/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.rocketmq.tools.command.broker;

import com.alibaba.rocketmq.common.protocol.body.KVTable;
import com.alibaba.rocketmq.remoting.RPCHook;
import com.alibaba.rocketmq.tools.admin.DefaultMQAdminExt;
import com.alibaba.rocketmq.tools.command.SubCommand;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;

public class BrokerStatusSubCommand
implements SubCommand {
    @Override
    public String commandName() {
        return "brokerStatus";
    }

    @Override
    public String commandDesc() {
        return "Fetch broker runtime status data";
    }

    @Override
    public Options buildCommandlineOptions(Options options) {
        Option opt = new Option("b", "brokerAddr", true, "Broker address");
        opt.setRequired(true);
        options.addOption(opt);
        return options;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(CommandLine commandLine, Options options, RPCHook rpcHook) {
        DefaultMQAdminExt defaultMQAdminExt = new DefaultMQAdminExt(rpcHook);
        defaultMQAdminExt.setInstanceName(Long.toString(System.currentTimeMillis()));
        try {
            defaultMQAdminExt.start();
            String brokerAddr = commandLine.getOptionValue('b').trim();
            KVTable kvTable = defaultMQAdminExt.fetchBrokerRuntimeStats(brokerAddr);
            TreeMap tmp = new TreeMap();
            tmp.putAll(kvTable.getTable());
            for (Map.Entry next : tmp.entrySet()) {
                System.out.printf("%-32s: %s\n", next.getKey(), next.getValue());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            defaultMQAdminExt.shutdown();
        }
    }
}

