/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.rocketmq.tools.command;

import com.alibaba.rocketmq.client.exception.MQBrokerException;
import com.alibaba.rocketmq.common.protocol.body.ClusterInfo;
import com.alibaba.rocketmq.common.protocol.route.BrokerData;
import com.alibaba.rocketmq.remoting.exception.RemotingConnectException;
import com.alibaba.rocketmq.remoting.exception.RemotingSendRequestException;
import com.alibaba.rocketmq.remoting.exception.RemotingTimeoutException;
import com.alibaba.rocketmq.tools.admin.MQAdminExt;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class CommandUtil {
    public static Set<String> fetchMasterAddrByClusterName(MQAdminExt adminExt, String clusterName) throws InterruptedException, RemotingConnectException, RemotingTimeoutException, RemotingSendRequestException, MQBrokerException {
        HashSet<String> masterSet = new HashSet<String>();
        ClusterInfo clusterInfoSerializeWrapper = adminExt.examineBrokerClusterInfo();
        Set brokerNameSet = (Set)clusterInfoSerializeWrapper.getClusterAddrTable().get(clusterName);
        if (brokerNameSet != null) {
            for (String brokerName : brokerNameSet) {
                String addr;
                BrokerData brokerData = (BrokerData)clusterInfoSerializeWrapper.getBrokerAddrTable().get(brokerName);
                if (brokerData == null || (addr = (String)brokerData.getBrokerAddrs().get(0L)) == null) continue;
                masterSet.add(addr);
            }
        } else {
            System.out.printf("[error] Make sure the specified clusterName exists or the nameserver which connected is correct.", new Object[0]);
        }
        return masterSet;
    }

    public static Set<String> fetchBrokerNameByClusterName(MQAdminExt adminExt, String clusterName) throws Exception {
        ClusterInfo clusterInfoSerializeWrapper = adminExt.examineBrokerClusterInfo();
        Set brokerNameSet = (Set)clusterInfoSerializeWrapper.getClusterAddrTable().get(clusterName);
        if (brokerNameSet.isEmpty()) {
            throw new Exception("Make sure the specified clusterName exists or the nameserver which connected is correct.");
        }
        return brokerNameSet;
    }

    public static String fetchBrokerNameByAddr(MQAdminExt adminExt, String addr) throws Exception {
        ClusterInfo clusterInfoSerializeWrapper = adminExt.examineBrokerClusterInfo();
        HashMap brokerAddrTable = clusterInfoSerializeWrapper.getBrokerAddrTable();
        for (Map.Entry entry : brokerAddrTable.entrySet()) {
            HashMap brokerAddrs = ((BrokerData)entry.getValue()).getBrokerAddrs();
            if (!brokerAddrs.containsValue(addr)) continue;
            return (String)entry.getKey();
        }
        throw new Exception("Make sure the specified broker addr exists or the nameserver which connected is correct.");
    }
}

