/*
 * Decompiled with CFR 0.152.
 */
package org.HdrHistogram;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Arrays;
import org.HdrHistogram.AbstractHistogram;

public class ShortHistogram
extends AbstractHistogram {
    long totalCount;
    final short[] counts;

    @Override
    long getCountAtIndex(int index) {
        return this.counts[index];
    }

    @Override
    void incrementCountAtIndex(int index) {
        int n = index;
        this.counts[n] = (short)(this.counts[n] + 1);
    }

    @Override
    void addToCountAtIndex(int index, long value) {
        int n = index;
        this.counts[n] = (short)((long)this.counts[n] + value);
    }

    @Override
    void clearCounts() {
        Arrays.fill(this.counts, (short)0);
        this.totalCount = 0L;
    }

    @Override
    public ShortHistogram copy() {
        ShortHistogram copy = new ShortHistogram(this.highestTrackableValue, this.numberOfSignificantValueDigits);
        copy.add(this);
        return copy;
    }

    @Override
    public ShortHistogram copyCorrectedForCoordinatedOmission(long expectedIntervalBetweenValueSamples) {
        ShortHistogram toHistogram = new ShortHistogram(this.highestTrackableValue, this.numberOfSignificantValueDigits);
        toHistogram.addWhileCorrectingForCoordinatedOmission(this, expectedIntervalBetweenValueSamples);
        return toHistogram;
    }

    @Override
    long getTotalCount() {
        return this.totalCount;
    }

    @Override
    void setTotalCount(long totalCount) {
        this.totalCount = totalCount;
    }

    @Override
    void incrementTotalCount() {
        ++this.totalCount;
    }

    @Override
    void addToTotalCount(long value) {
        this.totalCount += value;
    }

    @Override
    public int getEstimatedFootprintInBytes() {
        return 512 + 2 * this.counts.length;
    }

    public ShortHistogram(long highestTrackableValue, int numberOfSignificantValueDigits) {
        super(highestTrackableValue, numberOfSignificantValueDigits);
        this.counts = new short[this.countsArrayLength];
    }

    private void readObject(ObjectInputStream o) throws IOException, ClassNotFoundException {
        o.defaultReadObject();
    }
}

