/*
 * Decompiled with CFR 0.152.
 */
package org.HdrHistogram;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Arrays;
import org.HdrHistogram.AbstractHistogram;

public class IntHistogram
extends AbstractHistogram {
    long totalCount;
    final int[] counts;

    @Override
    long getCountAtIndex(int index) {
        return this.counts[index];
    }

    @Override
    void incrementCountAtIndex(int index) {
        int n = index;
        this.counts[n] = this.counts[n] + 1;
    }

    @Override
    void addToCountAtIndex(int index, long value) {
        int n = index;
        this.counts[n] = (int)((long)this.counts[n] + value);
    }

    @Override
    void clearCounts() {
        Arrays.fill(this.counts, 0);
        this.totalCount = 0L;
    }

    @Override
    public IntHistogram copy() {
        IntHistogram copy = new IntHistogram(this.highestTrackableValue, this.numberOfSignificantValueDigits);
        copy.add(this);
        return copy;
    }

    @Override
    public IntHistogram copyCorrectedForCoordinatedOmission(long expectedIntervalBetweenValueSamples) {
        IntHistogram toHistogram = new IntHistogram(this.highestTrackableValue, this.numberOfSignificantValueDigits);
        toHistogram.addWhileCorrectingForCoordinatedOmission(this, expectedIntervalBetweenValueSamples);
        return toHistogram;
    }

    @Override
    long getTotalCount() {
        return this.totalCount;
    }

    @Override
    void setTotalCount(long totalCount) {
        this.totalCount = totalCount;
    }

    @Override
    void incrementTotalCount() {
        ++this.totalCount;
    }

    @Override
    void addToTotalCount(long value) {
        this.totalCount += value;
    }

    @Override
    public int getEstimatedFootprintInBytes() {
        return 512 + 4 * this.counts.length;
    }

    public IntHistogram(long highestTrackableValue, int numberOfSignificantValueDigits) {
        super(highestTrackableValue, numberOfSignificantValueDigits);
        this.counts = new int[this.countsArrayLength];
    }

    private void readObject(ObjectInputStream o) throws IOException, ClassNotFoundException {
        o.defaultReadObject();
    }
}

