/*
 * Decompiled with CFR 0.152.
 */
package org.HdrHistogram;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.HdrHistogram.AbstractHistogramBase;
import org.HdrHistogram.HistogramData;
import org.HdrHistogram.HistogramIterationValue;

public abstract class AbstractHistogram
extends AbstractHistogramBase
implements Serializable {
    int subBucketHalfCountMagnitude;
    int subBucketHalfCount;
    long subBucketMask;
    private static final long serialVersionUID = 42L;

    abstract long getCountAtIndex(int var1);

    abstract void incrementCountAtIndex(int var1);

    abstract void addToCountAtIndex(int var1, long var2);

    abstract long getTotalCount();

    abstract void setTotalCount(long var1);

    abstract void incrementTotalCount();

    abstract void addToTotalCount(long var1);

    abstract void clearCounts();

    public abstract AbstractHistogram copy();

    public abstract AbstractHistogram copyCorrectedForCoordinatedOmission(long var1);

    public abstract int getEstimatedFootprintInBytes();

    public AbstractHistogram(long highestTrackableValue, int numberOfSignificantValueDigits) {
        if (highestTrackableValue < 2L) {
            throw new IllegalArgumentException("highestTrackableValue must be >= 2");
        }
        if (numberOfSignificantValueDigits < 0 || numberOfSignificantValueDigits > 5) {
            throw new IllegalArgumentException("numberOfSignificantValueDigits must be between 0 and 6");
        }
        this.identityCount = constructionIdentityCount.getAndIncrement();
        this.init(highestTrackableValue, numberOfSignificantValueDigits, 0L);
    }

    private void init(long highestTrackableValue, int numberOfSignificantValueDigits, long totalCount) {
        this.highestTrackableValue = highestTrackableValue;
        this.numberOfSignificantValueDigits = numberOfSignificantValueDigits;
        long largestValueWithSingleUnitResolution = 2L * (long)Math.pow(10.0, numberOfSignificantValueDigits);
        int subBucketCountMagnitude = (int)Math.ceil(Math.log(largestValueWithSingleUnitResolution) / Math.log(2.0));
        this.subBucketHalfCountMagnitude = (subBucketCountMagnitude > 1 ? subBucketCountMagnitude : 1) - 1;
        this.subBucketCount = (int)Math.pow(2.0, this.subBucketHalfCountMagnitude + 1);
        this.subBucketHalfCount = this.subBucketCount / 2;
        this.subBucketMask = this.subBucketCount - 1;
        long trackableValue = this.subBucketCount - 1;
        int bucketsNeeded = 1;
        while (trackableValue < highestTrackableValue) {
            trackableValue <<= 1;
            ++bucketsNeeded;
        }
        this.bucketCount = bucketsNeeded;
        this.countsArrayLength = (this.bucketCount + 1) * (this.subBucketCount / 2);
        this.setTotalCount(totalCount);
        this.histogramData = new HistogramData(this);
    }

    public int getNumberOfSignificantValueDigits() {
        return this.numberOfSignificantValueDigits;
    }

    public long getHighestTrackableValue() {
        return this.highestTrackableValue;
    }

    private int countsArrayIndex(int bucketIndex, int subBucketIndex) {
        assert (subBucketIndex < this.subBucketCount);
        assert (bucketIndex < this.bucketCount);
        assert (bucketIndex == 0 || subBucketIndex >= this.subBucketHalfCount);
        int bucketBaseIndex = bucketIndex + 1 << this.subBucketHalfCountMagnitude;
        int offsetInBucket = subBucketIndex - this.subBucketHalfCount;
        return bucketBaseIndex + offsetInBucket;
    }

    long getCountAt(int bucketIndex, int subBucketIndex) {
        return this.getCountAtIndex(this.countsArrayIndex(bucketIndex, subBucketIndex));
    }

    private static void arrayAdd(AbstractHistogram toHistogram, AbstractHistogram fromHistogram) {
        if (fromHistogram.countsArrayLength != toHistogram.countsArrayLength) {
            throw new IndexOutOfBoundsException();
        }
        for (int i = 0; i < fromHistogram.countsArrayLength; ++i) {
            toHistogram.addToCountAtIndex(i, fromHistogram.getCountAtIndex(i));
        }
    }

    int getBucketIndex(long value) {
        int pow2ceiling = 64 - Long.numberOfLeadingZeros(value | this.subBucketMask);
        return pow2ceiling - (this.subBucketHalfCountMagnitude + 1);
    }

    int getSubBucketIndex(long value, int bucketIndex) {
        return (int)(value >> bucketIndex);
    }

    private void recordCountAtValue(long count, long value) throws ArrayIndexOutOfBoundsException {
        int bucketIndex = this.getBucketIndex(value);
        int subBucketIndex = this.getSubBucketIndex(value, bucketIndex);
        int countsIndex = this.countsArrayIndex(bucketIndex, subBucketIndex);
        this.addToCountAtIndex(countsIndex, count);
        this.addToTotalCount(count);
    }

    private void recordSingleValue(long value) throws ArrayIndexOutOfBoundsException {
        int bucketIndex = this.getBucketIndex(value);
        int subBucketIndex = this.getSubBucketIndex(value, bucketIndex);
        int countsIndex = this.countsArrayIndex(bucketIndex, subBucketIndex);
        this.incrementCountAtIndex(countsIndex);
        this.incrementTotalCount();
    }

    private void recordValueWithCountAndExpectedInterval(long value, long count, long expectedIntervalBetweenValueSamples) throws ArrayIndexOutOfBoundsException {
        this.recordCountAtValue(count, value);
        if (expectedIntervalBetweenValueSamples <= 0L) {
            return;
        }
        for (long missingValue = value - expectedIntervalBetweenValueSamples; missingValue >= expectedIntervalBetweenValueSamples; missingValue -= expectedIntervalBetweenValueSamples) {
            this.recordCountAtValue(count, missingValue);
        }
    }

    public void recordValueWithExpectedInterval(long value, long expectedIntervalBetweenValueSamples) throws ArrayIndexOutOfBoundsException {
        this.recordValueWithCountAndExpectedInterval(value, 1L, expectedIntervalBetweenValueSamples);
    }

    public void recordValue(long value, long expectedIntervalBetweenValueSamples) throws ArrayIndexOutOfBoundsException {
        this.recordValueWithExpectedInterval(value, expectedIntervalBetweenValueSamples);
    }

    public void recordValueWithCount(long value, long count) throws ArrayIndexOutOfBoundsException {
        this.recordCountAtValue(count, value);
    }

    public void recordValue(long value) throws ArrayIndexOutOfBoundsException {
        this.recordSingleValue(value);
    }

    public void reset() {
        this.clearCounts();
    }

    public void add(AbstractHistogram other) {
        if (this.highestTrackableValue != other.highestTrackableValue || this.numberOfSignificantValueDigits != other.numberOfSignificantValueDigits || this.bucketCount != other.bucketCount || this.subBucketCount != other.subBucketCount) {
            throw new IllegalArgumentException("Cannot add histograms with incompatible ranges");
        }
        AbstractHistogram.arrayAdd(this, other);
        this.setTotalCount(this.getTotalCount() + other.getTotalCount());
    }

    void addWhileCorrectingForCoordinatedOmission(AbstractHistogram fromHistogram, long expectedIntervalBetweenValueSamples) {
        AbstractHistogram toHistogram = this;
        for (HistogramIterationValue v : fromHistogram.getHistogramData().recordedValues()) {
            toHistogram.recordValueWithCountAndExpectedInterval(v.getValueIteratedTo(), v.getCountAtValueIteratedTo(), expectedIntervalBetweenValueSamples);
        }
    }

    public boolean hasOverflowed() {
        long totalCounted = 0L;
        for (int i = 0; i < this.countsArrayLength; ++i) {
            totalCounted += this.getCountAtIndex(i);
        }
        return totalCounted != this.getTotalCount();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof AbstractHistogram)) {
            return false;
        }
        AbstractHistogram that = (AbstractHistogram)other;
        if (this.highestTrackableValue != that.highestTrackableValue || this.numberOfSignificantValueDigits != that.numberOfSignificantValueDigits) {
            return false;
        }
        if (this.countsArrayLength != that.countsArrayLength) {
            return false;
        }
        return this.getTotalCount() == that.getTotalCount();
    }

    public HistogramData getHistogramData() {
        return this.histogramData;
    }

    public long sizeOfEquivalentValueRange(long value) {
        int bucketIndex = this.getBucketIndex(value);
        int subBucketIndex = this.getSubBucketIndex(value, bucketIndex);
        long distanceToNextValue = 1 << (subBucketIndex >= this.subBucketCount ? bucketIndex + 1 : bucketIndex);
        return distanceToNextValue;
    }

    public long lowestEquivalentValue(long value) {
        int bucketIndex = this.getBucketIndex(value);
        int subBucketIndex = this.getSubBucketIndex(value, bucketIndex);
        long thisValueBaseLevel = subBucketIndex << bucketIndex;
        return thisValueBaseLevel;
    }

    public long highestEquivalentValue(long value) {
        return this.nextNonEquivalentValue(value) - 1L;
    }

    public long medianEquivalentValue(long value) {
        return this.lowestEquivalentValue(value) + (this.sizeOfEquivalentValueRange(value) >> 1);
    }

    public long nextNonEquivalentValue(long value) {
        return this.lowestEquivalentValue(value) + this.sizeOfEquivalentValueRange(value);
    }

    public boolean valuesAreEquivalent(long value1, long value2) {
        return this.lowestEquivalentValue(value1) == this.lowestEquivalentValue(value2);
    }

    private void writeObject(ObjectOutputStream o) throws IOException {
        o.writeLong(this.highestTrackableValue);
        o.writeInt(this.numberOfSignificantValueDigits);
        o.writeLong(this.getTotalCount());
    }

    private void readObject(ObjectInputStream o) throws IOException, ClassNotFoundException {
        long highestTrackableValue = o.readLong();
        int numberOfSignificantValueDigits = o.readInt();
        long totalCount = o.readLong();
        this.init(highestTrackableValue, numberOfSignificantValueDigits, totalCount);
    }
}

