/*
 * Decompiled with CFR 0.152.
 */
package co.paralleluniverse.strands.queues;

import co.paralleluniverse.common.monitoring.FlightRecorder;
import co.paralleluniverse.common.monitoring.FlightRecorderMessage;
import co.paralleluniverse.common.util.Debug;
import co.paralleluniverse.common.util.Objects;
import co.paralleluniverse.strands.queues.BasicSingleConsumerQueue;
import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Queue;

public abstract class SingleConsumerQueue<E, Node>
extends AbstractCollection<E>
implements Iterable<E>,
Queue<E>,
BasicSingleConsumerQueue<E> {
    static final FlightRecorder RECORDER = Debug.isDebug() ? Debug.getGlobalFlightRecorder() : null;

    @Override
    public abstract boolean enq(E var1);

    public abstract E value(Node var1);

    public abstract Node pk();

    public abstract Node succ(Node var1);

    public abstract void deq(Node var1);

    public abstract Node del(Node var1);

    public abstract boolean allowRetainPointers();

    @Override
    public abstract int size();

    public abstract List<E> snapshot();

    @Override
    public abstract int capacity();

    @Override
    public boolean hasNext() {
        return !this.isEmpty();
    }

    @Override
    public boolean isEmpty() {
        return this.pk() == null;
    }

    @Override
    public boolean add(E e) {
        this.enq(e);
        return true;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean offer(E e) {
        return this.enq(e);
    }

    @Override
    public E remove() {
        E val = this.poll();
        if (val == null) {
            throw new NoSuchElementException();
        }
        return val;
    }

    @Override
    public E poll() {
        Node n = this.pk();
        if (n == null) {
            return null;
        }
        E val = this.value(n);
        this.deq(n);
        return val;
    }

    @Override
    public E element() {
        E val = this.peek();
        if (val == null) {
            throw new NoSuchElementException();
        }
        return val;
    }

    @Override
    public E peek() {
        Node n = this.pk();
        if (n == null) {
            return null;
        }
        return this.value(n);
    }

    @Override
    public Iterator<E> iterator() {
        return new QueueIterator();
    }

    public void resetIterator(Iterator<E> iter2) {
        ((QueueIterator)iter2).n = null;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(Objects.systemToString(this));
        sb.append('[');
        Iterator<E> it = this.iterator();
        while (it.hasNext()) {
            sb.append(it.next()).append(", ");
        }
        if (sb.length() > 1) {
            sb.delete(sb.length() - 2, sb.length());
        }
        sb.append(']');
        return sb.toString();
    }

    boolean isRecording() {
        return RECORDER != null;
    }

    static void record(String method, String format) {
        if (RECORDER != null) {
            RECORDER.record(1, (Object)new FlightRecorderMessage("SingleConsumerQueue", method, format, null));
        }
    }

    static void record(String method, String format, Object arg1) {
        if (RECORDER != null) {
            RECORDER.record(1, (Object)new FlightRecorderMessage("SingleConsumerQueue", method, format, new Object[]{arg1}));
        }
    }

    static void record(String method, String format, Object arg1, Object arg2) {
        if (RECORDER != null) {
            RECORDER.record(1, (Object)new FlightRecorderMessage("SingleConsumerQueue", method, format, new Object[]{arg1, arg2}));
        }
    }

    static void record(String method, String format, Object arg1, Object arg2, Object arg3) {
        if (RECORDER != null) {
            RECORDER.record(1, (Object)new FlightRecorderMessage("SingleConsumerQueue", method, format, new Object[]{arg1, arg2, arg3}));
        }
    }

    static void record(String method, String format, Object arg1, Object arg2, Object arg3, Object arg4) {
        if (RECORDER != null) {
            RECORDER.record(1, (Object)new FlightRecorderMessage("SingleConsumerQueue", method, format, new Object[]{arg1, arg2, arg3, arg4}));
        }
    }

    static void record(String method, String format, Object arg1, Object arg2, Object arg3, Object arg4, Object arg5) {
        if (RECORDER != null) {
            RECORDER.record(1, (Object)new FlightRecorderMessage("SingleConsumerQueue", method, format, new Object[]{arg1, arg2, arg3, arg4, arg5}));
        }
    }

    private class QueueIterator
    implements Iterator<E> {
        private Node n;
        private boolean hasNextCalled;

        private QueueIterator() {
        }

        @Override
        public boolean hasNext() {
            Object next = SingleConsumerQueue.this.succ(this.n);
            this.hasNextCalled = true;
            if (next != null) {
                this.n = next;
                return true;
            }
            return false;
        }

        @Override
        public E next() {
            if (!this.hasNextCalled) {
                this.n = SingleConsumerQueue.this.succ(this.n);
            }
            this.hasNextCalled = false;
            return SingleConsumerQueue.this.value(this.n);
        }

        @Override
        public void remove() {
            this.n = SingleConsumerQueue.this.del(this.n);
        }
    }
}

