/*
 * Decompiled with CFR 0.152.
 */
package co.paralleluniverse.strands.queues;

import co.paralleluniverse.common.util.UtilUnsafe;
import co.paralleluniverse.strands.queues.SingleConsumerQueue;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import sun.misc.Unsafe;

abstract class SingleConsumerLinkedQueue<E>
extends SingleConsumerQueue<E, Node<E>> {
    private static final boolean DUMMY_NODE_ALGORITHM = false;
    volatile Node head;
    volatile Object p001;
    volatile Object p002;
    volatile Object p003;
    volatile Object p004;
    volatile Object p005;
    volatile Object p006;
    volatile Object p007;
    volatile Object p008;
    volatile Object p009;
    volatile Object p010;
    volatile Object p011;
    volatile Object p012;
    volatile Object p013;
    volatile Object p014;
    volatile Object p015;
    volatile Node tail;
    static final Unsafe UNSAFE = UtilUnsafe.getUnsafe();
    private static final long headOffset;
    private static final long tailOffset;
    private static final long nextOffset;
    private static final long prevOffset;

    @Override
    public boolean allowRetainPointers() {
        return true;
    }

    @Override
    public int capacity() {
        return -1;
    }

    abstract Node newNode();

    @Override
    boolean enq(Node<E> node) {
        Node t;
        do {
            node.prev = t = this.tail;
        } while (!this.compareAndSetTail(t, node));
        if (t == null) {
            this.head = node;
        } else {
            t.next = node;
        }
        return true;
    }

    @Override
    public void deq(Node<E> node) {
        this.clearValue(node);
        Node h = node.next;
        if (h == null) {
            this.orderedSetHead(null);
            if (this.tail == node && this.compareAndSetTail(node, null)) {
                node.next = null;
                return;
            }
            while ((h = node.next) == null) {
            }
        }
        this.orderedSetHead(h);
        SingleConsumerLinkedQueue.clearPrev(h);
        SingleConsumerLinkedQueue.clearPrev(node);
    }

    @Override
    public Node<E> pk() {
        Node h;
        if (this.tail == null) {
            return null;
        }
        while ((h = this.head) == null) {
        }
        return h;
    }

    boolean isHead(Node node) {
        return node.prev == null;
    }

    @Override
    public Node<E> succ(Node<E> node) {
        Node succ;
        if (node == null) {
            return this.pk();
        }
        if (this.tail == node) {
            return null;
        }
        while ((succ = node.next) == null) {
        }
        return succ;
    }

    @Override
    public Node<E> del(Node<E> node) {
        if (this.isHead(node)) {
            this.deq(node);
            return null;
        }
        this.clearValue(node);
        Node prev = node.prev;
        prev.next = null;
        Node t = this.tail;
        if (t != node || !this.compareAndSetTail(t, node.prev)) {
            prev.next = node.next;
            while (node.next == null) {
            }
            node.next.prev = prev;
        }
        SingleConsumerLinkedQueue.clearNext(node);
        SingleConsumerLinkedQueue.clearPrev(node);
        return prev;
    }

    @Override
    public int size() {
        int n = 0;
        Node p = this.tail;
        while (p != null) {
            ++n;
            p = p.prev;
        }
        return n;
    }

    @Override
    public List<E> snapshot() {
        ArrayList list = new ArrayList();
        Node p = this.tail;
        while (p != null) {
            list.add(this.value(p));
            p = p.prev;
        }
        return Lists.reverse(list);
    }

    boolean compareAndSetHead(Node update) {
        return UNSAFE.compareAndSwapObject(this, headOffset, null, update);
    }

    void orderedSetHead(Node value) {
        UNSAFE.putOrderedObject(this, headOffset, value);
    }

    void volatileSetHead(Node value) {
        UNSAFE.putObjectVolatile(this, headOffset, value);
    }

    boolean compareAndSetTail(Node expect, Node update) {
        return UNSAFE.compareAndSwapObject(this, tailOffset, expect, update);
    }

    static boolean compareAndSetNext(Node node, Node expect, Node update) {
        return UNSAFE.compareAndSwapObject(node, nextOffset, expect, update);
    }

    static void clearNext(Node node) {
        UNSAFE.putOrderedObject(node, nextOffset, null);
    }

    static void clearPrev(Node node) {
        UNSAFE.putOrderedObject(node, prevOffset, null);
    }

    abstract void clearValue(Node var1);

    static {
        try {
            headOffset = UNSAFE.objectFieldOffset(SingleConsumerLinkedQueue.class.getDeclaredField("head"));
            tailOffset = UNSAFE.objectFieldOffset(SingleConsumerLinkedQueue.class.getDeclaredField("tail"));
            nextOffset = UNSAFE.objectFieldOffset(Node.class.getDeclaredField("next"));
            prevOffset = UNSAFE.objectFieldOffset(Node.class.getDeclaredField("prev"));
        }
        catch (Exception ex) {
            throw new Error(ex);
        }
    }

    public static class Node<E> {
        volatile Node next;
        volatile Node prev;
    }
}

