/*
 * Decompiled with CFR 0.152.
 */
package co.paralleluniverse.strands.queues;

import co.paralleluniverse.common.util.Objects;
import co.paralleluniverse.strands.queues.SingleConsumerLinkedQueue;

public class SingleConsumerLinkedObjectQueue<E>
extends SingleConsumerLinkedQueue<E> {
    private static final long valueOffset;

    @Override
    SingleConsumerLinkedQueue.Node<E> newNode() {
        return new ObjectNode();
    }

    @Override
    public boolean enq(E item) {
        if (item == null) {
            throw new IllegalArgumentException("null values not allowed");
        }
        ObjectNode node = new ObjectNode();
        node.value = item;
        return this.enq((E)node);
    }

    @Override
    public E value(SingleConsumerLinkedQueue.Node<E> node) {
        return ((ObjectNode)node).value;
    }

    @Override
    void clearValue(SingleConsumerLinkedQueue.Node node) {
        UNSAFE.putOrderedObject(node, valueOffset, null);
    }

    static {
        try {
            valueOffset = UNSAFE.objectFieldOffset(ObjectNode.class.getDeclaredField("value"));
        }
        catch (Exception ex) {
            throw new Error(ex);
        }
    }

    static class ObjectNode<E>
    extends SingleConsumerLinkedQueue.Node<E> {
        E value;

        ObjectNode() {
        }

        public String toString() {
            return "Node{value: " + this.value + ", next: " + this.next + ", prev: " + Objects.systemToString(this.prev) + '}';
        }
    }
}

