/*
 * Decompiled with CFR 0.152.
 */
package co.paralleluniverse.strands.queues;

import co.paralleluniverse.common.util.UtilUnsafe;
import co.paralleluniverse.strands.queues.SingleConsumerQueue;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import sun.misc.Unsafe;

abstract class SingleConsumerLinkedArrayQueue<E>
extends SingleConsumerQueue<E, ElementPointer> {
    volatile Node head;
    int headIndex;
    volatile Object p001;
    volatile Object p002;
    volatile Object p003;
    volatile Object p004;
    volatile Object p005;
    volatile Object p006;
    volatile Object p007;
    volatile Object p008;
    volatile Object p009;
    volatile Object p010;
    volatile Object p011;
    volatile Object p012;
    volatile Object p013;
    volatile Object p014;
    volatile Object p015;
    volatile Node tail;
    volatile int p016;
    volatile int p017;
    volatile int p018;
    volatile int p019;
    volatile int p020;
    volatile int p021;
    volatile int p022;
    volatile int p023;
    volatile int p024;
    volatile int p025;
    volatile int p026;
    volatile int p027;
    volatile int p028;
    volatile int p029;
    volatile int p030;
    int seed = (int)System.nanoTime();
    static final Unsafe UNSAFE = UtilUnsafe.getUnsafe();
    private static final long headOffset;
    private static final long tailOffset;
    private static final long nextOffset;
    private static final long prevOffset;

    public SingleConsumerLinkedArrayQueue() {
        this.tail = this.head = this.newNode();
    }

    @Override
    public boolean allowRetainPointers() {
        return true;
    }

    @Override
    public int capacity() {
        return -1;
    }

    abstract Node newNode();

    abstract boolean hasValue(Node var1, int var2);

    abstract boolean isDeleted(Node var1, int var2);

    abstract void markDeleted(Node var1, int var2);

    abstract int blockSize();

    abstract E value(Node var1, int var2);

    @Override
    public void deq(ElementPointer ep) {
        int blockSize = this.blockSize();
        int i = this.headIndex;
        Node n = this.head;
        while (true) {
            int maxI;
            int n2 = maxI = n != ep.n ? blockSize - 1 : ep.i;
            while (i <= maxI) {
                this.markDeleted(n, i);
                ++i;
            }
            if (n == ep.n) break;
            Node next = n.next;
            SingleConsumerLinkedArrayQueue.clearNext(n);
            SingleConsumerLinkedArrayQueue.clearPrev(next);
            n = next;
            i = 0;
        }
        this.orderedSetHead(n);
        this.headIndex = ep.i + 1;
    }

    @Override
    public ElementPointer pk() {
        return this.current(new ElementPointer(this.head, this.headIndex));
    }

    @Override
    public ElementPointer succ(ElementPointer ep) {
        if (ep == null) {
            return this.pk();
        }
        ++ep.i;
        if (this.current(ep) == null) {
            --ep.i;
            return null;
        }
        return ep;
    }

    private ElementPointer current(ElementPointer ep) {
        block4: {
            int blockSize = this.blockSize();
            int i = ep.i;
            Node n = ep.n;
            while (true) {
                if (i >= blockSize) {
                    if (this.tail == n) {
                        return null;
                    }
                    while (n.next == null) {
                    }
                    n = n.next;
                    i = 0;
                    continue;
                }
                if (!this.hasValue(n, i)) break block4;
                if (!this.isDeleted(n, i)) break;
                ++i;
            }
            ep.i = i;
            ep.n = n;
            return ep;
        }
        return null;
    }

    boolean isHead(ElementPointer ep) {
        return ep.n == this.head & ep.i == this.headIndex;
    }

    @Override
    public final E value(ElementPointer ep) {
        return this.value(ep.n, ep.i);
    }

    @Override
    public ElementPointer del(ElementPointer ep) {
        if (this.isHead(ep)) {
            this.deq(ep);
            return null;
        }
        this.markDeleted(ep.n, ep.i);
        return ep;
    }

    @Override
    public int size() {
        int blockSize = this.blockSize();
        int count = 0;
        Node p = this.tail;
        while (p != null) {
            int i;
            int n = i = p == this.head ? this.headIndex : 0;
            while (i < blockSize && (p != this.tail || this.hasValue(p, i))) {
                if (!this.isDeleted(p, i)) {
                    ++count;
                }
                ++i;
            }
            p = p.prev;
        }
        return count;
    }

    @Override
    public List<E> snapshot() {
        int blockSize = this.blockSize();
        ArrayList<E> list = new ArrayList<E>();
        Node p = this.tail;
        while (p != null) {
            int i;
            int n = i = p == this.head ? this.headIndex : 0;
            while (i < blockSize && (p != this.tail || this.hasValue(p, i))) {
                if (this.hasValue(p, i) && !this.isDeleted(p, i)) {
                    list.add(this.value(p, i));
                }
                ++i;
            }
            p = p.prev;
        }
        return Lists.reverse(list);
    }

    public int nodeCount() {
        int count = 0;
        Node p = this.tail;
        while (p != null) {
            ++count;
            p = p.prev;
        }
        return count;
    }

    void backoff() {
        int spins = 256;
        int r = this.seed;
        while (spins >= 0) {
            r ^= r << 1;
            r ^= r >>> 3;
            if ((r ^= r << 10) < 0) continue;
            --spins;
        }
        this.seed = r;
    }

    boolean compareAndSetHead(Node update) {
        return UNSAFE.compareAndSwapObject(this, headOffset, null, update);
    }

    void orderedSetHead(Node value) {
        UNSAFE.putOrderedObject(this, headOffset, value);
    }

    boolean compareAndSetTail(Node expect, Node update) {
        return UNSAFE.compareAndSwapObject(this, tailOffset, expect, update);
    }

    static boolean compareAndSetNext(Node node, Node expect, Node update) {
        return UNSAFE.compareAndSwapObject(node, nextOffset, expect, update);
    }

    private static void clearNext(Node node) {
        UNSAFE.putOrderedObject(node, nextOffset, null);
    }

    private static void clearPrev(Node node) {
        UNSAFE.putOrderedObject(node, prevOffset, null);
    }

    static {
        try {
            headOffset = UNSAFE.objectFieldOffset(SingleConsumerLinkedArrayQueue.class.getDeclaredField("head"));
            tailOffset = UNSAFE.objectFieldOffset(SingleConsumerLinkedArrayQueue.class.getDeclaredField("tail"));
            nextOffset = UNSAFE.objectFieldOffset(Node.class.getDeclaredField("next"));
            prevOffset = UNSAFE.objectFieldOffset(Node.class.getDeclaredField("prev"));
        }
        catch (Exception ex) {
            throw new Error(ex);
        }
    }

    public static class ElementPointer {
        Node n;
        int i;

        public ElementPointer(Node n, int i) {
            this.n = n;
            this.i = i;
        }
    }

    static abstract class Node {
        volatile Node next;
        volatile Node prev;

        Node() {
        }
    }
}

