/*
 * Decompiled with CFR 0.152.
 */
package co.paralleluniverse.strands.queues;

import co.paralleluniverse.strands.queues.SingleConsumerLinkedArrayQueue;

public abstract class SingleConsumerLinkedArrayPrimitiveQueue<E>
extends SingleConsumerLinkedArrayQueue<E> {
    private static final long tailIndexOffset;
    private static final long maxReadIndexOffset;

    final SingleConsumerLinkedArrayQueue.ElementPointer preEnq() {
        int blockSize = this.blockSize();
        while (true) {
            PrimitiveNode t = (PrimitiveNode)this.tail;
            int i = t.tailIndex;
            if (i < blockSize) {
                if (this.compareAndSetTailIndex(t, i, i + 1)) {
                    return new SingleConsumerLinkedArrayQueue.ElementPointer(t, i);
                }
                this.backoff();
                continue;
            }
            SingleConsumerLinkedArrayQueue.Node n = this.newNode();
            n.prev = t;
            if (this.compareAndSetTail(t, n)) {
                t.next = n;
                continue;
            }
            this.backoff();
        }
    }

    final void postEnq(SingleConsumerLinkedArrayQueue.Node n1, int i) {
        PrimitiveNode n = (PrimitiveNode)n1;
        while (n.maxReadIndex != i) {
        }
        n.maxReadIndex = i + 1;
    }

    @Override
    boolean hasValue(SingleConsumerLinkedArrayQueue.Node n, int index) {
        return index < ((PrimitiveNode)n).maxReadIndex;
    }

    @Override
    boolean isDeleted(SingleConsumerLinkedArrayQueue.Node n, int index) {
        return SingleConsumerLinkedArrayPrimitiveQueue.getBit(((PrimitiveNode)n).deleted, index);
    }

    @Override
    void markDeleted(SingleConsumerLinkedArrayQueue.Node n1, int index) {
        assert (index <= this.blockSize());
        PrimitiveNode n = (PrimitiveNode)n1;
        n.deleted = SingleConsumerLinkedArrayPrimitiveQueue.setBit(n.deleted, index);
    }

    private static short setBit(short bits, int index) {
        return (short)(bits | 1 << index);
    }

    private static boolean getBit(short bits, int index) {
        return (bits >>> index & 1) != 0;
    }

    private boolean compareAndSetTailIndex(SingleConsumerLinkedArrayQueue.Node n, int expect, int update) {
        return UNSAFE.compareAndSwapInt((PrimitiveNode)n, tailIndexOffset, expect, update);
    }

    private boolean compareAndSetMaxReadIndex(SingleConsumerLinkedArrayQueue.Node n, int expect, int update) {
        return UNSAFE.compareAndSwapInt((PrimitiveNode)n, maxReadIndexOffset, expect, update);
    }

    static {
        try {
            tailIndexOffset = UNSAFE.objectFieldOffset(PrimitiveNode.class.getDeclaredField("tailIndex"));
            maxReadIndexOffset = UNSAFE.objectFieldOffset(PrimitiveNode.class.getDeclaredField("maxReadIndex"));
        }
        catch (Exception ex) {
            throw new Error(ex);
        }
    }

    static abstract class PrimitiveNode
    extends SingleConsumerLinkedArrayQueue.Node {
        volatile int tailIndex;
        volatile int maxReadIndex;
        short deleted;

        PrimitiveNode() {
        }
    }
}

