/*
 * Decompiled with CFR 0.152.
 */
package co.paralleluniverse.strands.queues;

import co.paralleluniverse.strands.queues.BasicSingleConsumerFloatQueue;
import co.paralleluniverse.strands.queues.SingleConsumerArrayWordQueue;
import co.paralleluniverse.strands.queues.SingleConsumerFloatQueue;

public class SingleConsumerArrayFloatQueue
extends SingleConsumerArrayWordQueue<Float>
implements SingleConsumerFloatQueue<Integer>,
BasicSingleConsumerFloatQueue {
    public SingleConsumerArrayFloatQueue(int capacity) {
        super(capacity);
    }

    @Override
    public boolean enq(float item) {
        return this.enqRaw(Float.floatToRawIntBits(item));
    }

    @Override
    public boolean enq(Float item) {
        if (item == null) {
            throw new IllegalArgumentException("null values not allowed");
        }
        return this.enq(item.floatValue());
    }

    @Override
    public float floatValue(int index) {
        return Float.intBitsToFloat(this.rawValue(index));
    }

    @Override
    public Float value(int index) {
        return Float.valueOf(this.floatValue(index));
    }

    @Override
    public float floatValue(Integer node) {
        return this.floatValue((int)node);
    }

    @Override
    public float pollFloat() {
        Integer n = this.pk();
        float val = this.floatValue(n);
        this.deq(n);
        return val;
    }
}

