/*
 * Decompiled with CFR 0.152.
 */
package co.paralleluniverse.strands;

import co.paralleluniverse.common.util.Exceptions;
import co.paralleluniverse.fibers.SuspendExecution;
import co.paralleluniverse.fibers.instrument.DontInstrument;
import co.paralleluniverse.strands.SuspendableCallable;
import co.paralleluniverse.strands.SuspendableRunnable;
import java.util.concurrent.Callable;

public class SuspendableUtils {
    public static SuspendableCallable<Void> runnableToCallable(SuspendableRunnable runnable) {
        return new VoidSuspendableCallable(runnable);
    }

    public static SuspendableRunnable asSuspendable(final Runnable runnable) {
        return new SuspendableRunnable(){

            @Override
            @DontInstrument
            public void run() throws SuspendExecution, InterruptedException {
                runnable.run();
            }
        };
    }

    public static <V> SuspendableCallable<V> asSuspendable(final Callable<V> callable) {
        return new SuspendableCallable<V>(){

            @Override
            public V run() throws SuspendExecution, InterruptedException {
                try {
                    return callable.call();
                }
                catch (Exception e) {
                    throw Exceptions.rethrow(e);
                }
            }
        };
    }

    public static class VoidSuspendableCallable
    implements SuspendableCallable<Void> {
        private final SuspendableRunnable runnable;

        public VoidSuspendableCallable(SuspendableRunnable runnable) {
            if (runnable == null) {
                throw new NullPointerException("Runnable is null");
            }
            this.runnable = runnable;
        }

        @Override
        @DontInstrument
        public Void run() throws SuspendExecution, InterruptedException {
            this.runnable.run();
            return null;
        }

        public SuspendableRunnable getRunnable() {
            return this.runnable;
        }
    }
}

