/*
 * Decompiled with CFR 0.152.
 */
package co.paralleluniverse.fibers.instrument;

import co.paralleluniverse.asm.Type;
import co.paralleluniverse.asm.tree.AbstractInsnNode;
import co.paralleluniverse.asm.tree.TypeInsnNode;
import co.paralleluniverse.asm.tree.analysis.AnalyzerException;
import co.paralleluniverse.asm.tree.analysis.BasicInterpreter;
import co.paralleluniverse.asm.tree.analysis.BasicValue;
import co.paralleluniverse.fibers.instrument.LogLevel;
import co.paralleluniverse.fibers.instrument.MethodDatabase;
import co.paralleluniverse.fibers.instrument.NewValue;

class TypeInterpreter
extends BasicInterpreter {
    private final MethodDatabase db;

    public TypeInterpreter(MethodDatabase db) {
        this.db = db;
    }

    @Override
    public BasicValue newValue(Type type) {
        if (type == null) {
            return BasicValue.UNINITIALIZED_VALUE;
        }
        if (type.getSort() == 10 || type.getSort() == 9) {
            return new BasicValue(type);
        }
        return super.newValue(type);
    }

    @Override
    public BasicValue newOperation(AbstractInsnNode insn) throws AnalyzerException {
        if (insn.getOpcode() == 187) {
            return new NewValue(Type.getObjectType(((TypeInsnNode)insn).desc), false, insn);
        }
        return super.newOperation(insn);
    }

    @Override
    public BasicValue copyOperation(AbstractInsnNode insn, BasicValue value) throws AnalyzerException {
        if (insn.getOpcode() == 89 && value instanceof NewValue) {
            NewValue newValue = (NewValue)value;
            if (!newValue.isDupped) {
                return new NewValue(newValue.getType(), true, insn);
            }
        }
        return super.copyOperation(insn, value);
    }

    @Override
    public BasicValue binaryOperation(AbstractInsnNode insn, BasicValue value1, BasicValue value2) throws AnalyzerException {
        if (insn.getOpcode() == 50) {
            Type t1 = value1.getType();
            if (t1 == null || t1.getSort() != 9) {
                throw new AnalyzerException(insn, "AALOAD needs an array as first parameter");
            }
            Type resultType = Type.getType(t1.getDescriptor().substring(1));
            return new BasicValue(resultType);
        }
        return super.binaryOperation(insn, value1, value2);
    }

    @Override
    public BasicValue merge(BasicValue v, BasicValue w) {
        if (!v.equals(w)) {
            if (v.isReference() && w.isReference()) {
                int dimensions = 0;
                Type typeV = v.getType();
                Type typeW = w.getType();
                if (typeV.getSort() != typeW.getSort()) {
                    this.db.log(LogLevel.DEBUG, "Array and none array type can't be merged: %s %s", v, w);
                    return BasicValue.UNINITIALIZED_VALUE;
                }
                if (typeW.getSort() == 9) {
                    dimensions = typeV.getDimensions();
                    if (dimensions != typeW.getDimensions()) {
                        this.db.log(LogLevel.DEBUG, "Arrays with different dimensions can't be merged: %s %s", v, w);
                        return BasicValue.UNINITIALIZED_VALUE;
                    }
                    typeV = typeV.getElementType();
                    typeW = typeW.getElementType();
                    if (typeV.getSort() != 10 || typeW.getSort() != 10) {
                        this.db.log(LogLevel.DEBUG, "Arrays of different primitive type can't be merged: %s %s", v, w);
                        return BasicValue.UNINITIALIZED_VALUE;
                    }
                }
                String internalV = typeV.getInternalName();
                String internalW = typeW.getInternalName();
                if ("null".equals(internalV)) {
                    return w;
                }
                if ("null".equals(internalW)) {
                    return v;
                }
                String superClass = this.db.getCommonSuperClass(internalV, internalW);
                if (superClass == null) {
                    if (this.db.isException(internalW)) {
                        this.db.log(LogLevel.WARNING, "Could not determine super class for v=%s w=%s - decided to use exception %s", v, w, w);
                        return w;
                    }
                    if (this.db.isException(internalV)) {
                        this.db.log(LogLevel.WARNING, "Could not determine super class for v=%s w=%s - decided to use exception %s", v, w, v);
                        return v;
                    }
                    this.db.log(LogLevel.WARNING, "Could not determine super class for v=%s w=%s - decided to use java/lang/Object", v, w);
                    superClass = "java/lang/Object";
                }
                String typeDescriptor = TypeInterpreter.makeTypeDescriptor(superClass, dimensions);
                this.db.log(LogLevel.INFO, "Common super class for v=%s w=%s is %s", v, w, typeDescriptor);
                return new BasicValue(Type.getType(typeDescriptor));
            }
            return BasicValue.UNINITIALIZED_VALUE;
        }
        return v;
    }

    private static String makeTypeDescriptor(String className, int dimensions) {
        int len = className.length();
        char[] tmp = new char[len + 2 + dimensions];
        for (int i = 0; i < dimensions; ++i) {
            tmp[i] = 91;
        }
        tmp[dimensions] = 76;
        className.getChars(0, len, tmp, dimensions + 1);
        tmp[dimensions + 1 + len] = 59;
        return new String(tmp);
    }
}

