/*
 * Decompiled with CFR 0.152.
 */
package co.paralleluniverse.fibers.instrument;

import co.paralleluniverse.asm.ClassReader;
import co.paralleluniverse.asm.ClassVisitor;
import co.paralleluniverse.asm.util.CheckClassAdapter;
import co.paralleluniverse.asm.util.TraceClassVisitor;
import co.paralleluniverse.common.util.Debug;
import co.paralleluniverse.fibers.instrument.DBClassWriter;
import co.paralleluniverse.fibers.instrument.DefaultSuspendableClassifier;
import co.paralleluniverse.fibers.instrument.InstrumentClass;
import co.paralleluniverse.fibers.instrument.Log;
import co.paralleluniverse.fibers.instrument.LogLevel;
import co.paralleluniverse.fibers.instrument.MethodDatabase;
import co.paralleluniverse.fibers.instrument.SuspendableClassifier;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;

public final class QuasarInstrumentor {
    public static final int ASMAPI = 327680;
    static final String EXAMINED_CLASS = null;
    private final MethodDatabase db;
    private boolean check;
    private final boolean aot;

    public QuasarInstrumentor(boolean aot, ClassLoader classLoader, SuspendableClassifier classifier) {
        this.db = new MethodDatabase(classLoader, classifier);
        this.aot = aot;
    }

    public QuasarInstrumentor(ClassLoader classLoader, SuspendableClassifier classifier) {
        this(false, classLoader, classifier);
    }

    public QuasarInstrumentor(boolean aot, ClassLoader classLoader) {
        this(aot, classLoader, new DefaultSuspendableClassifier(classLoader));
    }

    public QuasarInstrumentor(ClassLoader classLoader) {
        this(false, classLoader, new DefaultSuspendableClassifier(classLoader));
    }

    public boolean isAOT() {
        return this.aot;
    }

    public boolean shouldInstrument(String className) {
        if ((className = className.replace('.', '/')).startsWith("co/paralleluniverse/fibers/instrument/") && !Debug.isUnitTest()) {
            return false;
        }
        if (className.startsWith("co/paralleluniverse/asm/")) {
            return false;
        }
        if (className.startsWith("org/netbeans/lib/")) {
            return false;
        }
        if (className.equals("co/paralleluniverse/fibers/Fiber") || className.startsWith("co/paralleluniverse/fibers/Fiber$")) {
            return false;
        }
        if (className.equals("co/paralleluniverse/fibers/Stack")) {
            return false;
        }
        return !MethodDatabase.isJavaCore(className);
    }

    public byte[] instrumentClass(String className, byte[] data) {
        return this.shouldInstrument(className = className.replace('.', '/')) ? this.instrumentClass(className, new ClassReader(data), false) : data;
    }

    public byte[] instrumentClass(String className, InputStream is) throws IOException {
        className = className.replace('.', '/');
        return this.instrumentClass(className, new ClassReader(is), false);
    }

    byte[] instrumentClass(String className, InputStream is, boolean forceInstrumentation) throws IOException {
        className = className.replace('.', '/');
        return this.instrumentClass(className, new ClassReader(is), forceInstrumentation);
    }

    private byte[] instrumentClass(String className, ClassReader r, boolean forceInstrumentation) {
        ClassVisitor cv;
        this.log(LogLevel.INFO, "TRANSFORM: %s %s", className, this.db.getClassEntry(className) != null && this.db.getClassEntry(className).requiresInstrumentation() ? "request" : "");
        DBClassWriter cw = new DBClassWriter(this.db, r);
        ClassVisitor classVisitor = cv = this.check && EXAMINED_CLASS == null ? new CheckClassAdapter(cw) : cw;
        if (EXAMINED_CLASS != null && className.startsWith(EXAMINED_CLASS)) {
            cv = new TraceClassVisitor(cv, new PrintWriter(System.out));
        }
        InstrumentClass ic = new InstrumentClass(cv, this.db, forceInstrumentation);
        byte[] transformed = null;
        try {
            r.accept(ic, 4);
            transformed = cw.toByteArray();
        }
        catch (Exception e) {
            if (ic.hasSuspendableMethods()) {
                this.error("Unable to instrument class " + className, e);
                throw e;
            }
            if (!MethodDatabase.isProblematicClass(className)) {
                this.log(LogLevel.DEBUG, "Unable to instrument class " + className, new Object[0]);
            }
            return null;
        }
        if (EXAMINED_CLASS != null) {
            if (className.startsWith(EXAMINED_CLASS)) {
                try (FileOutputStream os = new FileOutputStream(className.replace('/', '.') + ".class");){
                    ((OutputStream)os).write(transformed);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            if (this.check) {
                ClassReader r2 = new ClassReader(transformed);
                CheckClassAdapter cv2 = new CheckClassAdapter(new TraceClassVisitor(null), true);
                r2.accept(cv2, 0);
            }
        }
        return transformed;
    }

    public MethodDatabase getMethodDatabase() {
        return this.db;
    }

    public QuasarInstrumentor setCheck(boolean check) {
        this.check = check;
        return this;
    }

    public QuasarInstrumentor setAllowMonitors(boolean allowMonitors) {
        this.db.setAllowMonitors(allowMonitors);
        return this;
    }

    public QuasarInstrumentor setAllowBlocking(boolean allowBlocking) {
        this.db.setAllowBlocking(allowBlocking);
        return this;
    }

    public QuasarInstrumentor setLog(Log log) {
        this.db.setLog(log);
        return this;
    }

    public QuasarInstrumentor setVerbose(boolean verbose) {
        this.db.setVerbose(verbose);
        return this;
    }

    public QuasarInstrumentor setDebug(boolean debug) {
        this.db.setDebug(debug);
        return this;
    }

    public void log(LogLevel level, String msg, Object ... args) {
        this.db.log(level, msg, args);
    }

    public void error(String msg, Exception ex) {
        this.db.error(msg, ex);
    }

    public ArrayList<MethodDatabase.WorkListEntry> getWorkList() {
        return this.db.getWorkList();
    }

    public void checkClass(File f) {
        this.db.checkClass(f);
    }
}

