/*
 * Decompiled with CFR 0.152.
 */
package co.paralleluniverse.fibers.instrument;

import co.paralleluniverse.asm.ClassReader;
import co.paralleluniverse.asm.ClassVisitor;
import co.paralleluniverse.fibers.instrument.CheckInstrumentationVisitor;
import co.paralleluniverse.fibers.instrument.Classes;
import co.paralleluniverse.fibers.instrument.JavaAgent;
import co.paralleluniverse.fibers.instrument.Log;
import co.paralleluniverse.fibers.instrument.LogLevel;
import co.paralleluniverse.fibers.instrument.SuspendableClassifier;
import co.paralleluniverse.fibers.instrument.UnableToInstrumentException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;

public class MethodDatabase
implements Log {
    private static final int ASMAPI = 327680;
    private final ClassLoader cl;
    private final SuspendableClassifier classifier;
    private final NavigableMap<String, ClassEntry> classes;
    private final HashMap<String, String> superClasses;
    private final ArrayList<WorkListEntry> workList;
    private Log log;
    private boolean verbose;
    private boolean debug;
    private boolean allowMonitors;
    private boolean allowBlocking;
    private int logLevelMask;
    private static final int UNKNOWN = 0;
    private static final int MAYBE_CORE = 1;
    private static final int NONSUSPENDABLE = 2;
    private static final int SUSPENDABLE_ABSTRACT = 3;
    private static final int SUSPENDABLE = 4;
    private static final ClassEntry CLASS_NOT_FOUND = new ClassEntry("<class not found>");

    public MethodDatabase(ClassLoader classloader, SuspendableClassifier classifier) {
        if (classloader == null) {
            throw new NullPointerException("classloader");
        }
        this.cl = classloader;
        this.classifier = classifier;
        this.classes = new TreeMap<String, ClassEntry>();
        this.superClasses = new HashMap();
        this.workList = new ArrayList();
        this.setLogLevelMask();
    }

    public boolean isAllowMonitors() {
        return this.allowMonitors;
    }

    public void setAllowMonitors(boolean allowMonitors) {
        this.allowMonitors = allowMonitors;
    }

    public boolean isAllowBlocking() {
        return this.allowBlocking;
    }

    public void setAllowBlocking(boolean allowBlocking) {
        this.allowBlocking = allowBlocking;
    }

    public SuspendableClassifier getClassifier() {
        return this.classifier;
    }

    public Log getLog() {
        return this.log;
    }

    public void setLog(Log log) {
        this.log = log;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
        this.setLogLevelMask();
    }

    public boolean isDebug() {
        return this.debug;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
        this.setLogLevelMask();
    }

    private void setLogLevelMask() {
        this.logLevelMask = 1 << LogLevel.WARNING.ordinal();
        if (this.verbose || this.debug) {
            this.logLevelMask |= 1 << LogLevel.INFO.ordinal();
        }
        if (this.debug) {
            this.logLevelMask |= 1 << LogLevel.DEBUG.ordinal();
        }
    }

    @Override
    public void log(LogLevel level, String msg, Object ... args) {
        if (this.log != null && (this.logLevelMask & 1 << level.ordinal()) != 0) {
            this.log.log(level, msg, args);
        }
    }

    @Override
    public void error(String msg, Exception ex) {
        if (this.log != null) {
            this.log.error(msg, ex);
        }
    }

    public void checkClass(File f) {
        try {
            FileInputStream fis = new FileInputStream(f);
            CheckInstrumentationVisitor civ = this.checkFileAndClose(fis, f.getPath());
            if (civ != null) {
                this.recordSuspendableMethods(civ.getName(), civ.getClassEntry());
                if (civ.needsInstrumentation()) {
                    if (civ.isAlreadyInstrumented()) {
                        this.log(LogLevel.INFO, "Found instrumented class: %s", f.getPath());
                        if (JavaAgent.isActive()) {
                            throw new AssertionError();
                        }
                    } else {
                        this.log(LogLevel.INFO, "Found class: %s", f.getPath());
                        if (!JavaAgent.isActive()) {
                            this.workList.add(new WorkListEntry(civ.getName(), f));
                        }
                    }
                }
            }
        }
        catch (UnableToInstrumentException ex) {
            throw ex;
        }
        catch (Exception ex) {
            this.error(f.getPath(), ex);
        }
    }

    public SuspendableType isMethodSuspendable(String className, String methodName, String methodDesc, int opcode) {
        if (className.startsWith("org/netbeans/lib/")) {
            return SuspendableType.NON_SUSPENDABLE;
        }
        int res = this.isMethodSuspendable0(className, methodName, methodDesc, opcode);
        switch (res) {
            case 0: {
                return null;
            }
            case 1: {
                if (!className.startsWith("java/")) {
                    this.log(LogLevel.INFO, "Method: %s#%s presumed non-suspendable: probably java core", className, methodName);
                }
            }
            case 2: {
                return SuspendableType.NON_SUSPENDABLE;
            }
            case 3: {
                return SuspendableType.SUSPENDABLE_SUPER;
            }
            case 4: {
                return SuspendableType.SUSPENDABLE;
            }
        }
        throw new AssertionError();
    }

    public ClassEntry getOrLoadClassEntry(String className) {
        ClassEntry entry = this.getClassEntry(className);
        if (entry == null) {
            entry = this.checkClass(className);
        }
        return entry;
    }

    private int isMethodSuspendable0(String className, String methodName, String methodDesc, int opcode) {
        if (methodName.charAt(0) == '<') {
            return 2;
        }
        if (Classes.isYieldMethod(className, methodName)) {
            return 4;
        }
        ClassEntry entry = this.getOrLoadClassEntry(className);
        if (entry == null) {
            if (MethodDatabase.isJavaCore(className)) {
                return 1;
            }
            return 0;
        }
        SuspendableType susp1 = entry.check(methodName, methodDesc);
        int suspendable = 0;
        if (susp1 == null) {
            suspendable = 0;
        } else if (susp1 == SuspendableType.SUSPENDABLE) {
            suspendable = 4;
        } else if (susp1 == SuspendableType.SUSPENDABLE_SUPER) {
            suspendable = 3;
        } else if (susp1 == SuspendableType.NON_SUSPENDABLE) {
            suspendable = 2;
        }
        if (suspendable == 0) {
            if ((opcode == 182 || opcode == 184 || opcode == 183) && entry.getSuperName() != null) {
                suspendable = this.isMethodSuspendable0(entry.getSuperName(), methodName, methodDesc, opcode);
            }
            if (opcode == 185 || opcode == 182) {
                for (String iface : entry.getInterfaces()) {
                    int s = this.isMethodSuspendable0(iface, methodName, methodDesc, opcode);
                    if (s > suspendable) {
                        suspendable = s;
                    }
                    if (suspendable > 1) break;
                }
            }
        }
        return suspendable;
    }

    public synchronized ClassEntry getClassEntry(String className) {
        return (ClassEntry)this.classes.get(className);
    }

    public synchronized ClassEntry getOrCreateClassEntry(String className, String superType) {
        ClassEntry ce = (ClassEntry)this.classes.get(className);
        if (ce == null) {
            ce = new ClassEntry(superType);
            this.classes.put(className, ce);
        }
        return ce;
    }

    public synchronized Map<String, ClassEntry> getInnerClassesEntries(String className) {
        NavigableMap<String, ClassEntry> tailMap = this.classes.tailMap(className, true);
        HashMap map = new HashMap();
        for (Map.Entry entry : tailMap.entrySet()) {
            if (!((String)entry.getKey()).equals(className) && !((String)entry.getKey()).startsWith(className + '$')) continue;
            map.put(entry.getKey(), entry.getValue());
        }
        return Collections.unmodifiableMap(map);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void recordSuspendableMethods(String className, ClassEntry entry) {
        ClassEntry oldEntry;
        MethodDatabase methodDatabase = this;
        synchronized (methodDatabase) {
            oldEntry = this.classes.put(className, entry);
        }
        if (oldEntry != null && oldEntry != entry && !oldEntry.equals(entry)) {
            this.log(LogLevel.WARNING, "Duplicate class entries with different data for class: %s", className);
        }
    }

    public String getCommonSuperClass(String classA, String classB) {
        String superClassB;
        String superClassA;
        int idx;
        ArrayList<String> listA = this.getSuperClasses(classA);
        ArrayList<String> listB = this.getSuperClasses(classB);
        if (listA == null || listB == null) {
            return null;
        }
        int num = Math.min(listA.size(), listB.size());
        for (idx = 0; idx < num && (superClassA = listA.get(idx)).equals(superClassB = listB.get(idx)); ++idx) {
        }
        if (idx > 0) {
            return listA.get(idx - 1);
        }
        return null;
    }

    public boolean isException(String className) {
        while (!"java/lang/Throwable".equals(className)) {
            if ("java/lang/Object".equals(className)) {
                return false;
            }
            String superClass = this.getDirectSuperClass(className);
            if (superClass == null) {
                this.log(MethodDatabase.isProblematicClass(className) ? LogLevel.INFO : LogLevel.WARNING, "Can't determine super class of %s", className);
                return false;
            }
            className = superClass;
        }
        return true;
    }

    public ArrayList<WorkListEntry> getWorkList() {
        return this.workList;
    }

    protected ClassEntry checkClass(String className) {
        if (this.cl == null) {
            this.log(LogLevel.INFO, "Can't check class: %s", className);
            return null;
        }
        this.log(LogLevel.INFO, "Reading class: %s", className);
        InputStream is = this.cl.getResourceAsStream(className + ".class");
        if (is == null) {
            this.log(LogLevel.INFO, "Class not found: %s", className);
            return null;
        }
        ClassEntry entry = this.getClassEntry(className);
        if (entry == null) {
            CheckInstrumentationVisitor civ = this.checkFileAndClose(is, className);
            if (civ != null) {
                entry = civ.getClassEntry();
                this.recordSuspendableMethods(className, entry);
            } else {
                this.log(LogLevel.INFO, "Class not found: %s", className);
            }
        } else {
            try {
                is.close();
            }
            catch (IOException e) {
                this.error(className, e);
            }
        }
        return entry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CheckInstrumentationVisitor checkFileAndClose(InputStream is, String name) {
        CheckInstrumentationVisitor checkInstrumentationVisitor;
        try {
            ClassReader r = new ClassReader(is);
            CheckInstrumentationVisitor civ = new CheckInstrumentationVisitor(this);
            r.accept(civ, 7);
            checkInstrumentationVisitor = civ;
        }
        catch (Throwable throwable) {
            try {
                is.close();
                throw throwable;
            }
            catch (UnableToInstrumentException ex) {
                throw ex;
            }
            catch (Exception ex) {
                this.error(name, ex);
                return null;
            }
        }
        is.close();
        return checkInstrumentationVisitor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String extractSuperClass(String className) {
        InputStream is = this.cl.getResourceAsStream(className + ".class");
        if (is != null) {
            String string;
            try {
                ClassReader r = new ClassReader(is);
                ExtractSuperClass esc = new ExtractSuperClass();
                r.accept(esc, 7);
                string = esc.superClass;
            }
            catch (Throwable throwable) {
                try {
                    is.close();
                    throw throwable;
                }
                catch (IOException ex) {
                    this.error(className, ex);
                }
            }
            is.close();
            return string;
        }
        return null;
    }

    private ArrayList<String> getSuperClasses(String className) {
        ArrayList<String> result = new ArrayList<String>();
        while (true) {
            result.add(0, className);
            if ("java/lang/Object".equals(className)) {
                return result;
            }
            String superClass = this.getDirectSuperClass(className);
            if (superClass == null) {
                this.log(MethodDatabase.isProblematicClass(className) ? LogLevel.INFO : LogLevel.WARNING, "Can't determine super class of %s", className);
                return null;
            }
            className = superClass;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getDirectSuperClass(String className) {
        String superClass;
        ClassEntry entry = this.getClassEntry(className);
        if (entry != null && entry != CLASS_NOT_FOUND) {
            return entry.getSuperName();
        }
        MethodDatabase methodDatabase = this;
        synchronized (methodDatabase) {
            superClass = this.superClasses.get(className);
        }
        if (superClass == null && (superClass = this.extractSuperClass(className)) != null) {
            String oldSuperClass;
            MethodDatabase methodDatabase2 = this;
            synchronized (methodDatabase2) {
                oldSuperClass = this.superClasses.put(className, superClass);
            }
            if (oldSuperClass != null && !oldSuperClass.equals(superClass)) {
                this.log(LogLevel.WARNING, "Duplicate super class entry with different value: %s vs %s", oldSuperClass, superClass);
            }
        }
        return superClass;
    }

    public static boolean isReflectInvocation(String className, String methodName) {
        return className.equals("java/lang/reflect/Method") && methodName.equals("invoke");
    }

    public static boolean isSyntheticAccess(String className, String methodName) {
        return methodName.startsWith("access$");
    }

    public static boolean isInvocationHandlerInvocation(String className, String methodName) {
        return className.equals("java/lang/reflect/InvocationHandler") && methodName.equals("invoke");
    }

    public static boolean isMethodHandleInvocation(String className, String methodName) {
        return className.equals("java/lang/invoke/MethodHandle") && methodName.startsWith("invoke");
    }

    public static boolean isJavaCore(String className) {
        return className.startsWith("java/") || className.startsWith("javax/") || className.startsWith("sun/") || className.startsWith("com/sun/") && !className.startsWith("com/sun/jersey");
    }

    public static boolean isProblematicClass(String className) {
        return className.startsWith("org/gradle/") || className.startsWith("javax/jms/") || className.startsWith("ch/qos/logback/") || className.startsWith("org/apache/logging/log4j/") || className.startsWith("org/apache/log4j/");
    }

    public static class WorkListEntry {
        public final String name;
        public final File file;

        public WorkListEntry(String name, File file) {
            this.name = name;
            this.file = file;
        }
    }

    public static class ExtractSuperClass
    extends ClassVisitor {
        String superClass;

        public ExtractSuperClass() {
            super(327680);
        }

        @Override
        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
            this.superClass = superName;
        }
    }

    public static final class ClassEntry {
        private final HashMap<String, SuspendableType> methods;
        private String[] interfaces;
        private final String superName;
        private boolean instrumented;
        private volatile boolean requiresInstrumentation;

        public ClassEntry(String superName) {
            this.superName = superName;
            this.methods = new HashMap();
        }

        public void set(String name, String desc, SuspendableType suspendable) {
            String nameAndDesc = ClassEntry.key(name, desc);
            this.methods.put(nameAndDesc, suspendable);
        }

        public String getSuperName() {
            return this.superName;
        }

        public void setAll(SuspendableType suspendable) {
            for (Map.Entry<String, SuspendableType> entry : this.methods.entrySet()) {
                entry.setValue(suspendable);
            }
        }

        public String[] getInterfaces() {
            return this.interfaces;
        }

        public void setInterfaces(String[] interfaces) {
            this.interfaces = interfaces;
        }

        public SuspendableType check(String name, String desc) {
            return this.methods.get(ClassEntry.key(name, desc));
        }

        public boolean isSuspendable(String name) {
            for (Map.Entry<String, SuspendableType> entry : this.methods.entrySet()) {
                String key = entry.getKey();
                if (!key.substring(0, key.indexOf(40)).equals(name) || entry.getValue() == SuspendableType.NON_SUSPENDABLE) continue;
                return true;
            }
            return false;
        }

        public boolean requiresInstrumentation() {
            return this.requiresInstrumentation;
        }

        public void setRequiresInstrumentation(boolean requiresInstrumentation) {
            this.requiresInstrumentation = requiresInstrumentation;
        }

        public int hashCode() {
            return this.superName.hashCode() * 67 + this.methods.hashCode();
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof ClassEntry)) {
                return false;
            }
            ClassEntry other = (ClassEntry)obj;
            return this.superName.equals(other.superName) && this.methods.equals(other.methods);
        }

        private static String key(String methodName, String methodDesc) {
            return methodName.concat(methodDesc);
        }

        public boolean isInstrumented() {
            return this.instrumented;
        }

        public void setInstrumented(boolean instrumented) {
            this.instrumented = instrumented;
        }
    }

    public static enum SuspendableType {
        NON_SUSPENDABLE,
        SUSPENDABLE_SUPER,
        SUSPENDABLE;

    }
}

