/*
 * Decompiled with CFR 0.152.
 */
package co.paralleluniverse.fibers.instrument;

import co.paralleluniverse.asm.AnnotationVisitor;
import co.paralleluniverse.asm.ClassVisitor;
import co.paralleluniverse.asm.MethodVisitor;
import co.paralleluniverse.asm.commons.JSRInlinerAdapter;
import co.paralleluniverse.asm.tree.AnnotationNode;
import co.paralleluniverse.asm.tree.MethodNode;
import co.paralleluniverse.asm.tree.analysis.AnalyzerException;
import co.paralleluniverse.fibers.instrument.Classes;
import co.paralleluniverse.fibers.instrument.InstrumentMethod;
import co.paralleluniverse.fibers.instrument.LogLevel;
import co.paralleluniverse.fibers.instrument.MethodDatabase;
import co.paralleluniverse.fibers.instrument.SuspendableClassifier;
import co.paralleluniverse.fibers.instrument.UnableToInstrumentException;
import java.util.ArrayList;
import java.util.List;

public class InstrumentClass
extends ClassVisitor {
    private final SuspendableClassifier classifier;
    private final MethodDatabase db;
    private boolean forceInstrumentation;
    private String className;
    private boolean isInterface;
    private boolean suspendableInterface;
    private MethodDatabase.ClassEntry classEntry;
    private boolean alreadyInstrumented;
    private ArrayList<MethodNode> methods;
    private RuntimeException exception;

    public InstrumentClass(ClassVisitor cv, MethodDatabase db, boolean forceInstrumentation) {
        super(327680, cv);
        this.db = db;
        this.classifier = db.getClassifier();
        this.forceInstrumentation = forceInstrumentation;
        this.suspendableInterface = false;
    }

    @Override
    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        this.className = name;
        this.isInterface = (access & 0x200) != 0;
        this.classEntry = this.db.getOrCreateClassEntry(this.className, superName);
        this.classEntry.setInterfaces(interfaces);
        this.forceInstrumentation |= this.classEntry.requiresInstrumentation();
        if (version < 49) {
            version = 49;
        }
        super.visit(version, access, name, signature, superName, interfaces);
    }

    public boolean hasSuspendableMethods() {
        return this.methods != null && !this.methods.isEmpty();
    }

    @Override
    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        if (desc.equals(Classes.ALREADY_INSTRUMENTED_DESC)) {
            this.alreadyInstrumented = true;
        } else if (this.isInterface && desc.equals("Lco/paralleluniverse/fibers/Suspendable;")) {
            this.suspendableInterface = true;
        }
        return super.visitAnnotation(desc, visible);
    }

    @Override
    public MethodVisitor visitMethod(final int access, final String name, final String desc, final String signature, final String[] exceptions) {
        MethodDatabase.SuspendableType setSuspendable;
        MethodDatabase.SuspendableType markedSuspendable = null;
        if (this.suspendableInterface) {
            markedSuspendable = MethodDatabase.SuspendableType.SUSPENDABLE_SUPER;
        }
        if (markedSuspendable == null) {
            markedSuspendable = this.classifier.isSuspendable(this.db, this.className, this.classEntry.getSuperName(), this.classEntry.getInterfaces(), name, desc, signature, exceptions);
        }
        if ((setSuspendable = this.classEntry.check(name, desc)) == null) {
            this.classEntry.set(name, desc, markedSuspendable != null ? markedSuspendable : MethodDatabase.SuspendableType.NON_SUSPENDABLE);
        }
        final MethodDatabase.SuspendableType suspendable = InstrumentClass.max(markedSuspendable, setSuspendable, MethodDatabase.SuspendableType.NON_SUSPENDABLE);
        if (InstrumentClass.checkAccess(access) && !Classes.isYieldMethod(this.className, name)) {
            if (this.methods == null) {
                this.methods = new ArrayList();
            }
            final MethodNode mn = new MethodNode(access, name, desc, signature, exceptions);
            return new MethodVisitor(327680, mn){
                private MethodDatabase.SuspendableType susp;
                private boolean commited;
                {
                    super(x0, x1);
                    this.susp = suspendable;
                    this.commited = false;
                }

                @Override
                public AnnotationVisitor visitAnnotation(String adesc, boolean visible) {
                    if (adesc.equals("Lco/paralleluniverse/fibers/Suspendable;")) {
                        this.susp = MethodDatabase.SuspendableType.SUSPENDABLE;
                    } else if (adesc.equals("Lco/paralleluniverse/fibers/instrument/DontInstrument;")) {
                        this.susp = MethodDatabase.SuspendableType.NON_SUSPENDABLE;
                    }
                    return super.visitAnnotation(adesc, visible);
                }

                @Override
                public void visitCode() {
                    this.commit();
                    super.visitCode();
                }

                @Override
                public void visitEnd() {
                    if (InstrumentClass.this.exception != null) {
                        return;
                    }
                    this.commit();
                    try {
                        super.visitEnd();
                    }
                    catch (RuntimeException e) {
                        InstrumentClass.this.exception = e;
                    }
                }

                private void commit() {
                    if (this.commited) {
                        return;
                    }
                    this.commited = true;
                    if (InstrumentClass.this.db.isDebug()) {
                        InstrumentClass.this.db.log(LogLevel.INFO, "Method %s#%s suspendable: %s (markedSuspendable: %s setSuspendable: %s)", new Object[]{InstrumentClass.this.className, name, this.susp, this.susp, setSuspendable});
                    }
                    InstrumentClass.this.classEntry.set(name, desc, this.susp);
                    if (this.susp != MethodDatabase.SuspendableType.NON_SUSPENDABLE) {
                        if (InstrumentClass.isSynchronized(access)) {
                            if (!InstrumentClass.this.db.isAllowMonitors()) {
                                throw new UnableToInstrumentException("synchronization", InstrumentClass.this.className, name, desc);
                            }
                            InstrumentClass.this.db.log(LogLevel.WARNING, "Method %s#%s%s is synchronized", InstrumentClass.this.className, name, desc);
                        }
                        InstrumentClass.this.methods.add(mn);
                    } else {
                        MethodVisitor _mv = InstrumentClass.this.makeOutMV(mn);
                        _mv = new JSRInlinerAdapter(_mv, access, name, desc, signature, exceptions);
                        mn.accept(new MethodVisitor(327680, _mv){

                            @Override
                            public void visitEnd() {
                            }
                        });
                        this.mv = _mv;
                    }
                }
            };
        }
        return super.visitMethod(access, name, desc, signature, exceptions);
    }

    @Override
    public void visitEnd() {
        MethodDatabase.ClassEntry superClass;
        if (this.exception != null) {
            throw this.exception;
        }
        this.classEntry.setRequiresInstrumentation(false);
        this.db.recordSuspendableMethods(this.className, this.classEntry);
        if (this.methods != null && !this.methods.isEmpty()) {
            if (this.alreadyInstrumented && !this.forceInstrumentation) {
                for (MethodNode mn : this.methods) {
                    mn.accept(this.makeOutMV(mn));
                }
            } else {
                if (!this.alreadyInstrumented) {
                    super.visitAnnotation(Classes.ALREADY_INSTRUMENTED_DESC, true);
                    this.classEntry.setInstrumented(true);
                }
                for (MethodNode mn : this.methods) {
                    MethodVisitor outMV = this.makeOutMV(mn);
                    try {
                        InstrumentMethod im = new InstrumentMethod(this.db, this.className, mn);
                        if (this.db.isDebug()) {
                            this.db.log(LogLevel.INFO, "About to instrument method %s#%s%s", this.className, mn.name, mn.desc);
                        }
                        if (im.collectCodeBlocks()) {
                            if (mn.name.charAt(0) == '<') {
                                throw new UnableToInstrumentException("special method", this.className, mn.name, mn.desc);
                            }
                            im.accept(outMV, this.hasAnnotation(mn));
                            continue;
                        }
                        this.db.log(LogLevel.INFO, "Nothing to instrument in method %s#%s%s", this.className, mn.name, mn.desc);
                        mn.accept(outMV);
                    }
                    catch (AnalyzerException ex) {
                        ex.printStackTrace();
                        throw new InternalError(ex.getMessage());
                    }
                }
            }
        } else if (!this.alreadyInstrumented && this.classEntry.getSuperName() != null && (superClass = this.db.getClassEntry(this.classEntry.getSuperName())) != null && superClass.isInstrumented()) {
            super.visitAnnotation(Classes.ALREADY_INSTRUMENTED_DESC, true);
            this.classEntry.setInstrumented(true);
        }
        super.visitEnd();
    }

    private boolean hasAnnotation(MethodNode mn) {
        List ans = mn.visibleAnnotations;
        if (ans == null) {
            return false;
        }
        for (AnnotationNode an : ans) {
            if (!an.desc.equals("Lco/paralleluniverse/fibers/Suspendable;")) continue;
            return true;
        }
        return false;
    }

    private MethodVisitor makeOutMV(MethodNode mn) {
        return super.visitMethod(mn.access, mn.name, mn.desc, mn.signature, InstrumentClass.toStringArray(mn.exceptions));
    }

    private static boolean isSynchronized(int access) {
        return (access & 0x20) != 0;
    }

    private static boolean checkAccess(int access) {
        return (access & 0x500) == 0;
    }

    private static MethodDatabase.SuspendableType max(MethodDatabase.SuspendableType a, MethodDatabase.SuspendableType b, MethodDatabase.SuspendableType def) {
        MethodDatabase.SuspendableType res = InstrumentClass.max(a, b);
        return res != null ? res : def;
    }

    private static MethodDatabase.SuspendableType max(MethodDatabase.SuspendableType a, MethodDatabase.SuspendableType b) {
        if (a == null) {
            return b;
        }
        if (b == null) {
            return a;
        }
        return b.compareTo(a) > 0 ? b : a;
    }

    private static String[] toStringArray(List<?> l) {
        if (l.isEmpty()) {
            return null;
        }
        return l.toArray(new String[l.size()]);
    }
}

