/*
 * Decompiled with CFR 0.152.
 */
package co.paralleluniverse.fibers.instrument;

import co.paralleluniverse.fibers.instrument.MethodDatabase;
import co.paralleluniverse.fibers.instrument.SimpleSuspendableClassifier;
import co.paralleluniverse.fibers.instrument.SuspendableClassifier;
import java.util.ServiceLoader;

public class DefaultSuspendableClassifier
implements SuspendableClassifier {
    private final ServiceLoader<SuspendableClassifier> loader;
    private final SuspendableClassifier simpleClassifier;

    public DefaultSuspendableClassifier(ClassLoader classLoader) {
        this.loader = ServiceLoader.load(SuspendableClassifier.class, classLoader);
        this.simpleClassifier = new SimpleSuspendableClassifier(classLoader);
    }

    @Override
    public MethodDatabase.SuspendableType isSuspendable(MethodDatabase db, String className, String superClassName, String[] interfaces, String methodName, String methodDesc, String methodSignature, String[] methodExceptions) {
        try {
            MethodDatabase.SuspendableType st;
            for (SuspendableClassifier sc : this.loader) {
                st = sc.isSuspendable(db, className, superClassName, interfaces, methodName, methodDesc, methodSignature, methodExceptions);
                if (st == null) continue;
                return st;
            }
            st = this.simpleClassifier.isSuspendable(db, className, superClassName, interfaces, methodName, methodDesc, methodSignature, methodExceptions);
            if (st != null) {
                return st;
            }
            if (DefaultSuspendableClassifier.checkExceptions(methodExceptions)) {
                return MethodDatabase.SuspendableType.SUSPENDABLE;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        return null;
    }

    private static boolean checkExceptions(String[] exceptions) {
        if (exceptions != null) {
            for (String ex : exceptions) {
                if (!ex.equals("co/paralleluniverse/fibers/SuspendExecution")) continue;
                return true;
            }
        }
        return false;
    }
}

