/*
 * Decompiled with CFR 0.152.
 */
package co.paralleluniverse.fibers;

import co.paralleluniverse.fibers.Fiber;
import co.paralleluniverse.fibers.SuspendExecution;
import java.io.Serializable;
import java.util.Arrays;

public final class Stack
implements Serializable {
    private static final int INITIAL_METHOD_STACK_DEPTH = 16;
    private static final long serialVersionUID = 12786283751253L;
    private final Fiber fiber;
    private int methodTOS;
    private int[] method;
    private long[] dataLong;
    private Object[] dataObject;
    private transient int curMethodSP;
    private transient boolean shouldVerifyInstrumentation;
    private transient boolean pushed;
    static final ThreadLocal<Stack> getStackTrace = new ThreadLocal();
    static final boolean foo = "hello".contains("kkk");

    Stack(Fiber fiber, int stackSize) {
        if (stackSize <= 0) {
            throw new IllegalArgumentException("stackSize");
        }
        this.fiber = fiber;
        this.method = new int[16];
        this.dataLong = new long[stackSize];
        this.dataObject = new Object[stackSize];
        this.resumeStack();
    }

    public static Stack getStack() {
        Fiber currentFiber = Fiber.currentFiber();
        if (currentFiber == null) {
            return Stack.getStackDuringStackTrace();
        }
        return currentFiber.stack;
    }

    private static Stack getStackDuringStackTrace() {
        if (foo) {
            System.out.println("6666: 1");
            System.out.println("6666: 2");
            System.out.println("6666: 3");
            System.out.println("6666: 4");
            System.out.println("6666: 5");
            System.out.println("6666: 6");
            System.out.println("6666: 7");
            System.out.println("6666: 8");
            System.out.println("6666: 9");
            System.out.println("6666: 10");
            System.out.println("6666: 1");
            System.out.println("6666: 2");
            System.out.println("6666: 3");
            System.out.println("6666: 4");
            System.out.println("6666: 5");
            System.out.println("6666: 6");
            System.out.println("6666: 7");
            System.out.println("6666: 8");
            System.out.println("6666: 9");
            System.out.println("6666: 10");
        }
        return getStackTrace.get();
    }

    Fiber getFiber() {
        return this.fiber;
    }

    final void resumeStack() {
        this.methodTOS = -1;
    }

    void resetStack() {
        Arrays.fill(this.method, 0);
        this.resumeStack();
    }

    public final int nextMethodEntry() {
        this.shouldVerifyInstrumentation = true;
        int idx = this.methodTOS;
        this.curMethodSP = this.method[++idx];
        this.methodTOS = ++idx;
        int entry = this.method[idx];
        if (this.fiber.isRecordingLevel(2)) {
            this.fiber.record(2, "Stack", "nextMethodEntry", "%s %s %s", (Object)Thread.currentThread().getStackTrace()[2], (Object)entry, (Object)this.curMethodSP);
        }
        return entry;
    }

    public final boolean isFirstInStackOrPushed() {
        boolean p = this.pushed;
        this.pushed = false;
        if (this.methodTOS == 1 | p) {
            return true;
        }
        this.methodTOS -= 2;
        this.curMethodSP = this.method[this.methodTOS - 1];
        return false;
    }

    public final void pushMethod(int entry, int numSlots) {
        this.shouldVerifyInstrumentation = false;
        this.pushed = true;
        int methodIdx = this.methodTOS;
        if (this.method.length - methodIdx < 2) {
            this.growMethodStack();
        }
        this.curMethodSP = this.method[methodIdx - 1];
        int dataTOS = this.curMethodSP + numSlots;
        this.method[methodIdx] = entry;
        this.method[methodIdx + 1] = dataTOS;
        if (dataTOS > this.dataObject.length) {
            this.growDataStack(dataTOS);
        }
        if (this.fiber.isRecordingLevel(2)) {
            this.fiber.record(2, "Stack", "pushMethod     ", "%s %s %s", (Object)Thread.currentThread().getStackTrace()[2], (Object)entry, (Object)this.curMethodSP);
        }
    }

    public final void popMethod() {
        int newSP;
        if (this.shouldVerifyInstrumentation) {
            Fiber.verifySuspend(this.fiber);
            this.shouldVerifyInstrumentation = false;
        }
        this.pushed = false;
        int idx = this.methodTOS;
        this.method[idx] = 0;
        int oldSP = this.curMethodSP;
        this.curMethodSP = newSP = this.method[idx - 1];
        this.methodTOS = idx - 2;
        for (int i = newSP; i < oldSP; ++i) {
            this.dataObject[i] = null;
        }
        if (this.fiber.isRecordingLevel(2)) {
            this.fiber.record(2, "Stack", "popMethod      ", "%s %s", (Object)Thread.currentThread().getStackTrace()[2], (Object)this.curMethodSP);
        }
    }

    public static void push(int value, Stack s, int idx) {
        s.dataLong[s.curMethodSP + idx] = value;
    }

    public static void push(float value, Stack s, int idx) {
        s.dataLong[s.curMethodSP + idx] = Float.floatToRawIntBits(value);
    }

    public static void push(long value, Stack s, int idx) {
        s.dataLong[s.curMethodSP + idx] = value;
    }

    public static void push(double value, Stack s, int idx) {
        s.dataLong[s.curMethodSP + idx] = Double.doubleToRawLongBits(value);
    }

    public static void push(Object value, Stack s, int idx) {
        s.dataObject[s.curMethodSP + idx] = value;
    }

    public final int getInt(int idx) {
        int value = (int)this.dataLong[this.curMethodSP + idx];
        return value;
    }

    public final float getFloat(int idx) {
        float value = Float.intBitsToFloat((int)this.dataLong[this.curMethodSP + idx]);
        return value;
    }

    public final long getLong(int idx) {
        long value = this.dataLong[this.curMethodSP + idx];
        return value;
    }

    public final double getDouble(int idx) {
        double value = Double.longBitsToDouble(this.dataLong[this.curMethodSP + idx]);
        return value;
    }

    public final Object getObject(int idx) {
        Object value = this.dataObject[this.curMethodSP + idx];
        return value;
    }

    public final void postRestore() throws SuspendExecution, InterruptedException {
        this.fiber.onResume();
    }

    public final void preemptionPoint(int type) throws SuspendExecution {
        this.fiber.preemptionPoint(type);
    }

    private void growDataStack(int required) {
        int newSize = this.dataObject.length;
        while ((newSize *= 2) < required) {
        }
        this.dataLong = Arrays.copyOf(this.dataLong, newSize);
        this.dataObject = Arrays.copyOf(this.dataObject, newSize);
    }

    private void growMethodStack() {
        int newSize = this.method.length << 1;
        this.method = Arrays.copyOf(this.method, newSize);
    }

    void dump() {
        int sp = 0;
        for (int i = 0; i <= this.methodTOS; i += 2) {
            System.out.println("i=" + i + " entry=" + this.method[i] + " sp=" + this.method[i + 1]);
            while (sp < this.method[i + 3]) {
                System.out.println("sp=" + sp + " long=" + this.dataLong[sp] + " obj=" + this.dataObject[sp]);
                ++sp;
            }
        }
    }
}

