/*
 * Decompiled with CFR 0.152.
 */
package co.paralleluniverse.common.monitoring;

import com.codahale.metrics.Reservoir;
import com.codahale.metrics.Snapshot;
import jsr166e.LongAdder;
import jsr166e.LongMaxUpdater;

public class SimpleReservoir
implements Reservoir {
    private final LongAdder num = new LongAdder();
    private final LongAdder sum = new LongAdder();
    private final LongMaxUpdater max = new LongMaxUpdater();
    private final LongMaxUpdater min = new LongMaxUpdater();

    public int size() {
        return 0;
    }

    public void update(long value) {
        this.num.increment();
        this.sum.add(value);
        this.max.update(value);
        this.min.update(-value);
    }

    public Snapshot getSnapshot() {
        return new Snapshot(new long[0]){
            private final long num;
            private final long sum;
            private final long max;
            private final long min;
            {
                this.num = SimpleReservoir.this.num.sumThenReset();
                this.sum = SimpleReservoir.this.sum.sumThenReset();
                this.max = SimpleReservoir.this.max.maxThenReset();
                this.min = SimpleReservoir.this.min.maxThenReset();
            }

            public int size() {
                return 0;
            }

            public long getMax() {
                return this.max;
            }

            public long getMin() {
                return -this.min;
            }

            public double getMean() {
                return (double)this.sum / (double)this.num;
            }
        };
    }
}

