/*
 * Decompiled with CFR 0.152.
 */
package co.paralleluniverse.common.benchmark;

import co.paralleluniverse.common.benchmark.Striped;
import org.HdrHistogram.AbstractHistogram;
import org.HdrHistogram.Histogram;
import org.HdrHistogram.HistogramData;

public class StripedHistogram {
    private final AbstractHistogram mainHistogram;
    private final Striped<AbstractHistogram> hs;
    private final long highestTrackableValue;
    private final int numberOfSignificantValueDigits;

    public StripedHistogram(long highestTrackableValue, int numberOfSignificantValueDigits) {
        this.highestTrackableValue = highestTrackableValue;
        this.numberOfSignificantValueDigits = numberOfSignificantValueDigits;
        this.mainHistogram = new Histogram(highestTrackableValue, numberOfSignificantValueDigits);
        this.hs = new Striped<AbstractHistogram>(){

            @Override
            protected AbstractHistogram newResource() {
                return new Histogram(StripedHistogram.this.highestTrackableValue, StripedHistogram.this.numberOfSignificantValueDigits);
            }
        };
    }

    public void combine() {
        this.mainHistogram.reset();
        for (AbstractHistogram h : this.hs) {
            this.mainHistogram.add(h);
        }
    }

    private AbstractHistogram get() {
        return this.hs.get();
    }

    public void recordValue(long value) throws ArrayIndexOutOfBoundsException {
        this.get().recordValue(value);
    }

    public void recordValueWithCount(long value, long count) throws ArrayIndexOutOfBoundsException {
        this.get().recordValueWithCount(value, count);
    }

    @Deprecated
    public void recordValue(long value, long expectedIntervalBetweenValueSamples) throws ArrayIndexOutOfBoundsException {
        this.get().recordValue(value, expectedIntervalBetweenValueSamples);
    }

    public void recordValueWithExpectedInterval(long value, long expectedIntervalBetweenValueSamples) throws ArrayIndexOutOfBoundsException {
        this.get().recordValueWithExpectedInterval(value, expectedIntervalBetweenValueSamples);
    }

    public void reset() {
        for (AbstractHistogram h : this.hs) {
            h.reset();
        }
        this.mainHistogram.reset();
    }

    public HistogramData getHistogramData() {
        this.combine();
        return this.mainHistogram.getHistogramData();
    }

    public HistogramData getHistogramDataCorrectedForCoordinatedOmission(long expectedIntervalBetweenValueSamples) {
        this.combine();
        return this.mainHistogram.copyCorrectedForCoordinatedOmission(expectedIntervalBetweenValueSamples).getHistogramData();
    }

    public boolean hasOverflowed() {
        for (AbstractHistogram h : this.hs) {
            if (!h.hasOverflowed()) continue;
            return true;
        }
        return false;
    }

    public int getNumberOfSignificantValueDigits() {
        return this.numberOfSignificantValueDigits;
    }

    public long getHighestTrackableValue() {
        return this.highestTrackableValue;
    }

    public long sizeOfEquivalentValueRange(long value) {
        return this.mainHistogram.sizeOfEquivalentValueRange(value);
    }

    public long lowestEquivalentValue(long value) {
        return this.mainHistogram.lowestEquivalentValue(value);
    }

    public long highestEquivalentValue(long value) {
        return this.mainHistogram.highestEquivalentValue(value);
    }

    public long medianEquivalentValue(long value) {
        return this.mainHistogram.medianEquivalentValue(value);
    }

    public long nextNonEquivalentValue(long value) {
        return this.mainHistogram.nextNonEquivalentValue(value);
    }

    public boolean valuesAreEquivalent(long value1, long value2) {
        return this.lowestEquivalentValue(value1) == this.lowestEquivalentValue(value2);
    }
}

