/*
 * Decompiled with CFR 0.152.
 */
package cn.jpush.api.push.model;

import cn.jiguang.common.utils.Preconditions;
import cn.jpush.api.push.model.PushModel;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.HashMap;
import java.util.Map;

public class SMS
implements PushModel {
    private final String content;
    private final int delay_time;
    private final long temp_id;
    private boolean active_filter;
    private boolean is_set_active_filter = false;
    private final Map<String, String> extras;
    private final Map<String, Number> numberExtras;
    private final Map<String, Boolean> booleanExtras;
    private final Map<String, JsonObject> jsonExtras;

    private SMS(String content, int delay_time, long temp_id, boolean active_filter, Map<String, String> extras, Map<String, Number> numberExtras, Map<String, Boolean> booleanExtras, Map<String, JsonObject> jsonExtras) {
        this.content = content;
        this.delay_time = delay_time;
        this.temp_id = temp_id;
        this.active_filter = active_filter;
        this.extras = extras;
        this.numberExtras = numberExtras;
        this.booleanExtras = booleanExtras;
        this.jsonExtras = jsonExtras;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    @Deprecated
    public static SMS content(String content, int delayTime) {
        return new Builder().setContent(content).setDelayTime(delayTime).build();
    }

    public static SMS content(long tempId, int delayTime) {
        return new Builder().setTempID(tempId).setDelayTime(delayTime).build();
    }

    @Override
    public JsonElement toJSON() {
        JsonObject json = new JsonObject();
        json.addProperty("delay_time", (Number)this.delay_time);
        if (this.temp_id > 0L) {
            json.addProperty("temp_id", (Number)this.temp_id);
        }
        if (null != this.content) {
            json.addProperty("content", this.content);
        }
        json.addProperty("active_filter", Boolean.valueOf(this.active_filter));
        JsonObject extrasObject = null;
        if (null != this.extras || null != this.numberExtras || null != this.booleanExtras || null != this.jsonExtras) {
            extrasObject = new JsonObject();
        }
        if (null != this.extras) {
            for (String key : this.extras.keySet()) {
                if (this.extras.get(key) != null) {
                    extrasObject.add(key, (JsonElement)new JsonPrimitive(this.extras.get(key)));
                    continue;
                }
                extrasObject.add(key, (JsonElement)JsonNull.INSTANCE);
            }
        }
        if (null != this.numberExtras) {
            for (String key : this.numberExtras.keySet()) {
                extrasObject.add(key, (JsonElement)new JsonPrimitive(this.numberExtras.get(key)));
            }
        }
        if (null != this.booleanExtras) {
            for (String key : this.booleanExtras.keySet()) {
                extrasObject.add(key, (JsonElement)new JsonPrimitive(this.booleanExtras.get(key)));
            }
        }
        if (null != this.jsonExtras) {
            for (String key : this.jsonExtras.keySet()) {
                extrasObject.add(key, (JsonElement)this.jsonExtras.get(key));
            }
        }
        if (null != this.extras || null != this.numberExtras || null != this.booleanExtras || null != this.jsonExtras) {
            json.add("temp_para", (JsonElement)extrasObject);
        }
        return json;
    }

    public static class Builder {
        private String content;
        private int delay_time;
        private long temp_id;
        private boolean active_filter;
        private boolean is_set_active_filter;
        private Map<String, String> extrasBuilder;
        private Map<String, Number> numberExtrasBuilder;
        private Map<String, Boolean> booleanExtrasBuilder;
        protected Map<String, JsonObject> jsonExtrasBuilder;

        public Builder setContent(String content) {
            this.content = content;
            return this;
        }

        public Builder setDelayTime(int delayTime) {
            this.delay_time = delayTime;
            return this;
        }

        public Builder setTempID(long tempID) {
            this.temp_id = tempID;
            return this;
        }

        public Builder setActiveFilter(boolean activeFilter) {
            this.active_filter = activeFilter;
            this.is_set_active_filter = true;
            return this;
        }

        public Builder addPara(String key, String value) {
            Preconditions.checkArgument((null != key && null != value ? 1 : 0) != 0, (Object)"Key/Value should not be null.");
            if (null == this.extrasBuilder) {
                this.extrasBuilder = new HashMap<String, String>();
            }
            this.extrasBuilder.put(key, value);
            return this;
        }

        public Builder addParas(Map<String, String> extras) {
            Preconditions.checkArgument((null != extras ? 1 : 0) != 0, (Object)"extras should not be null.");
            if (null == this.extrasBuilder) {
                this.extrasBuilder = new HashMap<String, String>();
            }
            for (String key : extras.keySet()) {
                this.extrasBuilder.put(key, extras.get(key));
            }
            return this;
        }

        public Builder addPara(String key, Number value) {
            Preconditions.checkArgument((null != key && null != value ? 1 : 0) != 0, (Object)"Key/Value should not be null.");
            if (null == this.numberExtrasBuilder) {
                this.numberExtrasBuilder = new HashMap<String, Number>();
            }
            this.numberExtrasBuilder.put(key, value);
            return this;
        }

        public Builder addPara(String key, Boolean value) {
            Preconditions.checkArgument((null != key && null != value ? 1 : 0) != 0, (Object)"Key/Value should not be null.");
            if (null == this.booleanExtrasBuilder) {
                this.booleanExtrasBuilder = new HashMap<String, Boolean>();
            }
            this.booleanExtrasBuilder.put(key, value);
            return this;
        }

        public Builder addPara(String key, JsonObject value) {
            Preconditions.checkArgument((null != key && null != value ? 1 : 0) != 0, (Object)"Key/Value should not be null.");
            if (null == this.jsonExtrasBuilder) {
                this.jsonExtrasBuilder = new HashMap<String, JsonObject>();
            }
            this.jsonExtrasBuilder.put(key, value);
            return this;
        }

        public SMS build() {
            Preconditions.checkArgument((this.delay_time >= 0 ? 1 : 0) != 0, (Object)"The delay time must be greater than or equal to 0");
            if (!this.is_set_active_filter) {
                this.active_filter = true;
            }
            return new SMS(this.content, this.delay_time, this.temp_id, this.active_filter, this.extrasBuilder, this.numberExtrasBuilder, this.booleanExtrasBuilder, this.jsonExtrasBuilder);
        }
    }
}

