/*
 * Decompiled with CFR 0.152.
 */
package kr.weitao.weitaokr.task.vip.vipremind;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.text.SimpleDateFormat;
import kr.weitao.business.entity.User;
import kr.weitao.common.exception.CommonException;
import kr.weitao.common.util.StringUtils;
import kr.weitao.common.util.TimeUtils;
import kr.weitao.starter.model.DataRequest;
import kr.weitao.starter.model.DataResponse;
import kr.weitao.starter.model.Status;
import kr.weitao.weitaokr.service.MemorandumService;
import kr.weitao.weitaokr.service.PushService;
import kr.weitao.weitaokr.task.common.AbstractJob;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bson.types.ObjectId;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Component;

@Component
public class VipRemindJob
extends AbstractJob {
    private static final Logger log = LogManager.getLogger(VipRemindJob.class);
    @Autowired
    MemorandumService memorandumService;
    @Autowired
    PushService pushService;
    @Autowired
    MongoTemplate mongoTemplate;

    protected void process(JobExecutionContext jec) throws CommonException {
        log.debug("doing......");
        JobDataMap jdm = jec.getJobDetail().getJobDataMap();
        log.info((Object)jdm);
        if (StringUtils.isNull((Object)jdm.get((Object)"_id"))) {
            return;
        }
        ObjectId _id = new ObjectId(StringUtils.valueOf((Object)jdm.get((Object)"_id")));
        JSONObject data = new JSONObject();
        data.put("id", (Object)_id);
        DataRequest drq = new DataRequest();
        drq.setData(data);
        DataResponse drs = this.memorandumService.query(drq);
        if (drs == null || !Status.SUCCESS.equals((Object)drs.getStatus())) {
            log.error("query data error");
            return;
        }
        log.info("data:" + drs.getData().toJSONString());
        JSONObject memorandum_data = drs.getData();
        if (memorandum_data == null || memorandum_data.isEmpty()) {
            log.error("data is null");
            return;
        }
        JSONArray memorandum_list = memorandum_data.getJSONArray("message");
        if (memorandum_list == null || memorandum_list.isEmpty() || memorandum_list.size() <= 0) {
            log.error("data list is null");
            return;
        }
        memorandum_data = memorandum_list.getJSONObject(0);
        data.clear();
        String user_id = memorandum_data.getString("user_id");
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"user_id").is((Object)user_id));
        User user = (User)this.mongoTemplate.findOne(query, User.class);
        if (null != user) {
            String content = memorandum_data.getString("content");
            String phone = user.getPhone();
            data.put("alias", (Object)phone);
            data.put("user_id", (Object)user_id);
            data.put("content", (Object)(StringUtils.isNull((Object)content) ? "\u60a8\u6709\u4e2a\u5907\u5fd8\u63d0\u9192\uff0c\u8bf7\u67e5\u770b\u3002" : content));
            data.put("title", (Object)"\u5907\u5fd8\u5f55\u63d0\u9192");
            data.put("sound", (Object)"memorandum.caf");
            JSONObject extra = new JSONObject();
            extra.put("remind_id", (Object)_id.toString());
            data.put("extra", (Object)extra);
            drq.setData(data);
            drs = this.pushService.notification(drq);
            drs = this.pushService.message(drq);
            if (drs == null) {
                log.error("push message error");
            } else {
                log.info("push message resutl:" + drs.getStatus());
            }
            data.put("notice_time", (Object)TimeUtils.getCurrentTimeInString((SimpleDateFormat)TimeUtils.DATETIME_FORMAT_DATE));
            this.mongoTemplate.insert((Object)data, "def_notice_log");
            try {
                Thread.sleep(10000L);
            }
            catch (Exception e) {
                log.error("sleep 10000 error:" + e.getLocalizedMessage(), (Throwable)e);
            }
        }
    }
}

