/*
 * Decompiled with CFR 0.152.
 */
package kr.weitao.weitaokr.task.ui;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import kr.weitao.common.exception.CommonException;
import kr.weitao.common.util.StringUtils;
import kr.weitao.starter.util.redis.RedisClient;
import kr.weitao.weitaokr.task.common.AbstractJob;
import org.quartz.JobExecutionContext;
import org.quartz.JobKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.stereotype.Component;

@Component
@RefreshScope
public class BirthdayOrderJob
extends AbstractJob {
    private static final Logger log = LoggerFactory.getLogger(BirthdayOrderJob.class);
    @Autowired
    MongoTemplate mongoTemplate;
    @Autowired
    RedisClient redisClient;

    protected void process(JobExecutionContext jec) throws CommonException {
        DBObject temp_order;
        JobKey jobKey = jec.getJobDetail().getKey();
        String queue_id = jobKey.getGroup();
        String queue_item_id = jobKey.getName();
        queue_id = queue_id.replace("queue_", "");
        queue_item_id = queue_id.trim();
        queue_item_id = queue_item_id.replace("queue_item_id", "");
        log.info("\u6d4b\u8bd5\u5b9a\u65f6\u4efb\u52a1 queue_id:" + queue_id + "  queue_item_id" + queue_item_id);
        if (StringUtils.isNotNull((Object)queue_id) && StringUtils.isNotNull((Object)queue_item_id) && StringUtils.isNotNull((Object)(temp_order = this.mongoTemplate.getCollection("def_order").findOne((DBObject)new BasicDBObject("queue_id", (Object)queue_id).append("pay_status", (Object)"0"))))) {
            JSONArray productList = JSONObject.parseObject((String)temp_order.toString()).getJSONArray("productList");
            for (int i = 0; i < productList.size(); ++i) {
                String occupied_stock;
                JSONObject temp_product = productList.getJSONObject(i);
                Integer product_num = temp_product.getInteger("product_num");
                String sku_id = temp_product.getString("sku_id");
                String product_id = temp_product.getString("product_id");
                String join_activity_type = temp_product.getString("join_activity_type");
                if ("SA".equals(join_activity_type) || StringUtils.isNull((Object)product_num) || StringUtils.isNull((Object)sku_id) || StringUtils.isNull((Object)product_id) || StringUtils.isNull((Object)(occupied_stock = this.redisClient.getValueOps().getValueString("STOCK" + product_id + sku_id)))) continue;
                Integer new_occupied_stock = Integer.parseInt(occupied_stock) - product_num;
                if (new_occupied_stock <= 0) {
                    this.redisClient.getValueOps().setValueString("STOCK" + product_id + sku_id, "0");
                }
                if (new_occupied_stock <= 0) continue;
                this.redisClient.getValueOps().setValueString("STOCK" + product_id + sku_id, String.valueOf(new_occupied_stock));
            }
            Query query = new Query((CriteriaDefinition)Criteria.where((String)"queue_id").is((Object)queue_id));
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"is_active").is((Object)"Y"));
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"is_success_used").is((Object)"N"));
            Update update = new Update();
            update.set("is_active", (Object)"N");
            this.mongoTemplate.updateFirst(query, update, "def_birthday_order");
            Update update_queue = new Update();
            update_queue.set("status", (Object)"0");
            Query query_queue = new Query((CriteriaDefinition)Criteria.where((String)"queue_id").is((Object)queue_id));
            this.mongoTemplate.updateFirst(query_queue, update_queue, "def_queue_item");
        }
    }
}

