/*
 * Decompiled with CFR 0.152.
 */
package kr.weitao.weitaokr.task.ui;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.mongodb.BasicDBObject;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import java.text.SimpleDateFormat;
import kr.weitao.business.common.feignclient.WeixinPayService;
import kr.weitao.business.entity.activity.Activity;
import kr.weitao.common.exception.CommonException;
import kr.weitao.common.util.TimeUtils;
import kr.weitao.starter.model.DataRequest;
import kr.weitao.starter.model.DataResponse;
import kr.weitao.weitaokr.service.PushService;
import kr.weitao.weitaokr.task.common.AbstractJob;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bson.types.ObjectId;
import org.quartz.JobExecutionContext;
import org.quartz.JobKey;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Component;

@RefreshScope
@Component
public class ActivityJob
extends AbstractJob {
    private static final Logger log = LogManager.getLogger(ActivityJob.class);
    @Autowired
    PushService pushService;
    @Autowired
    MongoTemplate mongoTemplate;
    @Autowired
    WeixinPayService weixinPayService;

    protected void process(JobExecutionContext jec) throws CommonException {
        DBObject object;
        BasicDBObject update;
        BasicDBObject query;
        log.debug("doing......");
        JobKey jobKey = jec.getJobDetail().getKey();
        String queue_id = jobKey.getGroup();
        String queue_item_id = jobKey.getName();
        queue_item_id = queue_item_id.replace("queue_item_", "");
        queue_id = queue_id.replace("queue_", "");
        log.info("\u6d4b\u8bd5\u5b9a\u65f6\u4efb\u52a1 queue_id:" + queue_id + "  queue_item_id:" + queue_item_id);
        if (queue_item_id.startsWith("startActivity")) {
            query = new BasicDBObject();
            query.put((Object)"_id", (Object)new ObjectId(queue_id));
            update = new BasicDBObject();
            update.put((Object)"activity_status", (Object)"1");
            this.mongoTemplate.getCollection("def_activity").update((DBObject)query, (DBObject)new BasicDBObject("$set", (Object)update));
        } else if (queue_item_id.startsWith("endActivity")) {
            query = new BasicDBObject();
            query.put((Object)"_id", (Object)new ObjectId(queue_id));
            update = new BasicDBObject();
            update.put((Object)"activity_status", (Object)"2");
            this.mongoTemplate.getCollection("def_activity").update((DBObject)query, (DBObject)new BasicDBObject("$set", (Object)update));
            BasicDBObject query_ajr = new BasicDBObject();
            query_ajr.put((Object)"activity_id", (Object)queue_id);
            query_ajr.put((Object)"status", (Object)"0");
            query_ajr.put((Object)"activity_type", (Object)new BasicDBObject("$ne", (Object)"presell"));
            DBCursor cursor = this.mongoTemplate.getCollection("def_activity_join_record").find((DBObject)query_ajr);
            while (cursor.hasNext()) {
                DBObject object2 = cursor.next();
                JSONArray buyers = JSONArray.parseArray((String)object2.get("buyers").toString());
                for (int i = 0; i < buyers.size(); ++i) {
                    JSONObject buyer = buyers.getJSONObject(i);
                    String order_id = buyer.getString("order_id");
                    try {
                        String out_refund_no = order_id + "--" + RandomStringUtils.randomAlphanumeric((int)5).toLowerCase();
                        JSONObject param = new JSONObject();
                        param.put("order_id", (Object)order_id);
                        param.put("out_refund_no", (Object)out_refund_no);
                        DataRequest request = new DataRequest();
                        request.setSign("");
                        request.setData(param);
                        DataResponse response = this.weixinPayService.getData("/weixinOrder/refund", request);
                        log.info("======\u6d3b\u52a8\u7ed3\u675f\u540e\u9000\u6b3e" + order_id + response.toJSONObject());
                        continue;
                    }
                    catch (Exception e) {
                        log.info("======\u6d3b\u52a8\u7ed3\u675f\u540e\u9000\u6b3e\u5f02\u5e38" + e.getLocalizedMessage());
                        e.printStackTrace();
                    }
                }
            }
            BasicDBObject update_ajr = new BasicDBObject();
            update_ajr.put((Object)"status", (Object)"-1");
            this.mongoTemplate.getCollection("def_activity_join_record").update((DBObject)query_ajr, (DBObject)new BasicDBObject("$set", (Object)update), false, true);
        } else if (queue_item_id.startsWith("endGroup")) {
            query = new BasicDBObject();
            query.put((Object)"_id", (Object)new ObjectId(queue_id));
            object = this.mongoTemplate.getCollection("def_activity_join_record").findOne((DBObject)query);
            if (object != null) {
                int people_limit = Integer.parseInt(object.get("people_limit").toString());
                JSONArray buyers = JSONArray.parseArray((String)object.get("buyers").toString());
                String status = object.get("status").toString();
                if (status.equals("0") && buyers.size() >= people_limit) {
                    BasicDBObject update2 = new BasicDBObject();
                    update2.put((Object)"status", (Object)"1");
                    this.mongoTemplate.getCollection("def_activity_join_record").update((DBObject)query, (DBObject)new BasicDBObject("$set", (Object)update2));
                } else if (status.equals("0") || status.equals("lock")) {
                    BasicDBObject update3 = new BasicDBObject();
                    update3.put((Object)"status", (Object)"-1");
                    this.mongoTemplate.getCollection("def_activity_join_record").update((DBObject)query, (DBObject)new BasicDBObject("$set", (Object)update3));
                    for (int i = 0; i < buyers.size(); ++i) {
                        JSONObject buyer = buyers.getJSONObject(i);
                        String order_id = buyer.getString("order_id");
                        try {
                            String out_refund_no = order_id + "--" + RandomStringUtils.randomAlphanumeric((int)5).toLowerCase();
                            JSONObject param = new JSONObject();
                            param.put("order_id", (Object)order_id);
                            param.put("out_refund_no", (Object)out_refund_no);
                            DataRequest request = new DataRequest();
                            request.setSign("");
                            request.setData(param);
                            DataResponse response = this.weixinPayService.getData("/weixinOrder/refund", request);
                            log.info("======\u62fc\u56e2\u8d85\u65f6\u540e\u9000\u6b3e" + order_id + response.toJSONObject());
                            continue;
                        }
                        catch (Exception e) {
                            log.info("======\u62fc\u56e2\u8d85\u65f6\u540e\u9000\u6b3e\u5f02\u5e38" + e.getLocalizedMessage());
                            e.printStackTrace();
                        }
                    }
                }
            }
        } else if (queue_item_id.startsWith("unlock")) {
            query = new BasicDBObject();
            query.put((Object)"_id", (Object)new ObjectId(queue_id));
            object = this.mongoTemplate.getCollection("def_activity_join_record").findOne((DBObject)query);
            if (object != null) {
                int people_limit = Integer.parseInt(object.get("people_limit").toString());
                JSONArray buyers = JSONArray.parseArray((String)object.get("buyers").toString());
                String status = object.get("status").toString();
                String created_date = object.get("created_date").toString();
                String activity_id = object.get("activity_id").toString();
                try {
                    Query query1 = new Query().addCriteria((CriteriaDefinition)Criteria.where((String)"_id").is((Object)new ObjectId(activity_id)));
                    Activity activity = (Activity)this.mongoTemplate.findOne(query1, Activity.class);
                    double effective_duration = Double.parseDouble(activity.getEffective_duration());
                    String time = TimeUtils.getHourAfter((double)effective_duration, (String)created_date, (SimpleDateFormat)TimeUtils.DATETIME_FORMAT_DATE);
                    if (status.equals("lock")) {
                        BasicDBObject update4 = new BasicDBObject();
                        if (people_limit == buyers.size()) {
                            update4.put((Object)"status", (Object)"1");
                        } else if (TimeUtils.getCurrentTimeInString().compareTo(time) > 0) {
                            update4.put((Object)"status", (Object)"-1");
                        } else {
                            update4.put((Object)"status", (Object)"0");
                        }
                        this.mongoTemplate.getCollection("def_activity_join_record").update((DBObject)query, (DBObject)new BasicDBObject("$set", (Object)update4));
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        } else if (queue_item_id.startsWith("restStartTime")) {
            BasicDBObject query_o = new BasicDBObject();
            query_o.put((Object)"activity_id", (Object)queue_id);
            query_o.put((Object)"front_pay_status", (Object)"1");
            DBCursor orders = this.mongoTemplate.getCollection("def_order").find((DBObject)query_o);
            while (orders.hasNext()) {
            }
        } else if (queue_item_id.startsWith("restEndTime")) {
            query = new BasicDBObject();
            query.put((Object)"activity_id", (Object)queue_id);
            query.put((Object)"status", (Object)"0");
            DBCursor records = this.mongoTemplate.getCollection("def_activity_join_record").find((DBObject)query);
            BasicDBObject update5 = new BasicDBObject();
            update5.put((Object)"status", (Object)"-1");
            this.mongoTemplate.getCollection("def_activity_join_record").update((DBObject)query, (DBObject)new BasicDBObject("$set", (Object)update5), false, true);
            Query query1 = new Query().addCriteria((CriteriaDefinition)Criteria.where((String)"_id").is((Object)new ObjectId(queue_id)));
            Activity activity = (Activity)this.mongoTemplate.findOne(query1, Activity.class);
            String is_front_refund = activity.getCan_front_refund();
            if (is_front_refund.equals("Y")) {
                while (records.hasNext()) {
                    DBObject record = records.next();
                    String order_id = JSONArray.parseArray((String)record.get("buyers").toString()).getJSONObject(0).getString("order_id");
                    try {
                        String out_refund_no = order_id + "--" + RandomStringUtils.randomAlphanumeric((int)5).toLowerCase();
                        JSONObject param = new JSONObject();
                        param.put("order_id", (Object)order_id);
                        param.put("out_refund_no", (Object)out_refund_no);
                        DataRequest request = new DataRequest();
                        request.setSign("");
                        request.setData(param);
                        DataResponse response = this.weixinPayService.getData("/weixinOrder/refund", request);
                        log.info("======\u5c3e\u6b3e\u672a\u4ed8\u9000\u5b9a\u91d1" + order_id + response.toJSONObject());
                    }
                    catch (Exception e) {
                        log.info("======\u5c3e\u6b3e\u672a\u4ed8\u9000\u5b9a\u91d1" + e.getLocalizedMessage());
                        e.printStackTrace();
                    }
                }
            } else {
                BasicDBObject query_o = new BasicDBObject();
                query_o.put((Object)"activity_id", (Object)queue_id);
                query_o.put((Object)"pay_status", (Object)"0");
                query_o.put((Object)"front_pay_status", (Object)"1");
                BasicDBObject update_item = new BasicDBObject("pay_status", (Object)"1");
                update_item.put((Object)"pay_info.pay_status", (Object)"1");
                BasicDBObject update_o = new BasicDBObject("$set", (Object)update_item);
                this.mongoTemplate.getCollection("def_order").update((DBObject)query_o, (DBObject)update_o);
            }
        }
        query = new BasicDBObject();
        query.put((Object)"queue_id", (Object)queue_id);
        query.put((Object)"queue_item_id", (Object)queue_item_id);
        update = new BasicDBObject();
        update.put((Object)"status", (Object)"0");
        this.mongoTemplate.getCollection("def_queue_item").update((DBObject)query, (DBObject)new BasicDBObject("$set", (Object)update));
    }
}

