/*
 * Decompiled with CFR 0.152.
 */
package kr.weitao.weitaokr.task.product;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.mongodb.BasicDBObject;
import com.mongodb.DBCollection;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kr.weitao.business.common.feignclient.ProductService;
import kr.weitao.business.common.feignclient.TeamService;
import kr.weitao.business.entity.data.Product;
import kr.weitao.common.exception.CommonException;
import kr.weitao.starter.model.DataRequest;
import kr.weitao.weitaokr.task.common.AbstractJob;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.quartz.JobExecutionContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Component;

@Component
public class ProductJob
extends AbstractJob {
    private static final Logger log = LogManager.getLogger(ProductJob.class);
    @Autowired
    MongoTemplate mongoTemplate;
    @Autowired
    ProductService productService;
    @Autowired
    TeamService teamService;

    protected void process(JobExecutionContext jec) throws CommonException {
        try {
            log.info("---\u6267\u884c\u5546\u54c1\u540c\u6b65-----");
        }
        catch (Exception exception) {
            // empty catch block
        }
        DBCollection collection = this.mongoTemplate.getCollection("def_product_synchronization");
        BasicDBObject basicDBObject = new BasicDBObject();
        basicDBObject.put((Object)"is_active", (Object)"Y");
        DBCursor dbObjects = collection.find((DBObject)basicDBObject);
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        calendar.add(2, -1);
        Date before = calendar.getTime();
        String before_time = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(before);
        DataRequest dataRequest = null;
        while (dbObjects.hasNext()) {
            DBObject object = dbObjects.next();
            Map map = object.toMap();
            String corp_code = map.get("corp_code").toString();
            String team_id = map.get("team_id").toString();
            String user_id = map.get("user_id").toString();
            String is_team_child = map.get("is_team_child").toString();
            Query query = new Query();
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"corp_code").is((Object)corp_code));
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"is_active").is((Object)"Y"));
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"created_date").gte((Object)before_time));
            List productList = this.mongoTemplate.find(query, Product.class);
            int total_results = productList.size();
            JSONArray array = new JSONArray();
            for (int k = 0; k < total_results / 1000 + 1; ++k) {
                List product = null;
                product = (k + 1) * 1000 <= total_results ? productList.subList(k * 1000, (k + 1) * 1000) : productList.subList(k * 1000, total_results);
                array = JSONArray.parseArray((String)JSON.toJSONString(product));
                JSONObject object2 = new JSONObject();
                object2.put("user_id", (Object)user_id);
                object2.put("product_ids", (Object)array);
                object2.put("team_id", (Object)team_id);
                object2.put("from_team_id", (Object)"");
                dataRequest = new DataRequest();
                dataRequest.setData(object2);
                this.productService.getData("/teamProduct/publishV2", dataRequest);
                try {
                    Thread.sleep(50L);
                    continue;
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            if (!"Y".equals(is_team_child)) continue;
            JSONObject object1 = new JSONObject();
            object1.put("user_id", (Object)user_id);
            object1.put("parent_team_id", (Object)team_id);
            object1.put("is_notice", (Object)"N");
            dataRequest = new DataRequest();
            dataRequest.setData(object1);
            this.teamService.getData("/teamProduct/batchPublishTeamProduct", dataRequest);
        }
    }
}

