/*
 * Decompiled with CFR 0.152.
 */
package kr.weitao.weitaokr.task.order.settlement;

import com.alibaba.fastjson.JSONObject;
import com.mongodb.BasicDBObject;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import kr.weitao.business.common.feignclient.OrderService;
import kr.weitao.common.exception.CommonException;
import kr.weitao.common.util.StringUtils;
import kr.weitao.common.util.TimeUtils;
import kr.weitao.starter.model.DataRequest;
import kr.weitao.weitaokr.task.common.AbstractJob;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.quartz.JobExecutionContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.stereotype.Component;

@Component
@RefreshScope
public class SettlementJob
extends AbstractJob {
    private static final Logger log = LogManager.getLogger(SettlementJob.class);
    @Autowired
    MongoTemplate mongoTemplate;
    @Autowired
    OrderService orderService;

    protected void process(JobExecutionContext jec) throws CommonException {
        String current_time = TimeUtils.getTime((long)(System.currentTimeMillis() - 600000L));
        BasicDBObject settlement_query = new BasicDBObject();
        settlement_query.put((Object)"status", (Object)"1");
        settlement_query.put((Object)"created_date", (Object)new BasicDBObject("$lte", (Object)current_time));
        BasicDBObject show_key = new BasicDBObject("_id", (Object)"1");
        log.info("begin settlement by:" + settlement_query);
        DBCursor db_cursor = null;
        try {
            db_cursor = this.mongoTemplate.getCollection("slm_settlement_bill").find((DBObject)settlement_query, (DBObject)show_key).limit(20);
            db_cursor.hasNext();
        }
        catch (Exception e) {
            log.error("get settlement bill by:" + settlement_query + " error:" + e.getLocalizedMessage(), (Throwable)e);
        }
        if (db_cursor == null) {
            log.error("not find seetlement by:" + settlement_query);
            return;
        }
        Object _id = null;
        DBObject db_object = null;
        DataRequest request = null;
        Object response = null;
        JSONObject param = null;
        String settlement_id = null;
        while (db_cursor.hasNext()) {
            db_object = db_cursor.next();
            _id = db_object.get("_id");
            if (_id == null) {
                log.error("_id is null");
                continue;
            }
            settlement_id = _id.toString();
            if (StringUtils.isNull((Object)settlement_id)) {
                log.error("id is null");
                continue;
            }
            param = new JSONObject();
            param.put("settlement_bill_id", (Object)settlement_id);
            request = new DataRequest();
            request.setData(param);
            log.info("settlementing by:" + param);
            try {
                this.orderService.getData("/settlement/orderSettlement", request);
                log.info("settlementing by:" + param + " result:" + (response == null ? "is null" : response.toJSONObject()));
            }
            catch (Exception e) {
                log.error(" error:" + e.getLocalizedMessage(), (Throwable)e);
            }
        }
        log.info("end settlement by:" + settlement_query);
    }
}

