/*
 * Decompiled with CFR 0.152.
 */
package kr.weitao.weitaokr.task.order.commission;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.mongodb.BasicDBObject;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import kr.weitao.business.common.feignclient.OrderService;
import kr.weitao.common.exception.CommonException;
import kr.weitao.common.util.StringUtils;
import kr.weitao.starter.model.DataRequest;
import kr.weitao.starter.model.DataResponse;
import kr.weitao.weitaokr.task.common.AbstractJob;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.quartz.JobExecutionContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.stereotype.Component;

@Component
@RefreshScope
public class OrderCommissionJob
extends AbstractJob {
    private static final Logger log = LogManager.getLogger(OrderCommissionJob.class);
    @Autowired
    MongoTemplate mongoTemplate;
    @Autowired
    OrderService orderService;

    protected void process(JobExecutionContext jec) throws CommonException {
        BasicDBObject order_query = new BasicDBObject("pay_status", (Object)"1");
        order_query.put((Object)"is_online_pay", (Object)"Y");
        BasicDBObject gt_query = new BasicDBObject("$gt", (Object)"2019-11-12 00:00:00");
        order_query.put((Object)"created_date", (Object)gt_query);
        order_query.put((Object)"productList.commission_status", (Object)new BasicDBObject("$ne", (Object)"1"));
        order_query.put((Object)"productList", (Object)new BasicDBObject("$elemMatch", (Object)new BasicDBObject("is_commission", (Object)new BasicDBObject("$ne", (Object)"Y"))));
        BasicDBObject show_key = new BasicDBObject();
        show_key.put((Object)"order_id", (Object)"1");
        log.info("begin order commission by:" + order_query);
        DBCursor db_cursor = null;
        try {
            db_cursor = this.mongoTemplate.getCollection("def_order").find((DBObject)order_query, (DBObject)show_key).limit(10000);
        }
        catch (Exception e) {
            log.error("get not commission oreder by:" + order_query + " error:" + e.getLocalizedMessage(), (Throwable)e);
            return;
        }
        if (db_cursor == null) {
            log.error("not find commission by" + order_query);
            return;
        }
        String order_id = null;
        DBObject db_object = null;
        JSONObject temp_order = null;
        JSONArray order_array = new JSONArray();
        while (db_cursor.hasNext()) {
            db_object = db_cursor.next();
            order_id = StringUtils.valueOf((Object)db_object.get("order_id"));
            if (!StringUtils.isNotNull((Object)order_id)) continue;
            temp_order = new JSONObject();
            temp_order.put("order_id", (Object)order_id);
            order_array.add((Object)temp_order);
        }
        DataRequest request = null;
        DataResponse response = null;
        int order_length = order_array.size();
        for (int i = 0; i < order_length; ++i) {
            temp_order = order_array.getJSONObject(i);
            request = new DataRequest();
            request.setData(temp_order);
            log.info("order commissioning by:" + temp_order);
            try {
                response = this.orderService.getData("/teamMemmberCommission/commissionCalculate", request);
                log.info("order commission by:" + temp_order + " result:" + (response == null ? "is null" : response.toJSONObject()));
                continue;
            }
            catch (Exception e) {
                log.error("order" + temp_order + " commission error:" + e.getLocalizedMessage(), (Throwable)e);
            }
        }
        log.info("end order commission by:" + order_query);
    }
}

