/*
 * Decompiled with CFR 0.152.
 */
package kr.weitao.weitaokr.task.material;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.mongodb.BasicDBObject;
import com.mongodb.DBCollection;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import java.text.SimpleDateFormat;
import java.util.List;
import java.util.Map;
import kr.weitao.business.common.feignclient.DataService;
import kr.weitao.business.entity.data.MaterialGroup;
import kr.weitao.business.entity.data.TeamMaterialGroup;
import kr.weitao.common.exception.CommonException;
import kr.weitao.common.util.StringUtils;
import kr.weitao.common.util.TimeUtils;
import kr.weitao.starter.model.DataRequest;
import kr.weitao.weitaokr.task.common.AbstractJob;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bson.types.ObjectId;
import org.quartz.JobExecutionContext;
import org.quartz.JobKey;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Component;

@Component
public class MaterialJob
extends AbstractJob {
    private static final Logger log = LogManager.getLogger(MaterialJob.class);
    @Autowired
    MongoTemplate mongoTemplate;
    @Autowired
    DataService dataService;

    protected void process(JobExecutionContext jec) throws CommonException {
        try {
            log.info("---\u6267\u884c\u7d20\u6750\u540c\u6b65-----" + jec.getFireTime());
        }
        catch (Exception exception) {
            // empty catch block
        }
        JobKey jobKey = jec.getJobDetail().getKey();
        String queue_id = jobKey.getGroup();
        String queue_item_id = jobKey.getName();
        queue_item_id = queue_item_id.replace("queue_item_", "");
        queue_id = queue_id.replace("queue_", "");
        if (queue_item_id.startsWith("newsSyn")) {
            DataRequest dataRequest = new DataRequest();
            dataRequest.setSign("");
            dataRequest.setAccess_key("");
            this.dataService.getData("/material/newsSyn", dataRequest);
        } else {
            DBCollection collection = this.mongoTemplate.getCollection("def_material_synchronization");
            DBCollection collection_material = this.mongoTemplate.getCollection("def_material");
            DBCollection collection_team_material_group = this.mongoTemplate.getCollection("def_team_material_group");
            BasicDBObject basicDBObject = new BasicDBObject();
            basicDBObject.put((Object)"is_active", (Object)"Y");
            DBCursor dbObjects = collection.find((DBObject)basicDBObject);
            String time = TimeUtils.getCurrentTimeInString((SimpleDateFormat)TimeUtils.DATETIME_FORMAT_DATE);
            while (dbObjects.hasNext()) {
                DBObject object = dbObjects.next();
                Map map = object.toMap();
                String corp_code = map.get("corp_code").toString();
                String team_id = map.get("team_id").toString();
                String user_id = map.get("user_id").toString();
                String is_team_child = map.get("is_team_child").toString();
                Query query = new Query();
                query.addCriteria((CriteriaDefinition)Criteria.where((String)"corp_code").is((Object)corp_code));
                query.addCriteria((CriteriaDefinition)Criteria.where((String)"is_active").is((Object)"Y"));
                List materialGroupsList = this.mongoTemplate.find(query, MaterialGroup.class);
                for (int i = 0; i < materialGroupsList.size(); ++i) {
                    int k = 0;
                    MaterialGroup materialGroup = (MaterialGroup)materialGroupsList.get(i);
                    String team_group_name = materialGroup.getMaterial_group_name();
                    String team_group_id = JSONObject.parseObject((String)materialGroup.toString()).getString("id");
                    int level = materialGroup.getLevel();
                    BasicDBObject basicDBObject1 = new BasicDBObject();
                    basicDBObject1.put((Object)"material_group_id.material_group_id", (Object)team_group_id);
                    basicDBObject1.put((Object)"is_active", (Object)"Y");
                    BasicDBObject project = new BasicDBObject();
                    project.put((Object)"material_id", (Object)1);
                    project.put((Object)"material_name", (Object)1);
                    project.put((Object)"user_id", (Object)1);
                    project.put((Object)"created_date", (Object)1);
                    project.put((Object)"material_type", (Object)1);
                    List dbObjectList = collection_material.find((DBObject)basicDBObject1, (DBObject)project).toArray();
                    JSONArray array = new JSONArray();
                    Query query1 = new Query();
                    query1.addCriteria((CriteriaDefinition)Criteria.where((String)"name").is((Object)team_group_name));
                    query1.addCriteria((CriteriaDefinition)Criteria.where((String)"team_id").is((Object)team_id));
                    TeamMaterialGroup teamMaterialGroup = (TeamMaterialGroup)this.mongoTemplate.findOne(query1, TeamMaterialGroup.class);
                    if (null == teamMaterialGroup) {
                        teamMaterialGroup = new TeamMaterialGroup();
                        teamMaterialGroup.setCreate_id(user_id);
                        teamMaterialGroup.setIs_active("Y");
                        teamMaterialGroup.setLevel(String.valueOf(level));
                        teamMaterialGroup.setModifier_id(user_id);
                        teamMaterialGroup.setCreate_time(time);
                        teamMaterialGroup.setMaterial_count(dbObjectList.size());
                        teamMaterialGroup.setMaterials(array);
                        teamMaterialGroup.setModified_time(time);
                        teamMaterialGroup.setName(team_group_name);
                        teamMaterialGroup.setTeam_id(team_id);
                        teamMaterialGroup.set_id((Object)new ObjectId());
                        this.mongoTemplate.save((Object)teamMaterialGroup);
                    }
                    for (int j = 0; j < dbObjectList.size(); ++j) {
                        String can_app_show;
                        String material_type;
                        DBObject dbObject = (DBObject)dbObjectList.get(j);
                        String def_material_id = dbObject.get("material_id").toString();
                        String created_time = dbObject.get("created_date").toString();
                        String def_user_id = dbObject.get("user_id").toString();
                        String material_name = dbObject.get("material_name").toString();
                        String string = material_type = StringUtils.isNotNull((Object)dbObject.get("material_type")) ? String.valueOf(dbObject.get("material_type")) : "";
                        if ("6".equals(material_type) && !"Y".equals(can_app_show = String.valueOf(dbObject.get("can_app_show")))) continue;
                        ++k;
                        JSONObject object1 = new JSONObject();
                        object1.put("created_time", (Object)created_time);
                        object1.put("from_team_id", (Object)"");
                        object1.put("def_material_id", (Object)def_material_id);
                        object1.put("def_user_id", (Object)def_user_id);
                        object1.put("material_name", (Object)material_name);
                        object1.put("material_type", (Object)material_type);
                        BasicDBObject object2 = new BasicDBObject();
                        object2.put((Object)"materials", (Object)object1);
                        BasicDBObject basicDBObject2 = new BasicDBObject();
                        basicDBObject2.put((Object)"$addToSet", (Object)object2);
                        BasicDBObject query_ = new BasicDBObject();
                        query_.put((Object)"team_id", (Object)team_id);
                        query_.put((Object)"name", (Object)team_group_name);
                        collection_team_material_group.update((DBObject)query_, (DBObject)basicDBObject2);
                    }
                    BasicDBObject query_ = new BasicDBObject();
                    query_.put((Object)"team_id", (Object)team_id);
                    query_.put((Object)"name", (Object)team_group_name);
                    BasicDBObject basicDBObject2 = new BasicDBObject();
                    basicDBObject2.put((Object)"$set", (Object)new BasicDBObject("material_count", (Object)k));
                    collection_team_material_group.update((DBObject)query_, (DBObject)basicDBObject2);
                }
                if (!"Y".equals(is_team_child)) continue;
                JSONObject object1 = new JSONObject();
                object1.put("user_id", (Object)user_id);
                object1.put("parent_team_id", (Object)team_id);
                DataRequest dataRequest = new DataRequest().setData(object1);
                this.dataService.getData("/teamMaterial/batchSetTeamMaterial", dataRequest);
            }
        }
        BasicDBObject query = new BasicDBObject();
        query.put((Object)"queue_id", (Object)queue_id);
        query.put((Object)"queue_item_id", (Object)queue_item_id);
        BasicDBObject update = new BasicDBObject();
        update.put((Object)"modified_date", (Object)TimeUtils.getCurrentTimeInString());
        this.mongoTemplate.getCollection("def_queue_item").update((DBObject)query, (DBObject)new BasicDBObject("$set", (Object)update));
    }
}

