/*
 * Decompiled with CFR 0.152.
 */
package kr.weitao.weitaokr.task.common.quzrtz;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.quartz.spi.TriggerFiredBundle;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.AutowireCapableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.scheduling.quartz.AdaptableJobFactory;
import org.springframework.stereotype.Component;

@Component
public class SpringBeanJobFactory
extends AdaptableJobFactory {
    private static final Logger log = LogManager.getLogger(SpringBeanJobFactory.class);
    @Autowired
    private AutowireCapableBeanFactory capableBeanFactory;
    @Autowired
    private ApplicationContext applicationContext;

    protected Object createJobInstance(TriggerFiredBundle bundle) throws Exception {
        Object jobInstance = super.createJobInstance(bundle);
        log.info("autowired job:" + jobInstance.getClass().getName());
        if (this.capableBeanFactory == null && this.applicationContext != null) {
            this.capableBeanFactory = this.applicationContext.getAutowireCapableBeanFactory();
        }
        if (this.capableBeanFactory != null) {
            this.capableBeanFactory.autowireBean(jobInstance);
        }
        return jobInstance;
    }
}

