/*
 * Decompiled with CFR 0.152.
 */
package kr.weitao.weitaokr.task.common;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.List;
import kr.weitao.common.exception.CommonException;
import kr.weitao.common.util.DateSwitchUtil;
import kr.weitao.common.util.StringUtils;
import kr.weitao.weitaokr.task.common.QueueItemEntity;
import kr.weitao.weitaokr.task.common.QueueParam;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.quartz.CronScheduleBuilder;
import org.quartz.JobBuilder;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.SimpleScheduleBuilder;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.TriggerKey;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component
public class ScheduleManger {
    private static final Logger log = LogManager.getLogger(ScheduleManger.class);
    @Autowired
    @Qualifier(value="Scheduler")
    private Scheduler scheduler;

    public void addJob(QueueItemEntity qie, List<QueueParam> param) throws Exception {
        String end_time_str;
        log.debug("qie:" + JSON.toJSONString((Object)qie));
        if (param != null) {
            log.debug("param:" + JSON.toJSONString(param));
        }
        Class<?> clzz = Class.forName(qie.getClass_name());
        try {
            clzz.newInstance();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        JobDetail job = JobBuilder.newJob(clzz).withIdentity("queue_item_" + qie.getQueue_item_id(), "queue_" + qie.getQueue_id()).build();
        log.info("job name:queue_item_" + qie.getQueue_item_id() + " job group:queue_" + qie.getQueue_id());
        JobDataMap jdm = job.getJobDataMap();
        jdm.put("total_count", qie.getTotal_count());
        if (param != null && !param.isEmpty()) {
            for (QueueParam qp : param) {
                jdm.put(qp.getName(), qp.getValue());
                if (StringUtils.isNull((Object)qp.getName())) {
                    log.error("key is null");
                    continue;
                }
                log.info("key:" + qp.getName() + " value:" + qp.getValue());
            }
        }
        Trigger trigger = null;
        TriggerBuilder tb = TriggerBuilder.newTrigger().withIdentity("trigger_queue_item_" + qie.getTrigger_id(), "trigger_queue_" + qie.getQueue_id());
        log.info("trigger name:trigger_queue_item_" + qie.getTrigger_id() + " trigger group:trigger_queue_" + qie.getQueue_id());
        JSONObject recurrence = qie.getRecurrence();
        if (recurrence == null || recurrence.isEmpty()) {
            log.error("cycle info can not be null");
            throw new CommonException("-1", "\u5468\u671f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        log.info("cycle info:" + recurrence);
        if ("1".equals(recurrence.getString("type"))) {
            String value;
            int count = recurrence.getIntValue("cycle");
            if (count == 0) {
                count = Integer.MAX_VALUE;
            }
            if (count > 0) {
                --count;
            }
            if (StringUtils.isNull((Object)(value = recurrence.getString("value")))) {
                log.error("cycle vaue can not be null");
                throw new CommonException("-1", "\u63d0\u9192\u5468\u671f\u503c\u4e0d\u80fd\u4e3a\u7a7a");
            }
            String[] value_array = value.split(",");
            if (value_array == null || value_array.length != 2) {
                log.error("cycle value error");
                throw new CommonException("-1", "\u63d0\u9192\u5468\u671f\u503c\u9519\u8bef");
            }
            String cycle_type = value_array[0];
            if (StringUtils.isNull((Object)cycle_type)) {
                log.error("cycle value key error");
                throw new CommonException("-1", "\u63d0\u9192\u5468\u671f\u503c\u9519\u8bef");
            }
            if (StringUtils.isDigital((String)value_array[1])) {
                log.error("cycle value value error");
                throw new CommonException("-1", "\u63d0\u9192\u5468\u671f\u503c\u9519\u8bef");
            }
            int cycle_value = Integer.parseInt(value_array[1]);
            if ("seconds".equalsIgnoreCase(cycle_type)) {
                tb = tb.withSchedule((ScheduleBuilder)SimpleScheduleBuilder.simpleSchedule().withIntervalInSeconds(cycle_value).withRepeatCount(count));
            } else if ("minutes".equalsIgnoreCase(cycle_type)) {
                tb = tb.withSchedule((ScheduleBuilder)SimpleScheduleBuilder.simpleSchedule().withIntervalInMinutes(cycle_value).withRepeatCount(count));
            } else if ("hours".equalsIgnoreCase(cycle_type)) {
                tb = tb.withSchedule((ScheduleBuilder)SimpleScheduleBuilder.simpleSchedule().withIntervalInHours(cycle_value).withRepeatCount(count));
            }
        } else {
            String cron = recurrence.getString("cron");
            if (StringUtils.isNull((Object)cron)) {
                log.error("cron error");
                throw new CommonException("-1", "\u63d0\u9192\u5468\u671f\u503c\u9519\u8bef");
            }
            tb = tb.withSchedule((ScheduleBuilder)CronScheduleBuilder.cronSchedule((String)cron));
        }
        String start_time_str = recurrence.getString("start_time");
        if (StringUtils.isNotNull((Object)start_time_str)) {
            try {
                tb.startAt(DateSwitchUtil.parseDate((String)start_time_str));
            }
            catch (Exception e) {
                log.error("parse start date error:" + e.getLocalizedMessage(), (Throwable)e);
            }
        }
        if (StringUtils.isNotNull((Object)(end_time_str = recurrence.getString("end_time")))) {
            try {
                tb.endAt(DateSwitchUtil.parseDate((String)end_time_str));
            }
            catch (Exception e) {
                log.error("parse end date error:" + e.getLocalizedMessage(), (Throwable)e);
            }
        }
        trigger = tb.build();
        log.info(this.scheduler.getSchedulerInstanceId() + "----trigger----" + trigger.getKey());
        this.scheduler.scheduleJob(job, trigger);
        if (!this.scheduler.isShutdown()) {
            log.info("scheduler start......");
            this.scheduler.start();
        }
    }

    public void modifyJob(QueueItemEntity qie, List<QueueParam> paramList) throws Exception {
        JobKey key = new JobKey("queue_item_" + qie.getQueue_item_id(), "queue_" + qie.getQueue_id());
        this.scheduler.deleteJob(key);
        try {
            this.addJob(qie, paramList);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
    }

    public void removeJob(QueueItemEntity qie) throws Exception {
        log.info((Object)qie);
        TriggerKey triggerKey = TriggerKey.triggerKey((String)("trigger_queue_item_" + qie.getTrigger_id()), (String)("trigger_queue_" + qie.getQueue_id()));
        this.scheduler.pauseTrigger(triggerKey);
        this.scheduler.unscheduleJob(triggerKey);
        boolean flag = this.scheduler.deleteJob(JobKey.jobKey((String)("queue_item_" + qie.getQueue_item_id()), (String)("queue_" + qie.getQueue_id())));
        log.info("--flag-\u5220\u9664\u4efb\u52a1-" + flag);
    }

    public void removeAll() {
    }

    public void pauseJob(QueueItemEntity qie) throws Exception {
        JobKey jobKey = JobKey.jobKey((String)("queue_item_" + qie.getQueue_item_id()), (String)("queue_" + qie.getQueue_id()));
        this.scheduler.pauseJob(jobKey);
    }

    public void pauseAll() throws Exception {
        this.scheduler.resumeAll();
    }

    public void rePauseJob(QueueItemEntity qie) throws Exception {
        JobKey jobKey = JobKey.jobKey((String)("queue_item_" + qie.getQueue_item_id()), (String)("queue_" + qie.getQueue_id()));
        this.scheduler.resumeJob(jobKey);
    }

    public void rePauseAll() throws SchedulerException {
        this.scheduler.resumeAll();
    }

    public void runOneJob(QueueItemEntity qie) throws SchedulerException {
        JobKey jobKey = JobKey.jobKey((String)("queue_item_" + qie.getQueue_item_id()), (String)("queue_" + qie.getQueue_id()));
        this.scheduler.triggerJob(jobKey);
    }
}

