/*
 * Decompiled with CFR 0.152.
 */
package kr.weitao.weitaokr.task.common;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.mongodb.BasicDBList;
import com.mongodb.BasicDBObject;
import com.mongodb.DBCollection;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import java.util.List;
import java.util.Map;
import kr.weitao.common.util.TimeUtils;
import kr.weitao.weitaokr.task.common.QueueItemEntity;
import kr.weitao.weitaokr.task.common.QueueParam;
import kr.weitao.weitaokr.task.common.ScheduleManger;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bson.types.ObjectId;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.stereotype.Component;

@Component
public class QueueInit {
    private static final Logger log = LogManager.getLogger(QueueInit.class);
    @Autowired
    private ScheduleManger scheduleManger;
    @Autowired
    private MongoTemplate mongoTemplate;
    private static final String GET_QUEUE_ITEM_SQL = "select q._id as 'queue_id',qi._id as 'queue_item_id',qi.total_count,t._id as 'trigger_id',t.cron_expression,j.class_name,q.type,q.interval_second,q.count,q.end_time from def_job_queue q join def_job_queue_item qi on qi.def_job_queue_id=q._id join def_job_process j on j._id=qi.def_job_id join def_trigger t on t._id=q.def_trigger_id where q.is_active='Y' and qi.is_active='Y'";
    private static final String GET_QUEUE_PARAM_SQL = "select jp._id as 'queue_item_id',jp.name,jp.value from def_job_param jp where jp.def_job_queue_item_id=?";

    public void start_from_mongodb() {
        DBCursor dbCur = null;
        DBCollection collection = this.mongoTemplate.getCollection("def_queue_item");
        BasicDBObject mongoCondition = new BasicDBObject();
        mongoCondition.put((Object)"is_active", (Object)"Y");
        try {
            dbCur = collection.find((DBObject)mongoCondition);
        }
        catch (Exception e) {
            log.error("get queue item from mongodb error:" + e.getLocalizedMessage(), (Throwable)e);
        }
        if (dbCur == null) {
            log.error("not find queue item from mongodb");
            return;
        }
        Object _id = null;
        DBObject object = null;
        Map map = null;
        QueueItemEntity qie = null;
        List queueParams = null;
        Object temp_item_obj = null;
        int i = -1;
        BasicDBObject projection = new BasicDBObject();
        projection.put((Object)"name", (Object)"1");
        projection.put((Object)"value", (Object)"1");
        JSONArray queue_param_array = null;
        DBCursor quueu_param_cursor = null;
        while (dbCur.hasNext()) {
            ++i;
            queueParams = null;
            object = dbCur.next();
            map = object.toMap();
            if (map == null || map.isEmpty()) continue;
            _id = map.get("_id");
            map.put("_id", _id.toString());
            map.put("queue_id", _id.toString());
            map.put("queue_item_id", _id.toString());
            map.put("trigger_id", _id.toString());
            try {
                qie = (QueueItemEntity)JSONObject.parseObject((String)JSON.toJSONString((Object)map), QueueItemEntity.class);
            }
            catch (Exception e) {
                log.error("json string index:" + i + " to queueitementity obj error:" + e.getLocalizedMessage(), (Throwable)e);
                continue;
            }
            if (qie == null) {
                log.error("json string index:" + i + " to queueitementity obj entity is null");
                continue;
            }
            collection = this.mongoTemplate.getCollection("def_job_param");
            BasicDBList condigtion_array = new BasicDBList();
            condigtion_array.add((Object)new BasicDBObject("is_active", (Object)"Y"));
            condigtion_array.add((Object)new BasicDBObject("queue_item_id", (Object)_id.toString()));
            mongoCondition = new BasicDBObject();
            mongoCondition.put((Object)"$and", (Object)condigtion_array);
            try {
                quueu_param_cursor = collection.find((DBObject)mongoCondition, (DBObject)projection);
            }
            catch (Exception e) {
                log.error("get queue item param error:" + e.getLocalizedMessage(), (Throwable)e);
                continue;
            }
            if (quueu_param_cursor != null && quueu_param_cursor.hasNext()) {
                queue_param_array = new JSONArray();
                while (quueu_param_cursor.hasNext()) {
                    object = quueu_param_cursor.next();
                    map = object.toMap();
                    if (map == null || map.isEmpty()) continue;
                    _id = map.get("_id");
                    map.put("queue_item_id", _id.toString());
                    queue_param_array.add((Object)map);
                }
                try {
                    queueParams = JSONArray.parseArray((String)JSON.toJSONString((Object)queue_param_array), QueueParam.class);
                }
                catch (Exception e) {
                    log.error("queue item param json string to queueparam error:" + e.getLocalizedMessage(), (Throwable)e);
                    continue;
                }
            }
            try {
                this.scheduleManger.addJob(qie, queueParams);
            }
            catch (Exception e) {
                log.error("add job error:" + e.getLocalizedMessage(), (Throwable)e);
            }
        }
    }

    public void startOrderCommission() {
        ObjectId _id = new ObjectId();
        JSONObject recurrence = new JSONObject();
        String current_time = TimeUtils.getTime((long)System.currentTimeMillis());
        QueueItemEntity qie = new QueueItemEntity();
        qie.set_id((Object)_id);
        qie.setQueue_id(_id.toString());
        qie.setQueue_item_id(_id.toString());
        qie.setTrigger_id(_id.toString());
        qie.setClass_name("kr.weitao.weitaokr.task.order.commission.OrderCommissionJob");
        qie.setRecurrence(recurrence);
        recurrence.put("type", (Object)"2");
        recurrence.put("cron", (Object)"0 0/5 * * * ?");
        recurrence.put("start_time", (Object)current_time);
    }

    public void startOrderCoupon() {
        ObjectId _id = new ObjectId();
        JSONObject recurrence = new JSONObject();
        String current_time = TimeUtils.getTime((long)System.currentTimeMillis());
        QueueItemEntity qie = new QueueItemEntity();
        qie.set_id((Object)_id);
        qie.setQueue_id(_id.toString());
        qie.setQueue_item_id(_id.toString());
        qie.setTrigger_id(_id.toString());
        qie.setClass_name("kr.weitao.weitaokr.task.order.coupon.OrderCouponJob");
        qie.setRecurrence(recurrence);
        recurrence.put("type", (Object)"2");
        recurrence.put("cron", (Object)"0 0 0/2 * * ?");
        recurrence.put("start_time", (Object)current_time);
    }

    public void startOrderSettlement() {
        ObjectId _id = new ObjectId();
        JSONObject recurrence = new JSONObject();
        String current_time = TimeUtils.getTime((long)System.currentTimeMillis());
        QueueItemEntity qie = new QueueItemEntity();
        qie.set_id((Object)_id);
        qie.setQueue_id(_id.toString());
        qie.setQueue_item_id(_id.toString());
        qie.setTrigger_id(_id.toString());
        qie.setClass_name("kr.weitao.weitaokr.task.order.settlement.SettlementJob");
        qie.setRecurrence(recurrence);
        recurrence.put("type", (Object)"2");
        recurrence.put("cron", (Object)"0 0/5 * * * ?");
        recurrence.put("start_time", (Object)current_time);
    }

    private void initJobProcess() {
        DBCollection collection = this.mongoTemplate.getCollection("def_job_process");
        BasicDBObject basicDB = new BasicDBObject();
        basicDB.put((Object)"$and", (Object)new BasicDBObject("is_active", (Object)"Y"));
        BasicDBObject projection = new BasicDBObject();
        projection.put((Object)"class_name", (Object)"1");
        DBCursor dbCur = collection.find((DBObject)basicDB, (DBObject)projection);
        if (dbCur == null) {
            return;
        }
        Object _id = null;
        DBObject object = null;
        Map map = null;
        while (dbCur.hasNext()) {
            object = dbCur.next();
            map = object.toMap();
            if (map == null || map.isEmpty()) continue;
            _id = map.get("_id");
            map.put("_id", _id.toString());
            map.put("queue_id", _id.toString());
            map.put("queue_item_id", _id.toString());
            map.put("trigger_id", _id.toString());
            map.put("trigger_id", _id.toString());
        }
    }
}

