/*
 * Decompiled with CFR 0.152.
 */
package kr.weitao.weitaokr.task.Logistics;

import com.alibaba.fastjson.JSONObject;
import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import kr.weitao.business.common.agent.UiAgent;
import kr.weitao.common.exception.CommonException;
import kr.weitao.starter.model.DataRequest;
import kr.weitao.weitaokr.service.LogisticsService;
import kr.weitao.weitaokr.task.common.AbstractJob;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.quartz.JobExecutionContext;
import org.quartz.JobKey;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.stereotype.Component;

@RefreshScope
@Component
public class OrderDeliveryStatusJob
extends AbstractJob {
    private static final Logger log = LogManager.getLogger(OrderDeliveryStatusJob.class);
    @Autowired
    MongoTemplate mongoTemplate;
    @Autowired
    UiAgent uiAgent;
    @Autowired
    LogisticsService logisticsService;

    protected void process(JobExecutionContext jec) throws CommonException {
        log.debug("doing update order delivery status job......");
        JobKey jobKey = jec.getJobDetail().getKey();
        String queue_id = jobKey.getGroup();
        String queue_item_id = jobKey.getName();
        queue_item_id = queue_item_id.replace("queue_item_", "");
        queue_id = queue_id.replace("queue_", "");
        log.info("\u5b9a\u65f6\u4efb\u52a1 queue_id:" + queue_id + "  queue_item_id:" + queue_item_id);
        if (queue_item_id.startsWith("syncOrderReceiveStatus")) {
            JSONObject param = new JSONObject();
            param.put("id", (Object)queue_id);
            DataRequest request = new DataRequest();
            request.setData(param);
            this.logisticsService.syncJob(request);
        }
        BasicDBObject query = new BasicDBObject();
        query.put((Object)"queue_id", (Object)queue_id);
        query.put((Object)"queue_item_id", (Object)queue_item_id);
        BasicDBObject update = new BasicDBObject();
        update.put((Object)"status", (Object)"0");
        this.mongoTemplate.getCollection("def_queue_item").update((DBObject)query, (DBObject)new BasicDBObject("$set", (Object)update));
    }
}

