/*
 * Decompiled with CFR 0.152.
 */
package kr.weitao.weitaokr.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.mongodb.BasicDBList;
import com.mongodb.BasicDBObject;
import com.mongodb.DBCollection;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import com.mongodb.WriteResult;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.net.URL;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.imageio.ImageIO;
import kr.weitao.business.common.agent.TinyUrlAgent;
import kr.weitao.business.common.agent.WechatAgent;
import kr.weitao.business.entity.Corp;
import kr.weitao.business.entity.LogWechatMoments;
import kr.weitao.business.entity.User;
import kr.weitao.business.entity.Vip;
import kr.weitao.business.entity.data.Material;
import kr.weitao.common.util.AliCDNUrlAuth;
import kr.weitao.common.util.StringUtils;
import kr.weitao.common.util.TimeUtils;
import kr.weitao.common.util.qrcode.QRCodeUtil;
import kr.weitao.common.util.spring.SpringUtils;
import kr.weitao.starter.model.DataRequest;
import kr.weitao.starter.model.DataResponse;
import kr.weitao.starter.model.Status;
import kr.weitao.starter.util.oss.BlobClient;
import kr.weitao.weitaokr.network.NetWorkCommon;
import kr.weitao.weitaokr.service.PushService;
import kr.weitao.weitaokr.service.WxService;
import kr.weitao.weitaokr.service.common.UserPortUtils;
import kr.weitao.weitaokr.service.impl.WxServiceImpl;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.stereotype.Service;

@Service
public class WxServiceImpl
implements WxService {
    private static final Logger log = LogManager.getLogger(WxServiceImpl.class);
    @Autowired
    MongoTemplate mongoTemplate;
    @Autowired
    BlobClient blobClient;
    @Autowired
    TinyUrlAgent tinyUrlAgent;
    @Autowired
    WechatAgent wechatAgent;
    @Autowired
    PushService pushService;
    @Value(value="${spring.profiles.active}")
    private String active;
    @Value(value="${weixin.server.pay.domain}")
    private String domain;
    @Autowired
    AliCDNUrlAuth aliCDNUrlAuth;
    @Value(value="${oss.oss_domain}")
    String OSS_DOMAIN;
    public static final String NotOnline = "User is not online";

    public DataResponse add(DataRequest dataRequest) {
        return null;
    }

    public DataResponse mod(DataRequest dataRequest) {
        return null;
    }

    public DataResponse reLogin(DataRequest dataRequest) {
        JSONObject data = dataRequest.getData();
        String user_id = data.getString("user_id");
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("user_id", (Object)user_id);
        jsonObject.put("active", (Object)this.active);
        Query query_ = new Query();
        query_.addCriteria((CriteriaDefinition)Criteria.where((String)"user_id").is((Object)user_id));
        User user_ = (User)this.mongoTemplate.findOne(query_, User.class);
        String port = UserPortUtils.getUserPort((String)user_.getPort());
        try {
            String result = NetWorkCommon.commonwx((JSONObject)jsonObject, (String)"/user/reLogin", (String)port);
            JSONObject object = JSON.parseObject((String)result);
            if (object.containsKey((Object)"status")) {
                if ("SUCCESS".equals(object.getString("status"))) {
                    JSONObject dataObject = new JSONObject();
                    dataObject.put("message", (Object)"\u91cd\u65b0\u767b\u5165\u6210\u529f");
                    JSONObject wx_object = new JSONObject();
                    String time = TimeUtils.getCurrentTimeInString((SimpleDateFormat)TimeUtils.DATETIME_FORMAT_DATE);
                    wx_object.put("login_time", (Object)time);
                    wx_object.put("user_id", (Object)user_id);
                    wx_object.put("way", (Object)"\u91cd\u65b0\u4e0a\u7ebf");
                    wx_object.put("phone", (Object)user_.getPhone());
                    wx_object.put("wx_id", (Object)user_.getWx_id());
                    wx_object.put("uin", (Object)user_.getUin());
                    this.mongoTemplate.insert((Object)wx_object, "def_wx_login");
                    Update update = new Update();
                    update.set("wx_login_time", (Object)time);
                    this.mongoTemplate.upsert(query_, update, User.class);
                    return new DataResponse().setStatus(Status.SUCCESS).setCode("0").setMsg(object.getString("msg")).setData(dataObject);
                }
                return new DataResponse().setStatus(Status.FAILED).setCode("0").setMsg("\u8bf7\u626b\u7801\u767b\u5165");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return new DataResponse().setStatus(Status.FAILED).setCode("-1").setMsg("\u91cd\u65b0\u767b\u5165\u5931\u8d25");
        }
        return new DataResponse().setStatus(Status.FAILED).setCode("-1").setMsg("\u91cd\u65b0\u767b\u5165\u5931\u8d25");
    }

    public DataResponse del(DataRequest dataRequest) {
        return null;
    }

    public DataResponse query(DataRequest dataRequest) {
        return null;
    }

    public DataResponse queryList(DataRequest dataRequest) {
        return null;
    }

    public DataResponse login(DataRequest dataRequest) {
        JSONObject data = dataRequest.getData();
        String user_id = data.getString("user_id");
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("user_id", (Object)user_id);
        jsonObject.put("active", (Object)this.active);
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"user_id").is((Object)user_id));
        User user = (User)this.mongoTemplate.findOne(query, User.class);
        log.info("user---" + user);
        if (null == user) {
            return new DataResponse().setCode("-1").setMsg("\u53d1\u9001\u5931\u8d25,\u672a\u627e\u5230\u7528\u6237");
        }
        String phone = user.getPhone();
        String port = user.getPort();
        try {
            String result = NetWorkCommon.commonwx((JSONObject)jsonObject, (String)"/user/login", (String)port);
            JSONObject object = JSON.parseObject((String)result);
            if (object.containsKey((Object)"status")) {
                if ("SUCCESS".equals(object.getString("status"))) {
                    String wx_id = object.getJSONObject("data").getString("wx_id");
                    String uin = object.getJSONObject("data").getString("uin");
                    String head_img = object.getJSONObject("data").getString("head_img");
                    String nick_name = object.getJSONObject("data").getString("nick_name");
                    Update update = new Update();
                    if (StringUtils.isNotNull((Object)wx_id)) {
                        update.set("wx_id", (Object)wx_id);
                        update.set("uin", (Object)uin);
                        update.set("head_img", (Object)head_img);
                        update.set("nick_name", (Object)nick_name);
                        String time = TimeUtils.getCurrentTimeInString((SimpleDateFormat)TimeUtils.DATETIME_FORMAT_DATE);
                        update.set("wx_login_time", (Object)time);
                        log.info(query + "------" + update);
                        WriteResult writeResult = this.mongoTemplate.upsert(query, update, User.class);
                        log.info("----\u66f4\u65b0\u7528\u6237\u4fe1\u606f----" + writeResult.getN());
                        JSONObject wx_object = new JSONObject();
                        wx_object.put("login_time", (Object)time);
                        wx_object.put("user_id", (Object)user_id);
                        wx_object.put("way", (Object)"\u626b\u7801\u767b\u5165");
                        wx_object.put("phone", (Object)phone);
                        wx_object.put("wx_id", (Object)wx_id);
                        wx_object.put("uin", (Object)uin);
                        this.mongoTemplate.save((Object)wx_object, "def_wx_login");
                    }
                    jsonObject.put("message", JSONObject.parseObject((String)result).get((Object)"data"));
                    Thread thread = new Thread((Runnable)new WxGetContactLabel(dataRequest, this.mongoTemplate));
                    thread.start();
                    return new DataResponse().setStatus(Status.SUCCESS).setCode("0").setData(jsonObject);
                }
                String msg = object.getString("msg");
                if (NotOnline.equals(msg)) {
                    msg = "\u5f53\u524d\u5fae\u4fe1\u6682\u672a\u7ed1\u5b9a";
                }
                return new DataResponse().setStatus(Status.FAILED).setCode("-1").setMsg(msg);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return new DataResponse().setStatus(Status.FAILED).setCode("-1").setMsg("\u767b\u5165\u5931\u8d25");
        }
        return new DataResponse().setStatus(Status.FAILED).setCode("-1").setMsg("\u767b\u5165\u5931\u8d25");
    }

    public DataResponse check_login(DataRequest dataRequest) {
        return this.wechatAgent.callRest(dataRequest, "/wxAuth/getState");
    }

    public DataResponse getState(DataRequest dataRequest) {
        try {
            DataResponse response = this.wechatAgent.callRest(dataRequest, "/wxAuth/getState");
            if (response.getStatus().equals((Object)Status.SUCCESS)) {
                return response;
            }
            response = this.wechatAgent.callRest(dataRequest, "/wxAuth/checkLogin");
            return response;
        }
        catch (Exception e) {
            e.printStackTrace();
            return new DataResponse().setStatus(Status.FAILED).setCode("-1").setMsg("\u5929\u6c14\u592a\u70ed\uff0c\u670d\u52a1\u5668\u907f\u6691\u53bb\u5566\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\u3002");
        }
    }

    public DataResponse check_web_login(DataRequest dataRequest) {
        JSONObject data = dataRequest.getData();
        String user_id = data.getString("user_id");
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("user_id", (Object)user_id);
        jsonObject.put("active", (Object)this.active);
        Query query_ = new Query();
        query_.addCriteria((CriteriaDefinition)Criteria.where((String)"user_id").is((Object)user_id));
        User user_ = (User)this.mongoTemplate.findOne(query_, User.class);
        String port = UserPortUtils.getUserPort((String)user_.getPort());
        try {
            String result = NetWorkCommon.commonwx((JSONObject)jsonObject, (String)"/user/checkStatus", (String)port);
            log.info("check_web_login--" + result);
            JSONObject object = JSON.parseObject((String)result);
            if (object.containsKey((Object)"status")) {
                log.info("---\u6210\u529f----" + object);
                if ("SUCCESS".equals(object.getString("status"))) {
                    JSONObject object1 = JSONObject.parseObject((String)result).getJSONObject("data");
                    jsonObject.put("message", (Object)object1.getString("status"));
                    return new DataResponse().setStatus(Status.SUCCESS).setCode("0").setData(jsonObject);
                }
                String msg = object.getString("msg");
                if (NotOnline.equals(msg)) {
                    msg = "\u5f53\u524d\u5fae\u4fe1\u6682\u672a\u7ed1\u5b9a";
                }
                return new DataResponse().setStatus(Status.FAILED).setCode("-1").setMsg(msg);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return new DataResponse().setStatus(Status.FAILED).setCode("-1").setMsg("\u8bf7\u6c42\u5931\u8d25");
    }

    public DataResponse getFriends(DataRequest dataRequest) {
        JSONObject data = dataRequest.getData();
        String user_id = data.getString("user_id");
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("user_id", (Object)user_id);
        jsonObject.put("update", (Object)true);
        String result = "";
        Query query_ = new Query();
        query_.addCriteria((CriteriaDefinition)Criteria.where((String)"user_id").is((Object)user_id));
        User user_ = (User)this.mongoTemplate.findOne(query_, User.class);
        String port = UserPortUtils.getUserPort((String)user_.getPort());
        try {
            result = NetWorkCommon.commonwx((JSONObject)jsonObject, (String)"/user/getFriends", (String)port);
            log.info("--getFriends-" + result);
            JSONObject object = JSONObject.parseObject((String)result);
            if (object.containsKey((Object)"status")) {
                log.info("---\u6210\u529f----" + object);
                if ("SUCCESS".equals(object.getString("status"))) {
                    jsonObject.put("message", (Object)JSON.parseObject((String)result).getJSONObject("data"));
                    return new DataResponse().setStatus(Status.SUCCESS).setCode("0").setData(jsonObject);
                }
                String msg = object.getString("msg");
                if (NotOnline.equals(msg)) {
                    msg = "\u5f53\u524d\u5fae\u4fe1\u6682\u672a\u7ed1\u5b9a";
                }
                return new DataResponse().setStatus(Status.FAILED).setCode("-1").setMsg(msg);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return new DataResponse().setStatus(Status.FAILED).setMsg(result);
    }

    public DataResponse getFriend(DataRequest dataRequest) {
        JSONObject data = dataRequest.getData();
        String user_id = data.getString("user_id");
        String vip_id = data.getString("vip_id");
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"vip_id").is((Object)vip_id));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"user_id").is((Object)user_id));
        Vip vip = (Vip)this.mongoTemplate.findOne(query, Vip.class);
        if (null == vip) {
            return new DataResponse().setStatus(Status.FAILED).setMsg("\u4f1a\u5458\u4e0d\u5b58\u5728");
        }
        String wx_id = vip.getWx_id();
        String nick_name = vip.getNick_name();
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("user_id", (Object)user_id);
        jsonObject.put("wx_id", (Object)wx_id);
        jsonObject.put("nick_name", (Object)nick_name);
        String result = "";
        Query query_ = new Query();
        query_.addCriteria((CriteriaDefinition)Criteria.where((String)"user_id").is((Object)user_id));
        User user_ = (User)this.mongoTemplate.findOne(query_, User.class);
        String port = UserPortUtils.getUserPort((String)user_.getPort());
        try {
            result = NetWorkCommon.commonwx((JSONObject)jsonObject, (String)"/user/getFriend", (String)port);
            log.info("--getFriend--" + result);
            JSONObject object = JSONObject.parseObject((String)result);
            if (object.containsKey((Object)"status")) {
                log.info("---\u6210\u529f----" + object);
                if ("SUCCESS".equals(object.getString("status"))) {
                    jsonObject.put("message", (Object)JSONObject.parseObject((String)result).getJSONArray("data"));
                    return new DataResponse().setStatus(Status.SUCCESS).setCode("0").setData(jsonObject);
                }
                String msg = object.getString("msg");
                if (NotOnline.equals(msg)) {
                    msg = "\u5f53\u524d\u5fae\u4fe1\u6682\u672a\u7ed1\u5b9a";
                }
                return new DataResponse().setStatus(Status.FAILED).setCode("-1").setMsg(msg);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return new DataResponse().setStatus(Status.FAILED).setMsg(result);
    }

    public DataResponse getGroups(DataRequest dataRequest) {
        JSONObject data = dataRequest.getData();
        String user_id = data.getString("user_id");
        String wx_id = data.getString("wx_id");
        Query query_ = new Query();
        query_.addCriteria((CriteriaDefinition)Criteria.where((String)"user_id").is((Object)user_id));
        User user_ = (User)this.mongoTemplate.findOne(query_, User.class);
        String u_uin = user_.getUin();
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"u_uin").is((Object)u_uin));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"wx_id").is((Object)wx_id));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"user_id").is((Object)user_id));
        Vip vip = (Vip)this.mongoTemplate.findOne(query, Vip.class);
        JSONArray vips_array = new JSONArray();
        if (null != vip) {
            JSONArray array = vip.getMembers();
            for (int i = 0; i < array.size(); ++i) {
                JSONObject a = new JSONObject();
                String is_friend = "N";
                try {
                    a = array.getJSONObject(i);
                    String wx_ids = a.getString("wx_id");
                    Query query_wx = new Query();
                    query_wx.addCriteria((CriteriaDefinition)Criteria.where((String)"wx_id").is((Object)wx_ids));
                    query_wx.addCriteria((CriteriaDefinition)Criteria.where((String)"u_uin").is((Object)u_uin));
                    query_wx.addCriteria((CriteriaDefinition)Criteria.where((String)"user_id").is((Object)user_id));
                    Vip vips = (Vip)this.mongoTemplate.findOne(query_, Vip.class);
                    if (null != vips) {
                        a.put("vip_id", (Object)vips.getVip_id());
                        is_friend = "Y";
                    }
                    a.put("is_friend", (Object)is_friend);
                    vips_array.add((Object)a);
                    continue;
                }
                catch (Exception e) {
                    String wx_ids = array.getString(i);
                    Query query_wx = new Query();
                    query_wx.addCriteria((CriteriaDefinition)Criteria.where((String)"wx_id").is((Object)wx_ids));
                    query_wx.addCriteria((CriteriaDefinition)Criteria.where((String)"u_uin").is((Object)u_uin));
                    query_wx.addCriteria((CriteriaDefinition)Criteria.where((String)"user_id").is((Object)user_id));
                    Vip vip_by = (Vip)this.mongoTemplate.findOne(query_wx, Vip.class);
                    if (null != vip_by) {
                        a.put("vip_id", (Object)vip_by.getVip_id());
                        a.put("head_image", (Object)vip_by.getHead_img());
                        a.put("nick_name", (Object)vip_by.getNick_name());
                        is_friend = "Y";
                    }
                    a.put("is_friend", (Object)is_friend);
                    a.put("wx_id", (Object)vip_by.getWx_id());
                    vips_array.add((Object)a);
                }
            }
        }
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("vip_list", (Object)vips_array);
        return new DataResponse().setStatus(Status.SUCCESS).setMsg("\u67e5\u8be2\u6210\u529f").setCode("0").setData(jsonObject);
    }

    public DataResponse getGroupsMemberList(DataRequest dataRequest) {
        JSONObject data = dataRequest.getData();
        String user_id = data.getString("user_id");
        String wx_id = data.getString("wx_id");
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("user_id", (Object)user_id);
        jsonObject.put("group_id", (Object)wx_id);
        jsonObject.put("wx_id", (Object)wx_id);
        Query query_ = new Query();
        query_.addCriteria((CriteriaDefinition)Criteria.where((String)"user_id").is((Object)user_id));
        User user_ = (User)this.mongoTemplate.findOne(query_, User.class);
        String u_uin = user_.getUin();
        String result = "";
        String result_ = "";
        String owner_wx_id = "";
        String port = UserPortUtils.getUserPort((String)user_.getPort());
        try {
            JSONObject object;
            result = NetWorkCommon.commonwx((JSONObject)jsonObject, (String)"/user/getGroupMemberList", (String)port);
            result_ = NetWorkCommon.commonwx((JSONObject)jsonObject, (String)"/user/getContact", (String)port);
            log.info("-result_--" + result_);
            JSONObject object_ = JSONObject.parseObject((String)result_);
            if (object_.containsKey((Object)"status")) {
                if ("SUCCESS".equals(object_.getString("status"))) {
                    owner_wx_id = object_.getJSONObject("data").getJSONObject("contact_info").getString("owner");
                } else {
                    String msg = object_.getString("msg");
                    if (NotOnline.equals(msg)) {
                        msg = "\u5f53\u524d\u5fae\u4fe1\u6682\u672a\u7ed1\u5b9a";
                    }
                    return new DataResponse().setStatus(Status.FAILED).setCode("-1").setMsg(msg);
                }
            }
            if ((object = JSONObject.parseObject((String)result)).containsKey((Object)"status")) {
                log.info("---WX_GET_GROUPMEMBERSLIST------" + object);
                if ("SUCCESS".equals(object.getString("status")) && object.getJSONObject("data").containsKey((Object)"member_list") && null != object.getJSONObject("data").get((Object)"member_list")) {
                    JSONArray array = object.getJSONObject("data").getJSONArray("member_list");
                    JSONArray array1 = new JSONArray();
                    for (int i = 0; i < array.size(); ++i) {
                        JSONObject jsonObject1 = array.getJSONObject(i);
                        String member_wx_id = jsonObject1.getString("user_name");
                        String head_image = jsonObject1.getString("small_head");
                        String nick_name = jsonObject1.getString("nick_name");
                        String invited_by = jsonObject1.getString("invited_by");
                        String is_owner = "N";
                        JSONObject member = new JSONObject();
                        member.put("nick_name", (Object)nick_name);
                        member.put("head_img", (Object)head_image);
                        member.put("wx_id", (Object)member_wx_id);
                        member.put("invited_by", (Object)invited_by);
                        if (member_wx_id.equals(owner_wx_id)) {
                            is_owner = "Y";
                        }
                        member.put("is_owner", (Object)is_owner);
                        String is_friend = "N";
                        Query query_wx = new Query();
                        query_wx.addCriteria((CriteriaDefinition)Criteria.where((String)"wx_id").is((Object)member_wx_id));
                        query_wx.addCriteria((CriteriaDefinition)Criteria.where((String)"u_uin").is((Object)u_uin));
                        query_wx.addCriteria((CriteriaDefinition)Criteria.where((String)"user_id").is((Object)user_id));
                        Vip vips = (Vip)this.mongoTemplate.findOne(query_wx, Vip.class);
                        if (null != vips) {
                            member.put("vip_id", (Object)vips.getVip_id());
                            is_friend = "Y";
                        }
                        member.put("is_friend", (Object)is_friend);
                        array1.add((Object)member);
                    }
                    JSONObject vip = new JSONObject();
                    vip.put("vip_list", (Object)array1);
                    return new DataResponse().setStatus(Status.SUCCESS).setCode("0").setData(vip);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            log.info((Object)e, (Throwable)e);
        }
        return new DataResponse().setStatus(Status.SUCCESS).setMsg("\u67e5\u8be2\u6210\u529f").setCode("0").setData(jsonObject);
    }

    public DataResponse userLogout(DataRequest dataRequest) {
        JSONObject data = dataRequest.getData();
        String user_id = data.getString("user_id");
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("user_id", (Object)user_id);
        jsonObject.put("update", (Object)true);
        String result = "";
        Query query_ = new Query();
        query_.addCriteria((CriteriaDefinition)Criteria.where((String)"user_id").is((Object)user_id));
        User user_ = (User)this.mongoTemplate.findOne(query_, User.class);
        log.info("----user----" + user_);
        String port = UserPortUtils.getUserPort((String)user_.getPort());
        try {
            result = NetWorkCommon.commonwx((JSONObject)jsonObject, (String)"/user/logout", (String)port);
            JSONObject object = JSONObject.parseObject((String)result);
            if (object.containsKey((Object)"status")) {
                log.info("---------" + object);
                if ("SUCCESS".equals(object.getString("status"))) {
                    jsonObject.put("message", (Object)object);
                    return new DataResponse().setStatus(Status.SUCCESS).setCode("0").setData(jsonObject);
                }
                String msg = object.getString("msg");
                if (NotOnline.equals(msg)) {
                    msg = "\u5f53\u524d\u5fae\u4fe1\u6682\u672a\u7ed1\u5b9a";
                }
                return new DataResponse().setStatus(Status.FAILED).setCode("-1").setMsg(msg);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            log.info((Object)e, (Throwable)e);
        }
        return new DataResponse().setStatus(Status.FAILED).setMsg(result);
    }

    public DataResponse getContactList(DataRequest dataRequest) {
        return this.wechatAgent.callRest(dataRequest, "/wxAuth/getContactList");
    }

    public DataResponse getContactListV2(DataRequest dataRequest) {
        String user_id;
        block5: {
            JSONObject data = dataRequest.getData();
            user_id = data.getString("user_id");
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("user_id", (Object)user_id);
            jsonObject.put("update", (Object)false);
            String result = "";
            Query query_ = new Query();
            query_.addCriteria((CriteriaDefinition)Criteria.where((String)"user_id").is((Object)user_id));
            User user_ = (User)this.mongoTemplate.findOne(query_, User.class);
            String port = UserPortUtils.getUserPort((String)user_.getPort());
            try {
                result = NetWorkCommon.commonwx((JSONObject)jsonObject, (String)"/user/getContactList", (String)port);
                JSONObject object = JSONObject.parseObject((String)result);
                if (!object.containsKey((Object)"status")) break block5;
                if ("SUCCESS".equals(object.getString("status"))) {
                    if (object.getJSONObject("data").containsKey((Object)"contact_list") && null != object.getJSONObject("data").get((Object)"contact_list")) {
                        jsonObject.put("message", (Object)object.getJSONObject("data").getJSONArray("contact_list"));
                        return new DataResponse().setStatus(Status.SUCCESS).setCode("0").setData(jsonObject);
                    }
                    break block5;
                }
                String msg = object.getString("msg");
                if (NotOnline.equals(msg)) {
                    msg = "\u5f53\u524d\u5fae\u4fe1\u6682\u672a\u7ed1\u5b9a";
                }
                return new DataResponse().setStatus(Status.FAILED).setCode("-1").setMsg(msg);
            }
            catch (Exception e) {
                e.printStackTrace();
                log.error("-\u83b7\u53d6\u8054\u7cfb\u4eba\u5931\u8d25--user_id---" + user_id, (Throwable)e);
            }
        }
        log.info("-\u83b7\u53d6\u8054\u7cfb\u4eba\u5931\u8d25--user_id---" + user_id);
        return new DataResponse().setStatus(Status.FAILED).setMsg("-\u83b7\u53d6\u8054\u7cfb\u4eba\u5931\u8d25--user_id---" + user_id);
    }

    public DataResponse resumeOnline(DataRequest dataRequest) {
        JSONObject data = dataRequest.getData();
        String user_id = data.getString("user_id");
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("user_id", (Object)user_id);
        jsonObject.put("active", (Object)this.active);
        String result = "";
        Query query_ = new Query();
        query_.addCriteria((CriteriaDefinition)Criteria.where((String)"user_id").is((Object)user_id));
        User user_ = (User)this.mongoTemplate.findOne(query_, User.class);
        String port = UserPortUtils.getUserPort((String)user_.getPort());
        try {
            result = NetWorkCommon.commonwx((JSONObject)jsonObject, (String)"/user/resumeOnline", (String)port);
            JSONObject object = JSONObject.parseObject((String)result);
            if (object.containsKey((Object)"status")) {
                if ("SUCCESS".equals(object.getString("status"))) {
                    return new DataResponse().setStatus(Status.SUCCESS).setCode("0").setMsg("resumeOnline\u6210\u529f");
                }
                String msg = object.getString("msg");
                if (NotOnline.equals(msg)) {
                    msg = "\u5f53\u524d\u5fae\u4fe1\u6682\u672a\u7ed1\u5b9a";
                }
                return new DataResponse().setStatus(Status.FAILED).setCode("-1").setMsg(msg);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("-\u83b7\u53d6\u8054\u7cfb\u4eba\u5931\u8d25WX_GET_resumeOnline_PATH--user_id---" + user_id, (Throwable)e);
        }
        log.info("-\u83b7\u53d6\u8054\u7cfb\u4eba\u5931\u8d25WX_GET_resumeOnline_PATH--user_id---" + user_id);
        return new DataResponse().setStatus(Status.FAILED).setMsg("-\u83b7\u53d6\u8054\u7cfb\u4eba\u5931\u8d25-WX_GET_resumeOnline_PATH-user_id---" + user_id);
    }

    public DataResponse getContact(DataRequest dataRequest) {
        JSONObject data = dataRequest.getData();
        String user_id = data.getString("user_id");
        String wx_id = data.getString("wx_id");
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("user_id", (Object)user_id);
        jsonObject.put("wx_id", (Object)wx_id);
        jsonObject.put("update", (Object)true);
        String result = "";
        Query query_ = new Query();
        query_.addCriteria((CriteriaDefinition)Criteria.where((String)"user_id").is((Object)user_id));
        User user_ = (User)this.mongoTemplate.findOne(query_, User.class);
        String port = UserPortUtils.getUserPort((String)user_.getPort());
        try {
            result = NetWorkCommon.commonwx((JSONObject)jsonObject, (String)"/user/getContact", (String)port);
            log.info("--getGroups---" + result);
            JSONObject object = JSONObject.parseObject((String)result);
            if (object.containsKey((Object)"status")) {
                log.info((Object)object);
                if ("SUCCESS".equals(object.getString("status"))) {
                    jsonObject.put("message", (Object)JSONObject.parseObject((String)result).getJSONObject("data"));
                    return new DataResponse().setStatus(Status.SUCCESS).setCode("0").setData(jsonObject);
                }
                String msg = object.getString("msg");
                if (NotOnline.equals(msg)) {
                    msg = "\u5f53\u524d\u5fae\u4fe1\u6682\u672a\u7ed1\u5b9a";
                }
                return new DataResponse().setStatus(Status.FAILED).setCode("-1").setMsg(msg);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            log.info((Object)e, (Throwable)e);
        }
        return new DataResponse().setStatus(Status.FAILED).setMsg(result);
    }

    public DataResponse genQrcode(DataRequest dataRequest) {
        this.userLogout(dataRequest);
        JSONObject data = dataRequest.getData();
        String user_id = data.getString("user_id");
        String rebind = data.getString("rebind");
        String auto_login = data.getString("auto_login");
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("user_id", (Object)user_id);
        jsonObject.put("active", (Object)this.active);
        jsonObject.put("rebind", (Object)rebind);
        if (StringUtils.isNull((Object)rebind)) {
            jsonObject.put("auto_login", (Object)"Y");
        }
        Query query_ = new Query();
        query_.addCriteria((CriteriaDefinition)Criteria.where((String)"user_id").is((Object)user_id));
        String port = UserPortUtils.getSysPort();
        log.info("------port-----" + port);
        Update update = new Update();
        update.set("port", (Object)port);
        this.mongoTemplate.upsert(query_, update, User.class);
        String result = "\u5fae\u4fe1\u7ed1\u5b9a\u529f\u80fd\u6b63\u5728\u7ef4\u62a4,\u6682\u505c\u4f7f\u7528";
        try {
            result = NetWorkCommon.commonwx((JSONObject)jsonObject, (String)"/user/genQrcode", (String)port);
            log.info("--WX_GET_GENQRCODE_PATH---" + result);
            JSONObject object = JSONObject.parseObject((String)result);
            if (object.containsKey((Object)"status")) {
                log.info((Object)object);
                if ("SUCCESS".equals(object.getString("status"))) {
                    jsonObject.put("message", (Object)"\u83b7\u53d6\u6210\u529f");
                    return new DataResponse().setStatus(Status.SUCCESS).setCode("0").setData(jsonObject);
                }
                String msg = object.getString("msg");
                if (NotOnline.equals(msg)) {
                    msg = "\u5f53\u524d\u5fae\u4fe1\u6682\u672a\u7ed1\u5b9a";
                }
                return new DataResponse().setStatus(Status.FAILED).setCode("-1").setMsg(msg);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            log.info((Object)e, (Throwable)e);
        }
        return new DataResponse().setStatus(Status.FAILED).setMsg(result);
    }

    public DataResponse getGroupMembers(DataRequest dataRequest) {
        JSONObject data = dataRequest.getData();
        String user_id = data.getString("user_id");
        String vip_id = data.getString("vip_id");
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"vip_id").is((Object)vip_id));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"user_id").is((Object)user_id));
        Vip vip = (Vip)this.mongoTemplate.findOne(query, Vip.class);
        if (null == vip) {
            return new DataResponse().setStatus(Status.FAILED).setMsg("\u4f1a\u5458\u4e0d\u5b58\u5728");
        }
        String wx_id = vip.getWx_id();
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("user_id", (Object)user_id);
        jsonObject.put("wx_id", (Object)wx_id);
        String result = "";
        Query query_ = new Query();
        query_.addCriteria((CriteriaDefinition)Criteria.where((String)"user_id").is((Object)user_id));
        User user_ = (User)this.mongoTemplate.findOne(query_, User.class);
        String port = UserPortUtils.getUserPort((String)user_.getPort());
        try {
            result = NetWorkCommon.commonwx((JSONObject)jsonObject, (String)"/user/getGroupMembers", (String)port);
            log.info("-getGroupMembers--" + result);
            JSONObject object = JSONObject.parseObject((String)result);
            if (object.containsKey((Object)"status")) {
                log.info("---\u6210\u529f----" + object);
                if ("SUCCESS".equals(object.getString("status"))) {
                    jsonObject.put("message", (Object)JSONObject.parseObject((String)result).getJSONObject("data"));
                    return new DataResponse().setStatus(Status.SUCCESS).setCode("0").setData(jsonObject);
                }
                String msg = object.getString("msg");
                if (NotOnline.equals(msg)) {
                    msg = "\u5f53\u524d\u5fae\u4fe1\u6682\u672a\u7ed1\u5b9a";
                }
                return new DataResponse().setStatus(Status.FAILED).setCode("-1").setMsg(msg);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            log.info((Object)e, (Throwable)e);
        }
        return new DataResponse().setStatus(Status.FAILED).setMsg(result);
    }

    public DataResponse addGroupMembers(DataRequest dataRequest) {
        JSONObject data = dataRequest.getData();
        String user_id = data.getString("user_id");
        Query query_ = new Query();
        query_.addCriteria((CriteriaDefinition)Criteria.where((String)"user_id").is((Object)user_id));
        User user_ = (User)this.mongoTemplate.findOne(query_, User.class);
        String port = UserPortUtils.getUserPort((String)user_.getPort());
        String group_wx_id = data.getString("group_wx_id");
        String member_wx_ids = data.getString("member_wx_ids");
        log.info("--member_wx_ids---" + member_wx_ids);
        String[] member_wx_id = member_wx_ids.split(",");
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("user_id", (Object)user_id);
        jsonObject.put("group_wx_id", (Object)group_wx_id);
        jsonObject.put("member_wx_ids", (Object)member_wx_id);
        String result = "";
        try {
            result = NetWorkCommon.commonwx((JSONObject)jsonObject, (String)"/user/addGroupMembers", (String)port);
            log.info("-getGroupMembers--" + result);
            JSONObject object = JSONObject.parseObject((String)result);
            if (object.containsKey((Object)"status")) {
                log.info("---\u6210\u529f----" + object);
                if ("SUCCESS".equals(object.getString("status"))) {
                    jsonObject.put("message", (Object)JSONObject.parseObject((String)result).getJSONObject("data"));
                    return new DataResponse().setStatus(Status.SUCCESS).setCode("0").setData(jsonObject);
                }
                String msg = object.getString("msg");
                if (NotOnline.equals(msg)) {
                    msg = "\u5f53\u524d\u5fae\u4fe1\u6682\u672a\u7ed1\u5b9a";
                }
                return new DataResponse().setStatus(Status.FAILED).setCode("-1").setMsg(msg);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            log.info((Object)e, (Throwable)e);
        }
        return new DataResponse().setStatus(Status.FAILED).setMsg(result);
    }

    public DataResponse addFriend(DataRequest dataRequest) {
        JSONObject data = dataRequest.getData();
        String user_id = data.getString("user_id");
        Query query_ = new Query();
        query_.addCriteria((CriteriaDefinition)Criteria.where((String)"user_id").is((Object)user_id));
        User user_ = (User)this.mongoTemplate.findOne(query_, User.class);
        String port = UserPortUtils.getUserPort((String)user_.getPort());
        String friend_wx_id = data.getString("friend_wx_id");
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("user_id", (Object)user_id);
        jsonObject.put("group_wx_id", (Object)friend_wx_id);
        String result = "";
        try {
            result = NetWorkCommon.commonwx((JSONObject)jsonObject, (String)"/user/addFriend", (String)port);
            log.info("-getGroupMembers--" + result);
            JSONObject object = JSONObject.parseObject((String)result);
            if (object.containsKey((Object)"status")) {
                log.info("---\u6210\u529f----" + object);
                if ("SUCCESS".equals(object.getString("status"))) {
                    jsonObject.put("message", (Object)JSONObject.parseObject((String)result).getJSONObject("data"));
                    return new DataResponse().setStatus(Status.SUCCESS).setCode("0").setData(jsonObject);
                }
                String msg = object.getString("msg");
                if (NotOnline.equals(msg)) {
                    msg = "\u5f53\u524d\u5fae\u4fe1\u6682\u672a\u7ed1\u5b9a";
                }
                return new DataResponse().setStatus(Status.FAILED).setCode("-1").setMsg(msg);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            log.info((Object)e, (Throwable)e);
        }
        return new DataResponse().setStatus(Status.FAILED).setMsg(result);
    }

    public DataResponse addContactLabel(DataRequest dataRequest) {
        JSONObject data = dataRequest.getData();
        String user_id = data.getString("user_id");
        Query query_ = new Query();
        query_.addCriteria((CriteriaDefinition)Criteria.where((String)"user_id").is((Object)user_id));
        User user_ = (User)this.mongoTemplate.findOne(query_, User.class);
        if (null == user_) {
            return new DataResponse().setCode("-1").setMsg("\u53d1\u9001\u5931\u8d25,\u672a\u627e\u5230\u5bf9\u5e94\u5ba2\u670d");
        }
        String port = UserPortUtils.getUserPort((String)user_.getPort());
        String label_name = data.getString("vip_group_name");
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("user_id", (Object)user_id);
        jsonObject.put("label_name", (Object)label_name);
        String result = "";
        try {
            result = NetWorkCommon.commonwx((JSONObject)jsonObject, (String)"/user/addContactLabel", (String)port);
            log.info("-getGroupMembers--" + result);
            JSONObject object = JSONObject.parseObject((String)result);
            if (object.containsKey((Object)"status")) {
                log.info("---\u6210\u529f----" + object);
                if ("SUCCESS".equals(object.getString("status"))) {
                    jsonObject.put("message", (Object)JSONObject.parseObject((String)result).getJSONObject("data"));
                    return new DataResponse().setStatus(Status.SUCCESS).setCode("0").setData(jsonObject);
                }
                String msg = object.getString("msg");
                if (NotOnline.equals(msg)) {
                    msg = "\u5f53\u524d\u5fae\u4fe1\u6682\u672a\u7ed1\u5b9a";
                }
                return new DataResponse().setStatus(Status.FAILED).setCode("-1").setMsg(msg);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            log.info((Object)e, (Throwable)e);
        }
        return new DataResponse().setStatus(Status.FAILED).setMsg(result);
    }

    public DataResponse removeContactLabel(DataRequest dataRequest) {
        JSONObject data = dataRequest.getData();
        String user_id = data.getString("user_id");
        Query query_ = new Query();
        query_.addCriteria((CriteriaDefinition)Criteria.where((String)"user_id").is((Object)user_id));
        User user_ = (User)this.mongoTemplate.findOne(query_, User.class);
        String label_id = data.getString("id");
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("user_id", (Object)user_id);
        jsonObject.put("label_id", (Object)label_id);
        String result = "";
        String port = UserPortUtils.getUserPort((String)user_.getPort());
        try {
            result = NetWorkCommon.commonwx((JSONObject)jsonObject, (String)"/user/removeContactLabel", (String)port);
            log.info("-getGroupMembers--" + result);
            JSONObject object = JSONObject.parseObject((String)result);
            if (object.containsKey((Object)"status")) {
                log.info("---\u6210\u529f----" + object);
                if ("SUCCESS".equals(object.getString("status"))) {
                    jsonObject.put("message", (Object)JSONObject.parseObject((String)result).getJSONObject("data"));
                    return new DataResponse().setStatus(Status.SUCCESS).setCode("0").setData(jsonObject);
                }
                String msg = object.getString("msg");
                if (NotOnline.equals(msg)) {
                    msg = "\u5f53\u524d\u5fae\u4fe1\u6682\u672a\u7ed1\u5b9a";
                }
                return new DataResponse().setStatus(Status.FAILED).setCode("-1").setMsg(msg);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            log.info((Object)e, (Throwable)e);
        }
        return new DataResponse().setStatus(Status.FAILED).setMsg(result);
    }

    public static void main(String[] args) {
        String label_id = "2";
        String type = "del";
        String label_ids = "";
        JSONArray array = new JSONArray();
        JSONObject a = new JSONObject();
        a.put("vip_group_id", (Object)"1");
        JSONObject b = new JSONObject();
        b.put("vip_group_id", (Object)"2");
        JSONObject c = new JSONObject();
        c.put("vip_group_id", (Object)"3");
        JSONObject d = new JSONObject();
        d.put("vip_group_id", (Object)"4");
        array.add((Object)a);
        array.add((Object)b);
        array.add((Object)c);
        array.add((Object)d);
        if ("add".equalsIgnoreCase(type)) {
            for (int i = 0; i < array.size(); ++i) {
                JSONObject jsonObject = array.getJSONObject(i);
                String id = jsonObject.getString("vip_group_id");
                if (id.length() >= 5) continue;
                label_ids = label_ids + "," + id;
            }
            label_ids = label_id + label_ids;
        } else {
            for (int i = 0; i < array.size(); ++i) {
                JSONObject jsonObject = array.getJSONObject(i);
                String id = jsonObject.getString("vip_group_id");
                if (label_id.equalsIgnoreCase(id) || id.length() >= 5) continue;
                label_ids = label_ids + "," + id;
            }
            label_ids = label_ids.substring(1, label_ids.length());
        }
        log.info(label_ids);
    }

    public DataResponse setContactLabel(DataRequest dataRequest) {
        String id;
        JSONObject jsonObject;
        int i;
        JSONObject data = dataRequest.getData();
        log.info((Object)data);
        String user_id = data.getString("user_id");
        String label_id = data.getString("label_id");
        String type = data.getString("type");
        Query query_ = new Query();
        query_.addCriteria((CriteriaDefinition)Criteria.where((String)"user_id").is((Object)user_id));
        String vip_id = data.getString("vip_id");
        String label_ids = "";
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"vip_id").is((Object)vip_id));
        Vip vip = (Vip)this.mongoTemplate.findOne(query, Vip.class);
        String wx_id = vip.getWx_id();
        JSONArray array = vip.getVipGroups();
        log.info("----getVipGroups----" + array);
        if ("add".equalsIgnoreCase(type)) {
            for (i = 0; i < array.size(); ++i) {
                jsonObject = array.getJSONObject(i);
                id = jsonObject.getString("vip_group_id");
                if (id.length() >= 5 || id.equals(label_id)) continue;
                label_ids = label_ids + "," + id;
            }
            label_ids = label_id + label_ids;
        } else {
            for (i = 0; i < array.size(); ++i) {
                jsonObject = array.getJSONObject(i);
                id = jsonObject.getString("vip_group_id");
                if (label_id.equalsIgnoreCase(id) || id.length() >= 5) continue;
                label_ids = label_ids + "," + id;
            }
            if (StringUtils.isNotNull((Object)label_ids)) {
                label_ids = label_ids.substring(1, label_ids.length());
            }
        }
        log.info("---label_ids--" + label_ids);
        JSONObject jsonObject2 = new JSONObject();
        jsonObject2.put("user_id", (Object)user_id);
        jsonObject2.put("wx_id", (Object)wx_id);
        jsonObject2.put("label_id", (Object)label_ids);
        String result = "";
        Query quer = new Query();
        quer.addCriteria((CriteriaDefinition)Criteria.where((String)"user_id").is((Object)user_id));
        User user_ = (User)this.mongoTemplate.findOne(quer, User.class);
        String port = UserPortUtils.getUserPort((String)user_.getPort());
        try {
            result = NetWorkCommon.commonwx((JSONObject)jsonObject2, (String)"/user/setContactLabel", (String)port);
            log.info("-getGroupMembers--" + result);
            JSONObject object = JSONObject.parseObject((String)result);
            if (object.containsKey((Object)"status")) {
                log.info("---\u6210\u529f----" + object);
                if ("SUCCESS".equals(object.getString("status"))) {
                    jsonObject2.put("message", (Object)JSONObject.parseObject((String)result).getJSONObject("data"));
                    return new DataResponse().setStatus(Status.SUCCESS).setCode("0").setData(jsonObject2);
                }
                String msg = object.getString("msg");
                if (NotOnline.equals(msg)) {
                    msg = "\u5f53\u524d\u5fae\u4fe1\u6682\u672a\u7ed1\u5b9a";
                }
                return new DataResponse().setStatus(Status.FAILED).setCode("-1").setMsg(msg);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            log.info((Object)e, (Throwable)e);
        }
        return new DataResponse().setStatus(Status.FAILED).setMsg(result);
    }

    public DataResponse getContactLabelList(DataRequest dataRequest) {
        JSONObject data = dataRequest.getData();
        String user_id = data.getString("user_id");
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("user_id", (Object)user_id);
        jsonObject.put("update", (Object)true);
        String result = "";
        Query query_ = new Query();
        query_.addCriteria((CriteriaDefinition)Criteria.where((String)"user_id").is((Object)user_id));
        log.info("--getContactLabelList--" + query_);
        if (this.mongoTemplate == null) {
            this.mongoTemplate = (MongoTemplate)SpringUtils.getBean((String)"mongoTemplate");
        }
        User user_ = (User)this.mongoTemplate.findOne(query_, User.class);
        String port = UserPortUtils.getUserPort((String)user_.getPort());
        try {
            result = NetWorkCommon.commonwx((JSONObject)jsonObject, (String)"/user/getContactLabelList", (String)port);
            log.info("-getContactLabelList--" + result);
            JSONObject object = JSONObject.parseObject((String)result);
            if (object.containsKey((Object)"status")) {
                log.info("---\u6210\u529f----" + object);
                if ("SUCCESS".equals(object.getString("status"))) {
                    jsonObject.put("message", (Object)JSONObject.parseObject((String)result).getJSONObject("data"));
                    return new DataResponse().setStatus(Status.SUCCESS).setCode("0").setData(jsonObject);
                }
                String msg = object.getString("msg");
                if (NotOnline.equals(msg)) {
                    msg = "\u5f53\u524d\u5fae\u4fe1\u6682\u672a\u7ed1\u5b9a";
                }
                return new DataResponse().setStatus(Status.FAILED).setCode("-1").setMsg(msg);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            log.info((Object)e, (Throwable)e);
        }
        return new DataResponse().setStatus(Status.FAILED).setMsg(result);
    }

    public DataResponse addGroupMember(DataRequest dataRequest) {
        JSONObject data = dataRequest.getData();
        String user_id = data.getString("user_id");
        String group_id = data.getString("group_id");
        String wx_id = data.getString("wx_id");
        Query query_ = new Query();
        query_.addCriteria((CriteriaDefinition)Criteria.where((String)"user_id").is((Object)user_id));
        User user_ = (User)this.mongoTemplate.findOne(query_, User.class);
        String port = UserPortUtils.getUserPort((String)user_.getPort());
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("user_id", (Object)user_id);
        jsonObject.put("group_id", (Object)group_id);
        jsonObject.put("wx_id", (Object)wx_id);
        String result = "";
        try {
            result = NetWorkCommon.commonwx((JSONObject)jsonObject, (String)"/user/addGroupMember", (String)port);
            log.info("-getContactLabelList--" + result);
            JSONObject object = JSONObject.parseObject((String)result);
            if (object.containsKey((Object)"status")) {
                log.info("---\u6210\u529f----" + object);
                if ("SUCCESS".equals(object.getString("status"))) {
                    return new DataResponse().setStatus(Status.SUCCESS).setCode("0").setData(object);
                }
                String msg = object.getString("msg");
                if (NotOnline.equals(msg)) {
                    msg = "\u5f53\u524d\u5fae\u4fe1\u6682\u672a\u7ed1\u5b9a";
                }
                return new DataResponse().setStatus(Status.FAILED).setCode("-1").setMsg(msg);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            log.info((Object)e, (Throwable)e);
        }
        return new DataResponse().setStatus(Status.FAILED).setMsg(result);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public DataResponse delGroupMember(DataRequest dataRequest) {
        JSONObject data = dataRequest.getData();
        String user_id = data.getString("user_id");
        String group_id = data.getString("group_id");
        String wx_id = data.getString("wx_id");
        Query query_ = new Query();
        query_.addCriteria((CriteriaDefinition)Criteria.where((String)"user_id").is((Object)user_id));
        User user_ = (User)this.mongoTemplate.findOne(query_, User.class);
        String port = UserPortUtils.getUserPort((String)user_.getPort());
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("user_id", (Object)user_id);
        jsonObject.put("group_id", (Object)group_id);
        jsonObject.put("wx_id", (Object)wx_id);
        String result = "";
        try {
            JSONObject jsonObject_ = new JSONObject();
            jsonObject_.put("user_id", (Object)user_id);
            jsonObject_.put("wx_id", (Object)group_id);
            result = NetWorkCommon.commonwx((JSONObject)jsonObject_, (String)"/user/getContact", (String)port);
            Boolean flag = false;
            log.info("-getContactLabelList--" + result);
            JSONObject object = JSONObject.parseObject((String)result);
            if (object.containsKey((Object)"status")) {
                if ("SUCCESS".equals(object.getString("status"))) {
                    String owner_wx_id = object.getJSONObject("data").getJSONObject("contact_info").getString("owner");
                    if (!owner_wx_id.equals(wx_id)) return new DataResponse().setStatus(Status.FAILED).setCode("-1").setMsg("\u60a8\u4e0d\u662f\u7fa4\u4e3b");
                    flag = true;
                } else {
                    String msg = object.getString("msg");
                    if (!NotOnline.equals(msg)) return new DataResponse().setStatus(Status.FAILED).setCode("-1").setMsg(msg);
                    msg = "\u5f53\u524d\u5fae\u4fe1\u6682\u672a\u7ed1\u5b9a";
                    return new DataResponse().setStatus(Status.FAILED).setCode("-1").setMsg(msg);
                }
            }
            if (!flag.booleanValue()) return new DataResponse().setStatus(Status.FAILED).setMsg("\u5220\u9664\u5931\u8d25");
            result = NetWorkCommon.commonwx((JSONObject)jsonObject, (String)"/user/delGroupMember", (String)port);
            log.info("-getContactLabelList--" + result);
            JSONObject object_ = JSONObject.parseObject((String)result);
            if (!object_.containsKey((Object)"status")) return new DataResponse().setStatus(Status.FAILED).setMsg("\u5220\u9664\u5931\u8d25");
            log.info("---\u6210\u529f----" + object_);
            if ("SUCCESS".equals(object_.getString("status"))) {
                return new DataResponse().setStatus(Status.SUCCESS).setCode("0").setData(object);
            }
            String msg = object.getString("msg");
            if (!NotOnline.equals(msg)) return new DataResponse().setStatus(Status.FAILED).setCode("-1").setMsg(msg);
            msg = "\u5f53\u524d\u5fae\u4fe1\u6682\u672a\u7ed1\u5b9a";
            return new DataResponse().setStatus(Status.FAILED).setCode("-1").setMsg(msg);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.info((Object)e, (Throwable)e);
        }
        return new DataResponse().setStatus(Status.FAILED).setMsg("\u5220\u9664\u5931\u8d25");
    }

    public DataResponse wx_login_log(DataRequest dataRequest) {
        DataResponse dataResponse = new DataResponse();
        JSONObject data = dataRequest.getData();
        String user_id = data.getString("user_id");
        int page_num = data.getIntValue("page_num");
        int page_size = data.getIntValue("page_size");
        DBCollection collection = this.mongoTemplate.getCollection("def_wx_login");
        BasicDBObject basicDB = new BasicDBObject();
        BasicDBList basicDBList1 = new BasicDBList();
        basicDBList1.add((Object)new BasicDBObject("user_id", (Object)user_id));
        basicDB.put((Object)"$and", (Object)basicDBList1);
        DBCursor dbCur = collection.find((DBObject)basicDB).skip(page_num * page_size).limit(page_size).sort((DBObject)new BasicDBObject("login_time", (Object)-1));
        JSONObject jsonObject = new JSONObject();
        JSONArray productList = new JSONArray();
        while (dbCur.hasNext()) {
            DBObject object = dbCur.next();
            Map map = object.toMap();
            Object id = map.get("_id");
            map.put("id", id.toString());
            map.remove("_id");
            productList.add((Object)map);
        }
        jsonObject.put("message", (Object)productList);
        return dataResponse.setStatus(Status.SUCCESS).setData(jsonObject).setCode("0");
    }

    public DataResponse snsUploadImg(DataRequest dataRequest) {
        JSONObject data = dataRequest.getData();
        String user_id = data.getString("user_id");
        String img_key = data.getString("img_key");
        Query query_ = new Query();
        query_.addCriteria((CriteriaDefinition)Criteria.where((String)"user_id").is((Object)user_id));
        User user_ = (User)this.mongoTemplate.findOne(query_, User.class);
        String port = UserPortUtils.getUserPort((String)user_.getPort());
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("user_id", (Object)user_id);
        jsonObject.put("img_key", (Object)img_key);
        String result = "";
        try {
            result = NetWorkCommon.commonwx((JSONObject)jsonObject, (String)"/user/snsUploadImg", (String)port);
            log.info("-snsUploadImg--" + result);
            JSONObject object = JSONObject.parseObject((String)result);
            if (object.containsKey((Object)"status")) {
                log.info("---\u6210\u529f----" + object);
                if ("SUCCESS".equals(object.getString("status"))) {
                    jsonObject.put("message", (Object)JSONObject.parseObject((String)result).getJSONObject("data"));
                    return new DataResponse().setStatus(Status.SUCCESS).setCode("0").setData(jsonObject);
                }
                String msg = object.getString("msg");
                if (StringUtils.isNull((Object)msg)) {
                    msg = "\u4e0a\u4f20\u56fe\u7247\u5931\u8d25";
                }
                return new DataResponse().setStatus(Status.FAILED).setCode("-1").setMsg(msg);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            log.info((Object)e, (Throwable)e);
        }
        return new DataResponse().setStatus(Status.FAILED).setMsg(result);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public DataResponse publishPicture(DataRequest dataRequest) {
        DataResponse dataResponse = new DataResponse();
        JSONObject data = dataRequest.getData();
        String user_id = data.getString("user_id");
        String material_id = data.getString("material_id");
        String material_type = "";
        try {
            if (StringUtils.isNotNull((Object)material_id)) {
                Query query = new Query();
                query.addCriteria((CriteriaDefinition)Criteria.where((String)"material_id").is((Object)material_id));
                Material material = (Material)this.mongoTemplate.findOne(query, Material.class);
                if (material == null) {
                    return new DataResponse().setStatus(Status.FAILED).setCode("-1").setMsg("\u7d20\u6750\u4e0d\u5b58\u5728");
                }
                material_type = material.getMaterial_type();
                if ("1".equals(material_type)) {
                    data.put("content", (Object)material.getMaterial_content());
                    dataResponse = this.snsPublish(dataRequest);
                } else if ("2".equals(material_type)) {
                    data.put("content_desc", (Object)material.getMaterial_content());
                    JSONArray pictures = new JSONArray();
                    JSONArray image_url = material.getImage_url();
                    for (int i = 0; i < image_url.size(); ++i) {
                        String url;
                        JSONObject img_obj = image_url.getJSONObject(i);
                        String image = img_obj.getString("image_url");
                        String string = url = img_obj.getString("url") == null ? img_obj.getString("product_url") : img_obj.getString("url");
                        if (StringUtils.isNull((Object)url)) {
                            if (StringUtils.isNotNull((Object)img_obj.getString("wechat_url"))) {
                                pictures.add((Object)img_obj.getString("wechat_url"));
                                continue;
                            }
                            DataRequest dataRequest1 = new DataRequest();
                            JSONObject data1 = new JSONObject();
                            data1.put("user_id", (Object)user_id);
                            data1.put("img_key", (Object)image);
                            dataRequest1.setData(data1);
                            DataResponse dataResponse1 = this.snsUploadImg(dataRequest1);
                            if (!dataResponse1.getStatus().equals((Object)Status.SUCCESS)) return dataResponse1;
                            JSONObject upload_info = dataResponse1.getData().getJSONObject("message").getJSONObject("upload_info");
                            pictures.add((Object)upload_info.getString("big_url"));
                            BasicDBObject update_query = new BasicDBObject();
                            update_query.put((Object)"material_id", (Object)material_id);
                            update_query.put((Object)"image_url.image_url", (Object)image);
                            BasicDBObject update_item = new BasicDBObject("image_url.$.wechat_url", (Object)upload_info.getString("big_url"));
                            BasicDBObject update_data = new BasicDBObject("$set", (Object)update_item);
                            this.mongoTemplate.getCollection("def_material").update((DBObject)update_query, (DBObject)update_data);
                            continue;
                        }
                        int direction = img_obj.getInteger("direction");
                        String material_dynamic_code_url = img_obj.getString("material_dynamic_code_url");
                        String redirect_uri = img_obj.getString("redirect_uri");
                        String product_id = img_obj.getString("product_id");
                        String activity_id = img_obj.getString("activity_id");
                        String team_id = img_obj.getString("team_id");
                        redirect_uri = redirect_uri.replace("<user_id>", user_id).replace("<material_id>", material_id).replace("<product_url>", url);
                        if (StringUtils.isNotNull((Object)product_id)) {
                            redirect_uri = redirect_uri.replace("<product_id>", product_id);
                        }
                        if (StringUtils.isNotNull((Object)activity_id)) {
                            redirect_uri = redirect_uri.replace("<activity_id>", activity_id);
                        }
                        if (StringUtils.isNotNull((Object)team_id)) {
                            redirect_uri = redirect_uri.replace("<team_id>", team_id);
                        }
                        redirect_uri = URLEncoder.encode(redirect_uri);
                        material_dynamic_code_url = material_dynamic_code_url.replace("<redirect_uri>", redirect_uri);
                        JSONObject param = new JSONObject();
                        param.put("url", (Object)material_dynamic_code_url);
                        JSONObject tiny_url_data = this.tinyUrlAgent.getData(param, "/tinyUrl/generate");
                        image = this.aliCDNUrlAuth.getAuthURLA(this.OSS_DOMAIN + "/" + image);
                        InputStream bigImgIs = new URL(image).openStream();
                        BufferedImage smallImg = QRCodeUtil.createImage((String)tiny_url_data.getString("tiny_url"), (String)"", (boolean)false);
                        BufferedImage buffImg = QRCodeUtil.bigImgAddSmallImgAndText((InputStream)bigImgIs, (BufferedImage)smallImg, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (int)direction);
                        ByteArrayOutputStream os = new ByteArrayOutputStream();
                        ImageIO.write((RenderedImage)buffImg, "jpg", os);
                        ByteArrayInputStream is = new ByteArrayInputStream(os.toByteArray());
                        String name = System.currentTimeMillis() + "-" + i + ".jpg";
                        this.blobClient.passFileStrem("material-imgs/", material_id + "/" + name, (InputStream)is);
                        String image_key = "material_imgs/" + material_id + "/" + name;
                        DataRequest dataRequest1 = new DataRequest();
                        JSONObject data1 = new JSONObject();
                        data1.put("user_id", (Object)user_id);
                        data1.put("img_key", (Object)image_key);
                        dataRequest1.setData(data1);
                        DataResponse dataResponse1 = this.snsUploadImg(dataRequest1);
                        if (!dataResponse1.getStatus().equals((Object)Status.SUCCESS)) return dataResponse1;
                        JSONObject upload_info = dataResponse1.getData().getJSONObject("message").getJSONObject("upload_info");
                        pictures.add((Object)upload_info.getString("big_url"));
                    }
                    data.put("pictures", (Object)pictures);
                    dataRequest.setData(data);
                    dataResponse = this.snsPublishPicture(dataRequest);
                } else if ("3".equals(material_type) || "4".equals(material_type)) {
                    JSONArray pictures = new JSONArray();
                    String image_key = "";
                    if ("3".equals(material_type)) {
                        String url = material.getMaterial_qrcode();
                        BufferedImage buffImg = QRCodeUtil.createImage((String)url, (String)"", (boolean)false);
                        ByteArrayOutputStream os = new ByteArrayOutputStream();
                        ImageIO.write((RenderedImage)buffImg, "jpg", os);
                        ByteArrayInputStream is = new ByteArrayInputStream(os.toByteArray());
                        String name = System.currentTimeMillis() + "-.jpg";
                        this.blobClient.passFileStrem("material-imgs/", material_id + "/" + name, (InputStream)is);
                        image_key = "material_imgs/" + material_id + "/" + name;
                    } else {
                        image_key = material.getMaterial_all_url();
                    }
                    DataRequest dataRequest1 = new DataRequest();
                    JSONObject data1 = new JSONObject();
                    data1.put("user_id", (Object)user_id);
                    data1.put("img_key", (Object)image_key);
                    dataRequest1.setData(data1);
                    DataResponse dataResponse1 = this.snsUploadImg(dataRequest1);
                    if (!dataResponse1.getStatus().equals((Object)Status.SUCCESS)) {
                        return dataResponse1;
                    }
                    JSONObject upload_info = dataResponse1.getData().getJSONObject("message").getJSONObject("upload_info");
                    pictures.add((Object)upload_info.getString("big_url"));
                    BasicDBObject update_query = new BasicDBObject();
                    update_query.put((Object)"material_id", (Object)material_id);
                    BasicDBObject update_item = new BasicDBObject("wechat_url", (Object)upload_info.getString("big_url"));
                    BasicDBObject update_data = new BasicDBObject("$set", (Object)update_item);
                    this.mongoTemplate.getCollection("def_material").update((DBObject)update_query, (DBObject)update_data);
                    data.put("content_desc", (Object)"");
                    data.put("pictures", (Object)pictures);
                    dataRequest.setData(data);
                    dataResponse = this.snsPublishPicture(dataRequest);
                } else {
                    if (!"5".equals(material_type)) return new DataResponse().setStatus(Status.FAILED).setCode("-1").setMsg("\u7d20\u6750\u7c7b\u578b\u4e0d\u652f\u6301\u53d1\u5e03\u670b\u53cb\u5708");
                    String image_url = "";
                    if (material.getMedia().size() <= 0) {
                        if (StringUtils.isNotNull((Object)material.getArticle_image_url())) {
                            image_url = material.getArticle_image_url();
                        } else {
                            String material_content = material.getMaterial_content();
                            Matcher m = Pattern.compile("\\bsrc\\b\\s*=\\s*[\\'\\\"]?([^\\'\\\"]*)[\\'\\\"]?").matcher(material_content);
                            if (m.find()) {
                                image_url = m.group(1);
                            }
                        }
                        if (StringUtils.isNotNull((Object)image_url)) {
                            DataRequest dataRequest1 = new DataRequest();
                            JSONObject data1 = new JSONObject();
                            data1.put("user_id", (Object)user_id);
                            data1.put("img_key", (Object)image_url);
                            dataRequest1.setData(data1);
                            DataResponse dataResponse1 = this.snsUploadImg(dataRequest1);
                            if (!dataResponse1.getStatus().equals((Object)Status.SUCCESS)) return dataResponse1;
                            JSONObject upload_info = dataResponse1.getData().getJSONObject("message").getJSONObject("upload_info");
                            image_url = upload_info.getString("big_url");
                            BasicDBObject update_query = new BasicDBObject();
                            update_query.put((Object)"material_id", (Object)material_id);
                            JSONArray media = new JSONArray();
                            media.add((Object)image_url);
                            BasicDBObject update_item = new BasicDBObject("media", (Object)media);
                            BasicDBObject update_data = new BasicDBObject("$set", (Object)update_item);
                            this.mongoTemplate.getCollection("def_material").update((DBObject)update_query, (DBObject)update_data);
                        }
                    } else {
                        image_url = material.getMedia().getString(0);
                    }
                    String material_url = material.getArticle_url() != null ? material.getArticle_url() : this.domain + "/m/share/article.html?id=" + material_id;
                    String material_des = material.getMaterial_des() != null ? material.getMaterial_des() : "";
                    data.put("content_desc", (Object)material_des);
                    data.put("url", (Object)material_url);
                    data.put("title", (Object)material.getMaterial_name());
                    data.put("img_url", (Object)image_url);
                    dataRequest.setData(data);
                    dataResponse = this.snsPublishLink(dataRequest);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return new DataResponse().setStatus(Status.FAILED).setCode("-1").setMsg(e.getLocalizedMessage());
        }
        log.info("=====\u53d1\u5e03\u670b\u53cb\u5708\u63a5\u53e3===" + dataRequest.toString());
        if (!dataResponse.getStatus().equals((Object)Status.SUCCESS)) return dataResponse;
        LogWechatMoments logWechatMoments = new LogWechatMoments();
        logWechatMoments.setCreator(user_id);
        logWechatMoments.setUser_id(user_id);
        logWechatMoments.setCreated_time(TimeUtils.getTime((long)System.currentTimeMillis()));
        logWechatMoments.setMaterial_id(material_id);
        logWechatMoments.setMaterial_type(material_type);
        logWechatMoments.setStatus("SUCCESS");
        logWechatMoments.setContent(dataResponse.getData().getJSONObject("message").getJSONObject("publish_info"));
        this.mongoTemplate.insert((Object)logWechatMoments);
        return dataResponse;
    }

    private DataResponse snsPublishPicture(DataRequest dataRequest) {
        JSONObject data = dataRequest.getData();
        String user_id = data.getString("user_id");
        String content_desc = data.getString("content_desc");
        JSONArray pictures_o = data.getJSONArray("pictures");
        JSONArray pictures = new JSONArray();
        for (int i = 0; i < pictures_o.size(); ++i) {
            String picture = pictures_o.getString(i);
            picture = picture.substring(0, picture.length() - 1);
            pictures.add((Object)picture);
        }
        Query query_ = new Query();
        query_.addCriteria((CriteriaDefinition)Criteria.where((String)"user_id").is((Object)user_id));
        User user_ = (User)this.mongoTemplate.findOne(query_, User.class);
        String port = UserPortUtils.getUserPort((String)user_.getPort());
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("user_id", (Object)user_id);
        jsonObject.put("content_desc", (Object)content_desc);
        jsonObject.put("pictures", (Object)pictures);
        String result = "";
        try {
            result = NetWorkCommon.commonwx((JSONObject)jsonObject, (String)"/user/snsPublishPicture", (String)port);
            log.info("-snsPublishPicture--" + result);
            JSONObject object = JSONObject.parseObject((String)result);
            if (object.containsKey((Object)"status")) {
                log.info("---\u6210\u529f----" + object);
                if ("SUCCESS".equals(object.getString("status"))) {
                    jsonObject.put("message", (Object)JSONObject.parseObject((String)result).getJSONObject("data"));
                    return new DataResponse().setStatus(Status.SUCCESS).setCode("0").setData(jsonObject);
                }
                String msg = object.getString("msg");
                if (StringUtils.isNull((Object)msg)) {
                    msg = "\u53d1\u5e03\u670b\u53cb\u5708\u5931\u8d25";
                }
                return new DataResponse().setStatus(Status.FAILED).setCode("-1").setMsg(msg);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            log.info((Object)e, (Throwable)e);
        }
        return new DataResponse().setStatus(Status.FAILED).setMsg(result);
    }

    private DataResponse snsPublishLink(DataRequest dataRequest) {
        JSONObject data = dataRequest.getData();
        String user_id = data.getString("user_id");
        String img_url = data.getString("img_url");
        if (StringUtils.isNotNull((Object)img_url)) {
            img_url = img_url.substring(0, img_url.length() - 1);
            data.put("img_url", (Object)img_url);
        }
        Query query_ = new Query();
        query_.addCriteria((CriteriaDefinition)Criteria.where((String)"user_id").is((Object)user_id));
        User user_ = (User)this.mongoTemplate.findOne(query_, User.class);
        String port = UserPortUtils.getUserPort((String)user_.getPort());
        String result = "";
        try {
            result = NetWorkCommon.commonwx((JSONObject)data, (String)"/user/snsPublishLink", (String)port);
            log.info("-snsPublishLink--" + result);
            JSONObject object = JSONObject.parseObject((String)result);
            if (object.containsKey((Object)"status")) {
                log.info("---\u6210\u529f----" + object);
                if ("SUCCESS".equals(object.getString("status"))) {
                    data.put("message", (Object)JSONObject.parseObject((String)result).getJSONObject("data"));
                    return new DataResponse().setStatus(Status.SUCCESS).setCode("0").setData(data);
                }
                String msg = object.getString("msg");
                if (StringUtils.isNull((Object)msg)) {
                    msg = "\u53d1\u5e03\u670b\u53cb\u5708\u5931\u8d25";
                }
                return new DataResponse().setStatus(Status.FAILED).setCode("-1").setMsg(msg);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            log.info((Object)e, (Throwable)e);
        }
        return new DataResponse().setStatus(Status.FAILED).setMsg(result);
    }

    private DataResponse snsPublish(DataRequest dataRequest) {
        JSONObject data = dataRequest.getData();
        String user_id = data.getString("user_id");
        String content = data.getString("content");
        Query query_ = new Query();
        query_.addCriteria((CriteriaDefinition)Criteria.where((String)"user_id").is((Object)user_id));
        User user_ = (User)this.mongoTemplate.findOne(query_, User.class);
        String port = UserPortUtils.getUserPort((String)user_.getPort());
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("user_id", (Object)user_id);
        jsonObject.put("content", (Object)content);
        String result = "";
        try {
            result = NetWorkCommon.commonwx((JSONObject)jsonObject, (String)"/user/snsPublish", (String)port);
            log.info("-snsPublish--" + result);
            JSONObject object = JSONObject.parseObject((String)result);
            if (object.containsKey((Object)"status")) {
                log.info("---\u6210\u529f----" + object);
                if ("SUCCESS".equals(object.getString("status"))) {
                    jsonObject.put("message", (Object)JSONObject.parseObject((String)result).getJSONObject("data"));
                    return new DataResponse().setStatus(Status.SUCCESS).setCode("0").setData(jsonObject);
                }
                String msg = object.getString("msg");
                if (StringUtils.isNull((Object)msg)) {
                    msg = "\u53d1\u5e03\u670b\u53cb\u5708\u5931\u8d25";
                }
                if (NotOnline.equals(msg)) {
                    msg = "\u5f53\u524d\u5fae\u4fe1\u6682\u672a\u7ed1\u5b9a";
                }
                return new DataResponse().setStatus(Status.FAILED).setCode("-1").setMsg(msg);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            log.info((Object)e, (Throwable)e);
        }
        return new DataResponse().setStatus(Status.FAILED).setMsg(result);
    }

    public DataResponse snsRemove(DataRequest dataRequest) {
        JSONObject data = dataRequest.getData();
        String user_id = data.getString("user_id");
        String content_id = data.getString("content_id");
        Query query_ = new Query();
        query_.addCriteria((CriteriaDefinition)Criteria.where((String)"user_id").is((Object)user_id));
        User user_ = (User)this.mongoTemplate.findOne(query_, User.class);
        String port = UserPortUtils.getUserPort((String)user_.getPort());
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("user_id", (Object)user_id);
        jsonObject.put("content_id", (Object)content_id);
        String result = "";
        try {
            result = NetWorkCommon.commonwx((JSONObject)jsonObject, (String)"/user/snsRemove", (String)port);
            log.info("-snsRemove--" + result);
            JSONObject object = JSONObject.parseObject((String)result);
            if (object.containsKey((Object)"status")) {
                log.info("---\u6210\u529f----" + object);
                if ("SUCCESS".equals(object.getString("status"))) {
                    jsonObject.put("message", (Object)JSONObject.parseObject((String)result).getJSONObject("data"));
                    return new DataResponse().setStatus(Status.SUCCESS).setCode("0").setData(jsonObject);
                }
                String msg = object.getString("msg");
                if (StringUtils.isNull((Object)msg)) {
                    msg = "\u5220\u9664\u5931\u8d25";
                }
                if (NotOnline.equals(msg)) {
                    msg = "\u5f53\u524d\u5fae\u4fe1\u6682\u672a\u7ed1\u5b9a";
                }
                return new DataResponse().setStatus(Status.FAILED).setCode("-1").setMsg(msg);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            log.info((Object)e, (Throwable)e);
        }
        return new DataResponse().setStatus(Status.FAILED).setMsg(result);
    }

    public DataResponse getOnlineUsers(DataRequest dataRequest) {
        try {
            ArrayList<String> user_ids = new ArrayList<String>();
            String result = NetWorkCommon.commonwx((JSONObject)new JSONObject(), (String)"/sys/info", (String)"8080");
            JSONObject object = JSONObject.parseObject((String)result);
            if (object.containsKey((Object)"status")) {
                if ("SUCCESS".equals(object.getString("status"))) {
                    JSONObject jsonObject = object.getJSONObject("data");
                    JSONArray total_user_list = jsonObject.getJSONArray("total_user_list");
                    for (int i = 0; i < total_user_list.size(); ++i) {
                        if (!total_user_list.getJSONObject(i).getBoolean("is_online").booleanValue()) continue;
                        user_ids.add(total_user_list.getJSONObject(i).getString("user_id"));
                    }
                    JSONObject data = new JSONObject();
                    data.put("message", user_ids);
                    log.info("---------" + data);
                    return new DataResponse().setStatus(Status.SUCCESS).setCode("0").setData(data);
                }
                return new DataResponse().setStatus(Status.FAILED).setMsg(result);
            }
            return new DataResponse().setStatus(Status.FAILED).setMsg(result);
        }
        catch (Exception e) {
            e.printStackTrace();
            return new DataResponse().setStatus(Status.FAILED).setMsg(e.getLocalizedMessage());
        }
    }

    public DataResponse getUserQrcode(DataRequest dataRequest) {
        JSONObject data = dataRequest.getData();
        String userId = data.getString("user_id");
        String storeUserId = data.getString("store_user_id");
        JSONObject jsonObject = new JSONObject();
        if (StringUtils.isNotNull((Object)storeUserId)) {
            jsonObject.put("user_id", (Object)storeUserId);
        } else {
            jsonObject.put("user_id", (Object)userId);
        }
        return this.wechatAgent.callRest(new DataRequest().setData(jsonObject), "/wxAuth/getUserQrcode");
    }

    public String acceptMessage(JSONObject request) {
        User user;
        JSONObject post_param = request.getJSONObject("post_param");
        log.info("--post_param--" + post_param);
        String Event = post_param.getString("Event");
        String PicUrl = post_param.getString("PicUrl");
        String Content = post_param.getString("Content");
        String ToUserName = post_param.getString("ToUserName");
        String miniOpenId = post_param.getString("FromUserName");
        String MsgType = post_param.getString("MsgType");
        String message_type = "";
        String message_content = "";
        if ("user_enter_tempsession".equals(Event)) {
            return "SUCCESS";
        }
        if ("image".equals(MsgType.toLowerCase())) {
            message_type = "Picture";
            message_content = PicUrl;
        } else if ("text".equals(MsgType.toLowerCase())) {
            message_type = "Text";
            message_content = Content;
        } else {
            this.mongoTemplate.insert((Object)post_param, "log_chat_user");
            return "SUCCESS";
        }
        String corp_code = "";
        Corp corp = (Corp)this.mongoTemplate.findOne(Query.query((CriteriaDefinition)Criteria.where((String)"gh").is((Object)ToUserName)), Corp.class);
        if (null != corp) {
            corp_code = corp.getCorp_code();
        }
        String message_direction = "0";
        String MsgId = post_param.getString("MsgId");
        JSONObject pusToUser = new JSONObject();
        Vip vip = (Vip)this.mongoTemplate.findOne(Query.query((CriteriaDefinition)Criteria.where((String)"mini_openid").is((Object)miniOpenId)), Vip.class);
        if (null == vip) {
            return "SUCCESS";
        }
        String user_id = "";
        String chat_user_id = vip.getChat_user_id();
        String bing_user_id = vip.getUser_id();
        if (StringUtils.isNotNull((Object)chat_user_id)) {
            user_id = chat_user_id;
        } else if (StringUtils.isNotNull((Object)bing_user_id)) {
            user_id = bing_user_id;
        }
        if (StringUtils.isNull((Object)user_id)) {
            user = (User)this.mongoTemplate.findOne(Query.query((CriteriaDefinition)Criteria.where((String)"role_type").is((Object)"R1000").and("corp_code").is((Object)corp_code).and("is_active").is((Object)"Y")), User.class);
            user_id = null == user ? "5d5519cd5c82620c10a02c75" : user.getUser_id();
        }
        user = (User)this.mongoTemplate.findOne(Query.query((CriteriaDefinition)Criteria.where((String)"user_id").is((Object)user_id)), User.class);
        String phone = user.getPhone();
        String vip_id = vip.getVip_id();
        DataRequest pusData = new DataRequest();
        pusToUser.put("alias", (Object)phone);
        pusToUser.put("title", (Object)"\u60a8\u6709\u4e00\u6761\u65b0\u7684\u6d88\u606f");
        pusToUser.put("content", (Object)message_content);
        JSONObject extra = new JSONObject();
        extra.put("message_id", (Object)MsgId);
        extra.put("vip_id", (Object)vip_id);
        extra.put("from_self", (Object)"N");
        extra.put("is_silence", (Object)"N");
        pusToUser.put("extra", (Object)extra);
        pusToUser.put("user_id", (Object)user_id);
        pusData.setData(pusToUser);
        JSONObject message = new JSONObject();
        message.put("nick_name", (Object)vip.getVip_name());
        message.put("message_type", (Object)message_type);
        message.put("message_direction", (Object)message_direction);
        message.put("message_date", (Object)TimeUtils.getTime((long)System.currentTimeMillis()));
        message.put("head_img", (Object)vip.getHead_img());
        message.put("vip_id", (Object)vip_id);
        message.put("user_id", (Object)user_id);
        message.put("is_group_vip", (Object)"N");
        message.put("message_content", (Object)message_content);
        message.put("is_friend", (Object)"Y");
        message.put("is_read", (Object)"N");
        JSONObject last_message = new JSONObject();
        last_message.put("message_content", (Object)message_content);
        last_message.put("is_group_vip", (Object)"N");
        last_message.put("message_date", (Object)TimeUtils.getTime((long)System.currentTimeMillis()));
        last_message.put("message_type", (Object)message_type);
        last_message.put("message_direction", (Object)message_direction);
        BasicDBObject basicDBObject = new BasicDBObject();
        basicDBObject.put((Object)"last_message", (Object)last_message);
        BasicDBObject queryMessage = new BasicDBObject();
        queryMessage.put((Object)"user_id", (Object)user_id);
        queryMessage.put((Object)"vip_id", (Object)vip_id);
        BasicDBObject update = new BasicDBObject();
        update.put((Object)"$set", (Object)basicDBObject);
        long count = this.mongoTemplate.getCollection("vip_message").count((DBObject)queryMessage);
        if (count < 1L) {
            JSONObject object = new JSONObject();
            object.put("last_message", (Object)last_message);
            object.put("nick_name", (Object)vip.getVip_name());
            object.put("user_id", (Object)user_id);
            object.put("head_img", (Object)vip.getHead_img());
            object.put("vip_id", (Object)vip_id);
            object.put("modified_date", (Object)TimeUtils.getTime((long)System.currentTimeMillis()));
            this.mongoTemplate.insert((Object)object, "vip_message");
        } else {
            this.mongoTemplate.getCollection("vip_message").update((DBObject)queryMessage, (DBObject)update);
        }
        log.info("---\u65b0\u589e-from_self-true-" + count);
        this.mongoTemplate.insert((Object)message, "vip_message_content");
        this.pushService.notificationAliPush(pusData);
        this.pushService.messageAliPush(pusData);
        return "SUCCESS";
    }

    static /* synthetic */ Logger access$000() {
        return log;
    }
}

