/*
 * Decompiled with CFR 0.152.
 */
package kr.weitao.weitaokr.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import kr.weitao.business.common.agent.WechatAgent;
import kr.weitao.business.common.feignclient.MessageService;
import kr.weitao.business.entity.LogMpCode;
import kr.weitao.business.entity.QrcodeScanLog;
import kr.weitao.business.entity.activity.Activity;
import kr.weitao.business.entity.data.Material;
import kr.weitao.business.entity.data.Product;
import kr.weitao.common.exception.CommonException;
import kr.weitao.common.util.StringUtils;
import kr.weitao.common.util.TimeUtils;
import kr.weitao.common.util.UrlUtil;
import kr.weitao.starter.model.DataRequest;
import kr.weitao.starter.model.DataResponse;
import kr.weitao.starter.model.Status;
import kr.weitao.starter.util.redis.RedisClient;
import kr.weitao.weitaokr.service.VipService;
import kr.weitao.weitaokr.service.WechatOpenAuthorizer;
import kr.weitao.weitaokr.service.common.UserRedisUtils;
import kr.weitao.weitaokr.service.impl.WechatOpenAuthorizerImpl;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bson.types.ObjectId;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.stereotype.Component;

@Component
public class WechatOpenAuthorizerImpl
implements WechatOpenAuthorizer {
    private static final Logger log = LogManager.getLogger(WechatOpenAuthorizerImpl.class);
    @Value(value="${weixin.server.pay.url}")
    String order_pay_url;
    @Value(value="${weixin.server.pay.domain}")
    String order_pay_domain;
    @Value(value="${api.server.domain}")
    String server_domain;
    @Autowired
    MessageService messageService;
    @Autowired
    MongoTemplate mongoTemplate;
    @Autowired
    UserRedisUtils userRedisUtils;
    @Autowired
    VipService vipService;
    @Autowired
    WechatAgent wechatAgent;
    @Autowired
    RedisClient redisClient;

    public DataResponse noticeUser(JSONObject param) {
        DataRequest drq;
        log.info("--noticeUser--" + param);
        DataResponse dataResponse = new DataResponse();
        String user_id = param.getString("user_id");
        String product_url = "";
        String time = TimeUtils.getTime((long)System.currentTimeMillis());
        String product_id = param.getString("product_id");
        String material_id = param.getString("material_id");
        String activity_id = param.getString("activity_id");
        String article_id = param.getString("article_id");
        String content = param.getString("content");
        String cardno = "";
        String userName = "";
        if (StringUtils.isNotNull((Object)param.get((Object)"open_id"))) {
            DataRequest dataRequest = new DataRequest().setData(param);
            DataResponse dataResponse1 = this.vipService.JnbyVipQuery(dataRequest);
            if (!"SUCCESS".equals(dataResponse1.getStatus().toString())) {
                return dataResponse;
            }
            JSONObject jsonObject = dataResponse1.getData();
            JSONArray array = jsonObject.getJSONArray("vipList");
            if (array.size() == 0) {
                return dataResponse;
            }
            JSONObject vip = array.getJSONObject(0);
            cardno = vip.getString("cardNo");
            userName = vip.getString("nickName");
        }
        JSONObject data = new JSONObject();
        data.put("user_id", (Object)user_id);
        JSONObject message_content = new JSONObject();
        if (StringUtils.isNotNull((Object)material_id) || StringUtils.isNotNull((Object)product_id) || StringUtils.isNotNull((Object)activity_id)) {
            Product product;
            Activity activity;
            String name;
            Material material;
            if (StringUtils.isNotNull((Object)cardno)) {
                if (StringUtils.isNotNull((Object)material_id)) {
                    material = (Material)this.mongoTemplate.findOne(Query.query((CriteriaDefinition)Criteria.where((String)"material_id").is((Object)material_id)), Material.class);
                    name = material.getMaterial_name();
                    if (StringUtils.isNotNull((Object)article_id)) {
                        message_content.put("content", (Object)("\u7528\u6237\uff1a" + userName + "\uff08\u5361\u53f7\uff1a" + cardno + ") \u4e8e " + time + " \u67e5\u770b\u4e86\u60a8\u5206\u4eab\u7684<" + name + ">\u7d20\u6750\u8f6f\u6587"));
                    } else {
                        if (!product_url.contains("material_id")) {
                            product_url = product_url + "?material_id=" + material_id;
                        }
                        message_content.put("content", (Object)("\u7528\u6237\uff1a" + userName + "\uff08\u5361\u53f7\uff1a" + cardno + ") \u4e8e " + time + " \u67e5\u770b\u4e86\u60a8\u5206\u4eab\u7684<" + name + ">\u7d20\u6750"));
                    }
                }
                if (StringUtils.isNotNull((Object)activity_id)) {
                    activity = (Activity)this.mongoTemplate.findOne(Query.query((CriteriaDefinition)Criteria.where((String)"activity_id").is((Object)activity_id)), Activity.class);
                    name = activity.getActivity_theme();
                    message_content.put("content", (Object)("\u7528\u6237\uff1a" + userName + "\uff08\u5361\u53f7\uff1a" + cardno + ") \u4e8e " + time + " \u67e5\u770b\u4e86\u60a8\u5206\u4eab\u7684<" + name + ">\u6d3b\u52a8"));
                }
                if (StringUtils.isNotNull((Object)product_id) && StringUtils.isNull((Object)material_id)) {
                    product = (Product)this.mongoTemplate.findOne(Query.query((CriteriaDefinition)Criteria.where((String)"product_id").is((Object)product_id)), Product.class);
                    name = product.getProduct_name();
                    message_content.put("content", (Object)("\u7528\u6237\uff1a" + userName + "\uff08\u5361\u53f7\uff1a" + cardno + ") \u4e8e " + time + " \u67e5\u770b\u4e86\u60a8\u5206\u4eab\u7684<" + name + ">\u5546\u54c1"));
                }
            } else {
                if (StringUtils.isNotNull((Object)material_id)) {
                    material = (Material)this.mongoTemplate.findOne(Query.query((CriteriaDefinition)Criteria.where((String)"material_id").is((Object)material_id)), Material.class);
                    name = material.getMaterial_name();
                    if (StringUtils.isNotNull((Object)article_id)) {
                        message_content.put("content", (Object)("\u7528\u6237\uff1a" + userName + "\uff08\u5361\u53f7\uff1a" + cardno + ") \u4e8e " + time + " \u67e5\u770b\u4e86\u60a8\u5206\u4eab\u7684<" + name + ">\u7d20\u6750\u8f6f\u6587"));
                    } else {
                        if (!product_url.contains("material_id")) {
                            product_url = product_url + "?material_id=" + material_id;
                        }
                        message_content.put("content", (Object)("\u7528\u6237\uff1a" + userName + "\uff08\u5361\u53f7\uff1a" + cardno + ") \u4e8e " + time + " \u67e5\u770b\u4e86\u60a8\u5206\u4eab\u7684<" + name + ">\u7d20\u6750"));
                    }
                }
                if (StringUtils.isNotNull((Object)activity_id)) {
                    activity = (Activity)this.mongoTemplate.findOne(Query.query((CriteriaDefinition)Criteria.where((String)"activity_id").is((Object)activity_id)), Activity.class);
                    name = activity.getActivity_theme();
                    message_content.put("content", (Object)("\u7528\u6237\uff1a" + userName + " \u4e8e " + time + " \u67e5\u770b\u4e86\u60a8\u5206\u4eab\u7684<" + name + ">\u6d3b\u52a8"));
                }
                if (StringUtils.isNotNull((Object)product_id) && StringUtils.isNull((Object)material_id)) {
                    product = (Product)this.mongoTemplate.findOne(Query.query((CriteriaDefinition)Criteria.where((String)"product_id").is((Object)product_id)), Product.class);
                    name = product.getProduct_name();
                    message_content.put("content", (Object)("\u7528\u6237\uff1a" + userName + " \u4e8e " + time + " \u67e5\u770b\u4e86\u60a8\u5206\u4eab\u7684<" + name + ">\u5546\u54c1"));
                }
            }
            message_content.put("title", (Object)"\u6d4f\u89c8\u901a\u77e5");
            data.put("message_content", (Object)message_content);
            data.put("type", (Object)"1");
            drq = new DataRequest();
            drq.setData(data);
            dataResponse = this.messageService.getData("/sysMessage/sendMessage", drq);
        } else if (StringUtils.isNotNull((Object)content)) {
            message_content.put("content", (Object)content);
            if (StringUtils.isNull((Object)param.get((Object)"title"))) {
                message_content.put("title", (Object)"\u6d4f\u89c8\u901a\u77e5");
            } else {
                message_content.put("title", (Object)param.getString("title"));
            }
            data.put("message_content", (Object)message_content);
            data.put("type", (Object)"1");
            drq = new DataRequest();
            drq.setData(data);
            dataResponse = this.messageService.getData("/sysMessage/sendMessage", drq);
        }
        return dataResponse;
    }

    public DataResponse noticeUserV2(JSONObject param) {
        log.info("--noticeUserV2--" + param);
        DataResponse dataResponse = new DataResponse();
        String user_id = param.getString("user_id");
        String product_url = "";
        String time = TimeUtils.getTime((long)System.currentTimeMillis());
        String product_id = param.getString("product_id");
        String material_id = param.getString("material_id");
        String activity_id = param.getString("activity_id");
        DataRequest dataRequest = new DataRequest().setData(param);
        DataResponse dataResponse1 = this.vipService.searchVipByOpenId(dataRequest);
        String userName = "";
        if (!"SUCCESS".equals(dataResponse1.getStatus().toString())) {
            return dataResponse;
        }
        userName = dataResponse1.getData().getString("nick_name");
        if (StringUtils.isNotNull((Object)material_id) || StringUtils.isNotNull((Object)product_id) || StringUtils.isNotNull((Object)activity_id)) {
            String name;
            JSONObject data = new JSONObject();
            data.put("user_id", (Object)user_id);
            JSONObject message_content = new JSONObject();
            if (StringUtils.isNotNull((Object)material_id)) {
                Material material = (Material)this.mongoTemplate.findOne(Query.query((CriteriaDefinition)Criteria.where((String)"material_id").is((Object)material_id)), Material.class);
                name = material.getMaterial_name();
                message_content.put("content", (Object)("\u7528\u6237\uff1a" + userName + " \u4e8e " + time + " \u67e5\u770b\u4e86\u60a8\u5206\u4eab\u7684<" + name + ">\u7d20\u6750"));
            }
            if (StringUtils.isNotNull((Object)activity_id)) {
                Activity activity = (Activity)this.mongoTemplate.findOne(Query.query((CriteriaDefinition)Criteria.where((String)"activity_id").is((Object)activity_id)), Activity.class);
                name = activity.getActivity_theme();
                message_content.put("content", (Object)("\u7528\u6237\uff1a" + userName + " \u4e8e " + time + " \u67e5\u770b\u4e86\u60a8\u5206\u4eab\u7684<" + name + ">\u6d3b\u52a8"));
            }
            if (StringUtils.isNotNull((Object)product_id) && StringUtils.isNull((Object)material_id)) {
                Product product = (Product)this.mongoTemplate.findOne(Query.query((CriteriaDefinition)Criteria.where((String)"product_id").is((Object)product_id)), Product.class);
                name = product.getProduct_name();
                message_content.put("content", (Object)("\u7528\u6237\uff1a" + userName + " \u4e8e " + time + " \u67e5\u770b\u4e86\u60a8\u5206\u4eab\u7684<" + name + ">\u5546\u54c1"));
            }
            message_content.put("title", (Object)"\u6d4f\u89c8\u901a\u77e5");
            message_content.put("url", (Object)product_url);
            data.put("message_content", (Object)message_content);
            data.put("type", (Object)"1");
            DataRequest drq = new DataRequest();
            drq.setData(data);
            dataResponse = this.messageService.getData("/sysMessage/sendMessage", drq);
        }
        return dataResponse;
    }

    public JSONObject dispose(JSONObject param) {
        BasicDBObject update;
        JSONObject object;
        DataResponse dataResponse = new DataResponse();
        JSONObject data = param;
        UrlUtil urlUtil = new UrlUtil();
        log.info("---WechatOpenAuthorizerImpl--data--" + data);
        String open_id = data.getString("open_id");
        String unionid = data.getString("unionid");
        String app_id = data.getString("app_id");
        String product_url = urlUtil.urlCheck(data.getString("product_url"));
        String query_url = data.getString("url");
        String state = data.getString("state");
        String user_id = data.getString("user_id");
        String material_id = data.getString("material_id");
        String team_id = data.getString("team_id");
        String product_id = data.getString("product_id");
        String url = "";
        BasicDBObject query = new BasicDBObject();
        query.put((Object)"user_id", (Object)user_id);
        DBObject ueser = this.mongoTemplate.getCollection("def_user").findOne((DBObject)query);
        String store_id = "";
        store_id = null != ueser ? (StringUtils.isNull((Object)StringUtils.valueOf((Object)ueser.get("store_id"))) ? "1234" : StringUtils.valueOf((Object)ueser.get("store_id"))) : "1234";
        if (query_url.contains("order_id")) {
            url = this.order_pay_url;
            StringBuffer url_sb = new StringBuffer(this.order_pay_domain).append(this.order_pay_url);
            if (StringUtils.isNull((Object)query_url)) {
                url_sb.append("?openid=").append(open_id);
            } else {
                url_sb.append("?").append(query_url).append("&openid=").append(open_id);
            }
            url = url_sb.toString();
        } else if (StringUtils.isNotNull((Object)data.getString("material_id"))) {
            log.info("---\u7d20\u6750\u5206\u4eab--");
            object = new JSONObject();
            object.put("open_id", (Object)open_id);
            object.put("app_id", (Object)app_id);
            update = new BasicDBObject();
            BasicDBObject basicDBObject = new BasicDBObject();
            basicDBObject.put((Object)"openList", (Object)object);
            update.put((Object)"$addToSet", (Object)basicDBObject);
            this.mongoTemplate.getCollection("def_user_open_id").update((DBObject)query, (DBObject)update, true, true);
            url = product_url;
            if (StringUtils.isNotNull((Object)product_id)) {
                BasicDBObject dbObject = new BasicDBObject();
                dbObject.put((Object)"material_id", (Object)material_id);
                BasicDBObject dbObject1 = new BasicDBObject();
                dbObject1.put((Object)"image_url", (Object)"1");
                DBObject object1 = this.mongoTemplate.getCollection("def_material").findOne((DBObject)dbObject, (DBObject)dbObject1);
                if (null == object1) {
                    throw new CommonException("\u5bf9\u5e94\u7d20\u6750\u4e0d\u5b58\u5728");
                }
                if (StringUtils.isNotNull((Object)object1.get("image_url"))) {
                    JSONArray array = JSONArray.parseArray((String)object1.get("image_url").toString());
                    for (int i = 0; i < array.size(); ++i) {
                        JSONObject jsonObject = array.getJSONObject(i);
                        if (!jsonObject.containsValue((Object)product_id)) continue;
                        url = urlUtil.urlCheck(jsonObject.getString("product_url"));
                    }
                }
                StringBuffer url_sb = new StringBuffer(url);
                if (url.indexOf("?") > 0) {
                    url_sb.append("&ropenid=").append(open_id).append("&runionid=").append(unionid).append("&appid=").append(app_id).append("&productId=").append(product_id);
                } else {
                    url_sb.append("?").append("&ropenid=").append(open_id).append("&runionid=").append(unionid).append("&appid=").append(app_id).append("&productId=").append(product_id);
                }
                url = url_sb.toString();
            } else if (StringUtils.isNotNull((Object)data.getString("article_id"))) {
                Material material = (Material)this.mongoTemplate.findOne(Query.query((CriteriaDefinition)Criteria.where((String)"material_id").is((Object)material_id)), Material.class);
                String article_id = data.getString("article_id");
                JSONObject user = this.userRedisUtils.getUser(user_id, false);
                JSONArray articles = material.getArticles();
                for (int i = 0; i < articles.size(); ++i) {
                    JSONObject article = articles.getJSONObject(i);
                    if (!article.getString("article_id").equals(article_id)) continue;
                    if (StringUtils.isNotNull((Object)user.getString("qrcode")) && "Y".equals(article.getString("is_show_qrcode"))) {
                        JSONObject data_c = new JSONObject();
                        data_c.put("app_id", (Object)app_id);
                        data_c.put("open_id", (Object)open_id);
                        DataResponse response = this.checkFansExist(data_c);
                        if (!response.getStatus().equals((Object)"SUCCESS") || !StringUtils.isNotNull((Object)article.getString("wechat_url"))) break;
                        url = article.getString("wechat_url");
                        break;
                    }
                    if (!StringUtils.isNotNull((Object)article.getString("wechat_url"))) break;
                    url = article.getString("wechat_url");
                    break;
                }
                try {
                    1 checkVip = new /* Unavailable Anonymous Inner Class!! */;
                    Thread thread = new Thread((Runnable)checkVip);
                    thread.start();
                }
                catch (Exception e) {
                    log.error("redirect material:" + material_id + " check vip error:" + e.getLocalizedMessage(), (Throwable)e);
                }
            }
            StringBuffer url_sb = new StringBuffer(url);
            if (url.indexOf("?") > 0) {
                url_sb.append("&openId=").append(open_id).append("&appId=").append(app_id);
            } else {
                url_sb.append("?").append("&openId=").append(open_id).append("&appId=").append(app_id);
            }
            url = url_sb.toString();
            try {
                2 saveScanLog = new /* Unavailable Anonymous Inner Class!! */;
                Thread thread = new Thread((Runnable)saveScanLog);
                thread.start();
            }
            catch (Exception saveScanLog) {}
        } else if (data.containsKey((Object)"product_id") && !data.containsKey((Object)"material_id")) {
            Product product;
            object = new JSONObject();
            object.put("open_id", (Object)open_id);
            object.put("app_id", (Object)app_id);
            update = new BasicDBObject();
            BasicDBObject basicDBObject = new BasicDBObject();
            basicDBObject.put((Object)"openList", (Object)object);
            update.put((Object)"$addToSet", (Object)basicDBObject);
            this.mongoTemplate.getCollection("def_user_open_id").update((DBObject)query, (DBObject)update, true, true);
            url = product_url;
            log.debug("-----\u5546\u54c1\u5206\u4eab----" + url);
            if (StringUtils.isNotNull((Object)product_id) && (product = (Product)this.mongoTemplate.findOne(new Query().addCriteria((CriteriaDefinition)Criteria.where((String)"product_id").is((Object)product_id)), Product.class)) != null) {
                try {
                    JSONObject jsonObject;
                    JSONArray productUrl = product.getProduct_url();
                    log.debug("---productUrl-" + productUrl);
                    if (null != productUrl && productUrl.size() > 0 && (jsonObject = productUrl.getJSONObject(0)).containsKey((Object)"url")) {
                        url = jsonObject.getString("url");
                    }
                    3 saveScanLog = new /* Unavailable Anonymous Inner Class!! */;
                    Thread thread = new Thread((Runnable)saveScanLog);
                    thread.start();
                }
                catch (Exception e) {
                    url = product_url;
                }
            }
            StringBuffer url_sb = new StringBuffer(url);
            if (url.indexOf("?") > 0) {
                url_sb.append("&ropenid=").append(open_id).append("&runionid=").append(unionid).append("&appid=").append(app_id).append("&productId=").append(product_id);
            } else {
                url_sb.append("?").append("&ropenid=").append(open_id).append("&runionid=").append(unionid).append("&appid=").append(app_id).append("&productId=").append(product_id);
            }
            url = url_sb.toString();
        }
        String emp_id = user_id;
        log.debug("-----url----" + url);
        if (StringUtils.isNotNull((Object)url)) {
            StringBuffer url_sb = new StringBuffer(url);
            if (url.indexOf("?") > 0) {
                url_sb.append("&empId=").append(user_id).append("&storecode=").append("&storeId=").append(store_id);
            } else {
                url_sb.append("?").append("empId=").append(user_id).append("&storecode=").append("&storeId=").append(store_id);
            }
            if (StringUtils.isNotNull((Object)team_id)) {
                emp_id = emp_id + "@" + team_id;
                if (url.indexOf("?") > 0) {
                    url_sb.append("&teamId=").append(team_id);
                } else {
                    url_sb.append("?").append("&teamId=").append(team_id);
                }
            }
            url_sb.append("&emp_id=").append(emp_id);
            url = url_sb.toString();
        }
        log.debug("---\u5206\u4eab--url----" + url);
        if (url.contains("http://www.luolai.cn/")) {
            url = url.replace("http://www.luolai.cn/", "http://www.luolai.cn/wap/");
        }
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("url", (Object)url);
        log.info((Object)jsonObject);
        return jsonObject;
    }

    public DataResponse checkFansExist(JSONObject data) {
        String open_id = data.getString("open_id");
        String app_id = data.getString("app_id");
        if (StringUtils.isNull((Object)open_id) || StringUtils.isNull((Object)app_id)) {
            return new DataResponse().setCode("-1").setStatus(Status.FAILED).setMsg("N");
        }
        BasicDBObject query = new BasicDBObject();
        query.put((Object)"open_id", (Object)open_id);
        query.put((Object)"app_id", (Object)app_id);
        DBObject fans = this.mongoTemplate.getCollection("log_fans").findOne((DBObject)query);
        if (fans == null) {
            return new DataResponse().setCode("-1").setStatus(Status.FAILED).setMsg("N");
        }
        return new DataResponse().setCode("0").setStatus(Status.SUCCESS).setMsg("Y");
    }

    private void saveScanLog(JSONObject param, Product product, String material_id) {
        QrcodeScanLog scanLog = new QrcodeScanLog();
        scanLog.setCreated_time(TimeUtils.getTime((long)System.currentTimeMillis()));
        scanLog.setOpen_id(param.getString("open_id"));
        scanLog.setApp_id(param.getString("app_id"));
        scanLog.setTeam_id(param.getString("team_id"));
        scanLog.setUser_id(param.getString("user_id"));
        scanLog.setType(param.getString("state"));
        JSONObject m_param = new JSONObject();
        if (StringUtils.isNotNull((Object)product)) {
            m_param.put("product_id", (Object)product.getProduct_id());
            m_param.put("product_name", (Object)product.getProduct_name());
            m_param.put("product_price", (Object)product.getProduct_price());
            m_param.put("corp_code", (Object)product.getCorp_code());
            m_param.put("brand_name", (Object)product.getBrand_name());
        } else if (StringUtils.isNotNull((Object)material_id)) {
            m_param.put("material_id", (Object)material_id);
            Query query1 = new Query().addCriteria((CriteriaDefinition)Criteria.where((String)"material_id").is((Object)material_id));
            Material material = (Material)this.mongoTemplate.findOne(query1, Material.class);
            String brand_name = "";
            if (material != null) {
                m_param.put("material_name", (Object)material.getMaterial_name());
                m_param.put("material_type", (Object)material.getMaterial_type());
                m_param.put("corp_code", (Object)material.getCorp_code());
                if ("2".equals(material.getMaterial_type())) {
                    JSONArray image_url = material.getImage_url();
                    for (int i = 0; i < image_url.size(); ++i) {
                        if (!StringUtils.isNotNull((Object)image_url.getJSONObject(i).getString("brand_name"))) continue;
                        brand_name = image_url.getJSONObject(i).getString("brand_name");
                        break;
                    }
                }
                m_param.put("brand_name", (Object)brand_name);
            }
        }
        scanLog.setParam(m_param);
        this.mongoTemplate.insert((Object)scanLog);
    }

    public JSONObject getMpCode(JSONObject data) {
        String userId = data.getString("user_id");
        String miniAppid = data.getString("mini_appid");
        String productId = data.getString("product_id");
        String activityId = data.getString("activity_id");
        String materialId = data.getString("material_id");
        String orderId = data.getString("order_id");
        String is_invitation = data.getString("is_invitation");
        String share_open_id = null != data.getString("share_open_id") ? data.getString("share_open_id") : data.getString("share_openid");
        String taskId = data.getString("task_id");
        String vipId = data.getString("vip_id");
        String url = data.getString("url");
        if (StringUtils.isNull((Object)miniAppid) && StringUtils.isNotNull((Object)userId)) {
            JSONObject user = this.userRedisUtils.getUser(userId, false);
            String corp_code = user.getString("corp_code");
            BasicDBObject query = new BasicDBObject();
            query.put((Object)"corp_code", (Object)corp_code);
            DBObject object = this.mongoTemplate.getCollection("def_corp").findOne((DBObject)query);
            miniAppid = object.get("mini_appid").toString();
        }
        JSONObject sceneValue = new JSONObject();
        if (StringUtils.isNotNull((Object)userId)) {
            sceneValue.put("s_uid", (Object)userId);
        }
        if (StringUtils.isNotNull((Object)vipId)) {
            sceneValue.put("s_vid", (Object)vipId);
        }
        if (StringUtils.isNotNull((Object)productId)) {
            sceneValue.put("product_id", (Object)productId);
            if (StringUtils.isNull((Object)url)) {
                url = "pages/goods_detail";
            }
        }
        if (StringUtils.isNotNull((Object)materialId)) {
            sceneValue.put("material_id", (Object)materialId);
            if (StringUtils.isNull((Object)url)) {
                url = "pages/goods_detail";
            }
        }
        if (StringUtils.isNotNull((Object)share_open_id)) {
            sceneValue.put("share_open_id", (Object)share_open_id);
            if (StringUtils.isNull((Object)url)) {
                url = "pages/joinUs/index";
            }
        }
        if (StringUtils.isNotNull((Object)is_invitation)) {
            sceneValue.put("is_invitation", (Object)"Y");
            if (StringUtils.isNull((Object)url)) {
                url = "pages/home/index";
            }
        }
        if (StringUtils.isNotNull((Object)activityId)) {
            sceneValue.put("activity_id", (Object)activityId);
            if (StringUtils.isNull((Object)url)) {
                url = "pages/activity_detail";
            }
        }
        if (StringUtils.isNotNull((Object)orderId)) {
            sceneValue.put("order_id", (Object)orderId);
            if (StringUtils.isNull((Object)url)) {
                url = "pages/order/confirm";
            }
        }
        if (StringUtils.isNotNull((Object)taskId)) {
            sceneValue.put("task_id", (Object)taskId);
            if (StringUtils.isNull((Object)url)) {
                url = "pages/task_detail";
            }
        }
        LogMpCode logMpCode = null;
        if (StringUtils.isNotNull((Object)share_open_id) && StringUtils.isNull((Object)userId)) {
            logMpCode = StringUtils.isNotNull((Object)productId) ? (LogMpCode)this.mongoTemplate.findOne(Query.query((CriteriaDefinition)Criteria.where((String)"share_open_id").is((Object)share_open_id).and("ids").is((Object)productId)), LogMpCode.class) : (StringUtils.isNotNull((Object)is_invitation) ? (LogMpCode)this.mongoTemplate.findOne(Query.query((CriteriaDefinition)Criteria.where((String)"share_open_id").is((Object)share_open_id).and("type").is((Object)"inviting")), LogMpCode.class) : (LogMpCode)this.mongoTemplate.findOne(Query.query((CriteriaDefinition)Criteria.where((String)"share_open_id").is((Object)share_open_id).and("type").is((Object)"jion")), LogMpCode.class));
        }
        JSONObject result = new JSONObject();
        if (null == logMpCode) {
            logMpCode = new LogMpCode();
            logMpCode.setCreated_time(TimeUtils.getCurrentTimeInString());
            if (StringUtils.isNotNull((Object)productId)) {
                logMpCode.setType("product");
                logMpCode.setIds(productId);
                logMpCode.setShare_open_id(share_open_id);
            } else {
                if (!url.equals("pages/login/index")) {
                    logMpCode.setType("jion");
                }
                if (StringUtils.isNotNull((Object)is_invitation)) {
                    logMpCode.setType("inviting");
                }
                logMpCode.setShare_open_id(share_open_id);
            }
            logMpCode.setIs_read("N");
            JSONObject mpCodeParam = new JSONObject();
            for (String key : sceneValue.keySet()) {
                mpCodeParam.put(key, sceneValue.get((Object)key));
            }
            logMpCode.setParam(mpCodeParam);
            this.mongoTemplate.save((Object)logMpCode);
            String id = logMpCode.get_id().toString();
            Query query = new Query((CriteriaDefinition)Criteria.where((String)"_id").is((Object)new ObjectId(id)));
            log.info("----jumpUrl----" + sceneValue.toString());
            JSONObject param = new JSONObject();
            if ("jion".equals(logMpCode.getType())) {
                param.put("scene_param", (Object)share_open_id);
            } else {
                param.put("scene_param", (Object)id);
            }
            param.put("page", (Object)url);
            param.put("mini_appid", (Object)miniAppid);
            if (StringUtils.isNotNull((Object)is_invitation)) {
                param.put("is_hyaline", (Object)false);
            }
            DataRequest resu = new DataRequest();
            resu.setData(param);
            DataResponse response = this.wechatAgent.callRest(resu, "/wechat/mini/getWXACodeUnlimitImage");
            if ("SUCCESS".equals(response.getStatus().toString())) {
                JSONObject urlInfo = response.getData();
                logMpCode.setUrl(urlInfo.getString("url"));
                this.mongoTemplate.updateFirst(query, Update.update((String)"url", (Object)urlInfo.getString("url")), LogMpCode.class);
                this.redisClient.getValueOps().setValueStringWithExpire("logMpCode_" + id, JSON.toJSONString((Object)logMpCode), Long.valueOf(3600L));
                result.put("url", (Object)urlInfo.getString("url"));
            }
        } else {
            LogMpCode codeInfo;
            String id = logMpCode.get_id().toString();
            if (this.redisClient.exists("logMpCode_" + id)) {
                String codeInfoStr = this.redisClient.getValueOps().getValueString("logMpCode_" + id);
                codeInfo = (LogMpCode)JSON.parseObject((String)codeInfoStr, LogMpCode.class);
            } else {
                Query query = new Query((CriteriaDefinition)Criteria.where((String)"_id").is((Object)new ObjectId(id)));
                codeInfo = (LogMpCode)this.mongoTemplate.findOne(query, LogMpCode.class);
            }
            String urlQcode = codeInfo.getUrl();
            if (StringUtils.isNotNull((Object)urlQcode)) {
                result.put("url", (Object)urlQcode);
            }
        }
        return result;
    }

    static /* synthetic */ void access$000(WechatOpenAuthorizerImpl x0, JSONObject x1, Product x2, String x3) {
        x0.saveScanLog(x1, x2, x3);
    }
}

