/*
 * Decompiled with CFR 0.152.
 */
package kr.weitao.weitaokr.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.mongodb.AggregationOutput;
import com.mongodb.BasicDBList;
import com.mongodb.BasicDBObject;
import com.mongodb.DBCollection;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import com.mongodb.WriteResult;
import java.net.URLEncoder;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kr.weitao.business.entity.Captcha;
import kr.weitao.business.entity.LogVipOperation;
import kr.weitao.business.entity.Memorandum;
import kr.weitao.business.entity.Order;
import kr.weitao.business.entity.SysContact;
import kr.weitao.business.entity.User;
import kr.weitao.business.entity.Vip;
import kr.weitao.business.entity.VipGroup;
import kr.weitao.business.entity.coupon.Coupon;
import kr.weitao.business.entity.coupon.CouponType;
import kr.weitao.business.entity.vip.VipGrade;
import kr.weitao.business.entity.vip.VipGroupLabel;
import kr.weitao.business.entity.vip.VipLabel;
import kr.weitao.common.util.AliCDNUrlAuth;
import kr.weitao.common.util.JSONArraySortUtil;
import kr.weitao.common.util.MD5Util;
import kr.weitao.common.util.NumberUtil;
import kr.weitao.common.util.StringUtils;
import kr.weitao.common.util.TimeUtils;
import kr.weitao.starter.model.DataRequest;
import kr.weitao.starter.model.DataResponse;
import kr.weitao.starter.model.Status;
import kr.weitao.starter.util.redis.RedisClient;
import kr.weitao.weitaokr.network.NetWorkCommon;
import kr.weitao.weitaokr.service.VipService;
import kr.weitao.weitaokr.service.WechatOpenAuthorizer;
import kr.weitao.weitaokr.service.WxService;
import kr.weitao.weitaokr.service.common.SendMessage;
import kr.weitao.weitaokr.service.common.UserRedisUtils;
import kr.weitao.weitaokr.service.impl.PushServiceImpl;
import kr.weitao.weitaokr.service.impl.VipServiceImpl;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bson.types.ObjectId;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.aggregation.Aggregation;
import org.springframework.data.mongodb.core.aggregation.AggregationOperation;
import org.springframework.data.mongodb.core.aggregation.AggregationResults;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.stereotype.Service;

@Service
public class VipServiceImpl
implements VipService {
    private static final Logger log = LogManager.getLogger(VipServiceImpl.class);
    @Autowired
    MongoTemplate mongoTemplate;
    @Autowired
    WxService wxService;
    @Autowired
    UserRedisUtils userRedisUtils;
    @Autowired
    RedisClient redisClient;
    @Autowired
    WechatOpenAuthorizer wechatOpenAuthorizer;
    @Autowired
    SendMessage sendMessage;
    @Value(value="${weixin.server.pay.domain}")
    String web_server_domain;
    @Autowired
    AliCDNUrlAuth aliCDNUrlAuth;
    @Value(value="${oss.oss_domain}")
    String OSS_DOMAIN;

    public DataResponse add(DataRequest dataRequest) {
        String current = TimeUtils.getCurrentTimeInString((SimpleDateFormat)TimeUtils.DATETIME_FORMAT_DATE);
        DataResponse dataResponse = new DataResponse();
        JSONObject data = dataRequest.getData();
        String nick_name = data.getString("nick_name");
        String user_id = data.getString("user_id");
        Query query_ = new Query();
        query_.addCriteria((CriteriaDefinition)Criteria.where((String)"user_id").is((Object)user_id));
        User user_ = (User)this.mongoTemplate.findOne(query_, User.class);
        String user_wx_id = user_.getWx_id();
        String wx_id = data.getString("wx_id");
        String vip_name = data.getString("vip_name");
        String remark_name = data.getString("remark_name");
        String sex = data.getString("vip_sex");
        String head_img = data.getString("head_img");
        JSONArray address = data.getJSONArray("address_list");
        String birthday = data.getString("birthday");
        String age = data.getString("age");
        String vip_phone = data.getString("vip_phone");
        List vips = this.vipPhone(user_id, vip_phone);
        if (vips.size() > 0) {
            return new DataResponse().setStatus(Status.FAILED).setMsg("\u4f1a\u5458\u624b\u673a\u53f7\u5df2\u5b58\u5728").setData(JSONObject.parseObject((String)((Vip)vips.get(0)).toString()));
        }
        JSONArray open_id = data.getJSONArray("open_id");
        Vip vip = new Vip();
        vip.setAddress_list(address);
        vip.setU_uin(user_wx_id);
        vip.setAge(age);
        vip.setCorp_code("C10021");
        vip.setBirthday(birthday);
        vip.setCreated_date(current);
        vip.setCreator_id(user_id);
        vip.setIs_active("Y");
        vip.setHead_img(head_img);
        vip.setModified_date(current);
        vip.setNick_name(org.apache.commons.lang.StringUtils.isNotBlank((String)nick_name) ? nick_name : vip_name);
        vip.setRemark_name(remark_name);
        vip.setModifier_id(user_id);
        vip.setUser_id(user_id);
        vip.setVip_name(vip_name);
        vip.setVip_phone(vip_phone);
        vip.setVip_sex(sex);
        vip.setWx_id(wx_id);
        vip.setOpen_id(open_id);
        vip.setIs_group_vip("N");
        this.mongoTemplate.save((Object)vip);
        try {
            JSONObject dataResult = new JSONObject();
            dataResult.put("id", (Object)vip.get_id().toString());
            dataResponse.setCode("0").setData(dataResult).setStatus(Status.SUCCESS);
        }
        catch (Exception e) {
            dataResponse.setStatus(Status.FAILED).setMsg(e.getLocalizedMessage());
        }
        return dataResponse;
    }

    public DataResponse searchVipByOpenId(DataRequest dataRequest) {
        DataResponse dataResponse = new DataResponse();
        JSONObject data = dataRequest.getData();
        String user_id = data.getString("user_id");
        String open_id = data.getString("open_id");
        Query query = new Query((CriteriaDefinition)Criteria.where((String)"user_id").is((Object)user_id).and("open_id").is((Object)open_id));
        Vip vip = (Vip)this.mongoTemplate.findOne(query, Vip.class);
        if (null != vip) {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("nick_name", (Object)vip.getVip_name());
            dataResponse.setStatus(Status.SUCCESS).setCode("0").setData(jsonObject);
        } else {
            dataResponse.setStatus(Status.FAILED).setMsg("\u4f1a\u5458\u4e0d\u5b58\u5728");
        }
        return dataResponse;
    }

    public DataResponse checkVip(DataRequest dataRequest) {
        String results;
        JSONObject datas;
        JSONObject jsonObject;
        JSONObject object_jnby;
        JSONObject pdate;
        DataResponse dataResponse;
        String head_img;
        String nick_name;
        String hash;
        String unionid;
        String open_id;
        String user_id;
        block16: {
            JSONObject data = dataRequest.getData();
            String app_id = data.getString("app_id");
            user_id = data.getString("user_id");
            open_id = data.getString("open_id");
            String material_id = data.getString("material_id");
            String article_id = data.getString("article_id");
            unionid = data.getString("unionid");
            String type = data.getString("type");
            hash = data.getString("hash");
            nick_name = "";
            head_img = "";
            if (org.apache.commons.lang.StringUtils.isNotBlank((String)material_id)) {
                JSONObject get_param_ = new JSONObject();
                if (org.apache.commons.lang.StringUtils.isNotBlank((String)article_id)) {
                    get_param_.put("article_id", (Object)article_id);
                    get_param_.put("material_id", (Object)material_id);
                    get_param_.put("open_id", (Object)open_id);
                    get_param_.put("product_url", (Object)data.getString("url"));
                    get_param_.put("user_id", (Object)user_id);
                } else {
                    get_param_.put("material_id", (Object)material_id);
                    get_param_.put("open_id", (Object)open_id);
                    String url = this.web_server_domain + "/m/group/buy.html?material_id=" + material_id + "&open_id=" + open_id + "&appid=" + app_id + "&hash=" + hash + "&user_id=" + user_id;
                    get_param_.put("product_url", (Object)url);
                    get_param_.put("user_id", (Object)user_id);
                }
                try {
                    1 order_commission = new /* Unavailable Anonymous Inner Class!! */;
                    Thread thread = new Thread((Runnable)order_commission);
                    thread.start();
                }
                catch (Exception e) {
                    log.error("check_vip error:" + e.getLocalizedMessage(), (Throwable)e);
                }
            }
            dataResponse = new DataResponse();
            dataResponse.setStatus(Status.SUCCESS).setCode("0").setMsg("\u5b58\u5728");
            if (StringUtils.isNull((Object)unionid)) {
                String param = this.redisClient.getValueOps().getValueString("wx_" + app_id + "_" + open_id);
                log.info("-param---" + param);
                if (null == param) {
                    return dataResponse.setMsg("\u6388\u6743\u4fe1\u606f\u5931\u8d25").setStatus(Status.FAILED).setCode("-1");
                }
                JSONObject dataParam = JSONObject.parseObject((String)param);
                unionid = dataParam.getString("unionid");
                nick_name = dataParam.getString("nickname");
                head_img = dataParam.getString("headimgurl");
            } else {
                pdate = new JSONObject();
                pdate.put("openId", (Object)open_id);
                pdate.put("optType", (Object)"1");
                pdate.put("moblie", (Object)"");
                object_jnby = new JSONObject();
                object_jnby.put("hash", (Object)hash);
                object_jnby.put("apiUrl", (Object)"open-api/memberQuery.json");
                object_jnby.put("apiParam", (Object)pdate);
                log.info((Object)pdate);
                try {
                    String string = NetWorkCommon.JnbyDm((JSONObject)object_jnby);
                    if (null != string) {
                        JSONObject memberQuery_response;
                        jsonObject = JSONObject.parseObject((String)string);
                        if (jsonObject.containsKey((Object)"data") && jsonObject.containsKey((Object)"error") && (datas = JSONObject.parseObject((String)jsonObject.getString("data"))).containsKey((Object)"memberQuery_response") && null != (memberQuery_response = datas.getJSONObject("memberQuery_response")) && memberQuery_response.containsKey((Object)"result") && "1".equals(results = memberQuery_response.getString("result"))) {
                            JSONObject memberInfo = memberQuery_response.getJSONObject("memberInfo");
                            nick_name = memberInfo.getString("nickName");
                            head_img = memberInfo.getString("thirdImgUrl");
                        }
                        break block16;
                    }
                    return dataResponse.setMsg("\u67e5\u8be2\u4f1a\u5458\u5931\u8d25").setStatus(Status.FAILED).setCode("-1");
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return dataResponse.setMsg("\u67e5\u8be2\u4f1a\u5458\u5931\u8d25").setStatus(Status.FAILED).setCode("-1");
                }
            }
        }
        if (StringUtils.isNull((Object)nick_name)) {
            return dataResponse.setMsg("\u67e5\u8be2\u4f1a\u5458\u5931\u8d25").setStatus(Status.FAILED).setCode("-1");
        }
        pdate = new JSONObject();
        pdate.put("openId", (Object)open_id);
        pdate.put("unionid", (Object)unionid);
        pdate.put("headImgUrl", (Object)head_img);
        nick_name = nick_name.replaceAll("[\ud83c\udc00-\ud83c\udfff]|[\ud83d\udc00-\ud83d\udfff]|[\u2600-\u27ff]", " ");
        pdate.put("nickName", (Object)nick_name);
        pdate.put("empId", (Object)user_id);
        object_jnby = new JSONObject();
        object_jnby.put("hash", (Object)hash);
        object_jnby.put("apiUrl", (Object)"open-api/addMemberId.json");
        object_jnby.put("apiParam", (Object)pdate);
        try {
            JSONObject addMemberId_response;
            String result = NetWorkCommon.JnbyDm((JSONObject)object_jnby);
            log.info("--\u4f1a\u5458\u65b0\u589e---" + result);
            if (null != result && (jsonObject = JSONObject.parseObject((String)result)).containsKey((Object)"data") && jsonObject.containsKey((Object)"error") && (datas = jsonObject.getJSONObject("data")).containsKey((Object)"addMemberId_response") && null != (addMemberId_response = datas.getJSONObject("addMemberId_response")) && addMemberId_response.containsKey((Object)"result") && ("14004".equals(results = addMemberId_response.getString("result")) || "1".equals(results))) {
                dataResponse.setMsg("\u4f1a\u5458\u65b0\u589e\u6210\u529f").setStatus(Status.SUCCESS).setCode("0").setData(addMemberId_response);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            log.info("--catch---" + e.getLocalizedMessage());
        }
        return dataResponse;
    }

    public List<Vip> vipPhone(String user_id, String vip_phone) {
        return this.mongoTemplate.find(Query.query((CriteriaDefinition)Criteria.where((String)"user_id").is((Object)user_id).and("vip_phone").is((Object)vip_phone).and("is_active").is((Object)"Y")), Vip.class);
    }

    @CacheEvict(value={"vip"}, allEntries=true)
    public DataResponse mod(DataRequest dataRequest) {
        JSONObject da;
        DataResponse dataResponse = new DataResponse();
        JSONObject data = dataRequest.getData();
        String vip_id = data.getString("vip_id");
        String user_id = data.getString("user_id");
        BasicDBObject basicDBObject = new BasicDBObject();
        BasicDBObject update = new BasicDBObject();
        if (data.containsKey((Object)"vip_name")) {
            basicDBObject.put((Object)"vip_name", (Object)data.getString("vip_name"));
        }
        if (data.containsKey((Object)"remark_name")) {
            basicDBObject.put((Object)"remark_name", (Object)data.getString("remark_name"));
        }
        if (data.containsKey((Object)"nick_name")) {
            basicDBObject.put((Object)"nick_name", (Object)data.getString("nick_name"));
        }
        if (data.containsKey((Object)"head_img")) {
            basicDBObject.put((Object)"head_img", (Object)data.getString("head_img"));
        }
        if (data.containsKey((Object)"vip_sex")) {
            basicDBObject.put((Object)"vip_sex", (Object)data.getString("vip_sex"));
        }
        if (data.containsKey((Object)"user_id")) {
            basicDBObject.put((Object)"user_id", (Object)data.getString("user_id"));
            basicDBObject.put((Object)"chat_user_id", (Object)data.getString("user_id"));
        }
        log.info("\u4f1a\u5458\u7b49\u7ea7" + data.getString("vip_grade_id"));
        if (data.containsKey((Object)"vip_grade_id")) {
            basicDBObject.put((Object)"vip_grade_id", (Object)data.getString("vip_grade_id"));
        }
        if (data.containsKey((Object)"vipParams")) {
            basicDBObject.put((Object)"vipParams", (Object)data.getJSONArray("vipParams"));
        }
        if (data.containsKey((Object)"birthday")) {
            String birth = data.getString("birthday");
            try {
                int age = TimeUtils.getCurrentYear() - Integer.parseInt(TimeUtils.convertTime((String)birth.replace("-", "")).split(",")[0]);
                basicDBObject.put((Object)"age", (Object)(age + ""));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            basicDBObject.put((Object)"birthday", (Object)data.getString("birthday"));
        }
        if (data.containsKey((Object)"age")) {
            basicDBObject.put((Object)"age", (Object)data.getString("age"));
        }
        if (data.containsKey((Object)"vip_phone")) {
            basicDBObject.put((Object)"vip_phone", (Object)data.getString("vip_phone"));
            List vips = this.vipPhone(user_id, data.getString("vip_phone"));
            for (Vip vip : vips) {
                if (vip.getVip_id().equals(vip_id)) continue;
                return new DataResponse().setStatus(Status.FAILED).setMsg("\u4f1a\u5458\u5df2\u7ed1\u5b9a\u8be5\u5bfc\u8d2d").setData(JSONObject.parseObject((String)vip.toString()));
            }
        }
        if (data.containsKey((Object)"address_list")) {
            Vip vip = (Vip)this.mongoTemplate.findOne(Query.query((CriteriaDefinition)Criteria.where((String)"vip_id").is((Object)vip_id)), Vip.class);
            JSONArray array = data.getJSONArray("address_list");
            String vip_phone = vip.getVip_phone();
            if (org.apache.commons.lang.StringUtils.isBlank((String)vip_phone) && org.apache.commons.lang.StringUtils.isBlank((String)data.getString("vip_phone"))) {
                JSONObject object = array.getJSONObject(0);
                String phone = object.getString("phone");
                basicDBObject.put((Object)"vip_phone", (Object)phone);
            }
            basicDBObject.put((Object)"address_list", (Object)data.getJSONArray("address_list"));
        }
        if (data.containsKey((Object)"province")) {
            basicDBObject.put((Object)"province", (Object)data.getString("province"));
        }
        if (data.containsKey((Object)"city")) {
            basicDBObject.put((Object)"city", (Object)data.getString("city"));
        }
        basicDBObject.put((Object)"modified_date", (Object)TimeUtils.getCurrentTimeInString((SimpleDateFormat)TimeUtils.DATETIME_FORMAT_DATE));
        if (data.containsKey((Object)"open_id")) {
            try {
                JSONArray array = data.getJSONArray("open_id");
                basicDBObject.put((Object)"open_id", (Object)array);
            }
            catch (Exception array) {
                // empty catch block
            }
        }
        update.put((Object)"$set", (Object)basicDBObject);
        BasicDBObject query = new BasicDBObject();
        query.put((Object)"vip_id", (Object)vip_id);
        log.info("update>>" + update + ">>>>>>>>>query>>>>>>>" + query);
        WriteResult writeResult = this.mongoTemplate.getCollection("def_vip").updateMulti((DBObject)query, (DBObject)update);
        if (writeResult.getN() > 0) {
            da = new JSONObject();
            da.put("message", (Object)"\u4fee\u6539\u6210\u529f");
            dataResponse.setStatus(Status.SUCCESS).setCode("0").setId(dataRequest.getId()).setData(da);
        } else {
            da = new JSONObject();
            da.put("message", (Object)"\u4fee\u6539\u5931\u8d25");
            dataResponse.setStatus(Status.FAILED).setCode("-1").setId(dataRequest.getId()).setData(da).setMsg("\u4fee\u6539\u5931\u8d25");
        }
        return dataResponse;
    }

    public DataResponse del(DataRequest dataRequest) {
        DataResponse dataResponse = new DataResponse();
        JSONObject data = dataRequest.getData();
        String user_id = data.getString("user_id");
        String id = data.getString("id");
        DBCollection collection = this.mongoTemplate.getCollection("def_vip");
        BasicDBObject basicDB = new BasicDBObject();
        BasicDBList basicDBList1 = new BasicDBList();
        basicDBList1.add((Object)new BasicDBObject("user_id", (Object)user_id));
        basicDBList1.add((Object)new BasicDBObject("_id", (Object)new ObjectId(id)));
        basicDB.put((Object)"$and", (Object)basicDBList1);
        WriteResult writeResult = collection.remove((DBObject)basicDB);
        if (writeResult.getN() > 0) {
            JSONObject da = new JSONObject();
            da.put("message", (Object)"\u5220\u9664\u6210\u529f");
            dataResponse.setStatus(Status.SUCCESS).setCode("0").setId(dataRequest.getId()).setData(da);
        } else {
            JSONObject da = new JSONObject();
            da.put("message", (Object)"\u5220\u9664\u5931\u8d25");
            dataResponse.setStatus(Status.FAILED).setCode("-1").setId(dataRequest.getId()).setData(da).setMsg("\u4fee\u6539\u5931\u8d25");
        }
        return dataResponse;
    }

    public DataResponse queryVipParam(DataRequest dataRequest) {
        JSONObject data = dataRequest.getData();
        DBCollection collection = this.mongoTemplate.getCollection("def_vip_param");
        BasicDBObject basicDBObject = new BasicDBObject();
        basicDBObject.put((Object)"corp_code", (Object)"C10000");
        DBCursor dbCur = collection.find((DBObject)basicDBObject);
        JSONObject jsonObject = new JSONObject();
        JSONArray array = new JSONArray();
        while (dbCur.hasNext()) {
            DBObject object = dbCur.next();
            Map map = object.toMap();
            Object id = map.get("_id");
            map.put("id", id.toString());
            map.remove("_id");
            array.add((Object)map);
        }
        jsonObject.put("message", (Object)array);
        return new DataResponse().setStatus(Status.SUCCESS).setData(jsonObject);
    }

    public DataResponse queryList(DataRequest dataRequest) {
        JSONObject data = dataRequest.getData();
        String user_id = data.getString("user_id");
        String vip_name = data.getString("vip_name");
        String is_group_vip = data.getString("is_group_vip");
        int page_num = data.getIntValue("page_num");
        int page_size = data.getIntValue("page_size");
        Query query_ = new Query();
        query_.addCriteria((CriteriaDefinition)Criteria.where((String)"user_id").is((Object)user_id));
        User user_ = (User)this.mongoTemplate.findOne(query_, User.class);
        if (null == user_) {
            JSONObject result = new JSONObject();
            result.put("message", (Object)new JSONArray());
            return new DataResponse().setData(result).setCode("0").setStatus(Status.SUCCESS);
        }
        String role_type = user_.getRole_type();
        Criteria criteria = new Criteria();
        criteria.and("user_id").is((Object)user_id);
        criteria.and("is_active").is((Object)"Y");
        if (StringUtils.isNotNull((Object)vip_name)) {
            Criteria criteria_or = new Criteria();
            criteria_or.and("vip_name").regex(vip_name, "i");
            Criteria criteria_or_ = new Criteria();
            criteria_or_.and("nick_name").regex(vip_name, "i");
            Criteria criteria_ = new Criteria();
            criteria_.orOperator(new Criteria[]{criteria_or_, criteria_or});
            criteria.andOperator(new Criteria[]{criteria_});
        }
        log.info((Object)criteria);
        Query query = new Query();
        if (org.apache.commons.lang.StringUtils.isNotBlank((String)is_group_vip)) {
            criteria.and("is_group_vip").is((Object)is_group_vip);
            query = new Query((CriteriaDefinition)criteria).skip(page_num * page_size).limit(page_size).with(new Sort(Sort.Direction.ASC, new String[]{"modified_date"}));
        } else {
            query = new Query((CriteriaDefinition)criteria).skip(page_num * page_size).limit(page_size).with(new Sort(Sort.Direction.ASC, new String[]{"remark_name"}));
        }
        log.info("---vipAll----" + query);
        List groups = this.mongoTemplate.find(query, Vip.class);
        JSONArray array = new JSONArray();
        for (Vip vip : groups) {
            array.add(JSONObject.parse((String)vip.toString()));
        }
        JSONObject result = new JSONObject();
        result.put("message", (Object)array);
        return new DataResponse().setData(result).setCode("0").setStatus(Status.SUCCESS);
    }

    public DataResponse searchBirthVip(DataRequest dataRequest) {
        JSONObject data = dataRequest.getData();
        String user_id = data.getString("user_id");
        String is_group_vip = data.getString("is_group_vip");
        String time = data.getString("time");
        int page_num = data.getIntValue("page_num");
        int page_size = data.getIntValue("page_size");
        Query query_ = new Query();
        query_.addCriteria((CriteriaDefinition)Criteria.where((String)"user_id").is((Object)user_id));
        User user_ = (User)this.mongoTemplate.findOne(query_, User.class);
        String u_uin = user_.getUin();
        Criteria criteria = new Criteria();
        criteria.and("user_id").is((Object)user_id);
        criteria.and("u_uin").is((Object)u_uin);
        criteria.and("is_active").is((Object)"Y");
        if (org.apache.commons.lang.StringUtils.isNotBlank((String)is_group_vip)) {
            criteria.and("is_group_vip").is((Object)is_group_vip);
        }
        if (org.apache.commons.lang.StringUtils.isNotBlank((String)time)) {
            criteria.and("birthday").regex("-" + time);
        }
        Query query = new Query((CriteriaDefinition)criteria).skip(page_num * page_size).limit(page_size).with(new Sort(Sort.Direction.DESC, new String[]{"vip_py_initial"}));
        log.info("---vipAll----" + query);
        List groups = this.mongoTemplate.find(query, Vip.class);
        JSONArray array = new JSONArray();
        for (Vip vip : groups) {
            String remark_name = vip.getRemark_name();
            if (org.apache.commons.lang.StringUtils.isBlank((String)StringUtils.checkString((String)remark_name))) {
                remark_name = vip.getNick_name();
            }
            vip.setVip_name(remark_name);
            array.add(JSONObject.parse((String)vip.toString()));
        }
        JSONObject result = new JSONObject();
        result.put("message", (Object)array);
        return new DataResponse().setData(result).setCode("0").setStatus(Status.SUCCESS);
    }

    public DataResponse vipDetail(DataRequest dataRequest) {
        JSONObject data = dataRequest.getData();
        String vip_id = data.getString("vip_id");
        String user_id = data.getString("user_id");
        Criteria criteria = new Criteria();
        criteria.and("vip_id").is((Object)vip_id);
        Query query = new Query((CriteriaDefinition)criteria);
        Vip vip = (Vip)this.mongoTemplate.findOne(query, Vip.class);
        JSONArray vipParam = new JSONArray();
        if (null != vip) {
            String birthday;
            JSONObject jsonObject = new JSONObject();
            String is_user_id = vip.getUser_id();
            if (org.apache.commons.lang.StringUtils.isNotBlank((String)is_user_id)) {
                if (is_user_id.equals(user_id)) {
                    jsonObject.put("is_belong", (Object)"Y");
                } else {
                    jsonObject.put("is_belong", (Object)"N");
                }
            } else {
                jsonObject.put("is_belong", (Object)"N");
            }
            String vipAge = vip.getAge();
            if (null == vipAge && null != (birthday = vip.getBirthday())) {
                Integer year = Integer.parseInt(birthday.substring(0, 4));
                String now = TimeUtils.getTime((long)System.currentTimeMillis());
                Integer nowYear = Integer.parseInt(now.substring(0, 4));
                vip.setAge(String.valueOf(nowYear - year + 1));
            }
            if (vip.getVip_grade_id() != null) {
                String vip_grade_id = vip.getVip_grade_id();
                VipGrade vipGrade = (VipGrade)this.mongoTemplate.findOne(Query.query((CriteriaDefinition)Criteria.where((String)"_id").is((Object)new ObjectId(vip_grade_id))), VipGrade.class);
                if (vipGrade != null) {
                    jsonObject.put("vipGradeInfo", (Object)vipGrade);
                }
            }
            Criteria remind = Criteria.where((String)"user_id").is((Object)user_id).and("status").ne((Object)"0").and("vipList").elemMatch(Criteria.where((String)"vip_id").is((Object)vip_id));
            Query query_remind = new Query((CriteriaDefinition)remind).with(new Sort(Sort.Direction.DESC, new String[]{"modified_date"}));
            log.info((Object)query_remind);
            Memorandum remindList = (Memorandum)this.mongoTemplate.findOne(query_remind, Memorandum.class);
            JSONObject remind_json = new JSONObject();
            remind_json.put("counts", (Object)"0");
            if (null != remindList) {
                remind_json = JSONObject.parseObject((String)remindList.toString());
                BasicDBObject basicDBObject = new BasicDBObject();
                basicDBObject.put((Object)"user_id", (Object)user_id);
                basicDBObject.put((Object)"vipList", (Object)new BasicDBObject("$elemMatch", (Object)new BasicDBObject("vip_id", (Object)vip_id)));
                DBCursor dbObjects = this.mongoTemplate.getCollection("def_memorandum").find((DBObject)basicDBObject);
                remind_json.put("counts", (Object)(dbObjects.count() + ""));
            }
            Criteria order = Criteria.where((String)"order_vip.vip_id").is((Object)vip_id).and("pay_status").is((Object)"1");
            Query query_order = new Query((CriteriaDefinition)order).with(new Sort(Sort.Direction.DESC, new String[]{"modified_date"}));
            Order orderOne = (Order)this.mongoTemplate.findOne(query_order, Order.class);
            JSONObject order_json = new JSONObject();
            order_json.put("amt_trade", (Object)"0");
            order_json.put("num_trade", (Object)"0");
            if (null != orderOne) {
                order_json = JSONObject.parseObject((String)orderOne.toString());
                Map stringMap = this.selectVipOrder(vip_id, user_id);
                String amt_trade = (String)stringMap.get("sum_amount");
                String num_trade = (String)stringMap.get("counts");
                order_json.put("amt_trade", (Object)amt_trade);
                order_json.put("num_trade", (Object)num_trade);
            }
            jsonObject.putAll((Map)JSON.parseObject((String)vip.toString()));
            String user_name = "";
            JSONObject user = this.userRedisUtils.getUser(user_id, false);
            if (!user.isEmpty()) {
                user_name = user.getString("user_name");
            }
            jsonObject.put("user_name", (Object)user_name);
            String head_img = vip.getHead_img();
            if (org.apache.commons.lang.StringUtils.isNotBlank((String)head_img) && !head_img.startsWith("http")) {
                if (head_img.startsWith("/")) {
                    head_img = head_img.substring(1, head_img.length());
                }
                head_img = URLEncoder.encode(head_img);
                head_img = this.aliCDNUrlAuth.getAuthURLA(this.OSS_DOMAIN + "/" + head_img);
            }
            jsonObject.put("auth_head_img", (Object)head_img);
            jsonObject.put("remind", (Object)remind_json);
            jsonObject.put("order", (Object)order_json);
            try {
                data.put("page_size", (Object)"3");
                data.put("page_num", (Object)"0");
                JSONArray array = new JSONArray();
                DataResponse response = this.vipCouponList(dataRequest);
                if ("SUCCESS".equals(response.getStatus().toString())) {
                    array = response.getData().getJSONArray("message");
                }
                jsonObject.put("coupon", (Object)array);
            }
            catch (Exception array) {
                // empty catch block
            }
            LogVipOperation vipOperation = (LogVipOperation)this.mongoTemplate.findOne(Query.query((CriteriaDefinition)Criteria.where((String)"vip_id").is((Object)vip_id)).with(new Sort(Sort.Direction.DESC, new String[]{"created_time"})), LogVipOperation.class);
            jsonObject.put("behavior", (Object)vipOperation);
            return new DataResponse().setData(jsonObject).setCode("0").setStatus(Status.SUCCESS);
        }
        return new DataResponse().setMsg("\u4f1a\u5458\u4e0d\u5b58\u5728").setCode("-1").setStatus(Status.FAILED);
    }

    public Map<String, String> selectVipOrder(String vip_id, String user_id) {
        DBCollection collection = this.mongoTemplate.getCollection("def_order");
        BasicDBObject basicDBObject = new BasicDBObject();
        basicDBObject.put((Object)"pay_status", (Object)"1");
        basicDBObject.put((Object)"order_vip.vip_id", (Object)vip_id);
        log.info("--$match---" + basicDBObject);
        BasicDBObject match_user = new BasicDBObject("$match", (Object)basicDBObject);
        BasicDBObject groupField = new BasicDBObject("_id", (Object)"$order_vip.vip_id");
        groupField.put("sum_amount", (Object)new BasicDBObject("$sum", (Object)"$order_amount_pay"));
        groupField.put("counts", (Object)new BasicDBObject("$sum", (Object)1));
        BasicDBObject group_user = new BasicDBObject("$group", (Object)groupField);
        log.info("--$group---" + group_user);
        AggregationOutput output_user = collection.aggregate((DBObject)match_user, new DBObject[]{group_user});
        HashMap<String, String> map = new HashMap<String, String>();
        for (DBObject dbObject : output_user.results()) {
            BasicDBObject basicDBObject1 = (BasicDBObject)dbObject;
            log.info("-output_user-" + basicDBObject1);
            String sum_amount = basicDBObject1.getString("sum_amount");
            String counts = basicDBObject1.getString("counts");
            map.put("sum_amount", sum_amount);
            map.put("counts", counts);
        }
        return map;
    }

    public DataResponse vipRemind(DataRequest dataRequest) {
        String current = TimeUtils.getCurrentTimeInString((SimpleDateFormat)TimeUtils.DATETIME_FORMAT_DATE);
        JSONObject data = dataRequest.getData();
        String vip_id = data.getString("vip_id");
        String user_id = data.getString("user_id");
        String search_time = data.getString("time");
        Criteria remind = Criteria.where((String)"user_id").is((Object)user_id).and("vipList").elemMatch(Criteria.where((String)"vip_id").is((Object)vip_id));
        if (org.apache.commons.lang.StringUtils.isNotBlank((String)search_time)) {
            remind.and("remind_time").regex(search_time, "i");
        }
        Query query_remind = new Query((CriteriaDefinition)remind).with(new Sort(Sort.Direction.DESC, new String[]{"modified_date"}));
        List remindList = this.mongoTemplate.find(query_remind, Memorandum.class);
        JSONObject jsonObject = new JSONObject();
        JSONArray unused_array = new JSONArray();
        JSONArray used_array = new JSONArray();
        JSONArray overdue_array = new JSONArray();
        for (Memorandum remind1 : remindList) {
            String time = remind1.getRemind_time();
            String status = remind1.getStatus();
            JSONObject object = JSONObject.parseObject((String)remind1.toString());
            object.remove((Object)"_id");
            object.put("id", (Object)object.getString("data_id"));
            if ("0".equals(status)) {
                used_array.add((Object)object);
                continue;
            }
            if (TimeUtils.compareDateTime((String)time, (String)current, (SimpleDateFormat)TimeUtils.DATETIME_FORMAT_DATE)) {
                overdue_array.add((Object)object);
                unused_array.add((Object)object);
                continue;
            }
            unused_array.add((Object)object);
        }
        jsonObject.put("count", (Object)unused_array.size());
        jsonObject.put("unused_array", (Object)unused_array);
        jsonObject.put("overdue_array", (Object)overdue_array);
        jsonObject.put("used_array", (Object)used_array);
        return new DataResponse().setData(jsonObject).setStatus(Status.SUCCESS).setCode("0");
    }

    public DataResponse vipOrder(DataRequest dataRequest) {
        JSONObject data = dataRequest.getData();
        String vip_id = data.getString("vip_id");
        String user_id = data.getString("user_id");
        String query_type = data.getString("query_type");
        int page_num = data.getIntValue("page_num");
        int page_size = data.getIntValue("page_size");
        Criteria order = Criteria.where((String)"order_vip.vip_id").is((Object)vip_id);
        if (org.apache.commons.lang.StringUtils.isNotBlank((String)query_type)) {
            if ("0".equals(query_type)) {
                order.and("order_status").is((Object)query_type);
                order.and("pay_status").is((Object)"1");
            } else if ("-1".equals(query_type)) {
                order.and("pay_status").is((Object)"0");
            } else if ("1".equals(query_type)) {
                Criteria criteria_or = new Criteria();
                criteria_or.and("order_status").is((Object)"1");
                Criteria criteria_or_ = new Criteria();
                criteria_or_.and("order_status").is((Object)"2");
                Criteria criteria_ = new Criteria();
                criteria_.orOperator(new Criteria[]{criteria_or_, criteria_or});
                order.andOperator(new Criteria[]{criteria_});
            } else {
                order.and("order_status").is((Object)query_type);
            }
        }
        log.info((Object)order);
        Query query_order = new Query((CriteriaDefinition)order).skip(page_num * page_size).limit(page_size).with(new Sort(Sort.Direction.DESC, new String[]{"created_date"}));
        List orderList = this.mongoTemplate.find(query_order, Order.class);
        JSONArray array = new JSONArray();
        for (Order order1 : orderList) {
            array.add((Object)JSONObject.parseObject((String)order1.toString()));
        }
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("orderList", (Object)array);
        return new DataResponse().setData(jsonObject).setCode("0").setStatus(Status.SUCCESS);
    }

    public DataResponse vipLabel(DataRequest dataRequest) {
        JSONArray jsonArray;
        JSONObject data = dataRequest.getData();
        String vip_id = data.getString("vip_id");
        String user_id = data.getString("user_id");
        Criteria criteria = new Criteria();
        criteria.and("vip_id").is((Object)vip_id);
        criteria.and("user_id").is((Object)user_id);
        Query query = new Query((CriteriaDefinition)criteria);
        Vip vip = (Vip)this.mongoTemplate.findOne(query, Vip.class);
        JSONArray array = new JSONArray();
        if (null != vip && null != (jsonArray = vip.getVipLabels())) {
            array = jsonArray;
        }
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("message", (Object)array);
        return new DataResponse().setData(jsonObject).setCode("0").setStatus(Status.SUCCESS);
    }

    @CacheEvict(value={"vip"}, allEntries=true)
    public DataResponse vipLabelCreate(DataRequest dataRequest) {
        JSONObject data = dataRequest.getData();
        String vip_id = data.getString("vip_id");
        String user_id = data.getString("user_id");
        String label_name = data.getString("label_name");
        JSONObject label = new JSONObject();
        label.put("label_name", (Object)label_name);
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"vip_id").is((Object)vip_id));
        Update update = new Update();
        update.addToSet("vipLabels", (Object)label);
        WriteResult writeResult = this.mongoTemplate.upsert(query, update, Vip.class);
        if (writeResult.getN() > 0) {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("message", (Object)"\u65b0\u589e\u6210\u529f");
            return new DataResponse().setData(jsonObject).setCode("0").setStatus(Status.SUCCESS);
        }
        return new DataResponse().setMsg("\u5df2\u5b58\u5728").setStatus(Status.FAILED);
    }

    @CacheEvict(value={"vip"}, allEntries=true)
    public DataResponse vipLabelRemove(DataRequest dataRequest) {
        BasicDBObject basicDBObject;
        JSONObject data = dataRequest.getData();
        String vip_id = data.getString("vip_id");
        String user_id = data.getString("user_id");
        String label_name = data.getString("label_name");
        String type = data.getString("type");
        DBCollection collection = this.mongoTemplate.getCollection("def_vip");
        JSONObject label = new JSONObject();
        label.put("label_name", (Object)label_name);
        BasicDBObject query = new BasicDBObject();
        query.put((Object)"vip_id", (Object)vip_id);
        query.put((Object)"user_id", (Object)user_id);
        BasicDBObject update = new BasicDBObject();
        if ("all".equals(type)) {
            basicDBObject = new BasicDBObject();
            basicDBObject.put((Object)"vipLabels", (Object)new JSONArray());
            update.put((Object)"$set", (Object)basicDBObject);
        } else {
            basicDBObject = new BasicDBObject();
            basicDBObject.put((Object)"vipLabels", (Object)label);
            update.put((Object)"$pull", (Object)basicDBObject);
        }
        WriteResult writeResult = collection.update((DBObject)query, (DBObject)update);
        if (writeResult.getN() > 0) {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("message", (Object)"\u5220\u9664\u6210\u529f");
            return new DataResponse().setData(jsonObject).setCode("0").setStatus(Status.SUCCESS);
        }
        return new DataResponse().setMsg("\u5220\u9664\u5931\u8d25").setStatus(Status.FAILED);
    }

    @CacheEvict(value={"vip"}, allEntries=true)
    public DataResponse vipGroupDelete(DataRequest dataRequest) {
        DataResponse dataResponse = new DataResponse();
        JSONObject data = dataRequest.getData();
        String user_id = data.getString("user_id");
        String id = data.getString("id");
        DBCollection collection = this.mongoTemplate.getCollection("def_vip_group");
        BasicDBObject basicDB = new BasicDBObject();
        BasicDBList basicDBList1 = new BasicDBList();
        basicDBList1.add((Object)new BasicDBObject("user_id", (Object)user_id));
        basicDBList1.add((Object)new BasicDBObject("vip_group_id", (Object)id));
        basicDB.put((Object)"$and", (Object)basicDBList1);
        log.info((Object)basicDB);
        DBCursor dbCur = collection.find((DBObject)basicDB);
        while (dbCur.hasNext()) {
            DBObject object = dbCur.next();
            Map map = object.toMap();
            String type = (String)map.get("type");
            if (!"sys".equals(type)) continue;
            dataResponse.setStatus(Status.FAILED).setCode("-1").setId("").setMsg("\u7cfb\u7edf\u5206\u7ec4\u65e0\u6cd5\u5220\u9664\uff01");
        }
        DataResponse dataResponse1 = this.wxService.removeContactLabel(dataRequest);
        if ("SUCCESS".equals(dataResponse1.getStatus().toString())) {
            JSONObject da;
            WriteResult writeResult = collection.remove((DBObject)basicDB);
            if (writeResult.getN() > 0) {
                da = new JSONObject();
                da.put("message", (Object)"\u5220\u9664\u6210\u529f");
                dataResponse.setStatus(Status.SUCCESS).setCode("0").setData(da).setMsg("\u5220\u9664\u6210\u529f").setId("");
            } else {
                da = new JSONObject();
                da.put("message", (Object)"\u5220\u9664\u5931\u8d25");
                dataResponse.setStatus(Status.FAILED).setCode("-1").setData(da).setMsg("\u4fee\u6539\u5931\u8d25").setId("");
            }
        } else {
            return dataResponse1;
        }
        return dataResponse;
    }

    @CacheEvict(value={"vip"}, allEntries=true)
    public DataResponse vipGroupCreate(DataRequest dataRequest) {
        DataResponse dataResponse = new DataResponse();
        dataResponse = dataResponse.setCode("-1").setStatus(Status.FAILED).setMsg("\u65b0\u589e\u5931\u8d25");
        JSONObject data = dataRequest.getData();
        String vip_group_name = data.getString("vip_group_name");
        JSONArray vipList = data.getJSONArray("vipList");
        String user_id = data.getString("user_id");
        Query query_ = new Query();
        query_.addCriteria((CriteriaDefinition)Criteria.where((String)"user_id").is((Object)user_id));
        User user_ = (User)this.mongoTemplate.findOne(query_, User.class);
        String u_uin = user_.getUin();
        DataResponse dataResponse1 = this.wxService.addContactLabel(dataRequest);
        if ("SUCCESS".equals(dataResponse1.getStatus().toString())) {
            DataResponse response = this.wxService.getContactLabelList(dataRequest);
            JSONObject object_ = response.getData();
            if (object_.containsKey((Object)"message")) {
                log.info((Object)object_);
                JSONObject jsonObject = object_.getJSONObject("message");
                JSONArray array = jsonObject.getJSONArray("contact_label_list");
                log.info("---array---" + array.size());
                for (int i = 0; i < array.size(); ++i) {
                    JSONObject jsonObject1 = array.getJSONObject(i);
                    if (!jsonObject1.containsValue((Object)vip_group_name)) continue;
                    String id = jsonObject1.getString("id");
                    query_.addCriteria((CriteriaDefinition)Criteria.where((String)"vip_group_name").is((Object)vip_group_name));
                    query_.addCriteria((CriteriaDefinition)Criteria.where((String)"is_active").is((Object)"Y"));
                    VipGroup vipGroup1 = (VipGroup)this.mongoTemplate.findOne(query_, VipGroup.class);
                    if (null == vipGroup1) {
                        VipGroup vipGroup = new VipGroup();
                        vipGroup.setUser_id(user_id);
                        vipGroup.setCreator_id(user_id);
                        vipGroup.setModifier_id(user_id);
                        vipGroup.setCreated_date(TimeUtils.getCurrentTimeInString((SimpleDateFormat)TimeUtils.DATETIME_FORMAT_DATE));
                        vipGroup.setModified_date(TimeUtils.getCurrentTimeInString((SimpleDateFormat)TimeUtils.DATETIME_FORMAT_DATE));
                        vipGroup.setIs_active("Y");
                        vipGroup.setVip_group_name(vip_group_name);
                        vipGroup.setVip_group_id(id);
                        vipGroup.setLevel(100);
                        vipGroup.setU_uin(u_uin);
                        this.mongoTemplate.save((Object)vipGroup);
                    }
                    JSONObject json = new JSONObject();
                    json.put("message", (Object)"\u65b0\u589e\u6210\u529f");
                    log.info("---vipList--" + vipList.size());
                    for (int j = 0; j < vipList.size(); ++j) {
                        JSONObject vipListJSONObject = vipList.getJSONObject(j);
                        String vip_id = vipListJSONObject.getString("vip_id");
                        JSONObject object = new JSONObject();
                        object.put("vip_group_id", (Object)id);
                        BasicDBObject query = new BasicDBObject();
                        query.put((Object)"vip_id", (Object)vip_id);
                        query.put((Object)"user_id", (Object)user_id);
                        BasicDBObject update = new BasicDBObject();
                        BasicDBObject basicDBObject = new BasicDBObject();
                        basicDBObject.put((Object)"vipGroups", (Object)object);
                        update.put((Object)"$addToSet", (Object)basicDBObject);
                        DataRequest dataRequest1 = new DataRequest();
                        JSONObject object1 = new JSONObject();
                        object1.put("user_id", (Object)user_id);
                        object1.put("vip_id", (Object)vip_id);
                        object1.put("label_id", (Object)id);
                        object1.put("type", (Object)"add");
                        dataRequest1.setData(object1);
                        DataResponse dataResponse_ = this.wxService.setContactLabel(dataRequest1);
                        if (!"SUCCESS".equals(dataResponse_.getStatus().toString())) continue;
                        this.mongoTemplate.getCollection("def_vip").update((DBObject)query, (DBObject)update);
                    }
                    dataResponse = new DataResponse().setData(json).setCode("0").setStatus(Status.SUCCESS);
                }
            }
        } else {
            dataResponse = new DataResponse().setCode("-1").setStatus(Status.FAILED).setMsg(dataResponse1.getMsg());
        }
        return dataResponse;
    }

    @CacheEvict(value={"vip"}, allEntries=true)
    public DataResponse vipGroupLevelMod(DataRequest dataRequest) {
        DataResponse dataResponse = new DataResponse();
        JSONObject data = dataRequest.getData();
        JSONArray array = data.getJSONArray("content");
        WriteResult writeResult = null;
        for (int i = 0; i < array.size(); ++i) {
            JSONObject object = array.getJSONObject(i);
            String _id = object.getString("vip_group_id");
            int level = object.getIntValue("level");
            BasicDBObject basicDBObject = new BasicDBObject();
            BasicDBObject update = new BasicDBObject();
            if (object.containsKey((Object)"level")) {
                basicDBObject.put((Object)"level", (Object)level);
            }
            basicDBObject.put((Object)"modified_date", (Object)TimeUtils.getCurrentTimeInString((SimpleDateFormat)TimeUtils.DATETIME_FORMAT_DATE));
            update.put((Object)"$set", (Object)basicDBObject);
            BasicDBObject query = new BasicDBObject();
            query.put((Object)"_id", (Object)new ObjectId(_id));
            writeResult = this.mongoTemplate.getCollection("def_vip_group").updateMulti((DBObject)query, (DBObject)update);
        }
        if (null != writeResult) {
            if (writeResult.getN() > 0) {
                JSONObject da = new JSONObject();
                da.put("message", (Object)"\u4fee\u6539\u6210\u529f");
                dataResponse.setStatus(Status.SUCCESS).setCode("0").setId(dataRequest.getId()).setData(da);
            } else {
                JSONObject da = new JSONObject();
                da.put("message", (Object)"\u4fee\u6539\u5931\u8d25");
                dataResponse.setStatus(Status.FAILED).setCode("-1").setId(dataRequest.getId()).setData(da).setMsg("\u4fee\u6539\u5931\u8d25");
            }
        } else {
            JSONObject da = new JSONObject();
            da.put("message", (Object)"\u4fee\u6539\u5931\u8d25");
            dataResponse.setStatus(Status.FAILED).setCode("-1").setId(dataRequest.getId()).setData(da).setMsg("\u4fee\u6539\u5931\u8d25");
        }
        return dataResponse;
    }

    @CacheEvict(value={"vip"}, allEntries=true)
    public DataResponse vipAddGroup(DataRequest dataRequest) {
        JSONObject data = dataRequest.getData();
        String vip_group_id = data.getString("vip_group_id");
        String vip_id = data.getString("vip_id");
        String user_id = data.getString("user_id");
        DBCollection collection = this.mongoTemplate.getCollection("def_vip");
        JSONObject object = new JSONObject();
        object.put("vip_group_id", (Object)vip_group_id);
        BasicDBObject query = new BasicDBObject();
        query.put((Object)"vip_id", (Object)vip_id);
        query.put((Object)"user_id", (Object)user_id);
        BasicDBObject update = new BasicDBObject();
        BasicDBObject basicDBObject = new BasicDBObject();
        basicDBObject.put((Object)"vipGroups", (Object)object);
        update.put((Object)"$addToSet", (Object)basicDBObject);
        WriteResult writeResult = collection.update((DBObject)query, (DBObject)update);
        if (writeResult.getN() > 0) {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("message", (Object)"\u65b0\u589e\u6210\u529f");
            return new DataResponse().setData(jsonObject).setCode("0").setStatus(Status.SUCCESS);
        }
        return new DataResponse().setMsg("\u5220\u9664\u5931\u8d25").setStatus(Status.FAILED);
    }

    @CacheEvict(value={"vip"}, allEntries=true)
    public DataResponse VipGroupOperate(DataRequest dataRequest) {
        DataResponse dataResponse;
        JSONObject object1;
        DataRequest dataRequest1;
        BasicDBObject basicDBObject;
        BasicDBObject update;
        BasicDBObject query;
        JSONObject object;
        String vip_id;
        JSONObject jsonObject;
        int i;
        JSONObject data = dataRequest.getData();
        String vip_group_id = data.getString("vip_group_id");
        JSONArray vip_del = data.getJSONArray("del");
        JSONArray vip_add = data.getJSONArray("add");
        String user_id = data.getString("user_id");
        WriteResult writeResult = null;
        DBCollection collection = this.mongoTemplate.getCollection("def_vip");
        for (i = 0; i < vip_add.size(); ++i) {
            jsonObject = vip_add.getJSONObject(i);
            vip_id = jsonObject.getString("vip_id");
            object = new JSONObject();
            object.put("vip_group_id", (Object)vip_group_id);
            query = new BasicDBObject();
            query.put((Object)"vip_id", (Object)vip_id);
            query.put((Object)"user_id", (Object)user_id);
            update = new BasicDBObject();
            basicDBObject = new BasicDBObject();
            basicDBObject.put((Object)"vipGroups", (Object)object);
            update.put((Object)"$addToSet", (Object)basicDBObject);
            dataRequest1 = new DataRequest();
            object1 = new JSONObject();
            object1.put("user_id", (Object)user_id);
            object1.put("vip_id", (Object)vip_id);
            object1.put("label_id", (Object)vip_group_id);
            object1.put("type", (Object)"add");
            dataRequest1.setData(object1);
            dataResponse = this.wxService.setContactLabel(dataRequest1);
            if (!"SUCCESS".equals(dataResponse.getStatus().toString())) continue;
            writeResult = collection.update((DBObject)query, (DBObject)update);
        }
        for (i = 0; i < vip_del.size(); ++i) {
            jsonObject = vip_del.getJSONObject(i);
            vip_id = jsonObject.getString("vip_id");
            object = new JSONObject();
            object.put("vip_group_id", (Object)vip_group_id);
            query = new BasicDBObject();
            query.put((Object)"vip_id", (Object)vip_id);
            query.put((Object)"user_id", (Object)user_id);
            update = new BasicDBObject();
            basicDBObject = new BasicDBObject();
            basicDBObject.put((Object)"vipGroups", (Object)object);
            update.put((Object)"$pull", (Object)basicDBObject);
            dataRequest1 = new DataRequest();
            object1 = new JSONObject();
            object1.put("user_id", (Object)user_id);
            object1.put("vip_id", (Object)vip_id);
            object1.put("label_id", (Object)vip_group_id);
            object1.put("type", (Object)"del");
            dataRequest1.setData(object1);
            dataResponse = this.wxService.setContactLabel(dataRequest1);
            if (!"SUCCESS".equals(dataResponse.getStatus().toString())) continue;
            writeResult = collection.update((DBObject)query, (DBObject)update);
        }
        if (null != writeResult) {
            if (writeResult.getN() > 0) {
                JSONObject jsonObject2 = new JSONObject();
                jsonObject2.put("message", (Object)"\u65b0\u589e\u6210\u529f");
                return new DataResponse().setData(jsonObject2).setCode("0").setStatus(Status.SUCCESS);
            }
            return new DataResponse().setMsg("\u5220\u9664\u5931\u8d25").setStatus(Status.FAILED);
        }
        if (vip_add.size() == 0 && vip_del.size() == 0) {
            JSONObject jsonObject3 = new JSONObject();
            jsonObject3.put("message", (Object)"\u64cd\u4f5c\u6210\u529f");
            return new DataResponse().setData(jsonObject3).setCode("0").setStatus(Status.SUCCESS);
        }
        return new DataResponse().setMsg("\u5220\u9664\u5931\u8d25").setStatus(Status.FAILED);
    }

    public DataResponse bingVip(DataRequest dataRequest) {
        JSONObject data = dataRequest.getData();
        String open_id = data.getString("open_id");
        String app_id = data.getString("app_id");
        String param = this.redisClient.getValueOps().getValueString("wx_" + app_id + "_" + open_id);
        log.info("-param---" + param);
        if (null == param) {
            return new DataResponse().setStatus(Status.FAILED).setCode("0").setMsg("\u6388\u6743\u4fe1\u606f\u5931\u8d25");
        }
        JSONObject dataParam = JSONObject.parseObject((String)param);
        String phone = data.getString("phone");
        String code = data.getString("code");
        Query query_ = new Query();
        query_.addCriteria((CriteriaDefinition)Criteria.where((String)"phone").is((Object)phone));
        Captcha captcha = (Captcha)this.mongoTemplate.findOne(query_, Captcha.class);
        if (null == captcha) {
            return new DataResponse().setStatus(Status.FAILED).setCode("0").setMsg("\u624b\u673a\u53f7\u6682\u672a\u83b7\u53d6\u9a8c\u8bc1\u7801");
        }
        String valid_code = captcha.getValid_code();
        String time = captcha.getTime();
        Timestamp modifiedate = Timestamp.valueOf(time);
        log.debug("dbvaildcode jo ----->" + code + "-----" + valid_code);
        log.debug("modifiedate jo --------->" + modifiedate);
        long l = System.currentTimeMillis() - modifiedate.getTime();
        long day = l / 86400000L;
        long hour = l / 3600000L - day * 24L;
        long min = l / 60000L - day * 24L * 60L - hour * 60L;
        log.debug("day->" + day + "--hour--" + hour + "--min--" + min);
        if (valid_code.equals(code) || MD5Util.getMD5Str32((String)code).equals(valid_code)) {
            if (hour > 2L) {
                return new DataResponse().setStatus(Status.FAILED).setMsg("\u9a8c\u8bc1\u7801\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u83b7\u53d6\uff01");
            }
            String order_id = data.getString("order_id");
            JSONArray array = new JSONArray();
            array.add((Object)open_id);
            String user_id = data.getString("user_id");
            String nick_name = dataParam.getString("nickname");
            String sex = "1".equals(dataParam.getString("sex")) ? "M" : "F";
            String head_img = dataParam.getString("headimgurl");
            String unionid = dataParam.getString("unionid");
            data.put("unionid", (Object)unionid);
            Query query_order = new Query((CriteriaDefinition)Criteria.where((String)"order_id").is((Object)order_id));
            Order orderInfo = (Order)this.mongoTemplate.findOne(query_order, Order.class);
            user_id = orderInfo.getUser_id();
            data.put("user_id", (Object)user_id);
            User user = (User)this.mongoTemplate.findOne(new Query((CriteriaDefinition)Criteria.where((String)"user_id").is((Object)user_id)), User.class);
            if (null == user) {
                return new DataResponse().setStatus(Status.FAILED).setCode("0").setMsg("\u7ed1\u5b9a\u5931\u8d25");
            }
            JSONObject order_vip = orderInfo.getOrder_vip();
            if (null == order_vip) {
                Query query = new Query((CriteriaDefinition)Criteria.where((String)"open_id").is((Object)open_id).and("is_active").is((Object)"Y").and("user_id").is((Object)user_id));
                Vip vip = (Vip)this.mongoTemplate.findOne(query, Vip.class);
                if (null == vip) {
                    Query query_phone = new Query((CriteriaDefinition)Criteria.where((String)"vip_phone").is((Object)phone).and("is_active").is((Object)"Y").and("user_id").is((Object)user_id));
                    vip = (Vip)this.mongoTemplate.findOne(query_phone, Vip.class);
                    if (null == vip) {
                        vip = new Vip();
                        vip.setIs_group_vip("N");
                        vip.setU_uin(user.getUin());
                        vip.setHead_img(head_img);
                        vip.setIs_active("Y");
                        vip.setIs_friends("Y");
                        vip.setNick_name(nick_name);
                        vip.setBing_nick_name(nick_name);
                        vip.setOpen_id(array);
                        vip.setVip_phone(phone);
                        vip.setRemark_name(nick_name);
                        vip.setUser_id(user_id);
                        vip.setVip_name(nick_name);
                        vip.setVip_sex(sex);
                        this.mongoTemplate.save((Object)vip);
                    } else {
                        data.put("vip_id", (Object)vip.getVip_id());
                        data.put("bing_nick_name", (Object)nick_name);
                        data.put("vip_phone", (Object)phone);
                        DataResponse dataResponse = this.bingOpenId(dataRequest);
                        if (!"SUCCESS".equals(dataResponse.getStatus().toString())) {
                            return dataResponse;
                        }
                    }
                } else {
                    data.put("vip_id", (Object)vip.getVip_id());
                    if (StringUtils.isNotNull((Object)vip.getVip_phone())) {
                        data.put("vip_phone", (Object)vip.getVip_phone());
                    } else {
                        data.put("vip_phone", (Object)phone);
                        data.put("bing_nick_name", (Object)nick_name);
                    }
                    DataResponse dataResponse = this.bingOpenId(dataRequest);
                    if (!"SUCCESS".equals(dataResponse.getStatus().toString())) {
                        return dataResponse;
                    }
                }
                String vip_phone = vip.getVip_phone();
                String vip_name = vip.getVip_name();
                String vip_id = vip.getVip_id();
                JSONObject object = new JSONObject();
                object.put("vip_phone", (Object)(StringUtils.isNotNull((Object)vip_phone) ? vip_phone : phone));
                object.put("vip_name", (Object)vip_name);
                object.put("bing_nick_name", (Object)nick_name);
                object.put("vip_id", (Object)vip_id);
                Update update = new Update();
                update.set("order_vip", (Object)object);
                WriteResult writeResult = this.mongoTemplate.upsert(query_order, update, Order.class);
            } else {
                data.put("vip_id", (Object)order_vip.getString("vip_id"));
                if (StringUtils.isNotNull((Object)order_vip.getString("vip_phone"))) {
                    data.put("vip_phone", (Object)order_vip.getString("vip_phone"));
                    order_vip.put("vip_phone", (Object)order_vip.getString("vip_phone"));
                } else {
                    data.put("vip_phone", (Object)phone);
                    order_vip.put("vip_phone", (Object)phone);
                }
                data.put("vip_phone", (Object)order_vip.getString("vip_phone"));
                data.put("bing_nick_name", (Object)nick_name);
                order_vip.put("bing_nick_name", (Object)nick_name);
                DataResponse dataResponse = this.bingOpenId(dataRequest);
                if (!"SUCCESS".equals(dataResponse.getStatus().toString())) {
                    return dataResponse;
                }
                Update update = new Update();
                update.set("order_vip", (Object)order_vip);
                WriteResult writeResult = this.mongoTemplate.upsert(query_order, update, Order.class);
            }
        } else {
            return new DataResponse().setStatus(Status.FAILED).setMsg("\u9a8c\u8bc1\u7801\u9519\u8bef,\u8bf7\u91cd\u65b0\u8f93\u5165!");
        }
        return new DataResponse().setStatus(Status.SUCCESS).setCode("0").setMsg("\u7ed1\u5b9a\u6210\u529f");
    }

    public DataResponse JnbyVipQuery(DataRequest dataRequest) {
        JSONObject data = dataRequest.getData();
        String openId = data.getString("open_id");
        DataResponse dataResponse = new DataResponse();
        JSONObject jsonObject = null;
        try {
            String result = NetWorkCommon.JnbyVipQuery((String)openId);
            if (null != result) {
                jsonObject = JSONObject.parseObject((String)result);
                log.info((Object)jsonObject);
                if (jsonObject.containsKey((Object)"data") && jsonObject.containsKey((Object)"error")) {
                    if ("1000".equals(jsonObject.getString("error"))) {
                        JSONArray array = jsonObject.getJSONArray("data");
                        JSONObject object = new JSONObject();
                        object.put("vipList", (Object)array);
                        dataResponse.setData(object).setStatus(Status.SUCCESS).setCode("0");
                    } else {
                        DataResponse dataResponse1 = this.searchVipByOpenId(dataRequest);
                        if ("SUCCESS".equals(dataResponse1.getStatus().toString())) {
                            JSONArray array = new JSONArray();
                            JSONObject a = new JSONObject();
                            a.put("nickName", (Object)dataResponse1.getData().getString("nick_name"));
                            array.add((Object)a);
                            JSONObject object = new JSONObject();
                            object.put("vipList", (Object)array);
                            dataResponse.setData(object).setStatus(Status.SUCCESS).setCode("0");
                        } else {
                            dataResponse.setMsg(jsonObject.getString("errMsg")).setStatus(Status.FAILED).setCode("-1");
                        }
                    }
                } else {
                    dataResponse.setMsg("\u4f1a\u5458\u67e5\u8be2\u5931\u8d25").setStatus(Status.FAILED).setCode("-1");
                }
            } else {
                dataResponse.setMsg("\u4f1a\u5458\u67e5\u8be2\u5931\u8d25").setStatus(Status.FAILED).setCode("-1");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return dataResponse;
    }

    public DataResponse isVip(DataRequest dataRequest) {
        JSONObject data = dataRequest.getData();
        String open_id = data.getString("open_id");
        String order_id = data.getString("order_id");
        Query query_order = new Query((CriteriaDefinition)Criteria.where((String)"order_id").is((Object)order_id));
        Order orderInfo = (Order)this.mongoTemplate.findOne(query_order, Order.class);
        String user_id = orderInfo.getUser_id();
        Query query = new Query((CriteriaDefinition)Criteria.where((String)"open_id").is((Object)open_id).and("is_active").is((Object)"Y").and("user_id").is((Object)user_id));
        Vip vip = (Vip)this.mongoTemplate.findOne(query, Vip.class);
        if (null == vip) {
            return new DataResponse().setStatus(Status.FAILED).setCode("-1").setMsg("\u4f1a\u5458\u4e0d\u5b58\u5728");
        }
        String vip_name = vip.getVip_name();
        if (StringUtils.isNull((Object)vip_name)) {
            vip.setVip_name(vip.getNick_name());
        }
        return new DataResponse().setStatus(Status.SUCCESS).setCode("0").setMsg("\u4f1a\u5458\u5b58\u5728").setData(JSONObject.parseObject((String)vip.toString()));
    }

    public DataResponse bingOpenId(DataRequest dataRequest) {
        log.info((Object)dataRequest);
        JSONObject data = dataRequest.getData();
        String open_id = data.getString("open_id");
        String user_id = data.getString("user_id");
        String vip_phone = data.getString("vip_phone");
        String phone = data.getString("phone");
        String unionid = data.getString("unionid");
        String bing_nick_name = data.getString("bing_nick_name");
        JSONArray array = new JSONArray();
        array.add((Object)open_id);
        String vip_id = data.getString("vip_id");
        Query query = new Query((CriteriaDefinition)Criteria.where((String)"vip_id").is((Object)vip_id));
        Update update = new Update();
        update.set("open_id", (Object)array);
        update.set("bing_nick_name", (Object)bing_nick_name);
        update.set("vip_phone", (Object)vip_phone);
        update.set("unionid", (Object)unionid);
        Vip vip = (Vip)this.mongoTemplate.findOne(Query.query((CriteriaDefinition)Criteria.where((String)"user_id").is((Object)user_id).and("vip_phone").is((Object)phone).and("is_active").is((Object)"Y")), Vip.class);
        if (null != vip && !vip_id.equals(vip.getVip_id())) {
            return new DataResponse().setStatus(Status.FAILED).setCode("0").setMsg("\u8be5\u624b\u673a\u53f7\u5df2\u88ab\u5176\u4ed6\u4f1a\u5458\u7ed1\u5b9a\uff0c\u8bf7\u8054\u7cfb\u5356\u5bb6\u3002");
        }
        WriteResult writeResult = this.mongoTemplate.upsert(query, update, Vip.class);
        log.info((Object)writeResult.getN());
        return new DataResponse().setStatus(Status.SUCCESS).setCode("0").setMsg("\u7ed1\u5b9a\u6210\u529f");
    }

    @Cacheable(value={"vip"}, key="#dataRequest.data")
    public DataResponse vipGroup(DataRequest dataRequest) {
        JSONObject data = dataRequest.getData();
        String user_id = data.getString("user_id");
        int page_num = data.getIntValue("page_num");
        int page_size = data.getIntValue("page_size");
        boolean flag = data.getBooleanValue("flag");
        log.info("----\u4f1a\u5458\u5206\u7ec4---");
        Query query_ = new Query();
        query_.addCriteria((CriteriaDefinition)Criteria.where((String)"user_id").is((Object)user_id));
        User user_ = (User)this.mongoTemplate.findOne(query_, User.class);
        String u_uin = user_.getUin();
        Criteria criteria = new Criteria();
        criteria.and("user_id").is((Object)user_id);
        criteria.and("is_active").is((Object)"Y");
        criteria.and("u_uin").is((Object)u_uin);
        Query query = new Query((CriteriaDefinition)criteria).skip(page_num * page_size).limit(page_size).with(new Sort(Sort.Direction.ASC, new String[]{"level"}));
        log.info((Object)query);
        List groups = this.mongoTemplate.find(query, VipGroup.class);
        JSONArray array = new JSONArray();
        for (VipGroup vipGroup : groups) {
            JSONObject vips = new JSONObject();
            String vip_group_id = vipGroup.getVip_group_id();
            String vip_group_name = vipGroup.getVip_group_name();
            String vip_group_type = vipGroup.getType();
            if (flag) {
                Criteria order = Criteria.where((String)"user_id").is((Object)user_id).andOperator(new Criteria[]{Criteria.where((String)"u_uin").is((Object)u_uin)}).and("vipGroups").elemMatch(Criteria.where((String)"vip_group_id").is((Object)vip_group_id));
                Query query_order = new Query((CriteriaDefinition)order).with(new Sort(Sort.Direction.DESC, new String[]{"remark_name"}));
                log.info("--\u62c9\u53d6\u4f1a\u5458---" + query_order);
                List vipList = this.mongoTemplate.find(query_order, Vip.class);
                vips.put("vips", (Object)vipList);
            } else {
                JSONArray jsonArray = new JSONArray();
                BasicDBObject basicDBObject = new BasicDBObject();
                basicDBObject.put((Object)"user_id", (Object)user_id);
                basicDBObject.put((Object)"u_uin", (Object)u_uin);
                basicDBObject.put((Object)"is_active", (Object)"Y");
                basicDBObject.put((Object)"vipGroups.vip_group_id", (Object)vip_group_id);
                DBCursor dbObjects = this.mongoTemplate.getCollection("def_vip").find((DBObject)basicDBObject).skip(0).limit(3);
                vips.put("vip_count", (Object)dbObjects.count());
                while (dbObjects.hasNext()) {
                    DBObject object = dbObjects.next();
                    Map map = object.toMap();
                    Object id = map.get("_id");
                    map.put("id", id.toString());
                    map.remove("_id");
                    jsonArray.add((Object)map);
                }
                vips.put("vipList", (Object)jsonArray);
            }
            vips.put("vip_group_name", (Object)vip_group_name);
            vips.put("vip_group_id", (Object)vip_group_id);
            vips.put("vip_group_type", (Object)vip_group_type);
            array.add((Object)vips);
        }
        JSONObject result = new JSONObject();
        result.put("message", (Object)array);
        return new DataResponse().setData(result).setCode("0").setStatus(Status.SUCCESS);
    }

    public DataResponse vipGroupList(DataRequest dataRequest) {
        JSONObject data = dataRequest.getData();
        String user_id = data.getString("user_id");
        String vip_group_id = data.getString("vip_group_id");
        int page_num = data.getIntValue("page_num");
        int page_size = data.getIntValue("page_size");
        Query query_ = new Query();
        query_.addCriteria((CriteriaDefinition)Criteria.where((String)"user_id").is((Object)user_id));
        User user_ = (User)this.mongoTemplate.findOne(query_, User.class);
        String u_uin = user_.getUin();
        JSONArray array = new JSONArray();
        Criteria order = Criteria.where((String)"user_id").is((Object)user_id).andOperator(new Criteria[]{Criteria.where((String)"u_uin").is((Object)u_uin)}).and("vipGroups").elemMatch(Criteria.where((String)"vip_group_id").is((Object)vip_group_id));
        Query query_order = new Query((CriteriaDefinition)order).with(new Sort(Sort.Direction.DESC, new String[]{"modified_date"})).skip(page_num * page_size).limit(page_size);
        List vipList = this.mongoTemplate.find(query_order, Vip.class);
        JSONObject vips = new JSONObject();
        vips.put("vips", (Object)vipList);
        array.add((Object)vips);
        JSONObject result = new JSONObject();
        result.put("message", (Object)array);
        return new DataResponse().setData(result).setCode("0").setStatus(Status.SUCCESS);
    }

    public DataResponse vipCouponList(DataRequest dataRequest) {
        JSONObject data = dataRequest.getData();
        String vip_id = data.getString("vip_id");
        String status = data.getString("status");
        int page_num = data.getIntValue("page_num");
        int page_size = data.getIntValue("page_size");
        Object[] vip_ids = vip_id.split(",");
        Query query = new Query((CriteriaDefinition)Criteria.where((String)"vip_id").in(vip_ids).and("is_active").is((Object)"Y"));
        if (org.apache.commons.lang.StringUtils.isNotBlank((String)status) && !"3".equals(status)) {
            if ("2".equals(status)) {
                query.addCriteria((CriteriaDefinition)Criteria.where((String)"status").in((Object[])new String[]{"1", "2"}));
            } else {
                query.addCriteria((CriteriaDefinition)Criteria.where((String)"status").in((Object[])status.split(",")));
            }
        } else if ("3".equals(status)) {
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"status").ne((Object)"2"));
        }
        log.info("----query----" + query);
        List couponList = this.mongoTemplate.find(query, Coupon.class);
        JSONArray array = new JSONArray();
        for (int i = 0; i < couponList.size(); ++i) {
            CouponType couponType;
            Query query1;
            String coupon_type;
            JSONObject jsonObject1;
            String current_time;
            JSONObject jsonObject = new JSONObject();
            Coupon coupon = (Coupon)couponList.get(i);
            String begin_date = coupon.getBegin_date();
            String end_date = coupon.getEnd_date();
            String coupon_status = coupon.getStatus();
            if ("3".equals(status)) {
                current_time = TimeUtils.getTime((long)System.currentTimeMillis());
                if (!TimeUtils.compareDateTime((String)end_date, (String)current_time, (SimpleDateFormat)TimeUtils.DATE_FORMAT_DATE)) continue;
                jsonObject1 = JSON.parseObject((String)coupon.toString());
                jsonObject1.put("coupon_id", (Object)jsonObject1.getString("_id"));
                jsonObject1.put("status", (Object)"3");
                jsonObject.putAll((Map)jsonObject1);
                coupon_type = coupon.getCoupon_type_id();
                query1 = new Query((CriteriaDefinition)Criteria.where((String)"_id").is((Object)new ObjectId(coupon_type)));
                couponType = (CouponType)this.mongoTemplate.findOne(query1, CouponType.class);
                jsonObject.putAll((Map)JSON.parseObject((String)couponType.toString()));
                array.add((Object)jsonObject);
                continue;
            }
            current_time = TimeUtils.getTime((long)System.currentTimeMillis());
            jsonObject1 = JSON.parseObject((String)coupon.toString());
            jsonObject1.put("coupon_id", (Object)jsonObject1.getString("_id"));
            if (("1".equals(status) || "0".equals(status)) && TimeUtils.compareDateTime((String)end_date, (String)current_time, (SimpleDateFormat)TimeUtils.DATE_FORMAT_DATE)) continue;
            if (TimeUtils.compareDateTime((String)end_date, (String)current_time, (SimpleDateFormat)TimeUtils.DATE_FORMAT_DATE) && !"2".equals(coupon_status)) {
                jsonObject1.put("status", (Object)"3");
            }
            jsonObject.putAll((Map)jsonObject1);
            coupon_type = coupon.getCoupon_type_id();
            query1 = new Query((CriteriaDefinition)Criteria.where((String)"_id").is((Object)new ObjectId(coupon_type)));
            couponType = (CouponType)this.mongoTemplate.findOne(query1, CouponType.class);
            jsonObject.putAll((Map)JSON.parseObject((String)couponType.toString()));
            array.add((Object)jsonObject);
        }
        int endIndex = (page_num + 1) * page_size;
        if (endIndex > array.size()) {
            endIndex = array.size();
        }
        JSONArray coupon_list = new JSONArray();
        for (int i = page_num * page_size; i < endIndex; ++i) {
            coupon_list.add((Object)array.getJSONObject(i));
        }
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("message", (Object)coupon_list);
        return new DataResponse().setData(jsonObject).setCode("0").setStatus(Status.SUCCESS);
    }

    public DataResponse newVip(DataRequest dataRequest) {
        JSONObject data = dataRequest.getData();
        String user_id = data.getString("user_id");
        String query_type = data.getString("query_type");
        int page_num = data.getIntValue("page_num");
        int page_size = data.getIntValue("page_size");
        String time = TimeUtils.getCurrentTimeInString((SimpleDateFormat)TimeUtils.DATE_FORMAT_DATE_NO);
        String time_ = TimeUtils.getCurrentTimeInString((SimpleDateFormat)TimeUtils.DATE_FORMAT_DATE);
        String time_Y = "";
        String time_M = "";
        String time_W = "";
        String time_D = "";
        JSONObject jsonObject = new JSONObject();
        try {
            String[] strings = TimeUtils.convertTime((String)time).split(",");
            time_Y = strings[0];
            time_M = strings[1];
            Query query_ = new Query();
            query_.addCriteria((CriteriaDefinition)Criteria.where((String)"user_id").is((Object)user_id));
            User user_ = (User)this.mongoTemplate.findOne(query_, User.class);
            String u_uin = user_.getUin();
            Criteria criteria = new Criteria();
            criteria.and("user_id").is((Object)user_id);
            criteria.and("u_uin").is((Object)u_uin);
            if ("daily".equals(query_type)) {
                criteria.and("created_date").regex(time_);
            }
            if ("weekly".equals(query_type)) {
                String[] split = TimeUtils.getWeek((String)time_).split(",");
                String monday = split[0] + " 00:00:00";
                String sunday = split[6] + " 23:59:59";
                criteria.and("created_date").gte((Object)monday).lte((Object)sunday);
            }
            if ("monthly".equals(query_type)) {
                criteria.and("created_date").regex(time_Y + "-" + time_M + "-");
            }
            Query query = new Query((CriteriaDefinition)criteria).skip(page_num * page_size).limit(page_size);
            log.info("--newVip--" + query);
            List vipList = this.mongoTemplate.find(query, Vip.class);
            jsonObject.put("message", (Object)vipList);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return new DataResponse().setData(jsonObject).setCode("0").setStatus(Status.SUCCESS);
    }

    public DataResponse birthdayVip(DataRequest dataRequest) {
        JSONObject data = dataRequest.getData();
        String user_id = data.getString("user_id");
        String query_type = data.getString("query_type");
        int page_num = data.getIntValue("page_num");
        int page_size = data.getIntValue("page_size");
        JSONObject jsonObject = new JSONObject();
        try {
            String time = TimeUtils.getCurrentTimeInString((SimpleDateFormat)TimeUtils.DATE_FORMAT_DATE_NO);
            String time_Y = "";
            String time_M = "";
            String time_W = "";
            String time_D = "";
            String[] strings = TimeUtils.convertTime((String)time).split(",");
            time_Y = strings[0];
            time_M = strings[1];
            time_W = strings[2];
            time_D = strings[3];
            Query query_ = new Query();
            query_.addCriteria((CriteriaDefinition)Criteria.where((String)"user_id").is((Object)user_id));
            User user_ = (User)this.mongoTemplate.findOne(query_, User.class);
            String u_uin = user_.getUin();
            Criteria criteria = new Criteria();
            criteria.and("user_id").is((Object)user_id);
            criteria.and("u_uin").is((Object)u_uin);
            if ("daily".equals(query_type)) {
                criteria.and("birthday").regex(time_M + "-" + time_D);
            }
            if ("monthly".equals(query_type)) {
                criteria.and("birthday").regex("-" + time_M + "-");
            }
            if ("next_monthly".equals(query_type)) {
                int month = Integer.parseInt(time_M);
                month = month == 12 ? 1 : ++month;
                time_M = month < 10 ? "0" + month : "" + month;
                criteria.and("birthday").regex("-" + time_M + "-");
            }
            Query query = new Query((CriteriaDefinition)criteria).skip(page_num * page_size).limit(page_size);
            log.info("--birthdayVip--" + query);
            List vipList = this.mongoTemplate.find(query, Vip.class);
            jsonObject.put("message", (Object)vipList);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return new DataResponse().setData(jsonObject).setCode("0").setStatus(Status.SUCCESS);
    }

    public DataResponse consumeVip(DataRequest dataRequest) {
        DBCollection collection = this.mongoTemplate.getCollection("def_order");
        BasicDBList basicDBList = new BasicDBList();
        BasicDBObject basic_ = new BasicDBObject();
        JSONObject data = dataRequest.getData();
        String user_id = data.getString("user_id");
        String query_type = data.getString("query_type");
        int page_num = data.getIntValue("page_num");
        int page_size = data.getIntValue("page_size");
        JSONObject jsonObject = new JSONObject();
        try {
            BasicDBObject basic;
            String time = TimeUtils.getCurrentTimeInString((SimpleDateFormat)TimeUtils.DATE_FORMAT_DATE_NO);
            String week = TimeUtils.getWeek((String)TimeUtils.getCurrentTimeInString((SimpleDateFormat)TimeUtils.DATE_FORMAT_DATE));
            String time_Y = "";
            String time_M = "";
            String time_D = "";
            String[] strings = TimeUtils.convertTime((String)time).split(",");
            time_Y = strings[0];
            time_M = strings[1];
            time_D = strings[3];
            BasicDBObject basicDBObject = new BasicDBObject();
            basicDBObject.put((Object)"user_id", (Object)user_id);
            basicDBObject.put((Object)"pay_status", (Object)"1");
            basicDBList.add((Object)basicDBObject);
            if ("monthly".equals(query_type)) {
                basic = new BasicDBObject();
                basic.put((Object)"$regex", (Object)(time_Y + "-" + time_M));
                basicDBList.add((Object)new BasicDBObject("order_time", (Object)basic));
            }
            if ("weekly".equals(query_type)) {
                String monday = week.split(",")[0] + " 00:00:00";
                String sunday = week.split(",")[6] + " 23:59:59";
                BasicDBObject bas = new BasicDBObject();
                bas.put((Object)"$gte", (Object)monday);
                basicDBList.add((Object)new BasicDBObject("order_time", (Object)bas));
                BasicDBObject basi = new BasicDBObject();
                basi.put((Object)"$lte", (Object)sunday);
                basicDBList.add((Object)new BasicDBObject("order_time", (Object)basi));
            }
            if ("daily".equals(query_type)) {
                basic = new BasicDBObject();
                basic.put((Object)"$regex", (Object)(time_Y + "-" + time_M + "-" + time_D));
                basicDBList.add((Object)new BasicDBObject("order_time", (Object)basic));
            }
            basic_.put((Object)"$and", (Object)basicDBList);
            log.info("--$match---" + basic_);
            BasicDBObject match_user = new BasicDBObject("$match", (Object)basic_);
            BasicDBObject groupField = new BasicDBObject("_id", (Object)"$order_vip.vip_id");
            groupField.put("sum_amount", (Object)new BasicDBObject("$sum", (Object)"$order_amount_pay"));
            BasicDBObject group_user = new BasicDBObject("$group", (Object)groupField);
            BasicDBObject basicSkip = new BasicDBObject("$skip", (Object)(page_num * page_size));
            BasicDBObject basicLimit = new BasicDBObject("$limit", (Object)page_size);
            BasicDBObject sort = new BasicDBObject();
            sort.put((Object)"sum_amount", (Object)-1);
            BasicDBObject agg_sort = new BasicDBObject("$sort", (Object)sort);
            AggregationOutput output_user = collection.aggregate((DBObject)match_user, new DBObject[]{group_user, agg_sort, basicLimit, basicSkip});
            JSONArray jsonArray = new JSONArray();
            for (DBObject dbObject : output_user.results()) {
                BasicDBObject basicDBObject1 = (BasicDBObject)dbObject;
                String vip_id = basicDBObject1.getString("_id");
                String sum_amount = basicDBObject1.getString("sum_amount");
                Criteria criteria = new Criteria();
                criteria.and("user_id").is((Object)user_id);
                criteria.and("vip_id").is((Object)vip_id);
                Query query = new Query((CriteriaDefinition)criteria);
                Vip vip = (Vip)this.mongoTemplate.findOne(query, Vip.class);
                if (null == vip) continue;
                JSONObject vipInfo = JSONObject.parseObject((String)vip.toString());
                vipInfo.put("sum_amount", (Object)NumberUtil.keepPrecision((String)sum_amount));
                jsonArray.add((Object)vipInfo);
            }
            jsonObject.put("message", (Object)jsonArray);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return new DataResponse().setData(jsonObject).setCode("0").setStatus(Status.SUCCESS);
    }

    public DataResponse recentConsumeVip(DataRequest dataRequest) {
        return null;
    }

    public DataResponse searchVip(DataRequest dataRequest) {
        DataResponse dataResponse = new DataResponse();
        JSONObject data = dataRequest.getData();
        String user_id = data.getString("user_id");
        String wx_id = data.getString("wx_id");
        String open_id = data.getString("open_id");
        String phone = data.getString("phone");
        String is_group_vip = data.getString("is_group_vip");
        Query query_ = new Query();
        query_.addCriteria((CriteriaDefinition)Criteria.where((String)"user_id").is((Object)user_id));
        User user_ = (User)this.mongoTemplate.findOne(query_, User.class);
        if (null == user_) {
            JSONObject result = new JSONObject();
            result.put("message", (Object)new JSONArray());
            return new DataResponse().setData(result).setCode("0").setStatus(Status.SUCCESS);
        }
        String u_uin = user_.getUin();
        int page_num = data.getIntValue("page_num");
        int page_size = data.getIntValue("page_size");
        DBCollection collection = this.mongoTemplate.getCollection("def_vip");
        BasicDBObject basicDB = new BasicDBObject();
        BasicDBList basicDBList1 = new BasicDBList();
        BasicDBList basicDBList1_or = new BasicDBList();
        BasicDBList basicDBList_or = new BasicDBList();
        if (org.apache.commons.lang.StringUtils.isNotBlank((String)wx_id)) {
            basicDBList1.add((Object)new BasicDBObject("wx_id", (Object)wx_id));
        }
        if (org.apache.commons.lang.StringUtils.isNotBlank((String)is_group_vip)) {
            basicDBList1.add((Object)new BasicDBObject("is_group_vip", (Object)is_group_vip));
        }
        if (org.apache.commons.lang.StringUtils.isNotBlank((String)open_id)) {
            basicDBList1.add((Object)new BasicDBObject("open_id", (Object)open_id));
        }
        if (org.apache.commons.lang.StringUtils.isNotBlank((String)phone)) {
            basicDBList1.add((Object)new BasicDBObject("vip_phone", (Object)phone));
        }
        basicDBList1.add((Object)new BasicDBObject("user_id", (Object)user_id));
        basicDBList_or.add((Object)new BasicDBObject("u_uin", (Object)u_uin));
        basicDBList_or.add((Object)new BasicDBObject("u_uin", null));
        basicDBList1.add((Object)new BasicDBObject("$or", (Object)basicDBList_or));
        basicDBList1.add((Object)new BasicDBObject("is_active", (Object)"Y"));
        if (org.apache.commons.lang.StringUtils.isNotBlank((String)data.getString("nick_name"))) {
            String search_name = data.getString("nick_name").trim();
            basicDBList1_or.add((Object)new BasicDBObject("nick_name", (Object)new BasicDBObject("$regex", (Object)search_name).append("$options", (Object)"i")));
            basicDBList1_or.add((Object)new BasicDBObject("remark_name", (Object)new BasicDBObject("$regex", (Object)search_name).append("$options", (Object)"i")));
            basicDBList1_or.add((Object)new BasicDBObject("vip_phone", (Object)new BasicDBObject("$regex", (Object)search_name).append("$options", (Object)"i")));
            basicDBList1.add((Object)new BasicDBObject("$or", (Object)basicDBList1_or));
        }
        basicDB.put((Object)"$and", (Object)basicDBList1);
        log.info((Object)basicDB);
        DBCursor dbCur = collection.find((DBObject)basicDB).skip(page_num * page_size).limit(page_size).sort((DBObject)new BasicDBObject("vip_py_initial", (Object)1));
        JSONObject jsonObject = new JSONObject();
        JSONArray vipList = new JSONArray();
        while (dbCur.hasNext()) {
            DBObject object = dbCur.next();
            Map map = object.toMap();
            Object id = map.get("_id");
            map.put("id", id.toString());
            String remark_name = (String)map.get("remark_name");
            if (org.apache.commons.lang.StringUtils.isBlank((String)StringUtils.checkString((String)remark_name))) {
                remark_name = (String)map.get("nick_name");
            }
            map.remove("vip_name");
            map.put("vip_name", remark_name);
            map.remove("_id");
            vipList.add((Object)map);
        }
        jsonObject.put("message", (Object)vipList);
        return dataResponse.setStatus(Status.SUCCESS).setData(jsonObject).setCode("0");
    }

    public DataResponse vipSearchPro(DataRequest dataRequest) {
        BasicDBObject basicDBObject2;
        BasicDBObject basicDBObject1;
        DataResponse dataResponse = new DataResponse();
        JSONObject data = dataRequest.getData();
        String user_id = data.getString("user_id");
        Query query_ = new Query();
        query_.addCriteria((CriteriaDefinition)Criteria.where((String)"user_id").is((Object)user_id));
        User user_ = (User)this.mongoTemplate.findOne(query_, User.class);
        String u_uin = user_.getUin();
        Thread thread = new Thread((Runnable)new PushServiceImpl.VipTask(user_id, u_uin));
        thread.start();
        JSONObject amount_trade = data.getJSONObject("amount_trade");
        JSONObject num_trade = data.getJSONObject("num_trade");
        JSONObject time = data.getJSONObject("join_time");
        JSONObject address = data.getJSONObject("address");
        BasicDBList basicDBList = new BasicDBList();
        if (null != time) {
            String start_time = time.getString("begin");
            String end_time = time.getString("end");
            if (org.apache.commons.lang.StringUtils.isBlank((String)start_time)) {
                start_time = "*";
            }
            if (org.apache.commons.lang.StringUtils.isBlank((String)end_time)) {
                end_time = "*";
            }
            if (!"*".equals(start_time)) {
                basicDBObject1 = new BasicDBObject();
                basicDBObject1.put((Object)"$gte", (Object)start_time);
                basicDBList.add((Object)new BasicDBObject("created_date", (Object)basicDBObject1));
            }
            if (!"*".equals(end_time)) {
                basicDBObject2 = new BasicDBObject();
                basicDBObject2.put((Object)"$lte", (Object)end_time);
                basicDBList.add((Object)new BasicDBObject("created_date", (Object)basicDBObject2));
            }
        }
        if (null != amount_trade) {
            String start_amount = amount_trade.getString("begin");
            String end_amount = amount_trade.getString("end");
            if (org.apache.commons.lang.StringUtils.isBlank((String)start_amount)) {
                start_amount = "*";
            }
            if (org.apache.commons.lang.StringUtils.isBlank((String)end_amount)) {
                end_amount = "*";
            }
            if (!"*".equals(start_amount)) {
                basicDBObject1 = new BasicDBObject();
                basicDBObject1.put((Object)"$gte", (Object)start_amount);
                basicDBList.add((Object)new BasicDBObject("amt_trade", (Object)basicDBObject1));
            }
            if (!"*".equals(end_amount)) {
                basicDBObject2 = new BasicDBObject();
                basicDBObject2.put((Object)"$lte", (Object)end_amount);
                basicDBList.add((Object)new BasicDBObject("amt_trade", (Object)basicDBObject2));
            }
        }
        if (null != num_trade) {
            String start_num = num_trade.getString("begin");
            String end_num = num_trade.getString("end");
            if (org.apache.commons.lang.StringUtils.isBlank((String)start_num)) {
                start_num = "*";
            }
            if (org.apache.commons.lang.StringUtils.isBlank((String)end_num)) {
                end_num = "*";
            }
            if (!"*".equals(start_num)) {
                basicDBObject1 = new BasicDBObject();
                basicDBObject1.put((Object)"$gte", (Object)start_num);
                basicDBList.add((Object)new BasicDBObject("num_trade", (Object)basicDBObject1));
            }
            if (!"*".equals(end_num)) {
                basicDBObject2 = new BasicDBObject();
                basicDBObject2.put((Object)"$lte", (Object)end_num);
                basicDBList.add((Object)new BasicDBObject("num_trade", (Object)basicDBObject2));
            }
        }
        if (null != address) {
            String province = address.getString("province");
            String city = address.getString("city");
            if (org.apache.commons.lang.StringUtils.isNotBlank((String)province)) {
                basicDBList.add((Object)new BasicDBObject("address_list.province_name", (Object)new BasicDBObject("$regex", (Object)province)));
            }
            if (org.apache.commons.lang.StringUtils.isNotBlank((String)city)) {
                basicDBList.add((Object)new BasicDBObject("address_list.city_name", (Object)new BasicDBObject("$regex", (Object)city)));
            }
        }
        basicDBList.add((Object)new BasicDBObject("u_uin", (Object)u_uin));
        basicDBList.add((Object)new BasicDBObject("is_active", (Object)"Y"));
        int page_num = data.getIntValue("page_num");
        int page_size = data.getIntValue("page_size");
        DBCollection collection = this.mongoTemplate.getCollection("def_vip");
        BasicDBObject basicDB = new BasicDBObject();
        basicDB.put((Object)"$and", (Object)basicDBList);
        log.info("---basicDB----" + basicDB);
        DBCursor dbCur = collection.find((DBObject)basicDB).skip(page_num * page_size).limit(page_size).sort((DBObject)new BasicDBObject("vip_py_initial", (Object)1));
        JSONObject jsonObject = new JSONObject();
        JSONArray productList = new JSONArray();
        while (dbCur.hasNext()) {
            DBObject object = dbCur.next();
            Map map = object.toMap();
            Object id = map.get("_id");
            map.put("id", id.toString());
            map.remove("_id");
            productList.add((Object)map);
        }
        jsonObject.put("message", (Object)productList);
        return dataResponse.setStatus(Status.SUCCESS).setData(jsonObject).setCode("0");
    }

    public DataResponse syncContacts(DataRequest dataRequest) {
        JSONObject data = dataRequest.getData();
        String userId = data.getString("user_id");
        String id = data.getString("sync_id");
        JSONArray contacts = data.getJSONArray("message");
        String current = TimeUtils.getCurrentTimeInString((SimpleDateFormat)TimeUtils.DATETIME_FORMAT_DATE);
        Query queryUser = new Query();
        queryUser.addCriteria((CriteriaDefinition)Criteria.where((String)"user_id").is((Object)userId));
        User user = (User)this.mongoTemplate.findOne(queryUser, User.class);
        String uin = user.getUin();
        String user_nick_name = user.getNick_name();
        String user_head_img = user.getHead_img();
        Query queryContact = new Query();
        queryContact.addCriteria((CriteriaDefinition)Criteria.where((String)"user_id").is((Object)userId));
        queryContact.addCriteria((CriteriaDefinition)Criteria.where((String)"u_uin").is((Object)uin));
        queryContact.addCriteria((CriteriaDefinition)Criteria.where((String)"wx_id").is((Object)uin));
        Vip usr_vip = (Vip)this.mongoTemplate.findOne(queryContact, Vip.class);
        if (null == usr_vip) {
            Vip vip_new = new Vip();
            vip_new.setWx_id(uin);
            vip_new.setNick_name(user_nick_name);
            vip_new.setVip_name(user_nick_name);
            vip_new.setUser_id(userId);
            vip_new.setU_uin(uin);
            vip_new.setIs_active("Y");
            vip_new.setIs_friends("Y");
            vip_new.setHead_img(user_head_img);
            vip_new.setCreated_date(current);
            vip_new.setCreator_id(userId);
            vip_new.setModifier_id(userId);
            vip_new.setRemark_name(user_nick_name);
            vip_new.setModified_date(current);
            vip_new.setIs_group_vip("N");
            this.mongoTemplate.insert((Object)vip_new);
        } else {
            Update update_user_vip = new Update();
            update_user_vip.set("is_active", (Object)"Y");
            update_user_vip.set("nick_name", (Object)user_nick_name);
            update_user_vip.set("vip_name", (Object)user_nick_name);
            update_user_vip.set("modified_date", (Object)current);
            this.mongoTemplate.upsert(queryContact, update_user_vip, Vip.class);
        }
        for (int i = 0; i < contacts.size(); ++i) {
            JSONObject jsonObject = contacts.getJSONObject(i);
            String nick_name = jsonObject.getString("nick_name");
            String wx_id = jsonObject.getString("wx_id");
            if (wx_id.startsWith("gh_")) continue;
            String sex = jsonObject.getString("sex");
            String is_group = jsonObject.getString("is_group");
            String member_count = jsonObject.getString("member_count");
            String head_image = jsonObject.getString("head_img");
            JSONArray members = jsonObject.getJSONArray("member");
            String remark_name = jsonObject.getString("remark_name");
            String province = jsonObject.getString("province");
            String city = jsonObject.getString("city");
            String py_initial = jsonObject.getString("py_initial");
            String remark_py_initial = jsonObject.getString("remark_py_initial");
            if (org.apache.commons.lang.StringUtils.isBlank((String)remark_name)) {
                remark_name = "";
            }
            if (org.apache.commons.lang.StringUtils.isBlank((String)remark_py_initial)) {
                remark_py_initial = "";
            }
            JSONArray labels = jsonObject.getJSONArray("label");
            JSONArray array = new JSONArray();
            if (null != labels) {
                for (int j = 0; j < labels.size(); ++j) {
                    JSONObject label_name = new JSONObject();
                    String label_object = labels.getString(j);
                    label_name.put("vip_group_id", (Object)label_object);
                    array.add((Object)label_name);
                }
            }
            String u_uin = jsonObject.getString("u_uin");
            String key = userId + "-" + u_uin + "-" + wx_id;
            this.redisClient.getValueOps().setValueStringWithExpire(key, remark_name, Long.valueOf(10000L));
            sex = sex.equals("1") ? "M" : "F";
            Query query = new Query();
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"user_id").is((Object)userId));
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"u_uin").is((Object)u_uin));
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"wx_id").is((Object)wx_id));
            Update update = new Update();
            update.set("is_friends", (Object)"Y");
            update.set("is_active", (Object)"Y");
            update.set("nick_name", (Object)nick_name);
            update.set("head_img", (Object)head_image);
            update.set("vip_py_initial", (Object)(org.apache.commons.lang.StringUtils.isNotBlank((String)remark_py_initial) ? remark_py_initial : py_initial));
            update.set("vip_name", (Object)(org.apache.commons.lang.StringUtils.isNotBlank((String)remark_name) ? remark_name : nick_name));
            update.set("remark_name", (Object)remark_name);
            if ("true".equals(is_group)) {
                update.set("members", (Object)members);
                update.set("member_count", (Object)member_count);
                update.set("is_group_vip", (Object)"Y");
            } else {
                update.set("is_group_vip", (Object)"N");
            }
            Vip vip = (Vip)this.mongoTemplate.findOne(query, Vip.class);
            if (null != vip) {
                JSONArray jsonArray = vip.getVipGroups();
                if (null != jsonArray) {
                    for (int j = 0; j < jsonArray.size(); ++j) {
                        JSONObject jsonObject1 = jsonArray.getJSONObject(j);
                        String group_id = jsonObject1.getString("vip_group_id");
                        if (group_id.length() <= 4) continue;
                        JSONObject a = new JSONObject();
                        a.put("vip_group_id", (Object)group_id);
                        array.add((Object)a);
                    }
                }
                update.set("vipGroups", (Object)array);
                update.set("modified_date", (Object)current);
                this.mongoTemplate.upsert(query, update, Vip.class);
                continue;
            }
            Vip vip_new = new Vip();
            vip_new.setWx_id(wx_id);
            vip_new.setNick_name(nick_name);
            vip_new.setVip_name(org.apache.commons.lang.StringUtils.isNotBlank((String)remark_name) ? remark_name : nick_name);
            vip_new.setVip_sex(sex);
            vip_new.setUser_id(userId);
            vip_new.setU_uin(u_uin);
            vip_new.setIs_active("Y");
            vip_new.setIs_friends("Y");
            vip_new.setHead_img(head_image);
            vip_new.setVip_py_initial(org.apache.commons.lang.StringUtils.isNotBlank((String)remark_py_initial) ? remark_py_initial : py_initial);
            vip_new.setCreated_date(current);
            vip_new.setCreator_id(userId);
            vip_new.setModifier_id(userId);
            vip_new.setRemark_name(remark_name);
            vip_new.setModified_date(current);
            if ("true".equals(is_group)) {
                vip_new.setMembers(members);
                vip_new.setMember_count(member_count);
                vip_new.setIs_group_vip("Y");
            } else {
                vip_new.setIs_group_vip("N");
            }
            vip_new.setVipGroups(array);
            this.mongoTemplate.save((Object)vip_new);
        }
        this.redisClient.getValueOps().setValueStringWithExpire("syncContacts" + userId, Status.SUCCESS.toString(), Long.valueOf(900L));
        String sysCurr = TimeUtils.getCurrentTimeInString((SimpleDateFormat)TimeUtils.DATETIME_FORMAT_DATE);
        if (org.apache.commons.lang.StringUtils.isNotBlank((String)id)) {
            Query querySys = new Query();
            querySys.addCriteria((CriteriaDefinition)Criteria.where((String)"_id").is((Object)new ObjectId(id)));
            Update update = new Update();
            update.set("is_active", (Object)"Y");
            update.set("operation", (Object)sysCurr);
            this.mongoTemplate.upsert(querySys, update, SysContact.class);
        }
        JSONObject messageData = new JSONObject();
        messageData.put("type", (Object)"1");
        JSONObject messageContent = new JSONObject();
        messageContent.put("content", (Object)"\u8054\u7cfb\u4eba\u540c\u6b65\u6210\u529f");
        messageData.put("message_content", (Object)messageContent);
        messageData.put("user_id", (Object)userId);
        this.sendMessage.sendBackground(messageData);
        return new DataResponse().setMsg("\u540c\u6b65\u8054\u7cfb\u4eba\u6210\u529f").setCode("0").setStatus(Status.SUCCESS);
    }

    public DataResponse bingUser(DataRequest dataRequest) {
        JSONObject data = dataRequest.getData();
        String vip_id = data.getString("vip_id");
        String user_id = data.getString("user_id");
        Query query = new Query((CriteriaDefinition)Criteria.where((String)"vip_id").is((Object)vip_id));
        Update update = new Update();
        update.set("user_id", (Object)user_id);
        this.mongoTemplate.updateFirst(query, update, Vip.class);
        return new DataResponse().setCode("0").setStatus(Status.SUCCESS).setMsg("\u7ed1\u5b9a\u6210\u529f");
    }

    public DataResponse parentLabelGroup(DataRequest dataRequest) {
        DataResponse dataResponse = new DataResponse();
        JSONObject data = dataRequest.getData();
        String vip_id = data.getString("vip_id");
        DBCollection collection = this.mongoTemplate.getCollection("def_vip_group_label");
        BasicDBObject basic = new BasicDBObject();
        basic.put((Object)"parent_id", (Object)"0");
        BasicDBObject sort = new BasicDBObject();
        sort.append("level", (Object)1);
        DBCursor cursor = collection.find((DBObject)basic).sort((DBObject)sort);
        JSONObject data1 = new JSONObject();
        data1.put("list", (Object)cursor.toArray());
        return dataResponse.setStatus(Status.SUCCESS).setCode("0").setData(data1);
    }

    public DataResponse labelList(DataRequest dataRequest) {
        DataResponse dataResponse = new DataResponse();
        JSONObject data = dataRequest.getData();
        String id = data.getString("id");
        JSONArray newList = new JSONArray();
        List vipGroupLabel = this.mongoTemplate.find(Query.query((CriteriaDefinition)Criteria.where((String)"parent_id").is((Object)id)), VipGroupLabel.class);
        for (int i = 0; i < vipGroupLabel.size(); ++i) {
            VipGroupLabel vipGroupLabel1 = (VipGroupLabel)vipGroupLabel.get(i);
            String label_group_id = vipGroupLabel1.getLabel_group_id();
            List vipLabel = this.mongoTemplate.find(Query.query((CriteriaDefinition)Criteria.where((String)"label_group_id").is((Object)label_group_id)), VipLabel.class);
            JSONObject jsonObject = JSONObject.parseObject((String)vipGroupLabel1.toString());
            JSONArray vipLabelArray = new JSONArray();
            vipLabel.stream().forEach(vipLabel1 -> vipLabelArray.add(JSONObject.parse((String)vipLabel1.toString())));
            jsonObject.put("vipLabelList", (Object)vipLabelArray);
            newList.add((Object)jsonObject);
        }
        JSONObject data1 = new JSONObject();
        data1.put("list", (Object)newList);
        return dataResponse.setStatus(Status.SUCCESS).setCode("0").setData(data1);
    }

    public DataResponse vipBehaviorV2(DataRequest dataRequest) {
        JSONObject data = dataRequest.getData();
        String user_id = data.getString("user_id");
        String vip_id = data.getString("vip_id");
        Integer page_size = data.getInteger("page_size");
        Integer page_num = data.getInteger("page_num");
        Criteria criteria = new Criteria();
        if (org.apache.commons.lang.StringUtils.isNotBlank((String)vip_id)) {
            criteria.and("vip_id").is((Object)vip_id);
        }
        if (org.apache.commons.lang.StringUtils.isNotBlank((String)user_id)) {
            criteria.and("user_id").is((Object)user_id);
        }
        Aggregation customerAgg = Aggregation.newAggregation((AggregationOperation[])new AggregationOperation[]{Aggregation.match((Criteria)criteria), Aggregation.group((String[])new String[]{"operate_time"}).addToSet("log_id").as("log_id"), Aggregation.skip((int)(page_num * page_size)), Aggregation.limit((long)page_size.intValue())});
        AggregationResults aggregate = this.mongoTemplate.aggregate(customerAgg, "log_vip_operation", JSONObject.class);
        List results = aggregate.getMappedResults();
        JSONArray array = new JSONArray();
        results.stream().forEach(result -> {
            JSONObject object = new JSONObject();
            JSONArray array1 = result.getJSONArray("log_id");
            String _id = result.getString("_id");
            object.put("time", (Object)_id);
            JSONArray list = new JSONArray();
            for (int i = 0; i < array1.size(); ++i) {
                JSONObject object1 = new JSONObject();
                String log_id = array1.getString(i);
                LogVipOperation vipOperation = (LogVipOperation)this.mongoTemplate.findOne(Query.query((CriteriaDefinition)Criteria.where((String)"log_id").is((Object)log_id)), LogVipOperation.class);
                object1.put("vipBehavior", (Object)vipOperation);
                list.add((Object)object1);
            }
            object.put("list", (Object)list);
            array.add((Object)object);
        });
        JSONObject restltData = new JSONObject();
        restltData.put("message", (Object)array);
        return new DataResponse().setData(restltData).setCode("0").setStatus(Status.SUCCESS);
    }

    public static void main(String[] args) {
        System.out.println(TimeUtils.getTimeBeforDay((int)2, (SimpleDateFormat)TimeUtils.DATE_FORMAT_DATE));
    }

    public DataResponse vipBehavior(DataRequest dataRequest) {
        DBCollection collection = this.mongoTemplate.getCollection("def_log_vip_operation");
        JSONObject data = dataRequest.getData();
        String user_id = data.getString("user_id");
        String vip_id = data.getString("vip_id");
        Integer page_size = data.getInteger("page_size");
        Integer page_num = data.getInteger("page_num");
        BasicDBObject basicDBObject = new BasicDBObject();
        if (org.apache.commons.lang.StringUtils.isNotBlank((String)vip_id)) {
            Vip vip = (Vip)this.mongoTemplate.findOne(Query.query((CriteriaDefinition)Criteria.where((String)"vip_id").is((Object)vip_id)), Vip.class);
            String miniOpenId = vip.getMini_openid();
            BasicDBList basicDBList = new BasicDBList();
            basicDBList.add((Object)new BasicDBObject("vip_id", (Object)vip_id));
            basicDBList.add((Object)new BasicDBObject("open_id", (Object)miniOpenId));
            basicDBObject.put((Object)"$or", (Object)basicDBList);
        } else if (org.apache.commons.lang.StringUtils.isNotBlank((String)user_id)) {
            basicDBObject.put((Object)"user_id", (Object)user_id);
        }
        basicDBObject.put((Object)"operate_time", (Object)new BasicDBObject("$gte", (Object)TimeUtils.getTimeBeforDay((int)3, (SimpleDateFormat)TimeUtils.DATE_FORMAT_DATE)));
        BasicDBObject match_user = new BasicDBObject("$match", (Object)basicDBObject);
        BasicDBObject groupField = new BasicDBObject("_id", (Object)"$operate_time");
        groupField.put("log_id", (Object)new BasicDBObject("$addToSet", (Object)"$log_id"));
        BasicDBObject group_user = new BasicDBObject("$group", (Object)groupField);
        BasicDBObject basicSkip = new BasicDBObject("$skip", (Object)(page_num * page_size));
        BasicDBObject basicLimit = new BasicDBObject("$limit", (Object)page_size);
        BasicDBObject sort = new BasicDBObject();
        sort.put((Object)"_id", (Object)-1);
        BasicDBObject agg_sort = new BasicDBObject("$sort", (Object)sort);
        BasicDBObject project = new BasicDBObject();
        project.put((Object)"operate_time", (Object)1);
        project.put((Object)"log_id", (Object)1);
        BasicDBObject projects = new BasicDBObject();
        projects.put((Object)"$project", (Object)project);
        AggregationOutput output_user = collection.aggregate((DBObject)match_user, new DBObject[]{projects, group_user, agg_sort, basicLimit, basicSkip});
        JSONArray list = new JSONArray();
        JSONArray array = new JSONArray();
        for (DBObject dbObject : output_user.results()) {
            BasicDBObject basicDBObject1 = (BasicDBObject)dbObject;
            JSONObject object = new JSONObject();
            JSONArray array1 = JSONArray.parseArray((String)basicDBObject1.get("log_id").toString());
            String _id = basicDBObject1.getString("_id");
            object.put("time", (Object)_id);
            for (int i = 0; i < array1.size(); ++i) {
                String log_id = array1.getString(i);
                LogVipOperation vipOperation = (LogVipOperation)this.mongoTemplate.findOne(Query.query((CriteriaDefinition)Criteria.where((String)"log_id").is((Object)log_id)), LogVipOperation.class);
                list.add((Object)JSONObject.parseObject((String)vipOperation.toString()));
            }
            JSONArray array2 = JSONArraySortUtil.sortDesc((JSONArray)list, (String)"created_time");
            JSONArray array3 = new JSONArray();
            for (int i = 0; i < array2.size(); ++i) {
                JSONObject jsonObject = new JSONObject();
                JSONObject object1 = array2.getJSONObject(i);
                jsonObject.put("vipBehavior", (Object)object1);
                array3.add((Object)jsonObject);
            }
            object.put("list", (Object)array3);
            array.add((Object)object);
        }
        JSONObject restltData = new JSONObject();
        restltData.put("message", (Object)array);
        return new DataResponse().setData(restltData).setCode("0").setStatus(Status.SUCCESS);
    }
}

