/*
 * Decompiled with CFR 0.152.
 */
package kr.weitao.weitaokr.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.mongodb.BasicDBObject;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import com.mongodb.WriteResult;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.util.Date;
import java.util.List;
import kr.weitao.business.entity.ApplyRefund;
import kr.weitao.business.entity.Store;
import kr.weitao.business.entity.SysContact;
import kr.weitao.common.util.StringUtils;
import kr.weitao.common.util.TimeUtils;
import kr.weitao.starter.model.DataRequest;
import kr.weitao.starter.model.DataResponse;
import kr.weitao.starter.model.Status;
import kr.weitao.starter.util.redis.RedisClient;
import kr.weitao.weitaokr.service.JobService;
import kr.weitao.weitaokr.service.UserService;
import kr.weitao.weitaokr.service.WxService;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bson.types.ObjectId;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.stereotype.Service;

@Service
public class USerServiceImpl
implements UserService {
    private static final Logger log = LogManager.getLogger(USerServiceImpl.class);
    @Autowired
    MongoTemplate mongoTemplate;
    @Autowired
    WxService wxService;
    @Autowired
    RedisClient redisClient;
    @Autowired
    JobService jobService;

    public DataResponse syncContacts(DataRequest dataRequest) {
        JSONObject data = dataRequest.getData();
        String user_id = data.getString("user_id");
        String redis_time = this.redisClient.getValueOps().getValueString("syncContacts" + user_id);
        log.info("--redis_time--" + user_id + "----" + redis_time);
        if (StringUtils.isNull((Object)redis_time)) {
            String now = TimeUtils.getCurrentTimeInString((SimpleDateFormat)TimeUtils.DATETIME_FORMAT_DATE);
            try {
                String team_before = TimeUtils.getHourAfter((double)-0.3, (String)now, (SimpleDateFormat)TimeUtils.DATETIME_FORMAT_DATE);
                BasicDBObject basicDBObject = new BasicDBObject();
                basicDBObject.put((Object)"data.user_id", (Object)user_id);
                basicDBObject.put((Object)"is_active", (Object)"N");
                basicDBObject.put((Object)"created_date", (Object)new BasicDBObject("$gt", (Object)team_before));
                basicDBObject.put((Object)"cause", (Object)new BasicDBObject("$ne", (Object)"\u5f53\u524d\u5fae\u4fe1\u6682\u672a\u7ed1\u5b9a"));
                long count = this.mongoTemplate.getCollection("def_sys_contacts").count((DBObject)basicDBObject);
                if (count != 0L) {
                    return new DataResponse().setStatus(Status.FAILED).setCode("-1").setMsg("\u6b63\u5728\u540c\u6b65\u4e2d\u2026\u2026");
                }
                this.redisClient.getValueOps().setValueObjectWithExpire("syncContacts" + user_id, (Object)Status.ONGOING.toString(), Long.valueOf(1800L));
                SysContact sysContact = new SysContact();
                sysContact.setData(dataRequest.getData());
                sysContact.setIs_active("N");
                sysContact.setCreated_date(TimeUtils.getCurrentTimeInString((SimpleDateFormat)TimeUtils.DATETIME_FORMAT_DATE));
                this.mongoTemplate.insert((Object)sysContact, "def_sys_contacts");
                String cron = TimeUtils.getHourAfter((double)0.02, (String)now, (SimpleDateFormat)TimeUtils.DATETIME_FORMAT_DATE);
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("is_active", (Object)"Y");
                jsonObject.put("class_name", (Object)"kr.weitao.weitaokr.task.vip.vipSys.VipSysJob");
                jsonObject.put("user_id", (Object)user_id);
                jsonObject.put("creator_id", (Object)user_id);
                jsonObject.put("modifier_id", (Object)user_id);
                jsonObject.put("created_date", (Object)now);
                jsonObject.put("modified_date", (Object)now);
                jsonObject.put("_id", (Object)sysContact.get_id().toString());
                jsonObject.put("total_count", (Object)"1");
                jsonObject.put("status", (Object)"-1");
                JSONObject recurrence = new JSONObject();
                recurrence.put("cron", (Object)TimeUtils.getCron((Date)TimeUtils.DATETIME_FORMAT_DATE.parse(cron)));
                recurrence.put("type", (Object)"Fixed");
                jsonObject.put("recurrence", (Object)recurrence);
                int a = this.jobService.addJob(jsonObject);
                log.info("#######\u521b\u5efa\u5b9a\u65f6\u4efb\u52a1  \u540c\u6b65\u8054\u7cfb\u4eba#####" + a);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else if (!"SUCCESS".equals(redis_time)) {
            return new DataResponse().setStatus(Status.FAILED).setCode("-1").setMsg("\u6b63\u5728\u540c\u6b65\u4e2d\u2026\u2026");
        }
        JSONObject object = new JSONObject();
        object.put("message", (Object)"\u540c\u6b65\u6210\u529f");
        return new DataResponse().setStatus(Status.SUCCESS).setData(object).setCode("0").setMsg("\u540c\u6b65\u6210\u529f");
    }

    public DataResponse userLogSave(DataRequest dataRequest) {
        JSONObject data = dataRequest.getData();
        String user_id = data.getString("user_id");
        String time = TimeUtils.getCurrentTimeInString((SimpleDateFormat)TimeUtils.DATE_FORMAT_DATE);
        LocalDateTime currentTime = LocalDateTime.now();
        JSONObject object = new JSONObject();
        object.put("user_id", (Object)user_id);
        BasicDBObject query = new BasicDBObject();
        query.put((Object)"login_time", (Object)time);
        BasicDBObject update = new BasicDBObject();
        BasicDBObject basicDBObject = new BasicDBObject();
        basicDBObject.put((Object)(currentTime.getHour() + ""), (Object)object);
        update.put((Object)"$addToSet", (Object)basicDBObject);
        WriteResult writeResult = this.mongoTemplate.getCollection("def_user_login").update((DBObject)query, (DBObject)update, true, true);
        return new DataResponse().setStatus(Status.SUCCESS).setCode("0").setMsg("\u8bb0\u5f55\u6210\u529f");
    }

    public DataResponse storeQueryList(JSONObject data) {
        String corp_code = data.getString("corp_code");
        Integer page_size = data.getInteger("page_size");
        Integer page_num = data.getInteger("page_num");
        if (StringUtils.isNull((Object)corp_code)) {
            return new DataResponse().setMsg("\u4f01\u4e1a\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a").setStatus(Status.FAILED).setCode("-1");
        }
        String value = data.getString("search_value");
        Query query = new Query();
        if (StringUtils.isNotNull((Object)value)) {
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"store_name").regex(value, "i"));
        }
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"corp_code").is((Object)corp_code));
        query.skip(page_num * page_size);
        query.limit(page_size.intValue());
        List storeList = this.mongoTemplate.find(query, Store.class);
        JSONObject object = new JSONObject();
        object.put("list", (Object)storeList);
        return new DataResponse().setMsg("\u67e5\u8be2\u6210\u529f").setStatus(Status.SUCCESS).setCode("0").setData(object);
    }

    public DataResponse applyRefundOperate(JSONObject data) {
        String id = data.getString("id");
        JSONObject address = data.getJSONObject("address");
        this.mongoTemplate.updateFirst(Query.query((CriteriaDefinition)Criteria.where((String)"_id").is((Object)new ObjectId(id))), Update.update((String)"address", (Object)address), ApplyRefund.class);
        return new DataResponse().setMsg("").setStatus(Status.SUCCESS).setCode("0");
    }

    public DataResponse userPaymentAccount(DataRequest dataRequest) {
        DataResponse dataResponse = new DataResponse();
        JSONObject data = dataRequest.getData();
        String user_id = data.getString("user_id");
        String team_id = data.getString("team_id");
        BasicDBObject payment_account_query = new BasicDBObject();
        JSONArray array = new JSONArray();
        payment_account_query = StringUtils.isNotNull((Object)team_id) ? new BasicDBObject("team_id", (Object)team_id) : new BasicDBObject("creator_id", (Object)user_id);
        log.debug("query:" + payment_account_query.toString());
        DBCursor payment_accounts = this.mongoTemplate.getCollection("def_payment_account").find((DBObject)payment_account_query);
        while (payment_accounts.hasNext()) {
            DBObject object = payment_accounts.next();
            object.put("id", (Object)object.get("_id").toString());
            object.removeField("_id");
            array.add((Object)object);
        }
        JSONObject result = new JSONObject();
        result.put("message", (Object)array);
        return dataResponse.setCode("0").setStatus(Status.SUCCESS).setData(result);
    }
}

