/*
 * Decompiled with CFR 0.152.
 */
package kr.weitao.weitaokr.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.mongodb.AggregationOutput;
import com.mongodb.BasicDBList;
import com.mongodb.BasicDBObject;
import com.mongodb.DBCollection;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kr.weitao.business.common.agent.TeamAgent;
import kr.weitao.business.common.feignclient.TeamService;
import kr.weitao.common.util.AliCDNUrlAuth;
import kr.weitao.common.util.NumberUtil;
import kr.weitao.common.util.StringUtils;
import kr.weitao.common.util.TimeUtils;
import kr.weitao.starter.model.DataRequest;
import kr.weitao.starter.model.DataResponse;
import kr.weitao.starter.model.Status;
import kr.weitao.starter.util.mongodb.MongodbClient;
import kr.weitao.starter.util.oss.BlobClient;
import kr.weitao.starter.util.redis.RedisClient;
import kr.weitao.weitaokr.service.SaleService;
import kr.weitao.weitaokr.service.common.UserRedisUtils;
import org.apache.commons.lang.RandomStringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bson.types.ObjectId;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Service;

@Service
public class SaleServiceImpl
implements SaleService {
    private static final Logger log = LogManager.getLogger(SaleServiceImpl.class);
    @Autowired
    MongoTemplate mongoTemplate;
    @Autowired
    MongodbClient mongodbClient;
    @Autowired
    BlobClient blobClient;
    @Autowired
    UserRedisUtils user_redis_utils;
    @Autowired
    TeamService teamService;
    @Autowired
    TeamAgent team_agent;
    @Autowired
    RedisClient redisClient;
    @Autowired
    AliCDNUrlAuth aliCDNUrlAuth;

    public DataResponse queryTeamSale(DataRequest dataRequest) {
        JSONObject data = dataRequest.getData();
        BasicDBList basicDBList = new BasicDBList();
        BasicDBObject basic_ = new BasicDBObject();
        String user_id = data.getString("user_id");
        String team_id = data.getString("team_id");
        String query_type = data.getString("query_type");
        String saleInfo = this.redisClient.getValueOps().getValueString("queryTeamSaleteam_" + team_id + query_type + user_id);
        JSONObject team_info = new JSONObject();
        JSONObject team = new JSONObject();
        team.put("team_id", (Object)team_id);
        team.put("is_contains_self", (Object)"Y");
        team.put("is_all_child", (Object)"Y");
        try {
            team_info = this.team_agent.getData(team, "/team/getChildTeams");
        }
        catch (Exception e) {
            log.error("get team_info error:" + e.getLocalizedMessage(), (Throwable)e);
        }
        List teamIds = (List)team_info.get((Object)"list");
        JSONObject object = new JSONObject();
        if (null != saleInfo) {
            object = JSONObject.parseObject((String)saleInfo);
        } else {
            DBCollection collection = this.mongoTemplate.getCollection("def_order");
            String time = TimeUtils.getCurrentTimeInString((SimpleDateFormat)TimeUtils.DATE_FORMAT_DATE_NO);
            String time_Y = "";
            String time_M = "";
            String time_D = "";
            String[] strings = new String[]{};
            try {
                strings = TimeUtils.convertTime((String)time).split(",");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            time_Y = strings[0];
            time_M = strings[1];
            time_D = strings[3];
            if (StringUtils.isNotNull((Object)query_type)) {
                BasicDBObject basic;
                if ("all".equals(query_type)) {
                    // empty if block
                }
                if ("daily".equals(query_type)) {
                    basic = new BasicDBObject();
                    basic.put((Object)"$regex", (Object)(time_Y + "-" + time_M + "-" + time_D));
                    basicDBList.add((Object)new BasicDBObject("created_date", (Object)basic));
                }
                if ("monthly".equals(query_type)) {
                    basic = new BasicDBObject();
                    basic.put((Object)"$regex", (Object)(time_Y + "-" + time_M));
                    basicDBList.add((Object)new BasicDBObject("created_date", (Object)basic));
                }
                if ("yearly".equals(query_type)) {
                    basic = new BasicDBObject();
                    basic.put((Object)"$regex", (Object)time_Y);
                    basicDBList.add((Object)new BasicDBObject("created_date", (Object)basic));
                }
            }
            BasicDBObject basicDBObject = new BasicDBObject();
            basicDBList.add((Object)basicDBObject);
            basicDBObject.put((Object)"pay_status", (Object)"1");
            basicDBObject.put((Object)"productList.team_id", (Object)new BasicDBObject("$in", (Object)teamIds));
            basicDBObject.put((Object)"is_active", (Object)"Y");
            basic_.put((Object)"$and", (Object)basicDBList);
            log.info("--$match---" + basic_);
            BasicDBObject match_user = new BasicDBObject("$match", (Object)basic_);
            BasicDBObject groupField = new BasicDBObject("_id", (Object)"$user_id");
            groupField.put("amount_trade", (Object)new BasicDBObject("$sum", (Object)"$order_amount_pay"));
            groupField.put("num_sales", (Object)new BasicDBObject("$sum", (Object)"$order_num"));
            BasicDBObject group_user = new BasicDBObject("$group", (Object)groupField);
            AggregationOutput output_user = collection.aggregate((DBObject)match_user, new DBObject[]{group_user});
            Double amount_trade_double_all = 0.0;
            Double amount_trade_double = 0.0;
            Double sale_num_sales_double = 0.0;
            HashMap<String, String> map = new HashMap<String, String>();
            for (Object dbObject : output_user.results()) {
                BasicDBObject basicDBObject1 = (BasicDBObject)dbObject;
                amount_trade_double = amount_trade_double + basicDBObject1.getDouble("amount_trade");
                sale_num_sales_double = sale_num_sales_double + basicDBObject1.getDouble("num_sales");
            }
            amount_trade_double_all = amount_trade_double_all + amount_trade_double;
            log.info("amount_trade_double_all--" + amount_trade_double_all);
            basicDBList = new BasicDBList();
            basic_ = new BasicDBObject();
            if (StringUtils.isNotNull((Object)query_type)) {
                BasicDBObject basic;
                if ("all".equals(query_type)) {
                    // empty if block
                }
                if ("daily".equals(query_type)) {
                    basic = new BasicDBObject();
                    basic.put((Object)"$regex", (Object)(time_Y + "-" + time_M + "-" + time_D));
                    basicDBList.add((Object)new BasicDBObject("created_date", (Object)basic));
                }
                if ("monthly".equals(query_type)) {
                    basic = new BasicDBObject();
                    basic.put((Object)"$regex", (Object)(time_Y + "-" + time_M));
                    basicDBList.add((Object)new BasicDBObject("created_date", (Object)basic));
                }
                if ("yearly".equals(query_type)) {
                    basic = new BasicDBObject();
                    basic.put((Object)"$regex", (Object)time_Y);
                    basicDBList.add((Object)new BasicDBObject("created_date", (Object)basic));
                }
            }
            basicDBObject = new BasicDBObject();
            basicDBList.add((Object)basicDBObject);
            basicDBObject.put((Object)"pay_status", (Object)"1");
            basicDBObject.put((Object)"order_status", (Object)"1");
            basicDBObject.put((Object)"productList.team_id", (Object)new BasicDBObject("$in", (Object)teamIds));
            basicDBObject.put((Object)"is_active", (Object)"Y");
            basic_.put((Object)"$and", (Object)basicDBList);
            log.info("--$match---" + basic_);
            match_user = new BasicDBObject("$match", (Object)basic_);
            groupField = new BasicDBObject("_id", (Object)"$logistics_user");
            groupField.put("amount_trade", (Object)new BasicDBObject("$sum", (Object)"$order_amount_pay"));
            groupField.put("num_sales", (Object)new BasicDBObject("$sum", (Object)"$order_num"));
            group_user = new BasicDBObject("$group", (Object)groupField);
            output_user = collection.aggregate((DBObject)match_user, new DBObject[]{group_user});
            Double logistics_num_sales_double = 0.0;
            for (DBObject dbObject : output_user.results()) {
                BasicDBObject basicDBObject1 = (BasicDBObject)dbObject;
                logistics_num_sales_double = logistics_num_sales_double + basicDBObject1.getDouble("num_sales");
            }
            basicDBList = new BasicDBList();
            basic_ = new BasicDBObject();
            if (StringUtils.isNotNull((Object)query_type)) {
                BasicDBObject basic;
                if ("all".equals(query_type)) {
                    // empty if block
                }
                if ("daily".equals(query_type)) {
                    basic = new BasicDBObject();
                    basic.put((Object)"$regex", (Object)(time_Y + "-" + time_M + "-" + time_D));
                    basicDBList.add((Object)new BasicDBObject("created_date", (Object)basic));
                }
                if ("monthly".equals(query_type)) {
                    basic = new BasicDBObject();
                    basic.put((Object)"$regex", (Object)(time_Y + "-" + time_M));
                    basicDBList.add((Object)new BasicDBObject("created_date", (Object)basic));
                }
                if ("yearly".equals(query_type)) {
                    basic = new BasicDBObject();
                    basic.put((Object)"$regex", (Object)time_Y);
                    basicDBList.add((Object)new BasicDBObject("created_date", (Object)basic));
                }
            }
            basicDBObject = new BasicDBObject();
            basicDBList.add((Object)basicDBObject);
            basicDBObject.put((Object)"exclusive_user", (Object)new BasicDBObject("$ne", null));
            basicDBObject.put((Object)"pay_status", (Object)"1");
            basicDBObject.put((Object)"productList.team_id", (Object)new BasicDBObject("$in", (Object)teamIds));
            basicDBObject.put((Object)"is_active", (Object)"Y");
            basic_.put((Object)"$and", (Object)basicDBList);
            log.info("--$match---" + basic_);
            match_user = new BasicDBObject("$match", (Object)basic_);
            groupField = new BasicDBObject("_id", (Object)"$exclusive_user");
            groupField.put("amount_trade", (Object)new BasicDBObject("$sum", (Object)"$order_amount_pay"));
            groupField.put("num_sales", (Object)new BasicDBObject("$sum", (Object)"$order_num"));
            group_user = new BasicDBObject("$group", (Object)groupField);
            output_user = collection.aggregate((DBObject)match_user, new DBObject[]{group_user});
            Double exclusive_num_sales_double = 0.0;
            for (DBObject dbObject : output_user.results()) {
                BasicDBObject basicDBObject1 = (BasicDBObject)dbObject;
                exclusive_num_sales_double = exclusive_num_sales_double + basicDBObject1.getDouble("num_sales");
            }
            map.put("amount_trade", NumberUtil.keepPrecision((double)amount_trade_double_all));
            map.put("delivery_num", NumberUtil.keepPrecision((Number)logistics_num_sales_double, (int)0));
            map.put("sale_num", NumberUtil.keepPrecision((Number)sale_num_sales_double, (int)0));
            map.put("vip_num", NumberUtil.keepPrecision((Number)exclusive_num_sales_double, (int)0));
            object = JSON.parseObject((String)JSON.toJSONString(map));
            this.redisClient.getValueOps().setValueStringWithExpire("queryTeamSaleteam_" + team_id + query_type + user_id, object.toJSONString(), Long.valueOf(300L));
        }
        return new DataResponse().setStatus(Status.SUCCESS).setData(object).setCode("0");
    }

    public DataResponse querySelfSale(DataRequest dataRequest) {
        JSONObject data = dataRequest.getData();
        BasicDBList basicDBList = new BasicDBList();
        BasicDBObject basic_ = new BasicDBObject();
        String user_id = data.getString("user_id");
        String team_id = data.getString("team_id");
        String query_type = data.getString("query_type");
        String saleInfo = this.redisClient.getValueOps().getValueString("querySelfSaleteam_" + team_id + query_type + user_id);
        JSONObject object = new JSONObject();
        if (null != saleInfo) {
            object = JSONObject.parseObject((String)saleInfo);
        } else {
            DBCollection collection = this.mongoTemplate.getCollection("def_order");
            String time = TimeUtils.getCurrentTimeInString((SimpleDateFormat)TimeUtils.DATE_FORMAT_DATE_NO);
            String time_Y = "";
            String time_M = "";
            String time_D = "";
            String[] strings = new String[]{};
            try {
                strings = TimeUtils.convertTime((String)time).split(",");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            time_Y = strings[0];
            time_M = strings[1];
            time_D = strings[3];
            if (StringUtils.isNotNull((Object)query_type)) {
                BasicDBObject basic;
                if ("all".equals(query_type)) {
                    // empty if block
                }
                if ("daily".equals(query_type)) {
                    basic = new BasicDBObject();
                    basic.put((Object)"$regex", (Object)(time_Y + "-" + time_M + "-" + time_D));
                    basicDBList.add((Object)new BasicDBObject("created_date", (Object)basic));
                }
                if ("monthly".equals(query_type)) {
                    basic = new BasicDBObject();
                    basic.put((Object)"$regex", (Object)(time_Y + "-" + time_M));
                    basicDBList.add((Object)new BasicDBObject("created_date", (Object)basic));
                }
                if ("yearly".equals(query_type)) {
                    basic = new BasicDBObject();
                    basic.put((Object)"$regex", (Object)time_Y);
                    basicDBList.add((Object)new BasicDBObject("created_date", (Object)basic));
                }
            }
            BasicDBObject basicDBObject = new BasicDBObject();
            basicDBList.add((Object)basicDBObject);
            basicDBObject.put((Object)"user_id", (Object)user_id);
            basicDBObject.put((Object)"pay_status", (Object)"1");
            basicDBObject.put((Object)"productList.team_id", (Object)team_id);
            basicDBObject.put((Object)"is_active", (Object)"Y");
            basic_.put((Object)"$and", (Object)basicDBList);
            log.info("--$match---" + basic_);
            BasicDBObject match_user = new BasicDBObject("$match", (Object)basic_);
            BasicDBObject groupField = new BasicDBObject("_id", (Object)"$user_id");
            groupField.put("amount_trade", (Object)new BasicDBObject("$sum", (Object)"$order_amount_pay"));
            groupField.put("num_sales", (Object)new BasicDBObject("$sum", (Object)"$order_num"));
            BasicDBObject group_user = new BasicDBObject("$group", (Object)groupField);
            AggregationOutput output_user = collection.aggregate((DBObject)match_user, new DBObject[]{group_user});
            Double amount_trade_double_all = 0.0;
            Double amount_trade_double = 0.0;
            Double sale_num_sales_double = 0.0;
            HashMap<String, String> map = new HashMap<String, String>();
            for (Object dbObject : output_user.results()) {
                BasicDBObject basicDBObject1 = (BasicDBObject)dbObject;
                amount_trade_double = amount_trade_double + basicDBObject1.getDouble("amount_trade");
                sale_num_sales_double = sale_num_sales_double + basicDBObject1.getDouble("num_sales");
            }
            amount_trade_double_all = amount_trade_double_all + amount_trade_double;
            basicDBList = new BasicDBList();
            basic_ = new BasicDBObject();
            if (StringUtils.isNotNull((Object)query_type)) {
                BasicDBObject basic;
                if ("all".equals(query_type)) {
                    // empty if block
                }
                if ("daily".equals(query_type)) {
                    basic = new BasicDBObject();
                    basic.put((Object)"$regex", (Object)(time_Y + "-" + time_M + "-" + time_D));
                    basicDBList.add((Object)new BasicDBObject("created_date", (Object)basic));
                }
                if ("monthly".equals(query_type)) {
                    basic = new BasicDBObject();
                    basic.put((Object)"$regex", (Object)(time_Y + "-" + time_M));
                    basicDBList.add((Object)new BasicDBObject("created_date", (Object)basic));
                }
                if ("yearly".equals(query_type)) {
                    basic = new BasicDBObject();
                    basic.put((Object)"$regex", (Object)time_Y);
                    basicDBList.add((Object)new BasicDBObject("created_date", (Object)basic));
                }
            }
            basicDBObject = new BasicDBObject();
            basicDBList.add((Object)basicDBObject);
            basicDBObject.put((Object)"user_id", (Object)user_id);
            basicDBObject.put((Object)"pay_status", (Object)"1");
            basicDBObject.put((Object)"order_status", (Object)"1");
            basicDBObject.put((Object)"productList.team_id", (Object)team_id);
            basicDBObject.put((Object)"is_active", (Object)"Y");
            basic_.put((Object)"$and", (Object)basicDBList);
            log.info("--$match---" + basic_);
            match_user = new BasicDBObject("$match", (Object)basic_);
            groupField = new BasicDBObject("_id", (Object)"$user_id");
            groupField.put("amount_trade", (Object)new BasicDBObject("$sum", (Object)"$order_amount_pay"));
            groupField.put("num_sales", (Object)new BasicDBObject("$sum", (Object)"$order_num"));
            group_user = new BasicDBObject("$group", (Object)groupField);
            output_user = collection.aggregate((DBObject)match_user, new DBObject[]{group_user});
            Double logistics_num_sales_double = 0.0;
            for (DBObject dbObject : output_user.results()) {
                BasicDBObject basicDBObject1 = (BasicDBObject)dbObject;
                logistics_num_sales_double = logistics_num_sales_double + basicDBObject1.getDouble("num_sales");
            }
            basicDBList = new BasicDBList();
            basic_ = new BasicDBObject();
            if (StringUtils.isNotNull((Object)query_type)) {
                BasicDBObject basic;
                if ("all".equals(query_type)) {
                    // empty if block
                }
                if ("daily".equals(query_type)) {
                    basic = new BasicDBObject();
                    basic.put((Object)"$regex", (Object)(time_Y + "-" + time_M + "-" + time_D));
                    basicDBList.add((Object)new BasicDBObject("created_date", (Object)basic));
                }
                if ("monthly".equals(query_type)) {
                    basic = new BasicDBObject();
                    basic.put((Object)"$regex", (Object)(time_Y + "-" + time_M));
                    basicDBList.add((Object)new BasicDBObject("created_date", (Object)basic));
                }
                if ("yearly".equals(query_type)) {
                    basic = new BasicDBObject();
                    basic.put((Object)"$regex", (Object)time_Y);
                    basicDBList.add((Object)new BasicDBObject("created_date", (Object)basic));
                }
            }
            basicDBObject = new BasicDBObject();
            basicDBList.add((Object)basicDBObject);
            basicDBObject.put((Object)"exclusive_user", (Object)user_id);
            basicDBObject.put((Object)"pay_status", (Object)"1");
            basicDBObject.put((Object)"productList.team_id", (Object)team_id);
            basicDBObject.put((Object)"is_active", (Object)"Y");
            basic_.put((Object)"$and", (Object)basicDBList);
            log.info("--$match---" + basic_);
            match_user = new BasicDBObject("$match", (Object)basic_);
            groupField = new BasicDBObject("_id", (Object)"$exclusive_user");
            groupField.put("amount_trade", (Object)new BasicDBObject("$sum", (Object)"$order_amount_pay"));
            groupField.put("num_sales", (Object)new BasicDBObject("$sum", (Object)"$order_num"));
            group_user = new BasicDBObject("$group", (Object)groupField);
            output_user = collection.aggregate((DBObject)match_user, new DBObject[]{group_user});
            Double exclusive_num_sales_double = 0.0;
            for (DBObject dbObject : output_user.results()) {
                BasicDBObject basicDBObject1 = (BasicDBObject)dbObject;
                exclusive_num_sales_double = exclusive_num_sales_double + basicDBObject1.getDouble("num_sales");
            }
            map.put("amount_trade", NumberUtil.keepPrecision((double)amount_trade_double_all));
            map.put("delivery_num", NumberUtil.keepPrecision((Number)logistics_num_sales_double, (int)0));
            map.put("sale_num", NumberUtil.keepPrecision((Number)sale_num_sales_double, (int)0));
            map.put("vip_num", NumberUtil.keepPrecision((Number)exclusive_num_sales_double, (int)0));
            object = JSON.parseObject((String)JSON.toJSONString(map));
            this.redisClient.getValueOps().setValueStringWithExpire("queryTeamSaleteam_" + team_id + query_type + user_id, object.toJSONString(), Long.valueOf(300L));
        }
        return new DataResponse().setStatus(Status.SUCCESS).setData(object).setCode("0");
    }

    public DataResponse queryCorpSale(DataRequest dataRequest) {
        JSONObject data = dataRequest.getData();
        String corp_code = data.getString("corp_code");
        DBCollection collection = this.mongoTemplate.getCollection("def_order");
        BasicDBObject basicDBObject = new BasicDBObject();
        basicDBObject.put((Object)"productList.corp_code", (Object)corp_code);
        DBCursor dbObjects = collection.find((DBObject)basicDBObject);
        String order_no = null;
        String order_remark = null;
        String order_status = null;
        String order_logistic = null;
        String is_online_pay = null;
        String transaction_id = null;
        String product_name = null;
        int product_num = 0;
        double product_standard_price = 0.0;
        double product_standard_amount = 0.0;
        double product_traded_price = 0.0;
        double product_traded_amount = 0.0;
        int product_length = 0;
        JSONObject product_info = null;
        JSONArray product_array = null;
        JSONObject order_info = null;
        String product_id = null;
        JSONObject order_product_express_info = null;
        String team_id = null;
        String user_id = null;
        String product_corp = null;
        String pay_status = null;
        String temp_key = null;
        String logistics_time = null;
        String logistics_code = null;
        String phone = null;
        String user_name = null;
        String member_team_grade_name = null;
        String vip_name = null;
        String address_name = null;
        String address_phone = null;
        String address_detail = null;
        String team_name = null;
        JSONObject order_express_info = null;
        JSONObject user_info = null;
        JSONObject order_vip = null;
        JSONObject express_info = null;
        StringBuffer conter_sb = new StringBuffer();
        conter_sb.append("\"").append("\u4e0b\u5355\u65f6\u95f4").append("\"").append(",");
        conter_sb.append("\"").append("\u5355\u53f7").append("\"").append(",");
        conter_sb.append("\"").append("\u9500\u552e\u540d\u79f0").append("\"").append(",");
        conter_sb.append("\"").append("\u9500\u552e\u624b\u673a\u53f7").append("\"").append(",");
        conter_sb.append("\"").append("\u4ea4\u6613\u7c7b\u578b").append("\"").append(",");
        conter_sb.append("\"").append("\u56e2\u5458\u7b49\u7ea7").append("\"").append(",");
        conter_sb.append("\"").append("\u56e2\u961f\u540d\u79f0").append("\"").append(",");
        conter_sb.append("\"").append("\u987e\u5ba2\u6635\u79f0").append("\"").append(",");
        conter_sb.append("\"").append("\u6536\u8d27\u4eba\u59d3\u540d").append("\"").append(",");
        conter_sb.append("\"").append("\u6536\u8d27\u4eba\u624b\u673a\u53f7").append("\"").append(",");
        conter_sb.append("\"").append("\u6536\u8d27\u5730\u5740").append("\"").append(",");
        conter_sb.append("\"").append("\u8ba2\u5355\u5907\u6ce8").append("\"").append(",");
        conter_sb.append("\"").append("\u5fae\u4fe1\u652f\u4ed8\u5355\u53f7").append("\"").append(",");
        conter_sb.append("\"").append("\u5355\u636e\u72b6\u6001").append("\"").append(",");
        conter_sb.append("\"").append("\u53d1\u8d27\u65f6\u95f4").append("\"").append(",");
        conter_sb.append("\"").append("\u5feb\u9012\u5355\u53f7").append("\"").append(",");
        conter_sb.append("\"").append("\u5546\u54c1\u540d\u79f0").append("\"").append(",");
        conter_sb.append("\"").append("\u6807\u51c6\u4ef7").append("\"").append(",");
        conter_sb.append("\"").append("\u6210\u4ea4\u4ef7").append("\"").append(",");
        conter_sb.append("\"").append("\u6570\u91cf").append("\"").append(",");
        conter_sb.append("\"").append("\u6807\u51c6\u91d1\u989d").append("\"").append(",");
        conter_sb.append("\"").append("\u6210\u4ea4\u91d1\u989d").append("\"").append(",");
        conter_sb.append("\"").append("\u4f63\u91d1\u91d1\u989d").append("\"");
        Map map = null;
        Object member_team_info = null;
        String grade_id = null;
        JSONObject member_team_grade_info = null;
        JSONObject member_team_product_jo = new JSONObject();
        while (dbObjects.hasNext()) {
            DBObject object = dbObjects.next();
            map = object.toMap();
            try {
                order_info = JSONObject.parseObject((String)JSON.toJSONString((Object)map));
            }
            catch (Exception e) {
                log.error("order string to jsonobject error:" + e.getLocalizedMessage(), (Throwable)e);
                continue;
            }
            if (order_info == null || order_info.isEmpty()) {
                log.error("order data is null");
                continue;
            }
            is_online_pay = "Y".equalsIgnoreCase(order_info.getString("is_online_pay")) ? "\u7ebf\u4e0a\u4ea4\u6613" : "\u73b0\u8d27\u4ea4\u6613";
            product_array = order_info.getJSONArray("productList");
            if (product_array == null || product_array.isEmpty()) {
                log.error("product array data is null");
                continue;
            }
            String created_date = order_info.getString("created_date");
            order_no = order_info.getString("order_no");
            order_remark = StringUtils.checkString((String)order_info.getString("order_remark"));
            pay_status = order_info.getString("pay_status");
            order_status = StringUtils.checkString((String)order_info.getString("order_status"));
            order_status = "1".equals(pay_status) ? ("0".equals(order_status) ? "\u5df2\u4ed8\u6b3e" : ("1".equals(order_status) ? "\u5df2\u53d1\u8d27" : ("2".equals(order_status) ? "\u5df2\u6536\u8d27" : ""))) : "\u672a\u4ed8\u6b3e";
            order_logistic = StringUtils.checkString((String)order_info.getString("order_logistic"));
            transaction_id = StringUtils.checkString((String)order_info.getString("transaction_id"));
            try {
                order_vip = order_info.getJSONObject("order_vip");
            }
            catch (Exception e) {
                log.error("order_vip string to jsonobject error:" + e.getLocalizedMessage(), (Throwable)e);
            }
            vip_name = order_vip == null || order_vip.isEmpty() ? "" : order_vip.getString("vip_name");
            user_id = order_info.getString("user_id");
            Query query = new Query();
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"user_id").is((Object)user_id));
            user_info = this.user_redis_utils.getUser(user_id, false);
            if (user_info == null || user_info.isEmpty()) {
                phone = "";
                user_name = "";
            } else {
                phone = user_info.getString("phone");
                user_name = user_info.getString("user_name");
            }
            try {
                express_info = order_info.getJSONObject("express_info");
            }
            catch (Exception e) {
                log.error("express_info string to jsonobject error:" + e.getLocalizedMessage(), (Throwable)e);
            }
            if (express_info == null || express_info.isEmpty()) {
                address_name = "";
                address_phone = "";
                address_detail = "";
            } else {
                JSONObject address = express_info.getJSONObject("address");
                if (address == null || address.isEmpty()) {
                    address_name = "";
                    address_phone = "";
                    address_detail = "";
                } else {
                    address_name = address.getString("name");
                    address_phone = StringUtils.checkString((String)address.getString("phone"));
                    address_detail = StringUtils.checkString((String)address.getString("province_name")) + StringUtils.checkString((String)address.getString("city_name")) + StringUtils.checkString((String)address.getString("country_name")) + StringUtils.checkString((String)address.getString("address"));
                }
            }
            order_express_info = this.getOrderExpress(order_info.getString("order_id"));
            product_length = product_array.size();
            for (int i = 0; i < product_length; ++i) {
                product_info = product_array.getJSONObject(i);
                if (product_info == null || product_info.isEmpty()) {
                    log.error("product info by index:" + i + " data is null");
                    continue;
                }
                product_corp = product_info.getString("corp_code");
                if (!corp_code.equals(product_corp)) {
                    log.error("product corp code:" + product_corp + " not eq corp:" + corp_code);
                    continue;
                }
                product_name = product_info.getString("product_name");
                product_id = product_info.getString("product_id");
                order_product_express_info = order_express_info == null || order_express_info.isEmpty() ? null : order_express_info.getJSONObject(product_id);
                if (order_product_express_info == null || order_product_express_info.isEmpty()) {
                    logistics_time = "";
                    logistics_code = "";
                } else {
                    logistics_time = order_product_express_info.getString("logistics_time");
                    logistics_code = order_product_express_info.getString("logistics_code");
                }
                product_num = product_info.getIntValue("product_num");
                product_standard_price = product_info.getDoubleValue("product_price");
                product_standard_amount = product_standard_price * (double)product_num;
                product_traded_amount = product_info.getDoubleValue("product_amount");
                product_traded_price = product_traded_amount > 0.0 ? product_traded_amount / (double)product_num : 0.0;
                user_id = order_info.getString("user_id");
                team_id = product_info.getString("team_id");
                if (StringUtils.isNotNull((Object)team_id)) {
                    JSONObject result_data;
                    temp_key = team_id + "_" + user_id;
                    member_team_grade_info = member_team_product_jo.getJSONObject(temp_key);
                    if (member_team_grade_info == null || member_team_grade_info.isEmpty()) {
                        member_team_info = null;
                        JSONObject param_user = new JSONObject();
                        param_user.put("user_id", (Object)user_id);
                        param_user.put("team_id", (Object)team_id);
                        grade_id = this.team_agent.getData(param_user, "/team/getTeamMemberGrade").getString("grade_id");
                        BasicDBObject grade_query = new BasicDBObject("team_id", (Object)team_id);
                        if (StringUtils.isNotNull((Object)grade_id)) {
                            try {
                                grade_query.put((Object)"_id", (Object)new ObjectId(grade_id));
                            }
                            catch (Exception e) {
                                log.error(" error:" + e.getLocalizedMessage(), (Throwable)e);
                            }
                        } else {
                            grade_query.put((Object)"is_default", (Object)"Y");
                        }
                        try {
                            member_team_grade_info = this.mongodbClient.findOne("def_team_grade", grade_query);
                        }
                        catch (Exception e) {
                            log.error("get team grade by:" + grade_query + " error:" + e.getLocalizedMessage(), (Throwable)e);
                        }
                        member_team_product_jo.put(temp_key, (Object)member_team_grade_info);
                    }
                    member_team_grade_name = member_team_grade_info == null || member_team_grade_info.isEmpty() ? "" : member_team_grade_info.getString("name");
                    DataRequest team_request = new DataRequest();
                    JSONObject param = new JSONObject();
                    param.put("team_id", (Object)team_id);
                    team_request.setData(param);
                    DataResponse team_response = null;
                    try {
                        team_response = this.teamService.getData("/team/queryTeamByIdWithNothing", team_request);
                    }
                    catch (Exception e) {
                        log.error("get team error:" + e.getLocalizedMessage(), (Throwable)e);
                    }
                    team_name = team_response != null && Status.SUCCESS.equals((Object)team_response.getStatus()) ? ((result_data = team_response.getData()) != null && !result_data.isEmpty() ? ((result_data = result_data.getJSONObject("message")) != null && !result_data.isEmpty() ? result_data.getString("name") : "") : "") : "";
                } else {
                    team_name = "";
                    member_team_grade_name = "";
                }
                conter_sb.append("\n");
                conter_sb.append("\"").append(created_date).append("\"").append(",");
                conter_sb.append("\"").append(order_no).append("\"").append(",");
                conter_sb.append("\"").append(user_name).append("\"").append(",");
                conter_sb.append("\"").append(phone).append("\"").append(",");
                conter_sb.append("\"").append(is_online_pay).append("\"").append(",");
                conter_sb.append("\"").append(member_team_grade_name).append("\"").append(",");
                conter_sb.append("\"").append(team_name).append("\"").append(",");
                conter_sb.append("\"").append(vip_name).append("\"").append(",");
                conter_sb.append("\"").append(address_name).append("\"").append(",");
                conter_sb.append("\"").append(address_phone).append("\"").append(",");
                conter_sb.append("\"").append(address_detail).append("\"").append(",");
                conter_sb.append("\"").append(order_remark).append("\"").append(",");
                conter_sb.append("\"").append(transaction_id).append("\"").append(",");
                conter_sb.append("\"").append(order_status).append("\"").append(",");
                conter_sb.append("\"").append(logistics_time).append("\"").append(",");
                conter_sb.append("\"").append(logistics_code).append("\"").append(",");
                conter_sb.append("\"").append(product_name).append("\"").append(",");
                conter_sb.append("\"").append(product_standard_price).append("\"").append(",");
                conter_sb.append("\"").append(product_traded_price).append("\"").append(",");
                conter_sb.append("\"").append(product_num).append("\"").append(",");
                conter_sb.append("\"").append(product_standard_amount).append("\"").append(",");
                conter_sb.append("\"").append(product_traded_amount).append("\"").append(",");
                conter_sb.append("\"").append(0).append("\"");
            }
        }
        long current_sys = System.currentTimeMillis();
        String file_name = new StringBuffer(corp_code).append("-").append(TimeUtils.getTime((long)current_sys, (SimpleDateFormat)TimeUtils.DATETIME_FORMAT_DATE_NO)).append("-").append(RandomStringUtils.randomAlphanumeric((int)5)).append(".csv").toString();
        String url = this.pushToOssFile(file_name, conter_sb);
        JSONObject result_item = new JSONObject();
        result_item.put("oss_url", (Object)url);
        JSONObject result_data = new JSONObject();
        result_data.put("message", (Object)result_item);
        return new DataResponse().setStatus(Status.SUCCESS).setData(result_data).setCode("0");
    }

    private String pushToOssFile(String filename, StringBuffer content) {
        String url = null;
        try {
            ByteArrayInputStream input = new ByteArrayInputStream(content.toString().getBytes("UTF-8"));
            this.blobClient.passFileStrem("exports/order/", filename, (InputStream)input);
            url = "https://storage2tommy.blob.core.chinacloudapi.cn/exports/order/" + filename;
            url = this.aliCDNUrlAuth.getAuthURLA(url);
        }
        catch (Exception e) {
            log.error("push file to oss error:" + e.getLocalizedMessage(), (Throwable)e);
        }
        return url;
    }

    private JSONObject getOrderExpress(String order_id) {
        JSONObject order_express_info = null;
        if (StringUtils.isNull((Object)order_id)) {
            return order_express_info;
        }
        BasicDBObject order_express_query = new BasicDBObject("order_id", (Object)order_id);
        DBCursor db_cursor = null;
        try {
            db_cursor = this.mongoTemplate.getCollection("def_express").find((DBObject)order_express_query);
        }
        catch (Exception e) {
            log.error("get order express by:" + order_express_query + " error:" + e.getLocalizedMessage(), (Throwable)e);
            return order_express_info;
        }
        if (db_cursor == null) {
            log.error("not find order express by:" + order_express_query);
            return order_express_info;
        }
        JSONObject express_info = null;
        JSONArray express_product = null;
        JSONObject temp_express_info = null;
        JSONObject temp_product_info = null;
        DBObject db_object = null;
        int product_length = 0;
        String product_id = null;
        order_express_info = new JSONObject();
        while (db_cursor.hasNext()) {
            db_object = db_cursor.next();
            try {
                express_info = JSONObject.parseObject((String)JSON.toJSONString((Object)db_object.toMap()));
            }
            catch (Exception e) {
                log.error(" error:" + e.getLocalizedMessage(), (Throwable)e);
                continue;
            }
            if (express_info == null || express_info.isEmpty()) {
                log.error("data is null");
                continue;
            }
            express_product = express_info.getJSONArray("productList");
            if (express_product == null || express_product.isEmpty()) {
                log.error("product is null");
                continue;
            }
            product_length = express_product.size();
            for (int i = 0; i < product_length; ++i) {
                temp_product_info = express_product.getJSONObject(i);
                if (temp_product_info == null || temp_product_info.isEmpty()) {
                    log.error("product index:" + i + " data is null");
                    continue;
                }
                product_id = temp_product_info.getString("product_id");
                if (StringUtils.isNull((Object)product_id)) {
                    log.error("product index:" + i + " product id is null");
                }
                temp_express_info = new JSONObject();
                temp_express_info.put("logistics_code", (Object)express_info.getString("logistics_code"));
                temp_express_info.put("shipper_code", (Object)express_info.getString("shipper_code"));
                temp_express_info.put("logistics_name", (Object)express_info.getString("logistics_name"));
                temp_express_info.put("logistics_time", (Object)express_info.getString("logistics_time"));
                order_express_info.put(product_id, (Object)temp_express_info);
            }
        }
        return order_express_info;
    }
}

