/*
 * Decompiled with CFR 0.152.
 */
package kr.weitao.weitaokr.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.mongodb.BasicDBList;
import com.mongodb.BasicDBObject;
import com.mongodb.DBCollection;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import com.mongodb.WriteResult;
import java.text.SimpleDateFormat;
import java.util.Map;
import kr.weitao.business.entity.Remind;
import kr.weitao.common.util.JSONArraySortUtil;
import kr.weitao.common.util.TimeUtils;
import kr.weitao.starter.model.DataRequest;
import kr.weitao.starter.model.DataResponse;
import kr.weitao.starter.model.Status;
import kr.weitao.weitaokr.service.RemindService;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bson.types.ObjectId;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.stereotype.Service;

@Service
public class RemindServiceImpl
implements RemindService {
    private static final Logger log = LogManager.getLogger(RemindServiceImpl.class);
    @Autowired
    MongoTemplate mongoTemplate;

    public DataResponse add(DataRequest dataRequest) {
        DataResponse dataResponse = new DataResponse();
        String current = TimeUtils.getCurrentTimeInString((SimpleDateFormat)TimeUtils.DATETIME_FORMAT_DATE);
        JSONObject data = dataRequest.getData();
        Remind remind = new Remind();
        remind.setContent(data.getString("content"));
        remind.setCreated_date(current);
        remind.setCreator_id(data.getString("user_id"));
        remind.setModified_date(current);
        remind.setModifier_id(data.getString("user_id"));
        remind.setUser_id(data.getString("user_id"));
        remind.setRecurrence(data.getJSONObject("recurrence"));
        remind.setRemind_time(data.getString("remind_time"));
        remind.setVipList(data.getJSONArray("vipList"));
        remind.setIs_active("Y");
        this.mongoTemplate.insert((Object)remind);
        JSONObject da = new JSONObject();
        da.put("id", (Object)remind.get_id().toString());
        dataResponse.setStatus(Status.SUCCESS).setCode("0").setId(dataRequest.getId()).setData(da);
        return dataResponse;
    }

    public DataResponse mod(DataRequest dataRequest) {
        DataResponse dataResponse = new DataResponse();
        JSONObject data = dataRequest.getData();
        String _id = data.getString("id");
        BasicDBObject basicDBObject = new BasicDBObject();
        BasicDBObject update = new BasicDBObject();
        if (data.containsKey((Object)"content")) {
            basicDBObject.put((Object)"content", (Object)data.getString("content"));
        }
        if (data.containsKey((Object)"status")) {
            basicDBObject.put((Object)"status", (Object)data.getString("status"));
        }
        if (data.containsKey((Object)"remind_time")) {
            basicDBObject.put((Object)"remind_time", (Object)data.getString("remind_time"));
        }
        if (data.containsKey((Object)"vipList")) {
            basicDBObject.put((Object)"vipList", (Object)data.getJSONArray("vipList"));
        }
        if (data.containsKey((Object)"recurrence")) {
            basicDBObject.put((Object)"recurrence", (Object)data.getJSONObject("recurrence"));
        }
        basicDBObject.put((Object)"modified_date", (Object)TimeUtils.getCurrentTimeInString((SimpleDateFormat)TimeUtils.DATETIME_FORMAT_DATE));
        update.put((Object)"$set", (Object)basicDBObject);
        BasicDBObject query = new BasicDBObject();
        query.put((Object)"_id", (Object)new ObjectId(_id));
        log.info("update>>" + update + ">>>>>>>>>query>>>>>>>" + query);
        WriteResult writeResult = this.mongoTemplate.getCollection("def_remind").updateMulti((DBObject)query, (DBObject)update);
        if (writeResult.getN() > 0) {
            JSONObject da = new JSONObject();
            da.put("message", (Object)"\u4fee\u6539\u6210\u529f");
            dataResponse.setStatus(Status.SUCCESS).setCode("0").setId(dataRequest.getId()).setData(da);
        } else {
            JSONObject da = new JSONObject();
            da.put("message", (Object)"\u4fee\u6539\u5931\u8d25");
            dataResponse.setStatus(Status.FAILED).setCode("-1").setId(dataRequest.getId()).setData(da).setMsg("\u4fee\u6539\u5931\u8d25");
        }
        return dataResponse;
    }

    public DataResponse del(DataRequest dataRequest) {
        DataResponse dataResponse = new DataResponse();
        JSONObject data = dataRequest.getData();
        String user_id = data.getString("user_id");
        String id = data.getString("id");
        DBCollection collection = this.mongoTemplate.getCollection("def_remind");
        BasicDBObject basicDB = new BasicDBObject();
        BasicDBList basicDBList1 = new BasicDBList();
        basicDBList1.add((Object)new BasicDBObject("user_id", (Object)user_id));
        basicDBList1.add((Object)new BasicDBObject("_id", (Object)new ObjectId(id)));
        basicDB.put((Object)"$and", (Object)basicDBList1);
        WriteResult writeResult = collection.remove((DBObject)basicDB);
        if (writeResult.getN() > 0) {
            JSONObject da = new JSONObject();
            da.put("message", (Object)"\u5220\u9664\u6210\u529f");
            dataResponse.setStatus(Status.SUCCESS).setCode("0").setId(dataRequest.getId()).setData(da);
        } else {
            JSONObject da = new JSONObject();
            da.put("message", (Object)"\u5220\u9664\u5931\u8d25");
            dataResponse.setStatus(Status.FAILED).setCode("-1").setId(dataRequest.getId()).setData(da).setMsg("\u4fee\u6539\u5931\u8d25");
        }
        return dataResponse;
    }

    public DataResponse query(DataRequest dataRequest) {
        DataResponse dataResponse = new DataResponse();
        JSONObject data = dataRequest.getData();
        String user_id = data.getString("user_id");
        String id = data.getString("id");
        DBCollection collection = this.mongoTemplate.getCollection("def_remind");
        BasicDBObject basicDB = new BasicDBObject();
        BasicDBList basicDBList1 = new BasicDBList();
        basicDBList1.add((Object)new BasicDBObject("user_id", (Object)user_id));
        basicDBList1.add((Object)new BasicDBObject("_id", (Object)new ObjectId(id)));
        basicDBList1.add((Object)new BasicDBObject("is_active", (Object)"Y"));
        basicDB.put((Object)"$and", (Object)basicDBList1);
        DBCursor dbCur = collection.find((DBObject)basicDB);
        JSONObject jsonObject = new JSONObject();
        JSONArray array = new JSONArray();
        while (dbCur.hasNext()) {
            DBObject object = dbCur.next();
            Map map = object.toMap();
            map.put("id", id.toString());
            array.add((Object)map);
        }
        jsonObject.put("message", (Object)array);
        return dataResponse.setStatus(Status.SUCCESS).setData(jsonObject);
    }

    public DataResponse queryList(DataRequest dataRequest) {
        int counts = 0;
        String current = TimeUtils.getCurrentTimeInString((SimpleDateFormat)TimeUtils.DATETIME_FORMAT_DATE);
        JSONObject jsonObject = new JSONObject();
        JSONArray array = new JSONArray();
        DataResponse dataResponse = new DataResponse();
        JSONObject data = dataRequest.getData();
        String user_id = data.getString("user_id");
        String vip_id = data.getString("vip_id");
        String time_id = data.getString("time");
        int page_num = data.getIntValue("page_num");
        int page_size = data.getIntValue("page_size");
        String query_type = data.getString("query_type");
        DBCollection collection = this.mongoTemplate.getCollection("def_memorandum");
        BasicDBObject basicDB = new BasicDBObject();
        BasicDBList basicDBList1 = new BasicDBList();
        basicDBList1.add((Object)new BasicDBObject("user_id", (Object)user_id));
        if (StringUtils.isNotBlank((String)vip_id)) {
            basicDBList1.add((Object)new BasicDBObject("vipList.vip_id", (Object)vip_id));
        }
        basicDBList1.add((Object)new BasicDBObject("is_active", (Object)"Y"));
        if (StringUtils.isNotBlank((String)time_id)) {
            basicDBList1.add((Object)new BasicDBObject("remind_time", (Object)new BasicDBObject("$regex", (Object)time_id).append("$options", (Object)"i")));
        }
        String _id = data.getString("id");
        if (!"1".equals(query_type)) {
            if (StringUtils.isNotBlank((String)_id)) {
                basicDBList1.add((Object)new BasicDBObject("_id", (Object)new ObjectId(_id)));
                basicDB.put((Object)"$and", (Object)basicDBList1);
                DBCursor dbCur = collection.find((DBObject)basicDB).skip(page_num * page_size).limit(page_size).sort((DBObject)new BasicDBObject("remind_time", (Object)1));
                counts = dbCur.count();
                while (dbCur.hasNext()) {
                    DBObject object = dbCur.next();
                    Map map = object.toMap();
                    Object id = map.get("_id");
                    map.put("id", id.toString());
                    map.remove("_id");
                    array.add((Object)map);
                }
            } else if ("0".equals(query_type)) {
                basicDBList1.add((Object)new BasicDBObject("status", (Object)"0"));
                basicDB.put((Object)"$and", (Object)basicDBList1);
                DBCursor dbCur = collection.find((DBObject)basicDB).skip(page_num * page_size).limit(page_size).sort((DBObject)new BasicDBObject("remind_time", (Object)1));
                counts = dbCur.count();
                while (dbCur.hasNext()) {
                    DBObject object = dbCur.next();
                    Map map = object.toMap();
                    Object id = map.get("_id");
                    map.put("id", id.toString());
                    map.remove("_id");
                    array.add((Object)map);
                }
            } else if ("-1".equals(query_type)) {
                BasicDBList basicDBList1_or = new BasicDBList();
                basicDBList1_or.add((Object)new BasicDBObject("status", (Object)"-1"));
                basicDBList1_or.add((Object)new BasicDBObject("status", (Object)"1"));
                basicDBList1.add((Object)new BasicDBObject("$or", (Object)basicDBList1_or));
                basicDB.put((Object)"$and", (Object)basicDBList1);
                DBCursor dbCur = collection.find((DBObject)basicDB).skip(page_num * page_size).limit(page_size).sort((DBObject)new BasicDBObject("remind_time", (Object)1));
                counts = dbCur.count();
                while (dbCur.hasNext()) {
                    DBObject object = dbCur.next();
                    Map map = object.toMap();
                    Object id = map.get("_id");
                    map.put("id", id.toString());
                    map.remove("_id");
                    array.add((Object)map);
                }
            }
        } else if (StringUtils.isNotBlank((String)_id)) {
            basicDBList1.add((Object)new BasicDBObject("_id", (Object)new ObjectId(_id)));
            basicDB.put((Object)"$and", (Object)basicDBList1);
            DBCursor dbCur = collection.find((DBObject)basicDB).skip(page_num * page_size).limit(page_size).sort((DBObject)new BasicDBObject("remind_time", (Object)1));
            counts = dbCur.count();
            while (dbCur.hasNext()) {
                DBObject object = dbCur.next();
                Map map = object.toMap();
                Object id = map.get("_id");
                map.put("id", id.toString());
                map.remove("_id");
                array.add((Object)map);
            }
        } else {
            JSONArray jsonArray = new JSONArray();
            basicDB.put((Object)"$and", (Object)basicDBList1);
            DBCursor dbCur = collection.find((DBObject)basicDB);
            while (dbCur.hasNext()) {
                DBObject object = dbCur.next();
                Map map = object.toMap();
                Object id = map.get("_id");
                map.put("id", id.toString());
                map.remove("_id");
                String time = (String)map.get("remind_time");
                String status = (String)map.get("status");
                if ("0".equals(status) || !TimeUtils.compareDateTime((String)time, (String)current, (SimpleDateFormat)TimeUtils.DATETIME_FORMAT_DATE)) continue;
                jsonArray.add((Object)JSONObject.parseObject((String)JSON.toJSONString((Object)map)));
            }
            counts = jsonArray.size();
            log.info((Object)jsonArray);
            JSONArray jsonArraymessage = JSONArraySortUtil.sortAesc((JSONArray)jsonArray, (String)"remind_time");
            log.info((Object)jsonArraymessage);
            int endIndex = (page_num + 1) * page_size;
            if (endIndex > jsonArraymessage.size()) {
                endIndex = jsonArraymessage.size();
            }
            for (int i = page_num * page_size; i < endIndex; ++i) {
                JSONObject map = jsonArraymessage.getJSONObject(i);
                array.add((Object)map);
            }
        }
        jsonObject.put("message", (Object)array);
        jsonObject.put("count", (Object)counts);
        return dataResponse.setStatus(Status.SUCCESS).setData(jsonObject);
    }
}

