/*
 * Decompiled with CFR 0.152.
 */
package kr.weitao.weitaokr.service.impl;

import com.alibaba.fastjson.JSONObject;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import kr.weitao.common.util.AliCDNUrlAuth;
import kr.weitao.starter.model.DataRequest;
import kr.weitao.starter.model.DataResponse;
import kr.weitao.starter.model.Status;
import kr.weitao.starter.util.oss.BlobClient;
import kr.weitao.starter.util.oss.OssClient;
import kr.weitao.weitaokr.service.OssService;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.multipart.MultipartFile;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class OssServiceImpl
implements OssService {
    private static final Logger log = LogManager.getLogger(OssServiceImpl.class);
    @Autowired
    OssClient ossClient;
    @Qualifier(value="blobClient")
    @Autowired
    BlobClient blobClient;
    @Autowired
    AliCDNUrlAuth aliCDNUrlAuth;
    @Value(value="${blob.domain}")
    String OSS_DOMAIN;

    public DataResponse create(DataRequest dataRequest) {
        DataResponse dataResponse = new DataResponse();
        JSONObject data = dataRequest.getData();
        String url = data.getString("url");
        String name = data.getString("name");
        String dir = data.getString("dir");
        return dataResponse;
    }

    public DataResponse remove(DataRequest dataRequest) {
        DataResponse dataResponse = new DataResponse();
        JSONObject data = dataRequest.getData();
        String dir = data.getString("dir");
        String name = data.getString("name");
        return dataResponse.setStatus(Status.SUCCESS).setCode("0");
    }

    public DataResponse query(DataRequest dataRequest) {
        DataResponse dataResponse = new DataResponse();
        JSONObject data = dataRequest.getData();
        String dir = data.getString("dir");
        String name = data.getString("name");
        String s = this.ossClient.getImgUrl(name, dir);
        return dataResponse.setMsg("s").setCode("0").setStatus(Status.SUCCESS);
    }

    public static File multipartFileToFile(MultipartFile file) throws Exception {
        File toFile = null;
        if (file.equals("") || file.getSize() <= 0L) {
            file = null;
        } else {
            InputStream ins = null;
            ins = file.getInputStream();
            toFile = new File(file.getOriginalFilename());
            OssServiceImpl.inputStreamToFile((InputStream)ins, (File)toFile);
            ins.close();
        }
        return toFile;
    }

    private static void inputStreamToFile(InputStream ins, File file) {
        try {
            FileOutputStream os = new FileOutputStream(file);
            int bytesRead = 0;
            byte[] buffer = new byte[8192];
            while ((bytesRead = ins.read(buffer, 0, 8192)) != -1) {
                ((OutputStream)os).write(buffer, 0, bytesRead);
            }
            ((OutputStream)os).close();
            ins.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public File multipartFileToFileV2(MultipartFile multipartFile) {
        String fileName = multipartFile.getOriginalFilename();
        String prefix = fileName.substring(fileName.lastIndexOf("."));
        File excelFile = null;
        try {
            excelFile = File.createTempFile(UUID.randomUUID().toString(), prefix);
            multipartFile.transferTo(excelFile);
        }
        catch (Exception e) {
            log.error("==========={}\u6587\u4ef6=================\u8f6c\u6362\u5f02\u5e38", (Object)fileName);
            e.printStackTrace();
        }
        return excelFile;
    }

    public static byte[] readStream(InputStream imagePath) throws Exception {
        log.info("----\u8f6cbyte--");
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        int len = 0;
        while (-1 != (len = imagePath.read(buffer))) {
            outStream.write(buffer, 0, len);
        }
        outStream.close();
        imagePath.close();
        return outStream.toByteArray();
    }

    public DataResponse input(HttpServletRequest request, @RequestParam(value="file", required=false) MultipartFile file) {
        DataResponse dataResponse = new DataResponse();
        try {
            InputStream is = file.getInputStream();
            String file_name = request.getParameter("file_name").toLowerCase();
            String dir_path = request.getParameter("dir_path").replace("_", "-").toLowerCase();
            String[] strings = dir_path.split("/");
            int length = strings.length;
            log.info("===oss input file ===file_name:" + file_name + " dir_path:" + dir_path + " " + file.getOriginalFilename());
            String containerName = strings[0];
            StringBuilder blobName = new StringBuilder();
            for (int i = 1; i < length; ++i) {
                blobName.append(strings[i]).append("/");
            }
            String path = blobName + file_name;
            log.info("---path----" + path + "---" + containerName);
            this.blobClient.uploadBytesToBlob(containerName, path, OssServiceImpl.readStream((InputStream)is));
            String url = URLEncoder.encode(dir_path + file_name);
            url = this.aliCDNUrlAuth.getAuthURLA(this.OSS_DOMAIN + "/" + url);
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("auth_url", (Object)url);
            jsonObject.put("src_url", (Object)(dir_path + file_name));
            return dataResponse.setCode("0").setStatus(Status.SUCCESS).setMsg("\u4e0a\u4f20\u6210\u529f").setData(jsonObject);
        }
        catch (Exception e) {
            e.printStackTrace();
            return dataResponse.setCode("-1").setStatus(Status.FAILED).setMsg("\u4e0a\u4f20\u5931\u8d25");
        }
    }
}

