/*
 * Decompiled with CFR 0.152.
 */
package kr.weitao.weitaokr.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.mongodb.AggregationOutput;
import com.mongodb.BasicDBList;
import com.mongodb.BasicDBObject;
import com.mongodb.DBCollection;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import com.mongodb.WriteResult;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import javax.servlet.http.HttpServletRequest;
import kr.weitao.business.common.agent.ActivityAgent;
import kr.weitao.business.common.agent.DataAgent;
import kr.weitao.business.common.agent.OrderAgent;
import kr.weitao.business.common.agent.TeamAgent;
import kr.weitao.business.common.agent.UiAgent;
import kr.weitao.business.common.agent.WingMixAgent;
import kr.weitao.business.common.feignclient.CouponService;
import kr.weitao.business.common.feignclient.UiService;
import kr.weitao.business.common.feignclient.WechatService;
import kr.weitao.business.entity.ApplyRefund;
import kr.weitao.business.entity.Corp;
import kr.weitao.business.entity.Express;
import kr.weitao.business.entity.Logistics;
import kr.weitao.business.entity.Memorandum;
import kr.weitao.business.entity.Order;
import kr.weitao.business.entity.Store;
import kr.weitao.business.entity.User;
import kr.weitao.business.entity.Vip;
import kr.weitao.business.entity.activity.ActivityJoinRecord;
import kr.weitao.business.entity.coupon.Coupon;
import kr.weitao.business.entity.coupon.CouponType;
import kr.weitao.business.entity.data.Product;
import kr.weitao.business.entity.data.TeamNews;
import kr.weitao.business.entity.data.TeamProduct;
import kr.weitao.business.entity.product.ProductStock;
import kr.weitao.business.entity.product.Sku;
import kr.weitao.business.entity.product.Spec;
import kr.weitao.business.entity.product.SpecItem;
import kr.weitao.business.entity.stock.SkuFlow;
import kr.weitao.business.entity.team.Team;
import kr.weitao.business.entity.team.TeamCommissionRule;
import kr.weitao.business.entity.team.TeamMember;
import kr.weitao.common.exception.CommonException;
import kr.weitao.common.util.AliCDNUrlAuth;
import kr.weitao.common.util.DateSwitchUtil;
import kr.weitao.common.util.JSONArraySortUtil;
import kr.weitao.common.util.NumberUtil;
import kr.weitao.common.util.StringUtils;
import kr.weitao.common.util.TimeUtils;
import kr.weitao.starter.model.DataRequest;
import kr.weitao.starter.model.DataResponse;
import kr.weitao.starter.model.Status;
import kr.weitao.starter.util.mongodb.MongodbUtil;
import kr.weitao.starter.util.redis.RedisClient;
import kr.weitao.weitaokr.network.NetWorkCommon;
import kr.weitao.weitaokr.service.JobService;
import kr.weitao.weitaokr.service.KdniaoService;
import kr.weitao.weitaokr.service.OrderService;
import kr.weitao.weitaokr.service.common.MongodbUtils;
import kr.weitao.weitaokr.service.common.UserRedisUtils;
import kr.weitao.weitaokr.service.impl.OrderServiceImpl;
import kr.weitao.weitaokr.task.common.QueueParam;
import org.apache.commons.lang.RandomStringUtils;
import org.apache.commons.lang3.concurrent.BasicThreadFactory;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bson.types.ObjectId;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;

@Service
public class OrderServiceImpl
implements OrderService {
    private static final Logger log = LogManager.getLogger(OrderServiceImpl.class);
    @Autowired
    MongoTemplate mongoTemplate;
    @Autowired
    JobService jobService;
    @Autowired
    KdniaoService kdniaoService;
    @Autowired
    UserRedisUtils userRedisUtils;
    @Autowired
    RedisTemplate redisTemplate;
    @Autowired
    DataAgent dataAgent;
    @Autowired
    UiAgent uiAgent;
    @Autowired
    UiService uiService;
    @Autowired
    RedisClient redisClient;
    @Autowired
    OrderAgent orderAgent;
    @Autowired
    TeamAgent teamAgent;
    @Autowired
    MongodbUtils mongodbUtils;
    @Autowired
    ActivityAgent activityAgent;
    @Autowired
    AliCDNUrlAuth aliCDNUrlAuth;
    @Autowired
    private WechatService wechatService;
    static final String IMAGER_URL = "https://cdn.weitao.kr/";
    @Value(value="${order_url}")
    private String order_url;
    @Value(value="${public.appid}")
    String public_appid;
    @Value(value="${refund_logistics_url}")
    private String refund_logistics_url;
    @Value(value="${api.server.domain}")
    private String api_server_domain;
    @Value(value="${weixin.server.order.url}")
    private String weixin_server_order_url;
    @Autowired
    CouponService couponService;
    @Autowired
    WingMixAgent wingMixAgent;

    @CacheEvict(value={"order"}, allEntries=true)
    public DataResponse add(DataRequest dataRequest) {
        DataResponse dataResponse = new DataResponse();
        String current = TimeUtils.getCurrentTimeInString((SimpleDateFormat)TimeUtils.DATETIME_FORMAT_DATE);
        JSONObject data = dataRequest.getData();
        String user_id = data.getString("user_id");
        JSONArray logistics_info = data.getJSONArray("logisticsList");
        Double order_amount_pay = data.getDouble("order_price");
        Double order_amount = data.getDouble("order_amount");
        JSONObject order_reback_time = data.getJSONObject("order_reback_time");
        JSONObject recurrence = data.getJSONObject("recurrence");
        JSONArray recurrenceList = data.getJSONArray("recurrenceList");
        JSONObject vip_order = data.getJSONObject("order_vip");
        Double order_freight = data.getDouble("order_freight");
        int order_num = data.getIntValue("order_num");
        JSONArray array = data.getJSONArray("productList");
        JSONArray newArray = new JSONArray();
        String team_id = "";
        for (int i = 0; i < array.size(); ++i) {
            team_id = array.getJSONObject(i).getString("team_id");
        }
        String grade_id = "";
        if (StringUtils.isNotNull((Object)team_id)) {
            JSONObject param_user = new JSONObject();
            param_user.put("user_id", (Object)user_id);
            param_user.put("team_id", (Object)team_id);
            grade_id = this.teamAgent.getData(param_user, "/team/getTeamMemberGrade").getString("grade_id");
        }
        array = this.setOrderDetailProductParentTeam(array, grade_id);
        Double product_amount = 0.0;
        Double product_price = 0.0;
        int product_num = 0;
        for (int i = 0; i < array.size(); ++i) {
            JSONObject product = array.getJSONObject(i);
            product_amount = product.getDouble("product_amount");
            product_price = product.getDouble("product_price");
            product_num = product.getIntValue("product_num");
            product.remove((Object)"product_amount");
            product.put("product_amount", (Object)product_amount);
            product.remove((Object)"product_num");
            product.put("product_num", (Object)product_num);
            product.remove((Object)"product_price");
            product.put("product_price", (Object)product_price);
            newArray.add((Object)product);
        }
        Query query_ = new Query();
        query_.addCriteria((CriteriaDefinition)Criteria.where((String)"user_id").is((Object)user_id));
        User user_ = (User)this.mongoTemplate.findOne(query_, User.class);
        String u_uin = user_.getUin();
        String corp_code = user_.getCorp_code();
        Order order = new Order();
        order.setOrder_price(order_amount_pay);
        order.setOrder_amount_pay(order_amount_pay);
        order.setOrder_amount(order_amount);
        order.setOrder_reback_time(order_reback_time);
        order.setRecurrence(recurrence);
        order.setRecurrenceList(recurrenceList);
        order.setOrder_time(current);
        order.setLogisticsList(logistics_info);
        order.setU_uin(u_uin);
        if (StringUtils.isNotNull((Object)corp_code)) {
            order.setCorp_code(corp_code);
        }
        order.setOrder_vip(vip_order);
        order.setOrder_freight(order_freight);
        order.setOrder_num(order_num);
        order.setUser_id(user_id);
        order.setProductList(newArray);
        order.setCreator_id(user_id);
        order.setModifier_id(user_id);
        order.setCreated_date(current);
        order.setModified_date(current);
        order.setIs_active("Y");
        try {
            Memorandum memorandum;
            if (data.containsKey((Object)"order_reback_time")) {
                LocalDateTime end_datetime;
                String end_time_str;
                JSONObject order_json = JSONObject.parseObject((String)order.toString());
                order_json.put("order_id", (Object)order.get_id().toString());
                JSONArray jsonArray = new JSONArray();
                jsonArray.add((Object)vip_order);
                memorandum = new Memorandum();
                memorandum.set_id(new ObjectId());
                memorandum.setUser_id(user_id);
                memorandum.setIs_active("Y");
                memorandum.setCreator_id(user_id);
                memorandum.setCreated_date(TimeUtils.getCurrentTimeInString((SimpleDateFormat)TimeUtils.DATETIME_FORMAT_DATE));
                memorandum.setModifier_id(user_id);
                memorandum.setModified_date(memorandum.getCreated_date());
                memorandum.setRemind_time(data.getJSONObject("order_reback_time").getString("time"));
                memorandum.setContent("\u3010\u8ba2\u5355\u56de\u8bbf\u3011" + data.getJSONObject("recurrence").getString("remind_content"));
                memorandum.setVipList(jsonArray);
                memorandum.setClass_name("kr.weitao.weitaokr.task.vip.vipremind.VipRemindJob");
                String start_time_str = recurrence.getString("start_time");
                if (StringUtils.isNull((Object)start_time_str)) {
                    start_time_str = DateSwitchUtil.getCurrentDate();
                    recurrence.put("start_time", (Object)start_time_str);
                }
                if (StringUtils.isNull((Object)(end_time_str = recurrence.getString("end_time"))) && (end_datetime = MongodbUtil.getEndTime((JSONObject)recurrence)) != null) {
                    end_time_str = DateSwitchUtil.toString((LocalDateTime)end_datetime);
                    recurrence.put("end_time", (Object)end_time_str);
                }
                String cron = MongodbUtil.cron_expression((JSONObject)recurrence);
                recurrence.put("cron", (Object)cron);
                memorandum.setRecurrence(recurrence);
                log.info("create begin....");
                this.mongoTemplate.insert((Object)memorandum);
                log.info("create end...");
                QueueParam qp = new QueueParam();
                qp.set_id((Object)new ObjectId());
                qp.setUser_id(memorandum.getUser_id());
                qp.setCreator_id(user_id);
                qp.setCreated_date(memorandum.getCreated_date());
                qp.setModifier_id(user_id);
                qp.setModified_date(memorandum.getModified_date());
                qp.setIs_active("Y");
                qp.setName("_id");
                qp.setValue(memorandum.get_id().toString());
                qp.setQueue_item_id(memorandum.get_id().toString());
                this.mongoTemplate.insert((Object)qp);
                String str = memorandum.toString();
                log.info("str:" + str);
                this.jobService.addJob(JSON.parseObject((String)str));
                order.setRemind_id(memorandum.get_id().toString());
            }
            if (data.containsKey((Object)"productList")) {
                for (int i = 0; i < array.size(); ++i) {
                    LocalDateTime end_datetime;
                    String end_time_str;
                    JSONObject product = array.getJSONObject(i);
                    if (!product.containsKey((Object)"product_reback_time")) continue;
                    memorandum = new Memorandum();
                    if (product.getJSONObject("recurrence").size() == 0) continue;
                    if (product.getJSONObject("recurrence").size() > 0 && product.getJSONObject("recurrence").containsKey((Object)"remind_content")) {
                        memorandum.setContent("\u3010\u5546\u54c1\u56de\u8bbf\u3011" + product.getJSONObject("recurrence").getString("remind_content"));
                    }
                    if (product.getJSONObject("product_reback_time").size() > 0 && product.getJSONObject("product_reback_time").containsKey((Object)"time")) {
                        if (!org.apache.commons.lang.StringUtils.isNotBlank((String)product.getJSONObject("product_reback_time").getString("time"))) continue;
                        memorandum.setRemind_time(product.getJSONObject("product_reback_time").getString("time"));
                    }
                    JSONObject jsonObject_recurrence = product.getJSONObject("recurrence");
                    JSONArray jsonArray = new JSONArray();
                    jsonArray.add((Object)vip_order);
                    memorandum.set_id(new ObjectId());
                    memorandum.setUser_id(user_id);
                    memorandum.setIs_active("Y");
                    memorandum.setCreator_id(user_id);
                    memorandum.setCreated_date(TimeUtils.getCurrentTimeInString((SimpleDateFormat)TimeUtils.DATETIME_FORMAT_DATE));
                    memorandum.setModifier_id(user_id);
                    memorandum.setModified_date(memorandum.getCreated_date());
                    memorandum.setVipList(jsonArray);
                    memorandum.setClass_name("kr.weitao.weitaokr.task.vip.vipremind.VipRemindJob");
                    String start_time_str = jsonObject_recurrence.getString("start_time");
                    if (StringUtils.isNull((Object)start_time_str)) {
                        start_time_str = DateSwitchUtil.getCurrentDate();
                        jsonObject_recurrence.put("start_time", (Object)start_time_str);
                    }
                    if (StringUtils.isNull((Object)(end_time_str = jsonObject_recurrence.getString("end_time"))) && (end_datetime = MongodbUtil.getEndTime((JSONObject)recurrence)) != null) {
                        end_time_str = DateSwitchUtil.toString((LocalDateTime)end_datetime);
                        jsonObject_recurrence.put("end_time", (Object)end_time_str);
                    }
                    String cron = MongodbUtil.cron_expression((JSONObject)jsonObject_recurrence);
                    jsonObject_recurrence.put("cron", (Object)cron);
                    memorandum.setRecurrence(jsonObject_recurrence);
                    log.info("create begin....");
                    this.mongoTemplate.insert((Object)memorandum);
                    log.info("create end...");
                    QueueParam qp = new QueueParam();
                    qp.set_id((Object)new ObjectId());
                    qp.setUser_id(memorandum.getUser_id());
                    qp.setCreator_id(user_id);
                    qp.setCreated_date(memorandum.getCreated_date());
                    qp.setModifier_id(user_id);
                    qp.setModified_date(memorandum.getModified_date());
                    qp.setIs_active("Y");
                    qp.setName("_id");
                    qp.setValue(memorandum.get_id().toString());
                    qp.setQueue_item_id(memorandum.get_id().toString());
                    this.mongoTemplate.insert((Object)qp);
                    String str = memorandum.toString();
                    log.info("str:" + str);
                    this.jobService.addJob(JSON.parseObject((String)str));
                    Query query = new Query();
                    query.addCriteria((CriteriaDefinition)Criteria.where((String)"_id").is((Object)new ObjectId(product.getString("product_id"))));
                    Update update = new Update();
                    update.set("remind_id", (Object)memorandum.get_id().toString());
                    this.mongoTemplate.upsert(query, update, Product.class);
                }
            }
        }
        catch (Exception e) {
            log.info("---\u8ba2\u5355\u5907\u5fd8\u5f55----", (Throwable)e);
        }
        this.mongoTemplate.save((Object)order);
        JSONObject da = new JSONObject();
        da.put("id", (Object)order.get_id().toString());
        dataResponse.setStatus(Status.SUCCESS).setCode("0").setId(dataRequest.getId()).setData(da);
        return dataResponse;
    }

    public DataResponse create(DataRequest dataRequest) {
        DataResponse dataResponse;
        Query teamQuery;
        Team team;
        User user;
        Vip vip1;
        JSONObject object = dataRequest.getData();
        String user_id = object.getString("user_id");
        String open_id = object.getString("open_id");
        String app_id = object.getString("app_id");
        String vip_id = object.getString("vip_id");
        String type = object.getString("type");
        String record_id = object.getString("record_id");
        String source = object.getString("source");
        String team_id = object.getString("team_id");
        String share_open_id = object.getString("share_open_id");
        String mini_appid = object.getString("mini_appid");
        String living_id = "";
        String order_source = "";
        living_id = object.getString("living_id") != null ? object.getString("living_id") : "";
        order_source = object.getString("order_source") != null ? object.getString("order_source") : "";
        String share_guide = object.getString("share_guide");
        if (StringUtils.isNull((Object)user_id) && StringUtils.isNotNull((Object)share_open_id) && null != (vip1 = (Vip)this.mongoTemplate.findOne(Query.query((CriteriaDefinition)Criteria.where((String)"mini_openid").is((Object)share_open_id)), Vip.class)) && StringUtils.isNotNull((Object)vip1.getVip_phone()) && null != (user = (User)this.mongoTemplate.findOne(Query.query((CriteriaDefinition)Criteria.where((String)"phone").is((Object)vip1.getVip_phone()).and("corp_code").is((Object)vip1.getCorp_code())), User.class))) {
            user_id = user.getUser_id();
            object.put("user_id", (Object)user_id);
            log.info("share_open_id-----" + dataRequest.getData().toString());
        }
        int over_time = 12;
        String expiredTime = "";
        try {
            DBCollection collection_order_param = this.mongoTemplate.getCollection("def_order_param");
            DBObject dbObject = collection_order_param.findOne();
            if (null != dbObject && dbObject.containsField("order_overdue_time")) {
                over_time = Integer.parseInt(dbObject.get("order_overdue_time").toString());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        JSONArray items = object.getJSONArray("orderItem");
        Double order_amount_pay = 0.0;
        Double order_amount = 0.0;
        String order_time = TimeUtils.getTime((long)System.currentTimeMillis());
        int order_num = 0;
        Double order_freight = 0.0;
        String is_online_pay = "Y";
        JSONObject pay_info = new JSONObject();
        pay_info.put("pay_status", (Object)"0");
        pay_info.put("pay_way", (Object)"online");
        JSONObject order_vip = new JSONObject();
        String exclusive_user = "";
        if (StringUtils.isNotNull((Object)vip_id)) {
            order_vip.put("vip_id", (Object)vip_id);
            Vip vip = (Vip)this.mongoTemplate.findOne(Query.query((CriteriaDefinition)Criteria.where((String)"vip_id").is((Object)vip_id)), Vip.class);
            if (null == vip) {
                order_vip.put("vip_name", (Object)"\u672a\u77e5\u987e\u5ba2");
            } else {
                exclusive_user = vip.getUser_id();
                String vip_name = vip.getVip_name();
                if (StringUtils.isNull((Object)vip_name)) {
                    vip_name = vip.getNick_name();
                }
                order_vip.put("vip_name", (Object)vip_name);
                String bing_user_id = vip.getUser_id();
                if (StringUtils.isNull((Object)team_id)) {
                    team_id = vip.getTeam_id();
                }
                if (StringUtils.isNotNull((Object)bing_user_id) && StringUtils.isNull((Object)user_id)) {
                    user_id = bing_user_id;
                    object.put("user_id", (Object)user_id);
                }
            }
        }
        DBObject object_coupon = this.mongoTemplate.getCollection("def_coupon_product_param").findOne();
        JSONArray array = new JSONArray();
        String product_name_ = "";
        JSONObject calculateProducts = new JSONObject();
        calculateProducts.put("productInfo", (Object)items);
        calculateProducts.put("vip_id", (Object)vip_id);
        JSONObject result = this.activityAgent.getData(calculateProducts, "/activity/calculateProducts");
        log.info("---\u9a8c\u8bc1\u6ee1\u51cf--" + result);
        JSONArray productListActivity = result.getJSONArray("productInfo");
        JSONArray activity_ids = result.getJSONArray("activityInfo");
        JSONArray activityRuleInfo = result.getJSONArray("activityRuleInfo");
        for (int i = 0; i < productListActivity.size(); ++i) {
            int on_sale;
            Team team2;
            JSONObject item = productListActivity.getJSONObject(i);
            item.put("user_id", (Object)user_id);
            JSONObject product = this.getProductInfoV2(item);
            item.putAll((Map)product);
            String team_id_product = item.getString("team_id");
            String sku_id = item.getString("sku_id");
            if (StringUtils.isNull((Object)team_id)) {
                team_id = team_id_product;
            }
            if (StringUtils.isNull((Object)team_id) && StringUtils.isNotNull((Object)user_id) && null != (team2 = (Team)this.mongoTemplate.findOne(Query.query((CriteriaDefinition)Criteria.where((String)"members").in(new Object[]{user_id})), Team.class))) {
                team_id = team2.get_id().toString();
            }
            if (StringUtils.isNotNull((Object)team_id)) {
                team_id = team_id.trim();
            }
            item.put("team_id", (Object)team_id);
            product_name_ = product.getString("product_name");
            if (StringUtils.isNotNull((Object)product.get((Object)"on_sale")) && (on_sale = product.getInteger("on_sale").intValue()) != 1) {
                return new DataResponse().setStatus(Status.FAILED).setMsg("\u5546\u54c1\uff1a" + product_name_ + " \u5df2\u88ab\u4e0b\u67b6\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u5546\u54c1");
            }
            item.put("product_name", (Object)product.getString("product_name"));
            item.put("product_price", (Object)product.getDouble("product_price"));
            if (StringUtils.isNotNull((Object)sku_id)) {
                Sku sku = (Sku)this.mongoTemplate.findOne(new Query((CriteriaDefinition)Criteria.where((String)"_id").is((Object)new ObjectId(sku_id))), Sku.class);
                if (sku == null) {
                    return new DataResponse().setStatus(Status.FAILED).setMsg("\u5546\u54c1\uff1a" + product_name_ + "\u6761\u7801\u6570\u636e\u6709\u8bef");
                }
                if (!"Y".equals(sku.getIs_active())) {
                    Query query;
                    List specItem;
                    JSONArray specArray = sku.getSpec_array();
                    ArrayList<ObjectId> objectIds = new ArrayList<ObjectId>();
                    for (int j = 0; j < specArray.size(); ++j) {
                        objectIds.add(new ObjectId(specArray.getJSONObject(j).getString("spec_item_id")));
                    }
                    StringBuffer specItemName = new StringBuffer();
                    if (objectIds.isEmpty() && StringUtils.isNotNull((Object)(specItem = this.mongoTemplate.find(query = new Query((CriteriaDefinition)Criteria.where((String)"_id").in(objectIds)), SpecItem.class)))) {
                        for (int j = 0; j < specItem.size(); ++j) {
                            specItemName.append(((SpecItem)specItem.get(j)).getName());
                        }
                    }
                    return new DataResponse().setStatus(Status.FAILED).setMsg("\u5546\u54c1\uff1a" + product_name_ + specItemName + " \u5df2\u65e0\u6cd5\u8d2d\u4e70\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u5546\u54c1");
                }
                if (sku.getPrice() > 0.0) {
                    item.put("product_price", (Object)sku.getPrice());
                    item.put("sku_code", (Object)sku.getCode());
                    JSONArray jsonArray = sku.getSpec_array();
                    JSONArray spec_array = new JSONArray();
                    for (int j = 0; j < jsonArray.size(); ++j) {
                        JSONObject object1 = jsonArray.getJSONObject(j);
                        String spec_id = object1.getString("spec_id");
                        String spec_item_id = object1.getString("spec_item_id");
                        Spec spec = (Spec)this.mongoTemplate.findOne(Query.query((CriteriaDefinition)Criteria.where((String)"spec_id").is((Object)spec_id)), Spec.class);
                        SpecItem specItem = (SpecItem)this.mongoTemplate.findOne(Query.query((CriteriaDefinition)Criteria.where((String)"spec_item_id").is((Object)spec_item_id)), SpecItem.class);
                        if (null != spec) {
                            object1.put("name", (Object)spec.getName());
                        }
                        if (null != specItem) {
                            object1.put("spec_item_name", (Object)specItem.getName());
                        }
                        spec_array.add((Object)object1);
                    }
                    item.put("spec_array", (Object)spec_array);
                }
            }
            if (StringUtils.isNotNull((Object)team_id)) {
                String status = product.getString("status");
                String product_name = product.getString("product_name");
                if ("2".equals(status)) {
                    return new DataResponse().setStatus(Status.FAILED).setMsg("\u8be5\u5546\u54c1\uff1a" + product_name + " \u5df2\u4e0b\u67b6\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u5546\u54c1");
                }
                JSONObject payinfo = new JSONObject();
                payinfo.put("team_id", (Object)team_id);
                DataRequest dataRequest1 = new DataRequest();
                dataRequest1.setData(payinfo);
                DataResponse paydataresponse = this.dataAgent.callRest(dataRequest1, "/paymentAccount/getHierarchyPaymentAccount");
                if ("SUCCESS".equals(paydataresponse.getStatus().toString()) && (payinfo = paydataresponse.getData()).containsKey((Object)"payment_account_id")) {
                    product.put("payment_account_id", (Object)payinfo.getString("payment_account_id"));
                }
            }
            item.put("product_amount", (Object)item.getDouble("productsDiscountAmount"));
            order_amount_pay = order_amount_pay + item.getDouble("productsDiscountAmount");
            order_amount = order_amount + item.getDouble("product_price") * item.getDouble("num");
            order_num += item.getIntValue("num");
            array.add((Object)item);
        }
        if (!StringUtils.isNotNull((Object)vip_id)) {
            return new DataResponse().setStatus(Status.FAILED).setCode("-1").setMsg("\u8bf7\u9009\u62e9\u4f1a\u5458");
        }
        object.put("order_vip", (Object)order_vip);
        object.put("order_time", (Object)order_time);
        object.put("order_freight", (Object)order_freight);
        object.put("is_online_pay", (Object)is_online_pay);
        object.put("pay_info", (Object)pay_info);
        object.put("productList", (Object)array);
        object.put("order_amount_pay", (Object)order_amount_pay);
        object.put("activity_discount_amount", (Object)result.getDouble("discountAmount"));
        object.put("order_num", (Object)order_num);
        object.put("order_amount", (Object)order_amount);
        object.put("order_type", (Object)"0");
        object.put("type", (Object)type);
        object.put("activity_ids", (Object)activity_ids);
        object.put("exclusive_user", (Object)exclusive_user);
        object.put("order_pay_status", (Object)"0");
        object.put("activityRuleInfo", (Object)activityRuleInfo);
        if (StringUtils.isNotNull((Object)team_id) && (team = (Team)this.mongoTemplate.findOne(teamQuery = new Query((CriteriaDefinition)Criteria.where((String)"_id").is((Object)new ObjectId(team_id))).addCriteria((CriteriaDefinition)Criteria.where((String)"is_active").is((Object)"Y")), Team.class)) != null && StringUtils.isNotNull((Object)team.getStore_id())) {
            object.put("store_id", (Object)team.getStore_id());
        }
        if (StringUtils.isNotNull((Object)living_id)) {
            DataRequest livRequest = new DataRequest();
            JSONObject livInfo = new JSONObject();
            try {
                livInfo.put("mini_appid", (Object)mini_appid);
                livInfo.put("livingid", (Object)living_id);
                livRequest.setData(livInfo);
                DataResponse livResponse = this.wechatService.getData("/live/getLivingInfo", livRequest);
                JSONObject livData = livResponse.getData();
                if (StringUtils.isNotNull((Object)livData.get((Object)"theme"))) {
                    object.put("living_theme", livData.get((Object)"theme"));
                } else {
                    log.error("theme is null prams:" + JSON.toJSONString((Object)livData));
                }
                if (StringUtils.isNotNull((Object)livData.get((Object)"living_start"))) {
                    String living_start1 = TimeUtils.getTime((long)(livData.getLong("living_start") * 1000L));
                    object.put("living_start", (Object)living_start1);
                } else {
                    log.error("theme is null prams:" + JSON.toJSONString((Object)livData));
                }
                log.debug("---| get living share info, param:" + JSON.toJSONString((Object)livRequest) + ", response:{}" + JSON.toJSONString((Object)livResponse));
            }
            catch (Exception e) {
                log.debug("---| get living info error" + e.getLocalizedMessage());
            }
            if (StringUtils.isNotNull((Object)order_source)) {
                object.put("order_source", (Object)order_source);
            } else {
                log.error("living is null prams:" + JSON.toJSONString((Object)dataRequest));
            }
            if (StringUtils.isNotNull((Object)share_guide)) {
                User user2 = (User)this.mongoTemplate.findOne(Query.query((CriteriaDefinition)Criteria.where((String)"user_id").is((Object)share_guide)), User.class);
                object.put("share_guide", (Object)user2.getUser_name());
            } else {
                log.error("share_guide is null prams:" + JSON.toJSONString((Object)dataRequest));
            }
        } else {
            object.put("share_guide", (Object)share_guide);
            object.put("order_source", (Object)order_source);
            object.put("living_start", (Object)"");
            object.put("living_theme", (Object)"");
            object.put("living_id", (Object)living_id);
        }
        if (StringUtils.isNotNull((Object)result.getString("is_birthday_discount")) && "Y".equals(result.getString("is_birthday_discount"))) {
            JSONObject data = dataRequest.getData();
            data.put("is_birthday_discount", (Object)result.getString("is_birthday_discount"));
            data.put("vipDiscount", (Object)result.getString("vipDiscount"));
            dataRequest.setData(data);
        }
        if ("SUCCESS".equals((dataResponse = this.addv2(dataRequest)).getStatus().toString())) {
            String id = dataResponse.getData().getString("id");
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("order_id", (Object)id);
            jsonObject.put("url", (Object)(this.api_server_domain + "/order/getUrl?order_id=" + id + "&url=" + this.weixin_server_order_url));
            return new DataResponse().setData(jsonObject).setStatus(Status.SUCCESS).setCode("0");
        }
        if (null != dataResponse.getMsg() && !dataResponse.getMsg().startsWith("\u79d2\u6740\u6821\u9a8c\u5931\u8d25")) {
            JSONObject object1 = new JSONObject();
            object1.put("productInfo", (Object)items);
            object1.put("type", (Object)"ADD");
            DataRequest dataRequest1 = new DataRequest();
            dataRequest1.setData(object1);
            DataResponse dataResponse1 = this.activityAgent.callRest(dataRequest1, "/seckill/activity/handleSeckillStock");
            log.info("-handleSeckillStock--" + dataResponse1);
        }
        if (StringUtils.isNotNull((Object)dataResponse.getMsg())) {
            String msg = "";
            msg = dataResponse.getMsg().startsWith("\u79d2\u6740\u6821\u9a8c\u5931\u8d25") ? dataResponse.getMsg().split(":")[1] : dataResponse.getMsg();
            return dataResponse.setMsg(msg);
        }
        return new DataResponse().setStatus(Status.FAILED).setMsg("\u521b\u5efa\u8ba2\u5355\u5931\u8d25");
    }

    public DataResponse createV2(DataRequest dataRequest) {
        JSONObject object = dataRequest.getData();
        String user_id = object.getString("user_id");
        String vip_id = object.getString("vip_id");
        String type = object.getString("type");
        String team_id = object.getString("team_id");
        String mini_appid = object.getString("mini_appid");
        String livingid = "";
        String order_source = "";
        try {
            livingid = object.getString("livingid");
        }
        catch (Exception e) {
            livingid = "";
        }
        try {
            order_source = object.getString("order_source");
        }
        catch (Exception e) {
            order_source = "";
        }
        String share_guide = object.getString("share_guide");
        object.put("is_create", (Object)"N");
        JSONArray items = object.getJSONArray("orderItem");
        Double order_amount_pay = 0.0;
        Double order_amount = 0.0;
        String order_time = TimeUtils.getTime((long)System.currentTimeMillis());
        int order_num = 0;
        Double order_freight = 0.0;
        String is_online_pay = "Y";
        JSONObject pay_info = new JSONObject();
        pay_info.put("pay_status", (Object)"0");
        pay_info.put("pay_way", (Object)"online");
        JSONObject order_vip = new JSONObject();
        String exclusive_user = "";
        if (StringUtils.isNotNull((Object)vip_id)) {
            order_vip.put("vip_id", (Object)vip_id);
            Vip vip = (Vip)this.mongoTemplate.findOne(Query.query((CriteriaDefinition)Criteria.where((String)"vip_id").is((Object)vip_id)), Vip.class);
            if (null == vip) {
                order_vip.put("vip_name", (Object)"\u672a\u77e5\u987e\u5ba2");
            } else {
                exclusive_user = vip.getUser_id();
                String vip_name = vip.getVip_name();
                if (StringUtils.isNull((Object)vip_name)) {
                    vip_name = vip.getNick_name();
                }
                order_vip.put("vip_name", (Object)vip_name);
                String bing_user_id = vip.getUser_id();
                if (StringUtils.isNull((Object)team_id)) {
                    team_id = vip.getTeam_id();
                }
                if (StringUtils.isNotNull((Object)bing_user_id) && StringUtils.isNull((Object)user_id)) {
                    user_id = bing_user_id;
                    object.put("user_id", (Object)user_id);
                }
            }
        }
        JSONArray array = new JSONArray();
        String product_name_ = "";
        for (int i = 0; i < items.size(); ++i) {
            int on_sale;
            Team team;
            JSONObject product;
            JSONObject item = items.getJSONObject(i);
            String product_id = item.getString("product_id");
            Integer num = item.getInteger("num");
            String is_group = item.getString("is_group");
            if (!"Y".equals(is_group)) {
                int on_sale2;
                Team team2;
                item.put("user_id", (Object)user_id);
                product = this.getProductInfoV2(item);
                String sku_id = product.getString("sku_id");
                String team_id_product = item.getString("team_id");
                if (StringUtils.isNull((Object)team_id)) {
                    team_id = team_id_product;
                }
                if (StringUtils.isNull((Object)team_id) && StringUtils.isNotNull((Object)user_id) && null != (team2 = (Team)this.mongoTemplate.findOne(Query.query((CriteriaDefinition)Criteria.where((String)"members").in(new Object[]{user_id})), Team.class))) {
                    team_id = team2.get_id().toString();
                }
                product.put("team_id", (Object)team_id);
                product_name_ = product.getString("product_name");
                if (StringUtils.isNotNull((Object)product.get((Object)"on_sale")) && (on_sale2 = product.getInteger("on_sale").intValue()) != 1) {
                    return new DataResponse().setStatus(Status.FAILED).setMsg("\u5546\u54c1\uff1a" + product_name_ + " \u5df2\u88ab\u4e0b\u67b6\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u5546\u54c1");
                }
                if (StringUtils.isNotNull((Object)sku_id)) {
                    Sku sku = (Sku)this.mongoTemplate.findOne(new Query((CriteriaDefinition)Criteria.where((String)"_id").is((Object)new ObjectId(sku_id))), Sku.class);
                    if (sku == null) {
                        return new DataResponse().setStatus(Status.FAILED).setMsg("\u5546\u54c1\uff1a" + product_name_ + "\u6761\u7801\u6570\u636e\u6709\u8bef");
                    }
                    if (!"Y".equals(sku.getIs_active())) {
                        Query query;
                        List specItem;
                        JSONArray specArray = sku.getSpec_array();
                        ArrayList<ObjectId> objectIds = new ArrayList<ObjectId>();
                        for (int j = 0; j < specArray.size(); ++j) {
                            objectIds.add(new ObjectId(specArray.getJSONObject(j).getString("spec_item_id")));
                        }
                        StringBuffer specItemName = new StringBuffer();
                        if (objectIds.isEmpty() && StringUtils.isNotNull((Object)(specItem = this.mongoTemplate.find(query = new Query((CriteriaDefinition)Criteria.where((String)"_id").in(objectIds)), SpecItem.class)))) {
                            for (int j = 0; j < specItem.size(); ++j) {
                                specItemName.append(((SpecItem)specItem.get(j)).getName());
                            }
                        }
                        return new DataResponse().setStatus(Status.FAILED).setMsg("\u5546\u54c1\uff1a" + product_name_ + specItemName + " \u5df2\u65e0\u6cd5\u8d2d\u4e70\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u5546\u54c1");
                    }
                    if (sku.getPrice() > 0.0) {
                        product.put("product_price", (Object)sku.getPrice());
                        product.put("sku_code", (Object)sku.getOutter_id());
                        JSONArray jsonArray = sku.getSpec_array();
                        JSONArray spec_array = new JSONArray();
                        for (int j = 0; j < jsonArray.size(); ++j) {
                            JSONObject object1 = jsonArray.getJSONObject(j);
                            String spec_id = object1.getString("spec_id");
                            String spec_item_id = object1.getString("spec_item_id");
                            Spec spec = (Spec)this.mongoTemplate.findOne(Query.query((CriteriaDefinition)Criteria.where((String)"spec_id").is((Object)spec_id)), Spec.class);
                            SpecItem specItem = (SpecItem)this.mongoTemplate.findOne(Query.query((CriteriaDefinition)Criteria.where((String)"spec_item_id").is((Object)spec_item_id)), SpecItem.class);
                            if (null != spec) {
                                object1.put("name", (Object)spec.getName());
                            }
                            if (null != specItem) {
                                object1.put("spec_item_name", (Object)specItem.getName());
                            }
                            spec_array.add((Object)object1);
                        }
                        product.put("spec_array", (Object)spec_array);
                    }
                }
                if (StringUtils.isNotNull((Object)team_id)) {
                    String status = product.getString("status");
                    String product_name = product.getString("product_name");
                    if ("2".equals(status)) {
                        return new DataResponse().setStatus(Status.FAILED).setMsg("\u8be5\u5546\u54c1\uff1a" + product_name + " \u5df2\u4e0b\u67b6\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u5546\u54c1");
                    }
                    JSONObject payinfo = new JSONObject();
                    payinfo.put("team_id", (Object)team_id);
                    DataRequest dataRequest1 = new DataRequest();
                    dataRequest1.setData(payinfo);
                    DataResponse paydataresponse = this.dataAgent.callRest(dataRequest1, "/paymentAccount/getHierarchyPaymentAccount");
                    if ("SUCCESS".equals(paydataresponse.getStatus().toString()) && (payinfo = paydataresponse.getData()).containsKey((Object)"payment_account_id")) {
                        product.put("payment_account_id", (Object)payinfo.getString("payment_account_id"));
                    }
                }
                order_amount_pay = order_amount_pay + product.getDouble("product_price") * product.getDouble("product_num");
                order_amount = order_amount + product.getDouble("product_price") * product.getDouble("product_num");
                order_num += product.getIntValue("product_num");
                array.add((Object)product);
                continue;
            }
            product = this.getProductInfoV2(item);
            String team_id_product = item.getString("team_id");
            if (StringUtils.isNull((Object)team_id)) {
                team_id = team_id_product;
            }
            if (StringUtils.isNull((Object)team_id) && StringUtils.isNotNull((Object)user_id) && null != (team = (Team)this.mongoTemplate.findOne(Query.query((CriteriaDefinition)Criteria.where((String)"members").in(new Object[]{user_id})), Team.class))) {
                team_id = team.get_id().toString();
            }
            product.put("team_id", (Object)team_id);
            product_name_ = product.getString("product_name");
            if (StringUtils.isNotNull((Object)product.get((Object)"on_sale")) && (on_sale = product.getInteger("on_sale").intValue()) != 1) {
                return new DataResponse().setStatus(Status.FAILED).setMsg("\u5546\u54c1\uff1a" + product_name_ + " \u5df2\u88ab\u4e0b\u67b6\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u5546\u54c1");
            }
            order_amount_pay = order_amount_pay + product.getDouble("product_price") * product.getDouble("product_num");
            order_amount = order_amount + product.getDouble("product_price") * product.getDouble("product_num");
            order_num += product.getIntValue("product_num");
            array.add((Object)product);
        }
        if (StringUtils.isNotNull((Object)vip_id)) {
            object.put("order_vip", (Object)order_vip);
        }
        if (StringUtils.isNotNull((Object)livingid)) {
            DataRequest livRequest = new DataRequest();
            JSONObject livInfo = new JSONObject();
            try {
                livInfo.put("mini_appid", (Object)mini_appid);
                livInfo.put("livingid", (Object)livingid);
                livRequest.setData(livInfo);
                DataResponse livResponse = this.wechatService.getData("/live/getLivingInfo", livRequest);
                JSONObject livData = livResponse.getData();
                if (StringUtils.isNotNull((Object)livData.get((Object)"theme"))) {
                    object.put("living_theme", livData.get((Object)"theme"));
                } else {
                    log.error("theme is null prams:" + JSON.toJSONString((Object)livData));
                }
                if (StringUtils.isNotNull((Object)livData.get((Object)"living_start"))) {
                    object.put("living_start", livData.get((Object)"living_start"));
                } else {
                    log.error("theme is null prams:" + JSON.toJSONString((Object)livData));
                }
                log.debug("---| get living share info, param:" + JSON.toJSONString((Object)livRequest) + ", response:{}" + JSON.toJSONString((Object)livResponse));
            }
            catch (Exception e) {
                log.debug("---| get living info error" + e.getLocalizedMessage());
            }
            if (StringUtils.isNotNull((Object)order_source)) {
                object.put("order_source", (Object)order_source);
            } else {
                log.error("living is null prams:" + JSON.toJSONString((Object)dataRequest));
            }
            if (StringUtils.isNotNull((Object)share_guide)) {
                object.put("share_guide", (Object)share_guide);
            } else {
                log.error("share_guide is null prams:" + JSON.toJSONString((Object)dataRequest));
            }
        } else {
            object.put("share_guide", (Object)share_guide);
            object.put("order_source", (Object)order_source);
            object.put("living_start", (Object)"");
            object.put("living_theme", (Object)"");
            object.put("livingid", (Object)livingid);
        }
        object.put("order_time", (Object)order_time);
        object.put("order_freight", (Object)order_freight);
        object.put("is_online_pay", (Object)is_online_pay);
        object.put("pay_info", (Object)pay_info);
        object.put("productList", (Object)array);
        object.put("order_amount_pay", (Object)order_amount_pay);
        object.put("order_num", (Object)order_num);
        object.put("order_amount", (Object)order_amount);
        object.put("order_type", (Object)"0");
        object.put("type", (Object)type);
        object.put("exclusive_user", (Object)exclusive_user);
        object.put("order_pay_status", (Object)"0");
        log.info("-----addv4---" + dataRequest);
        DataResponse dataResponse = this.addv4(dataRequest);
        if ("SUCCESS".equals(dataResponse.getStatus().toString())) {
            String id = dataResponse.getData().getString("id");
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("order_id", (Object)id);
            jsonObject.put("url", (Object)(this.api_server_domain + "/order/getUrl?order_id=" + id + "&url=" + this.weixin_server_order_url));
            return new DataResponse().setData(jsonObject).setStatus(Status.SUCCESS).setCode("0");
        }
        if (StringUtils.isNotNull((Object)dataResponse.getMsg())) {
            return dataResponse;
        }
        return new DataResponse().setStatus(Status.FAILED).setMsg("\u521b\u5efa\u8ba2\u5355\u5931\u8d25");
    }

    public JSONObject getProductInfoV2(JSONObject jsonObject) {
        JSONObject product = new JSONObject();
        String sku_id = jsonObject.getString("sku_id");
        String team_id = jsonObject.getString("team_id");
        String user_id = jsonObject.getString("user_id");
        String product_id = jsonObject.getString("product_id");
        int num = jsonObject.getIntValue("num");
        BasicDBObject basicDBObject = new BasicDBObject();
        basicDBObject.put((Object)"product_id", (Object)product_id);
        DBObject dbObject_product = this.mongoTemplate.getCollection("def_product").findOne((DBObject)basicDBObject);
        JSONObject object_product = JSONObject.parseObject((String)JSON.toJSONString((Object)dbObject_product));
        product.put("product_id", (Object)product_id);
        product.put("product_no", dbObject_product.get("product_no"));
        product.put("team_id", (Object)team_id);
        product.put("select_group_info", (Object)jsonObject.getJSONArray("select_group_info"));
        if (StringUtils.isNotNull((Object)jsonObject.getString("is_group"))) {
            product.put("is_group", (Object)jsonObject.getString("is_group"));
        } else {
            product.put("is_group", (Object)"N");
        }
        product.put("product_price", (Object)object_product.getDoubleValue("product_price"));
        if (StringUtils.isNotNull((Object)team_id)) {
            String team_commission_rule_id;
            basicDBObject = new BasicDBObject();
            basicDBObject.put((Object)"team_id", (Object)team_id);
            basicDBObject.put((Object)"product_id", (Object)product_id);
            DBObject dbObject = this.mongoTemplate.getCollection("def_team_product").findOne((DBObject)basicDBObject);
            Map map = dbObject.toMap();
            JSONObject param = new JSONObject();
            param.put("team_id", (Object)team_id);
            param.put("sku_id", (Object)sku_id);
            param.put("product_id", (Object)product_id);
            param.put("team_product", (Object)JSONObject.parseObject((String)JSON.toJSONString((Object)dbObject)));
            JSONObject jsonObject1 = this.dataAgent.getData(param, "/teamProduct/getTeamSkuPrice");
            product.put("product_price", (Object)jsonObject1.getString("team_sku_price"));
            product.put("team_product_id", (Object)map.get("_id").toString());
            product.put("status", (Object)map.get("status").toString());
            if (map.containsKey("team_commission_rule_id") && null != map.get("team_commission_rule_id") && StringUtils.isNotNull((Object)(team_commission_rule_id = map.get("team_commission_rule_id").toString()))) {
                TeamMember teamMember;
                JSONArray grades;
                product.put("team_commission_rule_id", (Object)team_commission_rule_id);
                TeamCommissionRule teamCommissionRule = (TeamCommissionRule)this.mongoTemplate.findOne(Query.query((CriteriaDefinition)Criteria.where((String)"_id").is((Object)new ObjectId(team_commission_rule_id))), TeamCommissionRule.class);
                String commission_scale = "";
                if (null != teamCommissionRule && null != (grades = teamCommissionRule.getGrades()) && null != (teamMember = (TeamMember)this.mongoTemplate.findOne(Query.query((CriteriaDefinition)Criteria.where((String)"team_id").is((Object)team_id).and("user_id").is((Object)user_id)), TeamMember.class))) {
                    String grade_id = teamMember.getGrade_id();
                    for (int i = 0; i < grades.size(); ++i) {
                        JSONObject gradeItem = grades.getJSONObject(i);
                        if (!gradeItem.containsValue((Object)grade_id)) continue;
                        commission_scale = gradeItem.getString("grade_scale");
                    }
                }
                product.put("commission_scale", (Object)commission_scale);
            }
        }
        product.put("creator_id", (Object)object_product.getString("creator_id"));
        product.put("on_sale", object_product.get((Object)"on_sale"));
        product.put("product_desc", (Object)object_product.getJSONArray("product_desc"));
        product.put("product_name", (Object)object_product.getString("product_name"));
        JSONObject object = new JSONObject();
        object.put("image_url", (Object)object_product.getString("first_image_url"));
        JSONArray array = new JSONArray();
        array.add((Object)object);
        product.put("product_image_url", (Object)array);
        product.put("corp_code", (Object)object_product.getString("corp_code"));
        product.put("product_url", (Object)object_product.getJSONArray("product_url"));
        product.put("product_num", (Object)num);
        if (StringUtils.isNotNull((Object)sku_id)) {
            product.put("sku_id", (Object)sku_id);
        }
        return product;
    }

    public DataResponse addv3(DataRequest dataRequest) {
        JSONObject da;
        DataResponse dataResponse = new DataResponse();
        String current = TimeUtils.getCurrentTimeInString((SimpleDateFormat)TimeUtils.DATETIME_FORMAT_DATE);
        JSONObject data = dataRequest.getData();
        String user_id = data.getString("user_id");
        String order_type = data.getString("order_type");
        String type = data.getString("type");
        String trade_type = data.getString("trade_type");
        String order_no = data.getString("order_no");
        String order_remark = data.getString("order_remark");
        Double order_amount_pay = NumberUtil.round((double)data.getDouble("order_amount_pay"));
        Double order_amount = NumberUtil.round((double)data.getDouble("order_amount"));
        JSONObject recurrence = data.getJSONObject("recurrence");
        JSONArray logistics_info = data.getJSONArray("logisticsList");
        JSONObject express = data.getJSONObject("express_info");
        JSONObject pay_info = data.getJSONObject("pay_info");
        String pay_status = "0";
        if (StringUtils.isNotNull((Object)pay_info)) {
            String is_pay;
            String pay = pay_info.getString("pay_way");
            pay_status = pay_info.getString("pay_status");
            if (StringUtils.isNull((Object)pay_status) && "Y".equals(is_pay = pay_info.getString("is_pay"))) {
                pay_status = "1";
            }
            if (!"online".equals(pay)) {
                // empty if block
            }
        }
        String setExclusive_user = "";
        JSONObject vip_order = data.getJSONObject("order_vip");
        if (null != vip_order && !vip_order.isEmpty()) {
            String vip_id = vip_order.getString("vip_id");
            Vip vip = (Vip)this.mongoTemplate.findOne(Query.query((CriteriaDefinition)Criteria.where((String)"vip_id").is((Object)vip_id)), Vip.class);
            if (vip == null) {
                return new DataResponse().setMsg("\u6d88\u8d39\u4f1a\u5458\u4e0d\u5b58\u5728").setStatus(Status.FAILED);
            }
            String vip_name = vip_order.getString("vip_name");
            if (StringUtils.isNull((Object)vip_name)) {
                vip_name = vip.getVip_name() != null ? vip_name : vip.getNick_name();
                vip_order.put("vip_name", (Object)vip_name);
            }
            if (StringUtils.isNotNull((Object)vip.getUser_id())) {
                setExclusive_user = vip.getUser_id();
            }
        }
        Double order_freight = NumberUtil.round((double)data.getDouble("order_freight"));
        int order_num = data.getIntValue("order_num");
        JSONArray array = data.getJSONArray("productList");
        String team_id = "";
        for (int i = 0; i < array.size(); ++i) {
            team_id = array.getJSONObject(i).getString("team_id");
        }
        String grade_id = "";
        if (StringUtils.isNotNull((Object)team_id)) {
            JSONObject param_user = new JSONObject();
            param_user.put("user_id", (Object)user_id);
            param_user.put("team_id", (Object)team_id);
            grade_id = this.teamAgent.getData(param_user, "/team/getTeamMemberGrade").getString("grade_id");
        }
        array = this.setOrderDetailProductParentTeam(array, grade_id);
        JSONArray array_product = this.operateProduct(array, order_amount_pay, order_amount, "", order_freight);
        JSONArray recurrenceList = data.getJSONArray("recurrenceList");
        Query query_ = new Query();
        query_.addCriteria((CriteriaDefinition)Criteria.where((String)"user_id").is((Object)user_id));
        User user_ = (User)this.mongoTemplate.findOne(query_, User.class);
        if (null == user_) {
            return dataResponse.setStatus(Status.FAILED).setId(dataRequest.getId()).setMsg("\u7528\u6237\u4e0d\u5b58\u5728");
        }
        String u_uin = user_.getUin();
        String corp_code = user_.getCorp_code();
        Order order = new Order();
        if (StringUtils.isNotNull((Object)type)) {
            order.setType(type);
            if ("group".equals(type)) {
                dataResponse = this.disposeGroupOrder(data.getString("activity_id"), data.getString("record_id"), vip_order.getString("vip_id"));
                if (dataResponse.getStatus().equals((Object)Status.FAILED)) {
                    return dataResponse;
                }
                if (dataResponse.getData() != null && dataResponse.getData().containsKey((Object)"id")) {
                    return dataResponse;
                }
            } else if ("seckill".equals(type)) {
                JSONObject param_act = new JSONObject();
                param_act.put("activity_id", (Object)data.getString("activity_id"));
                param_act.put("vip_id", (Object)data.getString("vip_id"));
                param_act.put("productList", (Object)data.getJSONArray("productList"));
                dataResponse = this.uiService.getData("/management/activity/mob/checkActivityOrder", new DataRequest().setData(param_act));
                if (dataResponse.getStatus().equals((Object)Status.FAILED)) {
                    return dataResponse;
                }
            }
        } else {
            order.setType("common");
        }
        order.setOrder_remark(order_remark);
        order.setOrder_amount_pay(order_amount_pay);
        order.setOrder_amount(order_amount);
        if (StringUtils.isNotNull((Object)corp_code)) {
            order.setCorp_code(corp_code);
        }
        order.setRecurrence(recurrence);
        order.setTrade_type(trade_type);
        order.setRecurrenceList(recurrenceList);
        order.setOrder_time(current);
        if (StringUtils.isNull((Object)pay_status)) {
            order.setPay_status("0");
        } else {
            order.setPay_status(pay_status);
        }
        if (order.getPay_status().equals("1")) {
            order.setPay_date(current);
        }
        order.setLogisticsList(logistics_info);
        order.setU_uin(u_uin);
        if (StringUtils.isNotNull((Object)order_no)) {
            order.setOrder_no(order_no);
        } else {
            order.setOrder_no("ORD" + TimeUtils.getCurrentTimeInString((SimpleDateFormat)TimeUtils.DATETIME_FORMAT_DATE_NO) + org.apache.commons.lang3.RandomStringUtils.randomAlphanumeric((int)5).toUpperCase());
        }
        order.setExpress_info(express);
        order.setOrder_vip(vip_order);
        order.setOrder_freight(order_freight);
        order.setOrder_num(order_num);
        order.setUser_id(user_id);
        if (StringUtils.isNotNull((Object)setExclusive_user)) {
            order.setExclusive_user(setExclusive_user);
        }
        JSONArray newArray = new JSONArray();
        Double product_amount = 0.0;
        Double product_price = 0.0;
        int product_num = 0;
        for (int i = 0; i < array_product.size(); ++i) {
            JSONObject product = array_product.getJSONObject(i);
            String product_id = product.getString("product_id");
            product_num = product.getIntValue("product_num");
            team_id = product.getString("team_id");
            Query q = new Query();
            q.addCriteria((CriteriaDefinition)Criteria.where((String)"product_id").is((Object)product_id));
            Product productInfo = (Product)this.mongoTemplate.findOne(q, Product.class);
            String sku_id = product.getString("sku_id");
            String sku_code = product.getString("sku_code");
            log.info("-sku_code--" + sku_code);
            if (StringUtils.isNull((Object)sku_code)) {
                Sku sku = (Sku)this.mongoTemplate.findOne(Query.query((CriteriaDefinition)Criteria.where((String)"_id").is((Object)new ObjectId(sku_id))), Sku.class);
                log.info("-sku--" + sku);
                if (null != sku) {
                    sku_code = sku.getOutter_id();
                    product.put("sku_code", (Object)sku.getCode());
                }
            }
            if (StringUtils.isNull((Object)sku_id) && !StringUtils.isNotNull((Object)sku_code)) {
                return new DataResponse().setStatus(Status.FAILED).setCode("-1").setMsg("\u8bf7\u586b\u5199\u5546\u54c1\u6b3e\u53f7\u548c\u989c\u8272\u5c3a\u7801");
            }
            if (productInfo != null) {
                JSONObject object = new JSONObject();
                object.put("product_id", (Object)product_id);
                object.put("product_num", (Object)product_num);
                object.put("sku_id", (Object)sku_id);
                object.put("team_id", (Object)team_id);
                object.put("trade_type", (Object)trade_type);
                if (this.checkStock(object, productInfo)) {
                    dataResponse.setStatus(Status.FAILED).setMsg("\u5546\u54c1\"" + productInfo.getProduct_name() + "\"\u5e93\u5b58\u4e0d\u8db3\uff0c\u8bf7\u79fb\u9664\u8be5\u5546\u54c1\u540e\u91cd\u65b0\u4e0b\u5355\uff01").setId(dataRequest.getId());
                    return dataResponse;
                }
            } else {
                da = new JSONObject();
                da.put("msg", (Object)(product.getString("product_name") + "\u5df2\u88ab\u5220\u9664\uff0c\u8bf7\u91cd\u65b0\u4e0b\u5355"));
                dataResponse.setStatus(Status.FAILED).setCode("0").setId(dataRequest.getId()).setData(da);
                return dataResponse;
            }
            product_amount = product.getDouble("product_amount");
            product_price = product.getDouble("product_price");
            product_num = product.getIntValue("product_num");
            product.remove((Object)"product_amount");
            product.put("product_amount", (Object)product_amount);
            product.remove((Object)"product_num");
            product.put("product_num", (Object)product_num);
            product.remove((Object)"product_price");
            product.put("product_price", (Object)product_price);
            product.put("sku_code", (Object)sku_code);
            log.info("--product-" + product);
            newArray.add((Object)product);
        }
        if (StringUtils.isNotNull((Object)team_id)) {
            JSONObject param_user = new JSONObject();
            param_user.put("user_id", (Object)user_id);
            param_user.put("team_id", (Object)team_id);
            grade_id = this.teamAgent.getData(param_user, "/team/getTeamMemberGrade").getString("grade_id");
            order.setUser_grade_id(grade_id);
        }
        order.setProductList(newArray);
        order.setCreator_id(user_id);
        order.setModifier_id(user_id);
        order.setCreated_date(current);
        order.setModified_date(current);
        order.setPay_info(pay_info);
        order.setIs_active("Y");
        if (data.containsKey((Object)"is_active")) {
            order.setIs_active(data.getString("is_active"));
        }
        if (data.containsKey((Object)"activity_id")) {
            order.setActivity_id(data.getString("activity_id"));
        }
        if (data.containsKey((Object)"record_id")) {
            order.setActivity_join_record_id(data.getString("record_id"));
        }
        order.setOrder_url(this.api_server_domain + "/order/getUrl?order_id=" + order.getOrder_id() + "&url=" + this.weixin_server_order_url);
        if (!"1".equals(pay_status) || !"online".equals(trade_type)) {
            // empty if block
        }
        this.mongoTemplate.insert((Object)order);
        JSONArray product_list = order.getProductList();
        DataRequest dataRequestadjust = new DataRequest();
        JSONObject jsonObjectadjust = new JSONObject();
        jsonObjectadjust.put("order_no", (Object)order.getOrder_no());
        jsonObjectadjust.put("pay_status", (Object)order.getPay_status());
        jsonObjectadjust.put("productList", (Object)product_list);
        jsonObjectadjust.put("user_id", (Object)user_id);
        jsonObjectadjust.put("trade_type", (Object)order.getTrade_type());
        jsonObjectadjust.put("type", (Object)"add");
        dataRequestadjust.setData(jsonObjectadjust);
        this.adjustStock(dataRequestadjust);
        String finalTeam_id = team_id;
        1 order_commission = new /* Unavailable Anonymous Inner Class!! */;
        try {
            Thread t = new Thread((Runnable)order_commission);
            t.start();
        }
        catch (Exception e) {
            log.error("order recurrenceListlogistics_info error:" + e.getLocalizedMessage(), (Throwable)e);
        }
        if (pay_status.equals("1")) {
            BasicDBObject order_query = new BasicDBObject("order_id", (Object)order.getOrder_id());
            BasicDBObject unwind = new BasicDBObject("$unwind", (Object)"$productList");
            BasicDBObject match = new BasicDBObject("$match", (Object)order_query);
            AggregationOutput aggregationOutput = this.mongoTemplate.getCollection("def_order").aggregate((DBObject)unwind, new DBObject[]{match});
            ArrayList<DBObject> list = new ArrayList<DBObject>();
            for (DBObject object : aggregationOutput.results()) {
                object.removeField("_id");
                list.add(object);
            }
            WriteResult writeResult = this.mongoTemplate.getCollection("def_order_detail").insert(list);
            if (StringUtils.isNotNull((Object)team_id)) {
                try {
                    TeamNews news = new TeamNews();
                    news.setNews_type("addOrder");
                    news.setTeam_id(team_id);
                    news.setUser_id(user_id);
                    JSONObject news_obj = JSON.parseObject((String)news.toString());
                    news_obj.put("news_value", (Object)order);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            DataRequest dataRequest1 = new DataRequest();
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("order_id", (Object)order.getOrder_id());
            dataRequest1.setData(jsonObject);
            log.info("--add--\u6d88\u8d39\u53d1\u5238----" + jsonObject);
            DataResponse dataResponse1 = this.couponService.getData("/coupon/orderPaySuccessSendCoupon", dataRequest1);
            log.info("--add--\u6d88\u8d39\u53d1\u8fd4\u56de----" + dataResponse1);
        }
        DataRequest data_save = new DataRequest();
        JSONObject jsonObject_save = new JSONObject();
        jsonObject_save.put("description", (Object)"\u65b0\u589e\u8ba2\u5355");
        jsonObject_save.put("user_id", (Object)user_id);
        jsonObject_save.put("way", (Object)"save");
        jsonObject_save.put("operate_time", (Object)TimeUtils.getCurrentTimeInString((SimpleDateFormat)TimeUtils.DATETIME_FORMAT_DATE));
        jsonObject_save.put("data_new", (Object)order.toString());
        data_save.setData(jsonObject_save);
        da = new JSONObject();
        da.put("id", (Object)order.get_id().toString());
        dataResponse.setStatus(Status.SUCCESS).setCode("0").setId(dataRequest.getId()).setData(da);
        return dataResponse;
    }

    public DataResponse addv4(DataRequest dataRequest) {
        DataResponse dataResponse = new DataResponse();
        String current = TimeUtils.getCurrentTimeInString((SimpleDateFormat)TimeUtils.DATETIME_FORMAT_DATE);
        JSONObject data = dataRequest.getData();
        String user_id = data.getString("user_id");
        String type = data.getString("type");
        String trade_type = StringUtils.isNotNull((Object)data.getString("trade_type")) ? data.getString("trade_type") : "online";
        String order_no = data.getString("order_no");
        String order_remark = data.getString("order_remark");
        String mini_appid = data.getString("mini_appid");
        String corp_code = "";
        if (StringUtils.isNotNull((Object)mini_appid)) {
            Corp corp = (Corp)this.mongoTemplate.findOne(Query.query((CriteriaDefinition)Criteria.where((String)"mini_appid").is((Object)mini_appid)), Corp.class);
            corp_code = corp.getCorp_code();
        }
        if (StringUtils.isNull((Object)mini_appid) && StringUtils.isNotNull((Object)user_id)) {
            User user = (User)this.mongoTemplate.findOne(Query.query((CriteriaDefinition)Criteria.where((String)"user_id").is((Object)user_id)), User.class);
            corp_code = user.getCorp_code();
        }
        JSONObject recurrence = data.getJSONObject("recurrence");
        JSONArray logistics_info = data.getJSONArray("logisticsList");
        JSONObject express = data.getJSONObject("express_info");
        JSONObject pay_info = data.getJSONObject("pay_info");
        String pay_status = "0";
        if (StringUtils.isNotNull((Object)pay_info)) {
            String is_pay;
            String pay = pay_info.getString("pay_way");
            pay_status = pay_info.getString("pay_status");
            if (StringUtils.isNull((Object)pay_status) && "Y".equals(is_pay = pay_info.getString("is_pay"))) {
                pay_status = "1";
            }
            if (!"online".equals(pay)) {
                // empty if block
            }
        }
        JSONObject vip_order = data.getJSONObject("order_vip");
        Double order_freight = NumberUtil.round((double)data.getDouble("order_freight"));
        JSONArray array = data.getJSONArray("productList");
        String team_id = data.getString("team_id");
        if (StringUtils.isNull((Object)team_id)) {
            for (int i = 0; i < array.size(); ++i) {
                team_id = array.getJSONObject(i).getString("team_id");
            }
        }
        String grade_id = "";
        if (StringUtils.isNotNull((Object)team_id)) {
            JSONObject param_user = new JSONObject();
            param_user.put("user_id", (Object)user_id);
            param_user.put("team_id", (Object)team_id);
            grade_id = this.teamAgent.getData(param_user, "/team/getTeamMemberGrade").getString("grade_id");
        }
        JSONArray productList = new JSONArray();
        for (int i = 0; i < array.size(); ++i) {
            JSONObject object = array.getJSONObject(i);
            object.put("num", (Object)object.getInteger("product_num"));
            productList.add((Object)object);
        }
        JSONObject calculateProducts = new JSONObject();
        calculateProducts.put("productInfo", (Object)productList);
        if (StringUtils.isNotNull((Object)vip_order)) {
            calculateProducts.put("vip_id", (Object)vip_order.getString("vip_id"));
        }
        JSONObject result = this.activityAgent.getData(calculateProducts, "/activity/calculateProducts");
        log.info("---\u9a8c\u8bc1\u6ee1\u51cf\u6d3b\u52a8---" + result);
        JSONArray productListActivity = result.getJSONArray("productInfo");
        Double order_amount_pay = 0.0;
        Double order_amount = 0.0;
        int order_num = 0;
        for (int j = 0; j < productListActivity.size(); ++j) {
            JSONObject object = productListActivity.getJSONObject(j);
            object.put("product_amount", (Object)object.getDouble("productsDiscountAmount"));
            order_amount_pay = order_amount_pay + object.getDouble("productsDiscountAmount");
            order_amount = order_amount + object.getDouble("product_price") * object.getDouble("product_num");
            order_num += object.getIntValue("product_num");
        }
        array = this.setOrderDetailProductParentTeam(productListActivity, grade_id);
        JSONArray array_product = this.operateProduct(array, order_amount_pay, order_amount, "", order_freight);
        JSONArray recurrenceList = data.getJSONArray("recurrenceList");
        if (StringUtils.isNotNull((Object)user_id)) {
            Query query_ = new Query();
            query_.addCriteria((CriteriaDefinition)Criteria.where((String)"user_id").is((Object)user_id));
            User user_ = (User)this.mongoTemplate.findOne(query_, User.class);
            if (null == user_) {
                return dataResponse.setStatus(Status.FAILED).setId(dataRequest.getId()).setMsg("\u7528\u6237\u4e0d\u5b58\u5728");
            }
        }
        Vip vip = null;
        Order order = new Order();
        if (StringUtils.isNotNull((Object)user_id) && null != vip_order && !vip_order.isEmpty() && null != (vip = (Vip)this.mongoTemplate.findOne(Query.query((CriteriaDefinition)Criteria.where((String)"vip_id").is((Object)vip_order.getString("vip_id"))), Vip.class)) && null != vip.getUser_id()) {
            order.setExclusive_user(vip.getUser_id());
        }
        if (StringUtils.isNotNull((Object)type)) {
            order.setType(type);
            if ("group".equals(type)) {
                dataResponse = this.disposeGroupOrder(data.getString("activity_id"), data.getString("record_id"), vip_order.getString("vip_id"));
                if (dataResponse.getStatus().equals((Object)Status.FAILED)) {
                    return dataResponse;
                }
                if (dataResponse.getData() != null && dataResponse.getData().containsKey((Object)"id")) {
                    return dataResponse;
                }
            } else if ("seckill".equals(type)) {
                JSONObject param_act = new JSONObject();
                param_act.put("activity_id", (Object)data.getString("activity_id"));
                param_act.put("vip_id", (Object)data.getString("vip_id"));
                param_act.put("productList", (Object)data.getJSONArray("productList"));
                dataResponse = this.uiService.getData("/management/activity/mob/checkActivityOrder", new DataRequest().setData(param_act));
                if (dataResponse.getStatus().equals((Object)Status.FAILED)) {
                    return dataResponse;
                }
            }
        } else {
            order.setType("common");
        }
        String living_id = data.getString("living_id");
        order.setLiving_id(living_id);
        order.setOrder_remark(order_remark);
        order.setActivity_ids(result.getJSONArray("activity_ids"));
        order.setOrder_amount_pay(order_amount_pay);
        order.setOrder_amount(order_amount);
        if (null != result.getDouble("discountAmount") && result.getDouble("discountAmount") > 0.0) {
            order.setActivity_discount_amount(result.getDouble("discountAmount"));
        }
        if (null != result.getJSONArray("activityRuleInfo") && result.getJSONArray("activityRuleInfo").size() > 0) {
            order.setActivityRuleInfo(result.getJSONArray("activityRuleInfo"));
        }
        if (StringUtils.isNotNull((Object)corp_code)) {
            order.setCorp_code(corp_code);
        }
        order.setRecurrence(recurrence);
        order.setTrade_type(trade_type);
        order.setRecurrenceList(recurrenceList);
        order.setOrder_time(current);
        if (StringUtils.isNull((Object)pay_status)) {
            order.setPay_status("0");
        } else {
            order.setPay_status(pay_status);
        }
        if ("1".equals(order.getPay_status())) {
            order.setPay_date(current);
        }
        order.setLogisticsList(logistics_info);
        if (StringUtils.isNotNull((Object)order_no)) {
            order.setOrder_no(order_no);
        } else {
            order.setOrder_no("ORD" + TimeUtils.getCurrentTimeInString((SimpleDateFormat)TimeUtils.DATETIME_FORMAT_DATE_NO) + RandomStringUtils.randomAlphanumeric((int)5).toUpperCase());
        }
        order.setExpress_info(express);
        order.setOrder_vip(vip_order);
        order.setOrder_freight(order_freight);
        order.setOrder_num(order_num);
        order.setUser_id(user_id);
        JSONArray newArray = new JSONArray();
        Double product_amount = 0.0;
        Double product_price = 0.0;
        int product_num = 0;
        for (int i = 0; i < array_product.size(); ++i) {
            JSONObject product = array_product.getJSONObject(i);
            JSONArray array1 = product.getJSONArray("product_image_url");
            String first_image_url = "";
            if (product.containsKey((Object)"first_image_url")) {
                first_image_url = product.getString("first_image_url");
            }
            JSONArray jsonArray = new JSONArray();
            JSONObject image = new JSONObject();
            image.put("image_url", (Object)first_image_url);
            if (StringUtils.isNotNull((Object)first_image_url)) {
                jsonArray.add((Object)image);
            }
            jsonArray.addAll((Collection)array1);
            product.put("product_image_url", (Object)jsonArray);
            log.info("-\u9a8c\u8bc1-product-" + product);
            String product_id = product.getString("product_id");
            Product productGroup = (Product)this.mongoTemplate.findOne(Query.query((CriteriaDefinition)Criteria.where((String)"product_id").is((Object)product_id)), Product.class);
            String is_group = product.getString("is_group");
            product_num = product.getIntValue("product_num");
            if (!"Y".equals(is_group)) {
                if (StringUtils.isNull((Object)team_id)) {
                    team_id = product.getString("team_id");
                }
                Query q = new Query();
                q.addCriteria((CriteriaDefinition)Criteria.where((String)"product_id").is((Object)product_id));
                Product productInfo = (Product)this.mongoTemplate.findOne(q, Product.class);
                if (productInfo.getOn_sale() != 1) {
                    dataResponse.setStatus(Status.FAILED).setMsg("\u5546\u54c1\"" + productInfo.getProduct_name() + "\"\u5df2\u4e0b\u67b6\u6216\u672a\u4e0a\u67b6\uff01").setId(dataRequest.getId());
                    return dataResponse;
                }
                String sku_id = product.getString("sku_id");
                String sku_code = product.getString("sku_code");
                log.info("-sku_code--" + sku_code);
                if (StringUtils.isNull((Object)sku_code)) {
                    Sku sku = (Sku)this.mongoTemplate.findOne(Query.query((CriteriaDefinition)Criteria.where((String)"_id").is((Object)new ObjectId(sku_id))), Sku.class);
                    log.info("-sku--" + sku);
                    if (null != sku) {
                        sku_code = sku.getOutter_id();
                        product.put("sku_code", (Object)sku.getCode());
                    }
                }
                if (productInfo != null) {
                    JSONObject object = new JSONObject();
                    object.put("product_id", (Object)product_id);
                    object.put("product_num", (Object)product_num);
                    object.put("sku_id", (Object)sku_id);
                    object.put("team_id", (Object)team_id);
                    object.put("trade_type", (Object)trade_type);
                    if (this.checkStock(object, productInfo)) {
                        dataResponse.setStatus(Status.FAILED).setMsg("\u5546\u54c1\"" + productInfo.getProduct_name() + "\"\u5e93\u5b58\u4e0d\u8db3\uff0c\u8bf7\u79fb\u9664\u8be5\u5546\u54c1\u540e\u91cd\u65b0\u4e0b\u5355\uff01").setId(dataRequest.getId());
                        return dataResponse;
                    }
                    product_amount = product.getDouble("product_amount");
                    product_price = product.getDouble("product_price");
                    product_num = product.getIntValue("product_num");
                    product.remove((Object)"product_amount");
                    product.put("product_amount", (Object)product_amount);
                    product.remove((Object)"product_num");
                    product.put("product_num", (Object)product_num);
                    product.remove((Object)"product_price");
                    product.put("product_price", (Object)product_price);
                    product.put("sku_code", (Object)sku_code);
                    log.info("--product-" + product);
                    newArray.add((Object)product);
                    continue;
                }
                JSONObject da = new JSONObject();
                da.put("msg", (Object)(product.getString("product_name") + "\u5df2\u88ab\u5220\u9664\uff0c\u8bf7\u91cd\u65b0\u4e0b\u5355"));
                dataResponse.setStatus(Status.FAILED).setCode("0").setId(dataRequest.getId()).setData(da);
                return dataResponse;
            }
            if (StringUtils.isNotNull((Object)productGroup.getStock_num())) {
                String stock_num = productGroup.getStock_num();
                Integer qty = productGroup.getQty();
                Integer stock = Integer.valueOf(stock_num);
                if (null == qty) {
                    qty = 0;
                }
                if (null != qty && qty + product_num > stock) {
                    dataResponse.setStatus(Status.FAILED).setMsg("\u7ec4\u5408\u5546\u54c1\"" + productGroup.getProduct_name() + "\"\u5e93\u5b58\u4e0d\u8db3\uff0c\u8bf7\u79fb\u9664\u8be5\u5546\u54c1\u540e\u91cd\u65b0\u4e0b\u5355\uff01").setId(dataRequest.getId());
                    return dataResponse;
                }
            }
            JSONArray select_group_info = product.getJSONArray("select_group_info");
            for (int j = 0; j < select_group_info.size(); ++j) {
                JSONObject jsonObject = select_group_info.getJSONObject(j);
                String sku_id = jsonObject.getJSONObject("select_sku").getString("sku_id");
                Integer num = jsonObject.getJSONObject("select_sku").getInteger("num");
                JSONObject object = new JSONObject();
                object.put("product_id", (Object)jsonObject.getString("product_id"));
                object.put("product_num", (Object)(product_num * num));
                object.put("sku_id", (Object)sku_id);
                object.put("team_id", (Object)team_id);
                object.put("trade_type", (Object)trade_type);
                Query q = new Query();
                q.addCriteria((CriteriaDefinition)Criteria.where((String)"product_id").is((Object)jsonObject.getString("product_id")));
                Product productInfo = (Product)this.mongoTemplate.findOne(q, Product.class);
                if (productInfo.getOn_sale() != 1) {
                    dataResponse.setStatus(Status.FAILED).setMsg("\u7ec4\u5408\u5546\u54c1\u4e2d\"" + productInfo.getProduct_name() + "\"\u5df2\u4e0b\u67b6\u6216\u672a\u4e0a\u67b6\uff01").setId(dataRequest.getId());
                    return dataResponse;
                }
                if (!this.checkStock(object, productInfo)) continue;
                dataResponse.setStatus(Status.FAILED).setMsg("\u7ec4\u5408\u5546\u54c1\u4e2d\"" + productInfo.getProduct_name() + "\"\u5e93\u5b58\u4e0d\u8db3\uff0c\u8bf7\u79fb\u9664\u8be5\u5546\u54c1\u540e\u91cd\u65b0\u4e0b\u5355\uff01").setId(dataRequest.getId());
                return dataResponse;
            }
            newArray.add((Object)product);
        }
        if (StringUtils.isNotNull((Object)team_id)) {
            JSONObject param_user = new JSONObject();
            param_user.put("user_id", (Object)user_id);
            param_user.put("team_id", (Object)team_id);
            grade_id = this.teamAgent.getData(param_user, "/team/getTeamMemberGrade").getString("grade_id");
            order.setUser_grade_id(grade_id);
        }
        order.setProductList(newArray);
        order.setCreator_id(user_id);
        order.setModifier_id(user_id);
        order.setCreated_date(current);
        order.setModified_date(current);
        order.setPay_info(pay_info);
        order.setIs_active("Y");
        if (data.containsKey((Object)"is_active")) {
            order.setIs_active(data.getString("is_active"));
        }
        if (data.containsKey((Object)"activity_id")) {
            order.setActivity_id(data.getString("activity_id"));
        }
        if (data.containsKey((Object)"record_id")) {
            order.setActivity_join_record_id(data.getString("record_id"));
        }
        order.setOrder_url(this.api_server_domain + "/order/getUrl?order_id=" + order.getOrder_id() + "&url=" + this.weixin_server_order_url);
        if (!"1".equals(pay_status) || !"online".equals(trade_type)) {
            // empty if block
        }
        this.mongoTemplate.insert((Object)order);
        JSONArray product_list = order.getProductList();
        DataRequest dataRequestadjust = new DataRequest();
        JSONObject jsonObjectadjust = new JSONObject();
        jsonObjectadjust.put("order_no", (Object)order.getOrder_no());
        jsonObjectadjust.put("pay_status", (Object)"0");
        jsonObjectadjust.put("productList", (Object)product_list);
        jsonObjectadjust.put("user_id", (Object)user_id);
        jsonObjectadjust.put("trade_type", (Object)order.getTrade_type());
        jsonObjectadjust.put("type", (Object)"add");
        dataRequestadjust.setData(jsonObjectadjust);
        this.adjustStock(dataRequestadjust);
        String finalTeam_id = team_id;
        2 order_commission = new /* Unavailable Anonymous Inner Class!! */;
        try {
            Thread t = new Thread((Runnable)order_commission);
            t.start();
        }
        catch (Exception e) {
            log.error("order recurrenceListlogistics_info error:" + e.getLocalizedMessage(), (Throwable)e);
        }
        if (pay_status.equals("1")) {
            BasicDBObject order_query = new BasicDBObject("order_id", (Object)order.getOrder_id());
            BasicDBObject unwind = new BasicDBObject("$unwind", (Object)"$productList");
            BasicDBObject match = new BasicDBObject("$match", (Object)order_query);
            AggregationOutput aggregationOutput = this.mongoTemplate.getCollection("def_order").aggregate((DBObject)unwind, new DBObject[]{match});
            ArrayList<DBObject> list = new ArrayList<DBObject>();
            for (DBObject object : aggregationOutput.results()) {
                object.removeField("_id");
                list.add(object);
            }
            WriteResult writeResult = this.mongoTemplate.getCollection("def_order_detail").insert(list);
            if (StringUtils.isNotNull((Object)team_id)) {
                try {
                    TeamNews news = new TeamNews();
                    news.setNews_type("addOrder");
                    news.setTeam_id(team_id);
                    news.setUser_id(user_id);
                    JSONObject news_obj = JSON.parseObject((String)news.toString());
                    news_obj.put("news_value", (Object)order);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            DataRequest dataRequest1 = new DataRequest();
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("order_id", (Object)order.getOrder_id());
            dataRequest1.setData(jsonObject);
            log.info("--add--\u6d88\u8d39\u53d1\u5238----" + jsonObject);
            DataResponse dataResponse1 = this.couponService.getData("/coupon/orderPaySuccessSendCoupon", dataRequest1);
            log.info("--add--\u6d88\u8d39\u53d1\u8fd4\u56de----" + dataResponse1);
        }
        DataRequest data_save = new DataRequest();
        JSONObject jsonObject_save = new JSONObject();
        jsonObject_save.put("description", (Object)"\u65b0\u589e\u8ba2\u5355");
        jsonObject_save.put("user_id", (Object)user_id);
        jsonObject_save.put("way", (Object)"save");
        jsonObject_save.put("operate_time", (Object)TimeUtils.getCurrentTimeInString((SimpleDateFormat)TimeUtils.DATETIME_FORMAT_DATE));
        jsonObject_save.put("data_new", (Object)order.toString());
        data_save.setData(jsonObject_save);
        JSONObject da = new JSONObject();
        da.put("id", (Object)order.get_id().toString());
        dataResponse.setStatus(Status.SUCCESS).setCode("0").setId(dataRequest.getId()).setData(da);
        return dataResponse;
    }

    public DataResponse checkActivityStock(JSONArray array, String vip_id) {
        JSONObject dataRequest = new JSONObject();
        dataRequest.put("vip_id", (Object)vip_id);
        dataRequest.put("productInfo", (Object)array);
        DataRequest dataRequest1 = new DataRequest();
        dataRequest1.setData(dataRequest);
        return this.activityAgent.callRest(dataRequest1, "/seckill/activity/checkVipByLimitBuy");
    }

    @CacheEvict(value={"order"}, allEntries=true)
    public DataResponse addv2(DataRequest dataRequest) {
        DataResponse dataResponse = new DataResponse();
        String current = TimeUtils.getCurrentTimeInString((SimpleDateFormat)TimeUtils.DATETIME_FORMAT_DATE);
        JSONObject data = dataRequest.getData();
        log.info("--add2----" + data);
        String user_id = data.getString("user_id");
        String store_id = "";
        String order_type = data.getString("order_type");
        String order_pay_status = data.getString("order_pay_status");
        String type = data.getString("type");
        String is_create = data.getString("is_create");
        String share_open_id = data.getString("share_open_id");
        String order_no = data.getString("order_no");
        String source = data.getString("source");
        String vipDiscount = data.getString("vipDiscount");
        String order_remark = data.getString("order_remark");
        Double order_amount_pay = NumberUtil.round((double)data.getDouble("order_amount_pay"));
        Double order_amount = NumberUtil.round((double)data.getDouble("order_amount"));
        String living_id = data.getString("living_id");
        String living_theme = data.getString("living_theme");
        String living_start = data.getString("living_start");
        String order_source = data.getString("order_source");
        String share_guide = data.getString("share_guide");
        log.info("ZJY TEST living_id +++++" + living_id);
        log.info("\u521b\u5efa\u8ba2\u5355===================\u300b" + current);
        if (StringUtils.isNotNull((Object)user_id)) {
            BasicDBObject match = new BasicDBObject("is_active", (Object)"Y");
            BasicDBObject matchB = new BasicDBObject("is_active", (Object)"N");
            match.put("user_id", (Object)user_id);
            matchB.put("user_id", (Object)user_id);
            DBObject tempUser = this.mongoTemplate.getCollection("def_user").findOne((DBObject)match);
            DBObject noUseUser = this.mongoTemplate.getCollection("def_user").findOne((DBObject)matchB);
            if (StringUtils.isNotNull((Object)tempUser)) {
                String string = store_id = tempUser.get("store_id") != null ? tempUser.get("store_id").toString() : "";
            }
            if (StringUtils.isNotNull((Object)noUseUser)) {
                String corp_code;
                String string = corp_code = noUseUser.get("corp_code") != null ? noUseUser.get("corp_code").toString() : "";
                if ("C10041".equals(corp_code) || "C10042".equals(corp_code)) {
                    String string2 = store_id = noUseUser.get("store_id") != null ? noUseUser.get("store_id").toString() : "";
                    if (StringUtils.isNotNull((Object)store_id)) {
                        BasicDBObject storeMatch = new BasicDBObject("store_id", (Object)store_id);
                        storeMatch.put("status", (Object)"C");
                        DBObject tempStore = this.mongoTemplate.getCollection("def_store").findOne((DBObject)storeMatch);
                        if (StringUtils.isNotNull((Object)tempStore)) {
                            user_id = "";
                            store_id = "";
                        } else {
                            BasicDBObject storeManagerQuery = new BasicDBObject("is_active", (Object)"Y");
                            storeManagerQuery.put("role_type", (Object)"R2000");
                            storeManagerQuery.put("store_id", (Object)store_id);
                            DBObject storeManager = this.mongoTemplate.getCollection("def_user").findOne((DBObject)storeManagerQuery);
                            if (StringUtils.isNotNull((Object)storeManager)) {
                                user_id = storeManager.get("user_id") != null ? storeManager.get("user_id").toString() : "";
                            }
                        }
                    } else {
                        user_id = "";
                        store_id = "";
                    }
                }
            }
        }
        JSONObject recurrence = data.getJSONObject("recurrence");
        JSONArray logistics_info = data.getJSONArray("logisticsList");
        JSONObject express = data.getJSONObject("express_info");
        JSONObject pay_info = data.getJSONObject("pay_info");
        String is_online_pay = "Y";
        String pay_status = "0";
        if (StringUtils.isNotNull((Object)pay_info)) {
            String is_pay;
            String pay = pay_info.getString("pay_way");
            pay_status = pay_info.getString("pay_status");
            if (StringUtils.isNull((Object)pay_status) && "Y".equals(is_pay = pay_info.getString("is_pay"))) {
                pay_status = "1";
            }
            if (!"online".equals(pay)) {
                is_online_pay = "N";
            }
        }
        String trade_type = data.getString("trade_type");
        JSONObject vip_order = data.getJSONObject("order_vip");
        if (StringUtils.isNotNull((Object)order_type)) {
            if (vip_order.size() == 0) {
                return new DataResponse().setMsg("\u8bf7\u9009\u62e9\u6d88\u8d39\u4f1a\u5458").setStatus(Status.FAILED);
            }
        } else {
            if (null == vip_order) {
                return new DataResponse().setMsg("\u8bf7\u9009\u62e9\u6d88\u8d39\u4f1a\u5458").setStatus(Status.FAILED);
            }
            if (vip_order.size() == 0) {
                return new DataResponse().setMsg("\u8bf7\u9009\u62e9\u6d88\u8d39\u4f1a\u5458").setStatus(Status.FAILED);
            }
        }
        Vip vip = null;
        String vip_id = "";
        String vip_name = "";
        String corp_code = "";
        if (StringUtils.isNotNull((Object)vip_order)) {
            vip_id = vip_order.getString("vip_id");
            vip_name = vip_order.getString("vip_name");
            vip = (Vip)this.mongoTemplate.findOne(Query.query((CriteriaDefinition)Criteria.where((String)"vip_id").is((Object)vip_id)), Vip.class);
            corp_code = vip_order.getString("corp_code");
            if (StringUtils.isNull((Object)vip_name) && null != vip) {
                vip_name = vip.getVip_name() != null ? vip_name : vip.getNick_name();
            }
            vip_order.put("vip_name", (Object)vip_name);
        }
        Double order_freight = NumberUtil.round((double)data.getDouble("order_freight"));
        int order_num = data.getIntValue("order_num");
        JSONArray array = data.getJSONArray("productList");
        JSONArray pArray = new JSONArray();
        String team_id = "";
        for (int i = 0; i < array.size(); ++i) {
            JSONObject product = array.getJSONObject(i);
            String product_id = product.getString("product_id");
            String sku_id = product.getString("sku_id");
            Integer product_num = product.getIntValue("product_num");
            team_id = product.getString("team_id");
            if (StringUtils.isNotNull((Object)team_id)) {
                team_id = team_id.trim();
            }
            JSONObject object = new JSONObject();
            object.put("product_id", (Object)product_id);
            object.put("product_num", (Object)product_num);
            object.put("num", (Object)product_num);
            object.put("sku_id", (Object)sku_id);
            object.put("team_id", (Object)team_id);
            object.put("is_online_pay", (Object)is_online_pay);
            object.put("trade_type", (Object)trade_type);
            pArray.add((Object)object);
        }
        String grade_id = "";
        if (StringUtils.isNotNull((Object)team_id)) {
            JSONObject param_user = new JSONObject();
            param_user.put("user_id", (Object)user_id);
            param_user.put("team_id", (Object)team_id);
            grade_id = this.teamAgent.getData(param_user, "/team/getTeamMemberGrade").getString("grade_id");
        }
        array = this.setOrderDetailProductParentTeam(array, grade_id);
        JSONArray array_product = this.operateProduct(array, order_amount_pay, order_amount, "", order_freight);
        JSONArray recurrenceList = data.getJSONArray("recurrenceList");
        Order order = new Order();
        if (StringUtils.isNotNull((Object)type)) {
            order.setType(type);
            if ("group".equals(type)) {
                dataResponse = this.disposeGroupOrder(data.getString("activity_id"), data.getString("record_id"), vip_order.getString("vip_id"));
                if (dataResponse.getStatus().equals((Object)Status.FAILED)) {
                    return dataResponse;
                }
                if (dataResponse.getData() != null && dataResponse.getData().containsKey((Object)"id")) {
                    return dataResponse;
                }
            } else if ("seckill".equals(type)) {
                JSONObject param_act = new JSONObject();
                param_act.put("activity_id", (Object)data.getString("activity_id"));
                param_act.put("vip_id", (Object)vip_order.getString("vip_id"));
                param_act.put("productList", (Object)data.getJSONArray("productList"));
                dataResponse = this.uiService.getData("/management/activity/mob/checkActivityOrder", new DataRequest().setData(param_act));
                if (dataResponse.getStatus().equals((Object)Status.FAILED)) {
                    return dataResponse;
                }
            }
        } else {
            order.setType("common");
        }
        order.setOrder_remark(order_remark);
        order.setActivity_ids(data.getJSONArray("activity_ids"));
        order.setOrder_amount_pay(order_amount_pay);
        order.setOrder_amount(order_amount);
        if (null != data.getDouble("activity_discount_amount") && data.getDouble("activity_discount_amount") > 0.0) {
            order.setActivity_discount_amount(data.getDouble("activity_discount_amount"));
        }
        if (null != data.getJSONArray("activityRuleInfo") && data.getJSONArray("activityRuleInfo").size() > 0) {
            order.setActivityRuleInfo(data.getJSONArray("activityRuleInfo"));
        }
        order.setSource(source);
        if (StringUtils.isNotNull((Object)corp_code)) {
            order.setCorp_code(corp_code);
        }
        order.setRecurrence(recurrence);
        order.setRecurrenceList(recurrenceList);
        order.setOrder_time(current);
        if (StringUtils.isNull((Object)pay_status)) {
            order.setPay_status("0");
        } else {
            order.setPay_status(pay_status);
        }
        if (order.getPay_status().equals("1")) {
            order.setPay_date(current);
        }
        order.setLogisticsList(logistics_info);
        if (StringUtils.isNotNull((Object)order_no)) {
            order.setOrder_no(order_no);
        } else {
            order.setOrder_no("ORD" + TimeUtils.getCurrentTimeInString((SimpleDateFormat)TimeUtils.DATETIME_FORMAT_DATE_NO) + org.apache.commons.lang3.RandomStringUtils.randomAlphanumeric((int)5).toUpperCase());
        }
        order_no = order.getOrder_no();
        if (StringUtils.isNull((Object)trade_type)) {
            trade_type = "Y".equals(is_online_pay) ? "online" : "offline";
        }
        if ("0".equals(order_pay_status)) {
            order.setOrder_pay_status(order_pay_status);
        } else {
            order.setOrder_pay_status("1");
        }
        order.setExpress_info(express);
        order.setOrder_vip(vip_order);
        order.setOrder_freight(order_freight);
        order.setOrder_num(order_num);
        order.setUser_id(user_id);
        order.setShare_open_id(share_open_id);
        JSONArray newArray = new JSONArray();
        Double product_amount = 0.0;
        Double product_price = 0.0;
        int product_num = 0;
        for (int i = 0; i < array_product.size(); ++i) {
            JSONObject product = array_product.getJSONObject(i);
            String product_id = product.getString("product_id");
            String sku_id = product.getString("sku_id");
            product_num = product.getIntValue("product_num");
            team_id = product.getString("team_id");
            Query q = new Query();
            q.addCriteria((CriteriaDefinition)Criteria.where((String)"product_id").is((Object)product_id));
            Product productInfo = (Product)this.mongoTemplate.findOne(q, Product.class);
            if (StringUtils.isNull((Object)sku_id)) {
                sku_id = this.getProductSkuId(product_id);
            }
            if (StringUtils.isNotNull((Object)sku_id)) {
                product.put("sku_id", (Object)sku_id);
            }
            if (productInfo != null) {
                JSONObject object = new JSONObject();
                object.put("product_id", (Object)product_id);
                object.put("product_num", (Object)product_num);
                object.put("sku_id", (Object)sku_id);
                object.put("team_id", (Object)team_id);
                object.put("is_online_pay", (Object)is_online_pay);
                object.put("trade_type", (Object)trade_type);
                if (this.checkStock(object, productInfo)) {
                    dataResponse.setStatus(Status.FAILED).setMsg("\u5546\u54c1\"" + productInfo.getProduct_name() + "\"\u5e93\u5b58\u4e0d\u8db3\uff0c\u8bf7\u79fb\u9664\u8be5\u5546\u54c1\u540e\u91cd\u65b0\u4e0b\u5355\uff01").setId(dataRequest.getId());
                    return dataResponse;
                }
            } else {
                JSONObject da = new JSONObject();
                da.put("msg", (Object)(product.getString("product_name") + "\u5df2\u88ab\u5220\u9664\uff0c\u8bf7\u91cd\u65b0\u4e0b\u5355"));
                dataResponse.setStatus(Status.FAILED).setCode("0").setId(dataRequest.getId()).setData(da);
                return dataResponse;
            }
            product_amount = product.getDouble("product_amount");
            product_price = product.getDouble("product_price");
            product_num = product.getIntValue("product_num");
            product.remove((Object)"product_amount");
            product.put("product_amount", (Object)product_amount);
            product.remove((Object)"product_num");
            product.put("product_num", (Object)product_num);
            product.remove((Object)"product_price");
            product.put("product_price", (Object)product_price);
            product.put("total_product_price", (Object)(product_price * (double)product_num));
            product.put("productShipStatus", (Object)"0");
            newArray.add((Object)product);
        }
        if (StringUtils.isNotNull((Object)team_id)) {
            JSONObject param_user = new JSONObject();
            param_user.put("user_id", (Object)user_id);
            param_user.put("team_id", (Object)team_id);
            grade_id = this.teamAgent.getData(param_user, "/team/getTeamMemberGrade").getString("grade_id");
            order.setUser_grade_id(grade_id);
        }
        order.setProductList(newArray);
        order.setCreator_id(user_id);
        order.setModifier_id(user_id);
        order.setCreated_date(current);
        order.setModified_date(current);
        order.setPay_info(pay_info);
        order.setIs_active("Y");
        order.setShipStatus("0");
        if (data.containsKey((Object)"is_active")) {
            order.setIs_active(data.getString("is_active"));
        }
        if (data.containsKey((Object)"exclusive_user")) {
            order.setExclusive_user(data.getString("exclusive_user"));
        }
        if (data.containsKey((Object)"activity_id")) {
            order.setActivity_id(data.getString("activity_id"));
        }
        if (data.containsKey((Object)"record_id")) {
            order.setActivity_join_record_id(data.getString("record_id"));
        }
        order.setIs_online_pay(is_online_pay);
        order.setTrade_type(trade_type);
        if (StringUtils.isNotNull((Object)data.getString("mini_appid"))) {
            order.setMini_appid(data.getString("mini_appid"));
        }
        order.setOrder_url(this.api_server_domain + "/order/getUrl?order_id=" + order.getOrder_id() + "&url=" + this.weixin_server_order_url);
        if ("1".equals(pay_status) && "N".equals(is_online_pay) && vip != null && StringUtils.isNull((Object)vip.getVip_phone())) {
            return dataResponse.setStatus(Status.FAILED).setCode("-1").setId(dataRequest.getId()).setMsg("\u8bf7\u5148\u7ef4\u62a4\u4f1a\u5458\u624b\u673a\u53f7");
        }
        if ("Y".equals(data.getString("is_birthday_discount"))) {
            order.setIs_birthday_discount("Y");
            String now = TimeUtils.getCurrentTimeInString((SimpleDateFormat)TimeUtils.DATETIME_FORMAT_DATE);
            data.put("created_date", (Object)now);
            data.put("is_birthday_discount", (Object)"Y");
            data.put("is_success_used", (Object)"N");
            data.put("is_real_pay", (Object)"N");
            data.put("order_no", (Object)order_no);
            data.put("is_active", (Object)"N");
            this.mongoTemplate.insert((Object)data, "def_birthday_order");
        }
        log.info("\u521b\u5efa\u8ba2\u5355\u8e66\u7802\u5361\u62c9\u5361=====================================\u300b");
        order.setStore_id(store_id);
        order.setLiving_id(living_id);
        order.setLiving_start(living_start);
        order.setLiving_theme(living_theme);
        order.setShare_guide(share_guide);
        order.setOrder_source(order_source);
        log.info("ZJY TEST order ++++" + order);
        this.mongoTemplate.insert((Object)order);
        if ("Y".equals(data.getString("is_birthday_discount"))) {
            Query query = new Query((CriteriaDefinition)Criteria.where((String)"order_no").is((Object)order_no));
            Update update = new Update();
            update.set("vipDiscount", (Object)vipDiscount);
            this.mongoTemplate.updateFirst(query, update, "def_order");
        }
        String finalTeam_id = team_id;
        3 order_commission = new /* Unavailable Anonymous Inner Class!! */;
        try {
            Thread t = new Thread((Runnable)order_commission);
            t.start();
        }
        catch (Exception e) {
            log.error("order recurrenceListlogistics_info error:" + e.getLocalizedMessage(), (Throwable)e);
        }
        if (pay_status.equals("1")) {
            BasicDBObject order_query = new BasicDBObject("order_id", (Object)order.getOrder_id());
            BasicDBObject unwind = new BasicDBObject("$unwind", (Object)"$productList");
            BasicDBObject match = new BasicDBObject("$match", (Object)order_query);
            AggregationOutput aggregationOutput = this.mongoTemplate.getCollection("def_order").aggregate((DBObject)unwind, new DBObject[]{match});
            ArrayList<DBObject> list = new ArrayList<DBObject>();
            for (DBObject object : aggregationOutput.results()) {
                object.removeField("_id");
                list.add(object);
            }
            WriteResult writeResult = this.mongoTemplate.getCollection("def_order_detail").insert(list);
            if (StringUtils.isNotNull((Object)team_id)) {
                try {
                    TeamNews news = new TeamNews();
                    news.setNews_type("addOrder");
                    news.setTeam_id(team_id);
                    news.setUser_id(user_id);
                    JSONObject news_obj = JSON.parseObject((String)news.toString());
                    news_obj.put("news_value", (Object)order);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            DataRequest dataRequest1 = new DataRequest();
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("order_id", (Object)order.getOrder_id());
            dataRequest1.setData(jsonObject);
            log.info("--add--\u6d88\u8d39\u53d1\u5238----" + jsonObject);
            DataResponse dataResponse1 = this.couponService.getData("/coupon/orderPaySuccessSendCoupon", dataRequest1);
            log.info("--add--\u6d88\u8d39\u53d1\u8fd4\u56de----" + dataResponse1);
            4 createOfflineCreate = new /* Unavailable Anonymous Inner Class!! */;
            try {
                Thread t = new Thread((Runnable)createOfflineCreate);
                t.start();
            }
            catch (Exception e) {
                log.error("set message error:" + e.getLocalizedMessage(), (Throwable)e);
            }
        }
        DataRequest data_save = new DataRequest();
        JSONObject jsonObject_save = new JSONObject();
        jsonObject_save.put("description", (Object)"\u65b0\u589e\u8ba2\u5355");
        jsonObject_save.put("user_id", (Object)user_id);
        jsonObject_save.put("way", (Object)"save");
        jsonObject_save.put("operate_time", (Object)TimeUtils.getCurrentTimeInString((SimpleDateFormat)TimeUtils.DATETIME_FORMAT_DATE));
        jsonObject_save.put("data_new", (Object)order.toString());
        data_save.setData(jsonObject_save);
        JSONObject da = new JSONObject();
        da.put("id", (Object)order.get_id().toString());
        dataResponse.setStatus(Status.SUCCESS).setCode("0").setId(dataRequest.getId()).setData(da);
        return dataResponse;
    }

    public void insertRemind(DataRequest dataRequest, String product_id, String team_id) {
        JSONObject object = dataRequest.getData();
        JSONArray array = dataRequest.getData().getJSONArray("recurrenceList");
        String order_time = object.getString("order_time");
        String user_id = object.getString("user_id");
        JSONObject vip_order = object.getJSONObject("order_vip");
        JSONArray recurrenceList = new JSONArray();
        for (int i = 0; i < array.size(); ++i) {
            JSONObject jsonObject_recurrence = array.getJSONObject(i);
            jsonObject_recurrence.put("order_time", (Object)order_time);
            jsonObject_recurrence.put("cycle", (Object)"1");
            Memorandum memorandum = new Memorandum();
            if (StringUtils.isNotNull((Object)team_id)) {
                memorandum.setTeam_id(team_id);
            }
            memorandum.setContent(jsonObject_recurrence.getString("remind_content"));
            String start_time = DateSwitchUtil.toString((LocalDateTime)MongodbUtil.getStartTime((JSONObject)jsonObject_recurrence));
            jsonObject_recurrence.put("start_time", (Object)start_time);
            memorandum.setRemind_time(start_time);
            JSONArray jsonArray = new JSONArray();
            jsonArray.add((Object)vip_order);
            memorandum.set_id(new ObjectId());
            memorandum.setUser_id(user_id);
            memorandum.setIs_active("Y");
            memorandum.setCreator_id(user_id);
            memorandum.setCreated_date(TimeUtils.getCurrentTimeInString((SimpleDateFormat)TimeUtils.DATETIME_FORMAT_DATE));
            memorandum.setModifier_id(user_id);
            memorandum.setModified_date(memorandum.getCreated_date());
            memorandum.setVipList(jsonArray);
            memorandum.setClass_name("kr.weitao.weitaokr.task.vip.vipremind.VipRemindJob");
            String start_time_str = jsonObject_recurrence.getString("start_time");
            if (StringUtils.isNull((Object)start_time_str)) {
                start_time_str = DateSwitchUtil.getCurrentDate();
                jsonObject_recurrence.put("start_time", (Object)start_time_str);
            }
            jsonObject_recurrence.put("end_time", (Object)start_time);
            String cron = MongodbUtil.cron_expression((JSONObject)jsonObject_recurrence);
            jsonObject_recurrence.put("cron", (Object)cron);
            memorandum.setRecurrence(jsonObject_recurrence);
            log.info("create begin....");
            this.mongoTemplate.save((Object)memorandum);
            log.info("create end...");
            QueueParam qp = new QueueParam();
            qp.set_id((Object)new ObjectId());
            qp.setUser_id(memorandum.getUser_id());
            qp.setCreator_id(user_id);
            qp.setCreated_date(memorandum.getCreated_date());
            qp.setModifier_id(user_id);
            qp.setModified_date(memorandum.getModified_date());
            qp.setIs_active("Y");
            qp.setName("_id");
            qp.setValue(memorandum.get_id().toString());
            qp.setQueue_item_id(memorandum.get_id().toString());
            this.mongoTemplate.save((Object)qp);
            String str = memorandum.toString();
            log.info("str:" + str);
            this.jobService.addJob(JSON.parseObject((String)str));
            jsonObject_recurrence.put("remind_id", (Object)memorandum.get_id().toString());
            recurrenceList.add((Object)jsonObject_recurrence);
        }
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"order_id").is((Object)product_id));
        Update update = new Update();
        update.set("recurrenceList", (Object)recurrenceList);
        this.mongoTemplate.upsert(query, update, Order.class);
    }

    public void updateOrderRemind(DataRequest dataRequest, String order_id) {
        JSONObject jsonObject = dataRequest.getData();
        JSONArray array = jsonObject.getJSONArray("recurrenceList");
        String order_time = jsonObject.getString("order_time");
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"order_id").is((Object)order_id));
        Order order = (Order)this.mongoTemplate.findOne(query, Order.class);
        if (StringUtils.isNull((Object)order_time)) {
            order_time = order.getOrder_time();
        }
        String user_id = order.getUser_id();
        JSONObject vip_order = order.getOrder_vip();
        JSONArray recurrenceList = new JSONArray();
        for (int i = 0; i < array.size(); ++i) {
            JSONObject jsonObject_recurrence = array.getJSONObject(i);
            String remind_id = jsonObject_recurrence.getString("remind_id");
            if (StringUtils.isNotNull((Object)remind_id)) {
                JSONObject object = new JSONObject();
                object.put("user_id", (Object)user_id);
                object.put("id", (Object)remind_id);
                this.jobService.removeJob(object);
                Query query_remind = new Query();
                query_remind.addCriteria((CriteriaDefinition)Criteria.where((String)"_id").is((Object)new ObjectId(remind_id)));
                this.mongoTemplate.remove(query_remind, Memorandum.class);
            }
            jsonObject_recurrence.put("order_time", (Object)order_time);
            jsonObject_recurrence.put("cycle", (Object)"1");
            Memorandum memorandum = new Memorandum();
            memorandum.setContent(jsonObject_recurrence.getString("remind_content"));
            String start_time = DateSwitchUtil.toString((LocalDateTime)MongodbUtil.getStartTime((JSONObject)jsonObject_recurrence));
            jsonObject_recurrence.put("start_time", (Object)start_time);
            memorandum.setRemind_time(start_time);
            JSONArray jsonArray = new JSONArray();
            jsonArray.add((Object)vip_order);
            memorandum.set_id(new ObjectId());
            memorandum.setUser_id(user_id);
            memorandum.setIs_active("Y");
            memorandum.setCreator_id(user_id);
            memorandum.setCreated_date(TimeUtils.getCurrentTimeInString((SimpleDateFormat)TimeUtils.DATETIME_FORMAT_DATE));
            memorandum.setModifier_id(user_id);
            memorandum.setModified_date(memorandum.getCreated_date());
            memorandum.setVipList(jsonArray);
            memorandum.setClass_name("kr.weitao.weitaokr.task.vip.vipremind.VipRemindJob");
            String start_time_str = jsonObject_recurrence.getString("start_time");
            if (StringUtils.isNull((Object)start_time_str)) {
                start_time_str = DateSwitchUtil.getCurrentDate();
                jsonObject_recurrence.put("start_time", (Object)start_time_str);
            }
            jsonObject_recurrence.put("end_time", (Object)start_time);
            String cron = MongodbUtil.cron_expression((JSONObject)jsonObject_recurrence);
            jsonObject_recurrence.put("cron", (Object)cron);
            memorandum.setRecurrence(jsonObject_recurrence);
            log.info("create begin....");
            this.mongoTemplate.save((Object)memorandum);
            log.info("create end...");
            QueueParam qp = new QueueParam();
            qp.set_id((Object)new ObjectId());
            qp.setUser_id(memorandum.getUser_id());
            qp.setCreator_id(user_id);
            qp.setCreated_date(memorandum.getCreated_date());
            qp.setModifier_id(user_id);
            qp.setModified_date(memorandum.getModified_date());
            qp.setIs_active("Y");
            qp.setName("_id");
            qp.setValue(memorandum.get_id().toString());
            qp.setQueue_item_id(memorandum.get_id().toString());
            this.mongoTemplate.save((Object)qp);
            String str = memorandum.toString();
            log.info("str:" + str);
            this.jobService.addJob(JSON.parseObject((String)str));
            jsonObject_recurrence.put("remind_id", (Object)memorandum.get_id().toString());
            recurrenceList.add((Object)jsonObject_recurrence);
        }
        Update update = new Update();
        update.set("recurrenceList", (Object)recurrenceList);
        this.mongoTemplate.upsert(query, update, Order.class);
    }

    public void insertlogisict(JSONObject object) {
        String logistics_code = object.getString("logistics_code");
        String order_id = object.getString("order_id");
        String logistics_name = object.getString("logistics_name");
        String shipper_code = object.getString("shipper_code");
        String is_one = object.getString("is_one");
        String is_postage = object.getString("is_postage");
        JSONArray product_list = object.getJSONArray("product_list");
        Double logistics_freight = object.getDouble("freight");
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"shipper_code").is((Object)shipper_code));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"order_id").is((Object)order_id));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"logistics_code").is((Object)logistics_code));
        Logistics logisticsOne = (Logistics)this.mongoTemplate.findOne(query, Logistics.class);
        Query query1 = new Query();
        query1.addCriteria((CriteriaDefinition)Criteria.where((String)"logistics_name").is((Object)logistics_name));
        query1.addCriteria((CriteriaDefinition)Criteria.where((String)"shipper_code").is((Object)shipper_code));
        Express express = (Express)this.mongoTemplate.findOne(query1, Express.class);
        String kuaidi100 = "";
        if (null != express) {
            kuaidi100 = StringUtils.checkString((String)express.getKuaidi100());
        }
        if (null == logisticsOne) {
            Logistics logistics = new Logistics();
            logistics.setIs_logistics("Y");
            logistics.setLogistics_code(logistics_code);
            logistics.setProductList(product_list);
            logistics.setShipper_code(shipper_code);
            logistics.setIs_one(is_one);
            logistics.setIs_postage(is_postage);
            logistics.setFreight(logistics_freight);
            logistics.setLogistics_name(logistics_name);
            logistics.setOrder_id(order_id);
            logistics.setKuaidi100(kuaidi100);
            this.mongoTemplate.save((Object)logistics);
            this.kdniaoService.subOrderTraces(shipper_code, logistics_code, order_id);
            this.kdniaoService.queryOrderTraces(shipper_code, logistics_code);
        } else {
            Update update = new Update();
            update.set("logistics_code", (Object)logistics_code);
            update.set("logistics_name", (Object)logistics_name);
            update.set("shipper_code", (Object)shipper_code);
            update.set("kuaidi100", (Object)kuaidi100);
            update.set("is_one", (Object)is_one);
            update.set("is_postage", (Object)is_postage);
            update.set("productList", (Object)product_list);
            update.set("freight", (Object)logistics_freight);
            this.mongoTemplate.upsert(query, update, Logistics.class);
        }
    }

    @CacheEvict(value={"order"}, allEntries=true)
    public DataResponse mod(DataRequest dataRequest) {
        DataResponse dataResponse = new DataResponse();
        JSONObject data = dataRequest.getData();
        String _id = data.getString("id");
        String user_id = data.getString("user_id");
        JSONArray array = data.getJSONArray("productList");
        String team_id = "";
        for (int i = 0; i < array.size(); ++i) {
            team_id = array.getJSONObject(i).getString("team_id");
        }
        String grade_id = "";
        if (StringUtils.isNotNull((Object)team_id)) {
            JSONObject param_user = new JSONObject();
            param_user.put("user_id", (Object)user_id);
            param_user.put("team_id", (Object)team_id);
            grade_id = this.teamAgent.getData(param_user, "/team/getTeamMemberGrade").getString("grade_id");
        }
        array = this.setOrderDetailProductParentTeam(array, grade_id);
        BasicDBObject basicDBObject = new BasicDBObject();
        BasicDBObject update = new BasicDBObject();
        if (data.containsKey((Object)"order_price")) {
            basicDBObject.put((Object)"order_price", (Object)data.getDouble("order_price"));
        }
        if (data.containsKey((Object)"order_reback_time")) {
            basicDBObject.put((Object)"order_reback_time", (Object)data.getJSONObject("order_reback_time"));
        }
        if (data.containsKey((Object)"order_vip")) {
            basicDBObject.put((Object)"order_vip", (Object)data.getJSONObject("order_vip"));
        }
        if (data.containsKey((Object)"order_freight")) {
            basicDBObject.put((Object)"order_freight", (Object)data.getString("order_freight"));
        }
        if (data.containsKey((Object)"order_num")) {
            basicDBObject.put((Object)"order_num", (Object)data.getString("order_num"));
        }
        if (data.containsKey((Object)"productList")) {
            basicDBObject.put((Object)"productList", (Object)data.getJSONArray("productList"));
        }
        if (data.containsKey((Object)"recurrence")) {
            basicDBObject.put((Object)"recurrence", (Object)data.getJSONObject("recurrence"));
        }
        if (data.containsKey((Object)"recurrenceList")) {
            basicDBObject.put((Object)"recurrenceList", (Object)data.getJSONArray("recurrenceList"));
        }
        basicDBObject.put((Object)"modified_date", (Object)TimeUtils.getCurrentTimeInString((SimpleDateFormat)TimeUtils.DATETIME_FORMAT_DATE));
        update.put((Object)"$set", (Object)basicDBObject);
        BasicDBObject query = new BasicDBObject();
        query.put((Object)"_id", (Object)new ObjectId(_id));
        log.info("update>>" + update + ">>>>>>>>>query>>>>>>>" + query);
        WriteResult writeResult = this.mongoTemplate.getCollection("def_order").updateMulti((DBObject)query, (DBObject)update);
        if (writeResult.getN() > 0) {
            writeResult = this.mongoTemplate.getCollection("def_order_detail").updateMulti((DBObject)query, (DBObject)update);
            JSONObject da = new JSONObject();
            da.put("message", (Object)"\u4fee\u6539\u6210\u529f");
            dataResponse.setStatus(Status.SUCCESS).setCode("0").setId(dataRequest.getId()).setData(da);
        } else {
            JSONObject da = new JSONObject();
            da.put("message", (Object)"\u4fee\u6539\u5931\u8d25");
            dataResponse.setStatus(Status.FAILED).setCode("-1").setId(dataRequest.getId()).setData(da).setMsg("\u4fee\u6539\u5931\u8d25");
        }
        return dataResponse;
    }

    public JSONArray operateProduct(JSONArray array, Double order_amount_pay, Double order_amount, String id, Double fright) {
        if (StringUtils.isNotNull((Object)id)) {
            Query query_ = new Query();
            query_.addCriteria((CriteriaDefinition)Criteria.where((String)"_id").is((Object)new ObjectId(id)));
            Order order = (Order)this.mongoTemplate.findOne(query_, Order.class);
            if (StringUtils.isNull((Object)array)) {
                array = order.getProductList();
            }
            if (StringUtils.isNull((Object)order_amount_pay)) {
                order_amount_pay = order.getOrder_amount_pay();
            }
            if (StringUtils.isNull((Object)order_amount)) {
                order_amount = order.getOrder_amount();
            }
            if (StringUtils.isNull((Object)fright)) {
                fright = order.getOrder_freight();
            }
        }
        order_amount_pay = order_amount_pay - fright;
        JSONArray array_product = new JSONArray();
        Double product_all = 0.0;
        for (int i = 0; i < array.size(); ++i) {
            JSONObject object = array.getJSONObject(i);
            Double product_price = object.getDouble("product_price");
            Double product_num = object.getDouble("product_num");
            Double product_amount = 0.0;
            if (order_amount > 0.0) {
                Double s = product_price * product_num / order_amount * order_amount_pay;
                product_amount = NumberUtil.round((double)s);
            } else {
                product_amount = 0.0;
            }
            log.info((Object)product_amount);
            if (i == array.size() - 1) {
                if (i != 0) {
                    object.put("product_amount", (Object)NumberUtil.round((double)(order_amount_pay - product_all)));
                } else {
                    object.put("product_amount", (Object)product_amount);
                }
            } else {
                object.put("product_amount", (Object)product_amount);
            }
            product_all = product_all + product_amount;
            array_product.add((Object)object);
        }
        return array_product;
    }

    @CacheEvict(value={"order"}, allEntries=true)
    public DataResponse modv3(DataRequest dataRequest) {
        DataResponse dataResponse = new DataResponse();
        JSONObject data = dataRequest.getData();
        String _id = data.getString("id");
        Query query_ = new Query();
        query_.addCriteria((CriteriaDefinition)Criteria.where((String)"order_id").is((Object)_id));
        Order order = (Order)this.mongoTemplate.findOne(query_, Order.class);
        String old_pay_status = order.getPay_status();
        String order_no = order.getOrder_no();
        String team_id = "";
        String trade_type = order.getTrade_type();
        JSONArray productList = order.getProductList();
        JSONObject order_vip = order.getOrder_vip();
        String vip_id = "";
        if (null != order_vip && order_vip.size() > 0) {
            vip_id = order_vip.getString("vip_id");
        }
        for (int i = 0; i < productList.size(); ++i) {
            team_id = productList.getJSONObject(i).getString("team_id");
        }
        JSONArray order_product_array = data.getJSONArray("productList");
        String user_id = data.getString("user_id");
        for (int i = 0; i < productList.size(); ++i) {
            team_id = productList.getJSONObject(i).getString("team_id");
        }
        String grade_id = "";
        if (StringUtils.isNotNull((Object)team_id)) {
            JSONObject param_user = new JSONObject();
            param_user.put("user_id", (Object)user_id);
            param_user.put("team_id", (Object)team_id);
            grade_id = this.teamAgent.getData(param_user, "/team/getTeamMemberGrade").getString("grade_id");
        }
        order_product_array = this.setOrderDetailProductParentTeam(order_product_array, grade_id);
        Update basicDBObject = new Update();
        JSONArray array = new JSONArray();
        if (data.containsKey((Object)"order_amount_pay")) {
            basicDBObject.set("order_amount_pay", (Object)NumberUtil.round((double)data.getDoubleValue("order_amount_pay")));
            array = this.operateProduct(data.getJSONArray("productList"), Double.valueOf(NumberUtil.round((double)data.getDoubleValue("order_amount_pay"))), Double.valueOf(NumberUtil.round((double)data.getDoubleValue("order_amount"))), _id, Double.valueOf(NumberUtil.round((double)data.getDoubleValue("order_freight"))));
        }
        if (data.containsKey((Object)"seller_remark")) {
            basicDBObject.set("seller_remark", (Object)data.getString("seller_remark"));
        }
        if (data.containsKey((Object)"order_amount")) {
            basicDBObject.set("order_amount", (Object)NumberUtil.round((double)data.getDoubleValue("order_amount")));
            array = this.operateProduct(data.getJSONArray("productList"), Double.valueOf(NumberUtil.round((double)data.getDoubleValue("order_amount_pay"))), Double.valueOf(NumberUtil.round((double)data.getDoubleValue("order_amount"))), _id, Double.valueOf(NumberUtil.round((double)data.getDoubleValue("order_freight"))));
        }
        if (data.containsKey((Object)"order_status")) {
            basicDBObject.set("order_status", (Object)data.getString("order_status"));
            if ("1".equals(data.getString("order_status"))) {
                basicDBObject.set("logistics_time", (Object)TimeUtils.getCurrentTimeInString((SimpleDateFormat)TimeUtils.DATETIME_FORMAT_DATE));
            }
        }
        if (data.containsKey((Object)"pay_status")) {
            basicDBObject.set("pay_status", (Object)data.getString("pay_status"));
            if ("1".equals(data.getString("pay_status"))) {
                basicDBObject.set("pay_date", (Object)TimeUtils.getCurrentTimeInString((SimpleDateFormat)TimeUtils.DATETIME_FORMAT_DATE));
            }
        }
        if (data.containsKey((Object)"is_online_pay")) {
            basicDBObject.set("is_online_pay", (Object)data.getString("is_online_pay"));
        }
        if (data.containsKey((Object)"trade_type")) {
            trade_type = data.getString("trade_type");
            basicDBObject.set("trade_type", (Object)data.getString("trade_type"));
        }
        if (data.containsKey((Object)"order_vip")) {
            basicDBObject.set("order_vip", (Object)data.getJSONObject("order_vip"));
        }
        if (data.containsKey((Object)"order_freight")) {
            basicDBObject.set("order_freight", (Object)data.getDoubleValue("order_freight"));
            array = this.operateProduct(data.getJSONArray("productList"), Double.valueOf(data.getDoubleValue("order_amount_pay")), Double.valueOf(data.getDoubleValue("order_amount")), _id, Double.valueOf(NumberUtil.round((double)data.getDoubleValue("order_freight"))));
        }
        if (data.containsKey((Object)"order_num")) {
            basicDBObject.set("order_num", (Object)data.getIntValue("order_num"));
        }
        if (data.containsKey((Object)"productList")) {
            basicDBObject.set("productList", (Object)data.getJSONArray("productList"));
            array = this.operateProduct(data.getJSONArray("productList"), Double.valueOf(data.getDoubleValue("order_amount_pay")), Double.valueOf(data.getDoubleValue("order_amount")), _id, Double.valueOf(NumberUtil.round((double)data.getDoubleValue("order_freight"))));
            Double product_amount = 0.0;
            Double product_price = 0.0;
            int product_num = 0;
            JSONArray newArray = new JSONArray();
            for (int i = 0; i < array.size(); ++i) {
                JSONObject product = array.getJSONObject(i);
                String product_id = product.getString("product_id");
                product_num = product.getIntValue("product_num");
                team_id = product.getString("team_id");
                Query q = new Query();
                q.addCriteria((CriteriaDefinition)Criteria.where((String)"product_id").is((Object)product_id));
                Product productInfo = (Product)this.mongoTemplate.findOne(q, Product.class);
                String sku_id = this.getProductSkuId(product_id);
                if (StringUtils.isNotNull((Object)sku_id)) {
                    product.put("sku_id", (Object)sku_id);
                }
                if (productInfo != null) {
                    JSONObject object = new JSONObject();
                    object.put("product_id", (Object)product_id);
                    object.put("product_num", (Object)product_num);
                    object.put("sku_id", (Object)sku_id);
                    object.put("team_id", (Object)team_id);
                    object.put("trade_type", (Object)trade_type);
                    if (this.checkStock(object, productInfo)) {
                        dataResponse.setStatus(Status.FAILED).setMsg("\u5546\u54c1\"" + productInfo.getProduct_name() + "\"\u5e93\u5b58\u4e0d\u8db3\uff0c\u8bf7\u79fb\u9664\u8be5\u5546\u54c1\u540e\u91cd\u65b0\u4e0b\u5355\uff01").setId(dataRequest.getId());
                        return dataResponse;
                    }
                } else {
                    JSONObject da = new JSONObject();
                    da.put("msg", (Object)(product.getString("product_name") + "\u5df2\u88ab\u5220\u9664\uff0c\u8bf7\u91cd\u65b0\u4e0b\u5355"));
                    dataResponse.setStatus(Status.FAILED).setCode("0").setId(dataRequest.getId()).setData(da).setMsg(product.getString("product_name") + "\u5df2\u88ab\u5220\u9664\uff0c\u8bf7\u91cd\u65b0\u4e0b\u5355");
                    return dataResponse;
                }
                product_amount = product.getDoubleValue("product_amount");
                product_price = product.getDoubleValue("product_price");
                product_num = product.getIntValue("product_num");
                product.remove((Object)"product_amount");
                product.put("product_amount", (Object)product_amount);
                product.remove((Object)"product_num");
                product.put("product_num", (Object)product_num);
                product.remove((Object)"product_price");
                product.put("product_price", (Object)product_price);
                newArray.add((Object)product);
            }
            array = newArray;
        }
        if (array.size() > 0) {
            basicDBObject.set("productList", (Object)array);
        }
        if (data.containsKey((Object)"recurrenceList")) {
            this.updateOrderRemind(dataRequest, _id);
        }
        if (data.containsKey((Object)"logisticsList")) {
            JSONArray jsonArray = data.getJSONArray("logisticsList");
            JSONArray array3 = new JSONArray();
            for (int i = 0; i < jsonArray.size(); ++i) {
                JSONObject object = jsonArray.getJSONObject(i);
                JSONArray array1 = object.getJSONArray("product_list");
                JSONArray array2 = new JSONArray();
                if (null != array1) {
                    for (int j = 0; j < array1.size(); ++j) {
                        JSONObject jsonObject = array1.getJSONObject(j);
                        jsonObject.put("product_price", (Object)jsonObject.getDoubleValue("product_price"));
                        jsonObject.put("product_num", (Object)jsonObject.getIntValue("product_num"));
                        jsonObject.put("product_amount", (Object)jsonObject.getDoubleValue("product_amount"));
                        array2.add((Object)jsonObject);
                    }
                }
                object.put("product_list", (Object)array2);
                array3.add((Object)object);
            }
            basicDBObject.set("logisticsList", (Object)array3);
            JSONArray logistics_info = data.getJSONArray("logisticsList");
            if (null != logistics_info) {
                for (int i = 0; i < logistics_info.size(); ++i) {
                    this.insertlogisict(logistics_info.getJSONObject(i));
                }
            }
        }
        String pay_status = "";
        if (data.containsKey((Object)"pay_info")) {
            basicDBObject.set("pay_info", (Object)data.getJSONObject("pay_info"));
            if (data.getJSONObject("pay_info").containsKey((Object)"pay_status")) {
                pay_status = data.getJSONObject("pay_info").getString("pay_status");
                if (StringUtils.isNull((Object)pay_status)) {
                    String is_pay = data.getJSONObject("pay_info").getString("is_pay");
                    pay_status = "Y".equals(is_pay) ? "1" : "0";
                }
                basicDBObject.set("pay_status", (Object)pay_status);
                if ("1".equals(pay_status)) {
                    String corp_code = order.getProductList().getJSONObject(0).getString("corp_code");
                    if ("C10041".equals(corp_code)) {
                        this.redisClient.getValueOps().setValueString("Order_" + corp_code + order.getOrder_no(), JSON.toJSONString((Object)order));
                    }
                    basicDBObject.set("pay_date", (Object)TimeUtils.getCurrentTimeInString((SimpleDateFormat)TimeUtils.DATETIME_FORMAT_DATE));
                }
            }
            if (data.getJSONObject("pay_info").containsKey((Object)"pay_way")) {
                String pay_way;
                trade_type = pay_way = data.getJSONObject("pay_info").getString("pay_way");
                basicDBObject.set("trade_type", (Object)pay_way);
            }
        }
        if (!order_no.startsWith("WX") && "1".equals(old_pay_status) && "0".equals(pay_status)) {
            JSONObject da = new JSONObject();
            da.put("message", (Object)"\u4fee\u6539\u5931\u8d25");
            return dataResponse.setStatus(Status.FAILED).setCode("-1").setId(dataRequest.getId()).setData(da).setMsg("\u8ba2\u5355\u5df2\u652f\u4ed8");
        }
        if (data.containsKey((Object)"express_info")) {
            JSONObject a = data.getJSONObject("express_info");
            if (a.containsKey((Object)"address")) {
                Vip vip;
                JSONObject address = a.getJSONObject("address");
                String vip_phone = address.getString("phone");
                if (StringUtils.isNotNull((Object)vip_id) && address.size() > 0 && (vip = (Vip)this.mongoTemplate.findOne(Query.query((CriteriaDefinition)Criteria.where((String)"vip_id").is((Object)vip_id)), Vip.class)) != null && StringUtils.isNull((Object)vip.getVip_phone())) {
                    log.info("\u6536\u8d27\u5730\u5740\u66f4\u65b0\u624b\u673a\u53f7");
                    this.mongoTemplate.upsert(Query.query((CriteriaDefinition)Criteria.where((String)"vip_id").is((Object)vip_id)), Update.update((String)"vip_phone", (Object)vip_phone), Vip.class);
                }
            }
            if (StringUtils.isNotNull((Object)data.get((Object)"logisticsList"))) {
                a.put("is_self_pick", (Object)"N");
            }
            basicDBObject.set("express_info", (Object)a);
        }
        if ("1".equals(pay_status)) {
            Vip vip;
            if (!"online".equals(trade_type) && null != (vip = (Vip)this.mongoTemplate.findOne(Query.query((CriteriaDefinition)Criteria.where((String)"vip_id").is((Object)vip_id)), Vip.class)) && StringUtils.isNull((Object)vip.getVip_phone())) {
                return dataResponse.setStatus(Status.FAILED).setCode("-1").setId(dataRequest.getId()).setMsg("\u8bf7\u5148\u7ef4\u62a4\u4f1a\u5458\u624b\u673a\u53f7");
            }
            basicDBObject.set("pay_date", (Object)TimeUtils.getCurrentTimeInString((SimpleDateFormat)TimeUtils.DATETIME_FORMAT_DATE));
        }
        if (data.containsKey((Object)"recurrence")) {
            basicDBObject.set("recurrence", (Object)data.getJSONObject("recurrence"));
        }
        basicDBObject.set("modified_date", (Object)TimeUtils.getCurrentTimeInString((SimpleDateFormat)TimeUtils.DATETIME_FORMAT_DATE));
        try {
            this.unUseCoupon(order);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"order_id").is((Object)_id));
        log.info("update>>" + basicDBObject + ">>>>>>>>>query>>>>>>>" + query);
        DataRequest bankroll = new DataRequest();
        bankroll.setSign("");
        Update update_bank = basicDBObject;
        Update update_new = basicDBObject;
        if ("bankroll".equals(trade_type)) {
            update_bank.set("order_id", (Object)_id);
            bankroll.setData(JSONObject.parseObject((String)update_bank.toString()));
            DataResponse response = this.orderAgent.callRest(bankroll, "/bankroll/verifyBankroll");
            if (!"SUCCESS".equals(response.getStatus().toString())) {
                return response;
            }
        }
        log.info("--update_new----" + update_new);
        WriteResult writeResult = this.mongoTemplate.upsert(query, update_new, "def_order");
        if (writeResult.getN() > 0) {
            DataRequest adjuststockRequest = new DataRequest();
            JSONObject datarequest = new JSONObject();
            if (data.containsKey((Object)"productList")) {
                datarequest.put("productList", (Object)data.getJSONArray("productList"));
            } else {
                datarequest.put("productList", (Object)productList);
            }
            datarequest.put("user_id", (Object)data.getString("user_id"));
            datarequest.put("order_no", (Object)order.getOrder_no());
            datarequest.put("type", (Object)"mod");
            datarequest.put("pay_status", (Object)pay_status);
            datarequest.put("is_online_pay", (Object)order.getIs_online_pay());
            adjuststockRequest.setData(datarequest);
            5 adjuststock = new /* Unavailable Anonymous Inner Class!! */;
            try {
                Thread t = new Thread((Runnable)adjuststock);
                t.start();
            }
            catch (Exception e) {
                log.error("set message error:" + e.getLocalizedMessage(), (Throwable)e);
            }
            if (pay_status.equals("1")) {
                if ("bankroll".equals(trade_type)) {
                    JSONObject jsonObject_bank_consumer = new JSONObject();
                    jsonObject_bank_consumer.put("order_id", (Object)_id);
                    bankroll.setData(jsonObject_bank_consumer);
                    DataResponse response = this.orderAgent.callRest(bankroll, "/bankroll/consume");
                    if (!"SUCCESS".equals(response.getStatus().toString())) {
                        return response;
                    }
                }
                DataRequest dataRequest1 = new DataRequest();
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("order_id", (Object)_id);
                dataRequest1.setData(jsonObject);
                log.info("--mod--\u6d88\u8d39\u53d1\u5238----" + jsonObject);
                DataResponse dataResponse1 = this.couponService.getData("/coupon/orderPaySuccessSendCoupon", dataRequest1);
                log.info("--mod--\u6d88\u8d39\u53d1\u8fd4\u56de----" + dataResponse1);
                6 createOfflineCreate = new /* Unavailable Anonymous Inner Class!! */;
                try {
                    Thread t = new Thread((Runnable)createOfflineCreate);
                    t.start();
                }
                catch (Exception e) {
                    log.error("set message error:" + e.getLocalizedMessage(), (Throwable)e);
                }
                if (old_pay_status.equals("1")) {
                    writeResult = this.mongoTemplate.updateMulti(query, basicDBObject, "def_order_detail");
                } else if (old_pay_status.equals("0")) {
                    BasicDBObject order_query = new BasicDBObject("order_id", (Object)order.getOrder_id());
                    BasicDBObject unwind = new BasicDBObject("$unwind", (Object)"$productList");
                    BasicDBObject match = new BasicDBObject("$match", (Object)order_query);
                    AggregationOutput aggregationOutput = this.mongoTemplate.getCollection("def_order").aggregate((DBObject)unwind, new DBObject[]{match});
                    ArrayList<DBObject> list = new ArrayList<DBObject>();
                    for (DBObject object : aggregationOutput.results()) {
                        object.removeField("_id");
                        list.add(object);
                    }
                    WriteResult writeResult1 = this.mongoTemplate.getCollection("def_order_detail").insert(list);
                    if (StringUtils.isNotNull((Object)team_id)) {
                        try {
                            TeamNews news = new TeamNews();
                            news.setNews_type("addOrder");
                            news.setTeam_id(team_id);
                            news.setUser_id(order.getUser_id());
                            JSONObject news_obj = JSON.parseObject((String)news.toString());
                            JSONObject order_obj = JSONObject.parseObject((String)order.toString());
                            order_obj.remove((Object)"_id");
                            news_obj.put("news_value", (Object)order_obj);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }
            }
            JSONObject da = new JSONObject();
            da.put("message", (Object)"\u4fee\u6539\u6210\u529f");
            dataResponse.setStatus(Status.SUCCESS).setCode("0").setId(dataRequest.getId()).setData(da);
        } else {
            JSONObject da = new JSONObject();
            da.put("message", (Object)"\u4fee\u6539\u5931\u8d25");
            dataResponse.setStatus(Status.FAILED).setCode("-1").setId(dataRequest.getId()).setData(da).setMsg("\u4fee\u6539\u5931\u8d25");
        }
        return dataResponse;
    }

    public DataResponse modv4(DataRequest dataRequest) {
        DataResponse dataResponse = new DataResponse();
        JSONObject data = dataRequest.getData();
        String _id = data.getString("id");
        Query query_ = new Query();
        query_.addCriteria((CriteriaDefinition)Criteria.where((String)"order_id").is((Object)_id));
        Order order = (Order)this.mongoTemplate.findOne(query_, Order.class);
        String old_pay_status = order.getPay_status();
        String old_out_order_sn = order.getOut_order_sn();
        String order_no = order.getOrder_no();
        String team_id = "";
        String trade_type = order.getTrade_type();
        JSONArray productList = order.getProductList();
        JSONObject order_vip = order.getOrder_vip();
        String vip_id = "";
        if (null != order_vip && order_vip.size() > 0) {
            vip_id = order_vip.getString("vip_id");
        }
        String user_id = data.getString("user_id");
        for (int i = 0; i < productList.size(); ++i) {
            team_id = productList.getJSONObject(i).getString("team_id");
        }
        String grade_id = "";
        if (StringUtils.isNotNull((Object)team_id)) {
            JSONObject param_user = new JSONObject();
            param_user.put("user_id", (Object)user_id);
            param_user.put("team_id", (Object)team_id);
            grade_id = this.teamAgent.getData(param_user, "/team/getTeamMemberGrade").getString("grade_id");
        }
        Update basicDBObject = new Update();
        JSONArray array = new JSONArray();
        if (data.containsKey((Object)"order_amount_pay")) {
            basicDBObject.set("order_amount_pay", (Object)NumberUtil.round((double)data.getDoubleValue("order_amount_pay")));
            array = this.operateProduct(data.getJSONArray("productList"), Double.valueOf(NumberUtil.round((double)data.getDoubleValue("order_amount_pay"))), Double.valueOf(NumberUtil.round((double)data.getDoubleValue("order_amount"))), _id, Double.valueOf(NumberUtil.round((double)data.getDoubleValue("order_freight"))));
        }
        if (data.containsKey((Object)"seller_remark")) {
            basicDBObject.set("seller_remark", (Object)data.getString("seller_remark"));
        }
        if (data.containsKey((Object)"order_amount")) {
            basicDBObject.set("order_amount", (Object)NumberUtil.round((double)data.getDoubleValue("order_amount")));
            array = this.operateProduct(data.getJSONArray("productList"), Double.valueOf(NumberUtil.round((double)data.getDoubleValue("order_amount_pay"))), Double.valueOf(NumberUtil.round((double)data.getDoubleValue("order_amount"))), _id, Double.valueOf(NumberUtil.round((double)data.getDoubleValue("order_freight"))));
        }
        if (data.containsKey((Object)"order_status")) {
            basicDBObject.set("order_status", (Object)data.getString("order_status"));
            if ("1".equals(data.getString("order_status"))) {
                basicDBObject.set("logistics_time", (Object)TimeUtils.getCurrentTimeInString((SimpleDateFormat)TimeUtils.DATETIME_FORMAT_DATE));
            }
        }
        if (data.containsKey((Object)"pay_status")) {
            basicDBObject.set("pay_status", (Object)data.getString("pay_status"));
            if ("1".equals(data.getString("pay_status"))) {
                basicDBObject.set("pay_date", (Object)TimeUtils.getCurrentTimeInString((SimpleDateFormat)TimeUtils.DATETIME_FORMAT_DATE));
            }
        }
        if (data.containsKey((Object)"is_online_pay")) {
            basicDBObject.set("is_online_pay", (Object)data.getString("is_online_pay"));
        }
        if (data.containsKey((Object)"trade_type")) {
            trade_type = data.getString("trade_type");
            basicDBObject.set("trade_type", (Object)data.getString("trade_type"));
        }
        String corp_code = order.getProductList().getJSONObject(0).getString("corp_code");
        if (data.containsKey((Object)"out_order_sn")) {
            Order order1;
            String out_order_sn = data.getString("out_order_sn");
            if (StringUtils.isNull((Object)old_out_order_sn)) {
                order1 = (Order)this.mongoTemplate.findOne(Query.query((CriteriaDefinition)Criteria.where((String)"order_id").ne((Object)_id).and("out_order_sn").is((Object)out_order_sn).and("corp_code").is((Object)corp_code)), Order.class);
                if (null != order1) {
                    return new DataResponse().setStatus(Status.FAILED).setCode("-1").setMsg("POS\u5355\u53f7\u5728\u8ba2\u5355" + order1.getOrder_no() + "\u5df2\u5b58\u5728");
                }
                basicDBObject.set("out_order_sn", (Object)data.getString("out_order_sn"));
            } else if (!old_out_order_sn.equals(out_order_sn)) {
                order1 = (Order)this.mongoTemplate.findOne(Query.query((CriteriaDefinition)Criteria.where((String)"order_id").ne((Object)_id).and("out_order_sn").is((Object)out_order_sn).and("corp_code").is((Object)corp_code)), Order.class);
                if (null != order1) {
                    return new DataResponse().setStatus(Status.FAILED).setCode("-1").setMsg("POS\u5355\u53f7\u5728\u8ba2\u5355" + order1.getOrder_no() + "\u5df2\u5b58\u5728");
                }
                basicDBObject.set("out_order_sn", (Object)data.getString("out_order_sn"));
            }
        }
        if (data.containsKey((Object)"order_vip")) {
            basicDBObject.set("order_vip", (Object)data.getJSONObject("order_vip"));
        }
        if (data.containsKey((Object)"order_freight")) {
            basicDBObject.set("order_freight", (Object)data.getDoubleValue("order_freight"));
            array = this.operateProduct(data.getJSONArray("productList"), Double.valueOf(data.getDoubleValue("order_amount_pay")), Double.valueOf(data.getDoubleValue("order_amount")), _id, Double.valueOf(NumberUtil.round((double)data.getDoubleValue("order_freight"))));
        }
        if (data.containsKey((Object)"order_num")) {
            basicDBObject.set("order_num", (Object)data.getIntValue("order_num"));
        }
        if (data.containsKey((Object)"productList")) {
            productList = new JSONArray();
            for (int i = 0; i < array.size(); ++i) {
                JSONObject object = array.getJSONObject(i);
                object.put("num", (Object)object.getInteger("product_num"));
                productList.add((Object)object);
            }
            JSONObject calculateProducts = new JSONObject();
            calculateProducts.put("productInfo", (Object)productList);
            JSONObject result = this.activityAgent.getData(calculateProducts, "/activity/calculateProducts");
            JSONArray productListActivity = result.getJSONArray("productInfo");
            Double order_amount_pay = 0.0;
            Double order_amount = 0.0;
            int order_num = 0;
            for (int j = 0; j < productListActivity.size(); ++j) {
                JSONObject object = productListActivity.getJSONObject(j);
                object.put("product_amount", (Object)object.getDouble("productsDiscountAmount"));
                order_amount_pay = order_amount_pay + object.getDouble("productsDiscountAmount");
                order_amount = order_amount + object.getDouble("product_price") * object.getDouble("product_num");
                order_num += object.getIntValue("product_num");
            }
            array = this.setOrderDetailProductParentTeam(productListActivity, grade_id);
            JSONArray array_product = this.operateProduct(array, order_amount_pay, order_amount, "", Double.valueOf(0.0));
            if (null != result.getDouble("discountAmount") && result.getDouble("discountAmount") > 0.0) {
                basicDBObject.set("activity_discount_amount", (Object)result.getDouble("discountAmount"));
            }
            basicDBObject.set("order_amount", (Object)order_amount);
            basicDBObject.set("order_amount_pay", (Object)order_amount_pay);
            basicDBObject.set("order_num", (Object)order_num);
            basicDBObject.set("activity_ids", (Object)result.getJSONArray("activity_ids"));
            basicDBObject.set("activityRuleInfo", (Object)result.getJSONArray("activityRuleInfo"));
            Double product_amount = 0.0;
            Double product_price = 0.0;
            int product_num = 0;
            JSONArray newArray = new JSONArray();
            for (int i = 0; i < array_product.size(); ++i) {
                JSONObject product = array_product.getJSONObject(i);
                log.info("-\u9a8c\u8bc1-product-" + product);
                String product_id = product.getString("product_id");
                Product productGroup = (Product)this.mongoTemplate.findOne(Query.query((CriteriaDefinition)Criteria.where((String)"product_id").is((Object)product_id)), Product.class);
                String is_group = product.getString("is_group");
                product_num = product.getIntValue("product_num");
                if (!"Y".equals(is_group)) {
                    if (StringUtils.isNull((Object)team_id)) {
                        team_id = product.getString("team_id");
                    }
                    Query q = new Query();
                    q.addCriteria((CriteriaDefinition)Criteria.where((String)"product_id").is((Object)product_id));
                    Product productInfo = (Product)this.mongoTemplate.findOne(q, Product.class);
                    if (productInfo.getOn_sale() != 1) {
                        dataResponse.setStatus(Status.FAILED).setMsg("\u5546\u54c1\"" + productInfo.getProduct_name() + "\"\u5df2\u4e0b\u67b6\u6216\u672a\u4e0a\u67b6\uff01").setId(dataRequest.getId());
                        return dataResponse;
                    }
                    String sku_id = product.getString("sku_id");
                    String sku_code = product.getString("sku_code");
                    log.info("-sku_code--" + sku_code);
                    if (StringUtils.isNull((Object)sku_code)) {
                        Sku sku = (Sku)this.mongoTemplate.findOne(Query.query((CriteriaDefinition)Criteria.where((String)"_id").is((Object)new ObjectId(sku_id))), Sku.class);
                        log.info("-sku--" + sku);
                        if (null != sku) {
                            sku_code = sku.getOutter_id();
                            product.put("sku_code", (Object)sku.getCode());
                        }
                    }
                    if (productInfo != null) {
                        JSONObject object = new JSONObject();
                        object.put("product_id", (Object)product_id);
                        object.put("product_num", (Object)product_num);
                        object.put("sku_id", (Object)sku_id);
                        object.put("team_id", (Object)team_id);
                        object.put("trade_type", (Object)trade_type);
                        if (this.checkStock(object, productInfo)) {
                            dataResponse.setStatus(Status.FAILED).setMsg("\u5546\u54c1\"" + productInfo.getProduct_name() + "\"\u5e93\u5b58\u4e0d\u8db3\uff0c\u8bf7\u79fb\u9664\u8be5\u5546\u54c1\u540e\u91cd\u65b0\u4e0b\u5355\uff01").setId(dataRequest.getId());
                            return dataResponse;
                        }
                        product_amount = product.getDouble("product_amount");
                        product_price = product.getDouble("product_price");
                        product_num = product.getIntValue("product_num");
                        product.remove((Object)"product_amount");
                        product.put("product_amount", (Object)product_amount);
                        product.remove((Object)"product_num");
                        product.put("product_num", (Object)product_num);
                        product.remove((Object)"product_price");
                        product.put("product_price", (Object)product_price);
                        product.put("sku_code", (Object)sku_code);
                        log.info("--product-" + product);
                        newArray.add((Object)product);
                        continue;
                    }
                    JSONObject da = new JSONObject();
                    da.put("msg", (Object)(product.getString("product_name") + "\u5df2\u88ab\u5220\u9664\uff0c\u8bf7\u91cd\u65b0\u4e0b\u5355"));
                    dataResponse.setStatus(Status.FAILED).setCode("0").setId(dataRequest.getId()).setData(da);
                    return dataResponse;
                }
                if (StringUtils.isNotNull((Object)productGroup.getStock_num())) {
                    String stock_num = productGroup.getStock_num();
                    Integer qty = productGroup.getQty();
                    if (null == qty) {
                        qty = 0;
                    }
                    Integer stock = Integer.valueOf(stock_num);
                    if (qty + product_num > stock) {
                        dataResponse.setStatus(Status.FAILED).setMsg("\u7ec4\u5408\u5546\u54c1\"" + productGroup.getProduct_name() + "\"\u5e93\u5b58\u4e0d\u8db3\uff0c\u8bf7\u79fb\u9664\u8be5\u5546\u54c1\u540e\u91cd\u65b0\u4e0b\u5355\uff01").setId(dataRequest.getId());
                        return dataResponse;
                    }
                }
                JSONArray select_group_info = product.getJSONArray("select_group_info");
                for (int j = 0; j < select_group_info.size(); ++j) {
                    JSONObject jsonObject = select_group_info.getJSONObject(j);
                    String sku_id = jsonObject.getJSONObject("select_sku").getString("sku_id");
                    Integer num = jsonObject.getJSONObject("select_sku").getInteger("num");
                    JSONObject object = new JSONObject();
                    object.put("product_id", (Object)jsonObject.getString("product_id"));
                    object.put("product_num", (Object)(product_num * num));
                    object.put("sku_id", (Object)sku_id);
                    object.put("team_id", (Object)team_id);
                    object.put("trade_type", (Object)trade_type);
                    Query q = new Query();
                    q.addCriteria((CriteriaDefinition)Criteria.where((String)"product_id").is((Object)jsonObject.getString("product_id")));
                    Product productInfo = (Product)this.mongoTemplate.findOne(q, Product.class);
                    if (productInfo.getOn_sale() != 1) {
                        dataResponse.setStatus(Status.FAILED).setMsg("\u7ec4\u5408\u5546\u54c1\u4e2d\"" + productInfo.getProduct_name() + "\"\u5df2\u4e0b\u67b6\u6216\u672a\u4e0a\u67b6\uff01").setId(dataRequest.getId());
                        return dataResponse;
                    }
                    if (!this.checkStock(object, productInfo)) continue;
                    dataResponse.setStatus(Status.FAILED).setMsg("\u7ec4\u5408\u5546\u54c1\u4e2d\"" + productInfo.getProduct_name() + "\"\u5e93\u5b58\u4e0d\u8db3\uff0c\u8bf7\u79fb\u9664\u8be5\u5546\u54c1\u540e\u91cd\u65b0\u4e0b\u5355\uff01").setId(dataRequest.getId());
                    return dataResponse;
                }
                newArray.add((Object)product);
            }
            array = newArray;
        }
        if (array.size() > 0) {
            basicDBObject.set("productList", (Object)array);
        }
        if (data.containsKey((Object)"recurrenceList")) {
            this.updateOrderRemind(dataRequest, _id);
        }
        if (data.containsKey((Object)"logisticsList")) {
            JSONArray jsonArray = data.getJSONArray("logisticsList");
            JSONArray array3 = new JSONArray();
            for (int i = 0; i < jsonArray.size(); ++i) {
                JSONObject object = jsonArray.getJSONObject(i);
                JSONArray array1 = object.getJSONArray("product_list");
                JSONArray array2 = new JSONArray();
                if (null != array1) {
                    for (int j = 0; j < array1.size(); ++j) {
                        JSONObject jsonObject = array1.getJSONObject(j);
                        jsonObject.put("product_price", (Object)jsonObject.getDoubleValue("product_price"));
                        jsonObject.put("product_num", (Object)jsonObject.getIntValue("product_num"));
                        jsonObject.put("product_amount", (Object)jsonObject.getDoubleValue("product_amount"));
                        array2.add((Object)jsonObject);
                    }
                }
                object.put("product_list", (Object)array2);
                array3.add((Object)object);
            }
            basicDBObject.set("logisticsList", (Object)array3);
            basicDBObject.set("order_status", (Object)"1");
            String logisticsTime = TimeUtils.getCurrentTimeInString((SimpleDateFormat)TimeUtils.DATETIME_FORMAT_DATE);
            basicDBObject.set("logistics_time", (Object)logisticsTime);
            JSONArray logistics_info = data.getJSONArray("logisticsList");
            if (null != logistics_info) {
                for (int i = 0; i < logistics_info.size(); ++i) {
                    this.insertlogisict(logistics_info.getJSONObject(i));
                }
            }
        }
        String pay_status = "";
        if (data.containsKey((Object)"pay_info")) {
            basicDBObject.set("pay_info", (Object)data.getJSONObject("pay_info"));
            if (data.getJSONObject("pay_info").containsKey((Object)"pay_status")) {
                pay_status = data.getJSONObject("pay_info").getString("pay_status");
                if (StringUtils.isNull((Object)pay_status)) {
                    String is_pay = data.getJSONObject("pay_info").getString("is_pay");
                    pay_status = "Y".equals(is_pay) ? "1" : "0";
                }
                basicDBObject.set("pay_status", (Object)pay_status);
                if ("1".equals(pay_status)) {
                    corp_code = order.getProductList().getJSONObject(0).getString("corp_code");
                    if ("C10041".equals(corp_code)) {
                        this.redisClient.getValueOps().setValueString("Order_" + corp_code + order.getOrder_no(), JSON.toJSONString((Object)order));
                    }
                    basicDBObject.set("pay_date", (Object)TimeUtils.getCurrentTimeInString((SimpleDateFormat)TimeUtils.DATETIME_FORMAT_DATE));
                }
            }
            if (data.getJSONObject("pay_info").containsKey((Object)"pay_way")) {
                String pay_way;
                trade_type = pay_way = data.getJSONObject("pay_info").getString("pay_way");
                basicDBObject.set("trade_type", (Object)pay_way);
            }
        }
        if (!order_no.startsWith("WX") && "1".equals(old_pay_status) && "0".equals(pay_status)) {
            JSONObject da = new JSONObject();
            da.put("message", (Object)"\u4fee\u6539\u5931\u8d25");
            return dataResponse.setStatus(Status.FAILED).setCode("-1").setId(dataRequest.getId()).setData(da).setMsg("\u8ba2\u5355\u5df2\u652f\u4ed8");
        }
        if (data.containsKey((Object)"express_info")) {
            JSONObject a = data.getJSONObject("express_info");
            if (a.containsKey((Object)"address")) {
                Vip vip;
                JSONObject address = a.getJSONObject("address");
                String vip_phone = address.getString("phone");
                if (StringUtils.isNotNull((Object)vip_id) && address.size() > 0 && (vip = (Vip)this.mongoTemplate.findOne(Query.query((CriteriaDefinition)Criteria.where((String)"vip_id").is((Object)vip_id)), Vip.class)) != null && StringUtils.isNull((Object)vip.getVip_phone())) {
                    log.info("\u6536\u8d27\u5730\u5740\u66f4\u65b0\u624b\u673a\u53f7");
                    this.mongoTemplate.upsert(Query.query((CriteriaDefinition)Criteria.where((String)"vip_id").is((Object)vip_id)), Update.update((String)"vip_phone", (Object)vip_phone), Vip.class);
                }
            }
            if (StringUtils.isNotNull((Object)data.get((Object)"logisticsList"))) {
                a.put("is_self_pick", (Object)"N");
            }
            basicDBObject.set("express_info", (Object)a);
        }
        if ("1".equals(pay_status)) {
            Vip vip;
            if (!"online".equals(trade_type) && null != (vip = (Vip)this.mongoTemplate.findOne(Query.query((CriteriaDefinition)Criteria.where((String)"vip_id").is((Object)vip_id)), Vip.class)) && StringUtils.isNull((Object)vip.getVip_phone())) {
                return dataResponse.setStatus(Status.FAILED).setCode("-1").setId(dataRequest.getId()).setMsg("\u8bf7\u5148\u7ef4\u62a4\u4f1a\u5458\u624b\u673a\u53f7");
            }
            basicDBObject.set("pay_date", (Object)TimeUtils.getCurrentTimeInString((SimpleDateFormat)TimeUtils.DATETIME_FORMAT_DATE));
        }
        if (data.containsKey((Object)"recurrence")) {
            basicDBObject.set("recurrence", (Object)data.getJSONObject("recurrence"));
        }
        basicDBObject.set("modified_date", (Object)TimeUtils.getCurrentTimeInString((SimpleDateFormat)TimeUtils.DATETIME_FORMAT_DATE));
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"order_id").is((Object)_id));
        log.info("update>>" + basicDBObject + ">>>>>>>>>query>>>>>>>" + query);
        DataRequest bankroll = new DataRequest();
        bankroll.setSign("");
        Update update_bank = basicDBObject;
        Update update_new = basicDBObject;
        if ("bankroll".equals(trade_type)) {
            update_bank.set("order_id", (Object)_id);
            bankroll.setData(JSONObject.parseObject((String)update_bank.toString()));
            DataResponse response = this.orderAgent.callRest(bankroll, "/bankroll/verifyBankroll");
            if (!"SUCCESS".equals(response.getStatus().toString())) {
                return response;
            }
        }
        log.info("--update_new----" + update_new);
        WriteResult writeResult = this.mongoTemplate.upsert(query, update_new, "def_order");
        if (writeResult.getN() > 0) {
            DataRequest adjuststockRequest = new DataRequest();
            JSONObject datarequest = new JSONObject();
            if (data.containsKey((Object)"productList")) {
                datarequest.put("productList", (Object)data.getJSONArray("productList"));
            } else {
                datarequest.put("productList", (Object)productList);
            }
            datarequest.put("user_id", (Object)data.getString("user_id"));
            datarequest.put("order_no", (Object)order.getOrder_no());
            datarequest.put("type", (Object)"mod");
            datarequest.put("pay_status", (Object)pay_status);
            datarequest.put("is_online_pay", (Object)order.getIs_online_pay());
            adjuststockRequest.setData(datarequest);
            7 adjuststock = new /* Unavailable Anonymous Inner Class!! */;
            try {
                Thread t = new Thread((Runnable)adjuststock);
                t.start();
            }
            catch (Exception e) {
                log.error("set message error:" + e.getLocalizedMessage(), (Throwable)e);
            }
            if (pay_status.equals("1")) {
                if ("bankroll".equals(trade_type)) {
                    JSONObject jsonObject_bank_consumer = new JSONObject();
                    jsonObject_bank_consumer.put("order_id", (Object)_id);
                    bankroll.setData(jsonObject_bank_consumer);
                    DataResponse response = this.orderAgent.callRest(bankroll, "/bankroll/consume");
                    if (!"SUCCESS".equals(response.getStatus().toString())) {
                        return response;
                    }
                }
                DataRequest dataRequest1 = new DataRequest();
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("order_id", (Object)_id);
                dataRequest1.setData(jsonObject);
                log.info("--mod--\u6d88\u8d39\u53d1\u5238----" + jsonObject);
                DataResponse dataResponse1 = this.couponService.getData("/coupon/orderPaySuccessSendCoupon", dataRequest1);
                log.info("--mod--\u6d88\u8d39\u53d1\u8fd4\u56de----" + dataResponse1);
                8 createOfflineCreate = new /* Unavailable Anonymous Inner Class!! */;
                try {
                    Thread t = new Thread((Runnable)createOfflineCreate);
                    t.start();
                }
                catch (Exception e) {
                    log.error("set message error:" + e.getLocalizedMessage(), (Throwable)e);
                }
                if (old_pay_status.equals("1")) {
                    writeResult = this.mongoTemplate.updateMulti(query, basicDBObject, "def_order_detail");
                } else if (old_pay_status.equals("0")) {
                    BasicDBObject order_query = new BasicDBObject("order_id", (Object)order.getOrder_id());
                    BasicDBObject unwind = new BasicDBObject("$unwind", (Object)"$productList");
                    BasicDBObject match = new BasicDBObject("$match", (Object)order_query);
                    AggregationOutput aggregationOutput = this.mongoTemplate.getCollection("def_order").aggregate((DBObject)unwind, new DBObject[]{match});
                    ArrayList<DBObject> list = new ArrayList<DBObject>();
                    for (DBObject object : aggregationOutput.results()) {
                        object.removeField("_id");
                        list.add(object);
                    }
                    WriteResult writeResult1 = this.mongoTemplate.getCollection("def_order_detail").insert(list);
                    if (StringUtils.isNotNull((Object)team_id)) {
                        try {
                            TeamNews news = new TeamNews();
                            news.setNews_type("addOrder");
                            news.setTeam_id(team_id);
                            news.setUser_id(order.getUser_id());
                            JSONObject news_obj = JSON.parseObject((String)news.toString());
                            JSONObject order_obj = JSONObject.parseObject((String)order.toString());
                            order_obj.remove((Object)"_id");
                            news_obj.put("news_value", (Object)order_obj);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }
            }
            JSONObject da = new JSONObject();
            da.put("message", (Object)"\u4fee\u6539\u6210\u529f");
            dataResponse.setStatus(Status.SUCCESS).setCode("0").setId(dataRequest.getId()).setData(da);
        } else {
            JSONObject da = new JSONObject();
            da.put("message", (Object)"\u4fee\u6539\u5931\u8d25");
            dataResponse.setStatus(Status.FAILED).setCode("-1").setId(dataRequest.getId()).setData(da).setMsg("\u4fee\u6539\u5931\u8d25");
        }
        return dataResponse;
    }

    @CacheEvict(value={"order"}, allEntries=true)
    public DataResponse modv2(DataRequest dataRequest) {
        DataResponse dataResponse = new DataResponse();
        JSONObject data = dataRequest.getData();
        String _id = data.getString("id");
        Query query_ = new Query();
        query_.addCriteria((CriteriaDefinition)Criteria.where((String)"order_id").is((Object)_id));
        Order order = (Order)this.mongoTemplate.findOne(query_, Order.class);
        String old_pay_status = order.getPay_status();
        String order_no = order.getOrder_no();
        String team_id = "";
        String is_online_pay = order.getIs_online_pay();
        String trade_type = order.getTrade_type();
        JSONArray productList = order.getProductList();
        JSONObject order_vip = order.getOrder_vip();
        String vip_id = "";
        if (null != order_vip && order_vip.size() > 0) {
            vip_id = order_vip.getString("vip_id");
        }
        for (int i = 0; i < productList.size(); ++i) {
            team_id = productList.getJSONObject(i).getString("team_id");
        }
        JSONArray order_product_array = data.getJSONArray("productList");
        String user_id = data.getString("user_id");
        for (int i = 0; i < productList.size(); ++i) {
            team_id = productList.getJSONObject(i).getString("team_id");
        }
        String grade_id = "";
        if (StringUtils.isNotNull((Object)team_id)) {
            JSONObject param_user = new JSONObject();
            param_user.put("user_id", (Object)user_id);
            param_user.put("team_id", (Object)team_id);
            grade_id = this.teamAgent.getData(param_user, "/team/getTeamMemberGrade").getString("grade_id");
        }
        order_product_array = this.setOrderDetailProductParentTeam(order_product_array, grade_id);
        Update basicDBObject = new Update();
        JSONArray array = new JSONArray();
        if (data.containsKey((Object)"order_amount_pay")) {
            basicDBObject.set("order_amount_pay", (Object)NumberUtil.round((double)data.getDoubleValue("order_amount_pay")));
            array = this.operateProduct(data.getJSONArray("productList"), Double.valueOf(NumberUtil.round((double)data.getDoubleValue("order_amount_pay"))), Double.valueOf(NumberUtil.round((double)data.getDoubleValue("order_amount"))), _id, Double.valueOf(NumberUtil.round((double)data.getDoubleValue("order_freight"))));
        }
        if (data.containsKey((Object)"order_amount")) {
            basicDBObject.set("order_amount", (Object)NumberUtil.round((double)data.getDoubleValue("order_amount")));
            array = this.operateProduct(data.getJSONArray("productList"), Double.valueOf(NumberUtil.round((double)data.getDoubleValue("order_amount_pay"))), Double.valueOf(NumberUtil.round((double)data.getDoubleValue("order_amount"))), _id, Double.valueOf(NumberUtil.round((double)data.getDoubleValue("order_freight"))));
        }
        if (data.containsKey((Object)"order_status")) {
            basicDBObject.set("order_status", (Object)data.getString("order_status"));
            if ("1".equals(data.getString("order_status"))) {
                basicDBObject.set("logistics_time", (Object)TimeUtils.getCurrentTimeInString((SimpleDateFormat)TimeUtils.DATETIME_FORMAT_DATE));
            }
        }
        if (data.containsKey((Object)"pay_status")) {
            basicDBObject.set("pay_status", (Object)data.getString("pay_status"));
            if ("1".equals(data.getString("pay_status"))) {
                basicDBObject.set("pay_date", (Object)TimeUtils.getCurrentTimeInString((SimpleDateFormat)TimeUtils.DATETIME_FORMAT_DATE));
            }
        }
        if (data.containsKey((Object)"is_online_pay")) {
            basicDBObject.set("is_online_pay", (Object)data.getString("is_online_pay"));
        }
        if (data.containsKey((Object)"order_vip")) {
            basicDBObject.set("order_vip", (Object)data.getJSONObject("order_vip"));
        }
        if (data.containsKey((Object)"order_freight")) {
            basicDBObject.set("order_freight", (Object)data.getDoubleValue("order_freight"));
            array = this.operateProduct(data.getJSONArray("productList"), Double.valueOf(data.getDoubleValue("order_amount_pay")), Double.valueOf(data.getDoubleValue("order_amount")), _id, Double.valueOf(NumberUtil.round((double)data.getDoubleValue("order_freight"))));
        }
        if (data.containsKey((Object)"order_num")) {
            basicDBObject.set("order_num", (Object)data.getIntValue("order_num"));
        }
        if (data.containsKey((Object)"seller_remark")) {
            basicDBObject.set("seller_remark", (Object)data.getString("seller_remark"));
        }
        if (data.containsKey((Object)"productList")) {
            basicDBObject.set("productList", (Object)data.getJSONArray("productList"));
            array = this.operateProduct(data.getJSONArray("productList"), Double.valueOf(data.getDoubleValue("order_amount_pay")), Double.valueOf(data.getDoubleValue("order_amount")), _id, Double.valueOf(NumberUtil.round((double)data.getDoubleValue("order_freight"))));
            Double product_amount = 0.0;
            Double product_price = 0.0;
            int product_num = 0;
            JSONArray newArray = new JSONArray();
            for (int i = 0; i < array.size(); ++i) {
                JSONObject product = array.getJSONObject(i);
                String product_id = product.getString("product_id");
                product_num = product.getIntValue("product_num");
                team_id = product.getString("team_id");
                Query q = new Query();
                q.addCriteria((CriteriaDefinition)Criteria.where((String)"product_id").is((Object)product_id));
                Product productInfo = (Product)this.mongoTemplate.findOne(q, Product.class);
                String sku_id = this.getProductSkuId(product_id);
                if (StringUtils.isNotNull((Object)sku_id)) {
                    product.put("sku_id", (Object)sku_id);
                }
                if (productInfo != null) {
                    JSONObject object = new JSONObject();
                    object.put("product_id", (Object)product_id);
                    object.put("product_num", (Object)product_num);
                    object.put("sku_id", (Object)sku_id);
                    object.put("team_id", (Object)team_id);
                    object.put("is_online_pay", (Object)is_online_pay);
                    if (StringUtils.isNull((Object)trade_type)) {
                        if ("Y".equals(is_online_pay)) {
                            object.put("trade_type", (Object)"online");
                        } else {
                            object.put("trade_type", (Object)"offline");
                        }
                    } else {
                        object.put("trade_type", (Object)trade_type);
                    }
                    if (this.checkStock(object, productInfo)) {
                        dataResponse.setStatus(Status.FAILED).setMsg("\u5546\u54c1\"" + productInfo.getProduct_name() + "\"\u5e93\u5b58\u4e0d\u8db3\uff0c\u8bf7\u79fb\u9664\u8be5\u5546\u54c1\u540e\u91cd\u65b0\u4e0b\u5355\uff01").setId(dataRequest.getId());
                        return dataResponse;
                    }
                } else {
                    JSONObject da = new JSONObject();
                    da.put("msg", (Object)(product.getString("product_name") + "\u5df2\u88ab\u5220\u9664\uff0c\u8bf7\u91cd\u65b0\u4e0b\u5355"));
                    dataResponse.setStatus(Status.FAILED).setCode("0").setId(dataRequest.getId()).setData(da).setMsg(product.getString("product_name") + "\u5df2\u88ab\u5220\u9664\uff0c\u8bf7\u91cd\u65b0\u4e0b\u5355");
                    return dataResponse;
                }
                product_amount = product.getDoubleValue("product_amount");
                product_price = product.getDoubleValue("product_price");
                product_num = product.getIntValue("product_num");
                product.remove((Object)"product_amount");
                product.put("product_amount", (Object)product_amount);
                product.remove((Object)"product_num");
                product.put("product_num", (Object)product_num);
                product.remove((Object)"product_price");
                product.put("product_price", (Object)product_price);
                newArray.add((Object)product);
            }
            array = newArray;
        }
        if (array.size() > 0) {
            basicDBObject.set("productList", (Object)array);
        }
        if (data.containsKey((Object)"recurrenceList")) {
            this.updateOrderRemind(dataRequest, _id);
        }
        if (data.containsKey((Object)"logisticsList")) {
            JSONArray jsonArray = data.getJSONArray("logisticsList");
            JSONArray array3 = new JSONArray();
            for (int i = 0; i < jsonArray.size(); ++i) {
                JSONObject object = jsonArray.getJSONObject(i);
                String logistics_code = object.getString("logistics_code");
                String shipper_code = object.getString("shipper_code");
                JSONArray array1 = object.getJSONArray("product_list");
                JSONArray array2 = new JSONArray();
                if (null != array1) {
                    for (int j = 0; j < array1.size(); ++j) {
                        JSONObject jsonObject = array1.getJSONObject(j);
                        jsonObject.put("product_price", (Object)jsonObject.getDoubleValue("product_price"));
                        jsonObject.put("product_num", (Object)jsonObject.getIntValue("product_num"));
                        jsonObject.put("product_amount", (Object)jsonObject.getDoubleValue("product_amount"));
                        array2.add((Object)jsonObject);
                    }
                }
                object.put("product_list", (Object)array2);
                array3.add((Object)object);
            }
            basicDBObject.set("logisticsList", (Object)array3);
            JSONArray logistics_info = data.getJSONArray("logisticsList");
            if (null != logistics_info) {
                for (int i = 0; i < logistics_info.size(); ++i) {
                    this.insertlogisict(logistics_info.getJSONObject(i));
                }
            }
        }
        String pay_status = "";
        if (data.containsKey((Object)"pay_info")) {
            basicDBObject.set("pay_info", (Object)data.getJSONObject("pay_info"));
            if (data.getJSONObject("pay_info").containsKey((Object)"pay_status")) {
                pay_status = data.getJSONObject("pay_info").getString("pay_status");
                if (StringUtils.isNull((Object)pay_status)) {
                    String is_pay = data.getJSONObject("pay_info").getString("is_pay");
                    pay_status = "Y".equals(is_pay) ? "1" : "0";
                }
                basicDBObject.set("pay_status", (Object)pay_status);
                if ("1".equals(pay_status)) {
                    String corp_code = order.getProductList().getJSONObject(0).getString("corp_code");
                    if ("C10041".equals(corp_code)) {
                        this.redisClient.getValueOps().setValueString("Order_" + corp_code + order.getOrder_no(), JSON.toJSONString((Object)order));
                    }
                    basicDBObject.set("pay_date", (Object)TimeUtils.getCurrentTimeInString((SimpleDateFormat)TimeUtils.DATETIME_FORMAT_DATE));
                }
            }
            if (data.getJSONObject("pay_info").containsKey((Object)"pay_way")) {
                String pay_way = data.getJSONObject("pay_info").getString("pay_way");
                if ("online".equals(pay_way)) {
                    basicDBObject.set("is_online_pay", (Object)"Y");
                }
                if ("offline".equals(pay_way)) {
                    basicDBObject.set("is_online_pay", (Object)"N");
                }
            }
        }
        if (!order_no.startsWith("WX") && "1".equals(old_pay_status) && "0".equals(pay_status)) {
            JSONObject da = new JSONObject();
            da.put("message", (Object)"\u4fee\u6539\u5931\u8d25");
            return dataResponse.setStatus(Status.FAILED).setCode("-1").setId(dataRequest.getId()).setData(da).setMsg("\u8ba2\u5355\u5df2\u652f\u4ed8");
        }
        if (data.containsKey((Object)"express_info")) {
            JSONObject a = data.getJSONObject("express_info");
            if (a.containsKey((Object)"address")) {
                Vip vip;
                JSONObject address = a.getJSONObject("address");
                String vip_phone = address.getString("phone");
                if (StringUtils.isNotNull((Object)vip_id) && address.size() > 0 && (vip = (Vip)this.mongoTemplate.findOne(Query.query((CriteriaDefinition)Criteria.where((String)"vip_id").is((Object)vip_id)), Vip.class)) != null && StringUtils.isNull((Object)vip.getVip_phone())) {
                    log.info("\u6536\u8d27\u5730\u5740\u66f4\u65b0\u624b\u673a\u53f7");
                    this.mongoTemplate.upsert(Query.query((CriteriaDefinition)Criteria.where((String)"vip_id").is((Object)vip_id)), Update.update((String)"vip_phone", (Object)vip_phone), Vip.class);
                }
            }
            if (StringUtils.isNotNull((Object)data.get((Object)"logisticsList"))) {
                a.put("is_self_pick", (Object)"N");
            }
            basicDBObject.set("express_info", (Object)a);
        }
        if ("1".equals(pay_status)) {
            Vip vip;
            if (("N".equals(is_online_pay) || "offline".equals(trade_type)) && null != (vip = (Vip)this.mongoTemplate.findOne(Query.query((CriteriaDefinition)Criteria.where((String)"vip_id").is((Object)vip_id)), Vip.class)) && StringUtils.isNull((Object)vip.getVip_phone())) {
                return dataResponse.setStatus(Status.FAILED).setCode("-1").setId(dataRequest.getId()).setMsg("\u8bf7\u5148\u7ef4\u62a4\u4f1a\u5458\u624b\u673a\u53f7");
            }
            basicDBObject.set("pay_date", (Object)TimeUtils.getCurrentTimeInString((SimpleDateFormat)TimeUtils.DATETIME_FORMAT_DATE));
        }
        if (data.containsKey((Object)"recurrence")) {
            basicDBObject.set("recurrence", (Object)data.getJSONObject("recurrence"));
        }
        basicDBObject.set("modified_date", (Object)TimeUtils.getCurrentTimeInString((SimpleDateFormat)TimeUtils.DATETIME_FORMAT_DATE));
        try {
            this.unUseCoupon(order);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"order_id").is((Object)_id));
        log.info("update>>" + basicDBObject + ">>>>>>>>>query>>>>>>>" + query);
        WriteResult writeResult = this.mongoTemplate.upsert(query, basicDBObject, "def_order");
        if (writeResult.getN() > 0) {
            DataRequest adjuststockRequest = new DataRequest();
            JSONObject datarequest = new JSONObject();
            if (data.containsKey((Object)"productList")) {
                datarequest.put("productList", (Object)data.getJSONArray("productList"));
            } else {
                datarequest.put("productList", (Object)productList);
            }
            datarequest.put("user_id", (Object)data.getString("user_id"));
            datarequest.put("order_no", (Object)order.getOrder_no());
            datarequest.put("type", (Object)"mod");
            datarequest.put("pay_status", (Object)pay_status);
            if (StringUtils.isNull((Object)order.getIs_online_pay())) {
                datarequest.put("trade_type", (Object)order.getTrade_type());
            } else {
                datarequest.put("is_online_pay", (Object)order.getIs_online_pay());
            }
            adjuststockRequest.setData(datarequest);
            9 adjuststock = new /* Unavailable Anonymous Inner Class!! */;
            try {
                Thread t = new Thread((Runnable)adjuststock);
                t.start();
            }
            catch (Exception e) {
                log.error("set message error:" + e.getLocalizedMessage(), (Throwable)e);
            }
            if (pay_status.equals("1")) {
                DataRequest dataRequest1 = new DataRequest();
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("order_id", (Object)_id);
                dataRequest1.setData(jsonObject);
                log.info("--mod--\u6d88\u8d39\u53d1\u5238----" + jsonObject);
                DataResponse dataResponse1 = this.couponService.getData("/coupon/orderPaySuccessSendCoupon", dataRequest1);
                log.info("--mod--\u6d88\u8d39\u53d1\u8fd4\u56de----" + dataResponse1);
                10 createOfflineCreate = new /* Unavailable Anonymous Inner Class!! */;
                try {
                    Thread t = new Thread((Runnable)createOfflineCreate);
                    t.start();
                }
                catch (Exception e) {
                    log.error("set message error:" + e.getLocalizedMessage(), (Throwable)e);
                }
                if (old_pay_status.equals("1")) {
                    writeResult = this.mongoTemplate.updateMulti(query, basicDBObject, "def_order_detail");
                } else if (old_pay_status.equals("0")) {
                    BasicDBObject order_query = new BasicDBObject("order_id", (Object)order.getOrder_id());
                    BasicDBObject unwind = new BasicDBObject("$unwind", (Object)"$productList");
                    BasicDBObject match = new BasicDBObject("$match", (Object)order_query);
                    AggregationOutput aggregationOutput = this.mongoTemplate.getCollection("def_order").aggregate((DBObject)unwind, new DBObject[]{match});
                    ArrayList<DBObject> list = new ArrayList<DBObject>();
                    for (DBObject object : aggregationOutput.results()) {
                        object.removeField("_id");
                        list.add(object);
                    }
                    WriteResult writeResult1 = this.mongoTemplate.getCollection("def_order_detail").insert(list);
                    if (StringUtils.isNotNull((Object)team_id)) {
                        try {
                            TeamNews news = new TeamNews();
                            news.setNews_type("addOrder");
                            news.setTeam_id(team_id);
                            news.setUser_id(order.getUser_id());
                            JSONObject news_obj = JSON.parseObject((String)news.toString());
                            JSONObject order_obj = JSONObject.parseObject((String)order.toString());
                            order_obj.remove((Object)"_id");
                            news_obj.put("news_value", (Object)order_obj);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }
            }
            JSONObject da = new JSONObject();
            da.put("message", (Object)"\u4fee\u6539\u6210\u529f");
            dataResponse.setStatus(Status.SUCCESS).setCode("0").setId(dataRequest.getId()).setData(da);
        } else {
            JSONObject da = new JSONObject();
            da.put("message", (Object)"\u4fee\u6539\u5931\u8d25");
            dataResponse.setStatus(Status.FAILED).setCode("-1").setId(dataRequest.getId()).setData(da).setMsg("\u4fee\u6539\u5931\u8d25");
        }
        return dataResponse;
    }

    public void sysStock() {
        List productList = this.mongoTemplate.find(Query.query((CriteriaDefinition)Criteria.where((String)"stock_num").ne(null)), Product.class);
        for (int i = 0; i < productList.size(); ++i) {
            Product product = (Product)productList.get(i);
            String stock_num = product.getStock_num();
            String time = TimeUtils.getTime((long)System.currentTimeMillis());
            String product_id = product.getProduct_id();
            String user_id = product.getUser_id();
            String corp_code = product.getCorp_code();
            BasicDBObject match1 = new BasicDBObject();
            match1.put((Object)"pay_status", (Object)"1");
            match1.put((Object)"is_active", (Object)"Y");
            match1.put((Object)"productList.product_id", (Object)product_id);
            BasicDBObject basicDBObject_ = new BasicDBObject();
            basicDBObject_.put((Object)"_id", (Object)"$productList.product_id");
            basicDBObject_.put((Object)"count", (Object)new BasicDBObject("$sum", (Object)"$productList.product_num"));
            BasicDBObject group1 = new BasicDBObject("$group", (Object)basicDBObject_);
            AggregationOutput aggregate = this.mongoTemplate.getCollection("def_order").aggregate((DBObject)new BasicDBObject("$unwind", (Object)"$productList"), new DBObject[]{new BasicDBObject("$match", (Object)match1), group1});
            int num_sales = 0;
            for (DBObject obj : aggregate.results()) {
                BasicDBObject dbObject1 = (BasicDBObject)obj;
                num_sales = Integer.parseInt(dbObject1.get("count").toString());
            }
            int last = 0;
            if (StringUtils.isNotNull((Object)stock_num)) {
                int stock_num_int = Integer.parseInt(stock_num);
                last = stock_num_int - num_sales;
            }
            if (last > 0) {
                ProductStock stock = new ProductStock();
                stock.setIs_active("Y");
                stock.setCreated_date(time);
                if (StringUtils.isNotNull((Object)corp_code)) {
                    stock.setCorp_code(corp_code);
                }
                stock.setCreator_id(user_id);
                stock.setModified_date(time);
                stock.setModifier_id(user_id);
                stock.setProduct_id(product_id);
                stock.setStock_num(last);
                stock.setType("manualSet");
                this.mongoTemplate.save((Object)stock);
            }
            DBCollection collection_order_param = this.mongoTemplate.getCollection("def_order_param");
            DBObject dbObject = collection_order_param.findOne();
            int over_time = 12;
            if (null != dbObject && dbObject.containsField("order_overdue_time")) {
                over_time = Integer.parseInt(dbObject.get("order_overdue_time").toString());
            }
            match1 = new BasicDBObject();
            match1.put((Object)"created_date", (Object)new BasicDBObject("$gte", (Object)TimeUtils.getBeforeTime((int)(-over_time))));
            match1.put((Object)"pay_status", (Object)"0");
            match1.put((Object)"productList.product_id", (Object)product_id);
            match1.put((Object)"is_active", (Object)"Y");
            aggregate = this.mongoTemplate.getCollection("def_order").aggregate((DBObject)new BasicDBObject("$unwind", (Object)"$productList"), new DBObject[]{new BasicDBObject("$match", (Object)match1)});
            for (DBObject obj : aggregate.results()) {
                Map map = obj.toMap();
                String created_date = String.valueOf(map.get("created_date"));
                String is_online_pay = String.valueOf(map.get("is_online_pay"));
                int product_num = Integer.parseInt(String.valueOf(map.get("product_num")));
                ProductStock stock = new ProductStock();
                stock.setIs_active("Y");
                if (StringUtils.isNotNull((Object)corp_code)) {
                    stock.setCorp_code(corp_code);
                }
                stock.setCreator_id(user_id);
                stock.setModified_date(time);
                stock.setModifier_id(user_id);
                stock.setProduct_id(product_id);
                stock.setStock_num(-product_num);
                stock.setType("order");
                stock.setIs_online_pay(is_online_pay);
                stock.setPay_status("0");
                stock.setCreated_date(created_date);
                this.mongoTemplate.save((Object)stock);
            }
        }
    }

    public boolean checkStockV2(JSONObject object, Product product) {
        log.info("\u5224\u65ad\u5e93\u5b58" + object + "----" + product);
        boolean flag = false;
        DBCollection collection = this.mongoTemplate.getCollection("def_product_stock");
        String product_id = object.getString("product_id");
        int product_num = object.getIntValue("product_num");
        String sku_id = object.getString("sku_id");
        String order_no = object.getString("order_no");
        DBObject dbObject = this.mongoTemplate.getCollection("def_order_param").findOne();
        int over_time = 12;
        if (null != dbObject && dbObject.containsField("order_overdue_time")) {
            over_time = Integer.parseInt(dbObject.get("order_overdue_time").toString());
        }
        DBCollection collection1 = this.mongoTemplate.getCollection("def_order");
        double num_sales = 0.0;
        if (StringUtils.isNull((Object)sku_id)) {
            BasicDBObject object1 = new BasicDBObject();
            object1.put((Object)"pay_status", (Object)"1");
            object1.put((Object)"trade_type", (Object)"online");
            BasicDBObject object2 = new BasicDBObject();
            object2.put((Object)"created_date", (Object)new BasicDBObject("$gte", (Object)TimeUtils.getBeforeTime((int)(-over_time))));
            object2.put((Object)"pay_status", (Object)"0");
            object2.put((Object)"trade_type", (Object)"online");
            BasicDBList basicDBList = new BasicDBList();
            basicDBList.add((Object)object1);
            basicDBList.add((Object)object2);
            BasicDBObject matchs = new BasicDBObject("$or", (Object)basicDBList);
            matchs.put((Object)"productList.product_id", (Object)product_id);
            matchs.put((Object)"is_active", (Object)"Y");
            BasicDBObject group = new BasicDBObject();
            group.put((Object)"_id", (Object)"$productList.product_id");
            group.put((Object)"count", (Object)new BasicDBObject("$sum", (Object)"$productList.product_num"));
            AggregationOutput aggregate = collection1.aggregate((DBObject)new BasicDBObject("$unwind", (Object)"$productList"), new DBObject[]{new BasicDBObject("$match", (Object)matchs), new BasicDBObject("$group", (Object)group)});
            for (DBObject obj : aggregate.results()) {
                BasicDBObject dbObject1 = (BasicDBObject)obj;
                double num_sale = Double.parseDouble(dbObject1.get("count").toString());
                if (null == product.getStock_num() || !((double)Integer.valueOf(product.getStock_num()).intValue() < num_sale + (double)product_num)) continue;
                flag = true;
            }
        } else {
            BasicDBObject matchs = new BasicDBObject();
            matchs.put((Object)"product_id", (Object)product_id);
            matchs.put((Object)"is_active", (Object)"Y");
            matchs.put((Object)"sku_id", (Object)sku_id);
            BasicDBList basicDBList = new BasicDBList();
            BasicDBObject match = new BasicDBObject();
            match.put((Object)"pay_status", (Object)"1");
            match.put((Object)"trade_type", (Object)"online");
            match.put((Object)"type", (Object)"order");
            BasicDBObject match1 = new BasicDBObject();
            match1.put((Object)"created_date", (Object)new BasicDBObject("$gte", (Object)TimeUtils.getBeforeTime((int)(-over_time))));
            match1.put((Object)"pay_status", (Object)"0");
            if (StringUtils.isNotNull((Object)order_no)) {
                match1.put((Object)"order_no", (Object)new BasicDBObject("$ne", (Object)order_no));
            }
            match1.put((Object)"trade_type", (Object)"online");
            match1.put((Object)"type", (Object)"order");
            BasicDBObject match2 = new BasicDBObject();
            match2.put((Object)"type", (Object)"manualSet");
            basicDBList.add((Object)match);
            basicDBList.add((Object)match1);
            basicDBList.add((Object)match2);
            matchs.put((Object)"$or", (Object)basicDBList);
            log.info("check stock :" + matchs);
            BasicDBObject group = new BasicDBObject();
            group.put((Object)"_id", (Object)1);
            group.put((Object)"count", (Object)new BasicDBObject("$sum", (Object)"$stock_num"));
            AggregationOutput aggregate = collection.aggregate((DBObject)new BasicDBObject("$match", (Object)matchs), new DBObject[]{new BasicDBObject("$group", (Object)group)});
            for (DBObject obj : aggregate.results()) {
                num_sales = Double.parseDouble(obj.get("count").toString());
                log.debug("check stock last:" + obj.toString());
                if (!(num_sales < (double)product_num)) continue;
                flag = true;
            }
        }
        return flag;
    }

    public boolean checkStock(JSONObject object, Product product) {
        log.info("\u5224\u65ad\u5e93\u5b58" + object + "----" + product);
        boolean flag = false;
        String product_id = object.getString("product_id");
        int product_num = object.getIntValue("product_num");
        String sku_id = object.getString("sku_id");
        String unified_order = object.getString("unified_order");
        String corp_code = product.getCorp_code();
        DBObject dbObject = this.mongoTemplate.getCollection("def_order_param").findOne();
        int over_time = 12;
        if (null != dbObject && dbObject.containsField("order_overdue_time")) {
            over_time = Integer.parseInt(dbObject.get("order_overdue_time").toString());
        }
        DBCollection collection1 = this.mongoTemplate.getCollection("def_order");
        if (StringUtils.isNull((Object)sku_id)) {
            BasicDBObject object1 = new BasicDBObject();
            object1.put((Object)"pay_status", (Object)"1");
            object1.put((Object)"trade_type", (Object)"online");
            BasicDBObject object2 = new BasicDBObject();
            object2.put((Object)"created_date", (Object)new BasicDBObject("$gte", (Object)TimeUtils.getBeforeTime((int)(-over_time))));
            object2.put((Object)"pay_status", (Object)"0");
            object2.put((Object)"trade_type", (Object)"online");
            BasicDBList basicDBList = new BasicDBList();
            basicDBList.add((Object)object1);
            basicDBList.add((Object)object2);
            BasicDBObject matchs = new BasicDBObject("$or", (Object)basicDBList);
            matchs.put((Object)"productList.product_id", (Object)product_id);
            matchs.put((Object)"is_active", (Object)"Y");
            BasicDBObject group = new BasicDBObject();
            group.put((Object)"_id", (Object)"$productList.product_id");
            group.put((Object)"count", (Object)new BasicDBObject("$sum", (Object)"$productList.product_num"));
            AggregationOutput aggregate = collection1.aggregate((DBObject)new BasicDBObject("$unwind", (Object)"$productList"), new DBObject[]{new BasicDBObject("$match", (Object)matchs), new BasicDBObject("$group", (Object)group)});
            for (DBObject obj : aggregate.results()) {
                BasicDBObject dbObject1 = (BasicDBObject)obj;
                double num_sale = Double.parseDouble(dbObject1.get("count").toString());
                if (null == product.getStock_num() || !((double)Integer.valueOf(product.getStock_num()).intValue() < num_sale + (double)product_num)) continue;
                flag = true;
            }
        } else {
            String occupied_stock;
            BasicDBObject matchs = new BasicDBObject();
            matchs.put((Object)"product_id", (Object)product_id);
            matchs.put((Object)"is_active", (Object)"Y");
            matchs.put((Object)"sku_id", (Object)sku_id);
            DBObject object_sku_stock = this.mongoTemplate.getCollection("def_sku_stock").findOne((DBObject)new BasicDBObject("product_id", (Object)product_id).append("sku_id", (Object)sku_id));
            if (StringUtils.isNull((Object)object_sku_stock)) {
                return true;
            }
            int left_stock = JSONObject.parseObject((String)object_sku_stock.toString()).getInteger("left_stock");
            Object temp_object = this.redisTemplate.opsForValue().get((Object)("STOCK" + product_id + sku_id));
            String string = occupied_stock = temp_object != null ? temp_object.toString() : "0";
            if (product_num > left_stock - Integer.parseInt(occupied_stock)) {
                if (StringUtils.isNotNull((Object)unified_order)) {
                    return !"Y".equals(unified_order);
                }
                return true;
            }
        }
        return flag;
    }

    public boolean checkStockV3(JSONObject object, Product product) {
        boolean flag;
        block23: {
            AggregationOutput aggregate;
            BasicDBObject basicDBObject1;
            BasicDBObject match;
            BasicDBList basicDBList;
            int over_time;
            BasicDBObject group;
            BasicDBObject basicDBObject_;
            BasicDBObject matchs;
            String trade_type;
            int product_num;
            String product_id;
            block21: {
                block22: {
                    flag = false;
                    DBCollection collection = this.mongoTemplate.getCollection("def_product_stock");
                    product_id = object.getString("product_id");
                    product_num = object.getIntValue("product_num");
                    String sku_id = object.getString("sku_id");
                    String team_id = object.getString("team_id");
                    String is_online_pay = object.getString("is_online_pay");
                    trade_type = object.getString("trade_type");
                    if ("N".equals(is_online_pay)) {
                        return flag;
                    }
                    if (StringUtils.isNotNull((Object)trade_type)) {
                        if (!"online".equals(trade_type)) {
                            return flag;
                        }
                    } else {
                        trade_type = "Y".equals(is_online_pay) ? "online" : "offline";
                    }
                    matchs = new BasicDBObject();
                    if (StringUtils.isNull((Object)team_id)) {
                        matchs.put((Object)"product_id", (Object)product_id);
                        if (StringUtils.isNotNull((Object)product.getCorp_code())) {
                            matchs.put((Object)"corp_code", (Object)product.getCorp_code());
                        }
                        matchs.put((Object)"is_active", (Object)"Y");
                        matchs.put((Object)"team_id", null);
                        if (StringUtils.isNotNull((Object)sku_id)) {
                            matchs.put((Object)"sku_id", (Object)sku_id);
                        }
                    } else {
                        matchs.put((Object)"product_id", (Object)product_id);
                        String team_relation_id = "";
                        TeamProduct teamProduct = (TeamProduct)this.mongoTemplate.findOne(Query.query((CriteriaDefinition)Criteria.where((String)"team_id").is((Object)team_id).and("product_id").is((Object)product_id)), TeamProduct.class);
                        JSONArray array = teamProduct.getTeam_stock_list();
                        if (null != array) {
                            if (StringUtils.isNotNull((Object)sku_id)) {
                                for (int i = 0; i < array.size(); ++i) {
                                    JSONObject jsonObject = array.getJSONObject(i);
                                    if (!jsonObject.containsValue((Object)sku_id)) continue;
                                    team_relation_id = jsonObject.getString("team_id");
                                }
                            } else if (array.size() == 1) {
                                team_relation_id = array.getJSONObject(0).getString("team_id");
                            }
                        }
                        if (StringUtils.isNotNull((Object)team_relation_id)) {
                            matchs.put((Object)"team_id", (Object)team_relation_id);
                        } else {
                            matchs.put((Object)"team_id", null);
                        }
                        matchs.put((Object)"is_active", (Object)"Y");
                        if (StringUtils.isNotNull((Object)sku_id)) {
                            matchs.put((Object)"sku_id", (Object)sku_id);
                        }
                    }
                    basicDBObject_ = new BasicDBObject();
                    basicDBObject_.put((Object)"_id", (Object)1);
                    basicDBObject_.put((Object)"count", (Object)new BasicDBObject("$sum", (Object)"$stock_num"));
                    group = new BasicDBObject("$group", (Object)basicDBObject_);
                    DBCollection collection_order_param = this.mongoTemplate.getCollection("def_order_param");
                    DBObject dbObject = collection_order_param.findOne();
                    over_time = 12;
                    if (null != dbObject && dbObject.containsField("order_overdue_time")) {
                        over_time = Integer.parseInt(dbObject.get("order_overdue_time").toString());
                    }
                    basicDBList = new BasicDBList();
                    match = new BasicDBObject();
                    match.put((Object)"pay_status", (Object)"1");
                    match.put((Object)"trade_type", (Object)"online");
                    match.put((Object)"type", (Object)"order");
                    basicDBObject1 = new BasicDBObject();
                    basicDBObject1.put((Object)"created_date", (Object)new BasicDBObject("$gte", (Object)TimeUtils.getBeforeTime((int)(-over_time))));
                    basicDBObject1.put((Object)"pay_status", (Object)"0");
                    basicDBObject1.put((Object)"trade_type", (Object)"online");
                    basicDBObject1.put((Object)"type", (Object)"order");
                    BasicDBObject match1 = new BasicDBObject();
                    match1.put((Object)"type", (Object)"manualSet");
                    basicDBList.add((Object)basicDBObject1);
                    basicDBList.add((Object)match);
                    basicDBList.add((Object)match1);
                    matchs.put((Object)"$or", (Object)basicDBList);
                    log.info((Object)matchs);
                    aggregate = collection.aggregate((DBObject)new BasicDBObject("$match", (Object)matchs), new DBObject[]{group});
                    int num_sales = 0;
                    boolean flags = false;
                    if (null == aggregate) break block21;
                    for (DBObject obj : aggregate.results()) {
                        BasicDBObject dbObject1 = (BasicDBObject)obj;
                        num_sales = Integer.parseInt(dbObject1.get("count").toString());
                        flags = true;
                    }
                    if (!flags) break block22;
                    if (num_sales >= product_num) break block23;
                    flag = true;
                    break block23;
                }
                if (!"online".equals(trade_type) || !StringUtils.isNotNull((Object)product.getStock_num())) break block23;
                DBCollection collection1 = this.mongoTemplate.getCollection("def_order");
                basicDBList = new BasicDBList();
                match = new BasicDBObject();
                match.put((Object)"pay_status", (Object)"1");
                match.put((Object)"trade_type", (Object)"online");
                basicDBObject1 = new BasicDBObject();
                basicDBObject1.put((Object)"created_date", (Object)new BasicDBObject("$gte", (Object)TimeUtils.getBeforeTime((int)(-over_time))));
                basicDBObject1.put((Object)"pay_status", (Object)"0");
                basicDBObject1.put((Object)"trade_type", (Object)"online");
                basicDBList.add((Object)basicDBObject1);
                basicDBList.add((Object)match);
                matchs = new BasicDBObject("$or", (Object)basicDBList);
                matchs.put((Object)"productList.product_id", (Object)product_id);
                matchs.put((Object)"is_active", (Object)"Y");
                basicDBObject_ = new BasicDBObject();
                basicDBObject_.put((Object)"_id", (Object)"$productList.product_id");
                basicDBObject_.put((Object)"count", (Object)new BasicDBObject("$sum", (Object)"$productList.product_num"));
                group = new BasicDBObject("$group", (Object)basicDBObject_);
                aggregate = collection1.aggregate((DBObject)new BasicDBObject("$unwind", (Object)"$productList"), new DBObject[]{new BasicDBObject("$match", (Object)matchs), group});
                for (DBObject obj : aggregate.results()) {
                    BasicDBObject dbObject1 = (BasicDBObject)obj;
                    int num_sale = Integer.parseInt(dbObject1.get("count").toString());
                    if (Integer.valueOf(product.getStock_num()) >= num_sale + product_num) continue;
                    flag = true;
                }
                break block23;
            }
            if ("online".equals(trade_type) && StringUtils.isNotNull((Object)product.getStock_num())) {
                DBCollection collection1 = this.mongoTemplate.getCollection("def_order");
                basicDBList = new BasicDBList();
                match = new BasicDBObject();
                match.put((Object)"pay_status", (Object)"1");
                match.put((Object)"trade_type", (Object)"online");
                basicDBObject1 = new BasicDBObject();
                basicDBObject1.put((Object)"created_date", (Object)new BasicDBObject("$gte", (Object)TimeUtils.getBeforeTime((int)(-over_time))));
                basicDBObject1.put((Object)"pay_status", (Object)"0");
                basicDBObject1.put((Object)"trade_type", (Object)"online");
                basicDBList.add((Object)basicDBObject1);
                basicDBList.add((Object)match);
                matchs = new BasicDBObject("$or", (Object)basicDBList);
                matchs.put((Object)"productList.product_id", (Object)product_id);
                matchs.put((Object)"is_active", (Object)"Y");
                basicDBObject_ = new BasicDBObject();
                basicDBObject_.put((Object)"_id", (Object)"$productList.product_id");
                basicDBObject_.put((Object)"count", (Object)new BasicDBObject("$sum", (Object)"$productList.product_num"));
                group = new BasicDBObject("$group", (Object)basicDBObject_);
                aggregate = collection1.aggregate((DBObject)new BasicDBObject("$unwind", (Object)"$productList"), new DBObject[]{new BasicDBObject("$match", (Object)matchs), group});
                for (DBObject obj : aggregate.results()) {
                    BasicDBObject dbObject1 = (BasicDBObject)obj;
                    int num_sale = Integer.parseInt(dbObject1.get("count").toString());
                    if (Integer.valueOf(product.getStock_num()) >= num_sale + product_num) continue;
                    flag = true;
                }
            }
        }
        return flag;
    }

    public DataResponse adjustStock(DataRequest dataRequest) {
        JSONObject data = dataRequest.getData();
        String user_id = data.getString("user_id");
        String order_no = data.getString("order_no");
        String type = data.getString("type");
        String pay_status = data.getString("pay_status");
        if (StringUtils.isNull((Object)pay_status)) {
            JSONObject object = new JSONObject();
            object.putAll((Map)data);
            object.put("time", (Object)TimeUtils.getTime((long)System.currentTimeMillis()));
            this.mongoTemplate.save((Object)object, "log_stock_error");
        }
        String is_online_pay = data.getString("is_online_pay");
        String trade_type = data.getString("trade_type");
        if (StringUtils.isNull((Object)trade_type)) {
            trade_type = "Y".equals(is_online_pay) ? "online" : ("N".equals(is_online_pay) ? "offline" : "online");
        }
        String time = TimeUtils.getTime((long)System.currentTimeMillis());
        JSONArray array = data.getJSONArray("productList");
        if ("mod".equals(type)) {
            this.mongoTemplate.remove(Query.query((CriteriaDefinition)Criteria.where((String)"order_no").is((Object)order_no)), ProductStock.class);
        }
        if ("del".equals(type)) {
            this.mongoTemplate.updateMulti(Query.query((CriteriaDefinition)Criteria.where((String)"order_no").is((Object)order_no)), Update.update((String)"is_active", (Object)"N"), ProductStock.class);
        }
        for (int i = 0; i < array.size(); ++i) {
            JSONObject object = array.getJSONObject(i);
            String corp_code = object.getString("corp_code");
            String is_group = object.getString("is_group");
            int product_num = object.getIntValue("product_num");
            if (!"Y".equals(is_group)) {
                String team_id = object.getString("team_id");
                String team_relation_id = "";
                String product_id = object.getString("product_id");
                String sku_id = object.getString("sku_id");
                if (!"add".equals(type) && !"mod".equals(type)) continue;
                ProductStock stock = new ProductStock();
                stock.setOrder_no(order_no);
                stock.setPay_status(pay_status);
                stock.setIs_online_pay("Y");
                stock.setTrade_type(trade_type);
                stock.setIs_active("Y");
                stock.setTeam_relation_id(team_relation_id);
                stock.setCreated_date(time);
                if (StringUtils.isNotNull((Object)corp_code)) {
                    stock.setCorp_code(corp_code);
                }
                stock.setCreator_id(user_id);
                stock.setModified_date(time);
                stock.setModifier_id(user_id);
                stock.setProduct_id(product_id);
                if (StringUtils.isNotNull((Object)sku_id)) {
                    stock.setSku_id(sku_id);
                }
                stock.setStock_num(-1 * product_num);
                stock.setType("order");
                this.mongoTemplate.save((Object)stock);
                continue;
            }
            JSONArray select_group_info = object.getJSONArray("select_group_info");
            for (int j = 0; j < select_group_info.size(); ++j) {
                JSONObject jsonObject = select_group_info.getJSONObject(j);
                String team_id = object.getString("team_id");
                String team_relation_id = "";
                String product_id = jsonObject.getString("product_id");
                String sku_id = jsonObject.getJSONObject("select_sku").getString("sku_id");
                Integer sku_num = jsonObject.getJSONObject("select_sku").getInteger("num");
                if (!"add".equals(type) && !"mod".equals(type)) continue;
                ProductStock stock = new ProductStock();
                stock.setOrder_no(order_no);
                stock.setPay_status(pay_status);
                stock.setIs_online_pay("Y");
                stock.setTrade_type(trade_type);
                stock.setIs_active("Y");
                stock.setTeam_relation_id(team_relation_id);
                stock.setCreated_date(time);
                if (StringUtils.isNotNull((Object)corp_code)) {
                    stock.setCorp_code(corp_code);
                }
                stock.setCreator_id(user_id);
                stock.setModified_date(time);
                stock.setModifier_id(user_id);
                stock.setProduct_id(product_id);
                if (StringUtils.isNotNull((Object)sku_id)) {
                    stock.setSku_id(sku_id);
                }
                stock.setStock_num(-1 * product_num * sku_num);
                stock.setType("order");
                this.mongoTemplate.save((Object)stock);
            }
        }
        return new DataResponse().setStatus(Status.SUCCESS).setCode("0");
    }

    public DataResponse checkStock(DataRequest dataRequest) {
        JSONObject data = dataRequest.getData();
        String product_id = data.getString("product_id");
        Product product = (Product)this.mongoTemplate.findOne(Query.query((CriteriaDefinition)Criteria.where((String)"product_id").is((Object)product_id).and("is_active").is((Object)"Y")), Product.class);
        boolean s = this.checkStock(data, product);
        if (!s) {
            return new DataResponse().setCode("0").setStatus(Status.SUCCESS);
        }
        return new DataResponse().setCode("-1").setStatus(Status.FAILED).setMsg("\u5e93\u5b58\u4e0d\u8db3");
    }

    public DataResponse orderDetail(DataRequest dataRequest) {
        JSONObject data1;
        DataResponse dataResponse;
        block64: {
            String time_Y;
            String time;
            List teamIds;
            JSONArray commission_data;
            Integer page_size;
            Integer page_num;
            String query_type;
            String tag;
            String type;
            String team_id;
            block65: {
                block63: {
                    dataResponse = new DataResponse();
                    JSONObject data = dataRequest.getData();
                    String user_id = data.getString("user_id");
                    team_id = data.getString("team_id");
                    type = data.getString("type");
                    tag = data.getString("tag");
                    query_type = data.getString("query_type");
                    page_num = data.getInteger("page_num");
                    page_size = data.getInteger("page_size");
                    data1 = new JSONObject();
                    commission_data = new JSONArray();
                    teamIds = new ArrayList();
                    if (StringUtils.isNotNull((Object)tag)) {
                        if ("0".equalsIgnoreCase(tag)) {
                            JSONObject team_info = new JSONObject();
                            JSONObject team = new JSONObject();
                            team.put("team_id", (Object)team_id);
                            team.put("is_contains_self", (Object)"Y");
                            team.put("is_all_child", (Object)"Y");
                            try {
                                team_info = this.teamAgent.getData(team, "/team/getChildTeams");
                            }
                            catch (Exception e) {
                                log.error("get team_info error:" + e.getLocalizedMessage(), (Throwable)e);
                            }
                            teamIds = (List)team_info.get((Object)"list");
                        } else {
                            commission_data.add((Object)user_id);
                        }
                    } else {
                        commission_data.add((Object)user_id);
                    }
                    if (!"0".equals(type)) break block63;
                    time = TimeUtils.getCurrentTimeInString((SimpleDateFormat)TimeUtils.DATE_FORMAT_DATE_NO);
                    time_Y = "";
                    String time_M = "";
                    String time_D = "";
                    String[] strings = new String[]{};
                    try {
                        strings = TimeUtils.convertTime((String)time).split(",");
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    time_Y = strings[0];
                    time_M = strings[1];
                    time_D = strings[3];
                    BasicDBObject basic = new BasicDBObject();
                    BasicDBObject query = new BasicDBObject();
                    if (StringUtils.isNotNull((Object)query_type)) {
                        if ("all".equals(query_type)) {
                            // empty if block
                        }
                        if ("daily".equals(query_type)) {
                            basic.put((Object)"$regex", (Object)(time_Y + "-" + time_M + "-" + time_D));
                            query.put((Object)"created_date", (Object)basic);
                        }
                        if ("monthly".equals(query_type)) {
                            basic.put((Object)"$regex", (Object)(time_Y + "-" + time_M));
                            query.put((Object)"created_date", (Object)basic);
                        }
                        if ("yearly".equals(query_type)) {
                            basic.put((Object)"$regex", (Object)time_Y);
                            query.put((Object)"created_date", (Object)basic);
                        }
                    }
                    if ("0".equals(tag)) {
                        query.put((Object)"exclusive_user", (Object)new BasicDBObject("$ne", null));
                        query.put((Object)"pay_status", (Object)"1");
                        query.put((Object)"productList.team_id", (Object)new BasicDBObject("$in", teamIds));
                    } else {
                        query.put((Object)"exclusive_user", (Object)new BasicDBObject("$in", (Object)commission_data));
                        query.put((Object)"pay_status", (Object)"1");
                        query.put((Object)"productList.team_id", (Object)team_id);
                    }
                    log.info((Object)query);
                    JSONObject jsonObject = this.mongodbUtils.queryByPage(page_size.intValue(), page_num.intValue(), query, new BasicDBObject("created_date", (Object)-1), "def_order");
                    JSONArray list = jsonObject.getJSONArray("list");
                    JSONArray jsonArray1 = new JSONArray();
                    for (int i = 0; i < list.size(); ++i) {
                        JSONObject order = list.getJSONObject(i);
                        if (StringUtils.isNotNull((Object)order.get((Object)"productList"))) {
                            JSONArray productList = JSONObject.parseArray((String)order.get((Object)"productList").toString());
                            JSONArray arr = new JSONArray();
                            if (StringUtils.isNotNull((Object)productList) && productList.size() > 0) {
                                for (int j = 0; j < productList.size(); ++j) {
                                    String sku_id;
                                    JSONArray array1;
                                    JSONObject object = productList.getJSONObject(j);
                                    String first_image_url = object.getString("first_image_url");
                                    if (StringUtils.isNotNull((Object)first_image_url)) {
                                        String authUrl = this.aliCDNUrlAuth.getAuthUrl(first_image_url);
                                        object.put("first_image_url", (Object)authUrl);
                                    }
                                    if (StringUtils.isNotNull((Object)(array1 = object.getJSONArray("product_image_url"))) && array1.size() > 0) {
                                        JSONArray jsonArray = new JSONArray();
                                        for (int z = 0; z < array1.size(); ++z) {
                                            JSONObject object1 = array1.getJSONObject(z);
                                            String image_url = object1.getString("image_url");
                                            if (StringUtils.isNotNull((Object)image_url)) {
                                                String authUrl1 = this.aliCDNUrlAuth.getAuthUrl(image_url);
                                                object1.put("image_url", (Object)authUrl1);
                                            }
                                            jsonArray.add((Object)object1);
                                        }
                                        object.put("product_image_url", (Object)jsonArray);
                                    }
                                    if (StringUtils.isNotNull((Object)(sku_id = object.getString("sku_id")))) {
                                        Query query1 = new Query((CriteriaDefinition)Criteria.where((String)"_id").is((Object)new ObjectId(sku_id)));
                                        Sku sku = (Sku)this.mongoTemplate.findOne(query1, Sku.class);
                                        object.put("sku", (Object)sku);
                                    }
                                    arr.add((Object)object);
                                }
                            }
                            order.put("productList", (Object)arr);
                            jsonArray1.add((Object)order);
                        } else {
                            jsonArray1.add((Object)order);
                        }
                        data1.put("list", (Object)jsonArray1);
                    }
                    break block64;
                }
                if (!"1".equals(type)) break block65;
                time = TimeUtils.getCurrentTimeInString((SimpleDateFormat)TimeUtils.DATE_FORMAT_DATE_NO);
                time_Y = "";
                String time_M = "";
                String time_D = "";
                String[] strings = new String[]{};
                try {
                    strings = TimeUtils.convertTime((String)time).split(",");
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                time_Y = strings[0];
                time_M = strings[1];
                time_D = strings[3];
                BasicDBObject basic = new BasicDBObject();
                BasicDBObject query = new BasicDBObject();
                if (StringUtils.isNotNull((Object)query_type)) {
                    if ("all".equals(query_type)) {
                        // empty if block
                    }
                    if ("daily".equals(query_type)) {
                        basic.put((Object)"$regex", (Object)(time_Y + "-" + time_M + "-" + time_D));
                        query.put((Object)"created_date", (Object)basic);
                    }
                    if ("monthly".equals(query_type)) {
                        basic.put((Object)"$regex", (Object)(time_Y + "-" + time_M));
                        query.put((Object)"created_date", (Object)basic);
                    }
                    if ("yearly".equals(query_type)) {
                        basic.put((Object)"$regex", (Object)time_Y);
                        query.put((Object)"created_date", (Object)basic);
                    }
                }
                if ("0".equals(tag)) {
                    query.put((Object)"user_id", (Object)new BasicDBObject("$ne", null));
                    query.put((Object)"pay_status", (Object)"1");
                    query.put((Object)"productList.team_id", (Object)new BasicDBObject("$in", teamIds));
                } else {
                    query.put((Object)"user_id", (Object)new BasicDBObject("$in", (Object)commission_data));
                    query.put((Object)"pay_status", (Object)"1");
                    query.put((Object)"productList.team_id", (Object)team_id);
                }
                log.info("---\u56e2\u961f\u67e5\u8be2\u8ba2\u5355----" + query);
                JSONObject jsonObject = this.mongodbUtils.queryByPage(page_size.intValue(), page_num.intValue(), query, new BasicDBObject("created_date", (Object)-1), "def_order");
                JSONArray list = jsonObject.getJSONArray("list");
                JSONArray jsonArray1 = new JSONArray();
                for (int i = 0; i < list.size(); ++i) {
                    JSONObject order = list.getJSONObject(i);
                    if (StringUtils.isNotNull((Object)order.get((Object)"productList"))) {
                        JSONArray productList = JSONObject.parseArray((String)order.get((Object)"productList").toString());
                        JSONArray arr = new JSONArray();
                        if (StringUtils.isNotNull((Object)productList) && productList.size() > 0) {
                            for (int j = 0; j < productList.size(); ++j) {
                                String sku_id;
                                JSONArray array1;
                                JSONObject object = productList.getJSONObject(j);
                                String first_image_url = object.getString("first_image_url");
                                if (StringUtils.isNotNull((Object)first_image_url)) {
                                    String authUrl = this.aliCDNUrlAuth.getAuthUrl(first_image_url);
                                    object.put("first_image_url", (Object)authUrl);
                                }
                                if (StringUtils.isNotNull((Object)(array1 = object.getJSONArray("product_image_url"))) && array1.size() > 0) {
                                    JSONArray jsonArray = new JSONArray();
                                    for (int z = 0; z < array1.size(); ++z) {
                                        JSONObject object1 = array1.getJSONObject(z);
                                        String image_url = object1.getString("image_url");
                                        if (StringUtils.isNotNull((Object)image_url)) {
                                            String authUrl1 = this.aliCDNUrlAuth.getAuthUrl(image_url);
                                            object1.put("image_url", (Object)authUrl1);
                                        }
                                        jsonArray.add((Object)object1);
                                    }
                                    object.put("product_image_url", (Object)jsonArray);
                                }
                                if (StringUtils.isNotNull((Object)(sku_id = object.getString("sku_id")))) {
                                    Query query1 = new Query((CriteriaDefinition)Criteria.where((String)"_id").is((Object)new ObjectId(sku_id)));
                                    Sku sku = (Sku)this.mongoTemplate.findOne(query1, Sku.class);
                                    object.put("sku", (Object)sku);
                                }
                                arr.add((Object)object);
                            }
                        }
                        order.put("productList", (Object)arr);
                        jsonArray1.add((Object)order);
                    } else {
                        jsonArray1.add((Object)order);
                    }
                    data1.put("list", (Object)jsonArray1);
                }
                break block64;
            }
            if (!"2".equals(type)) break block64;
            time = TimeUtils.getCurrentTimeInString((SimpleDateFormat)TimeUtils.DATE_FORMAT_DATE_NO);
            time_Y = "";
            String time_M = "";
            String time_D = "";
            String[] strings = new String[]{};
            try {
                strings = TimeUtils.convertTime((String)time).split(",");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            time_Y = strings[0];
            time_M = strings[1];
            time_D = strings[3];
            BasicDBObject basic = new BasicDBObject();
            BasicDBObject query = new BasicDBObject();
            if (StringUtils.isNotNull((Object)query_type)) {
                if ("all".equals(query_type)) {
                    // empty if block
                }
                if ("daily".equals(query_type)) {
                    basic.put((Object)"$regex", (Object)(time_Y + "-" + time_M + "-" + time_D));
                    query.put((Object)"created_date", (Object)basic);
                }
                if ("monthly".equals(query_type)) {
                    basic.put((Object)"$regex", (Object)(time_Y + "-" + time_M));
                    query.put((Object)"created_date", (Object)basic);
                }
                if ("yearly".equals(query_type)) {
                    basic.put((Object)"$regex", (Object)time_Y);
                    query.put((Object)"created_date", (Object)basic);
                }
            }
            if ("0".equals(tag)) {
                query.put((Object)"pay_status", (Object)"1");
                query.put((Object)"order_status", (Object)"1");
                query.put((Object)"productList.team_id", (Object)new BasicDBObject("$in", teamIds));
            } else {
                query.put((Object)"user_id", (Object)new BasicDBObject("$in", (Object)commission_data));
                query.put((Object)"pay_status", (Object)"1");
                query.put((Object)"productList.team_id", (Object)team_id);
            }
            JSONObject jsonObject = this.mongodbUtils.queryByPage(page_size.intValue(), page_num.intValue(), query, new BasicDBObject("created_date", (Object)-1), "def_order");
            JSONArray list = jsonObject.getJSONArray("list");
            JSONArray jsonArray1 = new JSONArray();
            for (int i = 0; i < list.size(); ++i) {
                JSONObject order = list.getJSONObject(i);
                if (StringUtils.isNotNull((Object)order.get((Object)"productList"))) {
                    JSONArray productList = JSONObject.parseArray((String)order.get((Object)"productList").toString());
                    JSONArray arr = new JSONArray();
                    if (StringUtils.isNotNull((Object)productList) && productList.size() > 0) {
                        for (int j = 0; j < productList.size(); ++j) {
                            String sku_id;
                            JSONArray array1;
                            JSONObject object = productList.getJSONObject(j);
                            String first_image_url = object.getString("first_image_url");
                            if (StringUtils.isNotNull((Object)first_image_url)) {
                                String authUrl = this.aliCDNUrlAuth.getAuthUrl(first_image_url);
                                object.put("first_image_url", (Object)authUrl);
                            }
                            if (StringUtils.isNotNull((Object)(array1 = object.getJSONArray("product_image_url"))) && array1.size() > 0) {
                                JSONArray jsonArray = new JSONArray();
                                for (int z = 0; z < array1.size(); ++z) {
                                    JSONObject object1 = array1.getJSONObject(z);
                                    String image_url = object1.getString("image_url");
                                    if (StringUtils.isNotNull((Object)image_url)) {
                                        String authUrl1 = this.aliCDNUrlAuth.getAuthUrl(image_url);
                                        object1.put("image_url", (Object)authUrl1);
                                    }
                                    jsonArray.add((Object)object1);
                                }
                                object.put("product_image_url", (Object)jsonArray);
                            }
                            if (StringUtils.isNotNull((Object)(sku_id = object.getString("sku_id")))) {
                                Query query1 = new Query((CriteriaDefinition)Criteria.where((String)"_id").is((Object)new ObjectId(sku_id)));
                                Sku sku = (Sku)this.mongoTemplate.findOne(query1, Sku.class);
                                object.put("sku", (Object)sku);
                            }
                            arr.add((Object)object);
                        }
                    }
                    order.put("productList", (Object)arr);
                    jsonArray1.add((Object)order);
                } else {
                    jsonArray1.add((Object)order);
                }
                data1.put("list", (Object)jsonArray1);
            }
        }
        return dataResponse.setStatus(Status.SUCCESS).setCode("0").setData(data1);
    }

    @CacheEvict(value={"order"}, allEntries=true)
    public DataResponse receiveOrder(DataRequest dataRequest) {
        JSONObject da;
        DataResponse dataResponse = new DataResponse();
        JSONObject data = dataRequest.getData();
        String id = data.getString("id");
        String order_id = data.getString("order_id");
        if (StringUtils.isNotNull((Object)id)) {
            order_id = id;
        }
        Query query_ = new Query();
        query_.addCriteria((CriteriaDefinition)Criteria.where((String)"order_id").is((Object)order_id));
        Order order = (Order)this.mongoTemplate.findOne(query_, Order.class);
        if (null == order) {
            JSONObject da2 = new JSONObject();
            da2.put("message", (Object)"\u8ba2\u5355\u4e0d\u5b58\u5728");
            return dataResponse.setStatus(Status.FAILED).setCode("-1").setId(dataRequest.getId()).setData(da2).setMsg("\u8ba2\u5355\u4e0d\u5b58\u5728");
        }
        String currentTimeInString = TimeUtils.getCurrentTimeInString((SimpleDateFormat)TimeUtils.DATETIME_FORMAT_DATE);
        String create_date = StringUtils.valueOf((Object)order.getCreated_date());
        String pay_status = order.getPay_status();
        if (!"1".equals(pay_status)) {
            return dataResponse.setStatus(Status.FAILED).setCode("-1").setId(dataRequest.getId()).setMsg("\u8ba2\u5355\u672a\u4ed8\u6b3e");
        }
        JSONArray productList = order.getProductList();
        JSONArray productListNew = new JSONArray();
        for (int i = 0; i < productList.size(); ++i) {
            JSONObject product = productList.getJSONObject(i);
            if (StringUtils.isNotNull((Object)product.getString("refund_good_status"))) {
                String refund_good_status = product.getString("refund_good_status");
                String refund_id = product.getString("refund_id");
                if (StringUtils.isNotNull((Object)refund_id) && !"0".equals(product.getString("left_amount"))) {
                    Query query = new Query((CriteriaDefinition)Criteria.where((String)"_id").is((Object)new ObjectId(refund_id)));
                    Update refundUpdate = new Update();
                    refundUpdate.set("is_active", (Object)"N");
                    this.mongoTemplate.updateFirst(query, refundUpdate, "def_apply_refund");
                }
                if ("0".equals(refund_good_status) || "1".equals(refund_good_status) || "3".equals(refund_good_status)) {
                    product.remove((Object)"refund_good_status");
                    product.remove((Object)"refund_id");
                    BasicDBObject queryApply = new BasicDBObject();
                    queryApply.put((Object)"_id", (Object)new ObjectId(refund_id));
                    BasicDBObject basicDBObject = new BasicDBObject();
                }
            }
            productListNew.add((Object)product);
        }
        BasicDBObject basicDBObject = new BasicDBObject();
        BasicDBObject update = new BasicDBObject();
        basicDBObject.put((Object)"order_status", (Object)"2");
        basicDBObject.put((Object)"productList", (Object)productListNew);
        basicDBObject.put((Object)"received_date", (Object)TimeUtils.getCurrentTimeInString((SimpleDateFormat)TimeUtils.DATETIME_FORMAT_DATE));
        update.put((Object)"$set", (Object)basicDBObject);
        BasicDBObject query = new BasicDBObject();
        query.put((Object)"order_id", (Object)order_id);
        log.info("update>>" + update + ">>>>>>>>>query>>>>>>>" + query);
        WriteResult writeResult = this.mongoTemplate.getCollection("def_order").updateMulti((DBObject)query, (DBObject)update);
        if (writeResult.getN() > 0) {
            da = new JSONObject();
            da.put("message", (Object)"\u4fee\u6539\u6210\u529f");
            dataResponse.setStatus(Status.SUCCESS).setCode("0").setId(dataRequest.getId()).setData(da);
        } else {
            da = new JSONObject();
            da.put("message", (Object)"\u4fee\u6539\u5931\u8d25");
            dataResponse.setStatus(Status.FAILED).setCode("-1").setId(dataRequest.getId()).setData(da).setMsg("\u4fee\u6539\u5931\u8d25");
        }
        return dataResponse;
    }

    public DataResponse modExpressV2(DataRequest dataRequest) {
        DataResponse dataResponse = new DataResponse();
        JSONObject data = dataRequest.getData();
        String _id = data.getString("id");
        Query query_ = new Query();
        query_.addCriteria((CriteriaDefinition)Criteria.where((String)"order_id").is((Object)_id));
        Order order = (Order)this.mongoTemplate.findOne(query_, Order.class);
        if (null == order) {
            JSONObject da = new JSONObject();
            da.put("message", (Object)"\u8ba2\u5355\u4e0d\u5b58\u5728");
            return dataResponse.setStatus(Status.FAILED).setCode("-1").setId(dataRequest.getId()).setData(da).setMsg("\u8ba2\u5355\u4e0d\u5b58\u5728");
        }
        String pay_status = order.getPay_status();
        String order_status = order.getOrder_status();
        if (!"1".equals(pay_status)) {
            return dataResponse.setStatus(Status.FAILED).setCode("-1").setId(dataRequest.getId()).setMsg("\u4e0d\u6ee1\u8db3\u4fee\u6539\u6761\u4ef6");
        }
        if (!"0".equals(order_status)) {
            return dataResponse.setStatus(Status.FAILED).setCode("-1").setId(dataRequest.getId()).setMsg("\u4e0d\u6ee1\u8db3\u4fee\u6539\u6761\u4ef6");
        }
        BasicDBObject basicDBObject = new BasicDBObject();
        BasicDBObject update = new BasicDBObject();
        if (data.containsKey((Object)"express_info")) {
            basicDBObject.put((Object)"express_info", (Object)data.getJSONObject("express_info"));
        }
        basicDBObject.put((Object)"modified_date", (Object)TimeUtils.getCurrentTimeInString((SimpleDateFormat)TimeUtils.DATETIME_FORMAT_DATE));
        update.put((Object)"$set", (Object)basicDBObject);
        BasicDBObject query = new BasicDBObject();
        query.put((Object)"_id", (Object)new ObjectId(_id));
        log.info("update>>" + update + ">>>>>>>>>query>>>>>>>" + query);
        WriteResult writeResult = this.mongoTemplate.getCollection("def_order").updateMulti((DBObject)query, (DBObject)update);
        if (writeResult.getN() > 0) {
            Corp corp = (Corp)this.mongoTemplate.findOne(new Query().addCriteria((CriteriaDefinition)new Criteria("corp_code").is((Object)order.getProductList().getJSONObject(0).getString("corp_code"))), Corp.class);
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("order_id", (Object)_id);
            jsonObject.put("seller_remark", (Object)data.getString("seller_remark"));
            jsonObject.put("mini_appid", (Object)corp.getMini_appid());
            if (data.containsKey((Object)"express_info")) {
                jsonObject.putAll((Map)data.getJSONObject("express_info").getJSONObject("address"));
            }
            DataRequest dataRequest1 = new DataRequest();
            dataRequest1.setData(jsonObject);
            this.wingMixAgent.callRest(dataRequest1, "/order/orderDetailModify");
            JSONObject da = new JSONObject();
            da.put("message", (Object)"\u4fee\u6539\u6210\u529f");
            dataResponse.setStatus(Status.SUCCESS).setCode("0").setId(dataRequest.getId()).setData(da);
        } else {
            JSONObject da = new JSONObject();
            da.put("message", (Object)"\u4fee\u6539\u5931\u8d25");
            dataResponse.setStatus(Status.FAILED).setCode("-1").setId(dataRequest.getId()).setData(da).setMsg("\u4fee\u6539\u5931\u8d25");
        }
        return dataResponse;
    }

    public DataResponse agreeApplyRefund(DataRequest dataRequest) {
        JSONObject data = dataRequest.getData();
        String id = data.getString("id");
        String user_id = data.getString("user_id");
        Query query = new Query().addCriteria((CriteriaDefinition)Criteria.where((String)"_id").is((Object)new ObjectId(id)));
        ApplyRefund refund = (ApplyRefund)this.mongoTemplate.findOne(query, ApplyRefund.class);
        if (refund == null) {
            return new DataResponse().setStatus(Status.FAILED).setCode("-1").setMsg("\u9000\u6b3e\u7533\u8bf7\u4e0d\u5b58\u5728");
        }
        if ("N".equals(refund.getIs_active())) {
            return new DataResponse().setStatus(Status.FAILED).setCode("-1").setMsg("\u5f53\u524d\u7533\u8bf7\u5df2\u64a4\u9500");
        }
        if (!"0".equals(refund.getStatus())) {
            return new DataResponse().setStatus(Status.FAILED).setCode("-1").setMsg("\u5f53\u524d\u7533\u8bf7\u4e0d\u662f\u5f85\u5ba1\u6838\u72b6\u6001");
        }
        String order_id = refund.getOrder_id();
        Query query_o = new Query().addCriteria((CriteriaDefinition)Criteria.where((String)"order_id").is((Object)order_id));
        Order order = (Order)this.mongoTemplate.findOne(query_o, Order.class);
        if (order == null) {
            return new DataResponse().setStatus(Status.FAILED).setCode("-1").setMsg("\u8ba2\u5355\u4e0d\u5b58\u5728");
        }
        if (!"1".equals(order.getPay_status())) {
            return new DataResponse().setStatus(Status.FAILED).setCode("-1").setMsg("\u672a\u652f\u4ed8\u6216\u5df2\u9000\u6b3e");
        }
        String order_no = order.getOrder_no();
        Update update = new Update();
        update.set("status", (Object)"1");
        update.set("modified_date", (Object)TimeUtils.getCurrentTimeInString());
        update.set("modifier_id", (Object)user_id);
        this.mongoTemplate.upsert(query, update, ApplyRefund.class);
        Query queryO = new Query((CriteriaDefinition)Criteria.where((String)"order_id").is((Object)order_id));
        queryO.addCriteria((CriteriaDefinition)Criteria.where((String)"productList.refund_id").is((Object)id));
        Update updateO = new Update();
        updateO.set("productList.$.refund_good_status", (Object)"1");
        this.mongoTemplate.upsert(queryO, updateO, Order.class);
        JSONObject data1 = new JSONObject();
        data1.put("message", (Object)"\u7533\u8bf7\u901a\u8fc7");
        return new DataResponse().setData(data1).setStatus(Status.SUCCESS).setCode("0");
    }

    public DataResponse refundApplyCount(DataRequest dataRequest) {
        JSONObject object = new JSONObject();
        JSONObject data = dataRequest.getData();
        String user_id = data.getString("user_id");
        DBCollection collection_s = this.mongoTemplate.getCollection("def_apply_refund");
        BasicDBObject basicDBObject = new BasicDBObject();
        basicDBObject.put((Object)"user_id", (Object)user_id);
        basicDBObject.put((Object)"status", (Object)"0");
        Long s = collection_s.count((DBObject)basicDBObject);
        object.put("count", (Object)s);
        return new DataResponse().setStatus(Status.SUCCESS).setCode("0").setId(dataRequest.getId()).setData(object);
    }

    public DataResponse refundApplyList(DataRequest dataRequest) {
        DataResponse dataResponse = new DataResponse();
        DBCollection collection_s = this.mongoTemplate.getCollection("def_apply_refund");
        DBCollection collection_o = this.mongoTemplate.getCollection("def_order");
        JSONObject data = dataRequest.getData();
        int page_num = data.getInteger("page_num");
        int page_size = data.getInteger("page_size");
        String user_id = data.getString("user_id");
        String status = data.getString("status");
        String refund_id = data.getString("id");
        BasicDBObject query = new BasicDBObject();
        if (StringUtils.isNull((Object)user_id)) {
            return new DataResponse().setCode("-1").setStatus(Status.FAILED).setMsg("user_id\u4e3a\u7a7a");
        }
        query.put((Object)"user_id", (Object)user_id);
        if (StringUtils.isNotNull((Object)status)) {
            String[] strings = status.split(",");
            query.put((Object)"status", (Object)new BasicDBObject("$in", (Object)strings));
        }
        if (StringUtils.isNotNull((Object)refund_id)) {
            query.put((Object)"_id", (Object)new ObjectId(refund_id));
        }
        log.info((Object)query);
        DBCursor cursor = collection_s.find((DBObject)query).sort((DBObject)new BasicDBObject("created_date", (Object)-1)).skip(page_num * page_size).limit(page_size);
        int count = cursor.count();
        int pages = 0;
        pages = count % page_size == 0 ? count / page_size : count / page_size + 1;
        JSONArray array = new JSONArray();
        while (cursor.hasNext()) {
            DBObject object = cursor.next();
            String id = object.get("_id").toString();
            object.removeField("_id");
            object.put("id", (Object)id);
            String order_no = "";
            String order_id = object.get("order_id").toString();
            BasicDBObject query_o = new BasicDBObject();
            query_o.put((Object)"order_id", (Object)order_id);
            DBObject cursor_o = collection_o.findOne((DBObject)query_o);
            if (cursor_o == null) continue;
            if (StringUtils.isNotNull((Object)refund_id)) {
                String store_code = "";
                if (null == object.get("address")) {
                    User user = (User)this.mongoTemplate.findOne(Query.query((CriteriaDefinition)Criteria.where((String)"user_id").is((Object)user_id)), User.class);
                    if (null != user) {
                        String store_id = user.getStore_id();
                        Store store = (Store)this.mongoTemplate.findOne(Query.query((CriteriaDefinition)Criteria.where((String)"store_id").is((Object)store_id)), Store.class);
                        object.put("address", (Object)store);
                        object.put("user", (Object)user);
                    }
                    if (null == object.get("address")) {
                        Query query1 = new Query();
                        query1.addCriteria((CriteriaDefinition)Criteria.where((String)"order_id").is((Object)order_id));
                        Logistics logistics = (Logistics)this.mongoTemplate.findOne(query1, Logistics.class);
                        String is_one = logistics.getIs_one();
                        if ("Y".equals(is_one)) {
                            store_code = logistics.getStore_code();
                        } else {
                            JSONArray refund_product = JSONArray.parseArray((String)object.get("refund_product").toString());
                            query1.addCriteria((CriteriaDefinition)Criteria.where((String)"productList.sku_id").is((Object)refund_product.getJSONObject(0).getString("sku_id")));
                            logistics = (Logistics)this.mongoTemplate.findOne(query1, Logistics.class);
                            store_code = logistics.getStore_code();
                        }
                        if (StringUtils.isNotNull((Object)store_code)) {
                            Store store = (Store)this.mongoTemplate.findOne(Query.query((CriteriaDefinition)Criteria.where((String)"store_code").is((Object)store_code)), Store.class);
                            object.put("address", (Object)store);
                        }
                    }
                }
            }
            order_no = cursor_o.get("order_no").toString();
            object.put("order_no", (Object)order_no);
            object.put("order_info", (Object)cursor_o);
            object.put("order_vip", cursor_o.get("order_vip"));
            array.add((Object)object);
        }
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("list", (Object)array);
        jsonObject.put("page_num", (Object)(page_num + ""));
        jsonObject.put("page_size", (Object)(page_size + ""));
        jsonObject.put("pages", (Object)(pages + ""));
        jsonObject.put("count", (Object)(count + ""));
        return dataResponse.setCode("0").setStatus(Status.SUCCESS).setData(jsonObject);
    }

    public DataResponse agreeRefundApply(DataRequest dataRequest) {
        JSONObject data = dataRequest.getData();
        String id = data.getString("id");
        JSONObject address = data.getJSONObject("address");
        String user_id = data.getString("user_id");
        Query query = new Query().addCriteria((CriteriaDefinition)Criteria.where((String)"_id").is((Object)new ObjectId(id)));
        ApplyRefund refund = (ApplyRefund)this.mongoTemplate.findOne(query, ApplyRefund.class);
        if (refund == null) {
            return new DataResponse().setStatus(Status.FAILED).setCode("-1").setMsg("\u9000\u6b3e\u7533\u8bf7\u4e0d\u5b58\u5728");
        }
        if ("N".equals(refund.getIs_active())) {
            return new DataResponse().setStatus(Status.FAILED).setCode("-1").setMsg("\u5f53\u524d\u7533\u8bf7\u5df2\u64a4\u9500");
        }
        if (!"0".equals(refund.getStatus())) {
            return new DataResponse().setStatus(Status.FAILED).setCode("-1").setMsg("\u5f53\u524d\u7533\u8bf7\u4e0d\u662f\u5f85\u5ba1\u6838\u72b6\u6001");
        }
        String order_id = refund.getOrder_id();
        Query query_o = new Query().addCriteria((CriteriaDefinition)Criteria.where((String)"order_id").is((Object)order_id));
        Order order = (Order)this.mongoTemplate.findOne(query_o, Order.class);
        if (order == null) {
            return new DataResponse().setStatus(Status.FAILED).setCode("-1").setMsg("\u8ba2\u5355\u4e0d\u5b58\u5728");
        }
        if (!"1".equals(order.getPay_status())) {
            return new DataResponse().setStatus(Status.FAILED).setCode("-1").setMsg("\u672a\u652f\u4ed8\u6216\u5df2\u9000\u6b3e");
        }
        String order_no = order.getOrder_no();
        Update update = new Update();
        update.set("status", (Object)"1");
        update.set("modified_date", (Object)TimeUtils.getCurrentTimeInString());
        update.set("modifier_id", (Object)user_id);
        update.set("address", (Object)address);
        this.mongoTemplate.upsert(query, update, ApplyRefund.class);
        Query queryO = new Query((CriteriaDefinition)Criteria.where((String)"order_id").is((Object)order_id));
        queryO.addCriteria((CriteriaDefinition)Criteria.where((String)"productList.refund_id").is((Object)id));
        Update updateO = new Update();
        updateO.set("productList.$.refund_good_status", (Object)"1");
        this.mongoTemplate.upsert(queryO, updateO, Order.class);
        JSONObject data1 = new JSONObject();
        data1.put("message", (Object)"\u7533\u8bf7\u901a\u8fc7");
        return new DataResponse().setData(data1).setStatus(Status.SUCCESS).setCode("0");
    }

    public DataResponse refuseRefundApply(DataRequest dataRequest) {
        JSONObject data = dataRequest.getData();
        String id = data.getString("id");
        String user_id = data.getString("user_id");
        String refuse_reason = data.getString("reason");
        Query query = new Query().addCriteria((CriteriaDefinition)Criteria.where((String)"_id").is((Object)new ObjectId(id)));
        ApplyRefund refund = (ApplyRefund)this.mongoTemplate.findOne(query, ApplyRefund.class);
        if (refund == null) {
            return new DataResponse().setStatus(Status.FAILED).setCode("-1").setMsg("\u9000\u6b3e\u7533\u8bf7\u4e0d\u5b58\u5728");
        }
        if ("N".equals(refund.getIs_active())) {
            return new DataResponse().setStatus(Status.FAILED).setCode("-1").setMsg("\u5f53\u524d\u7533\u8bf7\u5df2\u64a4\u9500");
        }
        if ("2".equals(refund.getStatus())) {
            return new DataResponse().setStatus(Status.FAILED).setCode("-1").setMsg("\u5f53\u524d\u7533\u8bf7\u5df2\u5b8c\u6210");
        }
        String refund_user_id = refund.getUser_id();
        String refund_kind = refund.getRefund_kind();
        String order_id = refund.getOrder_id();
        Query query_o = new Query().addCriteria((CriteriaDefinition)Criteria.where((String)"order_id").is((Object)order_id));
        Order order = (Order)this.mongoTemplate.findOne(query_o, Order.class);
        if (order == null) {
            return new DataResponse().setStatus(Status.FAILED).setCode("-1").setMsg("\u8ba2\u5355\u4e0d\u5b58\u5728");
        }
        if (!"1".equals(order.getPay_status())) {
            return new DataResponse().setStatus(Status.FAILED).setCode("-1").setMsg("\u8ba2\u5355\u672a\u652f\u4ed8\u6216\u5df2\u9000\u6b3e");
        }
        String order_no = order.getOrder_no();
        Update update = new Update();
        update.set("status", (Object)"3");
        update.set("refuse_reason", (Object)refuse_reason);
        update.set("modified_date", (Object)TimeUtils.getCurrentTimeInString());
        update.set("refuse_date", (Object)TimeUtils.getCurrentTimeInString());
        update.set("modifier_id", (Object)user_id);
        this.mongoTemplate.upsert(query, update, ApplyRefund.class);
        JSONArray productList = refund.getRefund_product();
        for (int i = 0; i < productList.size(); ++i) {
            JSONObject object = productList.getJSONObject(i);
            String sku_id = object.getString("sku_id");
            Query queryO = new Query((CriteriaDefinition)Criteria.where((String)"order_id").is((Object)order_id));
            queryO.addCriteria((CriteriaDefinition)Criteria.where((String)"productList.sku_id").is((Object)sku_id));
            Update updateO = new Update();
            updateO.set("productList.$.refund_good_status", (Object)"3");
            this.mongoTemplate.updateFirst(queryO, updateO, Order.class);
        }
        11 sendMessage = new /* Unavailable Anonymous Inner Class!! */;
        try {
            ScheduledThreadPoolExecutor executorService = new ScheduledThreadPoolExecutor(1, (ThreadFactory)new BasicThreadFactory.Builder().namingPattern("example-schedule-pool-%d").daemon(true).build());
            executorService.execute((Runnable)sendMessage);
            executorService.shutdown();
        }
        catch (Exception e) {
            log.error("set message error:" + e.getLocalizedMessage(), (Throwable)e);
        }
        JSONObject data1 = new JSONObject();
        data1.put("message", (Object)"\u64cd\u4f5c\u6210\u529f");
        return new DataResponse().setData(data1).setStatus(Status.SUCCESS).setCode("0");
    }

    @CacheEvict(value={"order"}, allEntries=true)
    public DataResponse modExpress(DataRequest dataRequest) {
        JSONObject da;
        DataResponse dataResponse = new DataResponse();
        JSONObject data = dataRequest.getData();
        String _id = data.getString("id");
        String coupon_id = data.getString("coupon_id");
        Query query_ = new Query();
        query_.addCriteria((CriteriaDefinition)Criteria.where((String)"order_id").is((Object)_id));
        Order order = (Order)this.mongoTemplate.findOne(query_, Order.class);
        if (null == order) {
            JSONObject da2 = new JSONObject();
            da2.put("message", (Object)"\u8ba2\u5355\u4e0d\u5b58\u5728");
            return dataResponse.setStatus(Status.FAILED).setCode("-1").setId(dataRequest.getId()).setData(da2).setMsg("\u8ba2\u5355\u4e0d\u5b58\u5728");
        }
        String currentTimeInString = TimeUtils.getCurrentTimeInString((SimpleDateFormat)TimeUtils.DATETIME_FORMAT_DATE);
        String create_date = StringUtils.valueOf((Object)order.getCreated_date());
        String pay_status = order.getPay_status();
        String is_on = order.getIs_online_pay();
        String trade_type = order.getTrade_type();
        if ("Y".equals(is_on) || "online".equals(trade_type)) {
            DBCollection collection_order_param = this.mongoTemplate.getCollection("def_order_param");
            DBObject dbObject = collection_order_param.findOne();
            int over_time = 12;
            if (null != dbObject && dbObject.containsField("order_overdue_time")) {
                over_time = Integer.parseInt(dbObject.get("order_overdue_time").toString());
            }
            if (TimeUtils.getDistanceTimes((String)create_date, (String)currentTimeInString) >= (long)over_time && !"1".equals(pay_status)) {
                return dataResponse.setStatus(Status.FAILED).setCode("-1").setId(dataRequest.getId()).setMsg("\u6b64\u8ba2\u5355\u5df2\u8fc7\u671f");
            }
        }
        JSONObject order_vip = order.getOrder_vip();
        String vip_id = "";
        if (null != order_vip && order_vip.size() > 0) {
            vip_id = order_vip.getString("vip_id");
        }
        BasicDBObject basicDBObject = new BasicDBObject();
        BasicDBObject update = new BasicDBObject();
        String is_self_pick = "Y";
        DataResponse dataResponse1 = new DataResponse();
        if (StringUtils.isNotNull((Object)coupon_id) || StringUtils.isNotNull((Object)data.get((Object)"no_use_coupon"))) {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("coupon_id", (Object)data.getString("coupon_id"));
            jsonObject.put("order_id", (Object)_id);
            DataRequest datarequest = new DataRequest();
            datarequest.setData(jsonObject);
            log.info("-----dataResponse1-----" + dataResponse1);
            if (StringUtils.isNotNull((Object)coupon_id) && !"SUCCESS".equals(dataResponse1.getStatus().toString())) {
                return dataResponse1;
            }
        }
        if (data.containsKey((Object)"express_info")) {
            if (data.getJSONObject("express_info").containsKey((Object)"is_self_pick")) {
                is_self_pick = StringUtils.checkString((String)data.getJSONObject("express_info").getString("is_self_pick"));
                basicDBObject.put((Object)"express_info.is_self_pick", (Object)is_self_pick);
            }
            if (data.getJSONObject("express_info").containsKey((Object)"address") && "N".equals(is_self_pick) && data.getJSONObject("express_info").getJSONObject("address").size() > 0) {
                basicDBObject.put((Object)"express_info.address", (Object)data.getJSONObject("express_info").getJSONObject("address"));
                JSONObject a = data.getJSONObject("express_info");
                JSONObject address = a.getJSONObject("address");
                String vip_phone = address.getString("phone");
                if (StringUtils.isNotNull((Object)vip_id) && address.size() > 0) {
                    Vip vip = (Vip)this.mongoTemplate.findOne(Query.query((CriteriaDefinition)Criteria.where((String)"vip_id").is((Object)vip_id)), Vip.class);
                    if (StringUtils.isNull((Object)vip.getVip_phone())) {
                        log.info("\u6536\u8d27\u5730\u5740\u66f4\u65b0\u624b\u673a\u53f7");
                        this.mongoTemplate.upsert(Query.query((CriteriaDefinition)Criteria.where((String)"vip_id").is((Object)vip_id)), Update.update((String)"vip_phone", (Object)vip_phone), Vip.class);
                    }
                    boolean address_exist = false;
                    JSONArray address_list = vip.getAddress_list();
                    if (null != address_list) {
                        for (int i = 0; i < address_list.size(); ++i) {
                            JSONObject address_obj = address_list.getJSONObject(i);
                            if (!address_obj.getString("province_name").equals(address.getString("province_name")) || !address_obj.getString("city_name").equals(address.getString("city_name")) || !address_obj.getString("country_name").equals(address.getString("country_name")) || !address_obj.getString("address").equals(address.getString("address")) || !address_obj.getString("name").equals(address.getString("name")) || !address_obj.getString("phone").equals(address.getString("phone"))) continue;
                            address_exist = true;
                        }
                    }
                    if (!address_exist) {
                        address.put("is_default", (Object)"N");
                        BasicDBObject update_ = new BasicDBObject();
                        BasicDBObject query_vip = new BasicDBObject();
                        query_vip.put((Object)"vip_id", (Object)vip_id);
                        BasicDBObject basicDBObject_ = new BasicDBObject();
                        basicDBObject_.put((Object)"address_list", (Object)address);
                        update_.put((Object)"$addToSet", (Object)basicDBObject_);
                        this.mongoTemplate.getCollection("def_vip").update((DBObject)query_vip, (DBObject)update_);
                    }
                }
            }
        }
        if (data.containsKey((Object)"order_vip")) {
            basicDBObject.put((Object)"order_vip", (Object)data.getJSONObject("order_vip"));
        }
        if (data.containsKey((Object)"order_remark")) {
            basicDBObject.put((Object)"order_remark", (Object)data.getString("order_remark"));
        }
        basicDBObject.put((Object)"modified_date", (Object)TimeUtils.getCurrentTimeInString((SimpleDateFormat)TimeUtils.DATETIME_FORMAT_DATE));
        update.put((Object)"$set", (Object)basicDBObject);
        BasicDBObject query = new BasicDBObject();
        query.put((Object)"_id", (Object)new ObjectId(_id));
        log.info("update>>" + update + ">>>>>>>>>query>>>>>>>" + query);
        WriteResult writeResult = this.mongoTemplate.getCollection("def_order").updateMulti((DBObject)query, (DBObject)update);
        if (writeResult.getN() > 0) {
            da = new JSONObject();
            da.put("message", (Object)"\u4fee\u6539\u6210\u529f");
            dataResponse.setStatus(Status.SUCCESS).setCode("0").setId(dataRequest.getId()).setData(da);
        } else {
            da = new JSONObject();
            da.put("message", (Object)"\u4fee\u6539\u5931\u8d25");
            dataResponse.setStatus(Status.FAILED).setCode("-1").setId(dataRequest.getId()).setData(da).setMsg("\u4fee\u6539\u5931\u8d25");
        }
        return dataResponse;
    }

    @CacheEvict(value={"order"}, allEntries=true)
    public DataResponse del(DataRequest dataRequest) {
        DataResponse dataResponse = new DataResponse();
        JSONObject data = dataRequest.getData();
        String user_id = data.getString("user_id");
        String id = data.getString("id");
        DBCollection collection = this.mongoTemplate.getCollection("def_order");
        BasicDBObject basicDB = new BasicDBObject();
        BasicDBList basicDBList1 = new BasicDBList();
        if (StringUtils.isNotNull((Object)user_id)) {
            basicDBList1.add((Object)new BasicDBObject("user_id", (Object)user_id));
        }
        basicDBList1.add((Object)new BasicDBObject("_id", (Object)new ObjectId(id)));
        basicDB.put((Object)"$and", (Object)basicDBList1);
        DBObject dbObject = collection.findOne((DBObject)basicDB);
        if ("0".equals(dbObject.get("pay_status").toString())) {
            BasicDBObject update = new BasicDBObject();
            BasicDBObject basicDBObject = new BasicDBObject();
            basicDBObject.put((Object)"is_active", (Object)"N");
            update.put((Object)"$set", (Object)basicDBObject);
            WriteResult writeResult = collection.update((DBObject)basicDB, (DBObject)update);
            WriteResult writeResult1 = this.mongoTemplate.getCollection("def_order_detail").updateMulti((DBObject)basicDB, (DBObject)update);
            if (writeResult.getN() > 0) {
                Query query = new Query();
                query.addCriteria((CriteriaDefinition)Criteria.where((String)"order_id").is((Object)id));
                Order order = (Order)this.mongoTemplate.findOne(query, Order.class);
                String pay_status = order.getPay_status();
                JSONArray product_list = order.getProductList();
                DataRequest dataRequestadjust = new DataRequest();
                JSONObject jsonObjectadjust = new JSONObject();
                jsonObjectadjust.put("order_no", (Object)order.getOrder_no());
                jsonObjectadjust.put("pay_status", (Object)order.getPay_status());
                jsonObjectadjust.put("productList", (Object)product_list);
                jsonObjectadjust.put("user_id", (Object)user_id);
                if (StringUtils.isNull((Object)order.getTrade_type())) {
                    jsonObjectadjust.put("trade_type", (Object)order.getTrade_type());
                } else {
                    jsonObjectadjust.put("is_online_pay", (Object)order.getIs_online_pay());
                }
                jsonObjectadjust.put("type", (Object)"del");
                dataRequestadjust.setData(jsonObjectadjust);
                this.adjustStock(dataRequestadjust);
                if ("0".equals(pay_status) && StringUtils.isNotNull((Object)order.getCoupon_id_array())) {
                    JSONArray array = order.getCoupon_id_array();
                    for (int i = 0; i < array.size(); ++i) {
                        String coupon_id = array.getString(i);
                        Query query_coupon = new Query();
                        query_coupon.addCriteria((CriteriaDefinition)Criteria.where((String)"_id").is((Object)new ObjectId(coupon_id)));
                        Update update1 = new Update();
                        update1.set("status", (Object)"0");
                        this.mongoTemplate.updateMulti(query_coupon, update1, Coupon.class);
                    }
                    BasicDBObject update_ = new BasicDBObject();
                    BasicDBObject basicDBObject_ = new BasicDBObject();
                    basicDBObject_.put((Object)"coupon_id_array", null);
                    update_.put((Object)"$set", (Object)basicDBObject_);
                    collection.update((DBObject)basicDB, (DBObject)update_);
                }
                this.mongoTemplate.remove(query, Logistics.class);
                JSONObject da = new JSONObject();
                da.put("message", (Object)"\u5220\u9664\u6210\u529f");
                dataResponse.setStatus(Status.SUCCESS).setCode("0").setId(dataRequest.getId()).setData(da);
            } else {
                JSONObject da = new JSONObject();
                da.put("message", (Object)"\u5220\u9664\u5931\u8d25");
                dataResponse.setStatus(Status.FAILED).setCode("-1").setId(dataRequest.getId()).setData(da).setMsg("\u4fee\u6539\u5931\u8d25");
            }
        } else {
            JSONObject da = new JSONObject();
            da.put("message", (Object)"\u5220\u9664\u5931\u8d25");
            dataResponse.setStatus(Status.FAILED).setCode("-1").setId(dataRequest.getId()).setData(da).setMsg("\u8ba2\u5355\u5df2\u652f\u4ed8\u6216\u9000\u6b3e");
        }
        return dataResponse;
    }

    public DataResponse query(DataRequest dataRequest) {
        DataResponse dataResponse = new DataResponse();
        JSONObject data = dataRequest.getData();
        String user_id = data.getString("user_id");
        String id = data.getString("id");
        DBCollection collection = this.mongoTemplate.getCollection("def_order");
        BasicDBObject basicDB = new BasicDBObject();
        BasicDBList basicDBList1 = new BasicDBList();
        basicDBList1.add((Object)new BasicDBObject("user_id", (Object)user_id));
        basicDBList1.add((Object)new BasicDBObject("_id", (Object)new ObjectId(id)));
        basicDB.put((Object)"$and", (Object)basicDBList1);
        DBCursor dbCur = collection.find((DBObject)basicDB);
        JSONObject jsonObject = new JSONObject();
        JSONArray array = new JSONArray();
        while (dbCur.hasNext()) {
            DBObject object = dbCur.next();
            Map map = object.toMap();
            map.put("id", id.toString());
            String user_id_ = (String)map.get("user_id");
            if (!user_id.equals(user_id_)) {
                map.put("can_edit", "false");
                map.put("can_remove", "false");
            } else {
                map.put("can_edit", "true");
                map.put("can_remove", "true");
            }
            array.add((Object)map);
        }
        jsonObject.put("message", (Object)array);
        return dataResponse.setStatus(Status.SUCCESS).setData(jsonObject);
    }

    public DataResponse queryList(DataRequest dataRequest) {
        BasicDBList basicDBListOr;
        String _id;
        DataResponse dataResponse = new DataResponse();
        JSONObject data = dataRequest.getData();
        String user_id = data.getString("user_id");
        String query_type = data.getString("query_type");
        String vip_id = data.getString("vip_id");
        int page_num = data.getIntValue("page_num");
        int page_size = data.getIntValue("page_size");
        DBCollection collection = this.mongoTemplate.getCollection("def_order");
        BasicDBObject basicDB = new BasicDBObject();
        BasicDBList basicDBList1 = new BasicDBList();
        DBCollection collection_order_param = this.mongoTemplate.getCollection("def_order_param");
        DBObject dbObject = collection_order_param.findOne();
        int over_time = 12;
        if (null != dbObject && dbObject.containsField("order_overdue_time")) {
            over_time = Integer.parseInt(dbObject.get("order_overdue_time").toString());
        }
        if (org.apache.commons.lang.StringUtils.isNotBlank((String)(_id = data.getString("id")))) {
            if (_id.startsWith("WX")) {
                basicDBList1.add((Object)new BasicDBObject("order_no", (Object)_id));
            } else {
                basicDBList1.add((Object)new BasicDBObject("_id", (Object)new ObjectId(_id)));
            }
        } else {
            if (StringUtils.isNotNull((Object)user_id)) {
                basicDBListOr = new BasicDBList();
                basicDBListOr.add((Object)new BasicDBObject("user_id", (Object)user_id));
                basicDBList1.add((Object)new BasicDBObject("$or", (Object)basicDBListOr));
            }
            basicDBList1.add((Object)new BasicDBObject("is_active", (Object)"Y"));
        }
        if (StringUtils.isNull((Object)_id)) {
            basicDBList1.add((Object)new BasicDBObject("order_pay_status", (Object)new BasicDBObject("$ne", (Object)"0")));
        }
        if (StringUtils.isNotNull((Object)vip_id)) {
            String[] vip_ids = vip_id.split(",");
            basicDBList1.add((Object)new BasicDBObject("order_vip.vip_id", (Object)new BasicDBObject("$in", (Object)vip_ids)));
        }
        if (StringUtils.isNotNull((Object)query_type)) {
            if ("0".equals(query_type)) {
                basicDBList1.add((Object)new BasicDBObject("order_status", (Object)query_type));
                basicDBList1.add((Object)new BasicDBObject("pay_status", (Object)"1"));
                basicDBList1.add((Object)new BasicDBObject("productList.refund_good_status", (Object)new BasicDBObject("$in", (Object)new String[]{"3", null})));
                basicDBList1.add((Object)new BasicDBObject("out_refund_no", (Object)new BasicDBObject("$eq", null)));
            } else if ("-1".equals(query_type)) {
                basicDBList1.add((Object)new BasicDBObject("pay_status", (Object)"0"));
            } else if ("1".equals(query_type)) {
                basicDBListOr = new BasicDBList();
                basicDBList1.add((Object)new BasicDBObject("order_status", (Object)"1"));
                basicDBList1.add((Object)new BasicDBObject("pay_status", (Object)new BasicDBObject("$ne", (Object)"3")));
            } else if ("3".equals(query_type)) {
                basicDBListOr = new BasicDBList();
                basicDBListOr.add((Object)new BasicDBObject("pay_status", (Object)"3"));
                String[] status = new String[]{"0", "1", "2"};
                basicDBListOr.add((Object)new BasicDBObject("productList.refund_good_status", (Object)new BasicDBObject("$in", (Object)status)));
                basicDBList1.add((Object)new BasicDBObject("$or", (Object)basicDBListOr));
            } else if ("2".equals(query_type)) {
                Vip vip = (Vip)this.mongoTemplate.findOne(Query.query((CriteriaDefinition)Criteria.where((String)"vip_id").is((Object)vip_id)), Vip.class);
                String vip_phone = vip.getVip_phone();
                JSONObject object = new JSONObject();
                object.put("phone", (Object)vip_phone);
                DataRequest dataRequest1 = new DataRequest();
                dataRequest1.setData(object);
            } else {
                basicDBList1.add((Object)new BasicDBObject("order_status", (Object)query_type));
                basicDBList1.add((Object)new BasicDBObject("pay_status", (Object)new BasicDBObject("$ne", (Object)"3")));
            }
        }
        basicDB.put((Object)"$and", (Object)basicDBList1);
        log.info((Object)basicDB);
        DBCursor dbCur = collection.find((DBObject)basicDB).skip(page_num * page_size).limit(page_size).sort((DBObject)new BasicDBObject("order_time", (Object)-1));
        JSONObject jsonObject = new JSONObject();
        JSONArray productList = new JSONArray();
        DBCollection collection_s = this.mongoTemplate.getCollection("def_store");
        DBCollection collection_e = this.mongoTemplate.getCollection("def_express");
        while (dbCur.hasNext()) {
            String order_url;
            DBObject object = dbCur.next();
            Map map = object.toMap();
            Object id = map.get("_id");
            if (StringUtils.isNotNull(map.get("erp_deliver_store_name"))) {
                map.put("deliver_goods_store_name", map.get("erp_deliver_store_name"));
            }
            JSONArray products = JSONArray.parseArray((String)map.get("productList").toString());
            try {
                if (null != map.get("logisticsList")) {
                    JSONObject object1;
                    JSONArray result_array = new JSONArray();
                    JSONArray logisticsList = JSONArray.parseArray((String)map.get("logisticsList").toString());
                    for (int i = 0; i < logisticsList.size(); ++i) {
                        DBObject object_store;
                        JSONObject temp_object = logisticsList.getJSONObject(i);
                        String store_code = temp_object.getString("logistics_store");
                        String store_name = "";
                        String address = "";
                        if (StringUtils.isNotNull((Object)store_code) && StringUtils.isNotNull((Object)(object_store = collection_s.findOne((DBObject)new BasicDBObject("store_code", (Object)store_code))))) {
                            store_name = object_store.get("store_name") != null ? object_store.get("store_name").toString() : "";
                            address = object_store.get("address") != null ? object_store.get("address").toString() : "";
                        }
                        temp_object.put("store_name", (Object)store_name);
                        temp_object.put("address", (Object)address);
                        result_array.add((Object)temp_object);
                    }
                    map.put("logisticsList", result_array);
                    JSONArray jsonObject1 = new JSONArray();
                    if (logisticsList.size() == 1 && (object1 = logisticsList.getJSONObject(0)).containsKey((Object)"is_one") && "Y".equals(object1.get((Object)"is_one"))) {
                        Update update1_;
                        Query query1_;
                        Update update1;
                        Query query1;
                        if (!object1.containsKey((Object)"product_list")) {
                            object1.put("product_list", (Object)products);
                            object1.put("order_id", (Object)id.toString());
                            jsonObject1.add((Object)object1);
                            map.put("logisticsList", jsonObject1);
                            query1 = new Query();
                            query1.addCriteria((CriteriaDefinition)Criteria.where((String)"_id").is((Object)new ObjectId(id.toString())));
                            update1 = new Update();
                            update1.set("logisticsList", (Object)jsonObject1);
                            this.mongoTemplate.upsert(query1, update1, Order.class);
                            query1_ = new Query();
                            query1_.addCriteria((CriteriaDefinition)Criteria.where((String)"order_id").is((Object)id.toString()));
                            update1_ = new Update();
                            update1_.set("productList", (Object)products);
                            this.mongoTemplate.upsert(query1_, update1_, Logistics.class);
                        }
                        if (object1.containsKey((Object)"product_list")) {
                            try {
                                if (object1.getJSONArray("product_list").size() == 0) {
                                    object1.put("product_list", (Object)products);
                                    object1.put("order_id", (Object)id.toString());
                                    jsonObject1.add((Object)object1);
                                    map.put("logisticsList", jsonObject1);
                                    query1 = new Query();
                                    query1.addCriteria((CriteriaDefinition)Criteria.where((String)"_id").is((Object)new ObjectId(id.toString())));
                                    update1 = new Update();
                                    update1.set("logisticsList", (Object)jsonObject1);
                                    this.mongoTemplate.upsert(query1, update1, Order.class);
                                    query1_ = new Query();
                                    query1_.addCriteria((CriteriaDefinition)Criteria.where((String)"order_id").is((Object)id.toString()));
                                    update1_ = new Update();
                                    update1_.set("productList", (Object)products);
                                    this.mongoTemplate.upsert(query1_, update1_, Logistics.class);
                                }
                            }
                            catch (Exception e) {
                                object1.put("product_list", (Object)products);
                                object1.put("order_id", (Object)id.toString());
                                jsonObject1.add((Object)object1);
                                map.put("logisticsList", jsonObject1);
                                Query query12 = new Query();
                                query12.addCriteria((CriteriaDefinition)Criteria.where((String)"_id").is((Object)new ObjectId(id.toString())));
                                Update update12 = new Update();
                                update12.set("logisticsList", (Object)jsonObject1);
                                this.mongoTemplate.upsert(query12, update12, Order.class);
                                Query query1_2 = new Query();
                                query1_2.addCriteria((CriteriaDefinition)Criteria.where((String)"order_id").is((Object)id.toString()));
                                Update update1_2 = new Update();
                                update1_2.set("productList", (Object)products);
                                this.mongoTemplate.upsert(query1_2, update1_2, Logistics.class);
                            }
                        }
                    }
                }
                String refund_good_status = "";
                String refund_kind = "";
                for (int i = 0; i < products.size(); ++i) {
                    Sku sku;
                    JSONObject product_obj = products.getJSONObject(i);
                    String sku_id = product_obj.getString("sku_id");
                    if (StringUtils.isNotNull((Object)product_obj.get((Object)"refund_kind"))) {
                        refund_kind = product_obj.getString("refund_kind");
                    }
                    if (StringUtils.isNotNull((Object)product_obj.get((Object)"refund_good_status"))) {
                        refund_good_status = product_obj.getString("refund_good_status");
                    }
                    if (StringUtils.isNotNull((Object)sku_id) && null != (sku = this.getItemsBysku(sku_id))) {
                        product_obj.put("sku", JSONObject.parse((String)sku.toString()));
                    }
                    JSONArray product_image_url = product_obj.getJSONArray("product_image_url");
                    JSONArray img = new JSONArray();
                    if (null != product_image_url) {
                        for (int j = 0; j < product_image_url.size(); ++j) {
                            String url = product_image_url.getJSONObject(j).getString("image_url");
                            JSONObject object1 = new JSONObject();
                            object1.put("image_url", (Object)this.aliCDNUrlAuth.getAuthURLA(url));
                            img.add((Object)object1);
                        }
                    }
                    product_obj.put("product_image_url", (Object)img);
                    product_obj.put("product_image_url_old", (Object)product_image_url);
                }
                map.put("productList", products);
                map.put("refund_kind", refund_kind);
                map.put("refund_good_status", refund_good_status);
            }
            catch (Exception e) {
                log.info((Object)e, (Throwable)e);
            }
            String currentTimeInString = TimeUtils.getCurrentTimeInString((SimpleDateFormat)TimeUtils.DATETIME_FORMAT_DATE);
            String create_date = StringUtils.valueOf(map.get("created_date"));
            String pay_status = map.get("pay_status").toString();
            if (StringUtils.isNotNull(map.get("expired_time"))) {
                if (String.valueOf(map.get("expired_time")).compareTo(currentTimeInString) > 0) {
                    map.put("is_overtime", "false");
                    map.put("over_time", String.valueOf(map.get("expired_time")));
                } else {
                    map.put("is_overtime", "true");
                }
            } else if (TimeUtils.getDistanceTimes((String)create_date, (String)currentTimeInString) >= (long)over_time) {
                if (!"1".equals(pay_status)) {
                    map.put("is_overtime", "true");
                } else {
                    map.put("is_overtime", "false");
                    map.put("over_time", over_time);
                }
            } else {
                map.put("is_overtime", "false");
            }
            map.put("id", id.toString());
            map.remove("_id");
            String string = order_url = map.get("order_url") != null ? map.get("order_url").toString() : "";
            if (StringUtils.isNotNull((Object)_id)) {
                JSONObject expressInfo;
                String order_user_id;
                JSONObject user;
                try {
                    String redisKey = "orderCouponInfo_" + _id;
                    JSONObject orderInfo = null;
                    data.put("order_id", (Object)_id);
                    dataRequest.setData(data);
                    if (this.redisClient.exists(redisKey)) {
                        JSONArray coupon_id_array;
                        orderInfo = (JSONObject)this.redisClient.getValueOps().getValueObject(redisKey);
                        dataResponse = this.couponService.getData("/coupon/checkOrderCoupons", dataRequest);
                        if (!dataResponse.getCode().equals("0") && "false".equals(map.get("is_overtime"))) {
                            orderInfo = this.getOrderInfo(_id);
                        }
                        if (orderInfo.containsKey((Object)"coupon_id_array") && null != (coupon_id_array = orderInfo.getJSONArray("coupon_id_array"))) {
                            map.put("coupon_id_array", coupon_id_array);
                        }
                        if (orderInfo != null && !orderInfo.isEmpty()) {
                            map.put("order_amount_pay", orderInfo.getDouble("order_amount_pay"));
                            if (orderInfo.containsKey((Object)"discount_amount")) {
                                map.put("discount_amount", orderInfo.getDouble("discount_amount"));
                            }
                        }
                    } else if ("false".equals(map.get("is_overtime"))) {
                        orderInfo = this.getOrderInfo(_id);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                String user_name = "";
                String user_store_id = "";
                String head_img = "";
                if (StringUtils.isNotNull(map.get("user_id")) && (user = this.userRedisUtils.getUser(order_user_id = map.get("user_id").toString(), false)) != null) {
                    user_name = user.getString("user_name");
                    user_store_id = user.getString("store_id");
                    head_img = user.getString("head_img");
                    if (StringUtils.isNotNull((Object)head_img) && !head_img.startsWith("http")) {
                        if (head_img.startsWith("/")) {
                            head_img = URLEncoder.encode(head_img.substring(1, head_img.length()));
                            head_img = this.aliCDNUrlAuth.getAuthURLA("https://storage2tommy.blob.core.chinacloudapi.cn/" + head_img);
                        } else {
                            head_img = URLEncoder.encode(head_img);
                            head_img = this.aliCDNUrlAuth.getAuthURLA("https://storage2tommy.blob.core.chinacloudapi.cn/" + head_img);
                        }
                    }
                }
                if (StringUtils.isNotNull((Object)object.get("store_code"))) {
                    String store_code = String.valueOf(object.get("store_code"));
                    Store store = (Store)this.mongoTemplate.findOne(Query.query((CriteriaDefinition)Criteria.where((String)"store_code").is((Object)store_code)), Store.class);
                    if (null != store) {
                        map.put("store_name", store.getStore_name());
                    } else {
                        map.put("store_name", store_code);
                    }
                }
                if (StringUtils.isNotNull((Object)object.get("logistics_user"))) {
                    String logistics_user = String.valueOf(object.get("logistics_user"));
                    user = (User)this.mongoTemplate.findOne(Query.query((CriteriaDefinition)Criteria.where((String)"user_code").is((Object)logistics_user)), User.class);
                    if (null != user) {
                        map.put("logistics_user_name", user.getUser_name());
                    } else {
                        map.put("logistics_user_name", logistics_user);
                    }
                }
                if (StringUtils.isNotNull((Object)object.get("exclusive_user"))) {
                    String exclusive_user = String.valueOf(object.get("exclusive_user"));
                    user = (User)this.mongoTemplate.findOne(Query.query((CriteriaDefinition)Criteria.where((String)"user_id").is((Object)exclusive_user)), User.class);
                    if (null != user) {
                        map.put("exclusive_user_name", user.getUser_name());
                        Query exclusive_user_store_query = new Query((CriteriaDefinition)Criteria.where((String)"store_id").is((Object)user.getStore_id())).addCriteria((CriteriaDefinition)Criteria.where((String)"is_active").is((Object)"Y"));
                        Store exclusive_user_store = (Store)this.mongoTemplate.findOne(exclusive_user_store_query, Store.class);
                        if (exclusive_user_store != null) {
                            map.put("exclusive_user_store_name", exclusive_user_store.getStore_name());
                        }
                    } else {
                        Query exclusive_user_query = new Query((CriteriaDefinition)Criteria.where((String)"user_id").is((Object)exclusive_user)).addCriteria((CriteriaDefinition)Criteria.where((String)"is_active").is((Object)"Y"));
                        User exclusive_user1 = (User)this.mongoTemplate.findOne(exclusive_user_query, User.class);
                        if (exclusive_user1 != null) {
                            map.put("exclusive_user_name", exclusive_user1.getUser_name());
                            Query exclusive_user_store_query = new Query((CriteriaDefinition)Criteria.where((String)"store_id").is((Object)exclusive_user1.getStore_id())).addCriteria((CriteriaDefinition)Criteria.where((String)"is_active").is((Object)"Y"));
                            Store exclusive_user_store = (Store)this.mongoTemplate.findOne(exclusive_user_store_query, Store.class);
                            if (exclusive_user_store != null) {
                                map.put("exclusive_user_store_name", exclusive_user_store.getStore_name());
                            }
                        }
                    }
                }
                map.put("user_name", user_name);
                Query user_store_query = new Query((CriteriaDefinition)Criteria.where((String)"store_id").is((Object)user_store_id)).addCriteria((CriteriaDefinition)Criteria.where((String)"is_active").is((Object)"Y"));
                Store user_store = (Store)this.mongoTemplate.findOne(user_store_query, Store.class);
                if (user_store != null) {
                    map.put("user_store_name", user_store.getStore_name());
                }
                map.put("head_img", head_img);
                String corp_name = "";
                if (StringUtils.isNotNull(map.get("corp_code"))) {
                    String corp_code = map.get("corp_code").toString();
                    DBObject object1 = this.mongoTemplate.getCollection("def_corp").findOne((DBObject)new BasicDBObject("corp_code", (Object)corp_code));
                    if (object1 != null && StringUtils.isNotNull((Object)object1.get("corp_name"))) {
                        corp_name = object1.get("corp_name").toString();
                    }
                }
                map.put("corp_name", corp_name);
                map.put("can_use_coupon", this.canUseCoupon(map));
                if (StringUtils.isNotNull(map.get("express_info")) && StringUtils.isNotNull((Object)(expressInfo = JSONObject.parseObject((String)map.get("express_info").toString())).get((Object)"store_id"))) {
                    String storeId = expressInfo.getString("store_id");
                    BasicDBObject queryS = new BasicDBObject("store_id", (Object)storeId);
                    DBObject store = this.mongoTemplate.getCollection("def_store").findOne((DBObject)queryS);
                    if (store != null) {
                        for (String key : store.keySet()) {
                            if ("_id".equals(key)) continue;
                            if ("address".equals(key)) {
                                expressInfo.put("store_address", store.get(key));
                                continue;
                            }
                            expressInfo.put(key, store.get(key));
                        }
                    }
                    map.put("express_info", expressInfo);
                }
                products = JSONArray.parseArray((String)map.get("productList").toString());
                for (int i = 0; i < products.size(); ++i) {
                    Sku sku;
                    JSONObject product_obj = products.getJSONObject(i);
                    String sku_id = product_obj.getString("sku_id");
                    JSONArray product_image_url = product_obj.getJSONArray("product_image_url");
                    JSONArray img = new JSONArray();
                    if (null != product_image_url) {
                        for (int j = 0; j < product_image_url.size(); ++j) {
                            String url = product_image_url.getJSONObject(j).getString("image_url");
                            JSONObject object1 = new JSONObject();
                            if (!StringUtils.isNotNull((Object)url)) continue;
                            object1.put("image_url", (Object)this.aliCDNUrlAuth.getAuthURLA(url));
                            img.add((Object)object1);
                        }
                    }
                    if (StringUtils.isNotNull((Object)sku_id) && null != (sku = this.getItemsBysku(sku_id))) {
                        product_obj.put("sku", JSONObject.parse((String)sku.toString()));
                    }
                    product_obj.put("product_image_url", (Object)img);
                    product_obj.put("product_image_url_old", (Object)product_image_url);
                    if (!StringUtils.isNotNull((Object)product_obj.get((Object)"refund_id"))) continue;
                    String refund_id = product_obj.getString("refund_id");
                    DBObject applyRefund = this.mongoTemplate.getCollection("def_apply_refund").findOne((DBObject)new BasicDBObject("_id", (Object)new ObjectId(refund_id)));
                    if (applyRefund == null) continue;
                    product_obj.put("refund", (Object)applyRefund);
                }
                map.put("productList", products);
            }
            map.put("order_url", order_url);
            if (StringUtils.isNotNull(map.get("user_id"))) {
                String user_id_ = map.get("user_id").toString();
                if (StringUtils.isNotNull((Object)user_id)) {
                    if (!user_id.equals(user_id_)) {
                        map.put("can_edit", "false");
                        map.put("can_remove", "false");
                    } else {
                        map.put("can_edit", "true");
                        map.put("can_remove", "true");
                    }
                }
            }
            map.put("order_amount_pay", NumberUtil.round(map.get("order_amount_pay"), (int)2));
            ArrayList<Integer> timeList = new ArrayList<Integer>();
            for (int i = 0; i < products.size(); ++i) {
                DBObject skuObj;
                JSONObject pObj = products.getJSONObject(i);
                String product_id = pObj.getString("product_id");
                String sku_id = pObj.getString("sku_id");
                DBObject activityObj = this.mongoTemplate.getCollection("def_seckill_activity").findOne((DBObject)new BasicDBObject().append("status", (Object)"1").append("is_active", (Object)"Y").append("product_id", (Object)product_id));
                if (activityObj == null || (skuObj = this.mongoTemplate.getCollection("rel_seckill_activity").findOne((DBObject)new BasicDBObject("activity_id", activityObj.get("_id")).append("product_id", (Object)product_id).append("sku_id", (Object)sku_id))) == null) continue;
                timeList.add(Integer.parseInt(activityObj.get("cancleOrderTime").toString()));
            }
            Integer cancleOrderTime = null;
            if (timeList.size() > 0) {
                Collections.sort(timeList);
                cancleOrderTime = (Integer)timeList.get(0);
            } else {
                DBCursor dbCursor = this.mongoTemplate.getCollection("def_order_param").find();
                while (dbCursor.hasNext()) {
                    DBObject obj = dbCursor.next();
                    cancleOrderTime = obj.get("order_overdue_time") == null ? 60 : Integer.parseInt(obj.get("order_overdue_time").toString()) * 60;
                }
            }
            map.put("cancle_order_time", cancleOrderTime);
            productList.add((Object)map);
        }
        jsonObject.put("message", (Object)productList);
        JSONArray storeArray = new JSONArray();
        storeArray.add((Object)"5ee33aa484dbbd00018edc04");
        storeArray.add((Object)"5f6dba3c7c983c0001253f0e");
        DBCursor users = this.mongoTemplate.getCollection("def_user").find((DBObject)new BasicDBObject("store_id", (Object)new BasicDBObject("$in", (Object)storeArray)));
        ArrayList<String> userIds = new ArrayList<String>();
        while (users.hasNext()) {
            userIds.add(users.next().get("_id").toString());
        }
        if (userIds.contains(user_id)) {
            jsonObject.put("message", (Object)new JSONArray());
        }
        return dataResponse.setStatus(Status.SUCCESS).setData(jsonObject).setCode("0");
    }

    private JSONObject getOrderInfo(String orderId) {
        BasicDBObject orderQuery = new BasicDBObject();
        orderQuery.put((Object)"order_id", (Object)orderId);
        DBObject dbObject = this.mongoTemplate.getCollection("def_order").findOne((DBObject)orderQuery);
        if (dbObject == null) {
            log.error("not find order by:" + orderQuery);
            throw new CommonException("\u8ba2\u5355\u4fe1\u606f\u6709\u8bef");
        }
        Map map = dbObject.toMap();
        map.put("id", dbObject.get("_id").toString());
        map.remove("_id");
        JSONObject orderInfo = JSONObject.parseObject((String)JSON.toJSONString((Object)map));
        if (orderInfo == null || orderInfo.isEmpty()) {
            log.error("order is null");
            throw new CommonException("\u8ba2\u5355\u4fe1\u606f\u6709\u8bef");
        }
        JSONObject vipInfo = orderInfo.getJSONObject("order_vip");
        String vipId = vipInfo.getString("vip_id");
        if (StringUtils.isNull((Object)vipId)) {
            log.error("order:" + orderId + " vip id is null");
            throw new CommonException("\u8ba2\u5355\u4f1a\u5458\u4fe1\u606f\u6709\u8bef");
        }
        return orderInfo;
    }

    private Sku getItemsBysku(String sku_id) {
        Query query = new Query((CriteriaDefinition)Criteria.where((String)"_id").is((Object)new ObjectId(sku_id)));
        Sku sku = (Sku)this.mongoTemplate.findOne(query, Sku.class);
        if (null == sku) {
            return null;
        }
        JSONArray spec_array = sku.getSpec_array();
        JSONArray new_spec = new JSONArray();
        if (null != spec_array) {
            for (int i = 0; i < spec_array.size(); ++i) {
                JSONObject spec_obj = spec_array.getJSONObject(i);
                String spec_id = spec_obj.getString("spec_id");
                String spec_item_id = spec_obj.getString("spec_item_id");
                Query querySpec = new Query((CriteriaDefinition)Criteria.where((String)"_id").is((Object)new ObjectId(spec_id)));
                Spec spec = (Spec)this.mongoTemplate.findOne(querySpec, Spec.class);
                if (spec != null) {
                    spec_obj.put("spec_name", (Object)spec.getName());
                } else {
                    spec_obj.put("spec_name", (Object)"");
                }
                Query querySpecItem = new Query((CriteriaDefinition)Criteria.where((String)"_id").is((Object)new ObjectId(spec_item_id)));
                SpecItem specItem = (SpecItem)this.mongoTemplate.findOne(querySpecItem, SpecItem.class);
                if (specItem != null) {
                    spec_obj.put("spec_item_name", (Object)specItem.getName());
                } else {
                    spec_obj.put("spec_item_name", (Object)"");
                }
                new_spec.add((Object)spec_obj);
            }
        }
        JSONArray array = new JSONArray();
        if (new_spec.size() > 0) {
            array = JSONArraySortUtil.sortDesc((JSONArray)new_spec, (String)"spec_name");
        }
        sku.setSpec_array(array);
        return sku;
    }

    public DataResponse getOrderCount(DataRequest dataRequest) {
        JSONObject data = dataRequest.getData();
        String vipId = data.getString("vip_id");
        if (StringUtils.isNull((Object)vipId)) {
            return new DataResponse().setMsg("vipId\u4e0d\u80fd\u4e3a\u7a7a").setCode("-1").setStatus(Status.FAILED);
        }
        JSONObject resultObject = new JSONObject();
        DBCollection collection_order_param = this.mongoTemplate.getCollection("def_order_param");
        DBObject dbObject = collection_order_param.findOne();
        int over_time = 12;
        if (null != dbObject && dbObject.containsField("order_overdue_time")) {
            over_time = Integer.parseInt(dbObject.get("order_overdue_time").toString());
        }
        Query query = new Query((CriteriaDefinition)Criteria.where((String)"order_vip.vip_id").is((Object)vipId));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"pay_status").is((Object)"0"));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"is_active").is((Object)"Y"));
        long count = 0L;
        List orderList = this.mongoTemplate.find(query, Order.class);
        String currentTimeInString = TimeUtils.getCurrentTimeInString((SimpleDateFormat)TimeUtils.DATETIME_FORMAT_DATE);
        JSONObject orderObj = new JSONObject();
        for (Order order : orderList) {
            orderObj = JSONObject.parseObject((String)order.toString());
            if (this.isOverTime(orderObj, over_time, currentTimeInString)) continue;
            ++count;
        }
        resultObject.put("unpaid_count", (Object)count);
        query = new Query((CriteriaDefinition)Criteria.where((String)"order_vip.vip_id").is((Object)vipId));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"pay_status").is((Object)"1"));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"order_status").is((Object)"0"));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"is_active").is((Object)"Y"));
        count = this.mongoTemplate.count(query, Order.class);
        resultObject.put("wait_send_count", (Object)count);
        query = new Query((CriteriaDefinition)Criteria.where((String)"order_vip.vip_id").is((Object)vipId));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"pay_status").is((Object)"1"));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"order_status").is((Object)"1"));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"is_active").is((Object)"Y"));
        count = this.mongoTemplate.count(query, Order.class);
        resultObject.put("wait_receiving_count", (Object)count);
        return new DataResponse().setMsg("\u67e5\u8be2\u6210\u529f").setCode("0").setStatus(Status.SUCCESS).setData(resultObject);
    }

    public DataResponse orderPackageInfo(HttpServletRequest request) {
        DataRequest dataRequest = DataRequest.getRequestPayload((HttpServletRequest)request);
        JSONObject data = dataRequest.getData();
        String order_id = data.getString("order_id");
        if (StringUtils.isNull((Object)order_id)) {
            return new DataResponse().setCode("-1").setStatus(Status.FAILED).setMsg("\u5feb\u9012\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        DBObject object_o = this.mongoTemplate.getCollection("def_order").findOne((DBObject)new BasicDBObject("order_id", (Object)order_id));
        if (StringUtils.isNull((Object)object_o)) {
            return new DataResponse().setCode("-1").setStatus(Status.FAILED).setMsg("\u65e0\u6b64\u8ba2\u5355\u7684\u76f8\u5173\u4fe1\u606f");
        }
        JSONObject json_o = JSONObject.parseObject((String)object_o.toString());
        if (!"1".equals(json_o.getString("order_status"))) {
            return new DataResponse().setCode("-1").setStatus(Status.FAILED).setMsg("\u8ba2\u5355\u672a\u53d1\u8d27");
        }
        JSONArray logisticsList = json_o.getJSONArray("logisticsList");
        ArrayList<JSONObject> result_array = new ArrayList<JSONObject>();
        DBCollection collection_e = this.mongoTemplate.getCollection("def_express");
        DBCollection collection_s = this.mongoTemplate.getCollection("def_store");
        for (int i = 0; i < logisticsList.size(); ++i) {
            DBObject object_e;
            JSONObject temp_object = logisticsList.getJSONObject(i);
            String logistics_code = temp_object.getString("logistics_code");
            if (StringUtils.isNull((Object)logistics_code) || StringUtils.isNull((Object)(object_e = collection_e.findOne((DBObject)new BasicDBObject("logistics_code", (Object)logistics_code))))) continue;
            String store_code = object_e.get("store_code") != null ? object_e.get("store_code").toString() : "";
            String store_name = "";
            String address = "";
            if (!StringUtils.isNotNull((Object)store_code)) continue;
            DBObject object_store = collection_s.findOne((DBObject)new BasicDBObject("store_code", (Object)store_code));
            if (StringUtils.isNotNull((Object)object_store)) {
                store_name = object_store.get("store_name") != null ? object_store.get("store_name").toString() : "";
                address = object_store.get("address") != null ? object_store.get("address").toString() : "";
            }
            temp_object.put("store_name", (Object)store_name);
            temp_object.put("address", (Object)address);
            result_array.add(temp_object);
        }
        JSONObject data1 = new JSONObject();
        data1.put("list", result_array);
        return new DataResponse().setStatus(Status.SUCCESS).setMsg("\u8bf7\u6c42\u6210\u529f").setCode("0").setData(data1);
    }

    public DataResponse adjustStockV2(DataRequest request) {
        JSONObject data = request.getData();
        String now = TimeUtils.getCurrentTimeInString((SimpleDateFormat)TimeUtils.DATETIME_FORMAT_DATE);
        JSONArray productList = data.getJSONArray("productList");
        String type = data.getString("type");
        String user_id = data.getString("user_id");
        String source = data.getString("source");
        for (int i = 0; i < productList.size(); ++i) {
            DBObject sku_stock;
            JSONObject temp_product = productList.getJSONObject(i);
            Integer product_num = temp_product.getInteger("product_num");
            String corp_code = temp_product.getString("corp_code");
            String product_id = temp_product.getString("product_id");
            String sku_id = temp_product.getString("sku_id");
            if (0 == product_num || StringUtils.isNull((Object)product_id) || StringUtils.isNull((Object)sku_id) || StringUtils.isNull((Object)(sku_stock = this.mongoTemplate.getCollection("def_sku_stock").findOne((DBObject)new BasicDBObject("sku_id", (Object)sku_id).append("is_active", (Object)"Y")))) || sku_stock.get("left_stock") == null || sku_stock.get("original_stock") == null) continue;
            Integer left_stock = Integer.parseInt(sku_stock.get("left_stock").toString());
            Integer original_stock = Integer.parseInt(sku_stock.get("original_stock").toString());
            if ("refund".equals(source) && left_stock + product_num > original_stock) continue;
            Query query = new Query((CriteriaDefinition)Criteria.where((String)"product_id").is((Object)product_id));
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"sku_id").is((Object)sku_id));
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"is_active").is((Object)"Y"));
            Update update = new Update();
            update.inc("left_stock", (Number)product_num);
            update.set("modified_date", (Object)now);
            this.mongoTemplate.updateFirst(query, update, "def_sku_stock");
            SkuFlow skuFlow = new SkuFlow();
            skuFlow.setSku_id(sku_id);
            skuFlow.setLeft_stock(Integer.valueOf(Integer.parseInt(sku_stock.get("left_stock").toString())));
            skuFlow.setStock_num(product_num);
            skuFlow.setCreated_date(now);
            skuFlow.setSource(source);
            skuFlow.setCreator_id(user_id);
            skuFlow.setType(type);
            skuFlow.setCorp_code(corp_code);
            this.mongoTemplate.insert((Object)skuFlow);
        }
        return new DataResponse().setCode("0").setMsg("\u8c03\u7528\u6210\u529f").setStatus(Status.SUCCESS);
    }

    public DataResponse search(DataRequest dataRequest) {
        BasicDBList basicDBList1_or;
        DataResponse dataResponse = new DataResponse();
        JSONObject data = dataRequest.getData();
        String user_id = data.getString("user_id");
        String vip_id = data.getString("vip_id");
        String search_text = data.getString("content");
        String type = data.getString("type");
        String query_type = data.getString("query_type");
        Query query_ = new Query();
        query_.addCriteria((CriteriaDefinition)Criteria.where((String)"user_id").is((Object)data.getString("user_id")));
        User user_ = (User)this.mongoTemplate.findOne(query_, User.class);
        String u_uin = user_.getUin();
        int page_num = data.getIntValue("page_num");
        int page_size = data.getIntValue("page_size");
        DBCollection collection = this.mongoTemplate.getCollection("def_order");
        BasicDBObject basicDB = new BasicDBObject();
        BasicDBList basicDBList1 = new BasicDBList();
        basicDBList1.add((Object)new BasicDBObject("is_active", (Object)"Y"));
        basicDBList1.add((Object)new BasicDBObject("user_id", (Object)user_id));
        if (StringUtils.isNotNull((Object)query_type)) {
            if ("0".equals(query_type)) {
                basicDBList1.add((Object)new BasicDBObject("order_status", (Object)query_type));
                basicDBList1.add((Object)new BasicDBObject("pay_status", (Object)"1"));
            } else if ("-1".equals(query_type)) {
                basicDBList1.add((Object)new BasicDBObject("pay_status", (Object)"0"));
            } else if ("1".equals(query_type)) {
                basicDBList1_or = new BasicDBList();
                basicDBList1_or.add((Object)new BasicDBObject("order_status", (Object)"2"));
                basicDBList1_or.add((Object)new BasicDBObject("order_status", (Object)"1"));
                basicDBList1.add((Object)new BasicDBObject("$or", (Object)basicDBList1_or));
                basicDBList1.add((Object)new BasicDBObject("pay_status", (Object)new BasicDBObject("$ne", (Object)"3")));
            } else {
                basicDBList1.add((Object)new BasicDBObject("order_status", (Object)query_type));
            }
        }
        if (StringUtils.isNotNull((Object)vip_id)) {
            basicDBList1.add((Object)new BasicDBObject("order_vip.vip_id", (Object)vip_id));
        }
        if ("text".equals(type)) {
            basicDBList1_or = new BasicDBList();
            basicDBList1_or.add((Object)new BasicDBObject("order_vip.vip_name", (Object)new BasicDBObject("$regex", (Object)search_text).append("$options", (Object)"i")));
            basicDBList1_or.add((Object)new BasicDBObject("order_no", (Object)new BasicDBObject("$regex", (Object)search_text).append("$options", (Object)"i")));
            basicDBList1_or.add((Object)new BasicDBObject("productList.product_name", (Object)new BasicDBObject("$regex", (Object)search_text).append("$options", (Object)"i")));
            basicDBList1.add((Object)new BasicDBObject("$or", (Object)basicDBList1_or));
        }
        if ("date".equals(type)) {
            basicDBList1.add((Object)new BasicDBObject("order_time", (Object)new BasicDBObject("$regex", (Object)search_text).append("$options", (Object)"i")));
        }
        basicDB.put((Object)"$and", (Object)basicDBList1);
        DBCursor dbCur = collection.find((DBObject)basicDB).skip(page_num * page_size).limit(page_size).sort((DBObject)new BasicDBObject("order_time", (Object)-1));
        JSONObject jsonObject = new JSONObject();
        JSONArray productList = new JSONArray();
        while (dbCur.hasNext()) {
            DBObject object = dbCur.next();
            Map map = object.toMap();
            Object id = map.get("_id");
            map.put("id", id.toString());
            map.remove("_id");
            productList.add((Object)map);
        }
        jsonObject.put("message", (Object)productList);
        return dataResponse.setStatus(Status.SUCCESS).setData(jsonObject).setCode("0");
    }

    public DataResponse applyRefund(DataRequest dataRequest) {
        JSONObject object = dataRequest.getData();
        String order_id = object.getString("order_id");
        String user_id = object.getString("user_id");
        String type = object.getString("type");
        String refund_kind = object.getString("refund_kind");
        String is_reapply = object.getString("is_reapply");
        String team_id = object.getString("team_id");
        double refund_amount = object.getDoubleValue("refund_amount");
        String current = TimeUtils.getTime((long)System.currentTimeMillis());
        String description = object.getString("description");
        Query query = new Query((CriteriaDefinition)Criteria.where((String)"order_id").is((Object)order_id).and("is_active").is((Object)"Y"));
        if ("Y".equals(is_reapply)) {
            this.mongoTemplate.upsert(query, Update.update((String)"is_active", (Object)"N"), ApplyRefund.class);
        }
        ApplyRefund applyRefund = (ApplyRefund)this.mongoTemplate.findOne(query, ApplyRefund.class);
        Order order = (Order)this.mongoTemplate.findOne(query, Order.class);
        String is_online_pay = order.getIs_online_pay();
        String trade_type = order.getTrade_type();
        JSONArray array = order.getProductList();
        String corp_code = "";
        for (int i = 0; i < array.size(); ++i) {
            JSONObject a = array.getJSONObject(i);
            if (!a.containsKey((Object)"corp_code") || !StringUtils.isNotNull((Object)a.getString("corp_code"))) continue;
            corp_code = a.getString("corp_code");
        }
        if (null == applyRefund) {
            JSONObject jsonObject = new JSONObject();
            Query query1 = new Query();
            query1.addCriteria((CriteriaDefinition)Criteria.where((String)"order_id").is((Object)order_id));
            if (StringUtils.isNotNull((Object)is_online_pay) && "Y".equals(is_online_pay) || StringUtils.isNotNull((Object)trade_type) && "online".equals(trade_type)) {
                applyRefund = new ApplyRefund();
                applyRefund.setUser_id(user_id);
                applyRefund.setCreator_id(user_id);
                applyRefund.setModified_date(current);
                applyRefund.setModifier_id(user_id);
                applyRefund.setCreated_date(current);
                applyRefund.setIs_active("Y");
                applyRefund.setOrder_id(order_id);
                applyRefund.setStatus("0");
                applyRefund.setCorp_code(corp_code);
                applyRefund.setType(type);
                applyRefund.setTeam_id(team_id);
                applyRefund.setRefund_kind(refund_kind);
                applyRefund.setDescription(description);
                applyRefund.setRefund_amount(refund_amount);
                applyRefund.set_id(new ObjectId());
                applyRefund.setRefund_logistics_url(this.refund_logistics_url + "?order_id=" + order_id + "&app_id=" + this.public_appid);
                applyRefund.setRefund_logistics_title("\u4eb2\uff0c\u8bf7\u586b\u5199\u60a8\u7684\u9000\u8d27\u4fe1\u606f");
                this.mongoTemplate.save((Object)applyRefund);
                jsonObject.put("id", (Object)applyRefund.get_id().toString());
                Update update = new Update();
                update.set("refund_kind", (Object)refund_kind);
                update.set("refund_good_status", (Object)"0");
                this.mongoTemplate.upsert(query1, update, Order.class);
            } else {
                Update update = new Update();
                update.set("refund_kind", (Object)refund_kind);
                update.set("refund_good_status", (Object)"1");
                update.set("pay_status", (Object)"3");
                update.set("pay_info.pay_status", (Object)"3");
                update.set("refund_date", (Object)TimeUtils.getCurrentTimeInString((SimpleDateFormat)TimeUtils.DATETIME_FORMAT_DATE));
                this.mongoTemplate.upsert(query1, update, Order.class);
            }
            return new DataResponse().setStatus(Status.SUCCESS).setData(jsonObject).setMsg("\u63d0\u4ea4\u6210\u529f").setCode("0");
        }
        String status = applyRefund.getStatus();
        DataResponse dataResponse = new DataResponse();
        if ("0".equals(status)) {
            return dataResponse.setMsg("\u7533\u8bf7\u5df2\u63d0\u4ea4,\u7b49\u5f85\u5ba1\u6838").setStatus(Status.FAILED);
        }
        if ("1".equals(status)) {
            return dataResponse.setMsg("\u7533\u8bf7\u5df2\u63d0\u4ea4,\u5ba1\u6838\u4e2d").setStatus(Status.FAILED);
        }
        if ("2".equals(status)) {
            return dataResponse.setMsg("\u5ba1\u6838\u901a\u8fc7,\u7b49\u5f85\u9000\u6b3e").setStatus(Status.FAILED);
        }
        return dataResponse.setMsg("\u5ba1\u6838\u62d2\u7edd,\u8bf7\u8054\u7cfb\u5546\u5bb6").setStatus(Status.FAILED);
    }

    public DataResponse cancelRefund(DataRequest dataRequest) {
        JSONObject object = dataRequest.getData();
        String order_id = object.getString("order_id");
        String user_id = object.getString("user_id");
        Query query = new Query((CriteriaDefinition)Criteria.where((String)"order_id").is((Object)order_id).and("is_active").is((Object)"Y"));
        Order order = (Order)this.mongoTemplate.findOne(query, Order.class);
        String is_online_pay = order.getIs_online_pay();
        String trade_type = order.getTrade_type();
        String pay_status = order.getPay_status();
        if (!"3".equals(pay_status)) {
            if ("Y".equals(is_online_pay) || "online".equals(trade_type)) {
                this.mongoTemplate.upsert(query, Update.update((String)"is_active", (Object)"N"), ApplyRefund.class);
                this.mongoTemplate.upsert(query, Update.update((String)"refund_good_status", (Object)""), Order.class);
                this.mongoTemplate.upsert(query, Update.update((String)"refund_kind", (Object)""), Order.class);
            } else {
                this.mongoTemplate.upsert(query, Update.update((String)"is_active", (Object)"N"), ApplyRefund.class);
                this.mongoTemplate.upsert(query, Update.update((String)"refund_good_status", (Object)""), Order.class);
                this.mongoTemplate.upsert(query, Update.update((String)"refund_kind", (Object)""), Order.class);
                this.mongoTemplate.upsert(query, Update.update((String)"pay_status", (Object)"1"), Order.class);
                this.mongoTemplate.upsert(query, Update.update((String)"pay_info.pay_status", (Object)"1"), Order.class);
            }
        } else {
            return new DataResponse().setStatus(Status.FAILED).setMsg("\u64a4\u9500\u5931\u8d25\uff0c\u5df2\u9000\u6b3e");
        }
        return new DataResponse().setStatus(Status.SUCCESS).setMsg("\u64a4\u9500\u6210\u529f");
    }

    public DataResponse queryApplyRefund(DataRequest dataRequest) {
        JSONObject object = dataRequest.getData();
        String order_id = object.getString("order_id");
        BasicDBObject basicDBObject = new BasicDBObject();
        basicDBObject.put((Object)"is_active", (Object)"Y");
        basicDBObject.put((Object)"order_id", (Object)order_id);
        DBObject dbObject = this.mongoTemplate.getCollection("def_apply_refund").findOne((DBObject)basicDBObject);
        JSONObject object1 = new JSONObject();
        if (null != dbObject) {
            DBObject dbObject_order = this.mongoTemplate.getCollection("def_order").findOne((DBObject)basicDBObject);
            HashMap map = new HashMap();
            map.putAll(dbObject.toMap());
            map.putAll(dbObject_order.toMap());
            map.remove("_id");
            object1.put("message", map);
        }
        return new DataResponse().setStatus(Status.SUCCESS).setMsg("").setData(object1);
    }

    public DataResponse saveRefundLogistics(DataRequest dataRequest) {
        JSONObject object = dataRequest.getData();
        JSONObject logistics_info = object.getJSONObject("logistics_info");
        String order_id = object.getString("order_id");
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"order_id").is((Object)order_id));
        if (null != logistics_info) {
            this.mongoTemplate.upsert(query, Update.update((String)"logistics_info", (Object)logistics_info), ApplyRefund.class);
        }
        return new DataResponse().setStatus(Status.SUCCESS).setMsg("\u4fdd\u5b58\u6210\u529f");
    }

    public DataResponse orderCreate(DataRequest dataRequest) {
        DataResponse dataResponse;
        block21: {
            JSONObject data = dataRequest.getData();
            dataResponse = new DataResponse();
            JSONObject jsonObject = null;
            try {
                String results;
                JSONObject addShoppingCart_response;
                JSONObject datas;
                JSONObject jsonObject_;
                JSONObject object_jnby;
                JSONObject pdate;
                String cardNum;
                JSONArray orderItems;
                String hash;
                block22: {
                    String open_id = data.getString("open_id");
                    String app_id = data.getString("app_id");
                    hash = data.getString("hash");
                    String team_id = data.getString("team_id");
                    String unionid = data.getString("unionid");
                    String user_id = data.getString("user_id");
                    String COMMENTS = "http://sharewx.jnby.com/Index/Html/00000000000000.html";
                    if (StringUtils.isNotNull((Object)user_id)) {
                        COMMENTS = COMMENTS + "|empId=" + user_id;
                    }
                    if (StringUtils.isNotNull((Object)team_id)) {
                        COMMENTS = COMMENTS + "|teamId=" + team_id;
                    }
                    orderItems = data.getJSONArray("orderItem");
                    JSONArray array = new JSONArray();
                    for (int i = 0; i < orderItems.size(); ++i) {
                        JSONObject object = orderItems.getJSONObject(i);
                        object.put("CID", (Object)"0");
                        object.put("COMMENTS", (Object)COMMENTS);
                        array.add((Object)object);
                    }
                    if (StringUtils.isNull((Object)unionid)) {
                        String param = this.redisClient.getValueOps().getValueString("wx_" + app_id + "_" + open_id);
                        if (null == param) {
                            return new DataResponse().setStatus(Status.FAILED).setCode("0").setMsg("\u6388\u6743\u4fe1\u606f\u5931\u8d25");
                        }
                        JSONObject dataParam = JSONObject.parseObject((String)param);
                        unionid = dataParam.getString("unionid");
                        String nick_name = dataParam.getString("nickname");
                        String head_img = dataParam.getString("headimgurl");
                        JSONObject pdate2 = new JSONObject();
                        pdate2.put("openid", (Object)open_id);
                        pdate2.put("openId", (Object)open_id);
                        pdate2.put("unionid", (Object)unionid);
                        pdate2.put("headImgUrl", (Object)head_img);
                        pdate2.put("nickName", (Object)nick_name);
                        pdate2.put("hash", (Object)hash);
                        pdate2.put("orderItems", (Object)array);
                        String result = NetWorkCommon.JnbyOrderCreate((JSONObject)pdate2);
                        if (null != result) {
                            jsonObject = JSONObject.parseObject((String)result);
                            if (jsonObject.containsKey((Object)"ret") && jsonObject.containsKey((Object)"errMsg")) {
                                if ("1".equals(jsonObject.getString("ret"))) {
                                    String outOrderid = jsonObject.getString("outOrderid");
                                    JSONObject object = new JSONObject();
                                    String url = "https://jnby.jnby.com/weixin/" + hash + "/mall/page/orderConfirm.html?orderid=" + outOrderid + "&empId=" + user_id + "&channel=wtk";
                                    if (StringUtils.isNotNull((Object)team_id)) {
                                        url = url + "&teamId=" + team_id;
                                    }
                                    object.put("url", (Object)url);
                                    dataResponse.setData(object).setStatus(Status.SUCCESS).setCode("0");
                                } else {
                                    dataResponse.setMsg(jsonObject.getString("errMsg")).setStatus(Status.FAILED).setCode("-1");
                                }
                            } else {
                                dataResponse.setMsg("\u4e0b\u5355\u5931\u8d25").setStatus(Status.FAILED).setCode("-1");
                            }
                        } else {
                            dataResponse.setMsg("\u4e0b\u5355\u5931\u8d25").setStatus(Status.FAILED).setCode("-1");
                        }
                        break block21;
                    }
                    cardNum = data.getString("cardNum");
                    pdate = null;
                    object_jnby = null;
                    if (StringUtils.isNull((Object)cardNum)) {
                        pdate = new JSONObject();
                        object_jnby = new JSONObject();
                        pdate.put("openId", (Object)open_id);
                        pdate.put("optType", (Object)"1");
                        pdate.put("moblie", (Object)"");
                        object_jnby.put("hash", (Object)hash);
                        object_jnby.put("apiUrl", (Object)"open-api/memberQuery.json");
                        object_jnby.put("apiParam", (Object)pdate);
                        try {
                            String string = NetWorkCommon.JnbyDm((JSONObject)object_jnby);
                            if (null != string) {
                                String results2;
                                JSONObject memberQuery_response;
                                JSONObject datas2;
                                JSONObject jsonObject_2 = JSONObject.parseObject((String)string);
                                if (jsonObject_2.containsKey((Object)"data") && jsonObject_2.containsKey((Object)"error") && (datas2 = JSONObject.parseObject((String)jsonObject_2.getString("data"))).containsKey((Object)"memberQuery_response") && null != (memberQuery_response = datas2.getJSONObject("memberQuery_response")) && memberQuery_response.containsKey((Object)"result") && "1".equals(results2 = memberQuery_response.getString("result"))) {
                                    JSONObject memberInfo = memberQuery_response.getJSONObject("memberInfo");
                                    cardNum = memberInfo.getString("cardNo");
                                }
                                break block22;
                            }
                            return dataResponse.setMsg("\u67e5\u8be2\u4f1a\u5458\u5931\u8d25").setStatus(Status.FAILED).setCode("-1");
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            return dataResponse.setMsg("\u67e5\u8be2\u4f1a\u5458\u5931\u8d25").setStatus(Status.FAILED).setCode("-1");
                        }
                    }
                }
                pdate = new JSONObject();
                pdate.put("memberCardNo", (Object)cardNum);
                JSONArray proList = new JSONArray();
                for (int i = 0; i < orderItems.size(); ++i) {
                    JSONObject object = orderItems.getJSONObject(i);
                    JSONObject object1 = new JSONObject();
                    object1.put("skuCode", (Object)object.getString("BARCODE"));
                    object1.put("num", (Object)object.getString("SL"));
                    proList.add((Object)object1);
                }
                pdate.put("proList", (Object)proList);
                object_jnby = new JSONObject();
                object_jnby.put("hash", (Object)hash);
                object_jnby.put("apiUrl", (Object)"open-api/addShoppingCart.json");
                object_jnby.put("apiParam", (Object)pdate);
                String result = NetWorkCommon.JnbyDm((JSONObject)object_jnby);
                if (null != result && (jsonObject_ = JSONObject.parseObject((String)result)).containsKey((Object)"data") && jsonObject_.containsKey((Object)"error") && (datas = JSONObject.parseObject((String)jsonObject_.getString("data"))).containsKey((Object)"addShoppingCart_response") && null != (addShoppingCart_response = datas.getJSONObject("addShoppingCart_response")) && addShoppingCart_response.containsKey((Object)"result") && "1".equals(results = addShoppingCart_response.getString("result"))) {
                    String outOrderid = addShoppingCart_response.getString("data");
                    JSONObject object = new JSONObject();
                    String url = "/pages/mall/mall-shopping-cart-order-ensure/mall-shopping-cart-order-ensure?shoppingCartIds=" + outOrderid;
                    object.put("url", (Object)url);
                    dataResponse.setData(object).setStatus(Status.SUCCESS).setCode("0");
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return dataResponse;
    }

    public DataResponse info(DataRequest dataRequest) {
        DBObject object;
        DBObject temp_user;
        String user_id1 = dataRequest.getData().getString("user_id");
        DataResponse dataResponse = new DataResponse();
        JSONObject jsonObject = new JSONObject();
        JSONArray productList = new JSONArray();
        JSONObject data = dataRequest.getData();
        String order_id = data.getString("order_id");
        BasicDBObject basicDBObject = new BasicDBObject();
        basicDBObject.put((Object)"order_id", (Object)order_id);
        DBCollection collection_u = this.mongoTemplate.getCollection("def_user");
        DBCollection collection_s = this.mongoTemplate.getCollection("def_store");
        DBCollection collection = this.mongoTemplate.getCollection("def_order");
        DBCollection collection_order_param = this.mongoTemplate.getCollection("def_order_param");
        String store_name = "";
        if (StringUtils.isNotNull((Object)user_id1) && StringUtils.isNotNull((Object)(temp_user = collection_u.findOne((DBObject)new BasicDBObject("user_id", (Object)user_id1))))) {
            DBObject temp_store;
            String store_id;
            String string = store_id = temp_user.get("store_id") != null ? temp_user.get("store_id").toString() : "";
            if (StringUtils.isNotNull((Object)store_id) && StringUtils.isNotNull((Object)(temp_store = collection_s.findOne((DBObject)new BasicDBObject("store_id", (Object)store_id))))) {
                store_name = temp_store.get("store_name") != null ? temp_store.get("store_name").toString() : "";
            }
        }
        DBObject dbObject = collection_order_param.findOne();
        int over_time = 12;
        if (null != dbObject && dbObject.containsField("order_overdue_time")) {
            over_time = Integer.parseInt(dbObject.get("order_overdue_time").toString());
        }
        if (null != (object = collection.findOne((DBObject)basicDBObject))) {
            JSONArray product;
            Object id;
            Map map;
            block28: {
                map = object.toMap();
                id = map.get("_id");
                String pos_time = map.get("pos_time") != null ? map.get("pos_time").toString() : "";
                String logistics_time = map.get("logistics_time") != null ? map.get("logistics_time").toString() : "";
                String deliver_good_store_id = map.get("deliver_goods_store_id") != null ? map.get("deliver_goods_store_id").toString() : "";
                String deliver_good_store_name = map.get("deliver_goods_store") != null ? map.get("deliver_goods_store_name").toString() : "";
                map.put("pos_time", pos_time);
                map.put("delivery_time", logistics_time);
                map.put("deliver_good_store_id", deliver_good_store_id);
                map.put("deliver_good_store_name", deliver_good_store_name);
                String currentTimeInString = TimeUtils.getCurrentTimeInString((SimpleDateFormat)TimeUtils.DATETIME_FORMAT_DATE);
                String create_date = StringUtils.valueOf(map.get("created_date"));
                String is_online_pay = StringUtils.valueOf(map.get("is_online_pay"));
                String trade_type = StringUtils.valueOf(map.get("trade_type"));
                String order_vip = StringUtils.valueOf(map.get("order_vip"));
                String user_id = StringUtils.valueOf(map.get("user_id"));
                String coupon_id_array = StringUtils.valueOf(map.get("coupon_id_array"));
                if (StringUtils.isNotNull((Object)coupon_id_array)) {
                    JSONArray array = JSONArray.parseArray((String)coupon_id_array);
                    for (int i = 0; i < array.size(); ++i) {
                        String coupon_id = array.getString(i);
                        Query query = new Query((CriteriaDefinition)Criteria.where((String)"_id").is((Object)new ObjectId(coupon_id)));
                        Coupon coupon = (Coupon)this.mongoTemplate.findOne(query, Coupon.class);
                        query = new Query((CriteriaDefinition)Criteria.where((String)"_id").is((Object)new ObjectId(coupon.getCoupon_type_id())));
                        CouponType couponType = (CouponType)this.mongoTemplate.findOne(query, CouponType.class);
                        map.put("coupon_info", JSONObject.parseObject((String)couponType.toString()));
                    }
                }
                String pay_status = StringUtils.valueOf(map.get("pay_status"));
                JSONObject pay_info = JSONObject.parseObject((String)map.get("pay_info").toString());
                if (pay_info.containsKey((Object)"pay_way") && "offline".equals(pay_info.getString("pay_way"))) {
                    JSONObject alipay_payment;
                    String qrcode;
                    JSONObject wechat_payment;
                    JSONObject user = this.userRedisUtils.getUser(user_id, false);
                    if (user.containsKey((Object)"wechat_payment") && !"".equals(StringUtils.checkString((String)(wechat_payment = user.getJSONObject("wechat_payment")).getString("qrcode")))) {
                        qrcode = wechat_payment.getString("qrcode");
                        qrcode = this.aliCDNUrlAuth.getAuthURLA(qrcode);
                        wechat_payment.put("qrcode", (Object)qrcode);
                        map.put("wechat_payment", wechat_payment);
                    }
                    if (user.containsKey((Object)"alipay_payment") && !"".equals(StringUtils.checkString((String)(alipay_payment = user.getJSONObject("alipay_payment")).getString("qrcode")))) {
                        qrcode = alipay_payment.getString("qrcode");
                        qrcode = this.aliCDNUrlAuth.getAuthURLA(qrcode);
                        alipay_payment.put("qrcode", (Object)qrcode);
                        map.put("alipay_payment", alipay_payment);
                    }
                }
                if ("Y".equals(is_online_pay) || "online".equals(trade_type)) {
                    if (StringUtils.isNotNull(map.get("expired_time"))) {
                        if (String.valueOf(map.get("expired_time")).compareTo(currentTimeInString) > 0) {
                            map.put("is_overtime", "false");
                        } else {
                            map.put("is_overtime", "true");
                        }
                    } else if (TimeUtils.getDistanceTimes((String)create_date, (String)currentTimeInString) >= (long)over_time) {
                        if (!"1".equals(pay_status)) {
                            map.put("is_overtime", "true");
                        } else {
                            map.put("is_overtime", "false");
                        }
                    } else {
                        map.put("is_overtime", "false");
                    }
                } else {
                    map.put("is_overtime", "false");
                }
                map.put("can_use_coupon", this.canUseCoupon(map));
                map.put("store_name", store_name);
                product = JSONArray.parseArray((String)map.get("productList").toString());
                try {
                    Update update1_;
                    Query query1_;
                    Update update1;
                    Query query1;
                    JSONObject object1;
                    if (null == map.get("logisticsList")) break block28;
                    JSONArray logisticsList = JSONArray.parseArray((String)map.get("logisticsList").toString());
                    JSONArray jsonObject1 = new JSONArray();
                    if (logisticsList.size() != 1 || !(object1 = logisticsList.getJSONObject(0)).containsKey((Object)"is_one") || !"Y".equals(object1.get((Object)"is_one"))) break block28;
                    if (!object1.containsKey((Object)"product_list")) {
                        object1.put("product_list", (Object)product);
                        object1.put("order_id", (Object)id.toString());
                        jsonObject1.add((Object)object1);
                        map.put("logisticsList", jsonObject1);
                        query1 = new Query();
                        query1.addCriteria((CriteriaDefinition)Criteria.where((String)"_id").is((Object)new ObjectId(id.toString())));
                        update1 = new Update();
                        update1.set("logisticsList", (Object)jsonObject1);
                        this.mongoTemplate.upsert(query1, update1, Order.class);
                        query1_ = new Query();
                        query1_.addCriteria((CriteriaDefinition)Criteria.where((String)"order_id").is((Object)id.toString()));
                        update1_ = new Update();
                        update1_.set("productList", (Object)product);
                        this.mongoTemplate.upsert(query1_, update1_, Logistics.class);
                    }
                    if (!object1.containsKey((Object)"product_list")) break block28;
                    try {
                        if (object1.getJSONArray("product_list").size() == 0) {
                            object1.put("product_list", (Object)product);
                            object1.put("order_id", (Object)id.toString());
                            jsonObject1.add((Object)object1);
                            map.put("logisticsList", jsonObject1);
                            query1 = new Query();
                            query1.addCriteria((CriteriaDefinition)Criteria.where((String)"_id").is((Object)new ObjectId(id.toString())));
                            update1 = new Update();
                            update1.set("logisticsList", (Object)jsonObject1);
                            this.mongoTemplate.upsert(query1, update1, Order.class);
                            query1_ = new Query();
                            query1_.addCriteria((CriteriaDefinition)Criteria.where((String)"order_id").is((Object)id.toString()));
                            update1_ = new Update();
                            update1_.set("productList", (Object)product);
                            this.mongoTemplate.upsert(query1_, update1_, Logistics.class);
                        }
                    }
                    catch (Exception e) {
                        object1.put("product_list", (Object)product);
                        object1.put("order_id", (Object)id.toString());
                        jsonObject1.add((Object)object1);
                        map.put("logisticsList", jsonObject1);
                        Query query12 = new Query();
                        query12.addCriteria((CriteriaDefinition)Criteria.where((String)"_id").is((Object)new ObjectId(id.toString())));
                        Update update12 = new Update();
                        update12.set("logisticsList", (Object)jsonObject1);
                        this.mongoTemplate.upsert(query12, update12, Order.class);
                        Query query1_2 = new Query();
                        query1_2.addCriteria((CriteriaDefinition)Criteria.where((String)"order_id").is((Object)id.toString()));
                        Update update1_2 = new Update();
                        update1_2.set("productList", (Object)product);
                        this.mongoTemplate.upsert(query1_2, update1_2, Logistics.class);
                    }
                }
                catch (Exception e) {
                    log.error((Object)e, (Throwable)e);
                }
            }
            JSONArray jsonArray = new JSONArray();
            for (int i = 0; i < product.size(); ++i) {
                JSONObject jsonObject1 = product.getJSONObject(i);
                JSONArray objects = jsonObject1.getJSONArray("product_image_url");
                JSONArray array = new JSONArray();
                for (int j = 0; j < objects.size(); ++j) {
                    JSONObject jsonObject2 = objects.getJSONObject(j);
                    String image = jsonObject2.getString("image_url");
                    if (!image.startsWith("http")) {
                        String image_url = jsonObject2.getString("image_url");
                        image = this.aliCDNUrlAuth.getAuthURLA(image_url);
                    }
                    jsonObject2.put("image_url", (Object)image);
                    array.add((Object)jsonObject2);
                }
                jsonObject1.put("product_image_url", (Object)array);
                jsonArray.add((Object)jsonObject1);
            }
            String order_status = map.get("order_status").toString();
            String type = map.get("type").toString();
            map.remove("_id");
            map.put("id", id.toString());
            map.put("order_status", order_status);
            map.put("productList", jsonArray);
            productList.add((Object)map);
        }
        jsonObject.put("message", (Object)productList);
        return dataResponse.setStatus(Status.SUCCESS).setData(jsonObject).setCode("0");
    }

    private JSONArray setOrderDetailProductParentTeam(JSONArray order_product_array, String grade_id) {
        if (order_product_array == null || order_product_array.isEmpty()) {
            log.error("order product array can not be null");
            return order_product_array;
        }
        String parent_team_id = null;
        String team_product_id = null;
        JSONObject order_product_info = null;
        int order_product_length = order_product_array.size();
        JSONArray newOrderProduct = new JSONArray();
        for (int i = 0; i < order_product_length; ++i) {
            DBObject commission;
            String team_commission_rule_id;
            DBObject teamProduct;
            BasicDBObject queryTeamProduct;
            order_product_info = order_product_array.getJSONObject(i);
            team_product_id = order_product_info.getString("team_product_id");
            if (StringUtils.isNull((Object)team_product_id) && StringUtils.isNotNull((Object)order_product_info.getString("team_id"))) {
                queryTeamProduct = new BasicDBObject();
                queryTeamProduct.put((Object)"team_id", (Object)order_product_info.getString("team_id"));
                queryTeamProduct.put((Object)"product_id", (Object)order_product_info.getString("product_id"));
                try {
                    teamProduct = this.mongoTemplate.getCollection("def_team_product").findOne((DBObject)queryTeamProduct);
                    if (teamProduct != null) {
                        order_product_info.put("team_product_id", (Object)teamProduct.get("_id").toString());
                        order_product_info.put("parent_team_id", (Object)StringUtils.valueOf((Object)teamProduct.get("from_team_id")));
                        order_product_info.put("team_commission_rule_id", teamProduct.get("team_commission_rule_id"));
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            team_product_id = order_product_info.getString("team_product_id");
            parent_team_id = order_product_info.getString("parent_team_id");
            if (StringUtils.isNull((Object)parent_team_id) && StringUtils.isNotNull((Object)team_product_id)) {
                try {
                    queryTeamProduct = new BasicDBObject();
                    queryTeamProduct.put((Object)"_id", (Object)new ObjectId(team_product_id));
                    teamProduct = this.mongoTemplate.getCollection("def_team_product").findOne((DBObject)queryTeamProduct);
                    if (teamProduct != null) {
                        order_product_info.put("parent_team_id", (Object)StringUtils.valueOf((Object)teamProduct.get("from_team_id")));
                    }
                }
                catch (Exception e) {
                    log.error("string to objectid error:" + e.getLocalizedMessage(), (Throwable)e);
                }
            }
            if (StringUtils.isNotNull((Object)(team_commission_rule_id = order_product_info.getString("team_commission_rule_id"))) && StringUtils.isNotNull((Object)grade_id) && (commission = this.mongoTemplate.getCollection("def_team_commission_rule").findOne((DBObject)new BasicDBObject("_id", (Object)new ObjectId(team_commission_rule_id)))) != null) {
                JSONArray grades = JSONArray.parseArray((String)commission.get("grades").toString());
                for (int j = 0; j < grades.size(); ++j) {
                    if (!grade_id.equals(grades.getJSONObject(j).get((Object)"grade_id"))) continue;
                    order_product_info.put("commission_scale", (Object)grades.getJSONObject(j).getString("grade_scale"));
                    break;
                }
            }
            newOrderProduct.add((Object)order_product_info);
        }
        return newOrderProduct;
    }

    private DataResponse disposeGroupOrder(String activity_id, String join_record_id, String vip_id) {
        DataResponse dataResponse = new DataResponse();
        DBObject object_act = this.mongoTemplate.getCollection("def_activity").findOne((DBObject)new BasicDBObject("_id", (Object)new ObjectId(activity_id)));
        if (object_act != null && object_act.get("activity_status").equals("2")) {
            dataResponse.setStatus(Status.FAILED).setCode("-1").setMsg("\u6b64\u6d3b\u52a8\u5df2\u8fc7\u671f");
            return dataResponse;
        }
        String now = TimeUtils.getCurrentTimeInString((SimpleDateFormat)TimeUtils.DATETIME_FORMAT_DATE);
        try {
            String now_before_10 = TimeUtils.getHourAfter((double)-0.16, (String)now, (SimpleDateFormat)TimeUtils.DATETIME_FORMAT_DATE);
            BasicDBObject query_o = new BasicDBObject();
            query_o.put("activity_id", (Object)activity_id);
            query_o.put("order_vip.vip_id", (Object)vip_id);
            query_o.put("created_date", (Object)new BasicDBObject("$gt", (Object)now_before_10));
            query_o.put("pay_status", (Object)"0");
            if (StringUtils.isNull((Object)join_record_id)) {
                query_o.put("activity_join_id", null);
                DBObject orders = this.mongoTemplate.getCollection("def_order").findOne((DBObject)query_o);
                if (orders != null) {
                    JSONObject da = new JSONObject();
                    da.put("id", (Object)orders.get("order_id").toString());
                    dataResponse.setStatus(Status.SUCCESS).setCode("0").setData(da);
                    return dataResponse;
                }
            } else {
                Query query = new Query();
                query.addCriteria((CriteriaDefinition)Criteria.where((String)"_id").is((Object)new ObjectId(join_record_id)));
                ActivityJoinRecord record = (ActivityJoinRecord)this.mongoTemplate.findOne(query, ActivityJoinRecord.class);
                if (record != null) {
                    log.info("====\u62fc\u56e2\u8bb0\u5f55\uff1a" + record.toString());
                    JSONArray buyers = record.getBuyers();
                    String status = record.getStatus();
                    int people_limit = record.getPeople_limit();
                    if (status.equals("1")) {
                        return dataResponse.setStatus(Status.FAILED).setCode("-1").setMsg("\u6b64\u62fc\u56e2\u5df2\u6ee1\u5458\uff0c\u8bf7\u91cd\u65b0\u5f00\u56e2");
                    }
                    if (status.equals("-1")) {
                        return dataResponse.setStatus(Status.FAILED).setCode("-1").setMsg("\u6b64\u62fc\u56e2\u5df2\u8fc7\u671f\uff0c\u8bf7\u91cd\u65b0\u5f00\u56e2");
                    }
                    if (status.equals("lock") && !vip_id.equals(record.getLock_vipid())) {
                        return dataResponse.setStatus(Status.FAILED).setCode("-1").setMsg("\u8fd8\u6709\u5c0f\u4f19\u4f34\u672a\u652f\u4ed8\uff0c10\u5206\u949f\u5185\u672a\u4ed8\u6b3e\uff0c\u60a8\u5c31\u8fd8\u6709\u673a\u4f1a\u54e6~");
                    }
                    query_o.put("activity_join_id", (Object)join_record_id);
                    DBObject orders = this.mongoTemplate.getCollection("def_order").findOne((DBObject)query_o);
                    if (orders != null) {
                        JSONObject da = new JSONObject();
                        da.put("id", (Object)orders.get("order_id").toString());
                        dataResponse.setStatus(Status.SUCCESS).setCode("0").setData(da);
                        return dataResponse;
                    }
                    if (buyers.size() == people_limit - 1) {
                        Update update = new Update();
                        update.set("status", (Object)"lock");
                        update.set("lock_vipid", (Object)vip_id);
                        WriteResult writeResult = this.mongoTemplate.upsert(query, update, "def_activity_join_record");
                        String cron = TimeUtils.getHourAfter((double)0.17, (String)now, (SimpleDateFormat)TimeUtils.DATETIME_FORMAT_DATE);
                        JSONObject jsonObject = new JSONObject();
                        jsonObject.put("is_active", (Object)"Y");
                        jsonObject.put("class_name", (Object)"kr.weitao.weitaokr.task.ui.ActivityJob");
                        jsonObject.put("user_id", (Object)"");
                        jsonObject.put("creator_id", (Object)"");
                        jsonObject.put("modifier_id", (Object)"");
                        jsonObject.put("created_date", (Object)now);
                        jsonObject.put("modified_date", (Object)now);
                        jsonObject.put("_id", (Object)join_record_id);
                        jsonObject.put("trigger_id", (Object)("unlock" + join_record_id));
                        jsonObject.put("queue_item_id", (Object)("unlock" + join_record_id));
                        jsonObject.put("total_count", (Object)"1");
                        jsonObject.put("status", (Object)"-1");
                        JSONObject recurrence = new JSONObject();
                        recurrence.put("cron", (Object)TimeUtils.getCron((Date)TimeUtils.DATETIME_FORMAT_DATE.parse(cron)));
                        recurrence.put("type", (Object)"Fixed");
                        jsonObject.put("recurrence", (Object)recurrence);
                        int a = this.jobService.addJob(jsonObject);
                        log.info(join_record_id + "#######\u521b\u5efa\u5b9a\u65f6\u4efb\u52a1#####" + a);
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error(join_record_id + "#######\u521b\u5efa\u5b9a\u65f6\u4efb\u52a1#####" + e.getLocalizedMessage(), (Throwable)e);
        }
        return dataResponse.setCode("0").setStatus(Status.SUCCESS).setMsg("");
    }

    private Map<String, Object> disposePresellOrder(String type, Map<String, Object> map) {
        if ("presell".equals(type) && StringUtils.isNotNull((Object)map.get("activity_join_record_id"))) {
            String activity_id = map.get("activity_id").toString();
            JSONObject object_act = new JSONObject();
            object_act.put("activity_id", (Object)activity_id);
            JSONObject activity = this.uiAgent.getData(object_act, "management/activity/mob/getActivityById").getJSONObject("info");
            String rest_start_time = activity.getString("rest_start_time");
            String rest_end_time = activity.getString("rest_end_time");
            String activity_join_record_id = map.get("activity_join_record_id").toString();
            BasicDBObject query = new BasicDBObject("activity_join_record_id", (Object)activity_join_record_id);
            query.put((Object)"type", (Object)"presell_r");
            DBObject rest_order = this.mongoTemplate.getCollection("def_order").findOne((DBObject)query);
            rest_order.put("rest_start_time", (Object)rest_start_time);
            rest_order.put("rest_end_time", (Object)rest_end_time);
            map.put("rest_order", rest_order);
            map.put("is_overtime", "false");
        }
        return map;
    }

    private String getProductSkuId(String product_id) {
        String sku_id = "";
        Query q = new Query();
        q.addCriteria((CriteriaDefinition)Criteria.where((String)"product_id").is((Object)product_id));
        List sku = this.mongoTemplate.find(q, Sku.class);
        if (sku.size() > 0 && sku.size() == 1) {
            Sku skuItem = (Sku)sku.get(0);
            sku_id = skuItem.get_id().toString();
        }
        return sku_id;
    }

    private String canUseCoupon(Map<String, Object> map) {
        String can_use_coupon = "Y";
        if (StringUtils.isNotNull((Object)map.get("activity_id"))) {
            String activity_id = map.get("activity_id").toString();
            JSONObject object_act = new JSONObject();
            object_act.put("activity_id", (Object)activity_id);
            JSONObject activity = this.uiAgent.getData(object_act, "management/activity/mob/getActivityById").getJSONObject("info");
            if (activity != null && "N".equals(activity.getString("can_use_coupon"))) {
                can_use_coupon = "N";
            }
        }
        return can_use_coupon;
    }

    private void unUseCoupon(Order order) {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"order_id").is((Object)order.getOrder_id()));
        if (StringUtils.isNotNull((Object)order.getDiscount_amount())) {
            double discount_amount = order.getDiscount_amount();
            double order_amount_pay = order.getOrder_amount_pay();
            Update update = new Update();
            update.unset("coupon_id_array");
            update.set("order_amount_pay", (Object)(order_amount_pay + discount_amount));
            WriteResult writeResult = this.mongoTemplate.upsert(query, update, "def_order");
        }
    }

    public DataResponse orderCalculateByPoints(DataRequest dataRequest) {
        DataResponse dataResponse = new DataResponse();
        JSONObject data = dataRequest.getData();
        String order_id = data.getString("order_id");
        Double points = data.getDoubleValue("points");
        Double points_discount_amount = NumberUtil.round((double)(points / 100.0));
        String redisKey = "orderCouponInfo_" + order_id;
        JSONObject orderInfo = null;
        data.put("order_id", (Object)order_id);
        dataRequest.setData(data);
        if (this.redisClient.exists(redisKey)) {
            Double order_amount_pay;
            orderInfo = (JSONObject)this.redisClient.getValueOps().getValueObject(redisKey);
            JSONArray productList = orderInfo.getJSONArray("productList");
            Double original_order_amount_pay = order_amount_pay = Double.valueOf(orderInfo.getDoubleValue("order_amount_pay"));
            log.info("===========sa========order_amount_pay:{}", (Object)order_amount_pay);
            if (orderInfo.containsKey((Object)"points_discount_amount")) {
                order_amount_pay = order_amount_pay + orderInfo.getDoubleValue("points_discount_amount");
                log.info("===========sa========order_amount_pay1:{}", (Object)order_amount_pay);
            }
            Double order_amount_pay_after = order_amount_pay - points_discount_amount;
            log.info("=============sa======order_amount_pay_after:{}", (Object)order_amount_pay_after);
            if (order_amount_pay_after <= 0.0) {
                return dataResponse.setCode("-1").setStatus(Status.FAILED).setMsg("\u8ba2\u5355\u652f\u4ed8\u91d1\u989d\u6682\u4e0d\u80fd\u4e3a\u96f6\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\u79ef\u5206");
            }
            orderInfo.put("points_discount_amount", (Object)points_discount_amount);
            orderInfo.put("order_amount_pay", (Object)order_amount_pay_after);
            orderInfo.put("points", (Object)points);
            JSONArray products = new JSONArray();
            for (int i = 0; i < productList.size(); ++i) {
                JSONObject object = productList.getJSONObject(i);
                Double product_amount = object.getDoubleValue("product_amount");
                product_amount = product_amount * order_amount_pay_after / original_order_amount_pay;
                log.info("============sa=======product_amount:{}", (Object)product_amount);
                product_amount = NumberUtil.round((double)product_amount);
                object.put("product_amount", (Object)product_amount);
                products.add((Object)object);
            }
            orderInfo.put("productList", (Object)products);
            this.redisClient.getValueOps().setValueObjectWithExpire("orderCouponInfo_" + order_id, (Object)orderInfo, Long.valueOf(3600L));
        } else {
            Query query = Query.query((CriteriaDefinition)Criteria.where((String)"_id").is((Object)new ObjectId(order_id)));
            Order order = (Order)this.mongoTemplate.findOne(query, Order.class);
            orderInfo = JSONObject.parseObject((String)order.toString());
            JSONArray productList = order.getProductList();
            Double order_amount_pay = order.getOrder_amount_pay();
            log.info("==========s=========order_amount_pay:{}", (Object)order_amount_pay);
            Double order_amount_pay_after = order_amount_pay - points_discount_amount;
            log.info("=========s==========order_amount_pay_after:{}", (Object)order_amount_pay_after);
            if (order_amount_pay_after <= 0.0) {
                return dataResponse.setCode("-1").setStatus(Status.FAILED).setMsg("\u8ba2\u5355\u652f\u4ed8\u91d1\u989d\u6682\u4e0d\u80fd\u4e3a\u96f6\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\u79ef\u5206");
            }
            JSONArray products = new JSONArray();
            for (int i = 0; i < productList.size(); ++i) {
                JSONObject object = productList.getJSONObject(i);
                Double product_amount = object.getDoubleValue("product_amount");
                product_amount = product_amount * order_amount_pay_after / order_amount_pay;
                log.info("==========s=========product_amount:{}", (Object)product_amount);
                product_amount = NumberUtil.round((double)product_amount);
                object.put("product_amount", (Object)product_amount);
                products.add((Object)object);
            }
            orderInfo.put("productList", (Object)products);
            orderInfo.put("points_discount_amount", (Object)points_discount_amount);
            orderInfo.put("points", (Object)points);
            orderInfo.put("order_amount_pay", (Object)order_amount_pay_after);
            this.redisClient.getValueOps().setValueObjectWithExpire("orderCouponInfo_" + order_id, (Object)orderInfo, Long.valueOf(3600L));
        }
        return dataResponse.setData(orderInfo).setStatus(Status.SUCCESS).setCode("0");
    }

    public DataResponse refundGoodReceipt(DataRequest dataRequest) {
        JSONObject data = dataRequest.getData();
        String refund_id = data.getString("refund_id");
        Update update = new Update();
        update.set("logistics_confirm_time", (Object)TimeUtils.getTime((long)System.currentTimeMillis()));
        this.mongoTemplate.updateMulti(Query.query((CriteriaDefinition)Criteria.where((String)"_id").is((Object)new ObjectId(refund_id))), update, ApplyRefund.class);
        return new DataResponse().setStatus(Status.SUCCESS).setCode("0").setMsg("\u786e\u8ba4\u6536\u8d27\u6210\u529f");
    }

    public DataResponse unUsePoint(DataRequest dataRequest) {
        DataResponse dataResponse = new DataResponse();
        JSONObject data = dataRequest.getData();
        String order_id = data.getString("order_id");
        String redisKey = "orderCouponInfo_" + order_id;
        JSONObject orderInfo = null;
        data.put("order_id", (Object)order_id);
        dataRequest.setData(data);
        if (this.redisClient.exists(redisKey)) {
            orderInfo = (JSONObject)this.redisClient.getValueOps().getValueObject(redisKey);
            JSONArray productList = orderInfo.getJSONArray("productList");
            Double order_amount_pay = orderInfo.getDoubleValue("order_amount_pay");
            log.info("============ua-order_amount_pay:{}", (Object)order_amount_pay);
            Double order_amount_pay_after = 0.0;
            if (orderInfo.containsKey((Object)"points_discount_amount")) {
                order_amount_pay_after = order_amount_pay + orderInfo.getDoubleValue("points_discount_amount");
                log.info("============ua-order_amount_pay_after:{}", (Object)order_amount_pay_after);
            } else {
                order_amount_pay_after = order_amount_pay;
                log.info("============ua-order_amount_pay_after1:{}", (Object)order_amount_pay_after);
            }
            orderInfo.remove((Object)"points_discount_amount");
            orderInfo.put("order_amount_pay", (Object)order_amount_pay_after);
            JSONArray products = new JSONArray();
            for (int i = 0; i < productList.size(); ++i) {
                JSONObject object = productList.getJSONObject(i);
                Double product_amount = object.getDoubleValue("product_amount");
                product_amount = product_amount * order_amount_pay_after / order_amount_pay;
                log.info("============ua-product_amount:{}", (Object)product_amount);
                product_amount = NumberUtil.round((double)product_amount);
                object.put("product_amount", (Object)product_amount);
                products.add((Object)object);
            }
            orderInfo.put("productList", (Object)products);
            this.redisClient.getValueOps().setValueObjectWithExpire("orderCouponInfo_" + order_id, (Object)orderInfo, Long.valueOf(3600L));
        } else {
            Query query = Query.query((CriteriaDefinition)Criteria.where((String)"_id").is((Object)new ObjectId(order_id)));
            Order order = (Order)this.mongoTemplate.findOne(query, Order.class);
            orderInfo = JSONObject.parseObject((String)order.toString());
            this.redisClient.getValueOps().setValueObjectWithExpire("orderCouponInfo_" + order_id, (Object)orderInfo, Long.valueOf(3600L));
        }
        return dataResponse.setData(orderInfo).setStatus(Status.SUCCESS).setCode("0");
    }

    private boolean isOverTime(JSONObject order, int over_time, String currentTimeInString) {
        boolean overTime = true;
        String createDate = StringUtils.valueOf((Object)order.get((Object)"created_date"));
        if (StringUtils.isNotNull((Object)order.get((Object)"expired_time"))) {
            if (order.getString("expired_time").compareTo(currentTimeInString) > 0) {
                overTime = false;
            }
        } else if (TimeUtils.getDistanceTimes((String)createDate, (String)currentTimeInString) < (long)over_time) {
            overTime = false;
        }
        if ("1".equals(order.getString("pay_status"))) {
            overTime = false;
        }
        return overTime;
    }

    static /* synthetic */ Logger access$000() {
        return log;
    }
}

