/*
 * Decompiled with CFR 0.152.
 */
package kr.weitao.weitaokr.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.mongodb.BasicDBObject;
import com.mongodb.DBCollection;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import java.text.SimpleDateFormat;
import java.util.List;
import java.util.Map;
import kr.weitao.business.common.feignclient.DataService;
import kr.weitao.business.common.feignclient.ProductService;
import kr.weitao.business.common.feignclient.TeamService;
import kr.weitao.business.entity.User;
import kr.weitao.business.entity.data.MaterialGroup;
import kr.weitao.business.entity.data.Product;
import kr.weitao.business.entity.data.TeamMaterialGroup;
import kr.weitao.common.util.NumberUtil;
import kr.weitao.common.util.StringUtils;
import kr.weitao.common.util.TimeUtils;
import kr.weitao.starter.model.DataRequest;
import kr.weitao.starter.model.DataResponse;
import kr.weitao.starter.model.Status;
import kr.weitao.weitaokr.service.OpenService;
import kr.weitao.weitaokr.service.OrderService;
import kr.weitao.weitaokr.service.common.SendMessage;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bson.types.ObjectId;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Service;

@Service
public class OpenServiceImpl
implements OpenService {
    private static final Logger log = LogManager.getLogger(OpenServiceImpl.class);
    @Autowired
    MongoTemplate mongoTemplate;
    @Autowired
    OrderService orderService;
    @Autowired
    ProductService productService;
    @Autowired
    DataService dataService;
    @Autowired
    TeamService teamService;
    @Autowired
    SendMessage send_message;

    public DataResponse createUser(DataRequest dataRequest) {
        DBCollection collection = this.mongoTemplate.getCollection("def_user");
        JSONObject data = dataRequest.getData();
        data.remove((Object)"topic");
        String user_id = data.getString("user_id");
        String user_name = data.getString("user_name");
        String phone = data.getString("phone");
        String corp_code = data.getString("corp_code");
        BasicDBObject query = new BasicDBObject();
        query.put((Object)"phone", (Object)phone);
        DBObject object = collection.findOne((DBObject)query);
        DataRequest dataRequest1 = new DataRequest();
        if (null != object) {
            if (StringUtils.isNotNull((Object)object.get("corp_code")) && !object.get("corp_code").toString().equals(corp_code)) {
                new DataResponse().setStatus(Status.SUCCESS).setCode("0").setMsg("\u5176\u4ed6\u4f01\u4e1a\u6709\u8be5\u5458\u5de5\uff0c\u6682\u4e0d\u540c\u6b65");
            }
            BasicDBObject update = new BasicDBObject();
            data.put("modified_date", (Object)TimeUtils.getCurrentTimeInString((SimpleDateFormat)TimeUtils.DATETIME_FORMAT_DATE));
            update.put((Object)"$set", (Object)data);
            collection.updateMulti((DBObject)query, (DBObject)update);
            if ("C10055".equals(corp_code)) {
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("user_id", (Object)user_id);
                jsonObject.put("team_id", (Object)"5c32fc89a403bb3463279dfa");
                jsonObject.put("type", (Object)"join_team");
                jsonObject.put("is_notice", (Object)"N");
                jsonObject.put("explain", (Object)(user_name + "\u7533\u8bf7\u5165\u56e2"));
                dataRequest1.setData(jsonObject);
                DataResponse dataResponse = this.teamService.getData("/team/membersApply", dataRequest1);
                if ("SUCCESS".equals(dataResponse.getStatus().toString())) {
                    jsonObject = new JSONObject();
                    jsonObject.put("user_id", (Object)"330822198810255422");
                    jsonObject.put("is_all", (Object)"Y");
                    jsonObject.put("apply", (Object)"Y");
                    jsonObject.put("ids", (Object)new JSONArray());
                    dataRequest1.setData(jsonObject);
                    dataResponse = this.teamService.getData("/team/acceptMemberAllApply", dataRequest1);
                }
            }
        } else {
            query = new BasicDBObject();
            query.put((Object)"user_id", (Object)user_id);
            object = collection.findOne((DBObject)query);
            if (null != object) {
                BasicDBObject update = new BasicDBObject();
                data.put("modified_date", (Object)TimeUtils.getCurrentTimeInString((SimpleDateFormat)TimeUtils.DATETIME_FORMAT_DATE));
                update.put((Object)"$set", (Object)data);
                collection.updateMulti((DBObject)query, (DBObject)update);
            } else {
                data.put("modified_date", (Object)TimeUtils.getCurrentTimeInString((SimpleDateFormat)TimeUtils.DATETIME_FORMAT_DATE));
                data.put("created_date", (Object)TimeUtils.getCurrentTimeInString((SimpleDateFormat)TimeUtils.DATETIME_FORMAT_DATE));
                this.mongoTemplate.save((Object)data, "def_user");
                if ("C10055".equals(corp_code)) {
                    JSONObject jsonObject = new JSONObject();
                    jsonObject.put("user_id", (Object)user_id);
                    jsonObject.put("team_id", (Object)"5c32fc89a403bb3463279dfa");
                    jsonObject.put("type", (Object)"join_team");
                    jsonObject.put("is_notice", (Object)"N");
                    jsonObject.put("explain", (Object)(user_name + "\u7533\u8bf7\u5165\u56e2"));
                    dataRequest1.setData(jsonObject);
                    DataResponse dataResponse = this.teamService.getData("/team/membersApply", dataRequest1);
                    if ("SUCCESS".equals(dataResponse.getStatus().toString())) {
                        jsonObject = new JSONObject();
                        jsonObject.put("user_id", (Object)"330822198810255422");
                        jsonObject.put("is_all", (Object)"Y");
                        jsonObject.put("apply", (Object)"Y");
                        jsonObject.put("ids", (Object)new JSONArray());
                        dataRequest1.setData(jsonObject);
                        dataResponse = this.teamService.getData("/team/acceptMemberAllApply", dataRequest1);
                    }
                }
            }
        }
        return new DataResponse().setStatus(Status.SUCCESS).setCode("0").setMsg("\u5904\u7406\u6210\u529f");
    }

    public DataResponse createStore(DataRequest dataRequest) {
        DBCollection collection = this.mongoTemplate.getCollection("def_store");
        JSONObject data = dataRequest.getData();
        data.remove((Object)"topic");
        String store_id = data.getString("store_id");
        String corp_code = data.getString("corp_code");
        BasicDBObject query = new BasicDBObject();
        query.put((Object)"store_id", (Object)store_id);
        query.put((Object)"corp_code", (Object)corp_code);
        DBObject object = collection.findOne((DBObject)query);
        if (null != object) {
            BasicDBObject update = new BasicDBObject();
            data.put("modified_date", (Object)TimeUtils.getCurrentTimeInString((SimpleDateFormat)TimeUtils.DATETIME_FORMAT_DATE));
            update.put((Object)"$set", (Object)data);
            collection.update((DBObject)query, (DBObject)update);
        } else {
            data.put("modified_date", (Object)TimeUtils.getCurrentTimeInString((SimpleDateFormat)TimeUtils.DATETIME_FORMAT_DATE));
            data.put("created_date", (Object)TimeUtils.getCurrentTimeInString((SimpleDateFormat)TimeUtils.DATETIME_FORMAT_DATE));
            this.mongoTemplate.save((Object)data, "def_store");
        }
        return new DataResponse().setStatus(Status.SUCCESS).setCode("0").setMsg("\u5904\u7406\u6210\u529f");
    }

    public DataResponse createMaterial(DataRequest dataRequest) {
        BasicDBObject basicDBObject;
        DBCollection collection = this.mongoTemplate.getCollection("def_material");
        DBCollection collection_group = this.mongoTemplate.getCollection("def_material_group");
        JSONObject data = dataRequest.getData();
        data.remove((Object)"topic");
        String material_offline_id = data.getString("material_id");
        if (StringUtils.isNull((Object)material_offline_id)) {
            return new DataResponse().setStatus(Status.FAILED).setCode("-1");
        }
        JSONArray material_image_url = data.getJSONArray("material_image_url");
        if (material_image_url.size() == 0) {
            return new DataResponse().setStatus(Status.SUCCESS).setCode("0");
        }
        String material_group_name = data.getString("material_group_name");
        String userId = data.getString("user_id");
        boolean flag = false;
        Query query_ = new Query();
        query_.addCriteria((CriteriaDefinition)Criteria.where((String)"user_id").is((Object)userId));
        User user = (User)this.mongoTemplate.findOne(query_, User.class);
        if (null == user) {
            return new DataResponse().setStatus(Status.FAILED).setMsg("\u7528\u6237\u4e0d\u5b58\u5728");
        }
        if (StringUtils.isNotNull((Object)user.getRole_type()) && "R4000".equals(user.getRole_type())) {
            flag = true;
        }
        String material_group_id = "";
        DBObject object_ = null;
        if (flag) {
            basicDBObject = new BasicDBObject();
            basicDBObject.put((Object)"corp_code", (Object)"C10055");
            basicDBObject.put((Object)"is_active", (Object)"Y");
            basicDBObject.put((Object)"material_group_name", (Object)material_group_name);
            object_ = collection_group.findOne((DBObject)basicDBObject);
        } else {
            basicDBObject = new BasicDBObject();
            basicDBObject.put((Object)"user_id", (Object)userId);
            basicDBObject.put((Object)"is_active", (Object)"Y");
            basicDBObject.put((Object)"material_group_name", (Object)material_group_name);
            object_ = collection_group.findOne((DBObject)basicDBObject);
        }
        if (null == object_) {
            MaterialGroup materialGroup = new MaterialGroup();
            if (flag) {
                materialGroup.setCorp_code("C10055");
            }
            materialGroup.setIs_active("Y");
            materialGroup.setMaterial_group_name(material_group_name);
            materialGroup.setCreator_id(userId);
            materialGroup.setUser_id(userId);
            materialGroup.setModifier_id(userId);
            materialGroup.setLevel(1);
            materialGroup.setCreated_date(TimeUtils.getCurrentTimeInString((SimpleDateFormat)TimeUtils.DATETIME_FORMAT_DATE));
            materialGroup.setModified_date(TimeUtils.getCurrentTimeInString((SimpleDateFormat)TimeUtils.DATETIME_FORMAT_DATE));
            materialGroup.setCover_color(Integer.parseInt(NumberUtil.keepPrecision((double)(Math.random() * 100.0), (int)0)) % 6);
            this.mongoTemplate.save((Object)materialGroup);
            material_group_id = materialGroup.get_id().toString();
        } else {
            material_group_id = object_.get("_id").toString();
        }
        JSONArray jsonArray = new JSONArray();
        if (flag && object_ != null) {
            String material_group_ids = "";
            BasicDBObject basicDBObject2 = new BasicDBObject();
            basicDBObject2.put((Object)"user_id", (Object)userId);
            basicDBObject2.put((Object)"is_active", (Object)"Y");
            basicDBObject2.put((Object)"material_group_name", (Object)material_group_name);
            object_ = collection_group.findOne((DBObject)basicDBObject2);
            if (null == object_) {
                MaterialGroup materialGroup = new MaterialGroup();
                materialGroup.setIs_active("Y");
                materialGroup.setMaterial_group_name(material_group_name);
                materialGroup.setCreator_id(userId);
                materialGroup.setUser_id(userId);
                materialGroup.setModifier_id(userId);
                materialGroup.setLevel(1);
                materialGroup.setCover_color(Integer.parseInt(NumberUtil.keepPrecision((double)(Math.random() * 100.0), (int)0)) % 6);
                materialGroup.setCreated_date(TimeUtils.getCurrentTimeInString((SimpleDateFormat)TimeUtils.DATETIME_FORMAT_DATE));
                materialGroup.setModified_date(TimeUtils.getCurrentTimeInString((SimpleDateFormat)TimeUtils.DATETIME_FORMAT_DATE));
                this.mongoTemplate.save((Object)materialGroup);
                material_group_ids = materialGroup.get_id().toString();
            } else {
                material_group_ids = object_.get("_id").toString();
            }
            JSONObject object_material = new JSONObject();
            object_material.put("material_group_id", (Object)material_group_ids);
            object_material.put("material_group_name", (Object)material_group_name);
            jsonArray.add((Object)object_material);
        }
        JSONObject object_material = new JSONObject();
        object_material.put("material_group_id", (Object)material_group_id);
        object_material.put("material_group_name", (Object)material_group_name);
        jsonArray.add((Object)object_material);
        String material_product_url = data.getString("material_product_url");
        JSONArray array_ = new JSONArray();
        for (int i = 0; i < material_image_url.size(); ++i) {
            JSONObject image_object_ = material_image_url.getJSONObject(i);
            JSONObject object = new JSONObject();
            log.info("---image_object_-----" + image_object_);
            object.put("url", (Object)material_product_url);
            object.put("image_url", (Object)image_object_.getString("image_url"));
            if (StringUtils.isNotNull((Object)image_object_.getString("product_price"))) {
                object.put("product_price", (Object)image_object_.getString("product_price"));
            }
            if (StringUtils.isNotNull((Object)image_object_.getString("skuno"))) {
                String product = image_object_.getString("product_name") + "  " + image_object_.getString("skuno");
                log.info(product);
                object.put("product_name", (Object)product);
            }
            if (StringUtils.isNotNull((Object)image_object_.getString("skuno"))) {
                object.put("sku_no", (Object)image_object_.getString("skuno"));
            }
            if (StringUtils.isNotNull((Object)image_object_.getString("brand_name"))) {
                object.put("brand_name", (Object)image_object_.getString("brand_name"));
            }
            array_.add((Object)object);
        }
        if (array_.size() == 2 || array_.size() == 3) {
            data.put("is_cut", (Object)"Y");
        }
        data.put("is_corp", (Object)"Y");
        data.put("material_theme", (Object)"1");
        data.put("material_type", (Object)"2");
        data.put("image_url", (Object)array_);
        data.put("material_group_id", (Object)jsonArray);
        data.put("material_name", (Object)data.getString("material_title"));
        data.put("type", (Object)"synchronous");
        BasicDBObject query = new BasicDBObject();
        query.put((Object)"material_offline_id", (Object)material_offline_id);
        DBObject object = collection.findOne((DBObject)query);
        data.put("material_offline_id", (Object)material_offline_id);
        dataRequest.setData(data);
        log.debug("--data-2---" + data);
        if (null == object) {
            return this.dataService.getData("/material/create", dataRequest);
        }
        data.put("material_id", object.get("material_id"));
        data.put("id", object.get("material_id"));
        return this.dataService.getData("/material/mod", dataRequest);
    }

    public DataResponse createProduct(DataRequest dataRequest) {
        DBCollection collection = this.mongoTemplate.getCollection("def_product");
        JSONObject data = dataRequest.getData();
        data.remove((Object)"topic");
        data.put("is_corp", (Object)"Y");
        data.put("is_online_pay", (Object)"Y");
        String product_offline_id = data.getString("product_id");
        String skuno = data.getString("skuno");
        if (StringUtils.isNull((Object)skuno)) {
            skuno = data.getString("sku_no");
        }
        if (StringUtils.isNotNull((Object)skuno)) {
            String product_name = data.getString("product_name") + "  " + skuno;
            data.put("product_name", (Object)product_name);
        }
        if (StringUtils.isNull((Object)product_offline_id)) {
            return new DataResponse().setStatus(Status.FAILED).setCode("-1");
        }
        BasicDBObject query = new BasicDBObject();
        query.put((Object)"product_offline_id", (Object)product_offline_id);
        query.put((Object)"user_id", (Object)data.getString("user_id"));
        DBObject object = collection.findOne((DBObject)query);
        data.put("product_offline_id", (Object)product_offline_id);
        dataRequest.setData(data);
        if (null == object) {
            DataResponse dataResponse = this.productService.getData("/product/v2/create", dataRequest);
            if ("SUCCESS".equals(dataResponse.getStatus().toString())) {
                // empty if block
            }
            return dataResponse;
        }
        data.put("product_id", object.get("product_id"));
        data.put("id", object.get("product_id"));
        log.info("--product_id---" + object.get("product_id"));
        return this.productService.getData("/product/mod/v2", dataRequest);
    }

    public DataResponse createOrder(DataRequest dataRequest) {
        DBCollection collection = this.mongoTemplate.getCollection("def_order");
        JSONObject data = dataRequest.getData();
        String team_id = data.getString("team_id");
        data.remove((Object)"topic");
        if (data.containsKey((Object)"productList")) {
            JSONArray array = data.getJSONArray("productList");
            JSONArray productList = new JSONArray();
            for (int i = 0; i < array.size(); ++i) {
                JSONObject object = array.getJSONObject(i);
                String product_offline_id = object.getString("product_id");
                BasicDBObject query = new BasicDBObject();
                query.put((Object)"product_offline_id", (Object)product_offline_id);
                DBObject object_product = this.mongoTemplate.getCollection("def_product").findOne((DBObject)query);
                if (null != object_product) {
                    object.put("product_id", object_product.get("product_id"));
                }
                if (StringUtils.isNotNull((Object)team_id)) {
                    object.put("team_id", (Object)team_id);
                }
                productList.add((Object)object);
            }
            data.put("productList", (Object)productList);
        }
        dataRequest.setData(data);
        String order_no = data.getString("order_no");
        if (StringUtils.isNull((Object)order_no)) {
            return new DataResponse().setStatus(Status.FAILED).setCode("-1");
        }
        BasicDBObject query = new BasicDBObject();
        query.put((Object)"order_no", (Object)order_no);
        DBObject object = collection.findOne((DBObject)query);
        if (null != object) {
            String order_id = object.get("order_id").toString();
            String order_pay_status = object.get("pay_status").toString();
            String pay_status = data.getJSONObject("pay_info").getString("pay_status");
            data.put("order_id", (Object)order_id);
            data.put("id", (Object)order_id);
            DataResponse dataResponse = this.orderService.modv2(dataRequest);
            if ("SUCCESS".equals(dataResponse.getStatus().toString()) && !order_pay_status.equals(pay_status)) {
                JSONObject param;
                JSONObject content = new JSONObject();
                content.put("order_no", (Object)order_no);
                content.put("order_id", (Object)order_id);
                if ("3".equals(pay_status)) {
                    param = new JSONObject();
                    param.put("type", (Object)"1008");
                    param.put("user_id", (Object)data.getString("user_id"));
                    param.put("message_content", (Object)content);
                    try {
                        this.send_message.sendBackground(param);
                    }
                    catch (Exception e) {
                        log.error("send message error:" + e.getLocalizedMessage(), (Throwable)e);
                    }
                }
                if ("1".equals(pay_status)) {
                    content = new JSONObject();
                    content.put("vip_id", (Object)data.getJSONObject("order_vip").getString("vip_id"));
                    content.put("vip_name", (Object)data.getJSONObject("order_vip").getString("vip_name"));
                    content.put("order_id", (Object)order_id);
                    content.put("order_no", (Object)order_no);
                    content.put("order_amount_pay", (Object)data.getString("order_amount_pay"));
                    content.put("product_short_info", (Object)data.getJSONArray("productList"));
                    param = new JSONObject();
                    param.put("type", (Object)"1001");
                    param.put("user_id", (Object)data.getString("user_id"));
                    param.put("message_content", (Object)content);
                    try {
                        this.send_message.sendBackground(param);
                    }
                    catch (Exception e) {
                        log.error("send message error:" + e.getLocalizedMessage(), (Throwable)e);
                    }
                }
            }
            return dataResponse;
        }
        String pay_status = data.getJSONObject("pay_info").getString("pay_status");
        JSONObject content = new JSONObject();
        content.put("vip_id", (Object)data.getJSONObject("order_vip").getString("vip_id"));
        content.put("vip_name", (Object)data.getJSONObject("order_vip").getString("vip_name"));
        content.put("order_id", (Object)order_no);
        content.put("order_no", (Object)order_no);
        content.put("order_amount_pay", (Object)data.getString("order_amount_pay"));
        content.put("product_short_info", (Object)data.getJSONArray("productList"));
        DataResponse dataResponse = this.orderService.addv2(dataRequest);
        if ("SUCCESS".equals(dataResponse.getStatus().toString()) && "1".equals(pay_status)) {
            JSONObject param = new JSONObject();
            param.put("type", (Object)"1001");
            param.put("user_id", (Object)data.getString("user_id"));
            param.put("message_content", (Object)content);
            try {
                this.send_message.sendBackground(param);
            }
            catch (Exception e) {
                log.error("send message error:" + e.getLocalizedMessage(), (Throwable)e);
            }
        }
        return dataResponse;
    }

    public DataResponse SysnchronProduct(DataRequest dataRequest) {
        DBCollection collection = this.mongoTemplate.getCollection("def_product_synchronization");
        BasicDBObject basicDBObject = new BasicDBObject();
        basicDBObject.put((Object)"is_active", (Object)"Y");
        DBCursor dbObjects = collection.find((DBObject)basicDBObject);
        while (dbObjects.hasNext()) {
            DBObject object = dbObjects.next();
            Map map = object.toMap();
            String corp_code = map.get("corp_code").toString();
            String team_id = map.get("team_id").toString();
            String user_id = map.get("user_id").toString();
            String is_team_child = map.get("is_team_child").toString();
            Query query = new Query();
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"corp_code").is((Object)corp_code));
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"is_active").is((Object)"Y"));
            List productList = this.mongoTemplate.find(query, Product.class);
            int total_results = productList.size();
            JSONArray array = new JSONArray();
            for (int k = 0; k < total_results / 1000 + 1; ++k) {
                List product = null;
                product = (k + 1) * 1000 <= total_results ? productList.subList(k * 1000, (k + 1) * 1000) : productList.subList(k * 1000, total_results);
                array = JSONArray.parseArray((String)JSON.toJSONString(product));
                JSONObject object2 = new JSONObject();
                object2.put("user_id", (Object)user_id);
                object2.put("product_ids", (Object)array);
                object2.put("team_id", (Object)team_id);
                object2.put("from_team_id", (Object)"");
                dataRequest = new DataRequest();
                dataRequest.setData(object2);
                this.productService.getData("/teamProduct/publishV2", dataRequest);
                try {
                    Thread.sleep(50L);
                    continue;
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            if (!"Y".equals(is_team_child)) continue;
            JSONObject object1 = new JSONObject();
            object1.put("user_id", (Object)user_id);
            object1.put("parent_team_id", (Object)team_id);
            object1.put("is_batch_set", (Object)"Y");
            object1.put("is_notice", (Object)"N");
            dataRequest.setData(object1);
            return this.teamService.getData("/teamProduct/batchPublishTeamProduct", dataRequest);
        }
        return new DataResponse().setStatus(Status.SUCCESS);
    }

    public DataResponse SysnchronMaterial(DataRequest dataRequest) {
        DBCollection collection = this.mongoTemplate.getCollection("def_material_synchronization");
        DBCollection collection_material = this.mongoTemplate.getCollection("def_material");
        DBCollection collection_team_material_group = this.mongoTemplate.getCollection("def_team_material_group");
        BasicDBObject basicDBObject = new BasicDBObject();
        basicDBObject.put((Object)"is_active", (Object)"Y");
        DBCursor dbObjects = collection.find((DBObject)basicDBObject);
        String time = TimeUtils.getCurrentTimeInString((SimpleDateFormat)TimeUtils.DATETIME_FORMAT_DATE);
        while (dbObjects.hasNext()) {
            DBObject object = dbObjects.next();
            Map map = object.toMap();
            String corp_code = map.get("corp_code").toString();
            String team_id = map.get("team_id").toString();
            String user_id = map.get("user_id").toString();
            String is_team_child = map.get("is_team_child").toString();
            Query query = new Query();
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"corp_code").is((Object)corp_code));
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"is_active").is((Object)"Y"));
            List materialGroupsList = this.mongoTemplate.find(query, MaterialGroup.class);
            for (int i = 0; i < materialGroupsList.size(); ++i) {
                int k = 0;
                MaterialGroup materialGroup = (MaterialGroup)materialGroupsList.get(i);
                String team_group_name = materialGroup.getMaterial_group_name();
                String team_group_id = JSONObject.parseObject((String)materialGroup.toString()).getString("id");
                int level = materialGroup.getLevel();
                BasicDBObject basicDBObject1 = new BasicDBObject();
                basicDBObject1.put((Object)"material_group_id.material_group_id", (Object)team_group_id);
                basicDBObject1.put((Object)"is_active", (Object)"Y");
                BasicDBObject project = new BasicDBObject();
                project.put((Object)"material_id", (Object)1);
                project.put((Object)"material_name", (Object)1);
                project.put((Object)"user_id", (Object)1);
                project.put((Object)"created_date", (Object)1);
                project.put((Object)"material_type", (Object)1);
                project.put((Object)"can_app_show", (Object)1);
                List dbObjectList = collection_material.find((DBObject)basicDBObject1, (DBObject)project).toArray();
                JSONArray array = new JSONArray();
                Query query1 = new Query();
                query1.addCriteria((CriteriaDefinition)Criteria.where((String)"name").is((Object)team_group_name));
                query1.addCriteria((CriteriaDefinition)Criteria.where((String)"team_id").is((Object)team_id));
                TeamMaterialGroup teamMaterialGroup = (TeamMaterialGroup)this.mongoTemplate.findOne(query1, TeamMaterialGroup.class);
                if (null == teamMaterialGroup) {
                    teamMaterialGroup = new TeamMaterialGroup();
                    teamMaterialGroup.setCreate_id(user_id);
                    teamMaterialGroup.setIs_active("Y");
                    teamMaterialGroup.setLevel(String.valueOf(level));
                    teamMaterialGroup.setModifier_id(user_id);
                    teamMaterialGroup.setCreate_time(time);
                    teamMaterialGroup.setMaterial_count(dbObjectList.size());
                    teamMaterialGroup.setMaterials(array);
                    teamMaterialGroup.setModified_time(time);
                    teamMaterialGroup.setName(team_group_name);
                    teamMaterialGroup.setTeam_id(team_id);
                    teamMaterialGroup.set_id((Object)new ObjectId());
                    this.mongoTemplate.save((Object)teamMaterialGroup);
                }
                for (int j = 0; j < dbObjectList.size(); ++j) {
                    String can_app_show;
                    DBObject dbObject = (DBObject)dbObjectList.get(j);
                    String def_material_id = dbObject.get("material_id").toString();
                    String created_time = dbObject.get("created_date").toString();
                    String def_user_id = dbObject.get("user_id").toString();
                    String material_name = dbObject.get("material_name").toString();
                    String material_type = StringUtils.checkString((String)String.valueOf(dbObject.get("material_type")));
                    if ("6".equals(material_type) && !"Y".equals(can_app_show = String.valueOf(dbObject.get("can_app_show")))) continue;
                    ++k;
                    JSONObject object1 = new JSONObject();
                    object1.put("created_time", (Object)created_time);
                    object1.put("from_team_id", (Object)"");
                    object1.put("def_material_id", (Object)def_material_id);
                    object1.put("def_user_id", (Object)def_user_id);
                    object1.put("material_name", (Object)material_name);
                    object1.put("material_type", (Object)material_type);
                    BasicDBObject object2 = new BasicDBObject();
                    object2.put((Object)"materials", (Object)object1);
                    BasicDBObject basicDBObject2 = new BasicDBObject();
                    basicDBObject2.put((Object)"$addToSet", (Object)object2);
                    BasicDBObject query_ = new BasicDBObject();
                    query_.put((Object)"team_id", (Object)team_id);
                    query_.put((Object)"name", (Object)team_group_name);
                    collection_team_material_group.update((DBObject)query_, (DBObject)basicDBObject2);
                }
                BasicDBObject query_ = new BasicDBObject();
                query_.put((Object)"team_id", (Object)team_id);
                query_.put((Object)"name", (Object)team_group_name);
                BasicDBObject basicDBObject2 = new BasicDBObject();
                basicDBObject2.put((Object)"$set", (Object)new BasicDBObject("material_count", (Object)k));
                collection_team_material_group.update((DBObject)query_, (DBObject)basicDBObject2);
            }
            if (!"Y".equals(is_team_child)) continue;
            JSONObject object1 = new JSONObject();
            object1.put("user_id", (Object)user_id);
            object1.put("parent_team_id", (Object)team_id);
            dataRequest.setData(object1);
            return this.dataService.getData("/teamMaterial/batchSetTeamMaterial", dataRequest);
        }
        return new DataResponse().setStatus(Status.SUCCESS).setCode("0").setMsg("\u540c\u6b65\u6210\u529f");
    }

    public DataResponse batchApplyTeam(DataRequest dataRequest) {
        JSONObject data = dataRequest.getData();
        String corp_code = data.getString("corp_code");
        Query query = new Query((CriteriaDefinition)Criteria.where((String)"corp_code").is((Object)corp_code).and("is_active").is((Object)"Y"));
        List users = this.mongoTemplate.find(query, User.class);
        String team_id = "";
        for (User user : users) {
            JSONObject object = new JSONObject();
            team_id = "5c32fc89a403bb3463279dfa";
            object.put("team_id", (Object)team_id);
            object.put("user_id", (Object)user.getUser_id());
            object.put("type", (Object)"join_team");
            object.put("is_notice", (Object)"N");
            object.put("explain", (Object)(user.getUser_name() + "\u7533\u8bf7\u5165\u56e2"));
            DataRequest request = new DataRequest();
            request.setData(object);
            this.teamService.getData("/team/membersApply", request);
        }
        return new DataResponse().setStatus(Status.SUCCESS);
    }
}

