/*
 * Decompiled with CFR 0.152.
 */
package kr.weitao.weitaokr.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.mongodb.AggregationOutput;
import com.mongodb.BasicDBList;
import com.mongodb.BasicDBObject;
import com.mongodb.DBCollection;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import com.mongodb.WriteResult;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kr.weitao.business.entity.User;
import kr.weitao.business.entity.Vip;
import kr.weitao.business.entity.data.Product;
import kr.weitao.business.entity.data.ProductMessage;
import kr.weitao.common.util.JSONArraySortUtil;
import kr.weitao.common.util.RedisUtil;
import kr.weitao.common.util.StringUtils;
import kr.weitao.common.util.TimeUtils;
import kr.weitao.starter.model.DataRequest;
import kr.weitao.starter.model.DataResponse;
import kr.weitao.starter.model.Status;
import kr.weitao.starter.util.jdbc.JdbcClient;
import kr.weitao.starter.util.redis.RedisClient;
import kr.weitao.weitaokr.network.NetWorkCommon;
import kr.weitao.weitaokr.service.MessageService;
import kr.weitao.weitaokr.service.PushService;
import kr.weitao.weitaokr.service.common.UserPortUtils;
import org.apache.commons.collections.map.HashedMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bson.types.ObjectId;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.stereotype.Service;

@Service
public class MessageServiceImpl
implements MessageService {
    private static final Logger log = LogManager.getLogger(MessageServiceImpl.class);
    @Autowired
    @Qualifier(value="primaryJdbcClient")
    JdbcClient jdbcClient;
    @Autowired
    MongoTemplate mongoTemplate;
    @Autowired
    PushService pushService;
    @Autowired
    RedisClient redisClient;
    public static final String NotOnline = "User is not online";

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @CacheEvict(value={"message"}, allEntries=true)
    public DataResponse chatToVip(DataRequest dataRequest) {
        JSONObject data = dataRequest.getData();
        String message_type = data.getString("message_type");
        String message_flag = data.getString("message_flag");
        String message_content = data.getString("message_content");
        String user_id = data.getString("user_id");
        String vip_id = data.getString("vip_id");
        String type = data.getString("type");
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"vip_id").is((Object)vip_id));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"user_id").is((Object)user_id));
        Vip vip = (Vip)this.mongoTemplate.findOne(query, Vip.class);
        if (null == vip) {
            return new DataResponse().setMsg("\u4f1a\u5458\u4e0d\u5b58\u5728").setStatus(Status.FAILED);
        }
        String wx_id = vip.getWx_id();
        String is_group_vip = vip.getIs_group_vip();
        if (org.apache.commons.lang.StringUtils.isBlank((String)is_group_vip)) {
            is_group_vip = "N";
        }
        String nick_name = vip.getNick_name();
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("user_id", (Object)user_id);
        jsonObject.put("wx_id", (Object)wx_id);
        jsonObject.put("msg_type", (Object)message_type);
        jsonObject.put("msg_content", (Object)message_content);
        jsonObject.put("image_data", (Object)data.getString("image_data"));
        JSONObject object = new JSONObject();
        object.put("message", (Object)"\u53d1\u9001\u6210\u529f");
        if (org.apache.commons.lang.StringUtils.isBlank((String)type)) {
            type = "1";
        }
        Query query_ = new Query();
        query_.addCriteria((CriteriaDefinition)Criteria.where((String)"user_id").is((Object)user_id));
        User user_ = (User)this.mongoTemplate.findOne(query_, User.class);
        if (null == user_) {
            return new DataResponse().setCode("-1").setMsg("\u53d1\u9001\u5931\u8d25,\u672a\u627e\u5230\u5bf9\u5e94\u5ba2\u670d");
        }
        String u_uin = user_.getUin();
        String port = UserPortUtils.getUserPort((String)user_.getPort());
        String sender_wx_id = user_.getWx_id();
        String sender_avatar = StringUtils.checkString((String)user_.getHead_img());
        String sender_nick_name = StringUtils.checkString((String)user_.getNick_name());
        String sender_vip_id = "";
        Query query_wx = new Query();
        query_wx.addCriteria((CriteriaDefinition)Criteria.where((String)"wx_id").is((Object)sender_wx_id));
        query_wx.addCriteria((CriteriaDefinition)Criteria.where((String)"u_uin").is((Object)u_uin));
        query_wx.addCriteria((CriteriaDefinition)Criteria.where((String)"user_id").is((Object)user_id));
        Vip vip_by = (Vip)this.mongoTemplate.findOne(query_wx, Vip.class);
        if (null != vip_by) {
            log.info("---vip_id-----" + vip_by.getVip_id());
            sender_avatar = vip_by.getHead_img();
            sender_nick_name = vip_by.getNick_name();
            sender_vip_id = vip_by.getVip_id();
        }
        try {
            JSONObject vip_message_content;
            String result = NetWorkCommon.commonwx((JSONObject)jsonObject, (String)"/message/sendToFriend", (String)port);
            JSONObject result_back = JSON.parseObject((String)result);
            log.info("\u53d1\u9001\u6d88\u606f\u53cd\u9988" + result_back);
            if (!result_back.containsKey((Object)"code")) return new DataResponse().setMsg("\u53d1\u9001\u5931\u8d25").setStatus(Status.FAILED);
            if ("0".equals(result_back.getString("code"))) {
                String time = TimeUtils.getCurrentTimeInString((SimpleDateFormat)TimeUtils.DATETIME_FORMAT_DATE);
                JSONObject last_message = new JSONObject();
                last_message.put("message_content", (Object)message_content);
                last_message.put("message_type", (Object)message_type);
                last_message.put("message_flag", (Object)message_flag);
                last_message.put("message_date", (Object)time);
                last_message.put("message_direction", (Object)"1");
                last_message.put("type", (Object)type);
                last_message.put("is_group_vip", (Object)is_group_vip);
                if ("Y".equals(is_group_vip)) {
                    last_message.put("sender_avatar", (Object)sender_avatar);
                    last_message.put("sender_nick_name", (Object)sender_nick_name);
                    last_message.put("sender_vip_id", (Object)sender_vip_id);
                    last_message.put("sender_wx_id", (Object)sender_wx_id);
                }
                Update update = new Update();
                update.set("last_message", (Object)last_message);
                update.set("wx_id", (Object)wx_id);
                this.mongoTemplate.upsert(query, update, Vip.class);
                WriteResult writeResult_message = this.mongoTemplate.updateMulti(query, update, "vip_message");
                log.info("writeResult_message.getN()--" + writeResult_message.getN());
                if (writeResult_message.getN() == 0) {
                    log.info("--def_message-\u4e0d\u5b58\u5728-");
                    JSONObject vip_message = new JSONObject();
                    vip_message.put("vip_id", (Object)vip_id);
                    vip_message.put("user_id", (Object)user_id);
                    vip_message.put("u_uin", (Object)u_uin);
                    vip_message.put("wx_id", (Object)wx_id);
                    vip_message.put("is_active", (Object)"Y");
                    vip_message.put("modified_date", (Object)time);
                    vip_message.put("created_date", (Object)time);
                    vip_message.put("modifier_id", (Object)user_id);
                    vip_message.put("creator_id", (Object)user_id);
                    vip_message.put("nick_name", (Object)nick_name);
                    vip_message.put("head_img", (Object)"");
                    vip_message.put("last_message", (Object)last_message);
                    this.mongoTemplate.save((Object)vip_message, "vip_message");
                }
                vip_message_content = last_message;
                vip_message_content.put("vip_id", (Object)vip_id);
                vip_message_content.put("user_id", (Object)user_id);
                vip_message_content.put("is_active", (Object)"Y");
                vip_message_content.put("modified_date", (Object)time);
                vip_message_content.put("created_date", (Object)time);
                vip_message_content.put("modifier_id", (Object)user_id);
                vip_message_content.put("message_flag", (Object)message_flag);
                vip_message_content.put("creator_id", (Object)user_id);
                vip_message_content.put("is_group_vip", (Object)is_group_vip);
                if ("Y".equals(is_group_vip)) {
                    vip_message_content.put("sender_avatar", (Object)sender_avatar);
                    vip_message_content.put("sender_nick_name", (Object)sender_nick_name);
                    vip_message_content.put("sender_vip_id", (Object)sender_vip_id);
                    vip_message_content.put("sender_wx_id", (Object)sender_wx_id);
                }
            } else {
                String msg = object.getString("msg");
                if (!NotOnline.equals(msg)) return new DataResponse().setMsg(msg).setStatus(Status.FAILED);
                msg = "\u5f53\u524d\u5fae\u4fe1\u6682\u672a\u7ed1\u5b9a";
                return new DataResponse().setMsg(msg).setStatus(Status.FAILED);
            }
            this.mongoTemplate.save((Object)vip_message_content, "vip_message_content");
            return new DataResponse().setCode("0").setStatus(Status.SUCCESS).setData(object);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return new DataResponse().setCode("0").setStatus(Status.SUCCESS).setData(object);
    }

    public DataResponse chatToVipV2(DataRequest dataRequest) {
        return null;
    }

    public DataResponse chatToUser(DataRequest dataRequest) {
        JSONObject data = dataRequest.getData();
        JSONObject pusToUser = new JSONObject();
        String message_type = data.getString("message_type");
        String head_img = data.getString("head_img");
        String nickname = data.getString("nick_name");
        String description = data.getString("description");
        String message_content = data.getString("message_content");
        String thumb_width = data.getString("thumb_width");
        String thumb_height = data.getString("thumb_height");
        Boolean is_silence = data.getBoolean("is_silence");
        Boolean from_self = data.getBoolean("from_self");
        String user_id = data.getString("user_id");
        String wx_id = data.getString("wx_id");
        if (null == is_silence) {
            is_silence = true;
        }
        if (null == from_self) {
            from_self = false;
        }
        Boolean is_group = data.getBoolean("is_group");
        String is_group_vip = "N";
        if (null != is_group && is_group.booleanValue()) {
            is_group_vip = "Y";
        }
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"user_id").is((Object)user_id));
        User user = (User)this.mongoTemplate.findOne(query, User.class);
        if (null == user) {
            return new DataResponse().setCode("-1").setMsg("\u53d1\u9001\u5931\u8d25,\u672a\u627e\u5230\u5bf9\u5e94\u5ba2\u670d");
        }
        String u_uin = user.getUin();
        String message_direction = "0";
        String message_date = null == data.getString("message_date") ? TimeUtils.getCurrentTimeInString((SimpleDateFormat)TimeUtils.DATETIME_FORMAT_DATE) : data.getString("message_date");
        pusToUser.put("content", (Object)description);
        if ("picture".equals(message_type.toLowerCase())) {
            message_type = "Picture";
        } else if ("recording".equals(message_type.toLowerCase())) {
            message_type = "Recording";
        } else if ("text".equals(message_type.toLowerCase())) {
            message_type = "Text";
        } else if ("animation".equals(message_type.toLowerCase())) {
            message_type = "animation";
        } else if ("video".equals(message_type.toLowerCase())) {
            message_type = "video";
        } else {
            if ("friend_add_request".equals(message_type.toLowerCase())) {
                log.info("friend_add_request-" + data);
                return new DataResponse().setCode("0").setMsg("\u6210\u529f").setStatus(Status.SUCCESS);
            }
            if ("notice".equalsIgnoreCase(message_type)) {
                Vip vip_new;
                Vip vip;
                Query query_vip;
                log.info("notice-" + data);
                if (message_content.contains("\u901a\u8fc7\u4e86\u4f60\u7684\u670b\u53cb\u9a8c\u8bc1\u8bf7\u6c42")) {
                    query_vip = new Query();
                    query_vip.addCriteria((CriteriaDefinition)Criteria.where((String)"wx_id").is((Object)wx_id));
                    query_vip.addCriteria((CriteriaDefinition)Criteria.where((String)"user_id").is((Object)user_id));
                    query_vip.addCriteria((CriteriaDefinition)Criteria.where((String)"u_uin").is((Object)u_uin));
                    vip = (Vip)this.mongoTemplate.findOne(query_vip, Vip.class);
                    if (null == vip) {
                        vip_new = new Vip();
                        vip_new.setNick_name(nickname);
                        vip_new.setVip_name(nickname);
                        vip_new.setUser_id(user_id);
                        vip_new.setU_uin(u_uin);
                        vip_new.setWx_id(wx_id);
                        vip_new.setIs_active("Y");
                        vip_new.setIs_group_vip(is_group_vip);
                        log.info((Object)vip_new);
                        this.mongoTemplate.save((Object)vip_new);
                    }
                }
                if (message_content.contains("\u4f60\u5df2\u6dfb\u52a0")) {
                    query_vip = new Query();
                    query_vip.addCriteria((CriteriaDefinition)Criteria.where((String)"wx_id").is((Object)wx_id));
                    query_vip.addCriteria((CriteriaDefinition)Criteria.where((String)"user_id").is((Object)user_id));
                    query_vip.addCriteria((CriteriaDefinition)Criteria.where((String)"u_uin").is((Object)u_uin));
                    vip = (Vip)this.mongoTemplate.findOne(query_vip, Vip.class);
                    if (null == vip) {
                        vip_new = new Vip();
                        vip_new.setNick_name(nickname);
                        vip_new.setVip_name(nickname);
                        vip_new.setUser_id(user_id);
                        vip_new.setU_uin(u_uin);
                        vip_new.setWx_id(wx_id);
                        vip_new.setIs_active("Y");
                        vip_new.setIs_group_vip(is_group_vip);
                        log.info((Object)vip_new);
                        this.mongoTemplate.save((Object)vip_new);
                    }
                }
                if (message_content.contains("\u4fee\u6539\u7fa4\u540d\u4e3a")) {
                    BasicDBObject basicDBObject_ = new BasicDBObject();
                    BasicDBObject update = new BasicDBObject();
                    BasicDBObject query_ = new BasicDBObject();
                    nickname = message_content.substring(message_content.indexOf("\u4e3a") + 2, message_content.length() - 1);
                    basicDBObject_.put((Object)"nick_name", (Object)nickname);
                    log.info((Object)basicDBObject_);
                    update.put((Object)"$set", (Object)basicDBObject_);
                    query_.put((Object)"wx_id", (Object)wx_id);
                    this.mongoTemplate.getCollection("vip_message").updateMulti((DBObject)query_, (DBObject)update);
                    this.mongoTemplate.getCollection("def_vip").updateMulti((DBObject)query_, (DBObject)update);
                    DataRequest pusdata = new DataRequest();
                    pusToUser.put("alias", (Object)user.getPhone());
                    pusToUser.put("title", (Object)"\u60a8\u6709\u4e00\u6761\u65b0\u7684\u6d88\u606f");
                    JSONObject extra = new JSONObject();
                    extra.put("message_id", (Object)(System.currentTimeMillis() + ""));
                    extra.put("from_self", (Object)from_self.toString());
                    extra.put("is_silence", (Object)is_silence.toString());
                    pusToUser.put("extra", (Object)extra);
                    pusToUser.put("user_id", (Object)user_id);
                    log.info("pusToUser---" + pusToUser);
                    pusdata.setData(pusToUser);
                    DataResponse dataResponse = this.pushService.messagePush(pusdata);
                }
                return new DataResponse().setCode("0").setMsg("\u6210\u529f").setStatus(Status.SUCCESS);
            }
            return new DataResponse().setCode("0").setMsg("\u6210\u529f").setStatus(Status.SUCCESS);
        }
        Query query_vip = new Query();
        query_vip.addCriteria((CriteriaDefinition)Criteria.where((String)"wx_id").is((Object)wx_id));
        query_vip.addCriteria((CriteriaDefinition)Criteria.where((String)"user_id").is((Object)user_id));
        query_vip.addCriteria((CriteriaDefinition)Criteria.where((String)"u_uin").is((Object)u_uin));
        Vip vip = (Vip)this.mongoTemplate.findOne(query_vip, Vip.class);
        String vip_id = "";
        if (null == vip) {
            log.info("\u65b0\u589e\u4f1a\u5458");
            Vip vip_new = new Vip();
            vip_new.setNick_name(nickname);
            vip_new.setVip_name(nickname);
            vip_new.setHead_img(head_img);
            vip_new.setUser_id(user_id);
            vip_new.setU_uin(u_uin);
            vip_new.setIs_active("Y");
            vip_new.setWx_id(wx_id);
            vip_new.setIs_group_vip(is_group_vip);
            log.info((Object)vip_new);
            this.mongoTemplate.save((Object)vip_new);
            vip = new Vip();
            vip.setVip_id(vip_new.get_id().toString());
        }
        String phone = user.getPhone();
        vip_id = vip.getVip_id();
        DataRequest pusdata = new DataRequest();
        pusToUser.put("alias", (Object)phone);
        pusToUser.put("title", (Object)"\u60a8\u6709\u4e00\u6761\u65b0\u7684\u6d88\u606f");
        JSONObject extra = new JSONObject();
        extra.put("message_id", (Object)(System.currentTimeMillis() + ""));
        extra.put("vip_id", (Object)vip_id);
        extra.put("from_self", (Object)from_self.toString());
        extra.put("is_silence", (Object)is_silence.toString());
        pusToUser.put("extra", (Object)extra);
        pusToUser.put("user_id", (Object)user_id);
        log.info("pusToUser---" + pusToUser);
        pusdata.setData(pusToUser);
        String key = "message@" + user_id + "@" + u_uin + "@" + TimeUtils.getCurrentTimeInString((SimpleDateFormat)TimeUtils.DATE_FORMAT_DATE_NO) + "@" + vip_id;
        log.info("--key---" + key);
        JSONObject message = new JSONObject();
        message.put("nick_name", (Object)nickname);
        message.put("message_type", (Object)message_type);
        message.put("message_direction", (Object)message_direction);
        message.put("message_date", (Object)message_date);
        message.put("head_img", (Object)head_img);
        message.put("u_uin", (Object)u_uin);
        message.put("vip_id", (Object)vip_id);
        message.put("wx_id", (Object)wx_id);
        message.put("user_id", (Object)user_id);
        message.put("is_group_vip", (Object)is_group_vip);
        message.put("message_content", (Object)message_content);
        message.put("thumb_height", (Object)thumb_height);
        message.put("thumb_width", (Object)thumb_width);
        message.put("is_friend", (Object)"Y");
        if ("Y".equals(is_group_vip)) {
            message.put("sender_wx_id", (Object)data.getString("sender_wx_id"));
            message.put("sender_nick_name", (Object)data.getString("sender_nick_name"));
            message.put("sender_avatar", (Object)data.getString("sender_avatar"));
            String is_friend = "N";
            Query query_vip_by = new Query();
            query_vip_by.addCriteria((CriteriaDefinition)Criteria.where((String)"u_uin").is((Object)u_uin));
            query_vip_by.addCriteria((CriteriaDefinition)Criteria.where((String)"wx_id").is((Object)data.getString("sender_wx_id")));
            query_vip_by.addCriteria((CriteriaDefinition)Criteria.where((String)"user_id").is((Object)user_id));
            Vip groupVip = (Vip)this.mongoTemplate.findOne(query_vip_by, Vip.class);
            if (null != groupVip) {
                message.put("sender_vip_id", (Object)groupVip.getVip_id());
                is_friend = "Y";
            }
            message.put("is_friend", (Object)is_friend);
        }
        if (!from_self.booleanValue()) {
            JSONArray objects;
            if (RedisUtil.exists((String)key).booleanValue()) {
                log.info("\u5b58\u5728");
                objects = JSONArray.parseArray((String)RedisUtil.get((String)key));
            } else {
                objects = new JSONArray();
            }
            objects.add((Object)message);
            RedisUtil.set((String)key, (String)objects.toJSONString(), (int)604800);
        } else {
            JSONObject last_message = new JSONObject();
            last_message.put("message_content", (Object)message_content);
            last_message.put("is_group_vip", (Object)is_group_vip);
            if ("Y".equals(is_group_vip)) {
                last_message.put("sender_wx_id", (Object)data.getString("sender_wx_id"));
                last_message.put("sender_nick_name", (Object)data.getString("sender_nick_name"));
                last_message.put("sender_avatar", (Object)data.getString("sender_avatar"));
            }
            last_message.put("message_date", (Object)message_date);
            last_message.put("message_type", (Object)message_type);
            last_message.put("message_direction", (Object)"1");
            BasicDBObject basicDBObject = new BasicDBObject();
            basicDBObject.put((Object)"last_message", (Object)last_message);
            BasicDBObject queryMessage = new BasicDBObject();
            queryMessage.put((Object)"user_id", (Object)user_id);
            queryMessage.put((Object)"vip_id", (Object)vip_id);
            BasicDBObject update = new BasicDBObject();
            update.put((Object)"$set", (Object)basicDBObject);
            WriteResult writeResult = this.mongoTemplate.getCollection("vip_message").update((DBObject)queryMessage, (DBObject)update);
            if (writeResult.getN() == 0) {
                JSONObject object = new JSONObject();
                object.put("last_message", (Object)last_message);
                object.put("nick_name", (Object)nickname);
                object.put("user_id", (Object)user_id);
                object.put("head_img", (Object)head_img);
                object.put("vip_id", (Object)vip_id);
                object.put("u_uin", (Object)u_uin);
                object.put("wx_id", (Object)wx_id);
                object.put("modified_date", (Object)message_date);
                this.mongoTemplate.save((Object)object, "vip_message");
            }
            log.info("---\u65b0\u589e-from_self-true-" + writeResult.getN());
            message.put("message_direction", (Object)"1");
            this.mongoTemplate.save((Object)message, "vip_message_content");
        }
        log.info("\u65b0\u7684\u6d88\u606f\u67e5\u5165");
        Query query_ = new Query();
        query_.addCriteria((CriteriaDefinition)Criteria.where((String)"user_id").is((Object)user_id));
        query_.addCriteria((CriteriaDefinition)Criteria.where((String)"vip_id").is((Object)vip_id));
        Update query_update = new Update();
        query_update.set("last_message", (Object)message);
        query_update.set("head_img", (Object)head_img);
        query_update.set("is_group_vip", (Object)is_group_vip);
        this.mongoTemplate.upsert(query_, query_update, Vip.class);
        if (!is_silence.booleanValue() && !from_self.booleanValue()) {
            DataResponse dataResponse = this.pushService.notificationAliPush(pusdata);
            log.info("-dataResponse>>>-" + dataResponse);
        }
        DataResponse dataResponsemessage = this.pushService.messagePush(pusdata);
        log.info(pusToUser + "dataResponse_message>>>" + dataResponsemessage);
        return new DataResponse().setCode("0").setMsg("\u6210\u529f").setStatus(Status.SUCCESS);
    }

    public DataResponse readAllMessage(DataRequest dataRequest) {
        JSONObject data = dataRequest.getData();
        String user_id = data.getString("user_id");
        Query query_ = new Query();
        query_.addCriteria((CriteriaDefinition)Criteria.where((String)"user_id").is((Object)user_id));
        User user_ = (User)this.mongoTemplate.findOne(query_, User.class);
        if (null == user_) {
            return new DataResponse().setCode("-1").setMsg("\u53d1\u9001\u5931\u8d25,\u672a\u627e\u5230\u5bf9\u5e94\u5ba2\u670d");
        }
        String u_uin = user_.getUin();
        HashedMap mapList_vip_redis = new HashedMap();
        for (int i = 6; i >= 0; --i) {
            String date = "";
            try {
                date = TimeUtils.getTimeBefore((int)i, (String)TimeUtils.getCurrentTimeInString((SimpleDateFormat)TimeUtils.DATE_FORMAT_DATE_NO), (SimpleDateFormat)TimeUtils.DATE_FORMAT_DATE_NO);
            }
            catch (Exception e) {
                continue;
            }
            String key_day = "message@" + user_id + "@" + u_uin + "@" + date;
            Set mapList = RedisUtil.getcontains((String)key_day);
            if (mapList.size() <= 0) continue;
            for (String str : mapList) {
                JSONArray message;
                String vip_id = str.split("@")[4];
                if (mapList_vip_redis.containsKey(vip_id)) {
                    message = (JSONArray)mapList_vip_redis.get(vip_id);
                    try {
                        message.addAll((Collection)JSONArray.parseArray((String)RedisUtil.get((String)str)));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    mapList_vip_redis.put(vip_id, message);
                    continue;
                }
                try {
                    message = JSONArray.parseArray((String)RedisUtil.get((String)str));
                    mapList_vip_redis.put(vip_id, message);
                }
                catch (Exception message2) {}
            }
        }
        for (String key : mapList_vip_redis.keySet()) {
            JSONArray openIdMessage = (JSONArray)mapList_vip_redis.get(key);
            for (int i = 0; i < openIdMessage.size(); ++i) {
                JSONObject message = openIdMessage.getJSONObject(i);
                String vip_id = message.getString("vip_id");
                DataRequest dataRequest_message = new DataRequest();
                JSONObject object = new JSONObject();
                object.put("vip_id", (Object)vip_id);
                object.put("user_id", (Object)user_id);
                dataRequest_message.setData(object);
                try {
                    this.update__message_read(dataRequest_message);
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        JSONObject object = new JSONObject();
        object.put("message", (Object)"\u5df2\u8bfb\u6210\u529f");
        return new DataResponse().setCode("0").setMsg("\u6210\u529f").setStatus(Status.SUCCESS).setData(object);
    }

    public DataResponse readAllMessageV2(DataRequest dataRequest) {
        return null;
    }

    public DataResponse isMessageRead(DataRequest dataRequest) {
        JSONObject data = dataRequest.getData();
        String user_id = data.getString("user_id");
        Query query_ = new Query();
        query_.addCriteria((CriteriaDefinition)Criteria.where((String)"user_id").is((Object)user_id));
        User user_ = (User)this.mongoTemplate.findOne(query_, User.class);
        if (null == user_) {
            return new DataResponse().setCode("-1").setMsg("\u53d1\u9001\u5931\u8d25,\u672a\u627e\u5230\u5bf9\u5e94\u5ba2\u670d");
        }
        boolean flag = false;
        String u_uin = user_.getUin();
        for (int i = 6; i >= 0; --i) {
            String date = "";
            try {
                date = TimeUtils.getTimeBefore((int)i, (String)TimeUtils.getCurrentTimeInString((SimpleDateFormat)TimeUtils.DATE_FORMAT_DATE_NO), (SimpleDateFormat)TimeUtils.DATE_FORMAT_DATE_NO);
            }
            catch (Exception e) {
                continue;
            }
            String key_day = "message@" + user_id + "@" + u_uin + "@" + date;
            Set mapList = RedisUtil.getcontains((String)key_day);
            if (mapList.size() <= 0) continue;
            flag = true;
            break;
        }
        JSONObject jsonObject = new JSONObject();
        if (flag) {
            jsonObject.put("flag", (Object)"Y");
            return new DataResponse().setStatus(Status.SUCCESS).setMsg("\u67e5\u8be2\u6210\u529f").setData(jsonObject);
        }
        jsonObject.put("flag", (Object)"N");
        return new DataResponse().setStatus(Status.SUCCESS).setMsg("\u67e5\u8be2\u6210\u529f").setData(jsonObject);
    }

    public DataResponse isMessageReadV2(DataRequest dataRequest) {
        return null;
    }

    public DataResponse miniChatToUser(DataRequest dataRequest) {
        return null;
    }

    public DataResponse chatList(DataRequest dataRequest) {
        JSONArray jsonArray;
        JSONArray jsonArraymessage;
        int endIndex;
        String sender_nick_name;
        String is_group_vip;
        JSONArray openIdMessage;
        HashedMap result_item;
        DBCollection dbCollection = this.mongoTemplate.getCollection("vip_message");
        JSONObject data = dataRequest.getData();
        String user_id = data.getString("user_id");
        Query query_ = new Query();
        query_.addCriteria((CriteriaDefinition)Criteria.where((String)"user_id").is((Object)user_id));
        User user_ = (User)this.mongoTemplate.findOne(query_, User.class);
        if (null == user_) {
            return new DataResponse().setCode("-1").setMsg("\u53d1\u9001\u5931\u8d25,\u672a\u627e\u5230\u5bf9\u5e94\u5ba2\u670d");
        }
        String u_uin = user_.getUin();
        int page_num = data.getIntValue("page_num");
        int page_size = data.getIntValue("page_size");
        JSONObject user = new JSONObject();
        ArrayList<Map> list_content = new ArrayList<Map>();
        ArrayList<HashedMap> mapList_result = new ArrayList<HashedMap>();
        JSONArray mapList_vip = new JSONArray();
        BasicDBList values = new BasicDBList();
        values.add((Object)new BasicDBObject("user_id", (Object)user_id));
        values.add((Object)new BasicDBObject("u_uin", (Object)u_uin));
        BasicDBObject query = new BasicDBObject();
        query.put((Object)"$and", (Object)values);
        HashedMap mapList_vip_redis = new HashedMap();
        for (int i = 6; i >= 0; --i) {
            String date = "";
            try {
                date = TimeUtils.getTimeBefore((int)i, (String)TimeUtils.getCurrentTimeInString((SimpleDateFormat)TimeUtils.DATE_FORMAT_DATE_NO), (SimpleDateFormat)TimeUtils.DATE_FORMAT_DATE_NO);
            }
            catch (Exception e) {
                continue;
            }
            String key_day = "message@" + user_id + "@" + u_uin + "@" + date;
            Set mapList = RedisUtil.getcontains((String)key_day);
            if (mapList.size() <= 0) continue;
            for (String str : mapList) {
                JSONArray message;
                String vip_id = str.split("@")[4];
                if (mapList_vip_redis.containsKey(vip_id)) {
                    message = (JSONArray)mapList_vip_redis.get(vip_id);
                    try {
                        message.addAll((Collection)JSONArray.parseArray((String)RedisUtil.get((String)str)));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    mapList_vip_redis.put(vip_id, message);
                    continue;
                }
                try {
                    message = JSONArray.parseArray((String)RedisUtil.get((String)str));
                    mapList_vip_redis.put(vip_id, message);
                }
                catch (Exception message2) {}
            }
        }
        DBCursor dbCur = dbCollection.find((DBObject)query);
        while (dbCur.hasNext()) {
            DBObject object = dbCur.next();
            Map map = object.toMap();
            Object id = map.get("_id");
            map.put("id", id.toString());
            map.remove("_id");
            list_content.add(map);
        }
        if (list_content.size() > 0) {
            for (int i = 0; i < list_content.size(); ++i) {
                String vip_id = String.valueOf(((Map)list_content.get(i)).get("vip_id"));
                if (mapList_vip_redis.containsKey(vip_id)) {
                    result_item = new HashedMap();
                    openIdMessage = (JSONArray)mapList_vip_redis.get(vip_id);
                    is_group_vip = String.valueOf(openIdMessage.getJSONObject(openIdMessage.size() - 1).get((Object)"is_group_vip"));
                    if ("Y".equals(is_group_vip)) {
                        sender_nick_name = String.valueOf(openIdMessage.getJSONObject(openIdMessage.size() - 1).get((Object)"sender_nick_name"));
                        result_item.put("message_content", sender_nick_name + ": " + openIdMessage.getJSONObject(openIdMessage.size() - 1).get((Object)"message_content"));
                    } else {
                        result_item.put("message_content", openIdMessage.getJSONObject(openIdMessage.size() - 1).get((Object)"message_content"));
                    }
                    result_item.put("nick_name", "null".equals(String.valueOf(openIdMessage.getJSONObject(openIdMessage.size() - 1).get((Object)"nick_name"))) ? "" : String.valueOf(openIdMessage.getJSONObject(openIdMessage.size() - 1).get((Object)"nick_name")));
                    result_item.put("head_img", openIdMessage.getJSONObject(openIdMessage.size() - 1).get((Object)"head_img"));
                    result_item.put("vip_id", openIdMessage.getJSONObject(openIdMessage.size() - 1).get((Object)"vip_id"));
                    result_item.put("wx_id", openIdMessage.getJSONObject(openIdMessage.size() - 1).get((Object)"wx_id"));
                    result_item.put("message_type", openIdMessage.getJSONObject(openIdMessage.size() - 1).get((Object)"message_type"));
                    result_item.put("message_date", openIdMessage.getJSONObject(openIdMessage.size() - 1).get((Object)"message_date"));
                    result_item.put("is_group_vip", "null".equals(is_group_vip) ? "N" : is_group_vip);
                    result_item.put("count", openIdMessage.size() + "");
                    mapList_vip_redis.remove(vip_id);
                    mapList_result.add(result_item);
                    continue;
                }
                if (mapList_vip_redis.containsKey(vip_id)) continue;
                result_item = new HashedMap();
                openIdMessage = (JSONArray)mapList_vip_redis.get(vip_id);
                if (null != openIdMessage) {
                    result_item.put("count", openIdMessage.size() + "");
                } else {
                    result_item.put("count", "0");
                }
                result_item.put("nick_name", "null".equals(String.valueOf(((Map)list_content.get(i)).get("nick_name"))) ? "" : String.valueOf(((Map)list_content.get(i)).get("nick_name")));
                result_item.put("head_img", String.valueOf(((Map)list_content.get(i)).get("head_img")));
                result_item.put("wx_id", String.valueOf(((Map)list_content.get(i)).get("wx_id")));
                result_item.put("message_date", String.valueOf(((Map)((Map)list_content.get(i)).get("last_message")).get("message_date")));
                is_group_vip = String.valueOf(((Map)((Map)list_content.get(i)).get("last_message")).get("is_group_vip"));
                result_item.put("is_group_vip", "null".equals(is_group_vip) ? "N" : is_group_vip);
                if ("Y".equals(is_group_vip)) {
                    sender_nick_name = String.valueOf(((Map)((Map)list_content.get(i)).get("last_message")).get("sender_nick_name"));
                    result_item.put("message_content", sender_nick_name + ": " + String.valueOf(((Map)((Map)list_content.get(i)).get("last_message")).get("message_content")));
                } else {
                    result_item.put("message_content", String.valueOf(((Map)((Map)list_content.get(i)).get("last_message")).get("message_content")));
                }
                result_item.put("vip_id", "null".equals(String.valueOf(((Map)list_content.get(i)).get("vip_id"))) ? "" : String.valueOf(((Map)list_content.get(i)).get("vip_id")));
                result_item.put("message_type", String.valueOf(((Map)((Map)list_content.get(i)).get("last_message")).get("message_type")));
                mapList_result.add(result_item);
            }
            for (String key : mapList_vip_redis.keySet()) {
                result_item = new HashedMap();
                openIdMessage = (JSONArray)mapList_vip_redis.get(key);
                result_item.put("nick_name", StringUtils.checkString((String)("null".equals(String.valueOf(openIdMessage.getJSONObject(openIdMessage.size() - 1).get((Object)"nick_name"))) ? "" : String.valueOf(openIdMessage.getJSONObject(openIdMessage.size() - 1).get((Object)"nick_name")))));
                result_item.put("head_img", openIdMessage.getJSONObject(openIdMessage.size() - 1).get((Object)"head_img"));
                result_item.put("wx_id", openIdMessage.getJSONObject(openIdMessage.size() - 1).get((Object)"wx_id"));
                result_item.put("vip_id", openIdMessage.getJSONObject(openIdMessage.size() - 1).get((Object)"vip_id"));
                result_item.put("message_type", openIdMessage.getJSONObject(openIdMessage.size() - 1).get((Object)"message_type"));
                result_item.put("message_date", openIdMessage.getJSONObject(openIdMessage.size() - 1).get((Object)"message_date"));
                is_group_vip = String.valueOf(openIdMessage.getJSONObject(openIdMessage.size() - 1).get((Object)"is_group_vip"));
                result_item.put("is_group_vip", "null".equals(is_group_vip) ? "N" : is_group_vip);
                if ("Y".equals(is_group_vip)) {
                    sender_nick_name = String.valueOf(openIdMessage.getJSONObject(openIdMessage.size() - 1).get((Object)"sender_nick_name"));
                    result_item.put("message_content", sender_nick_name + ": " + openIdMessage.getJSONObject(openIdMessage.size() - 1).get((Object)"message_content"));
                } else {
                    result_item.put("message_content", openIdMessage.getJSONObject(openIdMessage.size() - 1).get((Object)"message_content"));
                }
                result_item.put("count", openIdMessage.size() + "");
                mapList_result.add(result_item);
            }
        } else {
            for (String key : mapList_vip_redis.keySet()) {
                result_item = new HashedMap();
                openIdMessage = (JSONArray)mapList_vip_redis.get(key);
                result_item.put("nick_name", StringUtils.checkString((String)("null".equals(String.valueOf(openIdMessage.getJSONObject(openIdMessage.size() - 1).get((Object)"nick_name"))) ? "" : String.valueOf(openIdMessage.getJSONObject(openIdMessage.size() - 1).get((Object)"nick_name")))));
                is_group_vip = String.valueOf(openIdMessage.getJSONObject(openIdMessage.size() - 1).get((Object)"is_group_vip"));
                result_item.put("is_group_vip", "null".equals(is_group_vip) ? "N" : is_group_vip);
                if ("Y".equals(is_group_vip)) {
                    sender_nick_name = String.valueOf(openIdMessage.getJSONObject(openIdMessage.size() - 1).get((Object)"sender_nick_name"));
                    result_item.put("message_content", sender_nick_name + ": " + openIdMessage.getJSONObject(openIdMessage.size() - 1).get((Object)"message_content"));
                } else {
                    result_item.put("message_content", openIdMessage.getJSONObject(openIdMessage.size() - 1).get((Object)"message_content"));
                }
                result_item.put("head_img", openIdMessage.getJSONObject(openIdMessage.size() - 1).get((Object)"head_img"));
                result_item.put("wx_id", openIdMessage.getJSONObject(openIdMessage.size() - 1).get((Object)"wx_id"));
                result_item.put("message_date", openIdMessage.getJSONObject(openIdMessage.size() - 1).get((Object)"message_date"));
                result_item.put("vip_id", openIdMessage.getJSONObject(openIdMessage.size() - 1).get((Object)"vip_id"));
                result_item.put("message_type", openIdMessage.getJSONObject(openIdMessage.size() - 1).get((Object)"message_type"));
                result_item.put("count", openIdMessage.size() + "");
                mapList_result.add(result_item);
            }
        }
        if ((endIndex = (page_num + 1) * page_size) > (jsonArraymessage = JSONArraySortUtil.sortDesc((JSONArray)(jsonArray = JSONArray.parseArray((String)JSON.toJSONString(mapList_result))), (String)"message_date")).size()) {
            endIndex = jsonArraymessage.size();
        }
        for (int i = page_num * page_size; i < endIndex; ++i) {
            JSONObject map = jsonArraymessage.getJSONObject(i);
            String wx_id = map.getString("wx_id");
            String remark_name = RedisUtil.get((String)(user_id + "-" + u_uin + "-" + wx_id));
            map.put("remark_name", (Object)StringUtils.checkString((String)remark_name));
            mapList_vip.add((Object)map);
        }
        user.put("user", (Object)mapList_vip);
        return new DataResponse().setData(user).setCode("0").setStatus(Status.SUCCESS);
    }

    public DataResponse chatListV2(DataRequest dataRequest) {
        return null;
    }

    public DataResponse chatMessage(DataRequest dataRequest) {
        try {
            this.update__message_read(dataRequest);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        JSONObject data = dataRequest.getData();
        String user_id = data.getString("user_id");
        String vip_id = data.getString("vip_id");
        int page_size = data.getIntValue("page_size");
        int page_num = data.getIntValue("page_num");
        BasicDBObject sort_obj = new BasicDBObject("message_date", (Object)-1);
        DBCollection dbCollection = this.mongoTemplate.getCollection("vip_message_content");
        BasicDBList values = new BasicDBList();
        values.add((Object)new BasicDBObject("user_id", (Object)user_id));
        values.add((Object)new BasicDBObject("vip_id", (Object)vip_id));
        BasicDBObject query = new BasicDBObject();
        query.put((Object)"$and", (Object)values);
        DBCursor dbCur = dbCollection.find((DBObject)query).skip(page_num * page_size).limit(page_size).sort((DBObject)sort_obj);
        log.info((Object)dbCur.size());
        JSONObject jsonObject = new JSONObject();
        JSONArray messageList = new JSONArray();
        while (dbCur.hasNext()) {
            DBObject object = dbCur.next();
            Map map = object.toMap();
            Object id = map.get("_id");
            map.put("id", id.toString());
            map.remove("_id");
            messageList.add((Object)map);
        }
        jsonObject.put("message", (Object)messageList);
        return new DataResponse().setStatus(Status.SUCCESS).setData(jsonObject).setCode("0");
    }

    public DataResponse chatMessageV2(DataRequest dataRequest) {
        return null;
    }

    public DataResponse removeChatMessage(DataRequest dataRequest) {
        JSONObject data = dataRequest.getData();
        String user_id = data.getString("user_id");
        String vip_id = data.getString("vip_id");
        String message_id = data.getString("message_id");
        DBCollection dbCollection = this.mongoTemplate.getCollection("vip_message_content");
        BasicDBObject query = new BasicDBObject();
        query.put((Object)"_id", (Object)new ObjectId(message_id));
        WriteResult writeResult = dbCollection.remove((DBObject)query);
        if (writeResult.getN() > 0) {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("message", (Object)"\u5220\u9664\u6210\u529f");
            return new DataResponse().setStatus(Status.SUCCESS).setData(jsonObject).setCode("0");
        }
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("message", (Object)"\u5220\u9664\u5931\u8d25");
        return new DataResponse().setStatus(Status.FAILED).setData(jsonObject).setCode("-1");
    }

    public DataResponse searchMessageContent(DataRequest dataRequest) {
        DataResponse dataResponse = new DataResponse();
        JSONObject data = dataRequest.getData();
        String user_id = data.getString("user_id");
        int page_num = data.getIntValue("page_num");
        int page_size = data.getIntValue("page_size");
        Query query_ = new Query();
        query_.addCriteria((CriteriaDefinition)Criteria.where((String)"user_id").is((Object)user_id));
        User user = (User)this.mongoTemplate.findOne(query_, User.class);
        if (null == user) {
            return new DataResponse().setCode("-1").setMsg("\u53d1\u9001\u5931\u8d25,\u672a\u627e\u5230\u5bf9\u5e94\u5ba2\u670d");
        }
        String u_uin = user.getUin();
        DBCollection collection = this.mongoTemplate.getCollection("vip_message_content");
        BasicDBObject basicDB = new BasicDBObject();
        BasicDBList basicDBList1 = new BasicDBList();
        basicDBList1.add((Object)new BasicDBObject("user_id", (Object)user_id));
        basicDBList1.add((Object)new BasicDBObject("u_uin", (Object)u_uin));
        basicDBList1.add((Object)new BasicDBObject("message_content", (Object)new BasicDBObject("$regex", (Object)data.getString("message_content")).append("$options", (Object)"i")));
        basicDB.put((Object)"$and", (Object)basicDBList1);
        BasicDBObject match_user = new BasicDBObject("$match", (Object)basicDB);
        BasicDBObject groupField = new BasicDBObject("_id", (Object)"$vip_id");
        BasicDBObject group_user = new BasicDBObject("$group", (Object)groupField);
        BasicDBObject basicSkip = new BasicDBObject("$skip", (Object)(page_num * page_size));
        BasicDBObject basicLimit = new BasicDBObject("$limit", (Object)page_size);
        AggregationOutput output_user = collection.aggregate((DBObject)match_user, new DBObject[]{group_user, basicLimit, basicSkip});
        JSONArray jsonArray = new JSONArray();
        for (DBObject dbObject : output_user.results()) {
            BasicDBObject basicDBObject1 = (BasicDBObject)dbObject;
            String vip_id = basicDBObject1.getString("_id");
            BasicDBObject basicDBObject = new BasicDBObject();
            basicDBObject.put((Object)"vip_id", (Object)vip_id);
            basicDBObject.put((Object)"message_content", (Object)new BasicDBObject("$regex", (Object)data.getString("message_content")).append("$options", (Object)"i"));
            DBCursor dbCur = collection.find((DBObject)basicDBObject);
            log.info((Object)dbCur.size());
            JSONObject jsonObject = new JSONObject();
            JSONArray messageList = new JSONArray();
            while (dbCur.hasNext()) {
                DBObject object = dbCur.next();
                Map map = object.toMap();
                Object id = map.get("_id");
                map.put("id", id.toString());
                map.remove("_id");
                messageList.add((Object)map);
            }
            jsonObject.put("message", (Object)messageList);
            jsonObject.put("vip_id", (Object)vip_id);
            Criteria criteria = new Criteria();
            criteria.and("user_id").is((Object)user_id);
            criteria.and("vip_id").is((Object)vip_id);
            Query query = new Query((CriteriaDefinition)criteria);
            Vip vip = (Vip)this.mongoTemplate.findOne(query, Vip.class);
            if (null == vip) continue;
            jsonObject.put("nick_name", (Object)vip.getNick_name());
            jsonObject.put("remark_name", (Object)StringUtils.checkString((String)vip.getRemark_name()));
            jsonArray.add((Object)jsonObject);
        }
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("message", (Object)jsonArray);
        return dataResponse.setStatus(Status.SUCCESS).setData(jsonObject).setCode("0");
    }

    public DataResponse chatProductList(DataRequest dataRequest) {
        DBCollection collection = this.mongoTemplate.getCollection("def_message_product");
        JSONObject data = dataRequest.getData();
        String user_id = data.getString("user_id");
        String vip_id = data.getString("vip_id");
        int page_num = data.getIntValue("page_num");
        int page_size = data.getIntValue("page_size");
        JSONObject jsonObject = new JSONObject();
        try {
            BasicDBObject basicDBObject = new BasicDBObject();
            basicDBObject.put((Object)"user_id", (Object)user_id);
            basicDBObject.put((Object)"vip_id", (Object)vip_id);
            log.info("--$match---" + basicDBObject);
            BasicDBObject match_user = new BasicDBObject("$match", (Object)basicDBObject);
            BasicDBObject groupField = new BasicDBObject("_id", (Object)"$recommend_time");
            BasicDBObject group_user = new BasicDBObject("$group", (Object)groupField);
            BasicDBObject basicSkip = new BasicDBObject("$skip", (Object)(page_num * page_size));
            BasicDBObject basicLimit = new BasicDBObject("$limit", (Object)page_size);
            BasicDBObject sort = new BasicDBObject();
            sort.put((Object)"_id", (Object)-1);
            BasicDBObject agg_sort = new BasicDBObject("$sort", (Object)sort);
            AggregationOutput output_user = collection.aggregate((DBObject)match_user, new DBObject[]{group_user, agg_sort, basicLimit, basicSkip});
            JSONArray jsonArray = new JSONArray();
            for (DBObject dbObject : output_user.results()) {
                BasicDBObject basicDBObject1 = (BasicDBObject)dbObject;
                String recommend_time = basicDBObject1.getString("_id");
                Criteria criteria = new Criteria();
                criteria.and("user_id").is((Object)user_id);
                criteria.and("vip_id").is((Object)vip_id);
                criteria.and("recommend_time").is((Object)recommend_time);
                Query query = new Query((CriteriaDefinition)criteria);
                List productMessageList = this.mongoTemplate.find(query, ProductMessage.class);
                ArrayList<Product> product_list = new ArrayList<Product>();
                for (ProductMessage productMessage : productMessageList) {
                    Criteria criteria_product = new Criteria();
                    log.info("-getProduct_id---" + productMessage.getProduct_id());
                    if (null == productMessage.getProduct_id()) continue;
                    criteria_product.and("_id").is((Object)new ObjectId(productMessage.getProduct_id()));
                    Query query_p = new Query((CriteriaDefinition)criteria_product);
                    log.info("--criteria_product-----" + query_p);
                    Product product = (Product)this.mongoTemplate.findOne(query_p, Product.class);
                    if (null == product) continue;
                    product_list.add(product);
                }
                JSONObject vipInfo = new JSONObject();
                vipInfo.put("recommend_time", (Object)recommend_time);
                vipInfo.put("product_list", product_list);
                jsonArray.add((Object)vipInfo);
            }
            jsonObject.put("message", (Object)jsonArray);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return new DataResponse().setData(jsonObject).setCode("0").setStatus(Status.SUCCESS);
    }

    public DataResponse removeChatProduct(DataRequest dataRequest) {
        DBCollection collection = this.mongoTemplate.getCollection("def_message_product");
        JSONObject data = dataRequest.getData();
        String user_id = data.getString("user_id");
        String vip_id = data.getString("vip_id");
        String product_id = data.getString("product_id");
        JSONObject jsonObject = new JSONObject();
        try {
            BasicDBObject basicDBObject = new BasicDBObject();
            basicDBObject.put((Object)"user_id", (Object)user_id);
            basicDBObject.put((Object)"vip_id", (Object)vip_id);
            basicDBObject.put((Object)"product_id", (Object)product_id);
            WriteResult writeResult = collection.remove((DBObject)basicDBObject);
            if (writeResult.getN() > 0) {
                jsonObject.put("message", (Object)"\u5220\u9664\u6210\u529f");
            } else {
                jsonObject.put("message", (Object)"\u5220\u9664\u5931\u8d25");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return new DataResponse().setData(jsonObject).setCode("0").setStatus(Status.SUCCESS);
    }

    public DataResponse removeChatListItem(DataRequest dataRequest) {
        JSONObject data = dataRequest.getData();
        String user_id = data.getString("user_id");
        String vip_id = data.getString("vip_id");
        String wx_id = data.getString("wx_id");
        DBCollection collection = this.mongoTemplate.getCollection("vip_message");
        BasicDBObject basicDBObject = new BasicDBObject();
        basicDBObject.put((Object)"user_id", (Object)user_id);
        basicDBObject.put((Object)"wx_id", (Object)wx_id);
        basicDBObject.put((Object)"vip_id", (Object)vip_id);
        log.info("mongoTemplate" + basicDBObject + collection.find((DBObject)basicDBObject).size());
        WriteResult writeResult = collection.remove((DBObject)basicDBObject);
        if (writeResult.getN() == 0) {
            Set keys = RedisUtil.getcontains((String)vip_id);
            log.info("-\u5220\u9664redis-key---" + keys);
            if (keys.size() > 0) {
                for (String str : keys) {
                    log.info("--key---" + str);
                    RedisUtil.remove((String)str);
                }
            }
        }
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("message", (Object)"\u5220\u9664\u6210\u529f");
        return new DataResponse().setData(jsonObject).setCode("0").setStatus(Status.SUCCESS);
    }

    public void message_product_insert(String product_id, String user_id, String vip_id) throws Exception {
        String monthTime = TimeUtils.getCurrentTimeInString((SimpleDateFormat)TimeUtils.MONTH_FORMAT);
        String currentTime = TimeUtils.getCurrentTimeInString((SimpleDateFormat)TimeUtils.DATE_FORMAT_DATE_NO);
        ProductMessage productMessage = new ProductMessage();
        productMessage.setIs_active("Y");
        productMessage.setProduct_id(product_id);
        productMessage.setRecommend_time(monthTime);
        productMessage.setUser_id(user_id);
        productMessage.setVip_id(vip_id);
        productMessage.setCreator_id(user_id);
        productMessage.setModifier_id(user_id);
        productMessage.setCreated_date(currentTime);
        productMessage.setModified_date(currentTime);
        this.mongoTemplate.save((Object)productMessage);
    }

    public synchronized int update__message_read(DataRequest db) throws Exception {
        String vip_id = db.getData().getString("vip_id");
        log.info("---------\u5f00\u59cb\u66f4\u65b0\u6d88\u606f-----------" + vip_id);
        String user_id = db.getData().getString("user_id");
        Query query_ = new Query();
        query_.addCriteria((CriteriaDefinition)Criteria.where((String)"user_id").is((Object)user_id));
        User user_ = (User)this.mongoTemplate.findOne(query_, User.class);
        String u_uin = user_.getUin();
        JSONArray message = new JSONArray();
        for (int i = 6; i >= 0; --i) {
            String date = TimeUtils.getTimeBefore((int)i, (String)TimeUtils.getCurrentTimeInString((SimpleDateFormat)TimeUtils.DATE_FORMAT_DATE_NO), (SimpleDateFormat)TimeUtils.DATE_FORMAT_DATE_NO);
            String key = "message@" + user_id + "@" + u_uin + "@" + date + "@" + vip_id;
            try {
                JSONArray param = JSONArray.parseArray((String)RedisUtil.get((String)key));
                if (null == param || param.size() <= 0) continue;
                message.addAll((Collection)param);
                continue;
            }
            catch (Exception param) {
                // empty catch block
            }
        }
        log.info("------redis-\u7ed3\u679c-----" + message.size());
        if (message.size() > 0) {
            String sender_avatar;
            String sender_wx_id;
            String sender_nick_name;
            String is_group_vip;
            String wx_id;
            JSONObject last_message = message.getJSONObject(message.size() - 1);
            for (int i = 0; i < message.size(); ++i) {
                JSONObject messageContent = message.getJSONObject(i);
                String message_type = messageContent.getString("message_type");
                String message_content = messageContent.getString("message_content");
                String message_direction = messageContent.getString("message_direction");
                String message_date = messageContent.getString("message_date");
                wx_id = messageContent.getString("wx_id");
                is_group_vip = null == messageContent.getString("is_group_vip") ? "N" : messageContent.getString("is_group_vip");
                sender_nick_name = messageContent.getString("sender_nick_name");
                sender_wx_id = messageContent.getString("sender_wx_id");
                sender_avatar = messageContent.getString("sender_avatar");
                String is_friend = messageContent.getString("is_friend");
                String sender_vip_id = messageContent.getString("sender_vip_id");
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("user_id", user_id);
                map.put("message_direction", message_direction);
                map.put("vip_id", vip_id);
                map.put("wx_id", wx_id);
                map.put("u_uin", u_uin);
                map.put("is_group_vip", is_group_vip);
                map.put("message_type", message_type);
                map.put("message_content", message_content);
                map.put("message_date", message_date);
                map.put("is_friend", is_friend);
                if ("Y".equals(is_group_vip)) {
                    map.put("sender_nick_name", sender_nick_name);
                    map.put("sender_wx_id", sender_wx_id);
                    map.put("sender_avatar", sender_avatar);
                    if ("Y".equals(is_friend)) {
                        map.put("sender_vip_id", sender_vip_id);
                    }
                }
                this.mongoTemplate.save(map, "vip_message_content");
            }
            String nickname = last_message.getString("nick_name");
            String message_type = last_message.getString("message_type");
            String message_content = last_message.getString("message_content");
            String message_direction = last_message.getString("message_direction");
            String message_date = last_message.getString("message_date");
            String head_img = last_message.getString("head_img");
            wx_id = last_message.getString("wx_id");
            is_group_vip = "null".equals(String.valueOf(last_message.getString("is_group_vip"))) ? "N" : String.valueOf(last_message.getString("is_group_vip"));
            sender_nick_name = last_message.getString("sender_nick_name");
            sender_wx_id = last_message.getString("sender_wx_id");
            sender_avatar = last_message.getString("sender_avatar");
            BasicDBObject map = new BasicDBObject();
            map.put((Object)"user_id", (Object)user_id);
            map.put((Object)"vip_id", (Object)vip_id);
            map.put((Object)"u_uin", (Object)u_uin);
            BasicDBObject new_map = new BasicDBObject();
            JSONObject last_message_content = new JSONObject();
            last_message_content.put("message_type", (Object)message_type);
            last_message_content.put("message_content", (Object)message_content);
            last_message_content.put("message_direction", (Object)message_direction);
            last_message_content.put("message_date", (Object)message_date);
            last_message_content.put("is_group_vip", (Object)is_group_vip);
            if ("Y".equals(is_group_vip)) {
                last_message_content.put("sender_nick_name", (Object)sender_nick_name);
                last_message_content.put("sender_wx_id", (Object)sender_wx_id);
                last_message_content.put("sender_avatar", (Object)sender_avatar);
            }
            new_map.put((Object)"nick_name", (Object)nickname);
            new_map.put((Object)"user_id", (Object)user_id);
            new_map.put((Object)"head_img", (Object)head_img);
            new_map.put((Object)"vip_id", (Object)vip_id);
            new_map.put((Object)"u_uin", (Object)u_uin);
            new_map.put((Object)"wx_id", (Object)wx_id);
            new_map.put((Object)"modified_date", (Object)message_date);
            new_map.put((Object)"last_message", (Object)last_message_content);
            this.insert_message_to_mongo(new_map, map, "vip_message");
        }
        String key = "message@" + user_id + "@" + u_uin + "@*@" + vip_id;
        Set keys = RedisUtil.getcontains((String)key);
        log.info("-\u5220\u9664redis-key---" + keys);
        if (keys.size() > 0) {
            for (String str : keys) {
                log.info("--key---" + str);
                RedisUtil.remove((String)str);
            }
        }
        return 1;
    }

    public int insert_message_to_mongo(BasicDBObject new_map, BasicDBObject query_map_param, String collection) {
        DBCollection dbCollection = this.mongoTemplate.getCollection(collection);
        BasicDBObject update = new BasicDBObject();
        update.put((Object)"$set", (Object)new_map);
        WriteResult writeResult = dbCollection.updateMulti((DBObject)query_map_param, (DBObject)update);
        int flag = writeResult.getN();
        if (flag == 0) {
            this.mongoTemplate.save((Object)new_map, "vip_message");
        }
        log.info("\u66f4\u65b0" + flag);
        DBCollection dbColl = this.mongoTemplate.getCollection("def_vip");
        JSONObject last_message = (JSONObject)new_map.get("last_message");
        BasicDBObject vip = new BasicDBObject();
        vip.put((Object)"last_message", (Object)last_message);
        BasicDBObject update_vip = new BasicDBObject();
        update_vip.put((Object)"$set", (Object)vip);
        WriteResult writeResult_vip = dbColl.updateMulti((DBObject)query_map_param, (DBObject)update_vip);
        if (writeResult_vip.getN() == 0) {
            vip.put((Object)"user_id", (Object)query_map_param.get("user_id").toString());
            vip.put((Object)"vip_id", (Object)query_map_param.get("vip_id").toString());
            vip.put((Object)"wx_id", (Object)query_map_param.get("wx_id").toString());
            vip.put((Object)"u_uin", (Object)query_map_param.get("u_uin").toString());
            vip.put((Object)"last_message", (Object)last_message);
            this.mongoTemplate.save((Object)vip, "def_vip");
        }
        return flag;
    }
}

