/*
 * Decompiled with CFR 0.152.
 */
package kr.weitao.weitaokr.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.mongodb.BasicDBList;
import com.mongodb.BasicDBObject;
import com.mongodb.DBCollection;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import com.mongodb.WriteResult;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.util.Map;
import kr.weitao.business.entity.Memorandum;
import kr.weitao.common.util.DateSwitchUtil;
import kr.weitao.common.util.StringUtils;
import kr.weitao.common.util.TimeUtils;
import kr.weitao.starter.model.DataRequest;
import kr.weitao.starter.model.DataResponse;
import kr.weitao.starter.model.Status;
import kr.weitao.starter.util.mongodb.MongodbUtil;
import kr.weitao.weitaokr.service.JobService;
import kr.weitao.weitaokr.service.MemorandumService;
import kr.weitao.weitaokr.task.common.QueueParam;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bson.types.ObjectId;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.stereotype.Service;

@Service
public class MemorandumServiceImpl
implements MemorandumService {
    private static final Logger log = LogManager.getLogger(MemorandumServiceImpl.class);
    private static final String[] cron_format_ori = new String[]{"seconds", "minutes", "hours", "dayofmonth", "month", "dayofweek", "year"};
    private static final String[] cron_format = new String[]{"seconds", "minutes", "hours", "day", "month", "week", "year"};
    private static final String[] cron_value = new String[]{"0", "*", "*", "*", "*", "?", "*"};
    @Autowired
    MongoTemplate mongoTemplate;
    @Autowired
    private JobService jobService;

    @CacheEvict(value={"memorandum"}, allEntries=true)
    public DataResponse add(DataRequest dataRequest) {
        LocalDateTime end_datetime;
        String end_time_str;
        DataResponse dataResponse = new DataResponse();
        JSONObject data = dataRequest.getData();
        log.debug("dat:" + data.toJSONString());
        String user_id = data.getString("user_id");
        Memorandum memorandum = new Memorandum();
        memorandum.set_id(new ObjectId());
        memorandum.setUser_id(user_id);
        memorandum.setIs_active("Y");
        memorandum.setCreator_id(user_id);
        memorandum.setCreated_date(TimeUtils.getCurrentTimeInString((SimpleDateFormat)TimeUtils.DATETIME_FORMAT_DATE));
        memorandum.setModifier_id(user_id);
        memorandum.setModified_date(memorandum.getCreated_date());
        memorandum.setRemind_time(data.getString("remind_time"));
        memorandum.setContent(data.getString("content"));
        memorandum.setImages(data.getJSONArray("images"));
        memorandum.setVipList(data.getJSONArray("vipList"));
        memorandum.setClass_name("kr.weitao.weitaokr.task.vip.vipremind.VipRemindJob");
        JSONObject recurrence = data.getJSONObject("recurrence");
        if (recurrence == null || recurrence.isEmpty()) {
            log.error("recurrence can not be null");
            return dataResponse.setStatus(Status.FAILED).setMsg("\u63d0\u9192\u5468\u671f\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a").setCode("-1");
        }
        String start_time_str = recurrence.getString("start_time");
        if (StringUtils.isNull((Object)start_time_str)) {
            start_time_str = DateSwitchUtil.getCurrentDate();
            recurrence.put("start_time", (Object)start_time_str);
        }
        if (StringUtils.isNull((Object)(end_time_str = recurrence.getString("end_time"))) && (end_datetime = MongodbUtil.getEndTime((JSONObject)recurrence)) != null) {
            end_time_str = DateSwitchUtil.toString((LocalDateTime)end_datetime);
            recurrence.put("end_time", (Object)end_time_str);
        }
        String cron = MongodbUtil.cron_expression((JSONObject)recurrence);
        recurrence.put("cron", (Object)cron);
        memorandum.setRecurrence(recurrence);
        log.info("create begin....");
        this.mongoTemplate.save((Object)memorandum);
        log.info("create end...");
        QueueParam qp = new QueueParam();
        qp.set_id((Object)new ObjectId());
        qp.setUser_id(memorandum.getUser_id());
        qp.setCreator_id(user_id);
        qp.setCreated_date(memorandum.getCreated_date());
        qp.setModifier_id(user_id);
        qp.setModified_date(memorandum.getModified_date());
        qp.setIs_active("Y");
        qp.setName("_id");
        qp.setValue(memorandum.get_id().toString());
        qp.setQueue_item_id(memorandum.get_id().toString());
        this.mongoTemplate.save((Object)qp);
        String str = memorandum.toString();
        log.info("str:" + str);
        this.jobService.addJob(JSON.parseObject((String)str));
        JSONObject da = new JSONObject();
        da.put("id", (Object)memorandum.get_id().toString());
        return dataResponse.setStatus(Status.SUCCESS).setMsg("\u521b\u5efa\u6210\u529f").setCode("0").setData(da);
    }

    public DataResponse mod(DataRequest dataRequest) {
        JSONObject da;
        DataResponse dataResponse = new DataResponse();
        JSONObject data = dataRequest.getData();
        String _id = data.getString("id");
        if (StringUtils.isNull((Object)_id)) {
            log.error("current user mast has value");
            return dataResponse.setCode("-1").setMsg("\u4fee\u6539\u8bb0\u5f55ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String user_id = data.getString("user_id");
        data.put("modifier_id", (Object)user_id);
        data.put("modified_date", (Object)TimeUtils.getCurrentTimeInString((SimpleDateFormat)TimeUtils.DATETIME_FORMAT_DATE));
        BasicDBObject basicDBObject = new BasicDBObject();
        BasicDBObject update = new BasicDBObject();
        if (data.containsKey((Object)"content")) {
            basicDBObject.put((Object)"content", (Object)data.getString("content"));
        }
        if (data.containsKey((Object)"images")) {
            basicDBObject.put((Object)"images", (Object)data.getJSONArray("images"));
        }
        if (data.containsKey((Object)"status")) {
            basicDBObject.put((Object)"status", (Object)data.getString("status"));
        }
        if (data.containsKey((Object)"remind_time")) {
            basicDBObject.put((Object)"remind_time", (Object)data.getString("remind_time"));
        }
        if (data.containsKey((Object)"vipList")) {
            basicDBObject.put((Object)"vipList", (Object)data.getJSONArray("vipList"));
        }
        if (data.containsKey((Object)"recurrence")) {
            LocalDateTime end_datetime;
            String end_time_str;
            JSONObject recurrence = data.getJSONObject("recurrence");
            if (recurrence == null || recurrence.isEmpty()) {
                log.error("recurrence can not be null");
                return dataResponse.setStatus(Status.FAILED).setMsg("\u63d0\u9192\u5468\u671f\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a").setCode("-1");
            }
            String start_time_str = recurrence.getString("start_time");
            if (StringUtils.isNull((Object)start_time_str)) {
                start_time_str = DateSwitchUtil.getCurrentDate();
                recurrence.put("start_time", (Object)start_time_str);
            }
            if (StringUtils.isNull((Object)(end_time_str = recurrence.getString("end_time"))) && (end_datetime = MongodbUtil.getEndTime((JSONObject)recurrence)) != null) {
                end_time_str = DateSwitchUtil.toString((LocalDateTime)end_datetime);
                recurrence.put("end_time", (Object)end_time_str);
            }
            String cron = MongodbUtil.cron_expression((JSONObject)recurrence);
            recurrence.put("cron", (Object)cron);
            data.put("recurrence", (Object)recurrence);
            basicDBObject.put((Object)"recurrence", (Object)recurrence);
        }
        basicDBObject.put((Object)"modified_date", (Object)TimeUtils.getCurrentTimeInString((SimpleDateFormat)TimeUtils.DATETIME_FORMAT_DATE));
        update.put((Object)"$set", (Object)basicDBObject);
        BasicDBObject query = new BasicDBObject();
        query.put((Object)"_id", (Object)new ObjectId(_id));
        log.info("update>>" + update + ">>>>>>>>>query>>>>>>>" + query);
        WriteResult writeResult = this.mongoTemplate.getCollection("def_memorandum").updateMulti((DBObject)query, (DBObject)update);
        if (writeResult.getN() > 0) {
            da = new JSONObject();
            da.put("message", (Object)"\u4fee\u6539\u6210\u529f");
            try {
                this.jobService.modify(data);
            }
            catch (Exception e) {
                log.error("modify task error:" + e.getLocalizedMessage(), (Throwable)e);
            }
            dataResponse.setStatus(Status.SUCCESS).setCode("0").setId(dataRequest.getId()).setData(da);
        } else {
            da = new JSONObject();
            da.put("message", (Object)"\u4fee\u6539\u5931\u8d25");
            dataResponse.setStatus(Status.FAILED).setCode("-1").setId(dataRequest.getId()).setData(da).setMsg("\u4fee\u6539\u5931\u8d25");
        }
        return dataResponse;
    }

    public DataResponse del(DataRequest dataRequest) {
        DataResponse dataResponse = new DataResponse();
        JSONObject data = dataRequest.getData();
        String _id = data.getString("id");
        String user_id = data.getString("user_id");
        DBCollection collection = this.mongoTemplate.getCollection("def_memorandum");
        BasicDBList basicDB = new BasicDBList();
        if (StringUtils.isNotNull((Object)_id)) {
            basicDB.add((Object)new BasicDBObject("_id", (Object)new ObjectId(_id)));
        }
        basicDB.add((Object)new BasicDBObject("user_id", (Object)user_id));
        if (StringUtils.isNull((Object)user_id)) {
            log.error("current user mast has value");
            return dataResponse.setCode("-1").setMsg("\u7528\u6237\u4fe1\u606f\u6709\u8bef");
        }
        log.info("remove--" + basicDB);
        BasicDBObject basic = new BasicDBObject();
        basic.put((Object)"$and", (Object)basicDB);
        WriteResult writeResult = collection.remove((DBObject)basic);
        if (writeResult.getN() > 0) {
            JSONObject da = new JSONObject();
            da.put("message", (Object)"\u5220\u9664\u6210\u529f");
            this.jobService.removeJob(data);
            dataResponse.setStatus(Status.SUCCESS).setCode("0").setId(dataRequest.getId()).setData(da);
        } else {
            JSONObject da = new JSONObject();
            da.put("message", (Object)"\u5220\u9664\u5931\u8d25");
            dataResponse.setStatus(Status.FAILED).setCode("-1").setId(dataRequest.getId()).setData(da).setMsg("\u4fee\u6539\u5931\u8d25");
        }
        return dataResponse;
    }

    public DataResponse query(DataRequest dataRequest) {
        DataResponse dataResponse = new DataResponse();
        JSONObject data = dataRequest.getData();
        String _id = data.getString("id");
        String user_id = data.getString("user_id");
        JSONArray memorandum_array = new JSONArray();
        BasicDBList condition_list = new BasicDBList();
        if (StringUtils.isNotNull((Object)_id)) {
            condition_list.add((Object)new BasicDBObject("_id", (Object)new ObjectId(_id)));
        }
        if (StringUtils.isNull((Object)_id) && StringUtils.isNull((Object)user_id)) {
            log.error("id and user_id mast has value of any one");
            return dataResponse.setStatus(Status.FAILED).setMsg("\u63d0\u9192\u8bb0\u5f55ID\u4e0e\u4f1a\u5458\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a").setCode("-1");
        }
        if (StringUtils.isNotNull((Object)user_id)) {
            condition_list.add((Object)new BasicDBObject("user_id", (Object)user_id));
        }
        BasicDBObject condition = new BasicDBObject();
        condition.put((Object)"$and", (Object)condition_list);
        log.debug("query:" + condition);
        DBCollection collection = this.mongoTemplate.getCollection("def_memorandum");
        DBCursor dbCur = collection.find((DBObject)condition);
        Object temp_id = null;
        DBObject object = null;
        Map map = null;
        while (dbCur.hasNext()) {
            object = dbCur.next();
            temp_id = object.get("_id");
            map = object.toMap();
            map.put("id", _id.toString());
            memorandum_array.add((Object)map);
        }
        JSONObject result_obj = new JSONObject();
        result_obj.put("message", (Object)memorandum_array);
        return dataResponse.setStatus(Status.SUCCESS).setData(result_obj).setCode("0");
    }

    @Cacheable(value={"memorandum"}, key="#dataRequest.data")
    public DataResponse search(DataRequest dataRequest) {
        DataResponse dataResponse = new DataResponse();
        JSONObject data = dataRequest.getData();
        String user_id = data.getString("user_id");
        String vip_id = data.getString("vip_id");
        int page_num = data.getIntValue("page_num");
        int page_size = data.getIntValue("page_size");
        String search_text = data.getString("content");
        String type = data.getString("type");
        DBCollection collection = this.mongoTemplate.getCollection("def_memorandum");
        BasicDBObject basicDB = new BasicDBObject();
        BasicDBList basicDBList1 = new BasicDBList();
        basicDBList1.add((Object)new BasicDBObject("user_id", (Object)user_id));
        basicDBList1.add((Object)new BasicDBObject("is_active", (Object)"Y"));
        if (StringUtils.isNotNull((Object)vip_id)) {
            basicDBList1.add((Object)new BasicDBObject("vipList.vip_id", (Object)vip_id));
        }
        if ("text".equals(type)) {
            BasicDBList basicDBList1_or = new BasicDBList();
            basicDBList1_or.add((Object)new BasicDBObject("vipList.vip_name", (Object)new BasicDBObject("$regex", (Object)search_text).append("$options", (Object)"i")));
            basicDBList1_or.add((Object)new BasicDBObject("content", (Object)new BasicDBObject("$regex", (Object)search_text).append("$options", (Object)"i")));
            basicDBList1.add((Object)new BasicDBObject("$or", (Object)basicDBList1_or));
        }
        if ("date".equals(type)) {
            String send_time_value = search_text;
            String start_time = send_time_value + " 00:00:00";
            String end_time = send_time_value + " 23:59:59";
            if (!"*".equals(start_time)) {
                BasicDBObject basicDBObject1 = new BasicDBObject();
                basicDBObject1.put((Object)"$gte", (Object)start_time);
                basicDBList1.add((Object)new BasicDBObject("created_date", (Object)basicDBObject1));
            }
            if (!"*".equals(end_time)) {
                BasicDBObject basicDBObject2 = new BasicDBObject();
                basicDBObject2.put((Object)"$lte", (Object)end_time);
                basicDBList1.add((Object)new BasicDBObject("created_date", (Object)basicDBObject2));
            }
        }
        basicDB.put((Object)"$and", (Object)basicDBList1);
        log.info("---\u5907\u5fd8\u641c\u7d22----" + basicDB);
        DBCursor dbCur = collection.find((DBObject)basicDB).skip(page_num * page_size).limit(page_size);
        JSONObject jsonObject = new JSONObject();
        JSONArray productList = new JSONArray();
        while (dbCur.hasNext()) {
            DBObject object = dbCur.next();
            Map map = object.toMap();
            Object id = map.get("_id");
            map.put("id", id.toString());
            map.remove("_id");
            productList.add((Object)map);
        }
        jsonObject.put("message", (Object)productList);
        return dataResponse.setStatus(Status.SUCCESS).setData(jsonObject).setCode("0");
    }
}

