/*
 * Decompiled with CFR 0.152.
 */
package kr.weitao.weitaokr.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.mongodb.BasicDBObject;
import com.mongodb.DBCollection;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kr.weitao.business.common.agent.DataAgent;
import kr.weitao.business.entity.Express;
import kr.weitao.business.entity.Logistics;
import kr.weitao.common.util.AliCDNUrlAuth;
import kr.weitao.common.util.JSONArraySortUtil;
import kr.weitao.common.util.StringUtils;
import kr.weitao.common.util.TimeUtils;
import kr.weitao.starter.model.DataRequest;
import kr.weitao.starter.model.DataResponse;
import kr.weitao.starter.model.Status;
import kr.weitao.weitaokr.service.KdniaoService;
import kr.weitao.weitaokr.service.LogisticsService;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bson.types.ObjectId;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Service;

@Service
public class LogisticsServiceImpl
implements LogisticsService {
    private static final Logger log = LogManager.getLogger(LogisticsServiceImpl.class);
    @Autowired
    MongoTemplate mongoTemplate;
    @Autowired
    KdniaoService kdniaoService;
    @Autowired
    AliCDNUrlAuth aliCDNUrlAuth;
    @Autowired
    DataAgent dataAgent;

    public DataResponse query(DataRequest dataRequest) {
        DBObject object;
        DataResponse dataResponse = new DataResponse();
        JSONObject data = dataRequest.getData();
        log.info("--logistics--" + data);
        String order_id = data.getString("order_id");
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"order_id").is((Object)order_id));
        List logisticsList = this.mongoTemplate.find(query, Logistics.class);
        HashMap<String, JSONArray> mapList = new HashMap<String, JSONArray>();
        for (Logistics logistics : logisticsList) {
            String logistics_code = logistics.getLogistics_code();
            String shipper_code = logistics.getShipper_code();
            JSONArray array = this.kdniaoService.queryOrderTraces(shipper_code, logistics_code);
            mapList.put(logistics_code, array);
        }
        DBCollection collection = this.mongoTemplate.getCollection("def_express");
        BasicDBObject dbObject = new BasicDBObject();
        dbObject.put((Object)"order_id", (Object)order_id);
        DBCursor cursor = collection.find((DBObject)dbObject);
        JSONArray Logistics2 = new JSONArray();
        while (cursor.hasNext()) {
            JSONArray arrays;
            object = cursor.next();
            Map map = object.toMap();
            Object id = map.get("_id");
            String logistics_name = String.valueOf(map.get("logistics_name"));
            String shipper_code = String.valueOf(map.get("shipper_code"));
            String logisticsCode = String.valueOf(map.get("logistics_code"));
            if (StringUtils.isNull(map.get("kuaidi100"))) {
                Query query1 = new Query();
                query1.addCriteria((CriteriaDefinition)Criteria.where((String)"logistics_name").is((Object)logistics_name));
                query1.addCriteria((CriteriaDefinition)Criteria.where((String)"shipper_code").is((Object)shipper_code));
                Express logistics = (Express)this.mongoTemplate.findOne(query1, Express.class);
                String kuaidi100 = "";
                if (null != logistics) {
                    kuaidi100 = StringUtils.checkString((String)logistics.getKuaidi100());
                }
                map.put("kuaidi100", kuaidi100);
            }
            JSONArray product = JSONArray.parseArray((String)map.get("productList").toString());
            JSONArray jsonArray = new JSONArray();
            for (int i = 0; i < product.size(); ++i) {
                JSONObject jsonObject1 = product.getJSONObject(i);
                JSONArray objects = jsonObject1.getJSONArray("product_image_url");
                if (objects == null) continue;
                JSONArray array = new JSONArray();
                for (int j = 0; j < objects.size(); ++j) {
                    JSONObject jsonObject2 = objects.getJSONObject(j);
                    String image_url = jsonObject2.getString("image_url");
                    String image = this.aliCDNUrlAuth.getAuthUrl(image_url);
                    jsonObject2.put("image_url", (Object)image);
                    array.add((Object)jsonObject2);
                }
                jsonObject1.put("product_image_url", (Object)array);
                jsonArray.add((Object)jsonObject1);
            }
            map.remove("_id");
            map.put("id", id.toString());
            if ((null == map.get("logistics_info") || JSONArray.parseArray((String)map.get("logistics_info").toString()).size() <= 0) && null != (arrays = (JSONArray)mapList.get(logisticsCode)) && arrays.size() > 0) {
                map.put("logistics_info", arrays);
            }
            map.put("productList", jsonArray);
            Logistics2.add((Object)map);
        }
        object = new JSONObject();
        object.put("message", (Object)Logistics2);
        return dataResponse.setData((JSONObject)object).setCode("0").setStatus(Status.SUCCESS);
    }

    public DataResponse syncJob(DataRequest request) {
        DataResponse dataResponse = new DataResponse();
        JSONObject data = request.getData();
        String id = data.getString("id");
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"queue_id").is((Object)id));
        BasicDBObject showKey = new BasicDBObject();
        showKey.put((Object)"logisticsList.logistics_code", (Object)"1");
        showKey.put((Object)"express_received_date", (Object)"1");
        showKey.put((Object)"_id", (Object)"1");
        BasicDBObject query1 = new BasicDBObject();
        query1.put((Object)"pay_status", (Object)"1");
        DBCursor dbCursor = null;
        try {
            dbCursor = this.mongoTemplate.getCollection("def_order").find((DBObject)query1, (DBObject)showKey);
        }
        catch (Exception e) {
            log.error("get brankroll flow by:" + query + " error:" + e.getLocalizedMessage(), (Throwable)e);
            return dataResponse.setStatus(Status.FAILED).setCode("-1").setMsg("\u67e5\u8be2\u5931\u8d25");
        }
        DBObject dbObject = null;
        String orderId = "";
        String express_received_date = "";
        while (dbCursor.hasNext()) {
            dbObject = dbCursor.next();
            orderId = dbObject.get("_id").toString();
            if (dbObject.get("express_received_date") != null) {
                express_received_date = dbObject.get("express_received_date").toString();
            }
            if (StringUtils.isNotNull((Object)express_received_date)) {
                log.debug("express_received_date is not null");
                continue;
            }
            data = new JSONObject();
            data.put("order_id", (Object)orderId);
            dataResponse = this.query(new DataRequest().setData(data));
            String now_express_received_date = "";
            if (!dataResponse.getCode().equals("0")) continue;
            log.debug(dataResponse.getData().toString());
            JSONObject result = dataResponse.getData();
            JSONArray resultArray = result.getJSONArray("message");
            if (resultArray == null) {
                log.info("query logistics message is null");
            }
            for (int i = 0; i < resultArray.size(); ++i) {
                boolean compareResult;
                result = resultArray.getJSONObject(i);
                if (StringUtils.isNull((Object)result.get((Object)"State"))) continue;
                String state = result.getString("State");
                JSONArray logistics_info = result.getJSONArray("logistics_info");
                if (logistics_info == null) continue;
                logistics_info = JSONArraySortUtil.sortDesc((JSONArray)logistics_info, (String)"AcceptTime");
                if (!"3".equals(state)) continue;
                if (i == 0) {
                    now_express_received_date = logistics_info.getJSONObject(0).getString("AcceptTime");
                }
                if (i <= 0 || !(compareResult = TimeUtils.compareDateTime((String)now_express_received_date, (String)(express_received_date = logistics_info.getJSONObject(0).getString("AcceptTime")), (SimpleDateFormat)TimeUtils.DATETIME_FORMAT_DATE))) continue;
                now_express_received_date = express_received_date;
            }
            if (!StringUtils.isNotNull((Object)now_express_received_date)) continue;
            BasicDBObject query_order = new BasicDBObject();
            query_order.put((Object)"_id", (Object)new ObjectId(orderId));
            BasicDBObject basicDBObject_ = new BasicDBObject();
            basicDBObject_.put((Object)"express_received_date", (Object)now_express_received_date);
            BasicDBObject update_ = new BasicDBObject("$set", (Object)basicDBObject_);
            this.mongoTemplate.getCollection("def_order").update((DBObject)query_order, (DBObject)update_);
        }
        return new DataResponse().setMsg("\u5904\u7406\u5b8c\u6210").setCode("0").setStatus(Status.SUCCESS);
    }
}

