/*
 * Decompiled with CFR 0.152.
 */
package kr.weitao.weitaokr.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.mongodb.BasicDBObject;
import com.mongodb.DBCollection;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import com.mongodb.WriteResult;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.security.MessageDigest;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kr.weitao.business.entity.Logistics;
import kr.weitao.business.entity.Order;
import kr.weitao.common.util.StringUtils;
import kr.weitao.common.util.TimeUtils;
import kr.weitao.starter.model.DataRequest;
import kr.weitao.starter.model.DataResponse;
import kr.weitao.starter.model.Status;
import kr.weitao.starter.util.mongodb.MongodbClient;
import kr.weitao.weitaokr.service.KdniaoService;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class KdniaoServiceImpl
implements KdniaoService {
    private static final Logger log = LogManager.getLogger(KdniaoServiceImpl.class);
    static final String LOG_COLLECTION = "log_logistics_tracing";
    static final String CHANNEL = "kdniao";
    @Value(value="${kdniao.api.EBusinessID}")
    private String EBusinessID = "1618268";
    @Value(value="${kdniao.api.AppKey}")
    private String AppKey = "a452a3ad-4aaa-44b9-8969-6da1102720e2";
    @Value(value="${kdniao.api.url.sub}")
    private String ReqURLSub = "http://api.kdniao.cc/api/dist";
    @Value(value="${kdniao.api.url.query}")
    private String ReqURLQuery = "http://api.kdniao.cc/Ebusiness/EbusinessOrderHandle.aspx";
    @Autowired
    MongodbClient mongodbClient;
    @Autowired
    MongoTemplate mongoTemplate;
    private static char[] base64EncodeChars = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '+', '/'};

    public DataResponse query(DataRequest dataRequest) {
        DBObject object;
        JSONObject data = dataRequest.getData();
        int page_num = data.getIntValue("page_num");
        int page_size = data.getIntValue("page_size");
        DataResponse dataResponse = new DataResponse();
        DBCollection dbCollection = this.mongodbClient.getMongoTemplate().getCollection("def_logistics");
        BasicDBObject basicDBObject = new BasicDBObject();
        DBCursor dbObjects = dbCollection.find((DBObject)basicDBObject).skip(page_num * page_size).limit(page_size);
        JSONArray jsonArray = new JSONArray();
        while (dbObjects.hasNext()) {
            object = dbObjects.next();
            Map map = object.toMap();
            map.remove("_id");
            jsonArray.add((Object)map);
        }
        object = new JSONObject();
        object.put("message", (Object)jsonArray);
        dataResponse.setData((JSONObject)object).setCode("0").setStatus(Status.SUCCESS);
        return dataResponse;
    }

    public DataResponse search(DataRequest dataRequest) {
        DBObject object;
        String name = dataRequest.getData().getString("logistics_name");
        DataResponse dataResponse = new DataResponse();
        DBCollection dbCollection = this.mongodbClient.getMongoTemplate().getCollection("def_logistics");
        BasicDBObject basicDBObject = new BasicDBObject();
        if (StringUtils.isNotNull((Object)name)) {
            basicDBObject.put((Object)"logistics_name", (Object)new BasicDBObject("$regex", (Object)name).append("$options", (Object)"i"));
        }
        DBCursor dbObjects = dbCollection.find((DBObject)basicDBObject);
        JSONArray jsonArray = new JSONArray();
        while (dbObjects.hasNext()) {
            object = dbObjects.next();
            Map map = object.toMap();
            map.remove("_id");
            jsonArray.add((Object)map);
        }
        object = new JSONObject();
        object.put("message", (Object)jsonArray);
        dataResponse.setData((JSONObject)object).setCode("0").setStatus(Status.SUCCESS);
        return dataResponse;
    }

    public boolean subOrderTraces(String shipperCode, String logisticCode, String orderCode) {
        String requestData = "{'OrderCode': '" + orderCode + "','ShipperCode':'" + shipperCode + "','LogisticCode':'" + logisticCode + "'}";
        JSONObject resultJSON = new JSONObject();
        resultJSON.put("Success", (Object)false);
        try {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("RequestData", KdniaoServiceImpl.urlEncoder((String)requestData, (String)"UTF-8"));
            params.put("EBusinessID", this.EBusinessID);
            params.put("RequestType", "8008");
            String dataSign = KdniaoServiceImpl.encrypt((String)requestData, (String)this.AppKey, (String)"UTF-8");
            params.put("DataSign", KdniaoServiceImpl.urlEncoder((String)dataSign, (String)"UTF-8"));
            params.put("DataType", "2");
            String result = KdniaoServiceImpl.sendPost((String)this.ReqURLSub, params);
            resultJSON = JSON.parseObject((String)result);
            log.info((Object)resultJSON);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return resultJSON.getBoolean("Success");
    }

    public static void main(String[] args) {
        String requestData = "";
        requestData = "{'ShipperCode':'SF','LogisticCode':'SF1017381362479','CustomerName':'1616'}";
        JSONObject resultJSON = new JSONObject();
        try {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("RequestData", KdniaoServiceImpl.urlEncoder((String)requestData, (String)"UTF-8"));
            params.put("EBusinessID", "1618268");
            params.put("RequestType", "8001");
            String dataSign = KdniaoServiceImpl.encrypt((String)requestData, (String)"d552188a-72a2-4f33-afb5-06781cf5f07d", (String)"UTF-8");
            params.put("DataSign", KdniaoServiceImpl.urlEncoder((String)dataSign, (String)"UTF-8"));
            params.put("DataType", "2");
            String result = KdniaoServiceImpl.sendPost((String)"http://api.kdniao.com/Ebusiness/EbusinessOrderHandle.aspx", params);
            resultJSON = JSON.parseObject((String)result);
            log.info((Object)resultJSON);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public JSONObject queryOrderTracesFromKdniao(String shipperCode, String logisticCode, String customerName) {
        String requestData = "";
        requestData = !"SF".equals(shipperCode) ? "{'ShipperCode':'" + shipperCode + "','LogisticCode':'" + logisticCode + "'}" : "{'ShipperCode':'" + shipperCode + "','LogisticCode':'" + logisticCode + "','CustomerName':'" + customerName + "'}";
        JSONObject resultJSON = new JSONObject();
        try {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("RequestData", KdniaoServiceImpl.urlEncoder((String)requestData, (String)"UTF-8"));
            params.put("EBusinessID", this.EBusinessID);
            params.put("RequestType", "8001");
            String dataSign = KdniaoServiceImpl.encrypt((String)requestData, (String)this.AppKey, (String)"UTF-8");
            params.put("DataSign", KdniaoServiceImpl.urlEncoder((String)dataSign, (String)"UTF-8"));
            params.put("DataType", "2");
            String result = KdniaoServiceImpl.sendPost((String)this.ReqURLQuery, params);
            resultJSON = JSON.parseObject((String)result);
            log.info((Object)resultJSON);
            if (resultJSON.getBoolean("Success").booleanValue()) {
                JSONObject updateJSON = new JSONObject();
                JSONArray tracesData = new JSONArray();
                tracesData.add((Object)resultJSON);
                updateJSON.put("Data", (Object)tracesData);
                this.updateOrderTraces(updateJSON);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return resultJSON;
    }

    public boolean updateOrderTraces(JSONObject traces) {
        JSONArray data = traces.getJSONArray("Data");
        Map tracesMap = (Map)JSON.parseObject((String)traces.toJSONString(), Map.class);
        log.info((Object)tracesMap);
        for (Object obj : data) {
            JSONObject traceItem = (JSONObject)obj;
            String shipperCode = traceItem.getString("ShipperCode");
            String logisticCode = traceItem.getString("LogisticCode");
            String state = traceItem.getString("State");
            HashMap<String, String> queryItem = new HashMap<String, String>();
            queryItem.put("ShipperCode", traceItem.getString("ShipperCode"));
            queryItem.put("LogisticCode", traceItem.getString("LogisticCode"));
            List resultList = this.mongodbClient.query("log_logistics_tracing", queryItem);
            Map newTrace = (Map)JSON.parseObject((String)traceItem.toJSONString(), Map.class);
            newTrace.put("channel", "kdniao");
            JSONArray jsonArray = traceItem.getJSONArray("Traces");
            if (resultList.size() < 1) {
                this.mongodbClient.insert("log_logistics_tracing", newTrace);
                continue;
            }
            this.mongodbClient.update("log_logistics_tracing", newTrace, queryItem);
            DBCollection dbCollection = this.mongodbClient.getMongoTemplate().getCollection("def_express");
            BasicDBObject query = new BasicDBObject();
            query.put((Object)"shipper_code", (Object)shipperCode);
            query.put((Object)"logistics_code", (Object)logisticCode);
            BasicDBObject update = new BasicDBObject();
            BasicDBObject basicDBObject = new BasicDBObject();
            basicDBObject.put((Object)"logistics_info", (Object)jsonArray);
            basicDBObject.put((Object)"state", (Object)state);
            update.put((Object)"$set", (Object)basicDBObject);
            dbCollection.update((DBObject)query, (DBObject)update);
            DBCursor dbObjects = dbCollection.find((DBObject)query);
            while (dbObjects.hasNext()) {
                while (dbObjects.hasNext()) {
                    DBObject object = dbObjects.next();
                    Map map = object.toMap();
                    String order_id = (String)map.get("order_id");
                    Query query1 = new Query();
                    query1.addCriteria((CriteriaDefinition)Criteria.where((String)"order_id").is((Object)order_id));
                    query1.addCriteria((CriteriaDefinition)Criteria.where((String)"state").ne((Object)"3"));
                    Update update1 = new Update();
                    update1.set("order_status", (Object)"2");
                    Logistics logistics = (Logistics)this.mongodbClient.getMongoTemplate().findOne(query1, Logistics.class);
                    if (null != logistics) continue;
                    Query querys = new Query();
                    querys.addCriteria((CriteriaDefinition)Criteria.where((String)"order_id").is((Object)order_id));
                }
            }
        }
        return true;
    }

    public JSONArray queryOrderTraces(String shipperCode, String logisticCode) {
        HashMap<String, String> queryItem = new HashMap<String, String>();
        queryItem.put("ShipperCode", shipperCode);
        queryItem.put("LogisticCode", logisticCode);
        String customerName = "1234";
        try {
            Query queryOrder = Query.query((CriteriaDefinition)Criteria.where((String)"logistics_code").is((Object)logisticCode).and("shipper_code").is((Object)shipperCode));
            Logistics logisticsOne = (Logistics)this.mongoTemplate.findOne(queryOrder, Logistics.class);
            Order order = (Order)this.mongoTemplate.findOne(Query.query((CriteriaDefinition)Criteria.where((String)"order_id").is((Object)logisticsOne.getOrder_id())), Order.class);
            customerName = order.getExpress_info().getJSONObject("address").getString("phone");
            customerName = customerName.substring(customerName.length() - 4);
        }
        catch (Exception queryOrder) {
            // empty catch block
        }
        List resultList = this.mongodbClient.query("log_logistics_tracing", queryItem);
        if (resultList.size() > 0) {
            Map result = (Map)resultList.get(0);
            String state = String.valueOf(result.get("State"));
            List tracesList = (List)result.get("Traces");
            if (StringUtils.isNull((Object)tracesList) || tracesList.size() == 0) {
                JSONArray tracesArr = (JSONArray)this.queryOrderTracesFromKdniao(shipperCode, logisticCode, customerName).get((Object)"Traces");
                return tracesArr;
            }
            try {
                if (!"3".equals(state)) {
                    JSONObject jsonObject = JSONObject.parseObject((String)JSON.toJSONString(tracesList.get(tracesList.size() - 1)));
                    log.info("--\u7269\u6d41----" + jsonObject);
                    if (jsonObject.containsKey((Object)"AcceptTime")) {
                        String AcceptTime = jsonObject.getString("AcceptTime");
                        String currentTime = TimeUtils.getCurrentTimeInString((SimpleDateFormat)TimeUtils.DATETIME_FORMAT_DATE);
                        int c = TimeUtils.calculateDateInDay((String)currentTime, (String)AcceptTime, (SimpleDateFormat)TimeUtils.DATETIME_FORMAT_DATE);
                        if (c > 1) {
                            JSONArray tracesArr = (JSONArray)this.queryOrderTracesFromKdniao(shipperCode, logisticCode, customerName).get((Object)"Traces");
                            return tracesArr;
                        }
                    }
                }
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
            DBCollection dbCollection = this.mongodbClient.getMongoTemplate().getCollection("def_express");
            BasicDBObject query = new BasicDBObject();
            query.put((Object)"shipper_code", (Object)shipperCode);
            query.put((Object)"logistics_code", (Object)logisticCode);
            BasicDBObject update = new BasicDBObject();
            BasicDBObject basicDBObject = new BasicDBObject();
            basicDBObject.put((Object)"logistics_info", (Object)tracesList);
            basicDBObject.put((Object)"state", (Object)state);
            update.put((Object)"$set", (Object)basicDBObject);
            WriteResult writeResult = dbCollection.updateMulti((DBObject)query, (DBObject)update);
            log.info("--def_express---" + writeResult.getN());
            DBCursor dbObjects = dbCollection.find((DBObject)query);
            while (dbObjects.hasNext()) {
                while (dbObjects.hasNext()) {
                    DBObject object = dbObjects.next();
                    Map map = object.toMap();
                    String order_id = (String)map.get("order_id");
                    Query query1 = new Query();
                    query1.addCriteria((CriteriaDefinition)Criteria.where((String)"order_id").is((Object)order_id));
                    query1.addCriteria((CriteriaDefinition)Criteria.where((String)"state").ne((Object)"3"));
                    Update update1 = new Update();
                    update1.set("order_status", (Object)"2");
                    Logistics logistics = (Logistics)this.mongodbClient.getMongoTemplate().findOne(query1, Logistics.class);
                    if (null != logistics) continue;
                    Query querys = new Query();
                    querys.addCriteria((CriteriaDefinition)Criteria.where((String)"order_id").is((Object)order_id));
                }
            }
            return JSONArray.parseArray((String)JSON.toJSONString((Object)tracesList));
        }
        JSONArray tracesArr = (JSONArray)this.queryOrderTracesFromKdniao(shipperCode, logisticCode, customerName).get((Object)"Traces");
        return tracesArr;
    }

    private static String MD5(String str, String charset) throws Exception {
        MessageDigest md = MessageDigest.getInstance("MD5");
        md.update(str.getBytes(charset));
        byte[] result = md.digest();
        StringBuffer sb = new StringBuffer(32);
        for (int i = 0; i < result.length; ++i) {
            int val = result[i] & 0xFF;
            if (val <= 15) {
                sb.append("0");
            }
            sb.append(Integer.toHexString(val));
        }
        return sb.toString().toLowerCase();
    }

    private static String base64(String str, String charset) throws UnsupportedEncodingException {
        String encoded = KdniaoServiceImpl.base64Encode((byte[])str.getBytes(charset));
        return encoded;
    }

    private static String urlEncoder(String str, String charset) throws UnsupportedEncodingException {
        String result = URLEncoder.encode(str, charset);
        return result;
    }

    private static String encrypt(String content, String keyValue, String charset) throws UnsupportedEncodingException, Exception {
        if (keyValue != null) {
            return KdniaoServiceImpl.base64((String)KdniaoServiceImpl.MD5((String)(content + keyValue), (String)charset), (String)charset);
        }
        return KdniaoServiceImpl.base64((String)KdniaoServiceImpl.MD5((String)content, (String)charset), (String)charset);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String sendPost(String url, Map<String, String> params) {
        OutputStreamWriter out = null;
        BufferedReader in = null;
        StringBuilder result = new StringBuilder();
        try {
            String line;
            URL realUrl = new URL(url);
            HttpURLConnection conn = (HttpURLConnection)realUrl.openConnection();
            conn.setDoOutput(true);
            conn.setDoInput(true);
            conn.setRequestMethod("POST");
            conn.setRequestProperty("accept", "*/*");
            conn.setRequestProperty("connection", "Keep-Alive");
            conn.setRequestProperty("user-agent", "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1;SV1)");
            conn.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
            conn.connect();
            out = new OutputStreamWriter(conn.getOutputStream(), "UTF-8");
            if (params != null) {
                StringBuilder param = new StringBuilder();
                for (Map.Entry<String, String> entry : params.entrySet()) {
                    if (param.length() > 0) {
                        param.append("&");
                    }
                    param.append(entry.getKey());
                    param.append("=");
                    param.append(entry.getValue());
                    log.debug(entry.getKey() + ":" + entry.getValue());
                }
                log.debug("param:" + param.toString());
                out.write(param.toString());
            }
            out.flush();
            in = new BufferedReader(new InputStreamReader(conn.getInputStream(), "UTF-8"));
            while ((line = in.readLine()) != null) {
                result.append(line);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        return result.toString();
    }

    public static String base64Encode(byte[] data) {
        StringBuffer sb = new StringBuffer();
        int len = data.length;
        int i = 0;
        while (i < len) {
            int b1 = data[i++] & 0xFF;
            if (i == len) {
                sb.append(base64EncodeChars[b1 >>> 2]);
                sb.append(base64EncodeChars[(b1 & 3) << 4]);
                sb.append("==");
                break;
            }
            int b2 = data[i++] & 0xFF;
            if (i == len) {
                sb.append(base64EncodeChars[b1 >>> 2]);
                sb.append(base64EncodeChars[(b1 & 3) << 4 | (b2 & 0xF0) >>> 4]);
                sb.append(base64EncodeChars[(b2 & 0xF) << 2]);
                sb.append("=");
                break;
            }
            int b3 = data[i++] & 0xFF;
            sb.append(base64EncodeChars[b1 >>> 2]);
            sb.append(base64EncodeChars[(b1 & 3) << 4 | (b2 & 0xF0) >>> 4]);
            sb.append(base64EncodeChars[(b2 & 0xF) << 2 | (b3 & 0xC0) >>> 6]);
            sb.append(base64EncodeChars[b3 & 0x3F]);
        }
        return sb.toString();
    }
}

