/*
 * Decompiled with CFR 0.152.
 */
package kr.weitao.weitaokr.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.mongodb.BasicDBList;
import com.mongodb.BasicDBObject;
import com.mongodb.DBCollection;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import com.mongodb.WriteResult;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import kr.weitao.common.util.StringUtils;
import kr.weitao.starter.util.mongodb.MongodbUtil;
import kr.weitao.weitaokr.service.JobService;
import kr.weitao.weitaokr.task.common.QueueItemEntity;
import kr.weitao.weitaokr.task.common.QueueParam;
import kr.weitao.weitaokr.task.common.ScheduleManger;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bson.types.ObjectId;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.stereotype.Service;

@Service
public class JobServiceImpl
implements JobService {
    private static final Logger log = LogManager.getLogger(JobServiceImpl.class);
    @Autowired
    private ScheduleManger scheduleManger;
    @Autowired
    MongoTemplate mongoTemplate;

    public int removeJob(JSONObject data) {
        if (data == null || data.isEmpty()) {
            return 0;
        }
        DBCollection collection = this.mongoTemplate.getCollection("def_queue_item");
        String _id = data.getString("id");
        String user_id = data.getString("user_id");
        if (StringUtils.isNotNull((Object)_id)) {
            QueueItemEntity qie = null;
            try {
                data.put("queue_id", (Object)_id);
                if (!data.containsKey((Object)"trigger_id")) {
                    data.put("trigger_id", (Object)_id.toString());
                }
                if (!data.containsKey((Object)"queue_item_id")) {
                    data.put("queue_item_id", (Object)_id.toString());
                }
                qie = (QueueItemEntity)JSONObject.parseObject((String)data.toJSONString(), QueueItemEntity.class);
                this.scheduleManger.removeJob(qie);
                BasicDBObject basicDB = new BasicDBObject();
                BasicDBList basicDBList1 = new BasicDBList();
                basicDBList1.add((Object)new BasicDBObject("queue_id", (Object)qie.getQueue_id()));
                basicDBList1.add((Object)new BasicDBObject("queue_item_id", (Object)qie.getQueue_item_id()));
                basicDB.put((Object)"$and", (Object)basicDBList1);
                WriteResult writeResult = collection.remove((DBObject)basicDB);
                log.info((Object)writeResult.getN());
            }
            catch (Exception e) {
                log.error("json string:" + data.toJSONString() + " to queueitementity obj error:" + e.getLocalizedMessage(), (Throwable)e);
            }
            return 0;
        }
        if (StringUtils.isNull((Object)user_id)) {
            return 0;
        }
        DBCursor dbCur = null;
        BasicDBObject mongoCondition = new BasicDBObject();
        BasicDBList condition_list = new BasicDBList();
        condition_list.add((Object)new BasicDBObject("is_active", (Object)"Y"));
        condition_list.add((Object)new BasicDBObject("user_id", (Object)user_id));
        mongoCondition.put((Object)"$and", (Object)condition_list);
        BasicDBObject projection = new BasicDBObject();
        projection.put((Object)"_id", (Object)"1");
        try {
            dbCur = collection.find((DBObject)mongoCondition, (DBObject)projection);
        }
        catch (Exception e) {
            log.error("get queue item from mongodb error:" + e.getLocalizedMessage(), (Throwable)e);
        }
        if (dbCur == null) {
            log.error("not find queue item from mongodb");
            return 0;
        }
        Object temp_id = null;
        DBObject object = null;
        QueueItemEntity qie = null;
        HashMap<String, String> map = new HashMap<String, String>();
        while (dbCur.hasNext()) {
            object = dbCur.next();
            if (map == null || !map.isEmpty()) continue;
            temp_id = map.get("_id");
            map.put("_id", temp_id.toString());
            map.put("queue_id", temp_id.toString());
            map.put("queue_item_id", temp_id.toString());
            map.put("trigger_id", temp_id.toString());
            try {
                qie = (QueueItemEntity)JSONObject.parseObject((String)data.toJSONString(), QueueItemEntity.class);
                this.scheduleManger.removeJob(qie);
            }
            catch (Exception e) {
                log.error("remove job list error:" + e.getLocalizedMessage(), (Throwable)e);
            }
        }
        return 0;
    }

    public int addJob(JSONObject data) {
        if (data == null || data.isEmpty()) {
            return -1;
        }
        log.debug("datas:" + data.toJSONString());
        ObjectId _id = null;
        _id = StringUtils.isNotNull((Object)data.get((Object)"_id")) ? new ObjectId(data.get((Object)"_id").toString()) : new ObjectId();
        QueueParam qp = new QueueParam();
        qp.set_id((Object)new ObjectId());
        qp.setName("_id");
        qp.setValue(_id.toString());
        qp.setQueue_item_id(_id.toString());
        data.put("queue_id", (Object)_id.toString());
        if (!data.containsKey((Object)"trigger_id")) {
            data.put("trigger_id", (Object)_id.toString());
        }
        if (!data.containsKey((Object)"queue_item_id")) {
            data.put("queue_item_id", (Object)_id.toString());
        }
        try {
            QueueItemEntity qie = (QueueItemEntity)JSONObject.parseObject((String)data.toJSONString(), QueueItemEntity.class);
            qie.set_id((Object)new ObjectId());
            this.mongoTemplate.save((Object)qie);
            ArrayList<QueueParam> paramList = new ArrayList<QueueParam>();
            paramList.add(qp);
            this.scheduleManger.addJob(qie, paramList);
        }
        catch (Exception e) {
            log.error(" error:" + e.getLocalizedMessage(), (Throwable)e);
        }
        return 0;
    }

    public int modify(JSONObject data) {
        ObjectId _id;
        String queue_id;
        if (data == null || data.isEmpty()) {
            return -1;
        }
        String queue_item_id = queue_id = data.getString("id");
        if (data.containsKey((Object)"queue_item_id")) {
            queue_item_id = data.getString("queue_item_id");
        }
        if (StringUtils.isNull((Object)(_id = new ObjectId(data.getString("id"))))) {
            return -1;
        }
        log.debug("mod data:" + data.toJSONString());
        BasicDBObject query_ma = new BasicDBObject();
        query_ma.put((Object)"queue_id", (Object)queue_id);
        query_ma.put((Object)"queue_item_id", (Object)queue_item_id);
        QueueItemEntity qie = new QueueItemEntity();
        DBCursor dbCur = this.mongoTemplate.getCollection("def_queue_item").find((DBObject)query_ma);
        while (dbCur.hasNext()) {
            DBObject object = dbCur.next();
            Map map = object.toMap();
            log.info("--map----" + map);
            qie = (QueueItemEntity)JSONObject.parseObject((String)JSON.toJSONString((Object)map), QueueItemEntity.class);
        }
        if (data.containsKey((Object)"recurrence")) {
            JSONObject recurrence = data.getJSONObject("recurrence");
            qie.setRecurrence(recurrence);
        }
        log.info("-qie---" + qie);
        QueueParam qp = new QueueParam();
        qp.set_id((Object)new ObjectId());
        qp.setName("_id");
        qp.setValue(_id.toString());
        qp.setQueue_item_id(_id.toString());
        data.put("queue_id", (Object)_id.toString());
        if (!data.containsKey((Object)"trigger_id")) {
            data.put("trigger_id", (Object)_id.toString());
        }
        if (!data.containsKey((Object)"queue_item_id")) {
            data.put("queue_item_id", (Object)_id.toString());
        }
        BasicDBObject update = MongodbUtil.checkMongoUpdate((JSONObject)data);
        BasicDBObject query = new BasicDBObject();
        query.put((Object)"queue_id", (Object)queue_id);
        query.put((Object)"queue_item_id", (Object)queue_item_id);
        log.info("update>>" + update + ">>>>>>>>>query>>>>>>>" + query);
        WriteResult writeResult = this.mongoTemplate.getCollection("def_queue_item").updateMulti((DBObject)query, (DBObject)update);
        try {
            ArrayList<QueueParam> paramList = new ArrayList<QueueParam>();
            paramList.add(qp);
            this.scheduleManger.modifyJob(qie, paramList);
        }
        catch (Exception e) {
            log.error(" error:" + e.getLocalizedMessage(), (Throwable)e);
        }
        return 0;
    }
}

