/*
 * Decompiled with CFR 0.152.
 */
package kr.weitao.weitaokr.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.mongodb.AggregationOutput;
import com.mongodb.BasicDBObject;
import com.mongodb.DBCollection;
import com.mongodb.DBObject;
import java.util.HashSet;
import java.util.LinkedHashMap;
import kr.weitao.business.entity.LogShare;
import kr.weitao.business.entity.Store;
import kr.weitao.business.entity.User;
import kr.weitao.business.entity.data.Material;
import kr.weitao.business.entity.data.Product;
import kr.weitao.common.util.AliCDNUrlAuth;
import kr.weitao.common.util.StringUtils;
import kr.weitao.starter.model.DataRequest;
import kr.weitao.starter.model.DataResponse;
import kr.weitao.starter.model.Status;
import kr.weitao.weitaokr.service.ExportService;
import kr.weitao.weitaokr.service.common.MongodbUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bson.types.ObjectId;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Service;

@Service
public class ExportServiceImpl
implements ExportService {
    private static final Logger log = LogManager.getLogger(ExportServiceImpl.class);
    @Autowired
    MongoTemplate mongoTemplate;
    @Autowired
    MongodbUtils mongodbUtils;
    @Autowired
    AliCDNUrlAuth aliCDNUrlAuth;

    public DataResponse exportShare(DataRequest dataRequest) {
        JSONObject data = dataRequest.getData();
        String begin_time = data.getString("begin_time");
        String end_time = data.getString("end_time");
        DataResponse dataResponse = new DataResponse();
        DBCollection collection = this.mongoTemplate.getCollection("log_share");
        BasicDBObject basicDBObject = new BasicDBObject();
        basicDBObject.put((Object)"user_id", (Object)new BasicDBObject("$regex", (Object)"^.{12,19}$"));
        basicDBObject.put((Object)"created_time", (Object)new BasicDBObject("$gte", (Object)begin_time).append("$lte", (Object)end_time));
        BasicDBObject match = new BasicDBObject();
        match.put((Object)"$match", (Object)basicDBObject);
        BasicDBObject group = new BasicDBObject();
        group.put((Object)"_id", (Object)"$user_id");
        group.put((Object)"count", (Object)new BasicDBObject("$sum", (Object)1));
        group.put((Object)"ids", (Object)new BasicDBObject("$addToSet", (Object)"$_id"));
        BasicDBObject groups = new BasicDBObject();
        groups.put((Object)"$group", (Object)group);
        JSONArray array = new JSONArray();
        AggregationOutput output_user = collection.aggregate((DBObject)match, new DBObject[]{groups});
        for (DBObject dbObject : output_user.results()) {
            BasicDBObject basicDBObject1 = (BasicDBObject)dbObject;
            String user_id = basicDBObject1.getString("_id");
            JSONArray jsonArray = JSONArray.parseArray((String)basicDBObject1.getString("ids"));
            JSONArray productList = new JSONArray();
            for (int i = 0; i < jsonArray.size(); ++i) {
                JSONObject object = new JSONObject();
                String s = jsonArray.get(i).toString();
                JSONObject a = JSONObject.parseObject((String)s);
                ObjectId id = new ObjectId(a.getString("$oid"));
                LogShare logShare = (LogShare)this.mongoTemplate.findOne(Query.query((CriteriaDefinition)Criteria.where((String)"_id").is((Object)id)), LogShare.class);
                String product_id = logShare.getProduct_id();
                if (StringUtils.isNull((Object)product_id)) {
                    String material_id = logShare.getMaterial_id();
                    Material material = (Material)this.mongoTemplate.findOne(Query.query((CriteriaDefinition)Criteria.where((String)"material_id").is((Object)material_id)), Material.class);
                    if (null == material) continue;
                    JSONArray image_url = material.getImage_url();
                    HashSet<String> strings = new HashSet<String>();
                    for (int j = 0; j < image_url.size(); ++j) {
                        JSONObject products = image_url.getJSONObject(j);
                        if (!products.containsKey((Object)"product_id") || !StringUtils.isNotNull((Object)products.getString("product_id")) || strings.contains(products.getString("product_id"))) continue;
                        strings.add(products.getString("product_id"));
                        Product product = (Product)this.mongoTemplate.findOne(Query.query((CriteriaDefinition)Criteria.where((String)"product_id").is((Object)product_id)), Product.class);
                        if (null == product) continue;
                        object.put("product_name", (Object)product.getProduct_name());
                        object.put("brand_name", (Object)product.getBrand_name());
                        object.put("product_id", (Object)product.getProduct_offline_id());
                        productList.add((Object)object);
                    }
                    continue;
                }
                Product product = (Product)this.mongoTemplate.findOne(Query.query((CriteriaDefinition)Criteria.where((String)"product_id").is((Object)product_id)), Product.class);
                if (null == product) continue;
                object.put("product_name", (Object)product.getProduct_name());
                object.put("brand_name", (Object)product.getBrand_name());
                object.put("product_id", (Object)product.getProduct_offline_id());
                productList.add((Object)object);
            }
            int counts = basicDBObject1.getInt("count");
            String user_name = "\u5458\u5de5";
            String store_name = "\u5e97\u94fa";
            JSONObject object = new JSONObject();
            User user = (User)this.mongoTemplate.findOne(Query.query((CriteriaDefinition)Criteria.where((String)"user_id").is((Object)user_id)), User.class);
            if (null != user) {
                user_name = user.getUser_name();
                String store_id = user.getStore_id();
                Store store = (Store)this.mongoTemplate.findOne(Query.query((CriteriaDefinition)Criteria.where((String)"store_id").is((Object)store_id)), Store.class);
                store_name = null != store ? store.getStore_name() : "\u529e\u516c\u5ba4";
            }
            object.put("user_name", (Object)user_name);
            object.put("user_id", (Object)user_id);
            object.put("store_name", (Object)store_name);
            object.put("counts", (Object)counts);
            object.put("product_items", (Object)productList);
            object.put("time", (Object)(begin_time + "~" + end_time));
            array.add((Object)object);
        }
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        map.put("\u59d3\u540d", "user_name");
        map.put("\u8eab\u4efd\u8bc1", "user_id");
        map.put("\u5e97\u94fa\u540d\u79f0", "store_name");
        map.put("\u6b21\u6570", "counts");
        map.put("\u5546\u54c1\u660e\u7ec6", "product_items");
        map.put("\u65f6\u95f4", "time");
        try {
            String url = this.mongodbUtils.exportFile(array, map, "shareLog");
            JSONObject result_item = new JSONObject();
            result_item.put("oss_url", (Object)url);
            JSONObject result_data = new JSONObject();
            result_data.put("message", (Object)result_item);
            dataResponse.setData(result_data).setStatus(Status.SUCCESS).setCode("0");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return dataResponse;
    }

    public DataResponse queryShare(DataRequest dataRequest) {
        JSONObject data = dataRequest.getData();
        String begin_time = data.getString("begin_time");
        String page_type = data.getString("page_type");
        String type = data.getString("type");
        String end_time = data.getString("end_time");
        int page_num = data.getIntValue("page_num");
        int page_size = data.getIntValue("page_size");
        DataResponse dataResponse = new DataResponse();
        DBCollection collection = this.mongoTemplate.getCollection("log_share");
        BasicDBObject basicDBObject = new BasicDBObject();
        basicDBObject.put((Object)"user_id", (Object)new BasicDBObject("$regex", (Object)"^.{12,19}$"));
        String userId = data.getString("user_id");
        if (StringUtils.isNotNull((Object)userId)) {
            basicDBObject.put((Object)"user_id", (Object)userId);
        }
        basicDBObject.put((Object)"created_time", (Object)new BasicDBObject("$gte", (Object)begin_time).append("$lte", (Object)end_time));
        BasicDBObject match = new BasicDBObject();
        match.put((Object)"$match", (Object)basicDBObject);
        BasicDBObject group = new BasicDBObject();
        BasicDBObject groupItem = new BasicDBObject();
        groupItem.put((Object)"user_id", (Object)"$user_id");
        groupItem.put((Object)"brand_name", (Object)"$brand_name");
        group.put((Object)"_id", (Object)groupItem);
        group.put((Object)"ids", (Object)new BasicDBObject("$addToSet", (Object)"$_id"));
        group.put((Object)"count", (Object)new BasicDBObject("$sum", (Object)1));
        BasicDBObject groups = new BasicDBObject();
        groups.put((Object)"$group", (Object)group);
        JSONArray array = new JSONArray();
        BasicDBObject basicSkip = new BasicDBObject("$skip", (Object)(page_num * page_size));
        BasicDBObject basicLimit = new BasicDBObject("$limit", (Object)page_size);
        AggregationOutput output_user = null;
        output_user = "data".equals(type) ? ("all".equals(page_type) ? collection.aggregate((DBObject)match, new DBObject[]{groups}) : collection.aggregate((DBObject)match, new DBObject[]{groups, basicSkip, basicLimit})) : collection.aggregate((DBObject)match, new DBObject[]{groups});
        int countss = MongodbUtils.iteratorToArray(output_user.results().iterator()).size();
        log.info("----count---" + countss);
        for (DBObject dbObject : output_user.results()) {
            BasicDBObject basicDBObject1 = (BasicDBObject)dbObject;
            String _id = basicDBObject1.getString("_id");
            JSONObject jsonObject = JSONObject.parseObject((String)_id);
            String user_id = jsonObject.getString("user_id");
            String brand_name = jsonObject.getString("brand_name");
            int counts = basicDBObject1.getInt("count");
            String user_name = "\u5458\u5de5";
            String store_name = "\u5e97\u94fa";
            JSONObject object_ = new JSONObject();
            User user = (User)this.mongoTemplate.findOne(Query.query((CriteriaDefinition)Criteria.where((String)"user_id").is((Object)user_id)), User.class);
            if (null != user) {
                user_name = user.getUser_name();
                String store_id = user.getStore_id();
                Store store = (Store)this.mongoTemplate.findOne(Query.query((CriteriaDefinition)Criteria.where((String)"store_id").is((Object)store_id)), Store.class);
                store_name = null != store ? store.getStore_name() : "\u529e\u516c\u5ba4";
            }
            object_.put("user_name", (Object)user_name);
            if (StringUtils.isNotNull((Object)brand_name)) {
                if ("less".equals(brand_name)) {
                    brand_name = "LESS";
                }
                if ("jnby".equals(brand_name)) {
                    brand_name = "JNBY";
                }
            } else {
                brand_name = "";
            }
            JSONArray jsonArray = JSONArray.parseArray((String)basicDBObject1.getString("ids"));
            JSONArray productList = new JSONArray();
            for (int i = 0; i < jsonArray.size(); ++i) {
                String s = jsonArray.get(i).toString();
                JSONObject a = JSONObject.parseObject((String)s);
                ObjectId id = new ObjectId(a.getString("$oid"));
                LogShare logShare = (LogShare)this.mongoTemplate.findOne(Query.query((CriteriaDefinition)Criteria.where((String)"_id").is((Object)id)), LogShare.class);
                String product_id = logShare.getProduct_id();
                String time = logShare.getCreated_time();
                if (StringUtils.isNull((Object)product_id)) {
                    JSONArray image_url;
                    String material_id = logShare.getMaterial_id();
                    Material material = (Material)this.mongoTemplate.findOne(Query.query((CriteriaDefinition)Criteria.where((String)"material_id").is((Object)material_id)), Material.class);
                    if (null == material || null == (image_url = material.getImage_url())) continue;
                    HashSet<String> strings = new HashSet<String>();
                    for (int j = 0; j < image_url.size(); ++j) {
                        JSONObject products = image_url.getJSONObject(j);
                        if (!products.containsKey((Object)"product_id") || !StringUtils.isNotNull((Object)products.getString("product_id")) || strings.contains(products.getString("product_id"))) continue;
                        strings.add(products.getString("product_id"));
                        Product product = (Product)this.mongoTemplate.findOne(Query.query((CriteriaDefinition)Criteria.where((String)"product_id").is((Object)products.getString("product_id"))), Product.class);
                        if (null == product) continue;
                        String url = product.getProduct_url().getJSONObject(0).getString("url");
                        String[] strings1 = url.split("prodId=");
                        JSONObject object = new JSONObject();
                        object.put("product_name", (Object)product.getProduct_name());
                        object.put("brand_name", (Object)product.getBrand_name());
                        object.put("product_offline_id", (Object)product.getProduct_offline_id());
                        object.put("product_id", (Object)product.getProduct_id());
                        object.put("material_id", (Object)material_id);
                        object.put("time", (Object)time);
                        if (strings1.length > 1) {
                            object.put("xcx_product_id", (Object)strings1[1]);
                        }
                        productList.add((Object)object);
                    }
                    continue;
                }
                Product product = (Product)this.mongoTemplate.findOne(Query.query((CriteriaDefinition)Criteria.where((String)"product_id").is((Object)product_id)), Product.class);
                if (null == product) continue;
                String url = product.getProduct_url().getJSONObject(0).getString("url");
                String[] strings1 = url.split("prodId=");
                JSONObject object = new JSONObject();
                object.put("product_name", (Object)product.getProduct_name());
                object.put("brand_name", (Object)product.getBrand_name());
                object.put("product_offline_id", (Object)product.getProduct_offline_id());
                object.put("product_id", (Object)product.getProduct_id());
                object.put("time", (Object)time);
                if (strings1.length > 1) {
                    object.put("xcx_product_id", (Object)strings1[1]);
                }
                productList.add((Object)object);
            }
            object_.put("brand_name", (Object)brand_name);
            object_.put("user_id", (Object)jsonObject.getString("user_id"));
            object_.put("store_name", (Object)store_name);
            object_.put("counts", (Object)counts);
            object_.put("product_items", (Object)productList);
            object_.put("time", (Object)(begin_time + "~" + end_time));
            array.add((Object)object_);
        }
        try {
            JSONObject result_item = new JSONObject();
            JSONObject result_data = new JSONObject();
            if ("data".equals(type)) {
                if ("all".equals(page_type)) {
                    result_data.put("list", (Object)array);
                } else {
                    int count = MongodbUtils.iteratorToArray(collection.aggregate((DBObject)match, new DBObject[]{groups}).results().iterator()).size();
                    int pages = 0;
                    pages = count % page_size == 0 ? count / page_size : count / page_size + 1;
                    result_data.put("list", (Object)array);
                    result_data.put("count", (Object)(count + ""));
                    result_data.put("page_num", (Object)(page_num + ""));
                    result_data.put("page_size", (Object)(page_size + ""));
                    result_data.put("pages", (Object)(pages + ""));
                }
                dataResponse.setData(result_data).setStatus(Status.SUCCESS).setCode("0").setId(dataRequest.getId());
            } else {
                LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
                map.put("\u59d3\u540d", "user_name");
                map.put("\u54c1\u724c", "brand_name");
                map.put("\u8eab\u4efd\u8bc1", "user_id");
                map.put("\u5e97\u94fa\u540d\u79f0", "store_name");
                map.put("\u6b21\u6570", "counts");
                map.put("\u5546\u54c1\u660e\u7ec6", "product_items");
                map.put("\u65f6\u95f4", "time");
                String url = this.mongodbUtils.exportFile(array, map, "shareLog");
                url = this.aliCDNUrlAuth.getAuthURLA(url);
                result_item.put("oss_url", (Object)url);
                result_data.put("message", (Object)result_item);
                dataResponse.setData(result_data).setStatus(Status.SUCCESS).setCode("0").setId(dataRequest.getId());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return dataResponse;
    }

    public DataResponse queryShareLook(DataRequest dataRequest) {
        JSONObject data = dataRequest.getData();
        String begin_time = data.getString("begin_time");
        String type = data.getString("type");
        String page_type = data.getString("page_type");
        String end_time = data.getString("end_time");
        int page_num = data.getIntValue("page_num");
        int page_size = data.getIntValue("page_size");
        DataResponse dataResponse = new DataResponse();
        DBCollection collection = this.mongoTemplate.getCollection("log_qrcode_scan");
        BasicDBObject basicDBObject = new BasicDBObject();
        basicDBObject.put((Object)"user_id", (Object)new BasicDBObject("$regex", (Object)"^.{12,19}$"));
        String userId = data.getString("user_id");
        if (StringUtils.isNotNull((Object)userId)) {
            basicDBObject.put((Object)"user_id", (Object)userId);
        }
        basicDBObject.put((Object)"created_time", (Object)new BasicDBObject("$gte", (Object)begin_time).append("$lte", (Object)end_time));
        BasicDBObject match = new BasicDBObject();
        match.put((Object)"$match", (Object)basicDBObject);
        BasicDBObject group = new BasicDBObject();
        BasicDBObject groupItem = new BasicDBObject();
        groupItem.put((Object)"user_id", (Object)"$user_id");
        groupItem.put((Object)"brand_name", (Object)"$param.brand_name");
        group.put((Object)"_id", (Object)groupItem);
        group.put((Object)"count", (Object)new BasicDBObject("$sum", (Object)1));
        group.put((Object)"open_ids", (Object)new BasicDBObject("$addToSet", (Object)"$open_id"));
        BasicDBObject groups = new BasicDBObject();
        groups.put((Object)"$group", (Object)group);
        JSONArray array = new JSONArray();
        BasicDBObject basicSkip = new BasicDBObject("$skip", (Object)(page_num * page_size));
        BasicDBObject basicLimit = new BasicDBObject("$limit", (Object)page_size);
        AggregationOutput output_user = null;
        output_user = "data".equals(type) ? ("all".equals(page_type) ? collection.aggregate((DBObject)match, new DBObject[]{groups}) : collection.aggregate((DBObject)match, new DBObject[]{groups, basicSkip, basicLimit})) : collection.aggregate((DBObject)match, new DBObject[]{groups});
        for (DBObject dbObject : output_user.results()) {
            BasicDBObject basicDBObject1 = (BasicDBObject)dbObject;
            String _id = basicDBObject1.getString("_id");
            JSONArray jsonArray = JSONArray.parseArray((String)basicDBObject1.getString("open_ids"));
            JSONObject jsonObject = JSONObject.parseObject((String)_id);
            String user_id = jsonObject.getString("user_id");
            String brand_name = jsonObject.getString("brand_name");
            int counts = basicDBObject1.getInt("count");
            String user_name = "\u5458\u5de5";
            String store_name = "\u5e97\u94fa";
            JSONObject object = new JSONObject();
            User user = (User)this.mongoTemplate.findOne(Query.query((CriteriaDefinition)Criteria.where((String)"user_id").is((Object)user_id)), User.class);
            if (null != user) {
                user_name = user.getUser_name();
                String store_id = user.getStore_id();
                Store store = (Store)this.mongoTemplate.findOne(Query.query((CriteriaDefinition)Criteria.where((String)"store_id").is((Object)store_id)), Store.class);
                store_name = null != store ? store.getStore_name() : "\u529e\u516c\u5ba4";
            }
            object.put("user_name", (Object)user_name);
            if (StringUtils.isNotNull((Object)brand_name)) {
                if ("less".equals(brand_name)) {
                    brand_name = "LESS";
                }
                if ("jnby".equals(brand_name)) {
                    brand_name = "JNBY";
                }
            } else {
                brand_name = "";
            }
            object.put("brand_name", (Object)brand_name);
            object.put("user_id", (Object)jsonObject.getString("user_id"));
            object.put("store_name", (Object)store_name);
            object.put("counts", (Object)counts);
            object.put("number", (Object)jsonArray.size());
            object.put("time", (Object)(begin_time + "~" + end_time));
            array.add((Object)object);
        }
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        map.put("\u59d3\u540d", "user_name");
        map.put("\u54c1\u724c", "brand_name");
        map.put("\u8eab\u4efd\u8bc1", "user_id");
        map.put("\u5e97\u94fa\u540d\u79f0", "store_name");
        map.put("\u4eba\u6570", "number");
        map.put("\u6b21\u6570", "counts");
        map.put("\u65f6\u95f4", "time");
        try {
            JSONObject result_data = new JSONObject();
            JSONObject result_item = new JSONObject();
            if ("data".equals(type)) {
                if ("all".equals(page_type)) {
                    result_data.put("list", (Object)array);
                } else {
                    int count = MongodbUtils.iteratorToArray(collection.aggregate((DBObject)match, new DBObject[]{groups}).results().iterator()).size();
                    int pages = 0;
                    pages = count % page_size == 0 ? count / page_size : count / page_size + 1;
                    result_data.put("list", (Object)array);
                    result_data.put("count", (Object)(count + ""));
                    result_data.put("page_num", (Object)(page_num + ""));
                    result_data.put("page_size", (Object)(page_size + ""));
                    result_data.put("pages", (Object)(pages + ""));
                }
                dataResponse.setData(result_data).setStatus(Status.SUCCESS).setCode("0").setId(dataRequest.getId());
            } else {
                String url = this.mongodbUtils.exportFile(array, map, "shareBrowse");
                url = this.aliCDNUrlAuth.getAuthURLA(url);
                result_item.put("oss_url", (Object)url);
                result_data.put("message", (Object)result_item);
                dataResponse.setData(result_data).setStatus(Status.SUCCESS).setCode("0").setId(dataRequest.getId());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return dataResponse;
    }

    public DataResponse exportCreateMaterial(DataRequest dataRequest) {
        JSONObject data = dataRequest.getData();
        String begin_time = data.getString("begin_time");
        String end_time = data.getString("end_time");
        int page_num = data.getIntValue("page_num");
        int page_size = data.getIntValue("page_size");
        DataResponse dataResponse = new DataResponse();
        DBCollection collection = this.mongoTemplate.getCollection("def_material");
        BasicDBObject basicDBObject = new BasicDBObject();
        basicDBObject.put((Object)"user_id", (Object)new BasicDBObject("$regex", (Object)"^.{12,19}$"));
        basicDBObject.put((Object)"material_offline_id", null);
        basicDBObject.put((Object)"created_date", (Object)new BasicDBObject("$gte", (Object)begin_time).append("$lte", (Object)end_time));
        BasicDBObject match = new BasicDBObject();
        match.put((Object)"$match", (Object)basicDBObject);
        BasicDBObject group = new BasicDBObject();
        group.put((Object)"_id", (Object)"$user_id");
        group.put((Object)"count", (Object)new BasicDBObject("$sum", (Object)1));
        group.put((Object)"ids", (Object)new BasicDBObject("$addToSet", (Object)"$material_id"));
        BasicDBObject groups = new BasicDBObject();
        groups.put((Object)"$group", (Object)group);
        JSONArray array = new JSONArray();
        AggregationOutput output_user = collection.aggregate((DBObject)match, new DBObject[]{groups});
        for (DBObject dbObject : output_user.results()) {
            BasicDBObject basicDBObject1 = (BasicDBObject)dbObject;
            String user_id = basicDBObject1.getString("_id");
            JSONArray jsonArray = JSONArray.parseArray((String)basicDBObject1.getString("ids"));
            JSONArray productList = new JSONArray();
            for (int i = 0; i < jsonArray.size(); ++i) {
                JSONObject object = new JSONObject();
                String material_id = jsonArray.getString(i);
                Material material = (Material)this.mongoTemplate.findOne(Query.query((CriteriaDefinition)Criteria.where((String)"material_id").is((Object)material_id)), Material.class);
                if (null == material) continue;
                JSONArray image_url = material.getImage_url();
                HashSet<String> strings = new HashSet<String>();
                for (int j = 0; j < image_url.size(); ++j) {
                    JSONObject products = image_url.getJSONObject(j);
                    if (!products.containsKey((Object)"product_id") || !StringUtils.isNotNull((Object)products.getString("product_id"))) continue;
                    String product_id = products.getString("product_id");
                    if (strings.contains(products.getString("product_id"))) continue;
                    strings.add(products.getString("product_id"));
                    Product product = (Product)this.mongoTemplate.findOne(Query.query((CriteriaDefinition)Criteria.where((String)"product_id").is((Object)product_id)), Product.class);
                    if (null == product) continue;
                    object.put("product_name", (Object)product.getProduct_name());
                    object.put("brand_name", (Object)product.getBrand_name());
                    object.put("product_id", (Object)product.getProduct_offline_id());
                    productList.add((Object)object);
                }
            }
            int counts = basicDBObject1.getInt("count");
            String user_name = "\u5458\u5de5";
            String store_name = "\u5e97\u94fa";
            JSONObject object = new JSONObject();
            User user = (User)this.mongoTemplate.findOne(Query.query((CriteriaDefinition)Criteria.where((String)"user_id").is((Object)user_id)), User.class);
            if (null != user) {
                user_name = user.getUser_name();
                String store_id = user.getStore_id();
                Store store = (Store)this.mongoTemplate.findOne(Query.query((CriteriaDefinition)Criteria.where((String)"store_id").is((Object)store_id)), Store.class);
                store_name = null != store ? store.getStore_name() : "\u529e\u516c\u5ba4";
            }
            object.put("user_name", (Object)user_name);
            object.put("user_id", (Object)user_id);
            object.put("store_name", (Object)store_name);
            object.put("counts", (Object)counts);
            object.put("product_items", (Object)productList);
            object.put("time", (Object)(begin_time + "~" + end_time));
            array.add((Object)object);
        }
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        map.put("\u59d3\u540d", "user_name");
        map.put("\u8eab\u4efd\u8bc1", "user_id");
        map.put("\u5e97\u94fa\u540d\u79f0", "store_name");
        map.put("\u6b21\u6570", "counts");
        map.put("\u5546\u54c1\u660e\u7ec6", "product_items");
        map.put("\u65f6\u95f4", "time");
        try {
            String url = this.mongodbUtils.exportFile(array, map, "createMaterial");
            JSONObject result_item = new JSONObject();
            result_item.put("oss_url", (Object)url);
            JSONObject result_data = new JSONObject();
            result_data.put("message", (Object)result_item);
            dataResponse.setData(result_data).setStatus(Status.SUCCESS).setCode("0");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return dataResponse;
    }

    public DataResponse queryCreateMaterial(DataRequest dataRequest) {
        JSONObject data = dataRequest.getData();
        String begin_time = data.getString("begin_time");
        String page_type = data.getString("page_type");
        String end_time = data.getString("end_time");
        int page_num = data.getIntValue("page_num");
        int page_size = data.getIntValue("page_size");
        String type = data.getString("type");
        DataResponse dataResponse = new DataResponse();
        DBCollection collection = this.mongoTemplate.getCollection("def_material");
        BasicDBObject basicDBObject = new BasicDBObject();
        basicDBObject.put((Object)"user_id", (Object)new BasicDBObject("$regex", (Object)"^.{12,19}$"));
        String userId = data.getString("user_id");
        if (StringUtils.isNotNull((Object)userId)) {
            basicDBObject.put((Object)"user_id", (Object)userId);
        }
        basicDBObject.put((Object)"material_offline_id", null);
        basicDBObject.put((Object)"created_date", (Object)new BasicDBObject("$gte", (Object)begin_time).append("$lte", (Object)end_time));
        BasicDBObject match = new BasicDBObject();
        match.put((Object)"$match", (Object)basicDBObject);
        BasicDBObject group = new BasicDBObject();
        BasicDBObject groupItem = new BasicDBObject();
        groupItem.put((Object)"user_id", (Object)"$user_id");
        groupItem.put((Object)"brand_name", (Object)"$image_url.brand_name");
        group.put((Object)"_id", (Object)groupItem);
        group.put((Object)"count", (Object)new BasicDBObject("$sum", (Object)1));
        group.put((Object)"ids", (Object)new BasicDBObject("$addToSet", (Object)"$material_id"));
        BasicDBObject groups = new BasicDBObject();
        groups.put((Object)"$group", (Object)group);
        JSONArray array = new JSONArray();
        BasicDBObject basicSkip = new BasicDBObject("$skip", (Object)(page_num * page_size));
        BasicDBObject basicLimit = new BasicDBObject("$limit", (Object)page_size);
        AggregationOutput output_user = null;
        output_user = "data".equals(type) ? ("all".equals(page_type) ? collection.aggregate((DBObject)match, new DBObject[]{groups}) : collection.aggregate((DBObject)match, new DBObject[]{groups, basicSkip, basicLimit})) : collection.aggregate((DBObject)match, new DBObject[]{groups});
        for (DBObject dbObject : output_user.results()) {
            BasicDBObject basicDBObject1 = (BasicDBObject)dbObject;
            String _id = basicDBObject1.getString("_id");
            JSONObject jsonObject = JSONObject.parseObject((String)_id);
            String user_id = jsonObject.getString("user_id");
            JSONArray jsonArray = JSONArray.parseArray((String)basicDBObject1.getString("ids"));
            JSONArray productList = new JSONArray();
            for (int i = 0; i < jsonArray.size(); ++i) {
                String material_id = jsonArray.getString(i);
                Material material = (Material)this.mongoTemplate.findOne(Query.query((CriteriaDefinition)Criteria.where((String)"material_id").is((Object)material_id)), Material.class);
                if (null == material) continue;
                String time = material.getCreated_date();
                JSONArray image_url = material.getImage_url();
                if (null == image_url) continue;
                HashSet<String> strings = new HashSet<String>();
                for (int j = 0; j < image_url.size(); ++j) {
                    JSONObject products = image_url.getJSONObject(j);
                    if (!products.containsKey((Object)"product_id") || !StringUtils.isNotNull((Object)products.getString("product_id"))) continue;
                    String product_id = products.getString("product_id");
                    if (strings.contains(products.getString("product_id"))) continue;
                    strings.add(products.getString("product_id"));
                    Product product = (Product)this.mongoTemplate.findOne(Query.query((CriteriaDefinition)Criteria.where((String)"product_id").is((Object)product_id)), Product.class);
                    if (null == product) continue;
                    String url = product.getProduct_url().getJSONObject(0).getString("url");
                    String[] strings1 = url.split("prodId=");
                    JSONObject object = new JSONObject();
                    object.put("product_name", (Object)product.getProduct_name());
                    object.put("brand_name", (Object)product.getBrand_name());
                    object.put("product_id", (Object)product.getProduct_id());
                    object.put("product_offline_id", (Object)product.getProduct_offline_id());
                    object.put("material_id", (Object)material_id);
                    object.put("time", (Object)time);
                    if (strings1.length > 1) {
                        object.put("xcx_product_id", (Object)strings1[1]);
                    }
                    productList.add((Object)object);
                }
            }
            JSONArray array1 = jsonObject.getJSONArray("brand_name");
            String brand_name = "";
            if (null != array1 && array1.size() > 0) {
                brand_name = jsonObject.getJSONArray("brand_name").getString(0);
            }
            int counts = basicDBObject1.getInt("count");
            String user_name = "\u5458\u5de5";
            String store_name = "\u5e97\u94fa";
            JSONObject object = new JSONObject();
            User user = (User)this.mongoTemplate.findOne(Query.query((CriteriaDefinition)Criteria.where((String)"user_id").is((Object)user_id)), User.class);
            if (null != user) {
                user_name = user.getUser_name();
                String store_id = user.getStore_id();
                Store store = (Store)this.mongoTemplate.findOne(Query.query((CriteriaDefinition)Criteria.where((String)"store_id").is((Object)store_id)), Store.class);
                store_name = null != store ? store.getStore_name() : "\u529e\u516c\u5ba4";
            }
            object.put("user_name", (Object)user_name);
            if ("less".equals(brand_name)) {
                brand_name = "LESS";
            }
            if ("jnby".equals(brand_name)) {
                brand_name = "JNBY";
            }
            object.put("brand_name", (Object)brand_name);
            object.put("user_id", (Object)user_id);
            object.put("store_name", (Object)store_name);
            object.put("counts", (Object)counts);
            object.put("product_items", (Object)productList);
            object.put("time", (Object)(begin_time + "~" + end_time));
            array.add((Object)object);
        }
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        map.put("\u59d3\u540d", "user_name");
        map.put("\u54c1\u724c", "brand_name");
        map.put("\u8eab\u4efd\u8bc1", "user_id");
        map.put("\u5e97\u94fa\u540d\u79f0", "store_name");
        map.put("\u6b21\u6570", "counts");
        map.put("\u5546\u54c1\u660e\u7ec6", "product_items");
        map.put("\u65f6\u95f4", "time");
        try {
            JSONObject result_item = new JSONObject();
            JSONObject result_data = new JSONObject();
            if ("data".equals(type)) {
                if ("all".equals(page_type)) {
                    result_data.put("list", (Object)array);
                } else {
                    int count = MongodbUtils.iteratorToArray(collection.aggregate((DBObject)match, new DBObject[]{groups}).results().iterator()).size();
                    int pages = 0;
                    pages = count % page_size == 0 ? count / page_size : count / page_size + 1;
                    result_data.put("list", (Object)array);
                    result_data.put("count", (Object)(count + ""));
                    result_data.put("page_num", (Object)(page_num + ""));
                    result_data.put("page_size", (Object)(page_size + ""));
                    result_data.put("pages", (Object)(pages + ""));
                }
                dataResponse.setData(result_data).setStatus(Status.SUCCESS).setCode("0").setId(dataRequest.getId());
            } else {
                String url = this.mongodbUtils.exportFile(array, map, "createMaterial");
                url = this.aliCDNUrlAuth.getAuthURLA(url);
                result_item.put("oss_url", (Object)url);
                result_data.put("message", (Object)result_item);
                dataResponse.setData(result_data).setStatus(Status.SUCCESS).setCode("0").setId(dataRequest.getId());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return dataResponse;
    }
}

