/*
 * Decompiled with CFR 0.152.
 */
package kr.weitao.weitaokr.service.common;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import java.util.Map;
import kr.weitao.common.util.StringUtils;
import kr.weitao.starter.util.redis.RedisClient;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.stereotype.Component;

@Component
public class UserRedisUtils {
    private static final Logger log = LogManager.getLogger(UserRedisUtils.class);
    @Autowired
    RedisClient redis_client;
    @Autowired
    MongoTemplate mongo_template;

    public JSONObject getUser(String user_id, boolean is_refresh) {
        JSONObject user_jo = new JSONObject();
        if (StringUtils.isNull((Object)user_id)) {
            return user_jo;
        }
        String user_str = null;
        String redis_user = "user_" + user_id;
        if (this.redis_client.exists(redis_user) && !is_refresh && StringUtils.isNotNull((Object)(user_str = this.redis_client.getValueOps().getValueString(redis_user)))) {
            try {
                user_jo = JSONObject.parseObject((String)user_str);
            }
            catch (Exception e) {
                log.error("redis user string to jsonobject error:" + e.getLocalizedMessage(), (Throwable)e);
            }
        }
        if (user_jo.isEmpty()) {
            BasicDBObject user_query = new BasicDBObject("user_id", (Object)user_id);
            DBObject db_bject = null;
            try {
                db_bject = this.mongo_template.getCollection("def_user").findOne((DBObject)user_query);
            }
            catch (Exception e) {
                log.error("get user by query:" + user_query + " error:" + e.getLocalizedMessage(), (Throwable)e);
            }
            if (db_bject == null) {
                log.error("not find user by query:" + user_query);
                return user_jo;
            }
            Object _id = db_bject.get("_id");
            Map map = db_bject.toMap();
            map.remove("_id");
            map.remove("_id");
            map.put("id", _id.toString());
            user_str = JSON.toJSONString((Object)map);
            user_jo = JSONObject.parseObject((String)user_str);
            if (!user_jo.isEmpty()) {
                this.redis_client.getValueOps().setValueString(redis_user, user_str);
            }
        }
        return user_jo;
    }
}

