/*
 * Decompiled with CFR 0.152.
 */
package kr.weitao.weitaokr.service;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.PostConstruct;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Element;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.cache.ehcache.EhCacheCacheManager;
import org.springframework.stereotype.Service;

@Service
public class CacheManagerService {
    @Qualifier(value="appEhCacheCacheManager")
    @Autowired
    public EhCacheCacheManager ehCacheManager;
    private CacheManager cacheManager;

    @PostConstruct
    public void init() {
        this.cacheManager = this.ehCacheManager.getCacheManager();
    }

    public String[] getCacheNames() {
        return this.cacheManager.getCacheNames();
    }

    public Ehcache getEhcache(String name) {
        return this.cacheManager.getEhcache(name);
    }

    public List getEhcacheKeys(String name) {
        return this.getEhcache(name).getKeys();
    }

    public Element getElements(String name, String key) {
        Ehcache cache = this.getEhcache(name);
        if (cache == null) {
            return null;
        }
        return cache.getQuiet((Serializable)((Object)key));
    }

    public List<Ehcache> getEhCaches() {
        String[] cacheNames = this.getCacheNames();
        ArrayList<Ehcache> list = new ArrayList<Ehcache>();
        for (String cacheName : cacheNames) {
            list.add(this.cacheManager.getEhcache(cacheName));
        }
        return list;
    }
}

