/*
 * Decompiled with CFR 0.152.
 */
package kr.weitao.weitaokr.filter;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.annotation.WebFilter;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import kr.weitao.common.util.MD5Util;
import kr.weitao.common.util.StringUtils;
import kr.weitao.starter.model.DataResponse;
import kr.weitao.starter.model.Status;
import kr.weitao.weitaokr.BodyReaderHttpServletRequestWrapper;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@WebFilter(urlPatterns={"/*"}, filterName="myFilter")
public class MyFilter
implements Filter {
    private static final Logger log = LogManager.getLogger(MyFilter.class);
    protected static List<Pattern> patterns = new ArrayList();

    public void init(FilterConfig filterConfig) throws ServletException {
        Pattern pattern = Pattern.compile("/swagger.+");
        patterns.add(pattern);
        pattern = Pattern.compile("/login");
        patterns.add(pattern);
        pattern = Pattern.compile("/express/updateOrderTrace");
        patterns.add(pattern);
        pattern = Pattern.compile("/webjars.+");
        patterns.add(pattern);
        pattern = Pattern.compile("/v2.+");
        patterns.add(pattern);
        pattern = Pattern.compile(".*css.*");
        patterns.add(pattern);
        pattern = Pattern.compile(".*html.*");
        patterns.add(pattern);
        pattern = Pattern.compile(".*js.*");
        patterns.add(pattern);
        pattern = Pattern.compile(".*png.*");
        patterns.add(pattern);
        pattern = Pattern.compile(".*txt.*");
        patterns.add(pattern);
        pattern = Pattern.compile(".*ttf.*");
        patterns.add(pattern);
        pattern = Pattern.compile(".*woff.*");
        patterns.add(pattern);
        pattern = Pattern.compile("/null.*");
        patterns.add(pattern);
        pattern = Pattern.compile("/bus/refresh");
        patterns.add(pattern);
        pattern = Pattern.compile("/refresh");
        patterns.add(pattern);
        pattern = Pattern.compile("/wechat.+");
        patterns.add(pattern);
        pattern = Pattern.compile("/s.+");
        patterns.add(pattern);
        pattern = Pattern.compile("/sale/queryCorpSale/.+");
        patterns.add(pattern);
        pattern = Pattern.compile("/web.+");
        patterns.add(pattern);
        pattern = Pattern.compile("/oss.+");
        patterns.add(pattern);
        pattern = Pattern.compile("/payCallback/.+");
        patterns.add(pattern);
        pattern = Pattern.compile("/order/getUrl");
        patterns.add(pattern);
        pattern = Pattern.compile("/message/miniChatToUser");
        patterns.add(pattern);
        pattern = Pattern.compile("/health/check");
        patterns.add(pattern);
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain chain) throws IOException, ServletException {
        DataResponse webDataResponse = new DataResponse();
        BodyReaderHttpServletRequestWrapper requestWrapper = new BodyReaderHttpServletRequestWrapper((HttpServletRequest)servletRequest);
        HttpServletRequest httpRequest = (HttpServletRequest)servletRequest;
        HttpServletResponse httpResponse = (HttpServletResponse)servletResponse;
        StringBuilder sb = new StringBuilder();
        sb.append("\nip: " + StringUtils.getIpAddress((HttpServletRequest)httpRequest, (String)"127.0.0.1") + "\n");
        sb.append("\u8def\u5f84: " + httpRequest.getRequestURL() + "\n");
        try {
            sb.append("contenttype:" + servletRequest.getContentType() + "\n");
        }
        catch (Exception e) {
            log.error("get content type error:" + e.getLocalizedMessage(), (Throwable)e);
        }
        sb.append("method: " + httpRequest.getMethod() + "\n");
        httpResponse.setCharacterEncoding("utf-8");
        httpResponse.setContentType("application/json; charset=utf-8");
        String body_str = requestWrapper.getBody();
        log.info("post param:" + sb.toString() + body_str);
        log.info("get param:" + httpRequest.getQueryString());
        if (StringUtils.isNotNull((Object)body_str) && body_str.startsWith("<xml")) {
            chain.doFilter((ServletRequest)requestWrapper, (ServletResponse)httpResponse);
            return;
        }
        String url = httpRequest.getRequestURI().substring(httpRequest.getContextPath().length());
        if (url.startsWith("/") && url.length() > 1) {
            url = url.substring(0);
        }
        if (this.isInclude(url)) {
            chain.doFilter((ServletRequest)requestWrapper, (ServletResponse)httpResponse);
        } else {
            JSONObject jsonObject = JSON.parseObject((String)body_str);
            if (null == jsonObject) {
                webDataResponse.setCode("-1").setId(String.valueOf(httpRequest.getAttribute("id"))).setMsg("\u8bf7\u6c42\u53c2\u6570\u4e3a\u7a7a").setStatus(Status.FAILED);
                httpResponse.getWriter().print(webDataResponse.toJSONObject());
            } else if (!jsonObject.containsKey((Object)"access_key")) {
                webDataResponse.setCode("-1").setId(String.valueOf(httpRequest.getAttribute("id"))).setMsg("access_key\u4e0d\u5b58\u5728").setStatus(Status.FAILED);
                httpResponse.getWriter().print(webDataResponse.toJSONObject());
            } else if (!jsonObject.containsKey((Object)"timestamp")) {
                webDataResponse.setCode("-1").setId(String.valueOf(httpRequest.getAttribute("id"))).setMsg("timestamp\u4e0d\u5b58\u5728").setStatus(Status.FAILED);
                httpResponse.getWriter().print(webDataResponse.toJSONObject());
            } else if (!jsonObject.containsKey((Object)"sign")) {
                webDataResponse.setCode("-1").setId(String.valueOf(httpRequest.getAttribute("id"))).setMsg("sign\u4e0d\u5b58\u5728").setStatus(Status.FAILED);
                httpResponse.getWriter().print(webDataResponse.toJSONObject());
            } else {
                String timestamp = jsonObject.getString("timestamp");
                String access_key = jsonObject.getString("access_key");
                String sign = null == jsonObject.getString("sign") ? "" : jsonObject.getString("sign");
                String secret = "weitao";
                String sign_new = MD5Util.getMD5Str32((String)(access_key + secret + timestamp)).toUpperCase();
                if (!sign.toUpperCase().equals(sign_new)) {
                    chain.doFilter((ServletRequest)requestWrapper, servletResponse);
                } else {
                    chain.doFilter((ServletRequest)requestWrapper, servletResponse);
                }
            }
        }
    }

    public void destroy() {
    }

    private boolean isInclude(String url) {
        for (Pattern pattern : patterns) {
            Matcher matcher = pattern.matcher(url);
            if (!matcher.matches()) continue;
            return true;
        }
        return false;
    }
}

